# 本章简介 [[本章简介]]

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

正如你在 [第一章](/course/chapter1) ，中看到的那样，Transformers 模型通常规模庞大。包含数以百万计到数千万计数十亿的参数，训练和部署这些模型是一项复杂的任务。再者，新模型的推出几乎日新月异，而每种模型都有其独特的实现方式，尝试全部模型绝非易事。

🤗 Transformers 库应运而生，就是为了解决这个问题。它的目标是提供一个统一的 API 接口，通过它可以加载、训练和保存任何 Transformer 模型。该库的主要特点有：
- **易于使用**：仅需两行代码，就能下载、加载并使用先进的 NLP 模型进行推理。
- **灵活**：在本质上，所有的模型都是简单的 PyTorch nn.Module 或 TensorFlow tf.keras.Model 类，并可像在各自的机器学习（ML）框架中处理其他模型一样处理它们。
- **简单**：该库几乎没有进行任何抽象化。🤗 Transformers 库一个核心概念是“全在一个文件中”：模型的前向传播完全在一个文件中定义，这使得代码本身易于理解和修改。

最后一个特性使🤗 Transformers 与其他 ML 库截然不同。模型并非建立在跨越多个代码文件共享的模块上；相反，每一个模型都有自己的层次结构。除了使模型更加容易接受和更容易理解，这还允许你轻松地在一个模型上实验，而且不影响其他模型。

本章将从一个端到端（从输入端到输出端）的示例开始，在该示例中，我们一起使用模型和 tokenizer 来复刻 [第一章](/course/chapter1) 中看到的 `pipeline()` 函数。接下来，我们将讨论 `Model` API：我们将深入研究 `Model` 类和 `Config` 类，并向你展示如何加载模型，以及它如何将输入处理为输出。

然后我们来看看 `tokenizer` API，它是 `pipeline()` 函数的另一个重要组成部分。在 `pipeline()` 中 `Tokenizer` 负责第一步和最后一步的处理，将文本转换到神经网络的输入，以及在需要时将其转换回文本。最后，我们将向你展示如何处理将多个句子整理为一个 batch 发送给模型，然后我们将更深入地研究 `tokenizer()` 函数。

<Tip>
⚠️ 为了充分利用 Model Hub 和🤗 Transformers 提供的所有功能，我们建议你<a href="https://huggingface.co/join">创建一个账户</a>。
</Tip>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter2/1.mdx" />