# 章末小测试 [[章末小测验]]

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

让我们测试一下你在本章所学的知识！

### 1.往Hub 上传模型有什么限制？

<Question
	choices={[
		{
			text: "模型需要来自🤗 Transformers 库。",
			explain: "虽然 Hugging Face Hub 支持 🤗 Transformers 库中的模型，但是其他的库的模型也可以上传到 Hub！"
		},
		{
			text: "所有与🤗 Transformers 库接口类似的模型。",
			explain: "将模型上传到 Hugging Face Hub 时，没有对接口有限制。"
		},
		{
			text: "没有限制。",
			explain: "对！在将模型上传到 Hub 时没有限制。",
            correct: true
		},
        {
			text: "在某种程度上与 NLP 相关的模型。",
			explain: "对模型应用的领域没有要求！"
		}
	]}
/>

### 2．如何管理 Hub 上的模型？
<Question
	choices={[
		{
			text: "通过 GCP 帐户。",
			explain: "不对！"
		},
		{
			text: "通过点对点分发。",
			explain: "不对！"
		},
		{
			text: "通过 git 和 git-lfs。",
			explain: "正确！Hub 上的模型就是简单的 Git 仓库，并使用 `git-lfs` 处理大型文件。",
            correct: true
		}
	]}
/>

### 3．你能使用 Hugging Face Hub 网页接口做什么？
<Question
	choices={[
		{
			text: "Fork 现有的存储库。",
			explain: "在 Hugging Face Hub 上无法 Fork 存储库。"
		},
		{
			text: "创建一个新的模型库。",
			explain: "没错！不过，但你能做的不止这些。",
            correct: true
		},
		{
			text: "管理和编辑文件。",
			explain: "正确！不过，但这不是唯一正确的答案。",
            correct: true
		},
        {
			text: "上传文件。",
			explain: "对！但还有更多可以做的。",
            correct: true
		},
        {
			text: "看看不同版本的差异。",
			explain: "没错！不过，这并不是你能做的全部。",
            correct: true
		}
	]}
/>

### 4．什么是模型卡片？
<Question
	choices={[
		{
			text: "模型的粗略描述，因此不如模型和 tokenizer 文件重要。",
			explain: "这确实是对模型的描述，但它是一个重要的部分：如果它不完整或缺失，模型的实用性将大幅降低。"
		},
		{
			text: "一种确保可复现性、可重用性和公平性的方法。",
			explain: "正确！在模型卡片中共享正确的信息将帮助用户利用你的模型，并了解其局限性和偏见。",
            correct: true
		},
		{
			text: "一个 Python 文件，可以运行它来检索有关模型的信息。",
			explain: "模型卡片是简单的 Markdown 文件。"
		}
	]}
/>

### 5．哪些🤗 Transformers 库的对象可以直接通过 `push_to_hub()` 分享到 Hub？
{#if fw === 'pt'}
<Question
	choices={[
		{
			text: " tokenizer ",
			explain: "正确！所有 tokenizer 都有 `push_to_hub` 方法，使用该方法将把 tokenizer 的全部文件（词汇表、 tokenizer 的架构等）推送到给定的存储库。不过，这不是唯一正确的答案！",
            correct: true
		},
		{
			text: "模型的 Config 对象",
			explain: "对！所有模型的 Config 对象都有 `push_to_hub` 方法，使用这个方法可以将它们推送到给定的存储库。你还有其他的答案吗？",
            correct: true
		},
		{
			text: "Model 类",
			explain: "正确！所有的 Model 类都有 `push_to_hub` 方法，使用它会将它们及其配置文件推送到给定的存储库。不过，还有其他的正确答案",
            correct: true
		},
        {
			text: "Trainer 类",
			explain: "没错 —— `Trainer` 也实现了 `push_to_hub` 方法，并且使用它可以将模型、配置、 tokenizer 和模型卡片上传到指定的仓库。试试其他答案！",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: " tokenizer ",
			explain: "正确！所有 tokenizer 都有 `push_to_hub` 方法，使用该方法将把所有 tokenizer 文件（词汇表、 tokenizer 的架构等）推送到给定的存储库。不过，这不是唯一正确的答案！",
            correct: true
		},
		{
			text: "模型的 Config 对象",
			explain: "对！所有模型的 Config 对象都有 `push_to_hub` 方法，使用这个方法可以将它们推送到给定的存储库。你还有其他能共享的吗？",
            correct: true
		},
		{
			text: "Model 类",
			explain: "正确！所有Model 类都有 `push_to_hub` 方法，使用它会将它们及其配置文件推送到给定的存储库。不过，还有其他可以分享到hub。",
            correct: true
		},
		{
			text: "所有以上的对象都可以通过专用的回调方法共享到 hub",
			explain: "正确 —— 在训练期间， `PushToHubCallback` 会定期将所有这些对象发送到 hub。",
            correct: true
		}
	]}
/>
{/if}

### 6．当使用 `push_to_hub()` 方法或 CLI 工具时，第一步是什么？
<Question
	choices={[
		{
			text: "在浏览器中登录网站。",
			explain: "在浏览器中登录网站这对你的本地上使用 `push_to_hub()` 方法或 CLI 工具没有帮助。"
		},
		{
			text: "在终端中运行'huggingface-cli login'。",
			explain: "正确——这将下载并缓存你的个人令牌。",
            correct: true
		},
		{
			text: "在 Notebook 中运行'notebook_login ()'。",
			explain: "正确——这将显示一个小部件，让你进行身份验证。",
            correct: true
		},
	]}
/>

### 7．你正在使用一个模型和一个 tokenizer ——如何将它们上传到 Hub？

<Question
	choices={[
		{
			text: "通过直接在模型和 tokenizer 上调用 push_to_hub 方法。",
			explain: "正确！",
            correct: true
		},
		{
			text: "在 Python 运行时中，使用 `huggingface_hub` 中的方法进行封装。",
			explain: "模型和 tokenizer 已经使用 `huggingface_hub` 封装过了：不需要额外的封装！"
		},
		{
			text: "将它们保存到磁盘并调用 `transformers-cli upload-model` ",
			explain: "命令 `upload-model` 不存在。"
		}
	]}
/>

### 8．你可以使用 `Repository` 类执行哪些 git 操作？
<Question
	choices={[
		{
			text: "提交（commit）",
			explain: "正确， `git_commit()` 方法就是为此而存在的。",
            correct: true
		},
		{
			text: "拉取（pull）",
			explain: "这就是 `git_pull()` 方法的功能。",
            correct: true
		},
		{
			text: "推送（push）",
			explain: "方法 `git_push()` 可以做到这一点。",
            correct: true
		},
		{
			text: "合并（merge）",
			explain: "不，这个操作在这个 API 中是无法实现的。"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter4/6.mdx" />