# 与他人分享演示 [[与他人分享演示]]


<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section4.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section4.ipynb"},
]} />

现在你已经构建了一个演示，你可能希望将其分享给你的同事或者朋友一起体验一下。Gradio 演示可以通过两种方式进行分享：使用 **临时的共享链接** 或者 **在 Spaces 上永久托管**。

我们将稍后快速介绍这两种方法。但在分享演示之前，你可能需要完善它 💅。

### 打磨你的 Gradio 演示：[[打磨你的 Gradio 演示:]]

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview.png" alt="Overview of a gradio interface"/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview-dark.png" alt="Overview of a gradio interface"/>
</div>

为了使演示使用起来更清晰， `Interface` 类支持一些可选参数：
    - `title` ：你可以给你的演示创建一个标题，它将显示在输入和输出组件的上方。
    - `description` ：你可以为界面提供描述（以文本、Markdown 或 HTML 形式），显示在输入和输出组件的上方和标题下方。
    - `article` ：你还可以编写扩展的文章（以文本、Markdown 或 HTML 形式）来解释界面。如果提供，它会出现在输入和输出组件的下方。
    - `theme` ：如果不喜欢默认颜色？你可以将主题可以设置为 `default` 、 `huggingface` 、 `grass` 、 `peach` 之一。同时你还可以添加 `dark-` 前缀，例如 `dark-peach` 用于深色主题（或者仅使用 `dark` 表示默认的深色主题）。
    - `examples` ：为了让你的演示更易于使用，你可以为函数提供一些示例输入。它们出现在 UI 组件下方，点击后可以自动填充到输入和输出。示例的格式应该是多层的列表，外层列表包含每个示例，每个内层的列表包含与每个输入组件对应的输入。
    - `live` ：如果你想使你的演示“实时”反馈，即每次输入更改时自动重新运行模型，你可以设置 `live=True` 。这对运行比较快的模型很有意义（我们将在本节末尾看到一个示例）

完善上述选项后，我们就得到了一个更完整的界面。运行以下代码，你可以与 Rick 和 Morty 进行对话：

```py
title = "Ask Rick a Question"
description = """
The bot was trained to answer questions based on Rick and Morty dialogues. Ask Rick anything!
<img src="https://huggingface.co/spaces/course-demos/Rick_and_Morty_QA/resolve/main/rick.png" width=200px>
"""

article = "Check out [the original Rick and Morty Bot](https://huggingface.co/spaces/kingabzpro/Rick_and_Morty_Bot) that this demo is based off of."

gr.Interface(
    fn=predict,
    inputs="textbox",
    outputs="text",
    title=title,
    description=description,
    article=article,
    examples=[["What are you doing?"], ["Where should we time travel to?"]],
).launch()
```

使用上面的选项，我们最终得到了一个更完整的界面。试试下面的界面：

<iframe src="https://course-demos-Rick-and-Morty-QA.hf.space" frameBorder="0" height="800" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

### 使用临时链接分享你的演示 [[使用临时链接分享你的演示]]

现在我们已经有了机器学习模型的工作演示，接下来将学习如何轻松地通过链接将演示共享给其他人。 
通过在 `launch()` 方法中设置 `share=True` 可以就轻松地公开共享接口：

```python
gr.Interface(classify_image, "image", "label").launch(share=True)
```

运行上面的代码会生成一个公开的、可共享的链接，你可以将其发送给任何人！得到此链接的用户可以在浏览器中试用该模型，时间长达 72 小时，时间长达 72 小时。因为处理发生在运行代码的设备上（设备需保持开启），所以无须打包任何依赖项。如果你使用 Google Colab 笔记本工作，则默认会自动创建共享链接。它通常看起来像这样：**XXXXX.gradio.app**。虽然链接是通过 Gradio 链接提供的，但 Gradio 只是提供了一个本地服务器的代理，不会存储通过接口发送的任何数据。

但是请记住，这些链接是可公开访问的，这意味着任何人都可以使用你的模型进行预测！因此，请确保不要使用你编写的函数公开任何敏感信息，也不要允许其中的代码对你的设备进行任何重要更改。如果设置 `share=False` （默认值就是False），则仅创建本地链接。

### 在 Hugging Face Spaces 上托管你的演示 [[在 Hugging Face Spaces 上托管你的演示]]

可以传递给同事的共享链接很酷，但是如何在互联网上永久托管你的演示并使其具有自己的“space”呢？

Hugging Face Spaces 提供了在互联网上永久托管你的 Gradio 模型的基础设施， 并且 **完全免费** ！你可以将你创建 Space 推送到（公共或私有）仓库，在其中，你的 Gradio 界面代码需要存储在一个 `app.py` 文件中。 请 [阅读分步教程](https://huggingface.co/blog/gradio-spaces) 开始使用 Hugging Face Spaces ，或观看下面的示例视频。

<Youtube id="LS9Y2wDVI0k" />

## ✏️ 让我们实现它！[[✏️ 让我们实现它!]]

现在，让我们使用到目前为止我们在各节中学到的知识，尝试创建我们在 [本章第一节](/course/chapter9/1) 中看到的草图识别演示。我们会在界面中添加一些自定义配置并设置 `share=True` 以创建一个可以与其他人共享的链接。

首先，我们可以从 [class_names.txt](https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/class_names.txt) 加载标签，并从 [pytorch_model.bin](https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/pytorch_model.bin) 加载预训练的 pytorch 模型。通过点击链接并点击文件预览左上角的下载来下载这些文件。然后使用下面的代码加载模型并创建一个 `predict()` 函数：
```py
from pathlib import Path
import torch
import gradio as gr
from torch import nn

LABELS = Path("class_names.txt").read_text().splitlines()

model = nn.Sequential(
    nn.Conv2d(1, 32, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Conv2d(32, 64, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Conv2d(64, 128, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Flatten(),
    nn.Linear(1152, 256),
    nn.ReLU(),
    nn.Linear(256, len(LABELS)),
)
state_dict = torch.load("pytorch_model.bin", map_location="cpu")
model.load_state_dict(state_dict, strict=False)
model.eval()


def predict(im):
    x = torch.tensor(im, dtype=torch.float32).unsqueeze(0).unsqueeze(0) / 255.0
    with torch.no_grad():
        out = model(x)
    probabilities = torch.nn.functional.softmax(out[0], dim=0)
    values, indices = torch.topk(probabilities, 5)
    return {LABELS[i]: v.item() for i, v in zip(indices, values)}
```

现在我们有了一个 `predict()` 函数。下一步是设置并启动我们的 gradio 界面：

```py
interface = gr.Interface(
    predict,
    inputs="sketchpad",
    outputs="label",
    theme="huggingface",
    title="Sketch Recognition",
    description="Who wants to play Pictionary? Draw a common object like a shovel or a laptop, and the algorithm will guess in real time!",
    article="<p style='text-align: center'>Sketch Recognition | Demo Model</p>",
    live=True,
)
interface.launch(share=True)
```

<iframe src="https://course-demos-Sketch-Recognition.hf.space" frameBorder="0" height="650" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>


注意 `Interface` 中设置了 `live=True` 参数，这意味着每当有人在画板上绘制时，草图演示都会实时进行预测（无需点击提交按钮！）。

此外，我们还在 `launch()` 方法中设置了 `share=True` 参数。这将创建一个公共链接，你可以发送给任何人！当你发送此链接时，对方可以尝试草图识别模型。重申一下，你还可以在 Hugging Face Spaces 上托管模型，这也是本教程中我们在网页上展示演示的方式。

接下来，我们将学习将 Gradio 与 Hugging Face 生态系统结合的其他用法！

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter9/4.mdx" />