import{s as Wt,a as at,n as Lt,o as Rt}from"../chunks/scheduler.cc52f4b9.js";import{S as Qt,i as St,e as i,s as a,c as y,h as Vt,a as p,d as l,b as n,f as ue,g as m,j as o,k as r,l as Nt,m as s,n as d,t as w,o as T,p as j}from"../chunks/index.9480bb2b.js";import{C as Xt,H as pe,E as Yt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.52103c90.js";import{C as nt}from"../chunks/CodeBlock.c5404643.js";import{D as Pt}from"../chunks/DocNotebookDropdown.ea74f0e0.js";function zt(it){let J,Me,oe,ce,f,ye,h,me,U,de,b,pt="在本節中，我們將仔細研究 <code>Interface</code> 類，並瞭解用於創建其的主要參數。",we,I,Te,C,ot="您會注意到 <code>Interface</code> 類有 3 個必需參數：",je,v,rt="<code>Interface(fn, inputs, outputs, ...)</code>",Je,g,ut="這些參數是：",fe,k,Mt="<li><code>fn</code>: 由 Gradio 接口包裝的預測函數。 該函數可以接受一個或多個參數並返回一個或多個值</li> <li><code>inputs</code>: 輸入組件類型。 Gradio 提供了許多預構建的組件，例如<code>&quot;image&quot;</code> 或<code>&quot;mic&quot;</code>。</li> <li><code>outputs</code>: 輸出組件類型。 同樣，Gradio 提供了許多預構建的組件，例如 <code>“圖像”</code>或“標籤”`。</li>",he,$,ct='有關組件的完整列表，<a href="https://gradio.app/docs" rel="nofollow">請參閱 Gradio 文檔</a>。 每個預構建的組件都可以通過實例化該組件對應的類來定製。',Ue,x,yt=`例如，正如我們在 <a href="/course/chapter9/2">上一節</a> 中看到的，您可以傳入一個 <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> 組件來創建一個包含 7 行和一個標籤的文本框，而不是將 <code>&quot;textbox&quot;</code> 傳遞給 <code>inputs</code> 參數。
讓我們看另一個例子，這次是一個 <code>Audio</code> 組件。`,be,A,Ie,G,mt=`如前所述，Gradio 提供了許多不同的輸入和輸出。
因此，讓我們構建一個適用於音頻的“接口”。`,Ce,B,dt="在這個例子中，我們將構建一個音頻到音頻的函數，它需要一個音頻文件並簡單地反轉它。",ve,Z,wt="我們將使用 <code>Audio</code> 組件作為輸入。 使用 <code>Audio</code> 組件時，您可以指定希望音頻的 <code>source</code> 是用戶上傳的文件還是用戶錄製聲音的麥克風。 在這種情況下，讓我們將其設置為“麥克風”。 只是為了好玩，我們會在我們的“音頻”中添加一個標籤，上面寫著“在這裡說話……”。",ge,_,Tt="此外，我們希望將音頻作為 numpy 數組接收，以便我們可以輕鬆地“反轉”它。 所以我們將 <code>&quot;type&quot;</code> 設置為 <code>&quot;numpy&quot;</code>，它會傳遞輸入data 作為 (<code>sample_rate</code>, <code>data</code>) 的元組進入我們的函數。",ke,q,jt="我們還將使用 <code>Audio</code> 輸出組件，它可以自動將具有采樣率和 numpy 數據數組的元組渲染為可播放的音頻文件。 在這種情況下，我們不需要進行任何自定義，因此我們將使用字符串快捷方式“audio”。",$e,E,xe,H,Jt=`上面的代碼會產生一個類似下面的界面（如果你的瀏覽器沒有
詢問您的麥克風權限， <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in  a separate tab</a>.)`,Ae,u,ft,Ge,W,ht="您現在應該能夠錄製自己的聲音並聽到自己在反向說話 - 聽起來好怪👻!",Be,L,Ze,R,Ut="假設我們有一個更復雜的函數，有多個輸入和輸出。在下面的示例中，我們有一個接受下拉索引、滑塊值和數字的函數，並返回一個音調的音頻樣本。",_e,Q,bt="看看我們如何傳遞輸入和輸出組件列表，看看你能不能跟上正在發生的事情。",qe,S,It="這裡的關鍵是當你通過時：",Ee,V,Ct="<li>輸入組件列表，每個組件依次對應一個參數。</li> <li>輸出組件列表，每個組件對應一個返回值。</li>",He,N,vt="下面的代碼片段顯示了三個輸入組件如何與 <code>generate_tone()</code> 函數的三個參數對齊：",We,X,Le,M,gt,Re,Y,Qe,P,kt=`到目前為止，我們已經使用了<code>launch()</code>方法來啟動界面，但是我們
還沒有真正討論過它的作用。`,Se,z,$t="默認情況下，<code>launch()</code> 方法將在 Web 服務器中啟動演示正在本地運行。 如果您在 Jupyter 或 Colab 筆記本中運行代碼，那麼Gradio 會將演示 GUI 嵌入到筆記本中，以便您輕鬆使用它。",Ve,F,xt="您可以通過不同的參數自定義 <code>launch()</code> 的行為：",Ne,D,At="<li><code>inline</code> - whether to display the interface inline on Python notebooks.</li> <li><code>inbrowser</code> - whether to automatically launch the interface in a new tab on the default browser.</li> <li><code>share</code> - whether to create a publicly shareable link from your computer for the interface. Kind of like a Google Drive link!</li>",Xe,K,Gt="我們將在下一節中更詳細地介紹 <code>share</code> 參數！",Ye,O,Pe,ee,Bt=`讓我們構建一個界面，讓您演示 <strong>speech-recognition</strong> 模型。
為了讓它變得有趣，我們將接受 <em>or</em> 麥克風輸入或上傳的文件。`,ze,te,Zt='像往常一樣，我們將使用 🤗 Transformers 中的 <code>pipeline()</code> 函數加載我們的語音識別模型。如果您需要快速複習，您可以返回 <a href="/course/chapter1/3">第 1 章中的那個部分</a>。 接下來，我們將實現一個 <code>transcribe_audio()</code> 函數來處理音頻並返回轉錄。 最後，我們將把這個函數包裝在一個 <code>Interface</code> 中，其中 <code>Audio</code> 組件用於輸入，只有文本用於輸出。 總而言之，此應用程序的代碼如下：',Fe,le,De,se,_t='如果您的瀏覽器沒有要求您提供麥克風權限，<a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in a separate tab</a>.',Ke,c,qt,Oe,ae,Et=`就是這樣！ 您現在可以使用此界面來轉錄音頻。 注意這裡
通過將 <code>optional</code> 參數作為 <code>True</code> 傳遞，我們允許用戶
提供麥克風或音頻文件（或兩者都不提供，但這會返回錯誤消息）。`,et,ne,Ht="繼續看看如何與他人分享您的界面！",tt,ie,lt,re,st;return f=new Xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new pe({props:{title:"瞭解接口類",local:"瞭解接口類",headingTag:"h1"}}),U=new Pt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"}]}}),I=new pe({props:{title:"如何創建接口",local:"如何創建接口",headingTag:"h2"}}),A=new pe({props:{title:"一個帶音頻的簡單示例",local:"一個帶音頻的簡單示例",headingTag:"h2"}}),E=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),L=new pe({props:{title:"處理多個輸入和輸出",local:"處理多個輸入和輸出",headingTag:"h2"}}),X=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new pe({props:{title:"launch() 方法",local:"launch-方法",headingTag:"h3"}}),O=new pe({props:{title:"✏️ 讓我們應用它！",local:"-讓我們應用它",headingTag:"h2"}}),le=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),ie=new Yt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter9/3.mdx"}}),{c(){J=i("meta"),Me=a(),oe=i("p"),ce=a(),y(f.$$.fragment),ye=a(),y(h.$$.fragment),me=a(),y(U.$$.fragment),de=a(),b=i("p"),b.innerHTML=pt,we=a(),y(I.$$.fragment),Te=a(),C=i("p"),C.innerHTML=ot,je=a(),v=i("p"),v.innerHTML=rt,Je=a(),g=i("p"),g.textContent=ut,fe=a(),k=i("ul"),k.innerHTML=Mt,he=a(),$=i("p"),$.innerHTML=ct,Ue=a(),x=i("p"),x.innerHTML=yt,be=a(),y(A.$$.fragment),Ie=a(),G=i("p"),G.textContent=mt,Ce=a(),B=i("p"),B.textContent=dt,ve=a(),Z=i("p"),Z.innerHTML=wt,ge=a(),_=i("p"),_.innerHTML=Tt,ke=a(),q=i("p"),q.innerHTML=jt,$e=a(),y(E.$$.fragment),xe=a(),H=i("p"),H.innerHTML=Jt,Ae=a(),u=i("iframe"),Ge=a(),W=i("p"),W.textContent=ht,Be=a(),y(L.$$.fragment),Ze=a(),R=i("p"),R.textContent=Ut,_e=a(),Q=i("p"),Q.textContent=bt,qe=a(),S=i("p"),S.textContent=It,Ee=a(),V=i("ul"),V.innerHTML=Ct,He=a(),N=i("p"),N.innerHTML=vt,We=a(),y(X.$$.fragment),Le=a(),M=i("iframe"),Re=a(),y(Y.$$.fragment),Qe=a(),P=i("p"),P.innerHTML=kt,Se=a(),z=i("p"),z.innerHTML=$t,Ve=a(),F=i("p"),F.innerHTML=xt,Ne=a(),D=i("ul"),D.innerHTML=At,Xe=a(),K=i("p"),K.innerHTML=Gt,Ye=a(),y(O.$$.fragment),Pe=a(),ee=i("p"),ee.innerHTML=Bt,ze=a(),te=i("p"),te.innerHTML=Zt,Fe=a(),y(le.$$.fragment),De=a(),se=i("p"),se.innerHTML=_t,Ke=a(),c=i("iframe"),Oe=a(),ae=i("p"),ae.innerHTML=Et,et=a(),ne=i("p"),ne.textContent=Ht,tt=a(),y(ie.$$.fragment),lt=a(),re=i("p"),this.h()},l(e){const t=Vt("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(l),Me=n(e),oe=p(e,"P",{}),ue(oe).forEach(l),ce=n(e),m(f.$$.fragment,e),ye=n(e),m(h.$$.fragment,e),me=n(e),m(U.$$.fragment,e),de=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1n241ec"&&(b.innerHTML=pt),we=n(e),m(I.$$.fragment,e),Te=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-cpncav"&&(C.innerHTML=ot),je=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-5xxju6"&&(v.innerHTML=rt),Je=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-136xoue"&&(g.textContent=ut),fe=n(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-bfg8z6"&&(k.innerHTML=Mt),he=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1gdrfcj"&&($.innerHTML=ct),Ue=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-wuhuoj"&&(x.innerHTML=yt),be=n(e),m(A.$$.fragment,e),Ie=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1ylue7a"&&(G.textContent=mt),Ce=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1qsoflg"&&(B.textContent=dt),ve=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1j2c7ez"&&(Z.innerHTML=wt),ge=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-35cafe"&&(_.innerHTML=Tt),ke=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1498ymc"&&(q.innerHTML=jt),$e=n(e),m(E.$$.fragment,e),xe=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1509wnm"&&(H.innerHTML=Jt),Ae=n(e),u=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(u).forEach(l),Ge=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-2k33o5"&&(W.textContent=ht),Be=n(e),m(L.$$.fragment,e),Ze=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1h3i1tv"&&(R.textContent=Ut),_e=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1dx3yg8"&&(Q.textContent=bt),qe=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1dstpsk"&&(S.textContent=It),Ee=n(e),V=p(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-1xcyqhu"&&(V.innerHTML=Ct),He=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-cp5tej"&&(N.innerHTML=vt),We=n(e),m(X.$$.fragment,e),Le=n(e),M=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(M).forEach(l),Re=n(e),m(Y.$$.fragment,e),Qe=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1lc29tb"&&(P.innerHTML=kt),Se=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1yn25id"&&(z.innerHTML=$t),Ve=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1wluu8a"&&(F.innerHTML=xt),Ne=n(e),D=p(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-f1qyss"&&(D.innerHTML=At),Xe=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1g3b2nk"&&(K.innerHTML=Gt),Ye=n(e),m(O.$$.fragment,e),Pe=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1bjo3cs"&&(ee.innerHTML=Bt),ze=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1uahifx"&&(te.innerHTML=Zt),Fe=n(e),m(le.$$.fragment,e),De=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1e8u067"&&(se.innerHTML=_t),Ke=n(e),c=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(c).forEach(l),Oe=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-bcbhfh"&&(ae.innerHTML=Et),et=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-erzn5k"&&(ne.textContent=Ht),tt=n(e),m(ie.$$.fragment,e),lt=n(e),re=p(e,"P",{}),ue(re).forEach(l),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",Ft),at(u.src,ft="https://course-demos-audio-reverse.hf.space")||r(u,"src",ft),r(u,"frameborder","0"),r(u,"height","250"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),at(M.src,gt="https://course-demos-generate-tone.hf.space")||r(M,"src",gt),r(M,"frameborder","0"),r(M,"height","450"),r(M,"title","Gradio app"),r(M,"class","container p-0 flex-grow space-iframe"),r(M,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(M,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),at(c.src,qt="https://course-demos-asr.hf.space")||r(c,"src",qt),r(c,"frameborder","0"),r(c,"height","550"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Nt(document.head,J),s(e,Me,t),s(e,oe,t),s(e,ce,t),d(f,e,t),s(e,ye,t),d(h,e,t),s(e,me,t),d(U,e,t),s(e,de,t),s(e,b,t),s(e,we,t),d(I,e,t),s(e,Te,t),s(e,C,t),s(e,je,t),s(e,v,t),s(e,Je,t),s(e,g,t),s(e,fe,t),s(e,k,t),s(e,he,t),s(e,$,t),s(e,Ue,t),s(e,x,t),s(e,be,t),d(A,e,t),s(e,Ie,t),s(e,G,t),s(e,Ce,t),s(e,B,t),s(e,ve,t),s(e,Z,t),s(e,ge,t),s(e,_,t),s(e,ke,t),s(e,q,t),s(e,$e,t),d(E,e,t),s(e,xe,t),s(e,H,t),s(e,Ae,t),s(e,u,t),s(e,Ge,t),s(e,W,t),s(e,Be,t),d(L,e,t),s(e,Ze,t),s(e,R,t),s(e,_e,t),s(e,Q,t),s(e,qe,t),s(e,S,t),s(e,Ee,t),s(e,V,t),s(e,He,t),s(e,N,t),s(e,We,t),d(X,e,t),s(e,Le,t),s(e,M,t),s(e,Re,t),d(Y,e,t),s(e,Qe,t),s(e,P,t),s(e,Se,t),s(e,z,t),s(e,Ve,t),s(e,F,t),s(e,Ne,t),s(e,D,t),s(e,Xe,t),s(e,K,t),s(e,Ye,t),d(O,e,t),s(e,Pe,t),s(e,ee,t),s(e,ze,t),s(e,te,t),s(e,Fe,t),d(le,e,t),s(e,De,t),s(e,se,t),s(e,Ke,t),s(e,c,t),s(e,Oe,t),s(e,ae,t),s(e,et,t),s(e,ne,t),s(e,tt,t),d(ie,e,t),s(e,lt,t),s(e,re,t),st=!0},p:Lt,i(e){st||(w(f.$$.fragment,e),w(h.$$.fragment,e),w(U.$$.fragment,e),w(I.$$.fragment,e),w(A.$$.fragment,e),w(E.$$.fragment,e),w(L.$$.fragment,e),w(X.$$.fragment,e),w(Y.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(ie.$$.fragment,e),st=!0)},o(e){T(f.$$.fragment,e),T(h.$$.fragment,e),T(U.$$.fragment,e),T(I.$$.fragment,e),T(A.$$.fragment,e),T(E.$$.fragment,e),T(L.$$.fragment,e),T(X.$$.fragment,e),T(Y.$$.fragment,e),T(O.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),st=!1},d(e){e&&(l(Me),l(oe),l(ce),l(ye),l(me),l(de),l(b),l(we),l(Te),l(C),l(je),l(v),l(Je),l(g),l(fe),l(k),l(he),l($),l(Ue),l(x),l(be),l(Ie),l(G),l(Ce),l(B),l(ve),l(Z),l(ge),l(_),l(ke),l(q),l($e),l(xe),l(H),l(Ae),l(u),l(Ge),l(W),l(Be),l(Ze),l(R),l(_e),l(Q),l(qe),l(S),l(Ee),l(V),l(He),l(N),l(We),l(Le),l(M),l(Re),l(Qe),l(P),l(Se),l(z),l(Ve),l(F),l(Ne),l(D),l(Xe),l(K),l(Ye),l(Pe),l(ee),l(ze),l(te),l(Fe),l(De),l(se),l(Ke),l(c),l(Oe),l(ae),l(et),l(ne),l(tt),l(lt),l(re)),l(J),j(f,e),j(h,e),j(U,e),j(I,e),j(A,e),j(E,e),j(L,e),j(X,e),j(Y,e),j(O,e),j(le,e),j(ie,e)}}}const Ft='{"title":"瞭解接口類","local":"瞭解接口類","sections":[{"title":"如何創建接口","local":"如何創建接口","sections":[],"depth":2},{"title":"一個帶音頻的簡單示例","local":"一個帶音頻的簡單示例","sections":[],"depth":2},{"title":"處理多個輸入和輸出","local":"處理多個輸入和輸出","sections":[{"title":"launch() 方法","local":"launch-方法","sections":[],"depth":3}],"depth":2},{"title":"✏️ 讓我們應用它！","local":"-讓我們應用它","sections":[],"depth":2}],"depth":1}';function Dt(it){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends Qt{constructor(J){super(),St(this,J,Dt,zt,Wt,{})}}export{sl as component};
