# Bias and limitations

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter1/section8.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter1/section8.ipynb"},
]} />

如果您打算在正式的項目中使用經過預訓練或經過微調的模型。請注意：雖然這些模型是很強大，但它們也有侷限性。其中最大的一個問題是，爲了對大量數據進行預訓練，研究人員通常會蒐集所有他們能找到的內容，中間可能夾帶一些意識形態或者價值觀的刻板印象。

爲了快速解釋清楚這個問題，讓我們回到一個使用 BERT 模型的 pipeline 的例子：

```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```
當要求模型填寫這兩句話中缺少的單詞時，模型給出的答案中，只有一個與性別無關（服務生/女服務生）。其他職業通常與某一特定性別相關，妓女最終進入了模型中與「女人」和「工作」相關的前五位。儘管 BERT 是使用經過篩選和清洗後，明顯中立的數據集上建立的的 Transformer 模型，而不是通過從互聯網上搜集數據（它是在[Wikipedia 英文](https://huggingface.co/datasets/wikipedia)和[BookCorpus](https://huggingface.co/datasets/bookcorpus)數據集）。

因此，當您使用這些工具時，您需要記住，使用的原始模型的時候，很容易生成性別歧視、種族主義或恐同內容。這種固有偏見不會隨着微調模型而使消失。

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter1/8.mdx" />