# 使用預訓練的模型

{#if fw === 'pt'}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter4/section2_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter4/section2_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter4/section2_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter4/section2_tf.ipynb"},
]} />

{/if}

模型中心使選擇合適的模型變得簡單，因此只需幾行代碼即可在任何下游庫中使用它。讓我們來看看如何實際使用這些模型之一，以及如何回饋社區。

假設我們正在尋找一種可以執行**mask**填充的French-based模型。

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/camembert.gif" alt="Selecting the Camembert model." width="80%"/>
</div>

我們選擇 **camembert-base** 檢查點來嘗試一下。我們需要做的僅僅是輸入 `camembert-base`標識符！正如您在前幾章中看到的，我們可以使用 **pipeline()** 功能：

```py
from transformers import pipeline

camembert_fill_mask = pipeline("fill-mask", model="camembert-base")
results = camembert_fill_mask("Le camembert est <mask> :)")
```

```python out
[
  {'sequence': 'Le camembert est délicieux :)', 'score': 0.49091005325317383, 'token': 7200, 'token_str': 'délicieux'}, 
  {'sequence': 'Le camembert est excellent :)', 'score': 0.1055697426199913, 'token': 2183, 'token_str': 'excellent'}, 
  {'sequence': 'Le camembert est succulent :)', 'score': 0.03453313186764717, 'token': 26202, 'token_str': 'succulent'}, 
  {'sequence': 'Le camembert est meilleur :)', 'score': 0.0330314114689827, 'token': 528, 'token_str': 'meilleur'}, 
  {'sequence': 'Le camembert est parfait :)', 'score': 0.03007650189101696, 'token': 1654, 'token_str': 'parfait'}
]
```

如您所見，在管道中加載模型非常簡單。您唯一需要注意的是所選檢查點是否適合它將用於的任務。例如，這裡我們正在加載 **camembert-base** 檢查點在 **fill-mask** 管道，這完全沒問題。但是如果我們要在 **text-classification** 管道，結果沒有任何意義，因為 **camembert-base** 不適合這個任務！我們建議使用 Hugging Face Hub 界面中的任務選擇器來選擇合適的檢查點：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/tasks.png" alt="The task selector on the web interface." width="80%"/>
</div>

您還可以直接使用模型架構實例化檢查點：

{#if fw === 'pt'}
```py
from transformers import CamembertTokenizer, CamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = CamembertForMaskedLM.from_pretrained("camembert-base")
```

然而，我們建議使用[Auto* 類](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes)，因為Auto* 類設計與架構無關。前面的代碼示例將只能在 CamemBERT 架構中加載可用的檢查點，但使用 **Auto*** 類使切換檢查點變得簡單：

```py
from transformers import AutoTokenizer, AutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = AutoModelForMaskedLM.from_pretrained("camembert-base")
```
{:else}
```py
from transformers import CamembertTokenizer, TFCamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = TFCamembertForMaskedLM.from_pretrained("camembert-base")
```

However, we recommend using the [`TFAuto*` classes](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes) instead, as these are by design architecture-agnostic. While the previous code sample limits users to checkpoints loadable in the CamemBERT architecture, using the `TFAuto*` classes makes switching checkpoints simple:
然而，我們建議使用[`TFAuto*` 類](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes)，因為`TFAuto*`類設計與架構無關。前面的代碼示例將只能在 CamemBERT 架構中加載可用的檢查點，但使用 `TFAuto*`  類使切換檢查點變得簡單：

```py
from transformers import AutoTokenizer, TFAutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = TFAutoModelForMaskedLM.from_pretrained("camembert-base")
```
{/if}

<Tip>
使用預訓練模型時，一定要檢查它是如何訓練的，在哪些數據集上，它的限制和它的偏差。所有這些信息都應在其模型卡片上註明。
</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter4/2.mdx" />