import{s as Ks,n as Ps,o as Os}from"../chunks/scheduler.ea9963d4.js";import{S as sl,i as ll,e as J,s as t,c as p,h as al,a as r,d as a,b as e,f as Ds,j as h,g as i,k as Rs,l as nl,m as n,n as c,t as M,o,p as y}from"../chunks/index.2ecb6441.js";import{C as tl,H as j,E as el}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c6a9a732.js";import{C as m}from"../chunks/CodeBlock.240e15a9.js";function pl(Vs){let U,ss,P,ls,T,Ys='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',as,w,ns,u,ts,d,es,g,vs="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ps,b,Xs='<li><a href="inference/README">@huggingface/inference</a>: Use all supported (serverless) Inference Providers or switch to Inference Endpoints (dedicated) to make calls to 100,000+ Machine Learning models</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li> <li><a href="mcp-client/README">@huggingface/mcp-client</a>: A Model Context Protocol (MCP) client, and a tiny Agent library, built on top of InferenceClient.</li> <li><a href="gguf/README">@huggingface/gguf</a>: A GGUF parser that works on remotely hosted files.</li> <li><a href="dduf/README">@huggingface/dduf</a>: Similar package for DDUF (DDUF Diffusers Unified Format)</li> <li><a href="tasks/README">@huggingface/tasks</a>: The definition files and source-of-truth for the Hub’s main primitives like pipeline tasks, model libraries, etc.</li> <li><a href="jinja/README">@huggingface/jinja</a>: A minimalistic JS implementation of the Jinja templating engine, to be used for ML chat templates.</li> <li><a href="space-header/README">@huggingface/space-header</a>: Use the Space <code>mini_header</code> outside Hugging Face</li> <li><a href="ollama-utils/README">@huggingface/ollama-utils</a>: Various utilities for maintaining Ollama compatibility with models on the Hugging Face Hub.</li> <li><a href="tiny-agents/README">@huggingface/tiny-agents</a>: A tiny, model-agnostic library for building AI agents that can use tools.</li>',is,I,As="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",cs,f,xs="The libraries are still very young, please help us by opening issues!",Ms,B,os,C,ys,G,qs="To install via NPM, you can download the libraries as needed:",Js,Z,rs,Q,Fs="Then import the libraries in your code:",hs,N,js,k,ms,E,Hs='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',Us,W,Ts,S,ws,$,us,R,ds,V,zs='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',gs,Y,bs,v,Is,X,fs,A,Bs,x,Cs,q,Gs,F,_s="There are more features of course, check each library’s README!",Zs,H,Qs,z,Ns,_,ks,L,Es,D,Ls="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",Ws,K,Ss,O,$s;return w=new m({props:{code:"JTJGJTJGJTIwUHJvZ3JhbW1hdGljYWxseSUyMGludGVyYWN0JTIwd2l0aCUyMHRoZSUyMEh1YiUwQSUwQWF3YWl0JTIwY3JlYXRlUmVwbyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCJTIwdHlwZSUzQSUyMCUyMm1vZGVsJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMjAlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwVXNlJTIwYWxsJTIwc3VwcG9ydGVkJTIwSW5mZXJlbmNlJTIwUHJvdmlkZXJzISUwQSUwQWF3YWl0JTIwaW5mZXJlbmNlLmNoYXRDb21wbGV0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIyc2FtYmFub3ZhJTIyJTJDJTIwJTJGJTJGJTIwb3IlMjB0b2dldGhlciUyQyUyMGZhbC1haSUyQyUyMHJlcGxpY2F0ZSUyQyUyMGNvaGVyZSUyMCVFMiU4MCVBNiUwQSUyMCUyMG1lc3NhZ2VzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBjb250ZW50JTNBJTIwJTIySGVsbG8lMkMlMjBuaWNlJTIwdG8lMjBtZWV0JTIweW91ISUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0ElMjA1MTIlMkMlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDAuNSUyQyUwQSU3RCklM0IlMEElMEFhd2FpdCUyMGluZmVyZW5jZS50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIycmVwbGljYXRlJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTIyYSUyMHBpY3R1cmUlMjBvZiUyMGElMjBncmVlbiUyMGJpcmQlMjIlMkMlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwYW5kJTIwbXVjaCUyMG1vcmUlRTIlODAlQTY=",highlighted:`<span class="hljs-comment">// Programmatically interact with the Hub</span>

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span> },
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...)
  }
});

<span class="hljs-comment">// Use all supported Inference Providers!</span>

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// or together, fal-ai, replicate, cohere …</span>
  <span class="hljs-attr">messages</span>: [
    {
      <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span>,
    },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.5</span>,
});

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
});

<span class="hljs-comment">// and much more…</span>`,wrap:!1}}),u=new tl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new j({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),B=new j({props:{title:"Installation",local:"installation",headingTag:"h2"}}),C=new j({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),Z=new m({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGbWNwLWNsaWVudA==",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/mcp-client`,wrap:!1}}),N=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBNY3BDbGllbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZtY3AtY2xpZW50JTIyJTNCJTBBaW1wb3J0JTIwdHlwZSUyMCU3QiUyMFJlcG9JZCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQg==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">McpClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/mcp-client&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),k=new j({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),W=new m({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEluZmVyZW5jZUNsaWVudCUyMCU3RCUyMGZyb20lMjAnaHR0cHMlM0ElMkYlMkZjZG4uanNkZWxpdnIubmV0JTJGbnBtJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlNDA0LjEzLjMlMkYlMkJlc20nJTNCJTBBJTIwJTIwJTIwJTIwaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZjZG4uanNkZWxpdnIubmV0JTJGbnBtJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlNDAyLjYuMTMlMkYlMkJlc20lMjIlM0IlMEElM0MlMkZzY3JpcHQlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@4.13.3/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@2.6.13/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),S=new j({props:{title:"Deno",local:"deno",headingTag:"h3"}}),$=new m({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlMEElMEFpbXBvcnQlMjAlN0IlMjBjcmVhdGVSZXBvJTJDJTIwY29tbWl0JTJDJTIwZGVsZXRlUmVwbyUyQyUyMGxpc3RGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjJodHRwcyUzQSUyRiUyRmVzbS5zaCUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTBBJTJGJTJGJTIwb3IlMjBucG0lM0ElMEFpbXBvcnQlMjAlN0IlMjBJbmZlcmVuY2VDbGllbnQlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlMEElMEFpbXBvcnQlMjAlN0IlMjBjcmVhdGVSZXBvJTJDJTIwY29tbWl0JTJDJTIwZGVsZXRlUmVwbyUyQyUyMGxpc3RGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),R=new j({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),Y=new j({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),v=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-comment">// Chat completion API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);

<span class="hljs-comment">// Streaming chat completion API</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> client.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>);
}

<span class="hljs-comment">/// Using a third-party provider:</span>
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// or together, fal-ai, replicate, cohere …</span>
})

<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;fal-ai&quot;</span>,
})



<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;My name is Wolfgang and I live in Amsterdam&quot;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&quot;en&quot;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&quot;fr&quot;</span>,
  },
});

<span class="hljs-comment">// pass multimodal files or URLs as inputs</span>
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
})

<span class="hljs-comment">// Using your own dedicated inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2Client = client.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2Client.<span class="hljs-title function_">textGeneration</span>({ <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span> });

<span class="hljs-comment">// Chat Completion</span>
<span class="hljs-keyword">const</span> llamaEndpoint = client.<span class="hljs-title function_">endpoint</span>(
  <span class="hljs-string">&quot;https://router.huggingface.co/hf-inference/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> llamaEndpoint.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);`,wrap:!1}}),X=new j({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),A=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMjAlMkYlMkYlMjBvciUyMCU3QiUyMHR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbmxwLXRlc3QlMjIlMjAlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjBkZWxldGVGaWxlcyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCJTIwdHlwZSUzQSUyMCUyMnNwYWNlJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZteS1zcGFjZSUyMiUyMCU3RCUyQyUyMCUyRiUyRiUyMG9yJTIwJTIyc3BhY2VzJTJGbXktdXNlciUyRm15LXNwYWNlJTIyJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMHBhdGhzJTNBJTIwJTVCJTIyUkVBRE1FLm1kJTIyJTJDJTIwJTIyLmdpdGF0dHJpYnV0ZXMlMjIlNUQlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or { type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot; },</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...)
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span> }, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),x=new j({props:{title:"@huggingface/mcp-client example",local:"huggingfacemcp-client-example",headingTag:"h3"}}),q=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwQWdlbnQlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGbWNwLWNsaWVudCclM0IlMEElMEFjb25zdCUyMEhGX1RPS0VOJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTNCJTBBJTBBY29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEFnZW50KCU3QiUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwYXBpS2V5JTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjBzZXJ2ZXJzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwUGxheXdyaWdodCUyME1DUCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNvbW1hbmQlM0ElMjAlMjJucHglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNBJTIwJTVCJTIyJTQwcGxheXdyaWdodCUyRm1jcCU0MGxhdGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSU3RCklM0IlMEElMEFhd2FpdCUyMGFnZW50LmxvYWRUb29scygpJTNCJTBBJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwYWdlbnQucnVuKCUyMldoYXQlMjBhcmUlMjB0aGUlMjB0b3AlMjA1JTIwdHJlbmRpbmclMjBtb2RlbHMlMjBvbiUyMEh1Z2dpbmclMjBGYWNlJTNGJTIyKSklMjAlN0IlMEElMjAlMjAlMjAlMjBpZiUyMCglMjJjaG9pY2VzJTIyJTIwaW4lMjBjaHVuayklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25zdCUyMGRlbHRhJTIwJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQlM0YuZGVsdGElM0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMChkZWx0YS5jb250ZW50KSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnNvbGUubG9nKGRlbHRhLmNvbnRlbnQpJTNCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">Agent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/mcp-client&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Agent</span>({
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;auto&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
  <span class="hljs-attr">apiKey</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">servers</span>: [
    {
      <span class="hljs-comment">// Playwright MCP</span>
      <span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
      <span class="hljs-attr">args</span>: [<span class="hljs-string">&quot;@playwright/mcp@latest&quot;</span>],
    },
  ],
});

<span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">loadTools</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;What are the top 5 trending models on Hugging Face?&quot;</span>)) {
    <span class="hljs-keyword">if</span> (<span class="hljs-string">&quot;choices&quot;</span> <span class="hljs-keyword">in</span> chunk) {
        <span class="hljs-keyword">const</span> delta = chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>]?.<span class="hljs-property">delta</span>;
        <span class="hljs-keyword">if</span> (delta.<span class="hljs-property">content</span>) {
            <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(delta.<span class="hljs-property">content</span>);
        }
    }
}`,wrap:!1}}),H=new j({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),z=new m({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),_=new j({props:{title:"Building",local:"building",headingTag:"h2"}}),L=new m({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),K=new el({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/index.md"}}),{c(){U=J("meta"),ss=t(),P=J("p"),ls=t(),T=J("p"),T.innerHTML=Ys,as=t(),p(w.$$.fragment),ns=t(),p(u.$$.fragment),ts=t(),p(d.$$.fragment),es=t(),g=J("p"),g.textContent=vs,ps=t(),b=J("ul"),b.innerHTML=Xs,is=t(),I=J("p"),I.textContent=As,cs=t(),f=J("p"),f.textContent=xs,Ms=t(),p(B.$$.fragment),os=t(),p(C.$$.fragment),ys=t(),G=J("p"),G.textContent=qs,Js=t(),p(Z.$$.fragment),rs=t(),Q=J("p"),Q.textContent=Fs,hs=t(),p(N.$$.fragment),js=t(),p(k.$$.fragment),ms=t(),E=J("p"),E.innerHTML=Hs,Us=t(),p(W.$$.fragment),Ts=t(),p(S.$$.fragment),ws=t(),p($.$$.fragment),us=t(),p(R.$$.fragment),ds=t(),V=J("p"),V.innerHTML=zs,gs=t(),p(Y.$$.fragment),bs=t(),p(v.$$.fragment),Is=t(),p(X.$$.fragment),fs=t(),p(A.$$.fragment),Bs=t(),p(x.$$.fragment),Cs=t(),p(q.$$.fragment),Gs=t(),F=J("p"),F.textContent=_s,Zs=t(),p(H.$$.fragment),Qs=t(),p(z.$$.fragment),Ns=t(),p(_.$$.fragment),ks=t(),p(L.$$.fragment),Es=t(),D=J("p"),D.innerHTML=Ls,Ws=t(),p(K.$$.fragment),Ss=t(),O=J("p"),this.h()},l(s){const l=al("svelte-u9bgzb",document.head);U=r(l,"META",{name:!0,content:!0}),l.forEach(a),ss=e(s),P=r(s,"P",{}),Ds(P).forEach(a),ls=e(s),T=r(s,"P",{align:!0,"data-svelte-h":!0}),h(T)!=="svelte-9rngw"&&(T.innerHTML=Ys),as=e(s),i(w.$$.fragment,s),ns=e(s),i(u.$$.fragment,s),ts=e(s),i(d.$$.fragment,s),es=e(s),g=r(s,"P",{"data-svelte-h":!0}),h(g)!=="svelte-1eufct4"&&(g.textContent=vs),ps=e(s),b=r(s,"UL",{"data-svelte-h":!0}),h(b)!=="svelte-52p5el"&&(b.innerHTML=Xs),is=e(s),I=r(s,"P",{"data-svelte-h":!0}),h(I)!=="svelte-5pb56g"&&(I.textContent=As),cs=e(s),f=r(s,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1vx14v7"&&(f.textContent=xs),Ms=e(s),i(B.$$.fragment,s),os=e(s),i(C.$$.fragment,s),ys=e(s),G=r(s,"P",{"data-svelte-h":!0}),h(G)!=="svelte-18mxf19"&&(G.textContent=qs),Js=e(s),i(Z.$$.fragment,s),rs=e(s),Q=r(s,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1fdwpsr"&&(Q.textContent=Fs),hs=e(s),i(N.$$.fragment,s),js=e(s),i(k.$$.fragment,s),ms=e(s),E=r(s,"P",{"data-svelte-h":!0}),h(E)!=="svelte-1td2f08"&&(E.innerHTML=Hs),Us=e(s),i(W.$$.fragment,s),Ts=e(s),i(S.$$.fragment,s),ws=e(s),i($.$$.fragment,s),us=e(s),i(R.$$.fragment,s),ds=e(s),V=r(s,"P",{"data-svelte-h":!0}),h(V)!=="svelte-mx6w21"&&(V.innerHTML=zs),gs=e(s),i(Y.$$.fragment,s),bs=e(s),i(v.$$.fragment,s),Is=e(s),i(X.$$.fragment,s),fs=e(s),i(A.$$.fragment,s),Bs=e(s),i(x.$$.fragment,s),Cs=e(s),i(q.$$.fragment,s),Gs=e(s),F=r(s,"P",{"data-svelte-h":!0}),h(F)!=="svelte-16qnxzd"&&(F.textContent=_s),Zs=e(s),i(H.$$.fragment,s),Qs=e(s),i(z.$$.fragment,s),Ns=e(s),i(_.$$.fragment,s),ks=e(s),i(L.$$.fragment,s),Es=e(s),D=r(s,"P",{"data-svelte-h":!0}),h(D)!=="svelte-ymfi8c"&&(D.innerHTML=Ls),Ws=e(s),i(K.$$.fragment,s),Ss=e(s),O=r(s,"P",{}),Ds(O).forEach(a),this.h()},h(){Rs(U,"name","hf:doc:metadata"),Rs(U,"content",il),Rs(T,"align","center")},m(s,l){nl(document.head,U),n(s,ss,l),n(s,P,l),n(s,ls,l),n(s,T,l),n(s,as,l),c(w,s,l),n(s,ns,l),c(u,s,l),n(s,ts,l),c(d,s,l),n(s,es,l),n(s,g,l),n(s,ps,l),n(s,b,l),n(s,is,l),n(s,I,l),n(s,cs,l),n(s,f,l),n(s,Ms,l),c(B,s,l),n(s,os,l),c(C,s,l),n(s,ys,l),n(s,G,l),n(s,Js,l),c(Z,s,l),n(s,rs,l),n(s,Q,l),n(s,hs,l),c(N,s,l),n(s,js,l),c(k,s,l),n(s,ms,l),n(s,E,l),n(s,Us,l),c(W,s,l),n(s,Ts,l),c(S,s,l),n(s,ws,l),c($,s,l),n(s,us,l),c(R,s,l),n(s,ds,l),n(s,V,l),n(s,gs,l),c(Y,s,l),n(s,bs,l),c(v,s,l),n(s,Is,l),c(X,s,l),n(s,fs,l),c(A,s,l),n(s,Bs,l),c(x,s,l),n(s,Cs,l),c(q,s,l),n(s,Gs,l),n(s,F,l),n(s,Zs,l),c(H,s,l),n(s,Qs,l),c(z,s,l),n(s,Ns,l),c(_,s,l),n(s,ks,l),c(L,s,l),n(s,Es,l),n(s,D,l),n(s,Ws,l),c(K,s,l),n(s,Ss,l),n(s,O,l),$s=!0},p:Ps,i(s){$s||(M(w.$$.fragment,s),M(u.$$.fragment,s),M(d.$$.fragment,s),M(B.$$.fragment,s),M(C.$$.fragment,s),M(Z.$$.fragment,s),M(N.$$.fragment,s),M(k.$$.fragment,s),M(W.$$.fragment,s),M(S.$$.fragment,s),M($.$$.fragment,s),M(R.$$.fragment,s),M(Y.$$.fragment,s),M(v.$$.fragment,s),M(X.$$.fragment,s),M(A.$$.fragment,s),M(x.$$.fragment,s),M(q.$$.fragment,s),M(H.$$.fragment,s),M(z.$$.fragment,s),M(_.$$.fragment,s),M(L.$$.fragment,s),M(K.$$.fragment,s),$s=!0)},o(s){o(w.$$.fragment,s),o(u.$$.fragment,s),o(d.$$.fragment,s),o(B.$$.fragment,s),o(C.$$.fragment,s),o(Z.$$.fragment,s),o(N.$$.fragment,s),o(k.$$.fragment,s),o(W.$$.fragment,s),o(S.$$.fragment,s),o($.$$.fragment,s),o(R.$$.fragment,s),o(Y.$$.fragment,s),o(v.$$.fragment,s),o(X.$$.fragment,s),o(A.$$.fragment,s),o(x.$$.fragment,s),o(q.$$.fragment,s),o(H.$$.fragment,s),o(z.$$.fragment,s),o(_.$$.fragment,s),o(L.$$.fragment,s),o(K.$$.fragment,s),$s=!1},d(s){s&&(a(ss),a(P),a(ls),a(T),a(as),a(ns),a(ts),a(es),a(g),a(ps),a(b),a(is),a(I),a(cs),a(f),a(Ms),a(os),a(ys),a(G),a(Js),a(rs),a(Q),a(hs),a(js),a(ms),a(E),a(Us),a(Ts),a(ws),a(us),a(ds),a(V),a(gs),a(bs),a(Is),a(fs),a(Bs),a(Cs),a(Gs),a(F),a(Zs),a(Qs),a(Ns),a(ks),a(Es),a(D),a(Ws),a(Ss),a(O)),a(U),y(w,s),y(u,s),y(d,s),y(B,s),y(C,s),y(Z,s),y(N,s),y(k,s),y(W,s),y(S,s),y($,s),y(R,s),y(Y,s),y(v,s),y(X,s),y(A,s),y(x,s),y(q,s),y(H,s),y(z,s),y(_,s),y(L,s),y(K,s)}}}const il='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3},{"title":"@huggingface/mcp-client example","local":"huggingfacemcp-client-example","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function cl(Vs){return Os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rl extends sl{constructor(U){super(),ll(this,U,cl,pl,Ks,{})}}export{rl as component};
