# Class: \_\_internal\_XetBlob

XetBlob is a blob implementation that fetches data directly from the Xet storage

## Hierarchy

- `Blob`

  ↳ **`__internal_XetBlob`**

## Constructors

### constructor

• **new __internal_XetBlob**(`params`): [`__internal_XetBlob`](_internal_XetBlob)

#### Parameters[[constructor.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | `XetBlobCreateOptions` |

#### Returns[[constructor.returns]]

[`__internal_XetBlob`](_internal_XetBlob)

#### Overrides[[constructor.overrides]]

Blob.constructor

#### Defined in[[constructor.defined-in]]

[packages/hub/src/utils/XetBlob.ts:96](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L96)

## Properties

### #reconstructionInfoPromise

• `Private` `Optional` **#reconstructionInfoPromise**: `Promise`\

#### Defined in[[reconstructioninfopromise.defined-in]]

[packages/hub/src/utils/XetBlob.ts:151](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L151)

___

### accessToken

• `Optional` **accessToken**: `string`

#### Defined in[[accesstoken.defined-in]]

[packages/hub/src/utils/XetBlob.ts:86](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L86)

___

### end

• **end**: `number` = `0`

#### Defined in[[end.defined-in]]

[packages/hub/src/utils/XetBlob.ts:91](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L91)

___

### fetch

• **fetch**: (`input`: `URL` \| `RequestInfo`, `init?`: `RequestInit`) => `Promise`\(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\

#### Type declaration[[fetch.type-declaration]]

▸ (`input`, `init?`): `Promise`\

[MDN Reference](https://developer.mozilla.org/docs/Web/API/Window/fetch)

##### Parameters[[fetch.parameters]]

| Name | Type |
| :------ | :------ |
| `input` | `URL` \| `RequestInfo` |
| `init?` | `RequestInit` |

##### Returns[[fetch.returns]]

`Promise`\

▸ (`input`, `init?`): `Promise`\

##### Parameters[[fetch.parameters]]

| Name | Type |
| :------ | :------ |
| `input` | `string` \| `URL` \| `Request` |
| `init?` | `RequestInit` |

##### Returns[[fetch.returns]]

`Promise`\

#### Defined in[[fetch.defined-in]]

[packages/hub/src/utils/XetBlob.ts:85](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L85)

___

### hash

• `Optional` **hash**: `string`

#### Defined in[[hash.defined-in]]

[packages/hub/src/utils/XetBlob.ts:89](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L89)

___

### internalLogging

• **internalLogging**: `boolean` = `false`

#### Defined in[[internallogging.defined-in]]

[packages/hub/src/utils/XetBlob.ts:92](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L92)

___

### listener

• **listener**: `undefined` \| (`arg`: \{ `event`: ``"read"``  } \| \{ `event`: ``"progress"`` ; `progress`: \{ `read`: `number` ; `total`: `number`  }  }) => `void`

#### Defined in[[listener.defined-in]]

[packages/hub/src/utils/XetBlob.ts:94](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L94)

___

### reconstructionInfo

• **reconstructionInfo**: `undefined` \| `ReconstructionInfo`

#### Defined in[[reconstructioninfo.defined-in]]

[packages/hub/src/utils/XetBlob.ts:93](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L93)

___

### reconstructionUrl

• `Optional` **reconstructionUrl**: `string`

#### Defined in[[reconstructionurl.defined-in]]

[packages/hub/src/utils/XetBlob.ts:88](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L88)

___

### refreshUrl

• **refreshUrl**: `string`

#### Defined in[[refreshurl.defined-in]]

[packages/hub/src/utils/XetBlob.ts:87](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L87)

___

### start

• **start**: `number` = `0`

#### Defined in[[start.defined-in]]

[packages/hub/src/utils/XetBlob.ts:90](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L90)

___

### type

• `Readonly` **type**: `string`

[MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/type)

#### Inherited from[[type.inherited-from]]

Blob.type

#### Defined in[[type.defined-in]]

packages/doc-internal/node_modules/.pnpm/typescript@5.8.3/node_modules/typescript/lib/lib.dom.d.ts:3501

## Accessors

### size

• `get` **size**(): `number`

#### Returns[[size.returns]]

`number`

#### Overrides[[size.overrides]]

Blob.size

#### Defined in[[size.defined-in]]

[packages/hub/src/utils/XetBlob.ts:110](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L110)

## Methods

### #clone

▸ **#clone**(): [`__internal_XetBlob`](_internal_XetBlob)

#### Returns[[clone.returns]]

[`__internal_XetBlob`](_internal_XetBlob)

#### Defined in[[clone.defined-in]]

[packages/hub/src/utils/XetBlob.ts:114](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L114)

___

### #fetch

▸ **#fetch**(): `Promise`\\>\>

#### Returns[[fetch.returns]]

`Promise`\\>\>

#### Defined in[[fetch.defined-in]]

[packages/hub/src/utils/XetBlob.ts:184](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L184)

___

### #loadReconstructionInfo

▸ **#loadReconstructionInfo**(): `Promise`\

#### Returns[[loadreconstructioninfo.returns]]

`Promise`\

#### Defined in[[loadreconstructioninfo.defined-in]]

[packages/hub/src/utils/XetBlob.ts:153](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L153)

___

### arrayBuffer

▸ **arrayBuffer**(): `Promise`\

#### Returns[[arraybuffer.returns]]

`Promise`\

#### Overrides[[arraybuffer.overrides]]

Blob.arrayBuffer

#### Defined in[[arraybuffer.defined-in]]

[packages/hub/src/utils/XetBlob.ts:486](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L486)

___

### bytes

▸ **bytes**(): `Promise`\\>

[MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/bytes)

#### Returns[[bytes.returns]]

`Promise`\\>

#### Inherited from[[bytes.inherited-from]]

Blob.bytes

#### Defined in[[bytes.defined-in]]

packages/doc-internal/node_modules/.pnpm/typescript@5.8.3/node_modules/typescript/lib/lib.dom.d.ts:3505

___

### response

▸ **response**(): `Promise`\

#### Returns[[response.returns]]

`Promise`\

#### Defined in[[response.defined-in]]

[packages/hub/src/utils/XetBlob.ts:498](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L498)

___

### slice

▸ **slice**(`start?`, `end?`): [`__internal_XetBlob`](_internal_XetBlob)

#### Parameters[[slice.parameters]]

| Name | Type | Default value |
| :------ | :------ | :------ |
| `start` | `number` | `0` |
| `end` | `number` | `undefined` |

#### Returns[[slice.returns]]

[`__internal_XetBlob`](_internal_XetBlob)

#### Overrides[[slice.overrides]]

Blob.slice

#### Defined in[[slice.defined-in]]

[packages/hub/src/utils/XetBlob.ts:134](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L134)

___

### stream

▸ **stream**(): `ReadableStream`\\>

#### Returns[[stream.returns]]

`ReadableStream`\\>

#### Overrides[[stream.overrides]]

Blob.stream

#### Defined in[[stream.defined-in]]

[packages/hub/src/utils/XetBlob.ts:504](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L504)

___

### text

▸ **text**(): `Promise`\

#### Returns[[text.returns]]

`Promise`\

#### Overrides[[text.overrides]]

Blob.text

#### Defined in[[text.defined-in]]

[packages/hub/src/utils/XetBlob.ts:492](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/XetBlob.ts#L492)

