# Namespace: snippets

## Type Aliases

### InferenceSnippetOptions

Ƭ **InferenceSnippetOptions**: \{ `accessToken?`: `string` ; `billTo?`: `string` ; `directRequest?`: `boolean` ; `endpointUrl?`: `string` ; `inputs?`: `Record`\ ; `streaming?`: `boolean`  } & `Record`\

#### Defined in[[inferencesnippetoptions.defined-in]]

[inference/src/snippets/getInferenceSnippets.ts:18](https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/snippets/getInferenceSnippets.ts#L18)

## Functions

### getInferenceSnippets

▸ **getInferenceSnippets**(`model`, `provider`, `inferenceProviderMapping?`, `opts?`): `InferenceSnippet`[]

#### Parameters[[getinferencesnippets.parameters]]

| Name | Type |
| :------ | :------ |
| `model` | `ModelDataMinimal` |
| `provider` | ``"baseten"`` \| ``"black-forest-labs"`` \| ``"cerebras"`` \| ``"clarifai"`` \| ``"cohere"`` \| ``"fal-ai"`` \| ``"featherless-ai"`` \| ``"fireworks-ai"`` \| ``"groq"`` \| ``"hf-inference"`` \| ``"hyperbolic"`` \| ``"nebius"`` \| ``"novita"`` \| ``"nscale"`` \| ``"openai"`` \| ``"ovhcloud"`` \| ``"publicai"`` \| ``"replicate"`` \| ``"sambanova"`` \| ``"scaleway"`` \| ``"together"`` \| ``"wavespeed"`` \| ``"zai-org"`` \| ``"auto"`` |
| `inferenceProviderMapping?` | [`InferenceProviderMappingEntry`](../interfaces/InferenceProviderMappingEntry) |
| `opts?` | `Record`\ |

#### Returns[[getinferencesnippets.returns]]

`InferenceSnippet`[]

#### Defined in[[getinferencesnippets.defined-in]]

[inference/src/snippets/getInferenceSnippets.ts:416](https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/snippets/getInferenceSnippets.ts#L416)

