# Supported models

🤗 Optimum handles the export of models to OpenVINO in the `exporters.openvino` module. It provides classes, functions, and a command line interface to perform the export easily.
Here is the list of the supported architectures :

## [Transformers](https://huggingface.co/docs/transformers/index)

- Albert
- Aquila
- Aquila 2
- Arcee
- Arctic
- Audio Spectrogram Transformer
- Baichuan 2
- Bart
- Beit
- Bert
- BioGPT
- Bitnet
- BlenderBot
- BlenderBotSmall
- Bloom
- CLIP
- Camembert
- ChatGLM (ChatGLM2, ChatGLM3, GLM4)
- CodeGen
- CodeGen2
- Cohere
- ConvBert
- ConvNext
- DBRX
- Data2VecAudio
- Data2VecText
- Data2VecVision
- Deberta
- Deberta-v2
- DeciLM
- Deit
- Deepseek
- Deepseek_v2
- Deepseek_v3
- DistilBert
- Ernie4.5
- Electra
- Encoder Decoder
- ESM
- Exaone
- Falcon
- Falcon-Mamba
- Flaubert
- GLM-4
- GLM-Edge
- GPT-2
- GPT-BigCode
- GPT-J
- GPT-Neo
- GPT-NeoX
- GPT-NeoX-Japanese
- Gemma
- Gemma2
- Gemma3
- GOT-OCR 2.0
- Granite
- GraniteMoE
- Hubert
- IBert
- Idefics3
- InternLM
- InternLM2
- InternVL2
- Jais
- Levit
- Llama
- Llama4
- Llava
- Llava-Next
- Llava-Next-Video
- M2-M100
- MAIRA-2
- Mamba
- MBart
- MPNet
- MPT
- MT5
- Marian
- MiniCPM
- MiniCPM3
- MiniCPM-o
- MiniCPMV
- Mistral
- Mixtral
- MobileBert
- MobileNet v1
- MobileNet v2
- MobileVit
- Nystromformer
- OLMo
- OPT
- Orion
- Pegasus
- Perceiver
- Persimmon
- Phi
- Phi3
- Phi3.5-MoE
- Phi3Vision
- Phi4-Multimodal
- Pix2Struct
- PoolFormer
- Qwen
- Qwen2(Qwen1.5, Qwen2.5)
- Qwen2MoE
- Qwen2VL
- Qwen2.5VL
- ResNet
- Roberta
- Roformer
- SAM
- SEW
- SEW-D
- Segformer
- SigLIP
- SmolVLM(SmolVLM2)
- SpeechT5 (text-to-speech)
- SqueezeBert
- StableLM
- StarCoder2
- Swin
- T5
- TROCR
- UniSpeech
- UniSpeech SAT
- Vision Encoder Decoder
- Vit
- Wav2Vec2
- Wav2Vec2 Conformer
- WavLM
- Whisper
- XGLM
- XLM
- XLM-Roberta
- XVERSE
- Zamba2

## [Diffusers](https://huggingface.co/docs/diffusers/index)
- Stable Diffusion
- Stable Diffusion XL
- Latent Consistency
- Stable Diffusion 3
- Flux
- Sana
- SanaSprint
- LTX

## [Timm](https://huggingface.co/docs/timm/index)
- PiT
- ViT

## [Sentence Transformers](https://github.com/UKPLab/sentence-transformers)
- All Transformer and CLIP-based models.

## [OpenCLIP](https://github.com/mlfoundations/open_clip)
- All CLIP-based models