import{s as Ls,n as Ks,o as Ps}from"../chunks/scheduler.b108d059.js";import{S as Os,i as sl,g as r,s as t,r as p,A as ll,h,f as a,c as e,j as Ds,x as m,u as i,k as Ss,y as al,a as n,v as c,d as M,t as o,w as J}from"../chunks/index.008de539.js";import{C as T}from"../chunks/CodeBlock.3968c746.js";import{H as y}from"../chunks/Heading.88bfeb84.js";function nl(Es){let w,O,K,ss,d,Rs='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',ls,j,as,g,ns,u,Ys="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ts,U,Vs='<li><a href="inference/README">@huggingface/inference</a>: Use the Inference API to make calls to 100,000+ Machine Learning models, or your own <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">inference endpoints</a>!</li> <li><a href="agents/README">@huggingface/agents</a>: Interact with HF models through a natural language interface</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li>',es,f,Xs="With more to come, like <code>@huggingface/endpoints</code> to manage your HF Endpoints!",ps,b,vs="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",is,Z,Hs="The libraries are still very young, please help us by opening issues!",cs,I,Ms,B,os,G,xs="To install via NPM, you can download the libraries as needed:",Js,C,rs,k,Fs="Then import the libraries in your code:",hs,W,ms,Q,ys,$,_s='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',Ts,N,ws,S,ds,E,js,R,gs,Y,zs='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',us,V,Us,X,fs,v,bs,H,Zs,x,Is,F,Bs,_,qs="There are more features of course, check each library’s README!",Gs,z,Cs,q,ks,A,Ws,D,Qs,L,As="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",$s,P,Ns;return j=new T({props:{code:"YXdhaXQlMjBpbmZlcmVuY2UudHJhbnNsYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAndDUtYmFzZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnTXklMjBuYW1lJTIwaXMlMjBXb2xmZ2FuZyUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBCZXJsaW4nJTBBJTdEKSUwQSUwQWF3YWl0JTIwaGYudHJhbnNsYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTIyaG93JTIwaXMlMjB0aGUlMjB3ZWF0aGVyJTIwbGlrZSUyMGluJTIwR2Fib3JvbmUlMjIlMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTIwJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc3JjX2xhbmclM0ElMjAlMjJlbmdfTGF0biUyMiUyQyUwQSUyMCUyMCUyMCUyMHRndF9sYW5nJTNBJTIwJTIyc290X0xhdG4lMjIlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBYXdhaXQlMjBpbmZlcmVuY2UudGV4dFRvSW1hZ2UoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTInJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ2F3YXJkJTIwd2lubmluZyUyMGhpZ2glMjByZXNvbHV0aW9uJTIwcGhvdG8lMjBvZiUyMGElMjBnaWFudCUyMHRvcnRvaXNlJTJGKChsYWR5YmlyZCkpJTIwaHlicmlkJTJDJTIwJTVCdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lNUQnJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzQSUyMCdibHVycnknJTJDJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;how is the weather like in Gaborone&quot;</span>,
  parameters : {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&quot;eng_Latn&quot;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&quot;sot_Latn&quot;</span>
  }
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})`,wrap:!1}}),g=new y({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),I=new y({props:{title:"Installation",local:"installation",headingTag:"h2"}}),B=new y({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),C=new T({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRz",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/agents`,wrap:!1}}),W=new T({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBIZkFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEFpbXBvcnQlMjB0eXBlJTIwJTdCJTIwUmVwb0lkJTJDJTIwQ3JlZGVudGlhbHMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0I=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span>, <span class="hljs-title class_">Credentials</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),Q=new y({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),N=new T({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCdodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSU0MDIuNi40JTJGJTJCZXNtJyUzQiUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGY2RuLmpzZGVsaXZyLm5ldCUyRm5wbSUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTQwMC4xMS40JTJGJTJCZXNtJTIyJTNCJTBBJTNDJTJGc2NyaXB0JTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@2.6.4/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@0.11.4/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),S=new y({props:{title:"Deno",local:"deno",headingTag:"h3"}}),E=new T({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQWltcG9ydCUyMCU3QiUyMEhmQWdlbnQlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaHViJTIy",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),R=new y({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),V=new y({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),X=new T({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFjb25zdCUyMEhGX0FDQ0VTU19UT0tFTiUyMCUzRCUyMCUyMmhmXy4uLiUyMiUzQiUwQSUwQWNvbnN0JTIwaW5mZXJlbmNlJTIwJTNEJTIwbmV3JTIwSGZJbmZlcmVuY2UoSEZfQUNDRVNTX1RPS0VOKSUzQiUwQSUwQSUyRiUyRiUyMFlvdSUyMGNhbiUyMGFsc28lMjBvbWl0JTIwJTIybW9kZWwlMjIlMjB0byUyMHVzZSUyMHRoZSUyMHJlY29tbWVuZGVkJTIwbW9kZWwlMjBmb3IlMjB0aGUlMjB0YXNrJTBBYXdhaXQlMjBpbmZlcmVuY2UudHJhbnNsYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAndDUtYmFzZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnTXklMjBuYW1lJTIwaXMlMjBXb2xmZ2FuZyUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBCZXJsaW4nJTBBJTdEKSUwQSUwQWF3YWl0JTIwaW5mZXJlbmNlLnRleHRUb0ltYWdlKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdhd2FyZCUyMHdpbm5pbmclMjBoaWdoJTIwcmVzb2x1dGlvbiUyMHBob3RvJTIwb2YlMjBhJTIwZ2lhbnQlMjB0b3J0b2lzZSUyRigobGFkeWJpcmQpKSUyMGh5YnJpZCUyQyUyMCU1QnRyZW5kaW5nJTIwb24lMjBhcnRzdGF0aW9uJTVEJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0ElMjAnYmx1cnJ5JyUyQyUwQSUyMCUyMCU3RCUwQSU3RCklMEElMEFhd2FpdCUyMGluZmVyZW5jZS5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwYXdhaXQlMjAoYXdhaXQlMjBmZXRjaCgnaHR0cHMlM0ElMkYlMkZwaWNzdW0ucGhvdG9zJTJGMzAwJTJGMzAwJykpLmJsb2IoKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUyQyUyMCUyMCUwQSU3RCklMEElMEElMkYlMkYlMjBVc2luZyUyMHlvdXIlMjBvd24lMjBpbmZlcmVuY2UlMjBlbmRwb2ludCUzQSUyMGh0dHBzJTNBJTJGJTJGaGYuY28lMkZkb2NzJTJGaW5mZXJlbmNlLWVuZHBvaW50cyUyRiUwQWNvbnN0JTIwZ3B0MiUyMCUzRCUyMGluZmVyZW5jZS5lbmRwb2ludCgnaHR0cHMlM0ElMkYlMkZ4eXouZXUtd2VzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMkZncHQyJyklM0IlMEFjb25zdCUyMCU3QiUyMGdlbmVyYXRlZF90ZXh0JTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBncHQyLnRleHRHZW5lcmF0aW9uKCU3QmlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTdEKSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_ACCESS_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">HF_ACCESS_TOKEN</span>);

<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,  
})

<span class="hljs-comment">// Using your own inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2 = inference.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});`,wrap:!1}}),v=new y({props:{title:"@huggingface/agents example",local:"huggingfaceagents-example",headingTag:"h3"}}),H=new T({props:{code:"aW1wb3J0JTIwJTdCSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMkMlMjBkZWZhdWx0VG9vbHMlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJyUzQiUwQSUwQWNvbnN0JTIwSEZfQUNDRVNTX1RPS0VOJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTNCJTBBJTBBY29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEhmQWdlbnQoJTBBJTIwJTIwSEZfQUNDRVNTX1RPS0VOJTJDJTBBJTIwJTIwTExNRnJvbUh1YihIRl9BQ0NFU1NfVE9LRU4pJTJDJTBBJTIwJTIwJTVCLi4uZGVmYXVsdFRvb2xzJTVEJTBBKSUzQiUwQSUwQSUwQSUyRiUyRiUyMHlvdSUyMGNhbiUyMGdlbmVyYXRlJTIwdGhlJTIwY29kZSUyQyUyMGluc3BlY3QlMjBpdCUyMGFuZCUyMHRoZW4lMjBydW4lMjBpdCUwQWNvbnN0JTIwY29kZSUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZ2VuZXJhdGVDb2RlKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUzQiUwQWNvbnNvbGUubG9nKGNvZGUpJTNCJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZXZhbHVhdGVDb2RlKGNvZGUpJTBBY29uc29sZS5sb2cobWVzc2FnZXMpJTNCJTIwJTJGJTJGJTIwY29udGFpbnMlMjB0aGUlMjBkYXRhJTBBJTBBJTJGJTJGJTIwb3IlMjB5b3UlMjBjYW4lMjBydW4lMjB0aGUlMjBjb2RlJTIwZGlyZWN0bHklMkMlMjBob3dldmVyJTIweW91JTIwY2FuJ3QlMjBjaGVjayUyMHRoYXQlMjB0aGUlMjBjb2RlJTIwaXMlMjBzYWZlJTIwdG8lMjBleGVjdXRlJTIwdGhpcyUyMHdheSUyQyUyMHVzZSUyMGF0JTIweW91ciUyMG93biUyMHJpc2suJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQucnVuKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUwQWNvbnNvbGUubG9nKG1lc3NhZ2VzKSUzQiUyMA==",highlighted:`<span class="hljs-keyword">import</span> {<span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span>, defaultTools} <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/agents&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_ACCESS_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-variable constant_">HF_ACCESS_TOKEN</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-variable constant_">HF_ACCESS_TOKEN</span>),
  [...defaultTools]
);


<span class="hljs-comment">// you can generate the code, inspect it and then run it</span>
<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code);
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.evaluateCode(code)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); <span class="hljs-comment">// contains the data</span>

<span class="hljs-comment">// or you can run the code directly, however you can&#x27;t check that the code is safe to execute this way, use at your own risk.</span>
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); `,wrap:!1}}),x=new y({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),F=new T({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfQUNDRVNTX1RPS0VOJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTNCJTBBJTBBYXdhaXQlMjBjcmVhdGVSZXBvKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlMjJteS11c2VyJTJGbmxwLW1vZGVsJTIyJTJDJTIwJTJGJTJGJTIwb3IlMjAlN0J0eXBlJTNBJTIwJTIybW9kZWwlMjIlMkMlMjBuYW1lJTNBJTIwJTIybXktdXNlciUyRm5scC10ZXN0JTIyJTdEJTJDJTBBJTIwJTIwY3JlZGVudGlhbHMlM0ElMjAlN0JhY2Nlc3NUb2tlbiUzQSUyMEhGX0FDQ0VTU19UT0tFTiU3RCUwQSU3RCklM0IlMEElMEFhd2FpdCUyMHVwbG9hZEZpbGUoJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMEElMjAlMjBjcmVkZW50aWFscyUzQSUyMCU3QmFjY2Vzc1Rva2VuJTNBJTIwSEZfQUNDRVNTX1RPS0VOJTdEJTJDJTBBJTIwJTIwJTJGJTJGJTIwQ2FuJTIwd29yayUyMHdpdGglMjBuYXRpdmUlMjBGaWxlJTIwaW4lMjBicm93c2VycyUwQSUyMCUyMGZpbGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXRoJTNBJTIwJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMEElMjAlMjAlMjAlMjBjb250ZW50JTNBJTIwbmV3JTIwQmxvYiguLi4pJTIwJTBBJTIwJTIwJTdEJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwZGVsZXRlRmlsZXMoJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCU3QnR5cGUlM0ElMjAlMjJzcGFjZSUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbXktc3BhY2UlMjIlN0QlMkMlMjAlMkYlMkYlMjBvciUyMCUyMnNwYWNlcyUyRm15LXVzZXIlMkZteS1zcGFjZSUyMiUwQSUyMCUyMGNyZWRlbnRpYWxzJTNBJTIwJTdCYWNjZXNzVG9rZW4lM0ElMjBIRl9BQ0NFU1NfVE9LRU4lN0QlMkMlMEElMjAlMjBwYXRocyUzQSUyMCU1QiUyMlJFQURNRS5tZCUyMiUyQyUyMCUyMi5naXRhdHRyaWJ1dGVzJTIyJTVEJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_ACCESS_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or {type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot;},</span>
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_ACCESS_TOKEN</span>}
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_ACCESS_TOKEN</span>},
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: {<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span>}, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_ACCESS_TOKEN</span>},
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),z=new y({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),q=new T({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),A=new y({props:{title:"Building",local:"building",headingTag:"h2"}}),D=new T({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),{c(){w=r("meta"),O=t(),K=r("p"),ss=t(),d=r("p"),d.innerHTML=Rs,ls=t(),p(j.$$.fragment),as=t(),p(g.$$.fragment),ns=t(),u=r("p"),u.textContent=Ys,ts=t(),U=r("ul"),U.innerHTML=Vs,es=t(),f=r("p"),f.innerHTML=Xs,ps=t(),b=r("p"),b.textContent=vs,is=t(),Z=r("p"),Z.textContent=Hs,cs=t(),p(I.$$.fragment),Ms=t(),p(B.$$.fragment),os=t(),G=r("p"),G.textContent=xs,Js=t(),p(C.$$.fragment),rs=t(),k=r("p"),k.textContent=Fs,hs=t(),p(W.$$.fragment),ms=t(),p(Q.$$.fragment),ys=t(),$=r("p"),$.innerHTML=_s,Ts=t(),p(N.$$.fragment),ws=t(),p(S.$$.fragment),ds=t(),p(E.$$.fragment),js=t(),p(R.$$.fragment),gs=t(),Y=r("p"),Y.innerHTML=zs,us=t(),p(V.$$.fragment),Us=t(),p(X.$$.fragment),fs=t(),p(v.$$.fragment),bs=t(),p(H.$$.fragment),Zs=t(),p(x.$$.fragment),Is=t(),p(F.$$.fragment),Bs=t(),_=r("p"),_.textContent=qs,Gs=t(),p(z.$$.fragment),Cs=t(),p(q.$$.fragment),ks=t(),p(A.$$.fragment),Ws=t(),p(D.$$.fragment),Qs=t(),L=r("p"),L.innerHTML=As,$s=t(),P=r("p"),this.h()},l(s){const l=ll("svelte-u9bgzb",document.head);w=h(l,"META",{name:!0,content:!0}),l.forEach(a),O=e(s),K=h(s,"P",{}),Ds(K).forEach(a),ss=e(s),d=h(s,"P",{align:!0,"data-svelte-h":!0}),m(d)!=="svelte-8nbzva"&&(d.innerHTML=Rs),ls=e(s),i(j.$$.fragment,s),as=e(s),i(g.$$.fragment,s),ns=e(s),u=h(s,"P",{"data-svelte-h":!0}),m(u)!=="svelte-1eufct4"&&(u.textContent=Ys),ts=e(s),U=h(s,"UL",{"data-svelte-h":!0}),m(U)!=="svelte-nu4yun"&&(U.innerHTML=Vs),es=e(s),f=h(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-17i36b5"&&(f.innerHTML=Xs),ps=e(s),b=h(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-9ezgtg"&&(b.textContent=vs),is=e(s),Z=h(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1vx14v7"&&(Z.textContent=Hs),cs=e(s),i(I.$$.fragment,s),Ms=e(s),i(B.$$.fragment,s),os=e(s),G=h(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-18mxf19"&&(G.textContent=xs),Js=e(s),i(C.$$.fragment,s),rs=e(s),k=h(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1fdwpsr"&&(k.textContent=Fs),hs=e(s),i(W.$$.fragment,s),ms=e(s),i(Q.$$.fragment,s),ys=e(s),$=h(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-1td2f08"&&($.innerHTML=_s),Ts=e(s),i(N.$$.fragment,s),ws=e(s),i(S.$$.fragment,s),ds=e(s),i(E.$$.fragment,s),js=e(s),i(R.$$.fragment,s),gs=e(s),Y=h(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-mx6w21"&&(Y.innerHTML=zs),us=e(s),i(V.$$.fragment,s),Us=e(s),i(X.$$.fragment,s),fs=e(s),i(v.$$.fragment,s),bs=e(s),i(H.$$.fragment,s),Zs=e(s),i(x.$$.fragment,s),Is=e(s),i(F.$$.fragment,s),Bs=e(s),_=h(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-16qnxzd"&&(_.textContent=qs),Gs=e(s),i(z.$$.fragment,s),Cs=e(s),i(q.$$.fragment,s),ks=e(s),i(A.$$.fragment,s),Ws=e(s),i(D.$$.fragment,s),Qs=e(s),L=h(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-ymfi8c"&&(L.innerHTML=As),$s=e(s),P=h(s,"P",{}),Ds(P).forEach(a),this.h()},h(){Ss(w,"name","hf:doc:metadata"),Ss(w,"content",tl),Ss(d,"align","center")},m(s,l){al(document.head,w),n(s,O,l),n(s,K,l),n(s,ss,l),n(s,d,l),n(s,ls,l),c(j,s,l),n(s,as,l),c(g,s,l),n(s,ns,l),n(s,u,l),n(s,ts,l),n(s,U,l),n(s,es,l),n(s,f,l),n(s,ps,l),n(s,b,l),n(s,is,l),n(s,Z,l),n(s,cs,l),c(I,s,l),n(s,Ms,l),c(B,s,l),n(s,os,l),n(s,G,l),n(s,Js,l),c(C,s,l),n(s,rs,l),n(s,k,l),n(s,hs,l),c(W,s,l),n(s,ms,l),c(Q,s,l),n(s,ys,l),n(s,$,l),n(s,Ts,l),c(N,s,l),n(s,ws,l),c(S,s,l),n(s,ds,l),c(E,s,l),n(s,js,l),c(R,s,l),n(s,gs,l),n(s,Y,l),n(s,us,l),c(V,s,l),n(s,Us,l),c(X,s,l),n(s,fs,l),c(v,s,l),n(s,bs,l),c(H,s,l),n(s,Zs,l),c(x,s,l),n(s,Is,l),c(F,s,l),n(s,Bs,l),n(s,_,l),n(s,Gs,l),c(z,s,l),n(s,Cs,l),c(q,s,l),n(s,ks,l),c(A,s,l),n(s,Ws,l),c(D,s,l),n(s,Qs,l),n(s,L,l),n(s,$s,l),n(s,P,l),Ns=!0},p:Ks,i(s){Ns||(M(j.$$.fragment,s),M(g.$$.fragment,s),M(I.$$.fragment,s),M(B.$$.fragment,s),M(C.$$.fragment,s),M(W.$$.fragment,s),M(Q.$$.fragment,s),M(N.$$.fragment,s),M(S.$$.fragment,s),M(E.$$.fragment,s),M(R.$$.fragment,s),M(V.$$.fragment,s),M(X.$$.fragment,s),M(v.$$.fragment,s),M(H.$$.fragment,s),M(x.$$.fragment,s),M(F.$$.fragment,s),M(z.$$.fragment,s),M(q.$$.fragment,s),M(A.$$.fragment,s),M(D.$$.fragment,s),Ns=!0)},o(s){o(j.$$.fragment,s),o(g.$$.fragment,s),o(I.$$.fragment,s),o(B.$$.fragment,s),o(C.$$.fragment,s),o(W.$$.fragment,s),o(Q.$$.fragment,s),o(N.$$.fragment,s),o(S.$$.fragment,s),o(E.$$.fragment,s),o(R.$$.fragment,s),o(V.$$.fragment,s),o(X.$$.fragment,s),o(v.$$.fragment,s),o(H.$$.fragment,s),o(x.$$.fragment,s),o(F.$$.fragment,s),o(z.$$.fragment,s),o(q.$$.fragment,s),o(A.$$.fragment,s),o(D.$$.fragment,s),Ns=!1},d(s){s&&(a(O),a(K),a(ss),a(d),a(ls),a(as),a(ns),a(u),a(ts),a(U),a(es),a(f),a(ps),a(b),a(is),a(Z),a(cs),a(Ms),a(os),a(G),a(Js),a(rs),a(k),a(hs),a(ms),a(ys),a($),a(Ts),a(ws),a(ds),a(js),a(gs),a(Y),a(us),a(Us),a(fs),a(bs),a(Zs),a(Is),a(Bs),a(_),a(Gs),a(Cs),a(ks),a(Ws),a(Qs),a(L),a($s),a(P)),a(w),J(j,s),J(g,s),J(I,s),J(B,s),J(C,s),J(W,s),J(Q,s),J(N,s),J(S,s),J(E,s),J(R,s),J(V,s),J(X,s),J(v,s),J(H,s),J(x,s),J(F,s),J(z,s),J(q,s),J(A,s),J(D,s)}}}const tl='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/agents example","local":"huggingfaceagents-example","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function el(Es){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Os{constructor(w){super(),sl(this,w,el,nl,Ls,{})}}export{ol as component};
