import{s as os,n as cs,o as Ms}from"../chunks/scheduler.b108d059.js";import{S as ys,i as hs,g as i,s as n,r as o,A as Js,h as c,f as a,c as t,j as ps,u as M,x as G,k as is,y as ms,a as e,v as y,d as h,t as J,w as m}from"../chunks/index.008de539.js";import{C as K}from"../chunks/CodeBlock.3968c746.js";import{H as R}from"../chunks/Heading.88bfeb84.js";function Us(O){let p,W,$,Y,U,F,d,ss="Official utilities to use the Hugging Face hub API, still very experimental.",S,r,E,w,N,T,v,j,V,u,_,f,ls='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',H,b,X,g,q,I,as="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",z,C,es="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",A,Z,ns="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",x,k,L,B,ts="<li><code>hash-wasm</code> : Only used in the browser, when committing files over 10 MB. Browsers do not natively support streaming sha256 computations.</li> <li><code>type-fest</code> : Typings only</li>",D,Q,P;return U=new R({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),r=new R({props:{title:"Install",local:"install",headingTag:"h2"}}),w=new K({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),T=new R({props:{title:"Deno",local:"deno",headingTag:"h3"}}),j=new K({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),u=new R({props:{title:"Usage",local:"usage",headingTag:"h2"}}),b=new K({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFiles, deleteFile, deleteRepo, listFiles, whoAmI } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span>, <span class="hljs-title class_">Credentials</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };
<span class="hljs-keyword">const</span> <span class="hljs-attr">credentials</span>: <span class="hljs-title class_">Credentials</span> = { <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> <span class="hljs-title function_">whoAmI</span>({credentials});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> <span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, credentials})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({ repo, credentials, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFiles</span>({
  repo,
  credentials,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFile</span>({repo, credentials, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> <span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteRepo</span>({ repo, credentials });`,wrap:!1}}),g=new R({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),k=new R({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),{c(){p=i("meta"),W=n(),$=i("p"),Y=n(),o(U.$$.fragment),F=n(),d=i("p"),d.textContent=ss,S=n(),o(r.$$.fragment),E=n(),o(w.$$.fragment),N=n(),o(T.$$.fragment),v=n(),o(j.$$.fragment),V=n(),o(u.$$.fragment),_=n(),f=i("p"),f.innerHTML=ls,H=n(),o(b.$$.fragment),X=n(),o(g.$$.fragment),q=n(),I=i("p"),I.innerHTML=as,z=n(),C=i("p"),C.innerHTML=es,A=n(),Z=i("p"),Z.innerHTML=ns,x=n(),o(k.$$.fragment),L=n(),B=i("ul"),B.innerHTML=ts,D=n(),Q=i("p"),this.h()},l(s){const l=Js("svelte-u9bgzb",document.head);p=c(l,"META",{name:!0,content:!0}),l.forEach(a),W=t(s),$=c(s,"P",{}),ps($).forEach(a),Y=t(s),M(U.$$.fragment,s),F=t(s),d=c(s,"P",{"data-svelte-h":!0}),G(d)!=="svelte-1rd1r5p"&&(d.textContent=ss),S=t(s),M(r.$$.fragment,s),E=t(s),M(w.$$.fragment,s),N=t(s),M(T.$$.fragment,s),v=t(s),M(j.$$.fragment,s),V=t(s),M(u.$$.fragment,s),_=t(s),f=c(s,"P",{"data-svelte-h":!0}),G(f)!=="svelte-1nqczoz"&&(f.innerHTML=ls),H=t(s),M(b.$$.fragment,s),X=t(s),M(g.$$.fragment,s),q=t(s),I=c(s,"P",{"data-svelte-h":!0}),G(I)!=="svelte-1gspubq"&&(I.innerHTML=as),z=t(s),C=c(s,"P",{"data-svelte-h":!0}),G(C)!=="svelte-em0etc"&&(C.innerHTML=es),A=t(s),Z=c(s,"P",{"data-svelte-h":!0}),G(Z)!=="svelte-lja874"&&(Z.innerHTML=ns),x=t(s),M(k.$$.fragment,s),L=t(s),B=c(s,"UL",{"data-svelte-h":!0}),G(B)!=="svelte-cfwqb4"&&(B.innerHTML=ts),D=t(s),Q=c(s,"P",{}),ps(Q).forEach(a),this.h()},h(){is(p,"name","hf:doc:metadata"),is(p,"content",ds)},m(s,l){ms(document.head,p),e(s,W,l),e(s,$,l),e(s,Y,l),y(U,s,l),e(s,F,l),e(s,d,l),e(s,S,l),y(r,s,l),e(s,E,l),y(w,s,l),e(s,N,l),y(T,s,l),e(s,v,l),y(j,s,l),e(s,V,l),y(u,s,l),e(s,_,l),e(s,f,l),e(s,H,l),y(b,s,l),e(s,X,l),y(g,s,l),e(s,q,l),e(s,I,l),e(s,z,l),e(s,C,l),e(s,A,l),e(s,Z,l),e(s,x,l),y(k,s,l),e(s,L,l),e(s,B,l),e(s,D,l),e(s,Q,l),P=!0},p:cs,i(s){P||(h(U.$$.fragment,s),h(r.$$.fragment,s),h(w.$$.fragment,s),h(T.$$.fragment,s),h(j.$$.fragment,s),h(u.$$.fragment,s),h(b.$$.fragment,s),h(g.$$.fragment,s),h(k.$$.fragment,s),P=!0)},o(s){J(U.$$.fragment,s),J(r.$$.fragment,s),J(w.$$.fragment,s),J(T.$$.fragment,s),J(j.$$.fragment,s),J(u.$$.fragment,s),J(b.$$.fragment,s),J(g.$$.fragment,s),J(k.$$.fragment,s),P=!1},d(s){s&&(a(W),a($),a(Y),a(F),a(d),a(S),a(E),a(N),a(v),a(V),a(_),a(f),a(H),a(X),a(q),a(I),a(z),a(C),a(A),a(Z),a(x),a(L),a(B),a(D),a(Q)),a(p),m(U,s),m(r,s),m(w,s),m(T,s),m(j,s),m(u,s),m(b,s),m(g,s),m(k,s)}}}const ds='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function rs(O){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends ys{constructor(p){super(),hs(this,p,rs,Us,os,{})}}export{fs as component};
