import{s as Ys,n as Ws,o as Ks}from"../chunks/scheduler.7da89386.js";import{S as Qs,i as Js,g as r,s,r as g,A as Xs,h as i,f as a,c as n,j as u,u as m,x as _,k as v,y as e,a as o,v as d,d as p,t as c,w as h}from"../chunks/index.20910acc.js";import{D as f}from"../chunks/Docstring.ed6eb432.js";import{H as Z,E as Zs}from"../chunks/index.3af8f81c.js";function tn(ps){let D,Te,ye,we,tt,Ce,et,Le,at,De,R,st,$a,At,cs="Stored configuration of a given <code>LightevalTask</code>.",Re,nt,Ie,k,rt,ba,z,it,xa,Bt,hs=`Return a dict with metric name and its aggregation function for all
metrics`,ya,U,lt,qa,jt,us="Constructs a list of requests from the task based on the given parameters.",Ta,O,ot,wa,Yt,vs="Returns the evaluation documents.",Ca,F,gt,La,Wt,fs=`Returns the few shot documents. If the few shot documents are not
available, it gets them from the few shot split or the evaluation split.`,Da,S,mt,Ra,Kt,_s=`Parses the possible fewshot split keys in order: train, then validation
keys and matches them with the available keys.  Returns the first
available.`,Ia,H,dt,Ea,Qt,ks="Load datasets from the HuggingFace Hub for the given tasks.",Ee,pt,Pe,y,ct,Pa,A,ht,Na,Jt,$s=`In some cases, when selecting few-shot samples, we want to use specific document classes
which need to be specified separately from the target.
For example, a document where the gold is a json might want to use only one of the keys of
the json to define sorting classes in few shot samples. Else we take the gold.`,Ga,B,ut,Va,Xt,bs="Returns the target of the given document.",Ma,j,vt,za,Zt,xs=`Returns the query of the document without the instructions. If the
document has instructions, it removes them from the query:`,Ne,ft,Ge,$,_t,Ua,te,ys="The Registry class is used to manage the task registry and get task classes.",Oa,ee,kt,Fa,q,$t,Sa,ae,qs="Get a dictionary of tasks based on the task name list (suite|task).",Ha,se,Ts="Notes:",Aa,ne,ws="<li>Each task in the task_name_list will be instantiated with the corresponding task class.</li>",Ba,Y,bt,ja,re,Cs="Get the task class based on the task name (suite|task).",Ya,W,xt,Wa,ie,Ls="Print all the tasks in the task registry.",Ve,yt,Me,I,qt,Ka,le,Ds=`Represents a request for a specific task, example and request within that
example in the evaluation process.
For example in the task “boolq”, the example “Is the sun hot?” and the
requests for that example “Is the sun hot? Yes” and “Is the sun hot? No”.`,ze,E,Tt,Qa,oe,Rs="Represents a request for log-likelihood evaluation.",Ue,P,wt,Ja,ge,Is=`Represents a request for calculating the log-likelihood of a single token.
Faster because we can get all the loglikelihoods in one pass.`,Oe,w,Ct,Xa,me,Es="Represents a request for log-likelihood rolling evaluation.",Za,de,Ps="Inherits from the base Request class.",Fe,N,Lt,ts,pe,Ns="Represents a request for generating text using the Greedy-Until algorithm.",Se,G,Dt,es,ce,Gs="Represents a request for generating text using the Greedy-Until algorithm.",He,Rt,Ae,C,It,as,K,Et,ss,he,Vs="Get the original order of the data.",ns,Q,Pt,rs,ue,Ms="Iterator that yields the dataset splits based on the split limits.",Be,Nt,Gt,je,Vt,Mt,Ye,V,zt,is,b,Ut,ls,ve,zs=`Initialises the split limits based on generation parameters.
The splits are used to estimate time remaining when evaluating, and in the case of generative evaluations, to group similar samples together.`,os,fe,Us="For generative tasks, self._sorting_criteria outputs:",gs,_e,Os="<li>a boolean (whether the generation task uses logits)</li> <li>a list (the stop sequences)</li> <li>the item length (the actual size sorting factor).</li>",ms,ke,Fs=`In the current function, we create evaluation groups by generation parameters (logits and eos), so that samples with similar properties get batched together afterwards.
The samples will then be further organised by length in each split.`,We,Ot,Ft,Ke,M,St,ds,$e,Ss=`A distributed sampler that copy the last element only when drop_last is False so we keep a small padding in the batches
as our samples are sorted by length.`,Qe,Ht,Je,qe,Xe;return tt=new Z({props:{title:"Tasks",local:"tasks",headingTag:"h1"}}),et=new Z({props:{title:"LightevalTask",local:"lightevaltask",headingTag:"h2"}}),at=new Z({props:{title:"LightevalTaskConfig",local:"lighteval.tasks.lighteval_task.LightevalTaskConfig",headingTag:"h3"}}),st=new f({props:{name:"class lighteval.tasks.lighteval_task.LightevalTaskConfig",anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig",parameters:[{name:"name",val:": str"},{name:"prompt_function",val:": typing.Callable[[dict, str], lighteval.tasks.requests.Doc | None]"},{name:"hf_repo",val:": str"},{name:"hf_subset",val:": str"},{name:"metric",val:": list[lighteval.metrics.utils.metric_utils.Metric | lighteval.metrics.metrics.Metrics] | tuple[lighteval.metrics.utils.metric_utils.Metric | lighteval.metrics.metrics.Metrics, ...]"},{name:"hf_revision",val:": typing.Optional[str] = None"},{name:"hf_filter",val:": typing.Optional[typing.Callable[[dict], bool]] = None"},{name:"hf_avail_splits",val:": typing.Union[list[str], tuple[str, ...], NoneType] = <factory>"},{name:"trust_dataset",val:": bool = False"},{name:"evaluation_splits",val:": list[str] | tuple[str, ...] = <factory>"},{name:"few_shots_split",val:": typing.Optional[str] = None"},{name:"few_shots_select",val:": typing.Optional[str] = None"},{name:"generation_size",val:": typing.Optional[int] = None"},{name:"generation_grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"stop_sequence",val:": typing.Union[list[str], tuple[str, ...], NoneType] = None"},{name:"num_samples",val:": typing.Optional[list[int]] = None"},{name:"suite",val:": list[str] | tuple[str, ...] = <factory>"},{name:"original_num_docs",val:": int = -1"},{name:"effective_num_docs",val:": int = -1"},{name:"must_remove_duplicate_docs",val:": bool = False"},{name:"version",val:": int = 0"}],parametersDescription:[{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.name",description:"<strong>name</strong> (str) &#x2014; Short name of the evaluation task.",name:"name"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.suite",description:"<strong>suite</strong> (list[str]) &#x2014; Evaluation suites to which the task belongs.",name:"suite"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.prompt_function",description:"<strong>prompt_function</strong> (Callable[[dict, str], Doc]) &#x2014; Function used to create the <code>Doc</code> samples from each line of the evaluation dataset.",name:"prompt_function"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.hf_repo",description:"<strong>hf_repo</strong> (str) &#x2014; Path of the hub dataset repository containing the evaluation information.",name:"hf_repo"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.hf_subset",description:"<strong>hf_subset</strong> (str) &#x2014; Subset used for the current task, will be default if none is selected.",name:"hf_subset"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.hf_avail_splits",description:"<strong>hf_avail_splits</strong> (list[str]) &#x2014; All the available splits in the evaluation dataset",name:"hf_avail_splits"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.evaluation_splits",description:"<strong>evaluation_splits</strong> (list[str]) &#x2014; List of the splits actually used for this evaluation",name:"evaluation_splits"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.few_shots_split",description:"<strong>few_shots_split</strong> (str) &#x2014; Name of the split from which to sample few-shot examples",name:"few_shots_split"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.few_shots_select",description:"<strong>few_shots_select</strong> (str) &#x2014; Method with which to sample few-shot examples",name:"few_shots_select"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.generation_size",description:"<strong>generation_size</strong> (int) &#x2014; Maximum allowed size of the generation",name:"generation_size"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.generation_grammar",description:"<strong>generation_grammar</strong> (TextGenerationInputGrammarType) &#x2014; The grammar to generate completion according to. Currently only available for TGI and Inference Endpoint models.",name:"generation_grammar"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.metric",description:"<strong>metric</strong> (list[str]) &#x2014; List of all the metrics for the current task.",name:"metric"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.stop_sequence",description:"<strong>stop_sequence</strong> (list[str]) &#x2014; Stop sequence which interrupts the generation for generative metrics.",name:"stop_sequence"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.original_num_docs",description:"<strong>original_num_docs</strong> (int) &#x2014; Number of documents in the task",name:"original_num_docs"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.effective_num_docs",description:"<strong>effective_num_docs</strong> (int) &#x2014; Number of documents used in a specific evaluation",name:"effective_num_docs"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.truncated_num_docs",description:"<strong>truncated_num_docs</strong> (bool) &#x2014; Whether less than the total number of documents were used",name:"truncated_num_docs"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.trust_dataset",description:"<strong>trust_dataset</strong> (bool) &#x2014; Whether to trust the dataset at execution or not",name:"trust_dataset"},{anchor:"lighteval.tasks.lighteval_task.LightevalTaskConfig.version",description:"<strong>version</strong> (int) &#x2014; The version of the task. Defaults to 0. Can be increased if the underlying dataset or the prompt changes.",name:"version"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/lighteval_task.py#L66"}}),nt=new Z({props:{title:"LightevalTask",local:"lighteval.tasks.lighteval_task.LightevalTask",headingTag:"h3"}}),rt=new f({props:{name:"class lighteval.tasks.lighteval_task.LightevalTask",anchor:"lighteval.tasks.lighteval_task.LightevalTask",parameters:[{name:"name",val:": str"},{name:"cfg",val:": LightevalTaskConfig"},{name:"cache_dir",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/lighteval_task.py#L161"}}),it=new f({props:{name:"aggregation",anchor:"lighteval.tasks.lighteval_task.LightevalTask.aggregation",parameters:[],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/lighteval_task.py#L525"}}),lt=new f({props:{name:"construct_requests",anchor:"lighteval.tasks.lighteval_task.LightevalTask.construct_requests",parameters:[{name:"formatted_doc",val:": Doc"},{name:"context",val:": str"},{name:"document_id_seed",val:": str"},{name:"current_task_name",val:": str"}],parametersDescription:[{anchor:"lighteval.tasks.lighteval_task.LightevalTask.construct_requests.formatted_doc",description:"<strong>formatted_doc</strong> (Doc) &#x2014; Formatted document almost straight from the dataset.",name:"formatted_doc"},{anchor:"lighteval.tasks.lighteval_task.LightevalTask.construct_requests.ctx",description:"<strong>ctx</strong> (str) &#x2014; Context, which is the few shot examples + the query.",name:"ctx"},{anchor:"lighteval.tasks.lighteval_task.LightevalTask.construct_requests.document_id_seed",description:"<strong>document_id_seed</strong> (str) &#x2014; Index of the document in the task appended with the seed used for the few shot sampling.",name:"document_id_seed"},{anchor:"lighteval.tasks.lighteval_task.LightevalTask.construct_requests.current_task_name",description:"<strong>current_task_name</strong> (str) &#x2014; Name of the current task.",name:"current_task_name"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/lighteval_task.py#L340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of requests.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>dict[RequestType, List[Request]]</p>
`}}),ot=new f({props:{name:"eval_docs",anchor:"lighteval.tasks.lighteval_task.LightevalTask.eval_docs",parameters:[],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/lighteval_task.py#L327",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Evaluation documents.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list[Doc]</p>
`}}),gt=new f({props:{name:"fewshot_docs",anchor:"lighteval.tasks.lighteval_task.LightevalTask.fewshot_docs",parameters:[],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/lighteval_task.py#L308",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Documents that will be used for few shot examples. One
document = one few shot example.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list[Doc]</p>
`}}),mt=new f({props:{name:"get_first_possible_fewshot_splits",anchor:"lighteval.tasks.lighteval_task.LightevalTask.get_first_possible_fewshot_splits",parameters:[{name:"available_splits",val:": list[str] | tuple[str, ...]"},{name:"number_of_splits",val:": int = 1"}],parametersDescription:[{anchor:"lighteval.tasks.lighteval_task.LightevalTask.get_first_possible_fewshot_splits.number_of_splits",description:`<strong>number_of_splits</strong> (int, optional) &#x2014; Number of splits to return.
Defaults to 1.`,name:"number_of_splits"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/lighteval_task.py#L231",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of the first available fewshot splits.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list[str]</p>
`}}),dt=new f({props:{name:"load_datasets",anchor:"lighteval.tasks.lighteval_task.LightevalTask.load_datasets",parameters:[{name:"tasks",val:": list"},{name:"dataset_loading_processes",val:": int = 1"}],parametersDescription:[{anchor:"lighteval.tasks.lighteval_task.LightevalTask.load_datasets.tasks",description:"<strong>tasks</strong> (list) &#x2014; A list of tasks.",name:"tasks"},{anchor:"lighteval.tasks.lighteval_task.LightevalTask.load_datasets.dataset_loading_processes",description:"<strong>dataset_loading_processes</strong> (int, optional) &#x2014; number of processes to use for dataset loading. Defaults to 1.",name:"dataset_loading_processes"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/lighteval_task.py#L532",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>None</p>
`}}),pt=new Z({props:{title:"PromptManager",local:"lighteval.tasks.prompt_manager.PromptManager",headingTag:"h2"}}),ct=new f({props:{name:"class lighteval.tasks.prompt_manager.PromptManager",anchor:"lighteval.tasks.prompt_manager.PromptManager",parameters:[{name:"task",val:": LightevalTask"},{name:"lm",val:": LightevalModel"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/prompt_manager.py#L45"}}),ht=new f({props:{name:"doc_to_fewshot_sorting_class",anchor:"lighteval.tasks.prompt_manager.PromptManager.doc_to_fewshot_sorting_class",parameters:[{name:"formatted_doc",val:": Doc"}],parametersDescription:[{anchor:"lighteval.tasks.prompt_manager.PromptManager.doc_to_fewshot_sorting_class.formatted_doc",description:"<strong>formatted_doc</strong> (Doc) &#x2014; Formatted document.",name:"formatted_doc"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/prompt_manager.py#L85",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Class of the fewshot document</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`}}),ut=new f({props:{name:"doc_to_target",anchor:"lighteval.tasks.prompt_manager.PromptManager.doc_to_target",parameters:[{name:"formatted_doc",val:": Doc"}],parametersDescription:[{anchor:"lighteval.tasks.prompt_manager.PromptManager.doc_to_target.formatted_doc",description:"<strong>formatted_doc</strong> (Doc) &#x2014; Formatted document.",name:"formatted_doc"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/prompt_manager.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Target of the document, which is the correct answer for a document.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`}}),vt=new f({props:{name:"doc_to_text",anchor:"lighteval.tasks.prompt_manager.PromptManager.doc_to_text",parameters:[{name:"doc",val:": Doc"},{name:"return_instructions",val:": bool = False"}],parametersDescription:[{anchor:"lighteval.tasks.prompt_manager.PromptManager.doc_to_text.doc",description:`<strong>doc</strong> (Doc) &#x2014; document class, containing the query and the
instructions.`,name:"doc"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/prompt_manager.py#L51",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Query of the document without the instructions.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`}}),ft=new Z({props:{title:"Registry",local:"lighteval.tasks.registry.Registry",headingTag:"h2"}}),_t=new f({props:{name:"class lighteval.tasks.registry.Registry",anchor:"lighteval.tasks.registry.Registry",parameters:[{name:"cache_dir",val:": typing.Optional[str] = None"},{name:"custom_tasks",val:": typing.Union[str, pathlib.Path, module, NoneType] = None"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/registry.py#L68"}}),kt=new f({props:{name:"expand_task_definition",anchor:"lighteval.tasks.registry.Registry.expand_task_definition",parameters:[{name:"task_definition",val:": str"}],parametersDescription:[{anchor:"lighteval.tasks.registry.Registry.expand_task_definition.task_definition",description:`<strong>task_definition</strong> (str) &#x2014; Task definition to expand. In format:<ul>
<li>suite|task</li>
<li>suite|task_superset (e.g lighteval|mmlu, which runs all the mmlu subtasks)</li>
</ul>`,name:"task_definition"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/registry.py#L215",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of task names (suite|task)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list[str]</p>
`}}),$t=new f({props:{name:"get_task_dict",anchor:"lighteval.tasks.registry.Registry.get_task_dict",parameters:[{name:"task_names",val:": list"}],parametersDescription:[{anchor:"lighteval.tasks.registry.Registry.get_task_dict.task_name_list",description:"<strong>task_name_list</strong> (List[str]) &#x2014; A list of task names (suite|task).",name:"task_name_list"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/registry.py#L199",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dict[str, LightevalTask]</p>
`}}),bt=new f({props:{name:"get_task_instance",anchor:"lighteval.tasks.registry.Registry.get_task_instance",parameters:[{name:"task_name",val:": str"}],parametersDescription:[{anchor:"lighteval.tasks.registry.Registry.get_task_instance.task_name",description:"<strong>task_name</strong> (str) &#x2014; Name of the task (suite|task).",name:"task_name"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/registry.py#L95",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Task class.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>LightevalTask</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If the task is not found in the task registry or custom task registry.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),xt=new f({props:{name:"print_all_tasks",anchor:"lighteval.tasks.registry.Registry.print_all_tasks",parameters:[],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/registry.py#L233"}}),yt=new Z({props:{title:"Requests",local:"lighteval.tasks.requests.Request",headingTag:"h2"}}),qt=new f({props:{name:"class lighteval.tasks.requests.Request",anchor:"lighteval.tasks.requests.Request",parameters:[{name:"task_name",val:": str"},{name:"sample_index",val:": int"},{name:"request_index",val:": int"},{name:"context",val:": str"},{name:"metric_categories",val:": list"}],parametersDescription:[{anchor:"lighteval.tasks.requests.Request.task_name",description:"<strong>task_name</strong> (str) &#x2014; The name of the task.",name:"task_name"},{anchor:"lighteval.tasks.requests.Request.sample_index",description:"<strong>sample_index</strong> (int) &#x2014; The index of the example.",name:"sample_index"},{anchor:"lighteval.tasks.requests.Request.request_index",description:"<strong>request_index</strong> (int) &#x2014; The index of the request.",name:"request_index"},{anchor:"lighteval.tasks.requests.Request.context",description:"<strong>context</strong> (str) &#x2014; The context for the request.",name:"context"},{anchor:"lighteval.tasks.requests.Request.metric_categories",description:"<strong>metric_categories</strong> (list[MetricCategory]) &#x2014; All the metric categories which concern this request",name:"metric_categories"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/requests.py#L41"}}),Tt=new f({props:{name:"class lighteval.tasks.requests.LoglikelihoodRequest",anchor:"lighteval.tasks.requests.LoglikelihoodRequest",parameters:[{name:"task_name",val:": str"},{name:"sample_index",val:": int"},{name:"request_index",val:": int"},{name:"context",val:": str"},{name:"metric_categories",val:": list"},{name:"choice",val:": str"},{name:"tokenized_context",val:": list = None"},{name:"tokenized_continuation",val:": list = None"}],parametersDescription:[{anchor:"lighteval.tasks.requests.LoglikelihoodRequest.choice",description:"<strong>choice</strong> (str) &#x2014; The choice to evaluate the log-likelihood for.",name:"choice"},{anchor:"lighteval.tasks.requests.LoglikelihoodRequest.request_type",description:"<strong>request_type</strong> (RequestType) &#x2014; The type of the request (LOGLIKELIHOOD).",name:"request_type"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/requests.py#L64"}}),wt=new f({props:{name:"class lighteval.tasks.requests.LoglikelihoodSingleTokenRequest",anchor:"lighteval.tasks.requests.LoglikelihoodSingleTokenRequest",parameters:[{name:"task_name",val:": str"},{name:"sample_index",val:": int"},{name:"request_index",val:": int"},{name:"context",val:": str"},{name:"metric_categories",val:": list"},{name:"choices",val:": list"},{name:"tokenized_context",val:": list = None"},{name:"tokenized_continuation",val:": list = None"}],parametersDescription:[{anchor:"lighteval.tasks.requests.LoglikelihoodSingleTokenRequest.choices",description:"<strong>choices</strong> (list[str]) &#x2014; The list of token choices.",name:"choices"},{anchor:"lighteval.tasks.requests.LoglikelihoodSingleTokenRequest.request_type",description:"<strong>request_type</strong> (RequestType) &#x2014; The type of the request.",name:"request_type"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/requests.py#L80"}}),Ct=new f({props:{name:"class lighteval.tasks.requests.LoglikelihoodRollingRequest",anchor:"lighteval.tasks.requests.LoglikelihoodRollingRequest",parameters:[{name:"task_name",val:": str"},{name:"sample_index",val:": int"},{name:"request_index",val:": int"},{name:"context",val:": str"},{name:"metric_categories",val:": list"},{name:"tokenized_context",val:": list = None"},{name:"tokenized_continuation",val:": list = None"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/requests.py#L97"}}),Lt=new f({props:{name:"class lighteval.tasks.requests.GreedyUntilRequest",anchor:"lighteval.tasks.requests.GreedyUntilRequest",parameters:[{name:"task_name",val:": str"},{name:"sample_index",val:": int"},{name:"request_index",val:": int"},{name:"context",val:": str"},{name:"metric_categories",val:": list"},{name:"stop_sequence",val:": typing.Union[str, tuple[str], list[str]]"},{name:"generation_size",val:": typing.Optional[int]"},{name:"generation_grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"tokenized_context",val:": list = None"},{name:"num_samples",val:": int = None"},{name:"do_sample",val:": bool = False"},{name:"use_logits",val:": bool = False"}],parametersDescription:[{anchor:"lighteval.tasks.requests.GreedyUntilRequest.stop_sequence",description:"<strong>stop_sequence</strong> (str) &#x2014; The sequence of tokens that indicates when to stop generating text.",name:"stop_sequence"},{anchor:"lighteval.tasks.requests.GreedyUntilRequest.generation_size",description:"<strong>generation_size</strong> (int) &#x2014; The maximum number of tokens to generate.",name:"generation_size"},{anchor:"lighteval.tasks.requests.GreedyUntilRequest.generation_grammar",description:`<strong>generation_grammar</strong> (TextGenerationInputGrammarType) &#x2014; The grammar to generate completion according to.
Currently only available for TGI models.`,name:"generation_grammar"},{anchor:"lighteval.tasks.requests.GreedyUntilRequest.request_type",description:"<strong>request_type</strong> (RequestType) &#x2014; The type of the request, set to RequestType.GREEDY_UNTIL.",name:"request_type"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/requests.py#L110"}}),Dt=new f({props:{name:"class lighteval.tasks.requests.GreedyUntilMultiTurnRequest",anchor:"lighteval.tasks.requests.GreedyUntilMultiTurnRequest",parameters:[{name:"task_name",val:": str"},{name:"sample_index",val:": int"},{name:"request_index",val:": int"},{name:"context",val:": str"},{name:"metric_categories",val:": list"},{name:"stop_sequence",val:": str"},{name:"generation_size",val:": int"},{name:"use_logits",val:": bool = False"}],parametersDescription:[{anchor:"lighteval.tasks.requests.GreedyUntilMultiTurnRequest.stop_sequence",description:"<strong>stop_sequence</strong> (str) &#x2014; The sequence of tokens that indicates when to stop generating text.",name:"stop_sequence"},{anchor:"lighteval.tasks.requests.GreedyUntilMultiTurnRequest.generation_size",description:"<strong>generation_size</strong> (int) &#x2014; The maximum number of tokens to generate.",name:"generation_size"},{anchor:"lighteval.tasks.requests.GreedyUntilMultiTurnRequest.request_type",description:"<strong>request_type</strong> (RequestType) &#x2014; The type of the request, set to RequestType.GREEDY_UNTIL.",name:"request_type"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/tasks/requests.py#L133"}}),Rt=new Z({props:{title:"Datasets",local:"lighteval.data.DynamicBatchDataset",headingTag:"h2"}}),It=new f({props:{name:"class lighteval.data.DynamicBatchDataset",anchor:"lighteval.data.DynamicBatchDataset",parameters:[{name:"requests",val:": list"},{name:"num_dataset_splits",val:": int"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L50"}}),Et=new f({props:{name:"get_original_order",anchor:"lighteval.data.DynamicBatchDataset.get_original_order",parameters:[{name:"new_arr",val:": list"}],parametersDescription:[{anchor:"lighteval.data.DynamicBatchDataset.get_original_order.newarr",description:`<strong>newarr</strong> (list) &#x2014; Array containing any kind of data that needs to be
reset in the original order.`,name:"newarr"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L99",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>new_arr in the original order.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list</p>
`}}),Pt=new f({props:{name:"splits_iterator",anchor:"lighteval.data.DynamicBatchDataset.splits_iterator",parameters:[],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L122",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Subset</p>
`,isYield:!0}}),Gt=new f({props:{name:"class lighteval.data.LoglikelihoodDataset",anchor:"lighteval.data.LoglikelihoodDataset",parameters:[{name:"requests",val:": list"},{name:"num_dataset_splits",val:": int"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L177"}}),Mt=new f({props:{name:"class lighteval.data.LoglikelihoodSingleTokenDataset",anchor:"lighteval.data.LoglikelihoodSingleTokenDataset",parameters:[{name:"requests",val:": list"},{name:"num_dataset_splits",val:": int"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L202"}}),zt=new f({props:{name:"class lighteval.data.GenerativeTaskDataset",anchor:"lighteval.data.GenerativeTaskDataset",parameters:[{name:"requests",val:": list"},{name:"num_dataset_splits",val:": int"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L221"}}),Ut=new f({props:{name:"init_split_limits",anchor:"lighteval.data.GenerativeTaskDataset.init_split_limits",parameters:[{name:"num_dataset_splits",val:""}],parametersDescription:[{anchor:"lighteval.data.GenerativeTaskDataset.init_split_limits.num_dataset_splits",description:"<strong>num_dataset_splits</strong> (<em>type</em>) &#x2014; <em>description</em>",name:"num_dataset_splits"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L222",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>description</em></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>type</em></p>
`}}),Ft=new f({props:{name:"class lighteval.data.GenerativeTaskDatasetNanotron",anchor:"lighteval.data.GenerativeTaskDatasetNanotron",parameters:[{name:"requests",val:": list"},{name:"num_dataset_splits",val:": int"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L287"}}),St=new f({props:{name:"class lighteval.data.GenDistributedSampler",anchor:"lighteval.data.GenDistributedSampler",parameters:[{name:"dataset",val:": Dataset"},{name:"num_replicas",val:": typing.Optional[int] = None"},{name:"rank",val:": typing.Optional[int] = None"},{name:"shuffle",val:": bool = True"},{name:"seed",val:": int = 0"},{name:"drop_last",val:": bool = False"}],source:"https://github.com/huggingface/lighteval/blob/v0.9.0/src/lighteval/data.py#L304"}}),Ht=new Zs({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/package_reference/tasks.mdx"}}),{c(){D=r("meta"),Te=s(),ye=r("p"),we=s(),g(tt.$$.fragment),Ce=s(),g(et.$$.fragment),Le=s(),g(at.$$.fragment),De=s(),R=r("div"),g(st.$$.fragment),$a=s(),At=r("p"),At.innerHTML=cs,Re=s(),g(nt.$$.fragment),Ie=s(),k=r("div"),g(rt.$$.fragment),ba=s(),z=r("div"),g(it.$$.fragment),xa=s(),Bt=r("p"),Bt.textContent=hs,ya=s(),U=r("div"),g(lt.$$.fragment),qa=s(),jt=r("p"),jt.textContent=us,Ta=s(),O=r("div"),g(ot.$$.fragment),wa=s(),Yt=r("p"),Yt.textContent=vs,Ca=s(),F=r("div"),g(gt.$$.fragment),La=s(),Wt=r("p"),Wt.textContent=fs,Da=s(),S=r("div"),g(mt.$$.fragment),Ra=s(),Kt=r("p"),Kt.textContent=_s,Ia=s(),H=r("div"),g(dt.$$.fragment),Ea=s(),Qt=r("p"),Qt.textContent=ks,Ee=s(),g(pt.$$.fragment),Pe=s(),y=r("div"),g(ct.$$.fragment),Pa=s(),A=r("div"),g(ht.$$.fragment),Na=s(),Jt=r("p"),Jt.textContent=$s,Ga=s(),B=r("div"),g(ut.$$.fragment),Va=s(),Xt=r("p"),Xt.textContent=bs,Ma=s(),j=r("div"),g(vt.$$.fragment),za=s(),Zt=r("p"),Zt.textContent=xs,Ne=s(),g(ft.$$.fragment),Ge=s(),$=r("div"),g(_t.$$.fragment),Ua=s(),te=r("p"),te.textContent=ys,Oa=s(),ee=r("div"),g(kt.$$.fragment),Fa=s(),q=r("div"),g($t.$$.fragment),Sa=s(),ae=r("p"),ae.textContent=qs,Ha=s(),se=r("p"),se.textContent=Ts,Aa=s(),ne=r("ul"),ne.innerHTML=ws,Ba=s(),Y=r("div"),g(bt.$$.fragment),ja=s(),re=r("p"),re.textContent=Cs,Ya=s(),W=r("div"),g(xt.$$.fragment),Wa=s(),ie=r("p"),ie.textContent=Ls,Ve=s(),g(yt.$$.fragment),Me=s(),I=r("div"),g(qt.$$.fragment),Ka=s(),le=r("p"),le.textContent=Ds,ze=s(),E=r("div"),g(Tt.$$.fragment),Qa=s(),oe=r("p"),oe.textContent=Rs,Ue=s(),P=r("div"),g(wt.$$.fragment),Ja=s(),ge=r("p"),ge.textContent=Is,Oe=s(),w=r("div"),g(Ct.$$.fragment),Xa=s(),me=r("p"),me.textContent=Es,Za=s(),de=r("p"),de.textContent=Ps,Fe=s(),N=r("div"),g(Lt.$$.fragment),ts=s(),pe=r("p"),pe.textContent=Ns,Se=s(),G=r("div"),g(Dt.$$.fragment),es=s(),ce=r("p"),ce.textContent=Gs,He=s(),g(Rt.$$.fragment),Ae=s(),C=r("div"),g(It.$$.fragment),as=s(),K=r("div"),g(Et.$$.fragment),ss=s(),he=r("p"),he.textContent=Vs,ns=s(),Q=r("div"),g(Pt.$$.fragment),rs=s(),ue=r("p"),ue.textContent=Ms,Be=s(),Nt=r("div"),g(Gt.$$.fragment),je=s(),Vt=r("div"),g(Mt.$$.fragment),Ye=s(),V=r("div"),g(zt.$$.fragment),is=s(),b=r("div"),g(Ut.$$.fragment),ls=s(),ve=r("p"),ve.textContent=zs,os=s(),fe=r("p"),fe.textContent=Us,gs=s(),_e=r("ul"),_e.innerHTML=Os,ms=s(),ke=r("p"),ke.textContent=Fs,We=s(),Ot=r("div"),g(Ft.$$.fragment),Ke=s(),M=r("div"),g(St.$$.fragment),ds=s(),$e=r("p"),$e.textContent=Ss,Qe=s(),g(Ht.$$.fragment),Je=s(),qe=r("p"),this.h()},l(t){const l=Xs("svelte-u9bgzb",document.head);D=i(l,"META",{name:!0,content:!0}),l.forEach(a),Te=n(t),ye=i(t,"P",{}),u(ye).forEach(a),we=n(t),m(tt.$$.fragment,t),Ce=n(t),m(et.$$.fragment,t),Le=n(t),m(at.$$.fragment,t),De=n(t),R=i(t,"DIV",{class:!0});var Ze=u(R);m(st.$$.fragment,Ze),$a=n(Ze),At=i(Ze,"P",{"data-svelte-h":!0}),_(At)!=="svelte-1detw9o"&&(At.innerHTML=cs),Ze.forEach(a),Re=n(t),m(nt.$$.fragment,t),Ie=n(t),k=i(t,"DIV",{class:!0});var x=u(k);m(rt.$$.fragment,x),ba=n(x),z=i(x,"DIV",{class:!0});var ta=u(z);m(it.$$.fragment,ta),xa=n(ta),Bt=i(ta,"P",{"data-svelte-h":!0}),_(Bt)!=="svelte-e3kmxq"&&(Bt.textContent=hs),ta.forEach(a),ya=n(x),U=i(x,"DIV",{class:!0});var ea=u(U);m(lt.$$.fragment,ea),qa=n(ea),jt=i(ea,"P",{"data-svelte-h":!0}),_(jt)!=="svelte-1ahzpty"&&(jt.textContent=us),ea.forEach(a),Ta=n(x),O=i(x,"DIV",{class:!0});var aa=u(O);m(ot.$$.fragment,aa),wa=n(aa),Yt=i(aa,"P",{"data-svelte-h":!0}),_(Yt)!=="svelte-qytfqy"&&(Yt.textContent=vs),aa.forEach(a),Ca=n(x),F=i(x,"DIV",{class:!0});var sa=u(F);m(gt.$$.fragment,sa),La=n(sa),Wt=i(sa,"P",{"data-svelte-h":!0}),_(Wt)!=="svelte-1y4eieh"&&(Wt.textContent=fs),sa.forEach(a),Da=n(x),S=i(x,"DIV",{class:!0});var na=u(S);m(mt.$$.fragment,na),Ra=n(na),Kt=i(na,"P",{"data-svelte-h":!0}),_(Kt)!=="svelte-1283lse"&&(Kt.textContent=_s),na.forEach(a),Ia=n(x),H=i(x,"DIV",{class:!0});var ra=u(H);m(dt.$$.fragment,ra),Ea=n(ra),Qt=i(ra,"P",{"data-svelte-h":!0}),_(Qt)!=="svelte-sf66t8"&&(Qt.textContent=ks),ra.forEach(a),x.forEach(a),Ee=n(t),m(pt.$$.fragment,t),Pe=n(t),y=i(t,"DIV",{class:!0});var J=u(y);m(ct.$$.fragment,J),Pa=n(J),A=i(J,"DIV",{class:!0});var ia=u(A);m(ht.$$.fragment,ia),Na=n(ia),Jt=i(ia,"P",{"data-svelte-h":!0}),_(Jt)!=="svelte-rvzqqg"&&(Jt.textContent=$s),ia.forEach(a),Ga=n(J),B=i(J,"DIV",{class:!0});var la=u(B);m(ut.$$.fragment,la),Va=n(la),Xt=i(la,"P",{"data-svelte-h":!0}),_(Xt)!=="svelte-tgn2zx"&&(Xt.textContent=bs),la.forEach(a),Ma=n(J),j=i(J,"DIV",{class:!0});var oa=u(j);m(vt.$$.fragment,oa),za=n(oa),Zt=i(oa,"P",{"data-svelte-h":!0}),_(Zt)!=="svelte-7cxfms"&&(Zt.textContent=xs),oa.forEach(a),J.forEach(a),Ne=n(t),m(ft.$$.fragment,t),Ge=n(t),$=i(t,"DIV",{class:!0});var T=u($);m(_t.$$.fragment,T),Ua=n(T),te=i(T,"P",{"data-svelte-h":!0}),_(te)!=="svelte-2fh3bo"&&(te.textContent=ys),Oa=n(T),ee=i(T,"DIV",{class:!0});var Hs=u(ee);m(kt.$$.fragment,Hs),Hs.forEach(a),Fa=n(T),q=i(T,"DIV",{class:!0});var X=u(q);m($t.$$.fragment,X),Sa=n(X),ae=i(X,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-6jsqgb"&&(ae.textContent=qs),Ha=n(X),se=i(X,"P",{"data-svelte-h":!0}),_(se)!=="svelte-1biq3pv"&&(se.textContent=Ts),Aa=n(X),ne=i(X,"UL",{"data-svelte-h":!0}),_(ne)!=="svelte-92brbd"&&(ne.innerHTML=ws),X.forEach(a),Ba=n(T),Y=i(T,"DIV",{class:!0});var ga=u(Y);m(bt.$$.fragment,ga),ja=n(ga),re=i(ga,"P",{"data-svelte-h":!0}),_(re)!=="svelte-15wn4sl"&&(re.textContent=Cs),ga.forEach(a),Ya=n(T),W=i(T,"DIV",{class:!0});var ma=u(W);m(xt.$$.fragment,ma),Wa=n(ma),ie=i(ma,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-x1foin"&&(ie.textContent=Ls),ma.forEach(a),T.forEach(a),Ve=n(t),m(yt.$$.fragment,t),Me=n(t),I=i(t,"DIV",{class:!0});var da=u(I);m(qt.$$.fragment,da),Ka=n(da),le=i(da,"P",{"data-svelte-h":!0}),_(le)!=="svelte-zf5ael"&&(le.textContent=Ds),da.forEach(a),ze=n(t),E=i(t,"DIV",{class:!0});var pa=u(E);m(Tt.$$.fragment,pa),Qa=n(pa),oe=i(pa,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-arv8a3"&&(oe.textContent=Rs),pa.forEach(a),Ue=n(t),P=i(t,"DIV",{class:!0});var ca=u(P);m(wt.$$.fragment,ca),Ja=n(ca),ge=i(ca,"P",{"data-svelte-h":!0}),_(ge)!=="svelte-1mewloc"&&(ge.textContent=Is),ca.forEach(a),Oe=n(t),w=i(t,"DIV",{class:!0});var be=u(w);m(Ct.$$.fragment,be),Xa=n(be),me=i(be,"P",{"data-svelte-h":!0}),_(me)!=="svelte-136acwq"&&(me.textContent=Es),Za=n(be),de=i(be,"P",{"data-svelte-h":!0}),_(de)!=="svelte-1lh5azd"&&(de.textContent=Ps),be.forEach(a),Fe=n(t),N=i(t,"DIV",{class:!0});var ha=u(N);m(Lt.$$.fragment,ha),ts=n(ha),pe=i(ha,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-1ir3rum"&&(pe.textContent=Ns),ha.forEach(a),Se=n(t),G=i(t,"DIV",{class:!0});var ua=u(G);m(Dt.$$.fragment,ua),es=n(ua),ce=i(ua,"P",{"data-svelte-h":!0}),_(ce)!=="svelte-1ir3rum"&&(ce.textContent=Gs),ua.forEach(a),He=n(t),m(Rt.$$.fragment,t),Ae=n(t),C=i(t,"DIV",{class:!0});var xe=u(C);m(It.$$.fragment,xe),as=n(xe),K=i(xe,"DIV",{class:!0});var va=u(K);m(Et.$$.fragment,va),ss=n(va),he=i(va,"P",{"data-svelte-h":!0}),_(he)!=="svelte-17n3dve"&&(he.textContent=Vs),va.forEach(a),ns=n(xe),Q=i(xe,"DIV",{class:!0});var fa=u(Q);m(Pt.$$.fragment,fa),rs=n(fa),ue=i(fa,"P",{"data-svelte-h":!0}),_(ue)!=="svelte-udia6y"&&(ue.textContent=Ms),fa.forEach(a),xe.forEach(a),Be=n(t),Nt=i(t,"DIV",{class:!0});var As=u(Nt);m(Gt.$$.fragment,As),As.forEach(a),je=n(t),Vt=i(t,"DIV",{class:!0});var Bs=u(Vt);m(Mt.$$.fragment,Bs),Bs.forEach(a),Ye=n(t),V=i(t,"DIV",{class:!0});var _a=u(V);m(zt.$$.fragment,_a),is=n(_a),b=i(_a,"DIV",{class:!0});var L=u(b);m(Ut.$$.fragment,L),ls=n(L),ve=i(L,"P",{"data-svelte-h":!0}),_(ve)!=="svelte-1akk4jf"&&(ve.textContent=zs),os=n(L),fe=i(L,"P",{"data-svelte-h":!0}),_(fe)!=="svelte-1jovh48"&&(fe.textContent=Us),gs=n(L),_e=i(L,"UL",{"data-svelte-h":!0}),_(_e)!=="svelte-62kt3p"&&(_e.innerHTML=Os),ms=n(L),ke=i(L,"P",{"data-svelte-h":!0}),_(ke)!=="svelte-1oovzw"&&(ke.textContent=Fs),L.forEach(a),_a.forEach(a),We=n(t),Ot=i(t,"DIV",{class:!0});var js=u(Ot);m(Ft.$$.fragment,js),js.forEach(a),Ke=n(t),M=i(t,"DIV",{class:!0});var ka=u(M);m(St.$$.fragment,ka),ds=n(ka),$e=i(ka,"P",{"data-svelte-h":!0}),_($e)!=="svelte-1xq59t"&&($e.textContent=Ss),ka.forEach(a),Qe=n(t),m(Ht.$$.fragment,t),Je=n(t),qe=i(t,"P",{}),u(qe).forEach(a),this.h()},h(){v(D,"name","hf:doc:metadata"),v(D,"content",en),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,l){e(document.head,D),o(t,Te,l),o(t,ye,l),o(t,we,l),d(tt,t,l),o(t,Ce,l),d(et,t,l),o(t,Le,l),d(at,t,l),o(t,De,l),o(t,R,l),d(st,R,null),e(R,$a),e(R,At),o(t,Re,l),d(nt,t,l),o(t,Ie,l),o(t,k,l),d(rt,k,null),e(k,ba),e(k,z),d(it,z,null),e(z,xa),e(z,Bt),e(k,ya),e(k,U),d(lt,U,null),e(U,qa),e(U,jt),e(k,Ta),e(k,O),d(ot,O,null),e(O,wa),e(O,Yt),e(k,Ca),e(k,F),d(gt,F,null),e(F,La),e(F,Wt),e(k,Da),e(k,S),d(mt,S,null),e(S,Ra),e(S,Kt),e(k,Ia),e(k,H),d(dt,H,null),e(H,Ea),e(H,Qt),o(t,Ee,l),d(pt,t,l),o(t,Pe,l),o(t,y,l),d(ct,y,null),e(y,Pa),e(y,A),d(ht,A,null),e(A,Na),e(A,Jt),e(y,Ga),e(y,B),d(ut,B,null),e(B,Va),e(B,Xt),e(y,Ma),e(y,j),d(vt,j,null),e(j,za),e(j,Zt),o(t,Ne,l),d(ft,t,l),o(t,Ge,l),o(t,$,l),d(_t,$,null),e($,Ua),e($,te),e($,Oa),e($,ee),d(kt,ee,null),e($,Fa),e($,q),d($t,q,null),e(q,Sa),e(q,ae),e(q,Ha),e(q,se),e(q,Aa),e(q,ne),e($,Ba),e($,Y),d(bt,Y,null),e(Y,ja),e(Y,re),e($,Ya),e($,W),d(xt,W,null),e(W,Wa),e(W,ie),o(t,Ve,l),d(yt,t,l),o(t,Me,l),o(t,I,l),d(qt,I,null),e(I,Ka),e(I,le),o(t,ze,l),o(t,E,l),d(Tt,E,null),e(E,Qa),e(E,oe),o(t,Ue,l),o(t,P,l),d(wt,P,null),e(P,Ja),e(P,ge),o(t,Oe,l),o(t,w,l),d(Ct,w,null),e(w,Xa),e(w,me),e(w,Za),e(w,de),o(t,Fe,l),o(t,N,l),d(Lt,N,null),e(N,ts),e(N,pe),o(t,Se,l),o(t,G,l),d(Dt,G,null),e(G,es),e(G,ce),o(t,He,l),d(Rt,t,l),o(t,Ae,l),o(t,C,l),d(It,C,null),e(C,as),e(C,K),d(Et,K,null),e(K,ss),e(K,he),e(C,ns),e(C,Q),d(Pt,Q,null),e(Q,rs),e(Q,ue),o(t,Be,l),o(t,Nt,l),d(Gt,Nt,null),o(t,je,l),o(t,Vt,l),d(Mt,Vt,null),o(t,Ye,l),o(t,V,l),d(zt,V,null),e(V,is),e(V,b),d(Ut,b,null),e(b,ls),e(b,ve),e(b,os),e(b,fe),e(b,gs),e(b,_e),e(b,ms),e(b,ke),o(t,We,l),o(t,Ot,l),d(Ft,Ot,null),o(t,Ke,l),o(t,M,l),d(St,M,null),e(M,ds),e(M,$e),o(t,Qe,l),d(Ht,t,l),o(t,Je,l),o(t,qe,l),Xe=!0},p:Ws,i(t){Xe||(p(tt.$$.fragment,t),p(et.$$.fragment,t),p(at.$$.fragment,t),p(st.$$.fragment,t),p(nt.$$.fragment,t),p(rt.$$.fragment,t),p(it.$$.fragment,t),p(lt.$$.fragment,t),p(ot.$$.fragment,t),p(gt.$$.fragment,t),p(mt.$$.fragment,t),p(dt.$$.fragment,t),p(pt.$$.fragment,t),p(ct.$$.fragment,t),p(ht.$$.fragment,t),p(ut.$$.fragment,t),p(vt.$$.fragment,t),p(ft.$$.fragment,t),p(_t.$$.fragment,t),p(kt.$$.fragment,t),p($t.$$.fragment,t),p(bt.$$.fragment,t),p(xt.$$.fragment,t),p(yt.$$.fragment,t),p(qt.$$.fragment,t),p(Tt.$$.fragment,t),p(wt.$$.fragment,t),p(Ct.$$.fragment,t),p(Lt.$$.fragment,t),p(Dt.$$.fragment,t),p(Rt.$$.fragment,t),p(It.$$.fragment,t),p(Et.$$.fragment,t),p(Pt.$$.fragment,t),p(Gt.$$.fragment,t),p(Mt.$$.fragment,t),p(zt.$$.fragment,t),p(Ut.$$.fragment,t),p(Ft.$$.fragment,t),p(St.$$.fragment,t),p(Ht.$$.fragment,t),Xe=!0)},o(t){c(tt.$$.fragment,t),c(et.$$.fragment,t),c(at.$$.fragment,t),c(st.$$.fragment,t),c(nt.$$.fragment,t),c(rt.$$.fragment,t),c(it.$$.fragment,t),c(lt.$$.fragment,t),c(ot.$$.fragment,t),c(gt.$$.fragment,t),c(mt.$$.fragment,t),c(dt.$$.fragment,t),c(pt.$$.fragment,t),c(ct.$$.fragment,t),c(ht.$$.fragment,t),c(ut.$$.fragment,t),c(vt.$$.fragment,t),c(ft.$$.fragment,t),c(_t.$$.fragment,t),c(kt.$$.fragment,t),c($t.$$.fragment,t),c(bt.$$.fragment,t),c(xt.$$.fragment,t),c(yt.$$.fragment,t),c(qt.$$.fragment,t),c(Tt.$$.fragment,t),c(wt.$$.fragment,t),c(Ct.$$.fragment,t),c(Lt.$$.fragment,t),c(Dt.$$.fragment,t),c(Rt.$$.fragment,t),c(It.$$.fragment,t),c(Et.$$.fragment,t),c(Pt.$$.fragment,t),c(Gt.$$.fragment,t),c(Mt.$$.fragment,t),c(zt.$$.fragment,t),c(Ut.$$.fragment,t),c(Ft.$$.fragment,t),c(St.$$.fragment,t),c(Ht.$$.fragment,t),Xe=!1},d(t){t&&(a(Te),a(ye),a(we),a(Ce),a(Le),a(De),a(R),a(Re),a(Ie),a(k),a(Ee),a(Pe),a(y),a(Ne),a(Ge),a($),a(Ve),a(Me),a(I),a(ze),a(E),a(Ue),a(P),a(Oe),a(w),a(Fe),a(N),a(Se),a(G),a(He),a(Ae),a(C),a(Be),a(Nt),a(je),a(Vt),a(Ye),a(V),a(We),a(Ot),a(Ke),a(M),a(Qe),a(Je),a(qe)),a(D),h(tt,t),h(et,t),h(at,t),h(st),h(nt,t),h(rt),h(it),h(lt),h(ot),h(gt),h(mt),h(dt),h(pt,t),h(ct),h(ht),h(ut),h(vt),h(ft,t),h(_t),h(kt),h($t),h(bt),h(xt),h(yt,t),h(qt),h(Tt),h(wt),h(Ct),h(Lt),h(Dt),h(Rt,t),h(It),h(Et),h(Pt),h(Gt),h(Mt),h(zt),h(Ut),h(Ft),h(St),h(Ht,t)}}}const en='{"title":"Tasks","local":"tasks","sections":[{"title":"LightevalTask","local":"lightevaltask","sections":[{"title":"LightevalTaskConfig","local":"lighteval.tasks.lighteval_task.LightevalTaskConfig","sections":[],"depth":3},{"title":"LightevalTask","local":"lighteval.tasks.lighteval_task.LightevalTask","sections":[],"depth":3}],"depth":2},{"title":"PromptManager","local":"lighteval.tasks.prompt_manager.PromptManager","sections":[],"depth":2},{"title":"Registry","local":"lighteval.tasks.registry.Registry","sections":[],"depth":2},{"title":"Requests","local":"lighteval.tasks.requests.Request","sections":[],"depth":2},{"title":"Datasets","local":"lighteval.data.DynamicBatchDataset","sections":[],"depth":2}],"depth":1}';function an(ps){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class on extends Qs{constructor(D){super(),Js(this,D,an,tn,Ys,{})}}export{on as component};
