import{s as De,n as Ke,o as je}from"../chunks/scheduler.53228c21.js";import{S as Re,i as Ne,e as i,s,c,h as ze,a as r,d as n,b as a,f as S,g as m,j as y,k as I,l as g,m as o,n as d,t as u,o as p,p as f}from"../chunks/index.100fac89.js";import{C as Ee}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{D as _e}from"../chunks/Docstring.9bbf7d33.js";import{C as Fe}from"../chunks/CodeBlock.d30a6509.js";import{H as Q,E as Ce}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function Xe(ke){let h,B,V,H,w,O,$,q,k,Me='Improved larger variational autoencoder (VAE) model with KL loss for inpainting task: <a href="https://huggingface.co/papers/2306.04632" rel="nofollow">Designing a Better Asymmetric VQGAN for StableDiffusion</a> by Zixin Zhu, Xuelu Feng, Dongdong Chen, Jianmin Bao, Le Wang, Yinpeng Chen, Lu Yuan, Gang Hua.',P,M,Ae="The abstract from the paper is:",ee,A,Te='<em>StableDiffusion is a revolutionary text-to-image generator that is causing a stir in the world of image generation and editing. Unlike traditional methods that learn a diffusion model in pixel space, StableDiffusion learns a diffusion model in the latent space via a VQGAN, ensuring both efficiency and quality. It not only supports image generation tasks, but also enables image editing for real images, such as image inpainting and local editing. However, we have observed that the vanilla VQGAN used in StableDiffusion leads to significant information loss, causing distortion artifacts even in non-edited image regions. To this end, we propose a new asymmetric VQGAN with two simple designs. Firstly, in addition to the input from the encoder, the decoder contains a conditional branch that incorporates information from task-specific priors, such as the unmasked image region in inpainting. Secondly, the decoder is much heavier than the encoder, allowing for more detailed recovery while only slightly increasing the total inference cost. The training cost of our asymmetric VQGAN is cheap, and we only need to retrain a new asymmetric decoder while keeping the vanilla VQGAN encoder and StableDiffusion unchanged. Our asymmetric VQGAN can be widely used in StableDiffusion-based inpainting and local editing methods. Extensive experiments demonstrate that it can significantly improve the inpainting and editing performance, while maintaining the original text-to-image capability. The code is available at <a href="https://github.com/buxiangzhiren/Asymmetric_VQGAN" rel="nofollow">https://github.com/buxiangzhiren/Asymmetric_VQGAN</a></em>',te,T,xe="Evaluation results can be found in section 4.1 of the original paper.",ne,x,oe,Z,Ze='<li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5</a></li> <li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2</a></li>',se,W,ae,L,ie,J,re,l,G,be,z,We=`Designing a Better Asymmetric VQGAN for StableDiffusion <a href="https://huggingface.co/papers/2306.04632" rel="nofollow">https://huggingface.co/papers/2306.04632</a> . A VAE model with
KL loss for encoding images into latents and decoding latent representations into images.`,ye,E,Le=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,ve,F,U,le,D,ce,_,K,we,C,Je="Output of AutoencoderKL encoding method.",me,j,de,b,R,$e,X,Ge="Output of decoding method.",ue,N,pe,Y,fe;return w=new Ee({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),$=new Q({props:{title:"AsymmetricAutoencoderKL",local:"asymmetricautoencoderkl",headingTag:"h1"}}),x=new Q({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),W=new Q({props:{title:"Example Usage",local:"example-usage",headingTag:"h2"}}),L=new Fe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFzeW1tZXRyaWNBdXRvZW5jb2RlcktMJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBwZXJzb24lMjB3aXRoJTIwYmVhcmQlMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZjZWxlYmFfaHFfMjU2LnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZtYXNrXzI1Ni5wbmclMjIlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyKSUwQXBpcGUudmFlJTIwJTNEJTIwQXN5bW1ldHJpY0F1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMmNyb3NzLWF0dGVudGlvbiUyRmFzeW1tZXRyaWMtYXV0b2VuY29kZXIta2wteC0xLTUlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRG9yaWdpbmFsX2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QzKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AsymmetricAutoencoderKL, StableDiffusionInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid


prompt = <span class="hljs-string">&quot;a photo of a person with beard&quot;</span>
img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/celeba_hq_256.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/mask_256.png&quot;</span>

original_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

pipe = StableDiffusionInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-inpainting&quot;</span>)
pipe.vae = AsymmetricAutoencoderKL.from_pretrained(<span class="hljs-string">&quot;cross-attention/asymmetric-autoencoder-kl-x-1-5&quot;</span>)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(prompt=prompt, image=original_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),J=new Q({props:{title:"AsymmetricAutoencoderKL",local:"diffusers.AsymmetricAutoencoderKL",headingTag:"h2"}}),G=new _e({props:{name:"class diffusers.AsymmetricAutoencoderKL",anchor:"diffusers.AsymmetricAutoencoderKL",parameters:[{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"down_block_types",val:": typing.Tuple[str, ...] = ('DownEncoderBlock2D',)"},{name:"down_block_out_channels",val:": typing.Tuple[int, ...] = (64,)"},{name:"layers_per_down_block",val:": int = 1"},{name:"up_block_types",val:": typing.Tuple[str, ...] = ('UpDecoderBlock2D',)"},{name:"up_block_out_channels",val:": typing.Tuple[int, ...] = (64,)"},{name:"layers_per_up_block",val:": int = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"latent_channels",val:": int = 4"},{name:"norm_num_groups",val:": int = 32"},{name:"sample_size",val:": int = 32"},{name:"scaling_factor",val:": float = 0.18215"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.in_channels",description:"<strong>in_channels</strong> (int, <em>optional</em>, defaults to 3) &#x2014; Number of channels in the input image.",name:"in_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.out_channels",description:"<strong>out_channels</strong> (int,  <em>optional</em>, defaults to 3) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;DownEncoderBlock2D&quot;,)</code>) &#x2014;
Tuple of downsample block types.`,name:"down_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_out_channels",description:`<strong>down_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of down block output channels.`,name:"down_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_down_block",description:`<strong>layers_per_down_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for down block.`,name:"layers_per_down_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpDecoderBlock2D&quot;,)</code>) &#x2014;
Tuple of upsample block types.`,name:"up_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_out_channels",description:`<strong>up_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of up block output channels.`,name:"up_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_up_block",description:`<strong>layers_per_up_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for up block.`,name:"layers_per_up_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AsymmetricAutoencoderKL.latent_channels",description:"<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the latent space.",name:"latent_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.sample_size",description:"<strong>sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014; Sample input size.",name:"sample_size"},{anchor:"diffusers.AsymmetricAutoencoderKL.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
Number of groups to use for the first normalization layer in ResNet blocks.`,name:"norm_num_groups"},{anchor:"diffusers.AsymmetricAutoencoderKL.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://huggingface.co/papers/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_asym_kl.py#L26"}}),U=new _e({props:{name:"forward",anchor:"diffusers.AsymmetricAutoencoderKL.forward",parameters:[{name:"sample",val:": Tensor"},{name:"mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sample_posterior",val:": bool = False"},{name:"return_dict",val:": bool = True"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample",description:"<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014; Input sample.",name:"sample"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.mask",description:"<strong>mask</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014; Optional inpainting mask.",name:"mask"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample_posterior",description:`<strong>sample_posterior</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample from the posterior.`,name:"sample_posterior"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_asym_kl.py#L155"}}),D=new Q({props:{title:"AutoencoderKLOutput",local:"diffusers.models.modeling_outputs.AutoencoderKLOutput",headingTag:"h2"}}),K=new _e({props:{name:"class diffusers.models.modeling_outputs.AutoencoderKLOutput",anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput",parameters:[{name:"latent_dist",val:": DiagonalGaussianDistribution"}],parametersDescription:[{anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput.latent_dist",description:`<strong>latent_dist</strong> (<code>DiagonalGaussianDistribution</code>) &#x2014;
Encoded outputs of <code>Encoder</code> represented as the mean and logvar of <code>DiagonalGaussianDistribution</code>.
<code>DiagonalGaussianDistribution</code> allows for sampling latents from the distribution.`,name:"latent_dist"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L7"}}),j=new Q({props:{title:"DecoderOutput",local:"diffusers.models.autoencoders.vae.DecoderOutput",headingTag:"h2"}}),R=new _e({props:{name:"class diffusers.models.autoencoders.vae.DecoderOutput",anchor:"diffusers.models.autoencoders.vae.DecoderOutput",parameters:[{name:"sample",val:": Tensor"},{name:"commit_loss",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"diffusers.models.autoencoders.vae.DecoderOutput.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
The decoded output sample from the last layer of the model.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vae.py#L47"}}),N=new Ce({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/asymmetricautoencoderkl.md"}}),{c(){h=i("meta"),B=s(),V=i("p"),H=s(),c(w.$$.fragment),O=s(),c($.$$.fragment),q=s(),k=i("p"),k.innerHTML=Me,P=s(),M=i("p"),M.textContent=Ae,ee=s(),A=i("p"),A.innerHTML=Te,te=s(),T=i("p"),T.textContent=xe,ne=s(),c(x.$$.fragment),oe=s(),Z=i("ul"),Z.innerHTML=Ze,se=s(),c(W.$$.fragment),ae=s(),c(L.$$.fragment),ie=s(),c(J.$$.fragment),re=s(),l=i("div"),c(G.$$.fragment),be=s(),z=i("p"),z.innerHTML=We,ye=s(),E=i("p"),E.innerHTML=Le,ve=s(),F=i("div"),c(U.$$.fragment),le=s(),c(D.$$.fragment),ce=s(),_=i("div"),c(K.$$.fragment),we=s(),C=i("p"),C.textContent=Je,me=s(),c(j.$$.fragment),de=s(),b=i("div"),c(R.$$.fragment),$e=s(),X=i("p"),X.textContent=Ge,ue=s(),c(N.$$.fragment),pe=s(),Y=i("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(n),B=a(e),V=r(e,"P",{}),S(V).forEach(n),H=a(e),m(w.$$.fragment,e),O=a(e),m($.$$.fragment,e),q=a(e),k=r(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-5bqk5j"&&(k.innerHTML=Me),P=a(e),M=r(e,"P",{"data-svelte-h":!0}),y(M)!=="svelte-1cwsb16"&&(M.textContent=Ae),ee=a(e),A=r(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-ggnlwl"&&(A.innerHTML=Te),te=a(e),T=r(e,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1dzj46z"&&(T.textContent=xe),ne=a(e),m(x.$$.fragment,e),oe=a(e),Z=r(e,"UL",{"data-svelte-h":!0}),y(Z)!=="svelte-1m6ravg"&&(Z.innerHTML=Ze),se=a(e),m(W.$$.fragment,e),ae=a(e),m(L.$$.fragment,e),ie=a(e),m(J.$$.fragment,e),re=a(e),l=r(e,"DIV",{class:!0});var v=S(l);m(G.$$.fragment,v),be=a(v),z=r(v,"P",{"data-svelte-h":!0}),y(z)!=="svelte-1clr2gx"&&(z.innerHTML=We),ye=a(v),E=r(v,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1hyu2ru"&&(E.innerHTML=Le),ve=a(v),F=r(v,"DIV",{class:!0});var Ue=S(F);m(U.$$.fragment,Ue),Ue.forEach(n),v.forEach(n),le=a(e),m(D.$$.fragment,e),ce=a(e),_=r(e,"DIV",{class:!0});var ge=S(_);m(K.$$.fragment,ge),we=a(ge),C=r(ge,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1vsc7ag"&&(C.textContent=Je),ge.forEach(n),me=a(e),m(j.$$.fragment,e),de=a(e),b=r(e,"DIV",{class:!0});var he=S(b);m(R.$$.fragment,he),$e=a(he),X=r(he,"P",{"data-svelte-h":!0}),y(X)!=="svelte-18u8upa"&&(X.textContent=Ge),he.forEach(n),ue=a(e),m(N.$$.fragment,e),pe=a(e),Y=r(e,"P",{}),S(Y).forEach(n),this.h()},h(){I(h,"name","hf:doc:metadata"),I(h,"content",Se),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){g(document.head,h),o(e,B,t),o(e,V,t),o(e,H,t),d(w,e,t),o(e,O,t),d($,e,t),o(e,q,t),o(e,k,t),o(e,P,t),o(e,M,t),o(e,ee,t),o(e,A,t),o(e,te,t),o(e,T,t),o(e,ne,t),d(x,e,t),o(e,oe,t),o(e,Z,t),o(e,se,t),d(W,e,t),o(e,ae,t),d(L,e,t),o(e,ie,t),d(J,e,t),o(e,re,t),o(e,l,t),d(G,l,null),g(l,be),g(l,z),g(l,ye),g(l,E),g(l,ve),g(l,F),d(U,F,null),o(e,le,t),d(D,e,t),o(e,ce,t),o(e,_,t),d(K,_,null),g(_,we),g(_,C),o(e,me,t),d(j,e,t),o(e,de,t),o(e,b,t),d(R,b,null),g(b,$e),g(b,X),o(e,ue,t),d(N,e,t),o(e,pe,t),o(e,Y,t),fe=!0},p:Ke,i(e){fe||(u(w.$$.fragment,e),u($.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(J.$$.fragment,e),u(G.$$.fragment,e),u(U.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(j.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),fe=!0)},o(e){p(w.$$.fragment,e),p($.$$.fragment,e),p(x.$$.fragment,e),p(W.$$.fragment,e),p(L.$$.fragment,e),p(J.$$.fragment,e),p(G.$$.fragment,e),p(U.$$.fragment,e),p(D.$$.fragment,e),p(K.$$.fragment,e),p(j.$$.fragment,e),p(R.$$.fragment,e),p(N.$$.fragment,e),fe=!1},d(e){e&&(n(B),n(V),n(H),n(O),n(q),n(k),n(P),n(M),n(ee),n(A),n(te),n(T),n(ne),n(oe),n(Z),n(se),n(ae),n(ie),n(re),n(l),n(le),n(ce),n(_),n(me),n(de),n(b),n(ue),n(pe),n(Y)),n(h),f(w,e),f($,e),f(x,e),f(W,e),f(L,e),f(J,e),f(G),f(U),f(D,e),f(K),f(j,e),f(R),f(N,e)}}}const Se='{"title":"AsymmetricAutoencoderKL","local":"asymmetricautoencoderkl","sections":[{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Example Usage","local":"example-usage","sections":[],"depth":2},{"title":"AsymmetricAutoencoderKL","local":"diffusers.AsymmetricAutoencoderKL","sections":[],"depth":2},{"title":"AutoencoderKLOutput","local":"diffusers.models.modeling_outputs.AutoencoderKLOutput","sections":[],"depth":2},{"title":"DecoderOutput","local":"diffusers.models.autoencoders.vae.DecoderOutput","sections":[],"depth":2}],"depth":1}';function Ie(ke){return je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qe extends Re{constructor(h){super(),Ne(this,h,Ie,Xe,De,{})}}export{qe as component};
