import{s as et,n as tt,o as it}from"../chunks/scheduler.53228c21.js";import{S as st,i as ot,e as l,s as o,c as f,h as nt,a,d as i,b as n,f as Xe,g as d,j as r,k as Ze,l as lt,m as s,n as c,t as h,o as p,p as u}from"../chunks/index.100fac89.js";import{C as at}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{H as g,E as rt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function ft(He){let m,Q,J,V,b,X,y,Z,w,De=`🧨 Diffusers provides <strong>state-of-the-art</strong> pretrained diffusion models across multiple modalities.
Its purpose is to serve as a <strong>modular toolbox</strong> for both inference and training.`,ee,v,Ie="We aim at building a library that stands the test of time and therefore take API design very seriously.",te,x,Se='In a nutshell, Diffusers is built to be a natural extension of PyTorch. Therefore, most of our design choices are based on <a href="https://pytorch.org/docs/stable/community/design.html#pytorch-design-philosophy" rel="nofollow">PyTorch’s Design Principles</a>. Let’s go over the most important ones:',ie,$,se,_,Ue='<li>While Diffusers has many built-in performance-enhancing features (see <a href="https://huggingface.co/docs/diffusers/optimization/fp16" rel="nofollow">Memory and Speed</a>), models are always loaded with the highest precision and lowest optimization. Therefore, by default diffusion pipelines are always instantiated on CPU with float32 precision if not otherwise defined by the user. This ensures usability across different platforms and accelerators and means that no complex installations are required to run the library.</li> <li>Diffusers aims to be a <strong>light-weight</strong> package and therefore has very few required dependencies, but many soft dependencies that can improve performance (such as <code>accelerate</code>, <code>safetensors</code>, <code>onnx</code>, etc…). We strive to keep the library as lightweight as possible so that it can be added without much concern as a dependency on other packages.</li> <li>Diffusers prefers simple, self-explainable code over condensed, magic code. This means that short-hand code syntaxes such as lambda functions, and advanced PyTorch operators are often not desired.</li>',oe,T,ne,k,je="As PyTorch states, <strong>explicit is better than implicit</strong> and <strong>simple is better than complex</strong>. This design philosophy is reflected in multiple parts of the library:",le,M,ze=`<li>We follow PyTorch’s API with methods like <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.to" rel="nofollow"><code>DiffusionPipeline.to</code></a> to let the user handle device management.</li> <li>Raising concise error messages is preferred to silently correct erroneous input. Diffusers aims at teaching the user, rather than making the library as easy to use as possible.</li> <li>Complex model vs. scheduler logic is exposed instead of magically handled inside. Schedulers/Samplers are separated from diffusion models with minimal dependencies on each other. This forces the user to write the unrolled denoising loop. However, the separation allows for easier debugging and gives the user more control over adapting the denoising process or switching out diffusion models or schedulers.</li> <li>Separately trained components of the diffusion pipeline, <em>e.g.</em> the text encoder, the unet, and the variational autoencoder, each have their own model class. This forces the user to handle the interaction between the different model components, and the serialization format separates the model components into different files. However, this allows for easier debugging and customization. DreamBooth or Textual Inversion training
is very simple thanks to Diffusers’ ability to separate single components of the diffusion pipeline.</li>`,ae,P,re,L,Ae=`For large parts of the library, Diffusers adopts an important design principle of the <a href="https://github.com/huggingface/transformers" rel="nofollow">Transformers library</a>, which is to prefer copy-pasted code over hasty abstractions. This design principle is very opinionated and stands in stark contrast to popular design principles such as <a href="https://en.wikipedia.org/wiki/Don%27t_repeat_yourself" rel="nofollow">Don’t repeat yourself (DRY)</a>.
In short, just like Transformers does for modeling files, Diffusers prefers to keep an extremely low level of abstraction and very self-contained code for pipelines and schedulers.
Functions, long code blocks, and even classes can be copied across multiple files which at first can look like a bad, sloppy design choice that makes the library unmaintainable.
<strong>However</strong>, this design has proven to be extremely successful for Transformers and makes a lot of sense for community-driven, open-source machine learning libraries because:`,fe,C,Ee="<li>Machine Learning is an extremely fast-moving field in which paradigms, model architectures, and algorithms are changing rapidly, which therefore makes it very difficult to define long-lasting code abstractions.</li> <li>Machine Learning practitioners like to be able to quickly tweak existing code for ideation and research and therefore prefer self-contained code over one that contains many abstractions.</li> <li>Open-source libraries rely on community contributions and therefore must build a library that is easy to contribute to. The more abstract the code, the more dependencies, the harder to read, and the harder to contribute to. Contributors simply stop contributing to very abstract libraries out of fear of breaking vital functionality. If contributing to a library cannot break other fundamental code, not only is it more inviting for potential new contributors, but it is also easier to review and contribute to multiple parts in parallel.</li>",de,H,qe=`At Hugging Face, we call this design the <strong>single-file policy</strong> which means that almost all of the code of a certain class should be written in a single, self-contained file. To read more about the philosophy, you can have a look
at <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">this blog post</a>.`,ce,D,Ne=`In Diffusers, we follow this philosophy for both pipelines and schedulers, but only partly for diffusion models. The reason we don’t follow this design fully for diffusion models is because almost all diffusion pipelines, such
as <a href="https://huggingface.co/docs/diffusers/api/pipelines/ddpm" rel="nofollow">DDPM</a>, <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview#stable-diffusion-pipelines" rel="nofollow">Stable Diffusion</a>, <a href="https://huggingface.co/docs/diffusers/api/pipelines/unclip" rel="nofollow">unCLIP (DALL·E 2)</a> and <a href="https://imagen.research.google/" rel="nofollow">Imagen</a> all rely on the same diffusion model, the <a href="https://huggingface.co/docs/diffusers/api/models/unet2d-cond" rel="nofollow">UNet</a>.`,he,I,Oe=`Great, now you should have generally understood why 🧨 Diffusers is designed the way it is 🤗.
We try to apply these design principles consistently across the library. Nevertheless, there are some minor exceptions to the philosophy or some unlucky design choices. If you have feedback regarding the design, we would ❤️  to hear it <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">directly on GitHub</a>.`,pe,S,ue,U,Fe=`Now, let’s look a bit into the nitty-gritty details of the design philosophy. Diffusers essentially consists of three major classes: <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines" rel="nofollow">pipelines</a>, <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/models" rel="nofollow">models</a>, and <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/schedulers" rel="nofollow">schedulers</a>.
Let’s walk through more in-detail design decisions for each class.`,me,j,ge,z,We='Pipelines are designed to be easy to use (therefore do not follow <a href="#simple-over-easy"><em>Simple over easy</em></a> 100%), are not feature complete, and should loosely be seen as examples of how to use <a href="#models">models</a> and <a href="#schedulers">schedulers</a> for inference.',be,A,Ge="The following design principles are followed:",ye,E,Re='<li>Pipelines follow the single-file policy. All pipelines can be found in individual directories under src/diffusers/pipelines. One pipeline folder corresponds to one diffusion paper/project/release. Multiple pipeline files can be gathered in one pipeline folder, as it’s done for <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines/stable_diffusion" rel="nofollow"><code>src/diffusers/pipelines/stable-diffusion</code></a>. If pipelines share similar functionality, one can make use of the <a href="https://github.com/huggingface/diffusers/blob/125d783076e5bd9785beb05367a2d2566843a271/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L251" rel="nofollow"># Copied from mechanism</a>.</li> <li>Pipelines all inherit from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.</li> <li>Every pipeline consists of different model and scheduler components, that are documented in the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code> file</a>, are accessible under the same name as attributes of the pipeline and can be shared between pipelines with <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.components" rel="nofollow"><code>DiffusionPipeline.components</code></a> function.</li> <li>Every pipeline should be loadable via the <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained" rel="nofollow"><code>DiffusionPipeline.from_pretrained</code></a> function.</li> <li>Pipelines should be used <strong>only</strong> for inference.</li> <li>Pipelines should be very readable, self-explanatory, and easy to tweak.</li> <li>Pipelines should be designed to build on top of each other and be easy to integrate into higher-level APIs.</li> <li>Pipelines are <strong>not</strong> intended to be feature-complete user interfaces. For feature-complete user interfaces one should rather have a look at <a href="https://github.com/invoke-ai/InvokeAI" rel="nofollow">InvokeAI</a>, <a href="https://github.com/abhishekkrthakur/diffuzers" rel="nofollow">Diffuzers</a>, and <a href="https://github.com/Sanster/lama-cleaner" rel="nofollow">lama-cleaner</a>.</li> <li>Every pipeline should have one and only one way to run it via a <code>__call__</code> method. The naming of the <code>__call__</code> arguments should be shared across all pipelines.</li> <li>Pipelines should be named after the task they are intended to solve.</li> <li>In almost all cases, novel diffusion pipelines shall be implemented in a new pipeline folder/file.</li>',we,q,ve,N,Be='Models are designed as configurable toolboxes that are natural extensions of <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow">PyTorch’s Module class</a>. They only partly follow the <strong>single-file policy</strong>.',xe,O,Ye="The following design principles are followed:",$e,F,Je=`<li>Models correspond to <strong>a type of model architecture</strong>. <em>E.g.</em> the <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> class is used for all UNet variations that expect 2D image inputs and are conditioned on some context.</li> <li>All models can be found in <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/models" rel="nofollow"><code>src/diffusers/models</code></a> and every model architecture shall be defined in its file, e.g. <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_2d_condition.py" rel="nofollow"><code>unets/unet_2d_condition.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_2d.py" rel="nofollow"><code>transformers/transformer_2d.py</code></a>, etc…</li> <li>Models <strong>do not</strong> follow the single-file policy and should make use of smaller model building blocks, such as <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention.py" rel="nofollow"><code>attention.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/resnet.py" rel="nofollow"><code>resnet.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/embeddings.py" rel="nofollow"><code>embeddings.py</code></a>, etc… <strong>Note</strong>: This is in stark contrast to Transformers’ modeling files and shows that models do not really follow the single-file policy.</li> <li>Models intend to expose complexity, just like PyTorch’s <code>Module</code> class, and give clear error messages.</li> <li>Models all inherit from <code>ModelMixin</code> and <code>ConfigMixin</code>.</li> <li>Models can be optimized for performance when it doesn’t demand major code changes, keeps backward compatibility, and gives significant memory or compute gain.</li> <li>Models should by default have the highest precision and lowest performance setting.</li> <li>To integrate new model checkpoints whose general architecture can be classified as an architecture that already exists in Diffusers, the existing model architecture shall be adapted to make it work with the new checkpoint. One should only create a new file if the model architecture is fundamentally different.</li> <li>Models should be designed to be easily extendable to future changes. This can be achieved by limiting public function arguments, configuration arguments, and “foreseeing” future changes, <em>e.g.</em> it is usually better to add <code>string</code> “…type” arguments that can easily be extended to new future types instead of boolean <code>is_..._type</code> arguments. Only the minimum amount of changes shall be made to existing architectures to make a new model checkpoint work.</li> <li>The model design is a difficult trade-off between keeping code readable and concise and supporting many model checkpoints. For most parts of the modeling code, classes shall be adapted for new model checkpoints, while there are some exceptions where it is preferred to add new classes to make sure the code is kept concise and
readable long-term, such as <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_2d_blocks.py" rel="nofollow">UNet blocks</a> and <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">Attention processors</a>.</li>`,_e,W,Te,G,Ke="Schedulers are responsible to guide the denoising process for inference as well as to define a noise schedule for training. They are designed as individual classes with loadable configuration files and strongly follow the <strong>single-file policy</strong>.",ke,R,Qe="The following design principles are followed:",Me,B,Ve='<li>All schedulers are found in <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/schedulers" rel="nofollow"><code>src/diffusers/schedulers</code></a>.</li> <li>Schedulers are <strong>not</strong> allowed to import from large utils files and shall be kept very self-contained.</li> <li>One scheduler Python file corresponds to one scheduler algorithm (as might be defined in a paper).</li> <li>If schedulers share similar functionalities, we can make use of the <code># Copied from</code> mechanism.</li> <li>Schedulers all inherit from <code>SchedulerMixin</code> and <code>ConfigMixin</code>.</li> <li>Schedulers can be easily swapped out with the <a href="https://huggingface.co/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config" rel="nofollow"><code>ConfigMixin.from_config</code></a> method as explained in detail <a href="../using-diffusers/schedulers">here</a>.</li> <li>Every scheduler has to have a <code>set_num_inference_steps</code>, and a <code>step</code> function. <code>set_num_inference_steps(...)</code> has to be called before every denoising process, <em>i.e.</em> before <code>step(...)</code> is called.</li> <li>Every scheduler exposes the timesteps to be “looped over” via a <code>timesteps</code> attribute, which is an array of timesteps the model will be called upon.</li> <li>The <code>step(...)</code> function takes a predicted model output and the “current” sample (x_t) and returns the “previous”, slightly more denoised sample (x_t-1).</li> <li>Given the complexity of diffusion schedulers, the <code>step</code> function does not expose all the complexity and can be a bit of a “black box”.</li> <li>In almost all cases, novel schedulers shall be implemented in a new scheduling file.</li>',Pe,Y,Le,K,Ce;return b=new at({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new g({props:{title:"Philosophy",local:"philosophy",headingTag:"h1"}}),$=new g({props:{title:"Usability over Performance",local:"usability-over-performance",headingTag:"h2"}}),T=new g({props:{title:"Simple over easy",local:"simple-over-easy",headingTag:"h2"}}),P=new g({props:{title:"Tweakable, contributor-friendly over abstraction",local:"tweakable-contributor-friendly-over-abstraction",headingTag:"h2"}}),S=new g({props:{title:"Design Philosophy in Details",local:"design-philosophy-in-details",headingTag:"h2"}}),j=new g({props:{title:"Pipelines",local:"pipelines",headingTag:"h3"}}),q=new g({props:{title:"Models",local:"models",headingTag:"h3"}}),W=new g({props:{title:"Schedulers",local:"schedulers",headingTag:"h3"}}),Y=new rt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/conceptual/philosophy.md"}}),{c(){m=l("meta"),Q=o(),J=l("p"),V=o(),f(b.$$.fragment),X=o(),f(y.$$.fragment),Z=o(),w=l("p"),w.innerHTML=De,ee=o(),v=l("p"),v.textContent=Ie,te=o(),x=l("p"),x.innerHTML=Se,ie=o(),f($.$$.fragment),se=o(),_=l("ul"),_.innerHTML=Ue,oe=o(),f(T.$$.fragment),ne=o(),k=l("p"),k.innerHTML=je,le=o(),M=l("ul"),M.innerHTML=ze,ae=o(),f(P.$$.fragment),re=o(),L=l("p"),L.innerHTML=Ae,fe=o(),C=l("ul"),C.innerHTML=Ee,de=o(),H=l("p"),H.innerHTML=qe,ce=o(),D=l("p"),D.innerHTML=Ne,he=o(),I=l("p"),I.innerHTML=Oe,pe=o(),f(S.$$.fragment),ue=o(),U=l("p"),U.innerHTML=Fe,me=o(),f(j.$$.fragment),ge=o(),z=l("p"),z.innerHTML=We,be=o(),A=l("p"),A.textContent=Ge,ye=o(),E=l("ul"),E.innerHTML=Re,we=o(),f(q.$$.fragment),ve=o(),N=l("p"),N.innerHTML=Be,xe=o(),O=l("p"),O.textContent=Ye,$e=o(),F=l("ul"),F.innerHTML=Je,_e=o(),f(W.$$.fragment),Te=o(),G=l("p"),G.innerHTML=Ke,ke=o(),R=l("p"),R.textContent=Qe,Me=o(),B=l("ul"),B.innerHTML=Ve,Pe=o(),f(Y.$$.fragment),Le=o(),K=l("p"),this.h()},l(e){const t=nt("svelte-u9bgzb",document.head);m=a(t,"META",{name:!0,content:!0}),t.forEach(i),Q=n(e),J=a(e,"P",{}),Xe(J).forEach(i),V=n(e),d(b.$$.fragment,e),X=n(e),d(y.$$.fragment,e),Z=n(e),w=a(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-7afmi5"&&(w.innerHTML=De),ee=n(e),v=a(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ymjbvo"&&(v.textContent=Ie),te=n(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1qf3v7v"&&(x.innerHTML=Se),ie=n(e),d($.$$.fragment,e),se=n(e),_=a(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-wzmc8i"&&(_.innerHTML=Ue),oe=n(e),d(T.$$.fragment,e),ne=n(e),k=a(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-rwqz34"&&(k.innerHTML=je),le=n(e),M=a(e,"UL",{"data-svelte-h":!0}),r(M)!=="svelte-10zm1ge"&&(M.innerHTML=ze),ae=n(e),d(P.$$.fragment,e),re=n(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1maatxx"&&(L.innerHTML=Ae),fe=n(e),C=a(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-8d4xn1"&&(C.innerHTML=Ee),de=n(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-cg0ywv"&&(H.innerHTML=qe),ce=n(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-s9oxaw"&&(D.innerHTML=Ne),he=n(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-k3kirj"&&(I.innerHTML=Oe),pe=n(e),d(S.$$.fragment,e),ue=n(e),U=a(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-g3jwp9"&&(U.innerHTML=Fe),me=n(e),d(j.$$.fragment,e),ge=n(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ln30jf"&&(z.innerHTML=We),be=n(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1yq4knn"&&(A.textContent=Ge),ye=n(e),E=a(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-jkaneg"&&(E.innerHTML=Re),we=n(e),d(q.$$.fragment,e),ve=n(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-bb7xr2"&&(N.innerHTML=Be),xe=n(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1yq4knn"&&(O.textContent=Ye),$e=n(e),F=a(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-rj13z9"&&(F.innerHTML=Je),_e=n(e),d(W.$$.fragment,e),Te=n(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-fs6rzc"&&(G.innerHTML=Ke),ke=n(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1yq4knn"&&(R.textContent=Qe),Me=n(e),B=a(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1va8p91"&&(B.innerHTML=Ve),Pe=n(e),d(Y.$$.fragment,e),Le=n(e),K=a(e,"P",{}),Xe(K).forEach(i),this.h()},h(){Ze(m,"name","hf:doc:metadata"),Ze(m,"content",dt)},m(e,t){lt(document.head,m),s(e,Q,t),s(e,J,t),s(e,V,t),c(b,e,t),s(e,X,t),c(y,e,t),s(e,Z,t),s(e,w,t),s(e,ee,t),s(e,v,t),s(e,te,t),s(e,x,t),s(e,ie,t),c($,e,t),s(e,se,t),s(e,_,t),s(e,oe,t),c(T,e,t),s(e,ne,t),s(e,k,t),s(e,le,t),s(e,M,t),s(e,ae,t),c(P,e,t),s(e,re,t),s(e,L,t),s(e,fe,t),s(e,C,t),s(e,de,t),s(e,H,t),s(e,ce,t),s(e,D,t),s(e,he,t),s(e,I,t),s(e,pe,t),c(S,e,t),s(e,ue,t),s(e,U,t),s(e,me,t),c(j,e,t),s(e,ge,t),s(e,z,t),s(e,be,t),s(e,A,t),s(e,ye,t),s(e,E,t),s(e,we,t),c(q,e,t),s(e,ve,t),s(e,N,t),s(e,xe,t),s(e,O,t),s(e,$e,t),s(e,F,t),s(e,_e,t),c(W,e,t),s(e,Te,t),s(e,G,t),s(e,ke,t),s(e,R,t),s(e,Me,t),s(e,B,t),s(e,Pe,t),c(Y,e,t),s(e,Le,t),s(e,K,t),Ce=!0},p:tt,i(e){Ce||(h(b.$$.fragment,e),h(y.$$.fragment,e),h($.$$.fragment,e),h(T.$$.fragment,e),h(P.$$.fragment,e),h(S.$$.fragment,e),h(j.$$.fragment,e),h(q.$$.fragment,e),h(W.$$.fragment,e),h(Y.$$.fragment,e),Ce=!0)},o(e){p(b.$$.fragment,e),p(y.$$.fragment,e),p($.$$.fragment,e),p(T.$$.fragment,e),p(P.$$.fragment,e),p(S.$$.fragment,e),p(j.$$.fragment,e),p(q.$$.fragment,e),p(W.$$.fragment,e),p(Y.$$.fragment,e),Ce=!1},d(e){e&&(i(Q),i(J),i(V),i(X),i(Z),i(w),i(ee),i(v),i(te),i(x),i(ie),i(se),i(_),i(oe),i(ne),i(k),i(le),i(M),i(ae),i(re),i(L),i(fe),i(C),i(de),i(H),i(ce),i(D),i(he),i(I),i(pe),i(ue),i(U),i(me),i(ge),i(z),i(be),i(A),i(ye),i(E),i(we),i(ve),i(N),i(xe),i(O),i($e),i(F),i(_e),i(Te),i(G),i(ke),i(R),i(Me),i(B),i(Pe),i(Le),i(K)),i(m),u(b,e),u(y,e),u($,e),u(T,e),u(P,e),u(S,e),u(j,e),u(q,e),u(W,e),u(Y,e)}}}const dt='{"title":"Philosophy","local":"philosophy","sections":[{"title":"Usability over Performance","local":"usability-over-performance","sections":[],"depth":2},{"title":"Simple over easy","local":"simple-over-easy","sections":[],"depth":2},{"title":"Tweakable, contributor-friendly over abstraction","local":"tweakable-contributor-friendly-over-abstraction","sections":[],"depth":2},{"title":"Design Philosophy in Details","local":"design-philosophy-in-details","sections":[{"title":"Pipelines","local":"pipelines","sections":[],"depth":3},{"title":"Models","local":"models","sections":[],"depth":3},{"title":"Schedulers","local":"schedulers","sections":[],"depth":3}],"depth":2}],"depth":1}';function ct(He){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends st{constructor(m){super(),ot(this,m,ct,ft,et,{})}}export{gt as component};
