import{s as Ye,n as Qe,o as Ne}from"../chunks/scheduler.53228c21.js";import{S as Fe,i as qe,e as a,s as i,c as d,h as De,a as o,d as l,b as n,f as q,g as c,j as p,k as ge,l as r,m as s,n as u,t as f,o as m,p as M}from"../chunks/index.100fac89.js";import{C as Oe}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{C as D}from"../chunks/CodeBlock.d30a6509.js";import{H as Te,E as Ke}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function et(Ge){let h,O,N,K,U,ee,w,te,T,Ze='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> is the basic block for building a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>. It defines what components, inputs/outputs, and computation a block should perform for a specific step in a pipeline. A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> connects with other blocks, using <a href="./modular_diffusers_states">state</a>, to enable the modular construction of workflows.',le,k,Je='A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> on it’s own can’t be executed. It is a blueprint for what a step should do in a pipeline. To actually run and execute a pipeline, the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> needs to be converted into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>.',se,$,Re='This guide will show you how to create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a>.',ie,B,ne,_,Se='<p>Refer to the <a href="./modular_diffusers_states">States</a> guide if you aren’t familiar with how state works in Modular Diffusers.</p>',ae,C,Ve='A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> requires <code>inputs</code>, and <code>intermediate_outputs</code>.',oe,j,y,L,He='<code>inputs</code> are values provided by a user and retrieved from the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>. This is useful because some workflows resize an image, but the original image is still required. The <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a> maintains the original image.',ke,X,Ie="Use <code>InputParam</code> to define <code>inputs</code>.",$e,v,Be,b,z,Pe='<code>intermediate_outputs</code> are new values created by a block and added to the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>. The <code>intermediate_outputs</code> are available as <code>inputs</code> for subsequent blocks or available as the final output from running the pipeline.',Ce,A,Ee="Use <code>OutputParam</code> to define <code>intermediate_outputs</code>.",ve,g,pe,G,xe="The intermediate inputs and outputs share data to connect blocks. They are accessible at any point, allowing you to track the workflow’s progress.",re,Z,de,J,We="The computation a block performs is defined in the <code>__call__</code> method and it follows a specific structure.",ce,R,Le='<li>Retrieve the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> to get a local view of the <code>inputs</code></li> <li>Implement the computation logic on the <code>inputs</code>.</li> <li>Update <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a> to push changes from the local <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> back to the global <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>.</li> <li>Return the components and state which becomes available to the next block.</li>',ue,S,fe,V,me,H,Xe='The components and pipeline-level configs a block needs are specified in <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.ComponentSpec">ComponentSpec</a> and <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.modular_pipelines.ConfigSpec">ConfigSpec</a>.',Me,I,ze='<li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.ComponentSpec">ComponentSpec</a> contains the expected components used by a block. You need the <code>name</code> of the component and ideally a <code>type_hint</code> that specifies exactly what the component is.</li> <li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.modular_pipelines.ConfigSpec">ConfigSpec</a> contains pipeline-level settings that control behavior across all blocks.</li>',he,P,ye,E,Ae="When the blocks are converted into a pipeline, the components become available to the block as the first argument in <code>__call__</code>.",be,x,_e,W,je,F,Ue;return U=new Oe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Te({props:{title:"ModularPipelineBlocks",local:"modularpipelineblocks",headingTag:"h1"}}),B=new Te({props:{title:"Inputs and outputs",local:"inputs-and-outputs",headingTag:"h2"}}),v=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMElucHV0UGFyYW0lMEElMEF1c2VyX2lucHV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMElucHV0UGFyYW0obmFtZSUzRCUyMmltYWdlJTIyJTJDJTIwdHlwZV9oaW50JTNEJTIyUElMLkltYWdlJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJyYXclMjBpbnB1dCUyMGltYWdlJTIwdG8lMjBwcm9jZXNzJTIyKSUwQSU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> InputParam

user_inputs = [
    InputParam(name=<span class="hljs-string">&quot;image&quot;</span>, type_hint=<span class="hljs-string">&quot;PIL.Image&quot;</span>, description=<span class="hljs-string">&quot;raw input image to process&quot;</span>)
]`,wrap:!1}}),g=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyME91dHB1dFBhcmFtJTBBJTBBJTIwJTIwJTIwJTIwdXNlcl9pbnRlcm1lZGlhdGVfb3V0cHV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyME91dHB1dFBhcmFtKG5hbWUlM0QlMjJpbWFnZV9sYXRlbnRzJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJsYXRlbnRzJTIwcmVwcmVzZW50aW5nJTIwdGhlJTIwaW1hZ2UlMjIpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> OutputParam

    user_intermediate_outputs = [
    OutputParam(name=<span class="hljs-string">&quot;image_latents&quot;</span>, description=<span class="hljs-string">&quot;latents representing the image&quot;</span>)
]`,wrap:!1}}),Z=new Te({props:{title:"Computation logic",local:"computation-logic",headingTag:"h2"}}),S=new D({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjBhJTIwbG9jYWwlMjB2aWV3JTIwb2YlMjB0aGUlMjBzdGF0ZSUyMHZhcmlhYmxlcyUyMHRoaXMlMjBibG9jayUyMG5lZWRzJTBBJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBzZWxmLmdldF9ibG9ja19zdGF0ZShzdGF0ZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwY29tcHV0YXRpb24lMjBsb2dpYyUyMGhlcmUlMEElMjAlMjAlMjAlMjAlMjMlMjBibG9ja19zdGF0ZSUyMGNvbnRhaW5zJTIwYWxsJTIweW91ciUyMGlucHV0cyUwQSUyMCUyMCUyMCUyMCUyMyUyMEFjY2VzcyUyMHRoZW0lMjBsaWtlJTNBJTIwYmxvY2tfc3RhdGUuaW1hZ2UlMkMlMjBibG9ja19zdGF0ZS5wcm9jZXNzZWRfaW1hZ2UlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBVcGRhdGUlMjB0aGUlMjBwaXBlbGluZSUyMHN0YXRlJTIwd2l0aCUyMHlvdXIlMjB1cGRhdGVkJTIwYmxvY2tfc3RhdGVzJTBBJTIwJTIwJTIwJTIwc2VsZi5zZXRfYmxvY2tfc3RhdGUoc3RhdGUlMkMlMjBibG9ja19zdGF0ZSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjb21wb25lbnRzJTJDJTIwc3RhdGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
    <span class="hljs-comment"># Get a local view of the state variables this block needs</span>
    block_state = self.get_block_state(state)

    <span class="hljs-comment"># Your computation logic here</span>
    <span class="hljs-comment"># block_state contains all your inputs</span>
    <span class="hljs-comment"># Access them like: block_state.image, block_state.processed_image</span>

    <span class="hljs-comment"># Update the pipeline state with your updated block_states</span>
    self.set_block_state(state, block_state)
    <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),V=new Te({props:{title:"Components and configs",local:"components-and-configs",headingTag:"h3"}}),P=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbXBvbmVudFNwZWMlMkMlMjBDb25maWdTcGVjJTBBJTBBZXhwZWN0ZWRfY29tcG9uZW50cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbXBvbmVudFNwZWMobmFtZSUzRCUyMnVuZXQlMjIlMkMlMjB0eXBlX2hpbnQlM0RVTmV0MkRDb25kaXRpb25Nb2RlbCklMkMlMEElMjAlMjAlMjAlMjBDb21wb25lbnRTcGVjKG5hbWUlM0QlMjJzY2hlZHVsZXIlMjIlMkMlMjB0eXBlX2hpbnQlM0RFdWxlckRpc2NyZXRlU2NoZWR1bGVyKSUwQSU1RCUwQSUwQWV4cGVjdGVkX2NvbmZpZyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbmZpZ1NwZWMoJTIyZm9yY2VfemVyb3NfZm9yX2VtcHR5X3Byb21wdCUyMiUyQyUyMFRydWUpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentSpec, ConfigSpec

expected_components = [
    ComponentSpec(name=<span class="hljs-string">&quot;unet&quot;</span>, type_hint=UNet2DConditionModel),
    ComponentSpec(name=<span class="hljs-string">&quot;scheduler&quot;</span>, type_hint=EulerDiscreteScheduler)
]

expected_config = [
    ConfigSpec(<span class="hljs-string">&quot;force_zeros_for_empty_prompt&quot;</span>, <span class="hljs-literal">True</span>)
]`,wrap:!1}}),x=new D({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBY2Nlc3MlMjBjb21wb25lbnRzJTIwdXNpbmclMjBkb3QlMjBub3RhdGlvbiUwQSUyMCUyMCUyMCUyMHVuZXQlMjAlM0QlMjBjb21wb25lbnRzLnVuZXQlMEElMjAlMjAlMjAlMjB2YWUlMjAlM0QlMjBjb21wb25lbnRzLnZhZSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUyMCUzRCUyMGNvbXBvbmVudHMuc2NoZWR1bGVy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
    <span class="hljs-comment"># Access components using dot notation</span>
    unet = components.unet
    vae = components.vae
    scheduler = components.scheduler`,wrap:!1}}),W=new Ke({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/pipeline_block.md"}}),{c(){h=a("meta"),O=i(),N=a("p"),K=i(),d(U.$$.fragment),ee=i(),d(w.$$.fragment),te=i(),T=a("p"),T.innerHTML=Ze,le=i(),k=a("p"),k.innerHTML=Je,se=i(),$=a("p"),$.innerHTML=Re,ie=i(),d(B.$$.fragment),ne=i(),_=a("blockquote"),_.innerHTML=Se,ae=i(),C=a("p"),C.innerHTML=Ve,oe=i(),j=a("ul"),y=a("li"),L=a("p"),L.innerHTML=He,ke=i(),X=a("p"),X.innerHTML=Ie,$e=i(),d(v.$$.fragment),Be=i(),b=a("li"),z=a("p"),z.innerHTML=Pe,Ce=i(),A=a("p"),A.innerHTML=Ee,ve=i(),d(g.$$.fragment),pe=i(),G=a("p"),G.textContent=xe,re=i(),d(Z.$$.fragment),de=i(),J=a("p"),J.innerHTML=We,ce=i(),R=a("ol"),R.innerHTML=Le,ue=i(),d(S.$$.fragment),fe=i(),d(V.$$.fragment),me=i(),H=a("p"),H.innerHTML=Xe,Me=i(),I=a("ul"),I.innerHTML=ze,he=i(),d(P.$$.fragment),ye=i(),E=a("p"),E.innerHTML=Ae,be=i(),d(x.$$.fragment),_e=i(),d(W.$$.fragment),je=i(),F=a("p"),this.h()},l(e){const t=De("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),O=n(e),N=o(e,"P",{}),q(N).forEach(l),K=n(e),c(U.$$.fragment,e),ee=n(e),c(w.$$.fragment,e),te=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-cj8g0i"&&(T.innerHTML=Ze),le=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-19agiu"&&(k.innerHTML=Je),se=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-8fu0w1"&&($.innerHTML=Re),ie=n(e),c(B.$$.fragment,e),ne=n(e),_=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-1sgfd79"&&(_.innerHTML=Se),ae=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-nui63e"&&(C.innerHTML=Ve),oe=n(e),j=o(e,"UL",{});var we=q(j);y=o(we,"LI",{});var Y=q(y);L=o(Y,"P",{"data-svelte-h":!0}),p(L)!=="svelte-wdjc3v"&&(L.innerHTML=He),ke=n(Y),X=o(Y,"P",{"data-svelte-h":!0}),p(X)!=="svelte-yx83i9"&&(X.innerHTML=Ie),$e=n(Y),c(v.$$.fragment,Y),Y.forEach(l),Be=n(we),b=o(we,"LI",{});var Q=q(b);z=o(Q,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ezs3pz"&&(z.innerHTML=Pe),Ce=n(Q),A=o(Q,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1wredql"&&(A.innerHTML=Ee),ve=n(Q),c(g.$$.fragment,Q),Q.forEach(l),we.forEach(l),pe=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-85xvms"&&(G.textContent=xe),re=n(e),c(Z.$$.fragment,e),de=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-ymvhyd"&&(J.innerHTML=We),ce=n(e),R=o(e,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-1q5kfeo"&&(R.innerHTML=Le),ue=n(e),c(S.$$.fragment,e),fe=n(e),c(V.$$.fragment,e),me=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1vve7vj"&&(H.innerHTML=Xe),Me=n(e),I=o(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-1aq4suh"&&(I.innerHTML=ze),he=n(e),c(P.$$.fragment,e),ye=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1cled56"&&(E.innerHTML=Ae),be=n(e),c(x.$$.fragment,e),_e=n(e),c(W.$$.fragment,e),je=n(e),F=o(e,"P",{}),q(F).forEach(l),this.h()},h(){ge(h,"name","hf:doc:metadata"),ge(h,"content",tt),ge(_,"class","tip")},m(e,t){r(document.head,h),s(e,O,t),s(e,N,t),s(e,K,t),u(U,e,t),s(e,ee,t),u(w,e,t),s(e,te,t),s(e,T,t),s(e,le,t),s(e,k,t),s(e,se,t),s(e,$,t),s(e,ie,t),u(B,e,t),s(e,ne,t),s(e,_,t),s(e,ae,t),s(e,C,t),s(e,oe,t),s(e,j,t),r(j,y),r(y,L),r(y,ke),r(y,X),r(y,$e),u(v,y,null),r(j,Be),r(j,b),r(b,z),r(b,Ce),r(b,A),r(b,ve),u(g,b,null),s(e,pe,t),s(e,G,t),s(e,re,t),u(Z,e,t),s(e,de,t),s(e,J,t),s(e,ce,t),s(e,R,t),s(e,ue,t),u(S,e,t),s(e,fe,t),u(V,e,t),s(e,me,t),s(e,H,t),s(e,Me,t),s(e,I,t),s(e,he,t),u(P,e,t),s(e,ye,t),s(e,E,t),s(e,be,t),u(x,e,t),s(e,_e,t),u(W,e,t),s(e,je,t),s(e,F,t),Ue=!0},p:Qe,i(e){Ue||(f(U.$$.fragment,e),f(w.$$.fragment,e),f(B.$$.fragment,e),f(v.$$.fragment,e),f(g.$$.fragment,e),f(Z.$$.fragment,e),f(S.$$.fragment,e),f(V.$$.fragment,e),f(P.$$.fragment,e),f(x.$$.fragment,e),f(W.$$.fragment,e),Ue=!0)},o(e){m(U.$$.fragment,e),m(w.$$.fragment,e),m(B.$$.fragment,e),m(v.$$.fragment,e),m(g.$$.fragment,e),m(Z.$$.fragment,e),m(S.$$.fragment,e),m(V.$$.fragment,e),m(P.$$.fragment,e),m(x.$$.fragment,e),m(W.$$.fragment,e),Ue=!1},d(e){e&&(l(O),l(N),l(K),l(ee),l(te),l(T),l(le),l(k),l(se),l($),l(ie),l(ne),l(_),l(ae),l(C),l(oe),l(j),l(pe),l(G),l(re),l(de),l(J),l(ce),l(R),l(ue),l(fe),l(me),l(H),l(Me),l(I),l(he),l(ye),l(E),l(be),l(_e),l(je),l(F)),l(h),M(U,e),M(w,e),M(B,e),M(v),M(g),M(Z,e),M(S,e),M(V,e),M(P,e),M(x,e),M(W,e)}}}const tt='{"title":"ModularPipelineBlocks","local":"modularpipelineblocks","sections":[{"title":"Inputs and outputs","local":"inputs-and-outputs","sections":[],"depth":2},{"title":"Computation logic","local":"computation-logic","sections":[{"title":"Components and configs","local":"components-and-configs","sections":[],"depth":3}],"depth":2}],"depth":1}';function lt(Ge){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pt extends Fe{constructor(h){super(),qe(this,h,lt,et,Ye,{})}}export{pt as component};
