import{s as Kt,n as Ot,o as te}from"../chunks/scheduler.53228c21.js";import{S as ee,i as ne,e as o,s as l,c as r,h as ae,a as i,d as n,b as s,f as zt,g as c,j as d,k as V,l as le,m as a,n as p,t as h,o as m,p as f}from"../chunks/index.100fac89.js";import{C as se}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{C as N}from"../chunks/CodeBlock.d30a6509.js";import{H as z,E as oe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function ie(Zt){let u,K,D,O,w,tt,T,et,b,St="<p>The attention dispatcher is an experimental feature. Please open an issue if you have any feedback or encounter any problems.</p>",nt,g,Gt="Diffusers provides several optimized attention algorithms that are more memory and computationally efficient through it’s <em>attention dispatcher</em>. The dispatcher acts as a router for managing and switching between different attention implementations and provides a unified interface for interacting with them.",at,k,xt='Refer to the table below for an overview of the available attention families and to the <a href="#available-backends">Available backends</a> section for a more complete list.',lt,U,At='<thead><tr><th>attention family</th> <th>main feature</th></tr></thead> <tbody><tr><td>FlashAttention</td> <td>minimizes memory reads/writes through tiling and recomputation</td></tr> <tr><td>AI Tensor Engine for ROCm</td> <td>FlashAttention implementation optimized for AMD ROCm accelerators</td></tr> <tr><td>SageAttention</td> <td>quantizes attention to int8</td></tr> <tr><td>PyTorch native</td> <td>built-in PyTorch implementation using <a href="./fp16#scaled-dot-product-attention">scaled_dot_product_attention</a></td></tr> <tr><td>xFormers</td> <td>memory-efficient attention with support for various attention kernels</td></tr></tbody>',st,_,Ft="This guide will show you how to set and use the different attention backends.",ot,J,it,v,Wt='The <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.set_attention_backend">set_attention_backend()</a> method iterates through all the modules in the model and sets the appropriate attention backend to use. The attention backend setting persists until <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.reset_attention_backend">reset_attention_backend()</a> is called.',dt,j,Qt='The example below demonstrates how to enable the <code>_flash_3_hub</code> implementation for FlashAttention-3 from the <a href="https://github.com/huggingface/kernels" rel="nofollow">kernel</a> library, which allows you to instantly use optimized compute kernels from the Hub without requiring any setup.',rt,y,Rt="<p>FlashAttention-3 is not supported for non-Hopper architectures, in which case, use FlashAttention with <code>set_attention_backend(&quot;flash&quot;)</code>.</p>",ct,$,pt,C,Ht='To restore the default attention backend, call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.reset_attention_backend">reset_attention_backend()</a>.',ht,I,mt,B,ft,Z,Et='The <a href="https://github.com/huggingface/diffusers/blob/5e181eddfe7e44c1444a2511b0d8e21d177850a0/src/diffusers/models/attention_dispatch.py#L225" rel="nofollow">attention_backend</a> context manager temporarily sets an attention backend for a model within the context. Outside the context, the default attention (PyTorch’s native scaled dot product attention) is used. This is useful if you want to use different backends for different parts of a pipeline or if you want to test the different backends.',ut,S,bt,M,Pt="<p>Most attention backends support <code>torch.compile</code> without graph breaks and can be used to further speed up inference.</p>",yt,G,Mt,x,Yt="The attention dispatcher includes debugging checks that catch common errors before they cause problems.",wt,A,qt="<li>Device checks verify that query, key, and value tensors live on the same device.</li> <li>Data type checks confirm tensors have matching dtypes and use either bfloat16 or float16.</li> <li>Shape checks validate tensor dimensions and prevent mixing attention masks with causal flags.</li>",Tt,F,Xt="Enable these checks by setting the <code>DIFFUSERS_ATTN_CHECKS</code> environment variable. Checks add overhead to every attention operation, so they’re disabled by default.",gt,W,kt,Q,Nt="The checks are run now before every attention operation.",Ut,R,_t,H,Dt="You can also configure the registry directly.",Jt,E,vt,P,jt,Y,Lt="Refer to the table below for a complete list of available attention backends and their variants.",$t,q,Vt='<summary>Expand</summary> <table><thead><tr><th>Backend Name</th> <th>Family</th> <th>Description</th></tr></thead> <tbody><tr><td><code>native</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Default backend using PyTorch’s scaled_dot_product_attention</td></tr> <tr><td><code>flex</code></td> <td><a href="https://docs.pytorch.org/docs/stable/nn.attention.flex_attention.html#module-torch.nn.attention.flex_attention" rel="nofollow">FlexAttention</a></td> <td>PyTorch FlexAttention implementation</td></tr> <tr><td><code>_native_cudnn</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>CuDNN-optimized attention</td></tr> <tr><td><code>_native_efficient</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Memory-efficient attention</td></tr> <tr><td><code>_native_flash</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>PyTorch’s FlashAttention</td></tr> <tr><td><code>_native_math</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Math-based attention (fallback)</td></tr> <tr><td><code>_native_npu</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>NPU-optimized attention</td></tr> <tr><td><code>_native_xla</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>XLA-optimized attention</td></tr> <tr><td><code>flash</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-2</td></tr> <tr><td><code>flash_varlen</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>Variable length FlashAttention</td></tr> <tr><td><code>aiter</code></td> <td><a href="https://github.com/ROCm/aiter" rel="nofollow">AI Tensor Engine for ROCm</a></td> <td>FlashAttention for AMD ROCm</td></tr> <tr><td><code>_flash_3</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-3</td></tr> <tr><td><code>_flash_varlen_3</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>Variable length FlashAttention-3</td></tr> <tr><td><code>_flash_3_hub</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-3 from kernels</td></tr> <tr><td><code>sage</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>Quantized attention (INT8 QK)</td></tr> <tr><td><code>sage_varlen</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>Variable length SageAttention</td></tr> <tr><td><code>_sage_qk_int8_pv_fp8_cuda</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP8 PV (CUDA)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp8_cuda_sm90</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP8 PV (SM90)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp16_cuda</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP16 PV (CUDA)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp16_triton</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP16 PV (Triton)</td></tr> <tr><td><code>xformers</code></td> <td><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a></td> <td>Memory-efficient attention</td></tr></tbody></table>',Ct,X,It,L,Bt;return w=new se({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new z({props:{title:"Attention backends",local:"attention-backends",headingTag:"h1"}}),J=new z({props:{title:"set_attention_backend",local:"setattentionbackend",headingTag:"h2"}}),$=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS50cmFuc2Zvcm1lci5zZXRfYXR0ZW50aW9uX2JhY2tlbmQoJTIyX2ZsYXNoXzNfaHViJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUwQWNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwYSUyMGNhdCUyMHNpcHBpbmclMjBhJTIwbWFyZ2FyaXRhJTIwaW4lMjBhJTIwcG9vbCUyMGluJTIwUGFsbSUyMFNwcmluZ3MlMkMlMjBDYWxpZm9ybmlhJTBBaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTBBJTIyJTIyJTIyJTBBcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.transformer.set_attention_backend(<span class="hljs-string">&quot;_flash_3_hub&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),I=new N({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIucmVzZXRfYXR0ZW50aW9uX2JhY2tlbmQoKQ==",highlighted:"pipeline.transformer.reset_attention_backend()",wrap:!1}}),B=new z({props:{title:"attention_backend context manager",local:"attentionbackend-context-manager",headingTag:"h2"}}),S=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQWhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQSUwQXdpdGglMjBhdHRlbnRpb25fYmFja2VuZCglMjJfZmxhc2hfM19odWIlMjIpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

<span class="hljs-keyword">with</span> attention_backend(<span class="hljs-string">&quot;_flash_3_hub&quot;</span>):
    image = pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),G=new z({props:{title:"Checks",local:"checks",headingTag:"h2"}}),W=new N({props:{code:"ZXhwb3J0JTIwRElGRlVTRVJTX0FUVE5fQ0hFQ0tTJTNEeWVz",highlighted:'<span class="hljs-built_in">export</span> DIFFUSERS_ATTN_CHECKS=<span class="hljs-built_in">yes</span>',wrap:!1}}),R=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFxdWVyeSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAxMCUyQyUyMDglMkMlMjA2NCUyQyUyMGR0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQWtleSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAxMCUyQyUyMDglMkMlMjA2NCUyQyUyMGR0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXZhbHVlJTIwJTNEJTIwdG9yY2gucmFuZG4oMSUyQyUyMDEwJTJDJTIwOCUyQyUyMDY0JTJDJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIpJTBBJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGF0dGVudGlvbl9iYWNrZW5kKCUyMmZsYXNoJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMGRpc3BhdGNoX2F0dGVudGlvbl9mbihxdWVyeSUyQyUyMGtleSUyQyUyMHZhbHVlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5QyU5MyUyMEZsYXNoJTIwQXR0ZW50aW9uJTIwd29ya3MlMjB3aXRoJTIwY2hlY2tzJTIwZW5hYmxlZCUyMiklMEFleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlDJTk3JTIwRmxhc2glMjBBdHRlbnRpb24lMjBmYWlsZWQlM0ElMjAlN0JlJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

query = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>, <span class="hljs-number">8</span>, <span class="hljs-number">64</span>, dtype=torch.bfloat16, device=<span class="hljs-string">&quot;cuda&quot;</span>)
key = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>, <span class="hljs-number">8</span>, <span class="hljs-number">64</span>, dtype=torch.bfloat16, device=<span class="hljs-string">&quot;cuda&quot;</span>)
value = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>, <span class="hljs-number">8</span>, <span class="hljs-number">64</span>, dtype=torch.bfloat16, device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">try</span>:
    <span class="hljs-keyword">with</span> attention_backend(<span class="hljs-string">&quot;flash&quot;</span>):
        output = dispatch_attention_fn(query, key, value)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✓ Flash Attention works with checks enabled&quot;</span>)
<span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✗ Flash Attention failed: <span class="hljs-subst">{e}</span>&quot;</span>)`,wrap:!1}}),E=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2RlbHMuYXR0ZW50aW9uX2Rpc3BhdGNoJTIwaW1wb3J0JTIwX0F0dGVudGlvbkJhY2tlbmRSZWdpc3RyeSUwQSUwQV9BdHRlbnRpb25CYWNrZW5kUmVnaXN0cnkuX2NoZWNrc19lbmFibGVkJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers.models.attention_dispatch <span class="hljs-keyword">import</span> _AttentionBackendRegistry

_AttentionBackendRegistry._checks_enabled = <span class="hljs-literal">True</span>`,wrap:!1}}),P=new z({props:{title:"Available backends",local:"available-backends",headingTag:"h2"}}),X=new oe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/attention_backends.md"}}),{c(){u=o("meta"),K=l(),D=o("p"),O=l(),r(w.$$.fragment),tt=l(),r(T.$$.fragment),et=l(),b=o("blockquote"),b.innerHTML=St,nt=l(),g=o("p"),g.innerHTML=Gt,at=l(),k=o("p"),k.innerHTML=xt,lt=l(),U=o("table"),U.innerHTML=At,st=l(),_=o("p"),_.textContent=Ft,ot=l(),r(J.$$.fragment),it=l(),v=o("p"),v.innerHTML=Wt,dt=l(),j=o("p"),j.innerHTML=Qt,rt=l(),y=o("blockquote"),y.innerHTML=Rt,ct=l(),r($.$$.fragment),pt=l(),C=o("p"),C.innerHTML=Ht,ht=l(),r(I.$$.fragment),mt=l(),r(B.$$.fragment),ft=l(),Z=o("p"),Z.innerHTML=Et,ut=l(),r(S.$$.fragment),bt=l(),M=o("blockquote"),M.innerHTML=Pt,yt=l(),r(G.$$.fragment),Mt=l(),x=o("p"),x.textContent=Yt,wt=l(),A=o("ol"),A.innerHTML=qt,Tt=l(),F=o("p"),F.innerHTML=Xt,gt=l(),r(W.$$.fragment),kt=l(),Q=o("p"),Q.textContent=Nt,Ut=l(),r(R.$$.fragment),_t=l(),H=o("p"),H.textContent=Dt,Jt=l(),r(E.$$.fragment),vt=l(),r(P.$$.fragment),jt=l(),Y=o("p"),Y.textContent=Lt,$t=l(),q=o("details"),q.innerHTML=Vt,Ct=l(),r(X.$$.fragment),It=l(),L=o("p"),this.h()},l(t){const e=ae("svelte-u9bgzb",document.head);u=i(e,"META",{name:!0,content:!0}),e.forEach(n),K=s(t),D=i(t,"P",{}),zt(D).forEach(n),O=s(t),c(w.$$.fragment,t),tt=s(t),c(T.$$.fragment,t),et=s(t),b=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(b)!=="svelte-7ay7vy"&&(b.innerHTML=St),nt=s(t),g=i(t,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1p5wykf"&&(g.innerHTML=Gt),at=s(t),k=i(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-q2vvjg"&&(k.innerHTML=xt),lt=s(t),U=i(t,"TABLE",{"data-svelte-h":!0}),d(U)!=="svelte-djamwt"&&(U.innerHTML=At),st=s(t),_=i(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1o85kpy"&&(_.textContent=Ft),ot=s(t),c(J.$$.fragment,t),it=s(t),v=i(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-k822hv"&&(v.innerHTML=Wt),dt=s(t),j=i(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-142if5b"&&(j.innerHTML=Qt),rt=s(t),y=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(y)!=="svelte-j6ruup"&&(y.innerHTML=Rt),ct=s(t),c($.$$.fragment,t),pt=s(t),C=i(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-41vsbn"&&(C.innerHTML=Ht),ht=s(t),c(I.$$.fragment,t),mt=s(t),c(B.$$.fragment,t),ft=s(t),Z=i(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-g6fiju"&&(Z.innerHTML=Et),ut=s(t),c(S.$$.fragment,t),bt=s(t),M=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(M)!=="svelte-1mkj6ep"&&(M.innerHTML=Pt),yt=s(t),c(G.$$.fragment,t),Mt=s(t),x=i(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-fodsmc"&&(x.textContent=Yt),wt=s(t),A=i(t,"OL",{"data-svelte-h":!0}),d(A)!=="svelte-1ylz7pk"&&(A.innerHTML=qt),Tt=s(t),F=i(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-nw9sbr"&&(F.innerHTML=Xt),gt=s(t),c(W.$$.fragment,t),kt=s(t),Q=i(t,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-9nu3ec"&&(Q.textContent=Nt),Ut=s(t),c(R.$$.fragment,t),_t=s(t),H=i(t,"P",{"data-svelte-h":!0}),d(H)!=="svelte-f6wmbe"&&(H.textContent=Dt),Jt=s(t),c(E.$$.fragment,t),vt=s(t),c(P.$$.fragment,t),jt=s(t),Y=i(t,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-frsh1o"&&(Y.textContent=Lt),$t=s(t),q=i(t,"DETAILS",{"data-svelte-h":!0}),d(q)!=="svelte-glnkza"&&(q.innerHTML=Vt),Ct=s(t),c(X.$$.fragment,t),It=s(t),L=i(t,"P",{}),zt(L).forEach(n),this.h()},h(){V(u,"name","hf:doc:metadata"),V(u,"content",de),V(b,"class","note"),V(y,"class","note"),V(M,"class","tip")},m(t,e){le(document.head,u),a(t,K,e),a(t,D,e),a(t,O,e),p(w,t,e),a(t,tt,e),p(T,t,e),a(t,et,e),a(t,b,e),a(t,nt,e),a(t,g,e),a(t,at,e),a(t,k,e),a(t,lt,e),a(t,U,e),a(t,st,e),a(t,_,e),a(t,ot,e),p(J,t,e),a(t,it,e),a(t,v,e),a(t,dt,e),a(t,j,e),a(t,rt,e),a(t,y,e),a(t,ct,e),p($,t,e),a(t,pt,e),a(t,C,e),a(t,ht,e),p(I,t,e),a(t,mt,e),p(B,t,e),a(t,ft,e),a(t,Z,e),a(t,ut,e),p(S,t,e),a(t,bt,e),a(t,M,e),a(t,yt,e),p(G,t,e),a(t,Mt,e),a(t,x,e),a(t,wt,e),a(t,A,e),a(t,Tt,e),a(t,F,e),a(t,gt,e),p(W,t,e),a(t,kt,e),a(t,Q,e),a(t,Ut,e),p(R,t,e),a(t,_t,e),a(t,H,e),a(t,Jt,e),p(E,t,e),a(t,vt,e),p(P,t,e),a(t,jt,e),a(t,Y,e),a(t,$t,e),a(t,q,e),a(t,Ct,e),p(X,t,e),a(t,It,e),a(t,L,e),Bt=!0},p:Ot,i(t){Bt||(h(w.$$.fragment,t),h(T.$$.fragment,t),h(J.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(B.$$.fragment,t),h(S.$$.fragment,t),h(G.$$.fragment,t),h(W.$$.fragment,t),h(R.$$.fragment,t),h(E.$$.fragment,t),h(P.$$.fragment,t),h(X.$$.fragment,t),Bt=!0)},o(t){m(w.$$.fragment,t),m(T.$$.fragment,t),m(J.$$.fragment,t),m($.$$.fragment,t),m(I.$$.fragment,t),m(B.$$.fragment,t),m(S.$$.fragment,t),m(G.$$.fragment,t),m(W.$$.fragment,t),m(R.$$.fragment,t),m(E.$$.fragment,t),m(P.$$.fragment,t),m(X.$$.fragment,t),Bt=!1},d(t){t&&(n(K),n(D),n(O),n(tt),n(et),n(b),n(nt),n(g),n(at),n(k),n(lt),n(U),n(st),n(_),n(ot),n(it),n(v),n(dt),n(j),n(rt),n(y),n(ct),n(pt),n(C),n(ht),n(mt),n(ft),n(Z),n(ut),n(bt),n(M),n(yt),n(Mt),n(x),n(wt),n(A),n(Tt),n(F),n(gt),n(kt),n(Q),n(Ut),n(_t),n(H),n(Jt),n(vt),n(jt),n(Y),n($t),n(q),n(Ct),n(It),n(L)),n(u),f(w,t),f(T,t),f(J,t),f($,t),f(I,t),f(B,t),f(S,t),f(G,t),f(W,t),f(R,t),f(E,t),f(P,t),f(X,t)}}}const de='{"title":"Attention backends","local":"attention-backends","sections":[{"title":"set_attention_backend","local":"setattentionbackend","sections":[],"depth":2},{"title":"attention_backend context manager","local":"attentionbackend-context-manager","sections":[],"depth":2},{"title":"Checks","local":"checks","sections":[],"depth":2},{"title":"Available backends","local":"available-backends","sections":[],"depth":2}],"depth":1}';function re(Zt){return te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ue extends ee{constructor(u){super(),ne(this,u,re,ie,Kt,{})}}export{ue as component};
