import{s as Mt,o as dt,n as Y}from"../chunks/scheduler.53228c21.js";import{S as ut,i as yt,e as y,s as m,c as U,h as ht,a as h,d as s,b as M,f as mt,g as Z,j as w,k as me,l as ft,m as a,n as B,t as I,o as _,p as C}from"../chunks/index.100fac89.js";import{C as Jt}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{C as $}from"../chunks/CodeBlock.d30a6509.js";import{H as ye,E as wt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";import{H as Re,a as R}from"../chunks/HfOption.fad27e59.js";function jt(G){let l,d="To apply first block cache on FLUX.1-dev, call <code>apply_cache_on_pipe</code> as shown below. 0.08 is the default residual difference value for FLUX models.",p,r,t,n,j='<thead><tr><th>Optimizations</th> <th>Original</th> <th>FBCache rdt=0.06</th> <th>FBCache rdt=0.08</th> <th>FBCache rdt=0.10</th> <th>FBCache rdt=0.12</th></tr></thead> <tbody><tr><td>Preview</td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-original.png" alt="Original"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-fbc-0.06.png" alt="FBCache rdt=0.06"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-fbc-0.08.png" alt="FBCache rdt=0.08"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-fbc-0.10.png" alt="FBCache rdt=0.10"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-fbc-0.12.png" alt="FBCache rdt=0.12"/></td></tr> <tr><td>Wall Time (s)</td> <td>26.36</td> <td>21.83</td> <td>17.01</td> <td>16.00</td> <td>13.78</td></tr></tbody>',J,c,W="First Block Cache reduced the inference speed to 17.01 seconds compared to the baseline, or 1.55x faster, while maintaining nearly zero quality loss.",b;return r=new $({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZnJvbSUyMHBhcmFfYXR0bi5maXJzdF9ibG9ja19jYWNoZS5kaWZmdXNlcnNfYWRhcHRlcnMlMjBpbXBvcnQlMjBhcHBseV9jYWNoZV9vbl9waXBlJTBBJTBBYXBwbHlfY2FjaGVfb25fcGlwZShwaXBlJTJDJTIwcmVzaWR1YWxfZGlmZl90aHJlc2hvbGQlM0QwLjA4KSUwQSUwQSUyMyUyMEVuYWJsZSUyMG1lbW9yeSUyMHNhdmluZ3MlMEElMjMlMjBwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBJTBBYmVnaW4lMjAlM0QlMjB0aW1lLnRpbWUoKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZW5kJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyVGltZSUzQSUyMCU3QmVuZCUyMC0lMjBiZWdpbiUzQS4yZiU3RHMlMjIpJTBBJTBBcHJpbnQoJTIyU2F2aW5nJTIwaW1hZ2UlMjB0byUyMGZsdXgucG5nJTIyKSUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(pipe, residual_diff_threshold=<span class="hljs-number">0.08</span>)

<span class="hljs-comment"># Enable memory savings</span>
<span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload()</span>

begin = time.time()
image = pipe(
    <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
).images[<span class="hljs-number">0</span>]
end = time.time()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving image to flux.png&quot;</span>)
image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){l=y("p"),l.innerHTML=d,p=m(),U(r.$$.fragment),t=m(),n=y("table"),n.innerHTML=j,J=m(),c=y("p"),c.textContent=W},l(u){l=h(u,"P",{"data-svelte-h":!0}),w(l)!=="svelte-1gztnit"&&(l.innerHTML=d),p=M(u),Z(r.$$.fragment,u),t=M(u),n=h(u,"TABLE",{"data-svelte-h":!0}),w(n)!=="svelte-oatp7r"&&(n.innerHTML=j),J=M(u),c=h(u,"P",{"data-svelte-h":!0}),w(c)!=="svelte-1igi2g7"&&(c.textContent=W)},m(u,g){a(u,l,g),a(u,p,g),B(r,u,g),a(u,t,g),a(u,n,g),a(u,J,g),a(u,c,g),b=!0},p:Y,i(u){b||(I(r.$$.fragment,u),b=!0)},o(u){_(r.$$.fragment,u),b=!1},d(u){u&&(s(l),s(p),s(t),s(n),s(J),s(c)),C(r,u)}}}function Tt(G){let l,d="To apply First Block Cache on HunyuanVideo, <code>apply_cache_on_pipe</code> as shown below. 0.06 is the default residual difference value for HunyuanVideo models.",p,r,t,n,j=`<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/hunyuan-video-original.mp4" type="video/mp4"/>
  Your browser does not support the video tag.`,J,c,W="HunyuanVideo without FBCache",b,u,g=`<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/hunyuan-video-fbc.mp4" type="video/mp4"/>
  Your browser does not support the video tag.`,o,T,Me="HunyuanVideo with FBCache",X,V,de="First Block Cache reduced the inference speed to 2271.06 seconds compared to the baseline, or 1.62x faster, while maintaining nearly zero quality loss.",k;return r=new $({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lJTJDJTIwSHVueXVhblZpZGVvVHJhbnNmb3JtZXIzRE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGVuY2VudCUyRkh1bnl1YW5WaWRlbyUyMiUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwSHVueXVhblZpZGVvVHJhbnNmb3JtZXIzRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIycmVmcyUyRnByJTJGMTglMjIlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRCUyMnJlZnMlMkZwciUyRjE4JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWZyb20lMjBwYXJhX2F0dG4uZmlyc3RfYmxvY2tfY2FjaGUuZGlmZnVzZXJzX2FkYXB0ZXJzJTIwaW1wb3J0JTIwYXBwbHlfY2FjaGVfb25fcGlwZSUwQSUwQWFwcGx5X2NhY2hlX29uX3BpcGUocGlwZSUyQyUyMHJlc2lkdWFsX2RpZmZfdGhyZXNob2xkJTNEMC42KSUwQSUwQXBpcGUudmFlLmVuYWJsZV90aWxpbmcoKSUwQSUwQWJlZ2luJTIwJTNEJTIwdGltZS50aW1lKCklMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBjYXQlMjB3YWxrcyUyMG9uJTIwdGhlJTIwZ3Jhc3MlMkMlMjByZWFsaXN0aWMlMjIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3MjAlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEyODAlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTI5JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZW5kJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyVGltZSUzQSUyMCU3QmVuZCUyMC0lMjBiZWdpbiUzQS4yZiU3RHMlMjIpJTBBJTBBcHJpbnQoJTIyU2F2aW5nJTIwdmlkZW8lMjB0byUyMGh1bnl1YW5fdmlkZW8ubXA0JTIyKSUwQWV4cG9ydF90b192aWRlbyhvdXRwdXQlMkMlMjAlMjJodW55dWFuX3ZpZGVvLm1wNCUyMiUyQyUyMGZwcyUzRDE1KQ==",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>
transformer = HunyuanVideoTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
)
pipe = HunyuanVideoPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=torch.float16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(pipe, residual_diff_threshold=<span class="hljs-number">0.6</span>)

pipe.vae.enable_tiling()

begin = time.time()
output = pipe(
    prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
    height=<span class="hljs-number">720</span>,
    width=<span class="hljs-number">1280</span>,
    num_frames=<span class="hljs-number">129</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
).frames[<span class="hljs-number">0</span>]
end = time.time()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving video to hunyuan_video.mp4&quot;</span>)
export_to_video(output, <span class="hljs-string">&quot;hunyuan_video.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){l=y("p"),l.innerHTML=d,p=m(),U(r.$$.fragment),t=m(),n=y("video"),n.innerHTML=j,J=m(),c=y("small"),c.textContent=W,b=m(),u=y("video"),u.innerHTML=g,o=m(),T=y("small"),T.textContent=Me,X=m(),V=y("p"),V.textContent=de,this.h()},l(f){l=h(f,"P",{"data-svelte-h":!0}),w(l)!=="svelte-ijrywe"&&(l.innerHTML=d),p=M(f),Z(r.$$.fragment,f),t=M(f),n=h(f,"VIDEO",{"data-svelte-h":!0}),w(n)!=="svelte-o0uc7b"&&(n.innerHTML=j),J=M(f),c=h(f,"SMALL",{"data-svelte-h":!0}),w(c)!=="svelte-1m2snav"&&(c.textContent=W),b=M(f),u=h(f,"VIDEO",{"data-svelte-h":!0}),w(u)!=="svelte-1lwel73"&&(u.innerHTML=g),o=M(f),T=h(f,"SMALL",{"data-svelte-h":!0}),w(T)!=="svelte-8iknyh"&&(T.textContent=Me),X=M(f),V=h(f,"P",{"data-svelte-h":!0}),w(V)!=="svelte-1ufkyta"&&(V.textContent=de),this.h()},h(){n.controls="",u.controls=""},m(f,v){a(f,l,v),a(f,p,v),B(r,f,v),a(f,t,v),a(f,n,v),a(f,J,v),a(f,c,v),a(f,b,v),a(f,u,v),a(f,o,v),a(f,T,v),a(f,X,v),a(f,V,v),k=!0},p:Y,i(f){k||(I(r.$$.fragment,f),k=!0)},o(f){_(r.$$.fragment,f),k=!1},d(f){f&&(s(l),s(p),s(t),s(n),s(J),s(c),s(b),s(u),s(o),s(T),s(X),s(V)),C(r,f)}}}function bt(G){let l,d,p,r;return l=new R({props:{id:"first-block-cache",option:"FLUX-1.dev",$$slots:{default:[jt]},$$scope:{ctx:G}}}),p=new R({props:{id:"first-block-cache",option:"HunyuanVideo",$$slots:{default:[Tt]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=m(),U(p.$$.fragment)},l(t){Z(l.$$.fragment,t),d=M(t),Z(p.$$.fragment,t)},m(t,n){B(l,t,n),a(t,d,n),B(p,t,n),r=!0},p(t,n){const j={};n&2&&(j.$$scope={dirty:n,ctx:t}),l.$set(j);const J={};n&2&&(J.$$scope={dirty:n,ctx:t}),p.$set(J)},i(t){r||(I(l.$$.fragment,t),I(p.$$.fragment,t),r=!0)},o(t){_(l.$$.fragment,t),_(p.$$.fragment,t),r=!1},d(t){t&&s(d),C(l,t),C(p,t)}}}function Ut(G){let l,d,p,r="fp8 dynamic quantization and torch.compile reduced the inference speed to 7.56 seconds compared to the baseline, or 3.48x faster.",t;return l=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(
    pipe,
    residual_diff_threshold=<span class="hljs-number">0.12</span>,  <span class="hljs-comment"># Use a larger value to make the cache take effect</span>
)

<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> quantize_, float8_dynamic_activation_float8_weight, float8_weight_only

quantize_(pipe.text_encoder, float8_weight_only())
quantize_(pipe.transformer, float8_dynamic_activation_float8_weight())
pipe.transformer = torch.<span class="hljs-built_in">compile</span>(
   pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune-no-cudagraphs&quot;</span>,
)

<span class="hljs-comment"># Enable memory savings</span>
<span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload()</span>

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):
    begin = time.time()
    image = pipe(
        <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
        num_inference_steps=<span class="hljs-number">28</span>,
    ).images[<span class="hljs-number">0</span>]
    end = time.time()
    <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warm up time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving image to flux.png&quot;</span>)
image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){U(l.$$.fragment),d=m(),p=y("p"),p.textContent=r},l(n){Z(l.$$.fragment,n),d=M(n),p=h(n,"P",{"data-svelte-h":!0}),w(p)!=="svelte-2k6y70"&&(p.textContent=r)},m(n,j){B(l,n,j),a(n,d,j),a(n,p,j),t=!0},p:Y,i(n){t||(I(l.$$.fragment,n),t=!0)},o(n){_(l.$$.fragment,n),t=!1},d(n){n&&(s(d),s(p)),C(l,n)}}}function Zt(G){let l,d,p,r="A NVIDIA L20 GPU only has 48GB memory and could face out-of-memory (OOM) errors after compilation and if <code>enable_model_cpu_offload</code> isn’t called because HunyuanVideo has very large activation tensors when running with high resolution and large number of frames. For GPUs with less than 80GB of memory, you can try reducing the resolution and number of frames to avoid OOM errors.",t,n,j="Large video generation models are usually bottlenecked by the attention computations rather than the fully connected layers. These models don’t significantly benefit from quantization and torch.compile.",J;return l=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>
transformer = HunyuanVideoTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
)
pipe = HunyuanVideoPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=torch.float16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(pipe)

<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> quantize_, float8_dynamic_activation_float8_weight, float8_weight_only

quantize_(pipe.text_encoder, float8_weight_only())
quantize_(pipe.transformer, float8_dynamic_activation_float8_weight())
pipe.transformer = torch.<span class="hljs-built_in">compile</span>(
   pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune-no-cudagraphs&quot;</span>,
)

<span class="hljs-comment"># Enable memory savings</span>
pipe.vae.enable_tiling()
<span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload()</span>

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):
    begin = time.time()
    output = pipe(
        prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
        height=<span class="hljs-number">720</span>,
        width=<span class="hljs-number">1280</span>,
        num_frames=<span class="hljs-number">129</span>,
        num_inference_steps=<span class="hljs-number">1</span> <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">30</span>,
    ).frames[<span class="hljs-number">0</span>]
    end = time.time()
    <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warm up time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving video to hunyuan_video.mp4&quot;</span>)
export_to_video(output, <span class="hljs-string">&quot;hunyuan_video.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){U(l.$$.fragment),d=m(),p=y("p"),p.innerHTML=r,t=m(),n=y("p"),n.textContent=j},l(c){Z(l.$$.fragment,c),d=M(c),p=h(c,"P",{"data-svelte-h":!0}),w(p)!=="svelte-1rkmqqz"&&(p.innerHTML=r),t=M(c),n=h(c,"P",{"data-svelte-h":!0}),w(n)!=="svelte-2mgvjd"&&(n.textContent=j)},m(c,W){B(l,c,W),a(c,d,W),a(c,p,W),a(c,t,W),a(c,n,W),J=!0},p:Y,i(c){J||(I(l.$$.fragment,c),J=!0)},o(c){_(l.$$.fragment,c),J=!1},d(c){c&&(s(d),s(p),s(t),s(n)),C(l,c)}}}function Bt(G){let l,d,p,r;return l=new R({props:{id:"fp8-quantization",option:"FLUX-1.dev",$$slots:{default:[Ut]},$$scope:{ctx:G}}}),p=new R({props:{id:"fp8-quantization",option:"HunyuanVideo",$$slots:{default:[Zt]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=m(),U(p.$$.fragment)},l(t){Z(l.$$.fragment,t),d=M(t),Z(p.$$.fragment,t)},m(t,n){B(l,t,n),a(t,d,n),B(p,t,n),r=!0},p(t,n){const j={};n&2&&(j.$$scope={dirty:n,ctx:t}),l.$set(j);const J={};n&2&&(J.$$scope={dirty:n,ctx:t}),p.$set(J)},i(t){r||(I(l.$$.fragment,t),I(p.$$.fragment,t),r=!0)},o(t){_(l.$$.fragment,t),_(p.$$.fragment,t),r=!1},d(t){t&&s(d),C(l,t),C(p,t)}}}function It(G){let l,d="The code sample below combines First Block Cache, fp8 dynamic quantization, torch.compile, and Context Parallelism for the fastest inference speed.",p,r,t,n,j='Save to <code>run_flux.py</code> and launch it with <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>.',J,c,W,b,u="Inference speed is reduced to 8.20 seconds compared to the baseline, or 3.21x faster, with 2 NVIDIA L20 GPUs. On 4 L20s, inference speed is 3.90 seconds, or 6.75x faster.",g;return r=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

dist.init_process_group()

torch.cuda.set_device(dist.get_rank())

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.context_parallel <span class="hljs-keyword">import</span> init_context_parallel_mesh
<span class="hljs-keyword">from</span> para_attn.context_parallel.diffusers_adapters <span class="hljs-keyword">import</span> parallelize_pipe
<span class="hljs-keyword">from</span> para_attn.parallel_vae.diffusers_adapters <span class="hljs-keyword">import</span> parallelize_vae

mesh = init_context_parallel_mesh(
    pipe.device.<span class="hljs-built_in">type</span>,
    max_ring_dim_size=<span class="hljs-number">2</span>,
)
parallelize_pipe(
    pipe,
    mesh=mesh,
)
parallelize_vae(pipe.vae, mesh=mesh._flatten())

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(
    pipe,
    residual_diff_threshold=<span class="hljs-number">0.12</span>,  <span class="hljs-comment"># Use a larger value to make the cache take effect</span>
)

<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> quantize_, float8_dynamic_activation_float8_weight, float8_weight_only

quantize_(pipe.text_encoder, float8_weight_only())
quantize_(pipe.transformer, float8_dynamic_activation_float8_weight())
torch._inductor.config.reorder_for_compute_comm_overlap = <span class="hljs-literal">True</span>
pipe.transformer = torch.<span class="hljs-built_in">compile</span>(
   pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune-no-cudagraphs&quot;</span>,
)

<span class="hljs-comment"># Enable memory savings</span>
<span class="hljs-comment"># pipe.enable_model_cpu_offload(gpu_id=dist.get_rank())</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload(gpu_id=dist.get_rank())</span>

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):
    begin = time.time()
    image = pipe(
        <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
        num_inference_steps=<span class="hljs-number">28</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span> <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;pt&quot;</span>,
    ).images[<span class="hljs-number">0</span>]
    end = time.time()
    <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
        <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warm up time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving image to flux.png&quot;</span>)
    image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)

dist.destroy_process_group()`,wrap:!1}}),c=new $({props:{code:"JTIzJTIwVXNlJTIwLS1ucHJvY19wZXJfbm9kZSUyMHRvJTIwc3BlY2lmeSUyMHRoZSUyMG51bWJlciUyMG9mJTIwR1BVcyUwQXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjBydW5fZmx1eC5weQ==",highlighted:`<span class="hljs-comment"># Use --nproc_per_node to specify the number of GPUs</span>
torchrun --nproc_per_node=2 run_flux.py`,wrap:!1}}),{c(){l=y("p"),l.textContent=d,p=m(),U(r.$$.fragment),t=m(),n=y("p"),n.innerHTML=j,J=m(),U(c.$$.fragment),W=m(),b=y("p"),b.textContent=u},l(o){l=h(o,"P",{"data-svelte-h":!0}),w(l)!=="svelte-l7izr3"&&(l.textContent=d),p=M(o),Z(r.$$.fragment,o),t=M(o),n=h(o,"P",{"data-svelte-h":!0}),w(n)!=="svelte-1gsxpvn"&&(n.innerHTML=j),J=M(o),Z(c.$$.fragment,o),W=M(o),b=h(o,"P",{"data-svelte-h":!0}),w(b)!=="svelte-11xwpjh"&&(b.textContent=u)},m(o,T){a(o,l,T),a(o,p,T),B(r,o,T),a(o,t,T),a(o,n,T),a(o,J,T),B(c,o,T),a(o,W,T),a(o,b,T),g=!0},p:Y,i(o){g||(I(r.$$.fragment,o),I(c.$$.fragment,o),g=!0)},o(o){_(r.$$.fragment,o),_(c.$$.fragment,o),g=!1},d(o){o&&(s(l),s(p),s(t),s(n),s(J),s(W),s(b)),C(r,o),C(c,o)}}}function _t(G){let l,d="The code sample below combines First Block Cache and Context Parallelism for the fastest inference speed.",p,r,t,n,j='Save to <code>run_hunyuan_video.py</code> and launch it with <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>.',J,c,W,b,u="Inference speed is reduced to 649.23 seconds compared to the baseline, or 5.66x faster, with 8 NVIDIA L20 GPUs.",g;return r=new $({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwdG9yY2guZGlzdHJpYnV0ZWQlMjBhcyUyMGRpc3QlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSHVueXVhblZpZGVvUGlwZWxpbmUlMkMlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBZGlzdC5pbml0X3Byb2Nlc3NfZ3JvdXAoKSUwQSUwQXRvcmNoLmN1ZGEuc2V0X2RldmljZShkaXN0LmdldF9yYW5rKCkpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJ0ZW5jZW50JTJGSHVueXVhblZpZGVvJTIyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYxOCUyMiUyQyUwQSklMEFwaXBlJTIwJTNEJTIwSHVueXVhblZpZGVvUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIycmVmcyUyRnByJTJGMTglMjIlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZnJvbSUyMHBhcmFfYXR0bi5jb250ZXh0X3BhcmFsbGVsJTIwaW1wb3J0JTIwaW5pdF9jb250ZXh0X3BhcmFsbGVsX21lc2glMEFmcm9tJTIwcGFyYV9hdHRuLmNvbnRleHRfcGFyYWxsZWwuZGlmZnVzZXJzX2FkYXB0ZXJzJTIwaW1wb3J0JTIwcGFyYWxsZWxpemVfcGlwZSUwQWZyb20lMjBwYXJhX2F0dG4ucGFyYWxsZWxfdmFlLmRpZmZ1c2Vyc19hZGFwdGVycyUyMGltcG9ydCUyMHBhcmFsbGVsaXplX3ZhZSUwQSUwQW1lc2glMjAlM0QlMjBpbml0X2NvbnRleHRfcGFyYWxsZWxfbWVzaCglMEElMjAlMjAlMjAlMjBwaXBlLmRldmljZS50eXBlJTJDJTBBKSUwQXBhcmFsbGVsaXplX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZSUyQyUwQSUyMCUyMCUyMCUyMG1lc2glM0RtZXNoJTJDJTBBKSUwQXBhcmFsbGVsaXplX3ZhZShwaXBlLnZhZSUyQyUyMG1lc2glM0RtZXNoLl9mbGF0dGVuKCkpJTBBJTBBZnJvbSUyMHBhcmFfYXR0bi5maXJzdF9ibG9ja19jYWNoZS5kaWZmdXNlcnNfYWRhcHRlcnMlMjBpbXBvcnQlMjBhcHBseV9jYWNoZV9vbl9waXBlJTBBJTBBYXBwbHlfY2FjaGVfb25fcGlwZShwaXBlKSUwQSUwQSUyMyUyMGZyb20lMjB0b3JjaGFvLnF1YW50aXphdGlvbiUyMGltcG9ydCUyMHF1YW50aXplXyUyQyUyMGZsb2F0OF9keW5hbWljX2FjdGl2YXRpb25fZmxvYXQ4X3dlaWdodCUyQyUyMGZsb2F0OF93ZWlnaHRfb25seSUwQSUyMyUwQSUyMyUyMHRvcmNoLl9pbmR1Y3Rvci5jb25maWcucmVvcmRlcl9mb3JfY29tcHV0ZV9jb21tX292ZXJsYXAlMjAlM0QlMjBUcnVlJTBBJTIzJTBBJTIzJTIwcXVhbnRpemVfKHBpcGUudGV4dF9lbmNvZGVyJTJDJTIwZmxvYXQ4X3dlaWdodF9vbmx5KCkpJTBBJTIzJTIwcXVhbnRpemVfKHBpcGUudHJhbnNmb3JtZXIlMkMlMjBmbG9hdDhfZHluYW1pY19hY3RpdmF0aW9uX2Zsb2F0OF93ZWlnaHQoKSklMEElMjMlMjBwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZSglMEElMjMlMjAlMjAlMjAlMjBwaXBlLnRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZS1uby1jdWRhZ3JhcGhzJTIyJTJDJTBBJTIzJTIwKSUwQSUwQSUyMyUyMEVuYWJsZSUyMG1lbW9yeSUyMHNhdmluZ3MlMEFwaXBlLnZhZS5lbmFibGVfdGlsaW5nKCklMEElMjMlMjBwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZChncHVfaWQlM0RkaXN0LmdldF9yYW5rKCkpJTBBJTIzJTIwcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZChncHVfaWQlM0RkaXN0LmdldF9yYW5rKCkpJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoMiklM0ElMEElMjAlMjAlMjAlMjBiZWdpbiUyMCUzRCUyMHRpbWUudGltZSgpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY2F0JTIwd2Fsa3MlMjBvbiUyMHRoZSUyMGdyYXNzJTJDJTIwcmVhbGlzdGljJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzIwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0QxMjgwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDEyOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxJTIwaWYlMjBpJTIwJTNEJTNEJTIwMCUyMGVsc2UlMjAzMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIycGlsJTIyJTIwaWYlMjBkaXN0LmdldF9yYW5rKCklMjAlM0QlM0QlMjAwJTIwZWxzZSUyMCUyMnB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwKS5mcmFtZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwZW5kJTIwJTNEJTIwdGltZS50aW1lKCklMEElMjAlMjAlMjAlMjBpZiUyMGRpc3QuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMldhcm0lMjB1cCUyMHRpbWUlM0ElMjAlN0JlbmQlMjAtJTIwYmVnaW4lM0EuMmYlN0RzJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyVGltZSUzQSUyMCU3QmVuZCUyMC0lMjBiZWdpbiUzQS4yZiU3RHMlMjIpJTBBJTBBaWYlMjBkaXN0LmdldF9yYW5rKCklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyU2F2aW5nJTIwdmlkZW8lMjB0byUyMGh1bnl1YW5fdmlkZW8ubXA0JTIyKSUwQSUyMCUyMCUyMCUyMGV4cG9ydF90b192aWRlbyhvdXRwdXQlMkMlMjAlMjJodW55dWFuX3ZpZGVvLm1wNCUyMiUyQyUyMGZwcyUzRDE1KSUwQSUwQWRpc3QuZGVzdHJveV9wcm9jZXNzX2dyb3VwKCk=",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

dist.init_process_group()

torch.cuda.set_device(dist.get_rank())

model_id = <span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>
transformer = HunyuanVideoTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
)
pipe = HunyuanVideoPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=torch.float16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.context_parallel <span class="hljs-keyword">import</span> init_context_parallel_mesh
<span class="hljs-keyword">from</span> para_attn.context_parallel.diffusers_adapters <span class="hljs-keyword">import</span> parallelize_pipe
<span class="hljs-keyword">from</span> para_attn.parallel_vae.diffusers_adapters <span class="hljs-keyword">import</span> parallelize_vae

mesh = init_context_parallel_mesh(
    pipe.device.<span class="hljs-built_in">type</span>,
)
parallelize_pipe(
    pipe,
    mesh=mesh,
)
parallelize_vae(pipe.vae, mesh=mesh._flatten())

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(pipe)

<span class="hljs-comment"># from torchao.quantization import quantize_, float8_dynamic_activation_float8_weight, float8_weight_only</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># torch._inductor.config.reorder_for_compute_comm_overlap = True</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># quantize_(pipe.text_encoder, float8_weight_only())</span>
<span class="hljs-comment"># quantize_(pipe.transformer, float8_dynamic_activation_float8_weight())</span>
<span class="hljs-comment"># pipe.transformer = torch.compile(</span>
<span class="hljs-comment">#    pipe.transformer, mode=&quot;max-autotune-no-cudagraphs&quot;,</span>
<span class="hljs-comment"># )</span>

<span class="hljs-comment"># Enable memory savings</span>
pipe.vae.enable_tiling()
<span class="hljs-comment"># pipe.enable_model_cpu_offload(gpu_id=dist.get_rank())</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload(gpu_id=dist.get_rank())</span>

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):
    begin = time.time()
    output = pipe(
        prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
        height=<span class="hljs-number">720</span>,
        width=<span class="hljs-number">1280</span>,
        num_frames=<span class="hljs-number">129</span>,
        num_inference_steps=<span class="hljs-number">1</span> <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">30</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span> <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;pt&quot;</span>,
    ).frames[<span class="hljs-number">0</span>]
    end = time.time()
    <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
        <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warm up time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving video to hunyuan_video.mp4&quot;</span>)
    export_to_video(output, <span class="hljs-string">&quot;hunyuan_video.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)

dist.destroy_process_group()`,wrap:!1}}),c=new $({props:{code:"JTIzJTIwVXNlJTIwLS1ucHJvY19wZXJfbm9kZSUyMHRvJTIwc3BlY2lmeSUyMHRoZSUyMG51bWJlciUyMG9mJTIwR1BVcyUwQXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDglMjBydW5faHVueXVhbl92aWRlby5weQ==",highlighted:`<span class="hljs-comment"># Use --nproc_per_node to specify the number of GPUs</span>
torchrun --nproc_per_node=8 run_hunyuan_video.py`,wrap:!1}}),{c(){l=y("p"),l.textContent=d,p=m(),U(r.$$.fragment),t=m(),n=y("p"),n.innerHTML=j,J=m(),U(c.$$.fragment),W=m(),b=y("p"),b.textContent=u},l(o){l=h(o,"P",{"data-svelte-h":!0}),w(l)!=="svelte-muxsqm"&&(l.textContent=d),p=M(o),Z(r.$$.fragment,o),t=M(o),n=h(o,"P",{"data-svelte-h":!0}),w(n)!=="svelte-7sbjia"&&(n.innerHTML=j),J=M(o),Z(c.$$.fragment,o),W=M(o),b=h(o,"P",{"data-svelte-h":!0}),w(b)!=="svelte-d28thb"&&(b.textContent=u)},m(o,T){a(o,l,T),a(o,p,T),B(r,o,T),a(o,t,T),a(o,n,T),a(o,J,T),B(c,o,T),a(o,W,T),a(o,b,T),g=!0},p:Y,i(o){g||(I(r.$$.fragment,o),I(c.$$.fragment,o),g=!0)},o(o){_(r.$$.fragment,o),_(c.$$.fragment,o),g=!1},d(o){o&&(s(l),s(p),s(t),s(n),s(J),s(W),s(b)),C(r,o),C(c,o)}}}function Ct(G){let l,d,p,r;return l=new R({props:{id:"context-parallelism",option:"FLUX-1.dev",$$slots:{default:[It]},$$scope:{ctx:G}}}),p=new R({props:{id:"context-parallelism",option:"HunyuanVideo",$$slots:{default:[_t]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=m(),U(p.$$.fragment)},l(t){Z(l.$$.fragment,t),d=M(t),Z(p.$$.fragment,t)},m(t,n){B(l,t,n),a(t,d,n),B(p,t,n),r=!0},p(t,n){const j={};n&2&&(j.$$scope={dirty:n,ctx:t}),l.$set(j);const J={};n&2&&(J.$$scope={dirty:n,ctx:t}),p.$set(J)},i(t){r||(I(l.$$.fragment,t),I(p.$$.fragment,t),r=!0)},o(t){_(l.$$.fragment,t),_(p.$$.fragment,t),r=!1},d(t){t&&s(d),C(l,t),C(p,t)}}}function Gt(G){let l,d="<thead><tr><th>GPU Type</th> <th>Number of GPUs</th> <th>Optimizations</th> <th>Wall Time (s)</th> <th>Speedup</th></tr></thead> <tbody><tr><td>NVIDIA L20</td> <td>1</td> <td>Baseline</td> <td>26.36</td> <td>1.00x</td></tr> <tr><td>NVIDIA L20</td> <td>1</td> <td>FBCache (rdt=0.08)</td> <td>17.01</td> <td>1.55x</td></tr> <tr><td>NVIDIA L20</td> <td>1</td> <td>FP8 DQ</td> <td>13.40</td> <td>1.96x</td></tr> <tr><td>NVIDIA L20</td> <td>1</td> <td>FBCache (rdt=0.12) + FP8 DQ</td> <td>7.56</td> <td>3.48x</td></tr> <tr><td>NVIDIA L20</td> <td>2</td> <td>FBCache (rdt=0.12) + FP8 DQ + CP</td> <td>4.92</td> <td>5.35x</td></tr> <tr><td>NVIDIA L20</td> <td>4</td> <td>FBCache (rdt=0.12) + FP8 DQ + CP</td> <td>3.90</td> <td>6.75x</td></tr></tbody>";return{c(){l=y("table"),l.innerHTML=d},l(p){l=h(p,"TABLE",{"data-svelte-h":!0}),w(l)!=="svelte-1eiq4i6"&&(l.innerHTML=d)},m(p,r){a(p,l,r)},p:Y,d(p){p&&s(l)}}}function Wt(G){let l,d="<thead><tr><th>GPU Type</th> <th>Number of GPUs</th> <th>Optimizations</th> <th>Wall Time (s)</th> <th>Speedup</th></tr></thead> <tbody><tr><td>NVIDIA L20</td> <td>1</td> <td>Baseline</td> <td>3675.71</td> <td>1.00x</td></tr> <tr><td>NVIDIA L20</td> <td>1</td> <td>FBCache</td> <td>2271.06</td> <td>1.62x</td></tr> <tr><td>NVIDIA L20</td> <td>2</td> <td>FBCache + CP</td> <td>1132.90</td> <td>3.24x</td></tr> <tr><td>NVIDIA L20</td> <td>4</td> <td>FBCache + CP</td> <td>718.15</td> <td>5.12x</td></tr> <tr><td>NVIDIA L20</td> <td>8</td> <td>FBCache + CP</td> <td>649.23</td> <td>5.66x</td></tr></tbody>";return{c(){l=y("table"),l.innerHTML=d},l(p){l=h(p,"TABLE",{"data-svelte-h":!0}),w(l)!=="svelte-1rcid57"&&(l.innerHTML=d)},m(p,r){a(p,l,r)},p:Y,d(p){p&&s(l)}}}function gt(G){let l,d,p,r;return l=new R({props:{id:"conclusion",option:"FLUX-1.dev",$$slots:{default:[Gt]},$$scope:{ctx:G}}}),p=new R({props:{id:"conclusion",option:"HunyuanVideo",$$slots:{default:[Wt]},$$scope:{ctx:G}}}),{c(){U(l.$$.fragment),d=m(),U(p.$$.fragment)},l(t){Z(l.$$.fragment,t),d=M(t),Z(p.$$.fragment,t)},m(t,n){B(l,t,n),a(t,d,n),B(p,t,n),r=!0},p(t,n){const j={};n&2&&(j.$$scope={dirty:n,ctx:t}),l.$set(j);const J={};n&2&&(J.$$scope={dirty:n,ctx:t}),p.$set(J)},i(t){r||(I(l.$$.fragment,t),I(p.$$.fragment,t),r=!0)},o(t){_(l.$$.fragment,t),_(p.$$.fragment,t),r=!1},d(t){t&&s(d),C(l,t),C(p,t)}}}function vt(G){let l,d,p,r,t,n,j,J,c,W='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-performance.png"/>',b,u,g='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/hunyuan-video-performance.png"/>',o,T,Me='Large image and video generation models, such as <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> and <a href="https://huggingface.co/tencent/HunyuanVideo" rel="nofollow">HunyuanVideo</a>, can be an inference challenge for real-time applications and deployment because of their size.',X,V,de='<a href="https://github.com/chengzeyi/ParaAttention" rel="nofollow">ParaAttention</a> is a library that implements <strong>context parallelism</strong> and <strong>first block cache</strong>, and can be combined with other techniques (torch.compile, fp8 dynamic quantization), to accelerate inference.',k,f,v=`This guide will show you how to apply ParaAttention to FLUX.1-dev and HunyuanVideo on NVIDIA L20 GPUs.
No optimizations are applied for our baseline benchmark, except for HunyuanVideo to avoid out-of-memory errors.`,he,z,Ye="Our baseline benchmark shows that FLUX.1-dev is able to generate a 1024x1024 resolution image in 28 steps in 26.36 seconds, and HunyuanVideo is able to generate 129 frames at 720p resolution in 30 steps in 3675.71 seconds.",fe,H,ze="<p>For even faster inference with context parallelism, try using NVIDIA A100 or H100 GPUs (if available) with NVLink support, especially when there is a large number of GPUs.</p>",Je,N,we,q,Ne="Caching the output of the transformers blocks in the model and reusing them in the next inference steps reduces the computation cost and makes inference faster.",je,L,qe="However, it is hard to decide when to reuse the cache to ensure quality generated images or videos. ParaAttention directly uses the <strong>residual difference of the first transformer block output</strong> to approximate the difference among model outputs. When the difference is small enough, the residual difference of previous inference steps is reused. In other words, the denoising step is skipped.",Te,K,Le="This achieves a 2x speedup on FLUX.1-dev and HunyuanVideo inference with very good quality.",be,D,Ke='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/ada-cache.png" alt="Cache in Diffusion Transformer"/> <figcaption>How AdaCache works, First Block Cache is a variant of it</figcaption>',Ue,Q,Ze,P,Be,O,De='fp8 with dynamic quantization further speeds up inference and reduces memory usage. Both the activations and weights must be quantized in order to use the 8-bit <a href="https://www.nvidia.com/en-us/data-center/tensor-cores/" rel="nofollow">NVIDIA Tensor Cores</a>.',Ie,ee,Pe="Use <code>float8_weight_only</code> and <code>float8_dynamic_activation_float8_weight</code> to quantize the text encoder and transformer model.",_e,te,Oe="The default quantization method is per tensor quantization, but if your GPU supports row-wise quantization, you can also try it for better accuracy.",Ce,le,et='Install <a href="https://github.com/pytorch/ao/tree/main" rel="nofollow">torchao</a> with the command below.',Ge,se,We,ae,tt='<a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> with <code>mode=&quot;max-autotune-no-cudagraphs&quot;</code> or <code>mode=&quot;max-autotune&quot;</code> selects the best kernel for performance. Compilation can take a long time if it’s the first time the model is called, but it is worth it once the model has been compiled.',ge,ne,lt="This example only quantizes the transformer model, but you can also quantize the text encoder to reduce memory usage even more.",ve,F,st="<p>Dynamic quantization can significantly change the distribution of the model output, so you need to change the <code>residual_diff_threshold</code> to a larger value for it to take effect.</p>",Ve,A,Xe,pe,ke,ie,at="Context Parallelism parallelizes inference and scales with multiple GPUs. The ParaAttention compositional design allows you to combine Context Parallelism with First Block Cache and dynamic quantization.",$e,x,nt='<p>Refer to the <a href="https://github.com/chengzeyi/ParaAttention/tree/main" rel="nofollow">ParaAttention</a> repository for detailed instructions and examples of how to scale inference with multiple GPUs.</p>',He,oe,pt='If the inference process needs to be persistent and serviceable, it is suggested to use <a href="https://pytorch.org/docs/stable/multiprocessing.html" rel="nofollow">torch.multiprocessing</a> to write your own inference processor. This can eliminate the overhead of launching the process and loading and recompiling the model.',Qe,S,Fe,re,Ae,E,xe,ce,Se,ue,Ee;return t=new Jt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new ye({props:{title:"ParaAttention",local:"paraattention",headingTag:"h1"}}),N=new ye({props:{title:"First Block Cache",local:"first-block-cache",headingTag:"h2"}}),Q=new Re({props:{id:"first-block-cache",options:["FLUX-1.dev","HunyuanVideo"],$$slots:{default:[bt]},$$scope:{ctx:G}}}),P=new ye({props:{title:"fp8 quantization",local:"fp8-quantization",headingTag:"h2"}}),se=new $({props:{code:"cGlwMyUyMGluc3RhbGwlMjAtVSUyMHRvcmNoJTIwdG9yY2hhbw==",highlighted:"pip3 install -U torch torchao",wrap:!1}}),A=new Re({props:{id:"fp8-quantization",options:["FLUX-1.dev","HunyuanVideo"],$$slots:{default:[Bt]},$$scope:{ctx:G}}}),pe=new ye({props:{title:"Context Parallelism",local:"context-parallelism",headingTag:"h2"}}),S=new Re({props:{id:"context-parallelism",options:["FLUX-1.dev","HunyuanVideo"],$$slots:{default:[Ct]},$$scope:{ctx:G}}}),re=new ye({props:{title:"Benchmarks",local:"benchmarks",headingTag:"h2"}}),E=new Re({props:{id:"conclusion",options:["FLUX-1.dev","HunyuanVideo"],$$slots:{default:[gt]},$$scope:{ctx:G}}}),ce=new wt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/para_attn.md"}}),{c(){l=y("meta"),d=m(),p=y("p"),r=m(),U(t.$$.fragment),n=m(),U(j.$$.fragment),J=m(),c=y("div"),c.innerHTML=W,b=m(),u=y("div"),u.innerHTML=g,o=m(),T=y("p"),T.innerHTML=Me,X=m(),V=y("p"),V.innerHTML=de,k=m(),f=y("p"),f.textContent=v,he=m(),z=y("p"),z.textContent=Ye,fe=m(),H=y("blockquote"),H.innerHTML=ze,Je=m(),U(N.$$.fragment),we=m(),q=y("p"),q.textContent=Ne,je=m(),L=y("p"),L.innerHTML=qe,Te=m(),K=y("p"),K.textContent=Le,be=m(),D=y("figure"),D.innerHTML=Ke,Ue=m(),U(Q.$$.fragment),Ze=m(),U(P.$$.fragment),Be=m(),O=y("p"),O.innerHTML=De,Ie=m(),ee=y("p"),ee.innerHTML=Pe,_e=m(),te=y("p"),te.textContent=Oe,Ce=m(),le=y("p"),le.innerHTML=et,Ge=m(),U(se.$$.fragment),We=m(),ae=y("p"),ae.innerHTML=tt,ge=m(),ne=y("p"),ne.textContent=lt,ve=m(),F=y("blockquote"),F.innerHTML=st,Ve=m(),U(A.$$.fragment),Xe=m(),U(pe.$$.fragment),ke=m(),ie=y("p"),ie.textContent=at,$e=m(),x=y("blockquote"),x.innerHTML=nt,He=m(),oe=y("p"),oe.innerHTML=pt,Qe=m(),U(S.$$.fragment),Fe=m(),U(re.$$.fragment),Ae=m(),U(E.$$.fragment),xe=m(),U(ce.$$.fragment),Se=m(),ue=y("p"),this.h()},l(e){const i=ht("svelte-u9bgzb",document.head);l=h(i,"META",{name:!0,content:!0}),i.forEach(s),d=M(e),p=h(e,"P",{}),mt(p).forEach(s),r=M(e),Z(t.$$.fragment,e),n=M(e),Z(j.$$.fragment,e),J=M(e),c=h(e,"DIV",{class:!0,"data-svelte-h":!0}),w(c)!=="svelte-1p4slnk"&&(c.innerHTML=W),b=M(e),u=h(e,"DIV",{class:!0,"data-svelte-h":!0}),w(u)!=="svelte-1kqq4mt"&&(u.innerHTML=g),o=M(e),T=h(e,"P",{"data-svelte-h":!0}),w(T)!=="svelte-uizfax"&&(T.innerHTML=Me),X=M(e),V=h(e,"P",{"data-svelte-h":!0}),w(V)!=="svelte-1ufw59x"&&(V.innerHTML=de),k=M(e),f=h(e,"P",{"data-svelte-h":!0}),w(f)!=="svelte-y6ktum"&&(f.textContent=v),he=M(e),z=h(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-12v81em"&&(z.textContent=Ye),fe=M(e),H=h(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),w(H)!=="svelte-au4ots"&&(H.innerHTML=ze),Je=M(e),Z(N.$$.fragment,e),we=M(e),q=h(e,"P",{"data-svelte-h":!0}),w(q)!=="svelte-zipcqj"&&(q.textContent=Ne),je=M(e),L=h(e,"P",{"data-svelte-h":!0}),w(L)!=="svelte-11q05n5"&&(L.innerHTML=qe),Te=M(e),K=h(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-1ecvggt"&&(K.textContent=Le),be=M(e),D=h(e,"FIGURE",{"data-svelte-h":!0}),w(D)!=="svelte-1czvnic"&&(D.innerHTML=Ke),Ue=M(e),Z(Q.$$.fragment,e),Ze=M(e),Z(P.$$.fragment,e),Be=M(e),O=h(e,"P",{"data-svelte-h":!0}),w(O)!=="svelte-yi5eo1"&&(O.innerHTML=De),Ie=M(e),ee=h(e,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-10ndi9a"&&(ee.innerHTML=Pe),_e=M(e),te=h(e,"P",{"data-svelte-h":!0}),w(te)!=="svelte-1dzea4g"&&(te.textContent=Oe),Ce=M(e),le=h(e,"P",{"data-svelte-h":!0}),w(le)!=="svelte-edf8tk"&&(le.innerHTML=et),Ge=M(e),Z(se.$$.fragment,e),We=M(e),ae=h(e,"P",{"data-svelte-h":!0}),w(ae)!=="svelte-xjm2cj"&&(ae.innerHTML=tt),ge=M(e),ne=h(e,"P",{"data-svelte-h":!0}),w(ne)!=="svelte-1akf52n"&&(ne.textContent=lt),ve=M(e),F=h(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),w(F)!=="svelte-6flf2e"&&(F.innerHTML=st),Ve=M(e),Z(A.$$.fragment,e),Xe=M(e),Z(pe.$$.fragment,e),ke=M(e),ie=h(e,"P",{"data-svelte-h":!0}),w(ie)!=="svelte-vw4vn"&&(ie.textContent=at),$e=M(e),x=h(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),w(x)!=="svelte-1jqb1qc"&&(x.innerHTML=nt),He=M(e),oe=h(e,"P",{"data-svelte-h":!0}),w(oe)!=="svelte-1vj39hr"&&(oe.innerHTML=pt),Qe=M(e),Z(S.$$.fragment,e),Fe=M(e),Z(re.$$.fragment,e),Ae=M(e),Z(E.$$.fragment,e),xe=M(e),Z(ce.$$.fragment,e),Se=M(e),ue=h(e,"P",{}),mt(ue).forEach(s),this.h()},h(){me(l,"name","hf:doc:metadata"),me(l,"content",Vt),me(c,"class","flex justify-center"),me(u,"class","flex justify-center"),me(H,"class","tip"),me(F,"class","tip"),me(x,"class","tip")},m(e,i){ft(document.head,l),a(e,d,i),a(e,p,i),a(e,r,i),B(t,e,i),a(e,n,i),B(j,e,i),a(e,J,i),a(e,c,i),a(e,b,i),a(e,u,i),a(e,o,i),a(e,T,i),a(e,X,i),a(e,V,i),a(e,k,i),a(e,f,i),a(e,he,i),a(e,z,i),a(e,fe,i),a(e,H,i),a(e,Je,i),B(N,e,i),a(e,we,i),a(e,q,i),a(e,je,i),a(e,L,i),a(e,Te,i),a(e,K,i),a(e,be,i),a(e,D,i),a(e,Ue,i),B(Q,e,i),a(e,Ze,i),B(P,e,i),a(e,Be,i),a(e,O,i),a(e,Ie,i),a(e,ee,i),a(e,_e,i),a(e,te,i),a(e,Ce,i),a(e,le,i),a(e,Ge,i),B(se,e,i),a(e,We,i),a(e,ae,i),a(e,ge,i),a(e,ne,i),a(e,ve,i),a(e,F,i),a(e,Ve,i),B(A,e,i),a(e,Xe,i),B(pe,e,i),a(e,ke,i),a(e,ie,i),a(e,$e,i),a(e,x,i),a(e,He,i),a(e,oe,i),a(e,Qe,i),B(S,e,i),a(e,Fe,i),B(re,e,i),a(e,Ae,i),B(E,e,i),a(e,xe,i),B(ce,e,i),a(e,Se,i),a(e,ue,i),Ee=!0},p(e,[i]){const it={};i&2&&(it.$$scope={dirty:i,ctx:e}),Q.$set(it);const ot={};i&2&&(ot.$$scope={dirty:i,ctx:e}),A.$set(ot);const rt={};i&2&&(rt.$$scope={dirty:i,ctx:e}),S.$set(rt);const ct={};i&2&&(ct.$$scope={dirty:i,ctx:e}),E.$set(ct)},i(e){Ee||(I(t.$$.fragment,e),I(j.$$.fragment,e),I(N.$$.fragment,e),I(Q.$$.fragment,e),I(P.$$.fragment,e),I(se.$$.fragment,e),I(A.$$.fragment,e),I(pe.$$.fragment,e),I(S.$$.fragment,e),I(re.$$.fragment,e),I(E.$$.fragment,e),I(ce.$$.fragment,e),Ee=!0)},o(e){_(t.$$.fragment,e),_(j.$$.fragment,e),_(N.$$.fragment,e),_(Q.$$.fragment,e),_(P.$$.fragment,e),_(se.$$.fragment,e),_(A.$$.fragment,e),_(pe.$$.fragment,e),_(S.$$.fragment,e),_(re.$$.fragment,e),_(E.$$.fragment,e),_(ce.$$.fragment,e),Ee=!1},d(e){e&&(s(d),s(p),s(r),s(n),s(J),s(c),s(b),s(u),s(o),s(T),s(X),s(V),s(k),s(f),s(he),s(z),s(fe),s(H),s(Je),s(we),s(q),s(je),s(L),s(Te),s(K),s(be),s(D),s(Ue),s(Ze),s(Be),s(O),s(Ie),s(ee),s(_e),s(te),s(Ce),s(le),s(Ge),s(We),s(ae),s(ge),s(ne),s(ve),s(F),s(Ve),s(Xe),s(ke),s(ie),s($e),s(x),s(He),s(oe),s(Qe),s(Fe),s(Ae),s(xe),s(Se),s(ue)),s(l),C(t,e),C(j,e),C(N,e),C(Q,e),C(P,e),C(se,e),C(A,e),C(pe,e),C(S,e),C(re,e),C(E,e),C(ce,e)}}}const Vt='{"title":"ParaAttention","local":"paraattention","sections":[{"title":"First Block Cache","local":"first-block-cache","sections":[],"depth":2},{"title":"fp8 quantization","local":"fp8-quantization","sections":[],"depth":2},{"title":"Context Parallelism","local":"context-parallelism","sections":[],"depth":2},{"title":"Benchmarks","local":"benchmarks","sections":[],"depth":2}],"depth":1}';function Xt(G){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends ut{constructor(l){super(),yt(this,l,Xt,vt,Mt,{})}}export{xt as component};
