import{s as Be,n as xe,o as Ve}from"../chunks/scheduler.53228c21.js";import{S as Ne,i as Re,e as s,s as a,c as p,h as $e,a as i,d as n,b as o,f as Ce,g as r,j as d,k as ke,l as Ee,m as l,n as c,t as m,o as u,p as f}from"../chunks/index.100fac89.js";import{C as Fe}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{C as he}from"../chunks/CodeBlock.d30a6509.js";import{H as Me,E as Qe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function Ge(ye){let h,Q,E,G,M,A,y,H,T,Te='<a href="https://github.com/NVIDIA/TensorRT-Model-Optimizer" rel="nofollow">NVIDIA-ModelOpt</a> is a unified library of state-of-the-art model optimization techniques like quantization, pruning, distillation, speculative decoding, etc. It compresses deep learning models for downstream deployment frameworks like TensorRT-LLM or TensorRT to optimize inference speed.',X,w,we="Before you begin, make sure you have nvidia_modelopt installed.",Y,J,D,b,Je='Quantize a model by passing <code>NVIDIAModelOptConfig</code> to <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> (you can also load pre-quantized models). This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',L,g,be="The example below only quantizes the weights to FP8.",S,_,P,q,ge='<p><strong>Note:</strong></p> <p>The quantization methods in NVIDIA-ModelOpt are designed to reduce the memory footprint of model weights using various QAT (Quantization-Aware Training) and PTQ (Post-Training Quantization) techniques while maintaining model performance. However, the actual performance gain during inference depends on the deployment framework (e.g., TRT-LLM, TensorRT) and the specific hardware configuration.</p> <p>More details can be found <a href="https://github.com/NVIDIA/TensorRT-Model-Optimizer/tree/main/examples" rel="nofollow">here</a>.</p>',O,Z,K,j,_e="The <code>NVIDIAModelOptConfig</code> class accepts three parameters:",ee,I,qe='<li><code>quant_type</code>: A string value mentioning one of the quantization types below.</li> <li><code>modules_to_not_convert</code>: A list of module full/partial module names for which quantization should not be performed. For example, to not perform any quantization of the <a href="/docs/diffusers/main/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>’s pos_embed projection blocks, one would specify: <code>modules_to_not_convert=[&quot;pos_embed.proj.weight&quot;]</code>.</li> <li><code>disable_conv_quantization</code>: A boolean value which when set to <code>True</code> disables quantization for all convolutional layers in the model. This is useful as channel and block quantization generally don’t work well with convolutional layers (used with INT4, NF4, NVFP4). If you want to disable quantization for specific convolutional layers, use <code>modules_to_not_convert</code> instead.</li> <li><code>algorithm</code>: The algorithm to use for determining scale, defaults to <code>&quot;max&quot;</code>. You can check modelopt documentation for more algorithms and details.</li> <li><code>forward_loop</code>: The forward loop function to use for calibrating activation during quantization. If not provided, it relies on static scale values computed using the weights only.</li> <li><code>kwargs</code>: A dict of keyword arguments to pass to the underlying quantization method which will be invoked based on <code>quant_type</code>.</li>',te,U,ne,z,Ze="ModelOpt supports weight-only, channel and block quantization int8, fp8, int4, nf4, and nvfp4. The quantization methods are designed to reduce the memory footprint of the model weights while maintaining the performance of the model during inference.",le,v,je="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",ae,W,Ie="The quantization methods supported are as follows:",oe,C,Ue="<thead><tr><th><strong>Quantization Type</strong></th> <th><strong>Supported Schemes</strong></th> <th><strong>Required Kwargs</strong></th> <th><strong>Additional Notes</strong></th></tr></thead> <tbody><tr><td><strong>INT8</strong></td> <td><code>int8 weight only</code>, <code>int8 channel quantization</code>, <code>int8 block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize</code>, <code>quant_type + channel_quantize + block_quantize</code></td> <td></td></tr> <tr><td><strong>FP8</strong></td> <td><code>fp8 weight only</code>, <code>fp8 channel quantization</code>, <code>fp8 block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize</code>, <code>quant_type + channel_quantize + block_quantize</code></td> <td></td></tr> <tr><td><strong>INT4</strong></td> <td><code>int4 weight only</code>, <code>int4 block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize + block_quantize</code></td> <td><code>channel_quantize = -1 is only supported for now</code></td></tr> <tr><td><strong>NF4</strong></td> <td><code>nf4 weight only</code>, <code>nf4 double block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize + block_quantize + scale_channel_quantize</code> + <code>scale_block_quantize</code></td> <td><code>channel_quantize = -1 and scale_channel_quantize = -1 are only supported for now</code></td></tr> <tr><td><strong>NVFP4</strong></td> <td><code>nvfp4 weight only</code>, <code>nvfp4 block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize + block_quantize</code></td> <td><code>channel_quantize = -1 is only supported for now</code></td></tr></tbody>",se,k,ze='Refer to the <a href="https://nvidia.github.io/TensorRT-Model-Optimizer/" rel="nofollow">official modelopt documentation</a> for a better understanding of the available quantization methods and the exhaustive list of configuration options available.',ie,B,de,x,ve='To serialize a quantized model in a given dtype, first load the model with the desired quantization dtype and then save it using the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a> method.',pe,V,re,N,We='To load a serialized quantized model, use the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method.',ce,R,me,$,ue,F,fe;return M=new Fe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new Me({props:{title:"NVIDIA ModelOpt",local:"nvidia-modelopt",headingTag:"h1"}}),J=new he({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwJTIybnZpZGlhX21vZGVsb3B0JTVCaGYlNUQlMjI=",highlighted:'pip install -U <span class="hljs-string">&quot;nvidia_modelopt[hf]&quot;</span>',wrap:!1}}),_=new he({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU2FuYVBpcGVsaW5lJTJDJTIwTlZJRElBTW9kZWxPcHRDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkVmZmljaWVudC1MYXJnZS1Nb2RlbCUyRlNhbmFfNjAwTV8xMDI0cHhfZGlmZnVzZXJzJTIyJTBBZHR5cGUlMjAlM0QlMjB0b3JjaC5iZmxvYXQxNiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBOVklESUFNb2RlbE9wdENvbmZpZyhxdWFudF90eXBlJTNEJTIyRlA4JTIyJTJDJTIwcXVhbnRfbWV0aG9kJTNEJTIybW9kZWxvcHQlMjIpJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEZHR5cGUlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMFNhbmFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUyQyUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJpbnQoZiUyMlBpcGVsaW5lJTIwbWVtb3J5JTIwdXNhZ2UlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfcmVzZXJ2ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuM2YlN0QlMjBHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENC41JTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, SanaPipeline, NVIDIAModelOptConfig

model_id = <span class="hljs-string">&quot;Efficient-Large-Model/Sana_600M_1024px_diffusers&quot;</span>
dtype = torch.bfloat16

quantization_config = NVIDIAModelOptConfig(quant_type=<span class="hljs-string">&quot;FP8&quot;</span>, quant_method=<span class="hljs-string">&quot;modelopt&quot;</span>)
transformer = AutoModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=dtype,
)
pipe = SanaPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=dtype,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Pipeline memory usage: <span class="hljs-subst">{torch.cuda.max_memory_reserved() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.3</span>f}</span> GB&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),Z=new Me({props:{title:"NVIDIAModelOptConfig",local:"nvidiamodeloptconfig",headingTag:"h2"}}),U=new Me({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),B=new Me({props:{title:"Serializing and Deserializing quantized models",local:"serializing-and-deserializing-quantized-models",headingTag:"h2"}}),V=new he({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwTlZJRElBTW9kZWxPcHRDb25maWclMEFmcm9tJTIwbW9kZWxvcHQudG9yY2gub3B0JTIwaW1wb3J0JTIwZW5hYmxlX2h1Z2dpbmdmYWNlX2NoZWNrcG9pbnRpbmclMEElMEFlbmFibGVfaHVnZ2luZ2ZhY2VfY2hlY2twb2ludGluZygpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJFZmZpY2llbnQtTGFyZ2UtTW9kZWwlMkZTYW5hXzYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUwQXF1YW50X2NvbmZpZ19mcDglMjAlM0QlMjAlN0IlMjJxdWFudF90eXBlJTIyJTNBJTIwJTIyRlA4JTIyJTJDJTIwJTIycXVhbnRfbWV0aG9kJTIyJTNBJTIwJTIybW9kZWxvcHQlMjIlN0QlMEFxdWFudF9jb25maWdfZnA4JTIwJTNEJTIwTlZJRElBTW9kZWxPcHRDb25maWcoKipxdWFudF9jb25maWdfZnA4KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZ19mcDglMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCgncGF0aCUyRnRvJTJGc2FuYV9mcDgnJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, NVIDIAModelOptConfig
<span class="hljs-keyword">from</span> modelopt.torch.opt <span class="hljs-keyword">import</span> enable_huggingface_checkpointing

enable_huggingface_checkpointing()

model_id = <span class="hljs-string">&quot;Efficient-Large-Model/Sana_600M_1024px_diffusers&quot;</span>
quant_config_fp8 = {<span class="hljs-string">&quot;quant_type&quot;</span>: <span class="hljs-string">&quot;FP8&quot;</span>, <span class="hljs-string">&quot;quant_method&quot;</span>: <span class="hljs-string">&quot;modelopt&quot;</span>}
quant_config_fp8 = NVIDIAModelOptConfig(**quant_config_fp8)
model = AutoModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config_fp8,
    torch_dtype=torch.bfloat16,
)
model.save_pretrained(<span class="hljs-string">&#x27;path/to/sana_fp8&#x27;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),R=new he({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwTlZJRElBTW9kZWxPcHRDb25maWclMkMlMjBTYW5hUGlwZWxpbmUlMEFmcm9tJTIwbW9kZWxvcHQudG9yY2gub3B0JTIwaW1wb3J0JTIwZW5hYmxlX2h1Z2dpbmdmYWNlX2NoZWNrcG9pbnRpbmclMEElMEFlbmFibGVfaHVnZ2luZ2ZhY2VfY2hlY2twb2ludGluZygpJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyME5WSURJQU1vZGVsT3B0Q29uZmlnKHF1YW50X3R5cGUlM0QlMjJGUDglMjIlMkMlMjBxdWFudF9tZXRob2QlM0QlMjJtb2RlbG9wdCUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyRnRvJTJGc2FuYV9mcDglMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEFwaXBlJTIwJTNEJTIwU2FuYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJFZmZpY2llbnQtTGFyZ2UtTW9kZWwlMkZTYW5hXzYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENC41JTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, NVIDIAModelOptConfig, SanaPipeline
<span class="hljs-keyword">from</span> modelopt.torch.opt <span class="hljs-keyword">import</span> enable_huggingface_checkpointing

enable_huggingface_checkpointing()

quantization_config = NVIDIAModelOptConfig(quant_type=<span class="hljs-string">&quot;FP8&quot;</span>, quant_method=<span class="hljs-string">&quot;modelopt&quot;</span>)
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;path/to/sana_fp8&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
pipe = SanaPipeline.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_600M_1024px_diffusers&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),$=new Qe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/modelopt.md"}}),{c(){h=s("meta"),Q=a(),E=s("p"),G=a(),p(M.$$.fragment),A=a(),p(y.$$.fragment),H=a(),T=s("p"),T.innerHTML=Te,X=a(),w=s("p"),w.textContent=we,Y=a(),p(J.$$.fragment),D=a(),b=s("p"),b.innerHTML=Je,L=a(),g=s("p"),g.textContent=be,S=a(),p(_.$$.fragment),P=a(),q=s("blockquote"),q.innerHTML=ge,O=a(),p(Z.$$.fragment),K=a(),j=s("p"),j.innerHTML=_e,ee=a(),I=s("ul"),I.innerHTML=qe,te=a(),p(U.$$.fragment),ne=a(),z=s("p"),z.textContent=Ze,le=a(),v=s("p"),v.innerHTML=je,ae=a(),W=s("p"),W.textContent=Ie,oe=a(),C=s("table"),C.innerHTML=Ue,se=a(),k=s("p"),k.innerHTML=ze,ie=a(),p(B.$$.fragment),de=a(),x=s("p"),x.innerHTML=ve,pe=a(),p(V.$$.fragment),re=a(),N=s("p"),N.innerHTML=We,ce=a(),p(R.$$.fragment),me=a(),p($.$$.fragment),ue=a(),F=s("p"),this.h()},l(e){const t=$e("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(n),Q=o(e),E=i(e,"P",{}),Ce(E).forEach(n),G=o(e),r(M.$$.fragment,e),A=o(e),r(y.$$.fragment,e),H=o(e),T=i(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-v41xgy"&&(T.innerHTML=Te),X=o(e),w=i(e,"P",{"data-svelte-h":!0}),d(w)!=="svelte-ieekzb"&&(w.textContent=we),Y=o(e),r(J.$$.fragment,e),D=o(e),b=i(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1g5a9mh"&&(b.innerHTML=Je),L=o(e),g=i(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1035mg9"&&(g.textContent=be),S=o(e),r(_.$$.fragment,e),P=o(e),q=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),d(q)!=="svelte-t3b69f"&&(q.innerHTML=ge),O=o(e),r(Z.$$.fragment,e),K=o(e),j=i(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-nf8ias"&&(j.innerHTML=_e),ee=o(e),I=i(e,"UL",{"data-svelte-h":!0}),d(I)!=="svelte-14j8c0y"&&(I.innerHTML=qe),te=o(e),r(U.$$.fragment,e),ne=o(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1qozamx"&&(z.textContent=Ze),le=o(e),v=i(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-17x1tdo"&&(v.innerHTML=je),ae=o(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-4xexxq"&&(W.textContent=Ie),oe=o(e),C=i(e,"TABLE",{"data-svelte-h":!0}),d(C)!=="svelte-zlixfj"&&(C.innerHTML=Ue),se=o(e),k=i(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-veoxfw"&&(k.innerHTML=ze),ie=o(e),r(B.$$.fragment,e),de=o(e),x=i(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-x34suv"&&(x.innerHTML=ve),pe=o(e),r(V.$$.fragment,e),re=o(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1km1qu3"&&(N.innerHTML=We),ce=o(e),r(R.$$.fragment,e),me=o(e),r($.$$.fragment,e),ue=o(e),F=i(e,"P",{}),Ce(F).forEach(n),this.h()},h(){ke(h,"name","hf:doc:metadata"),ke(h,"content",Ae)},m(e,t){Ee(document.head,h),l(e,Q,t),l(e,E,t),l(e,G,t),c(M,e,t),l(e,A,t),c(y,e,t),l(e,H,t),l(e,T,t),l(e,X,t),l(e,w,t),l(e,Y,t),c(J,e,t),l(e,D,t),l(e,b,t),l(e,L,t),l(e,g,t),l(e,S,t),c(_,e,t),l(e,P,t),l(e,q,t),l(e,O,t),c(Z,e,t),l(e,K,t),l(e,j,t),l(e,ee,t),l(e,I,t),l(e,te,t),c(U,e,t),l(e,ne,t),l(e,z,t),l(e,le,t),l(e,v,t),l(e,ae,t),l(e,W,t),l(e,oe,t),l(e,C,t),l(e,se,t),l(e,k,t),l(e,ie,t),c(B,e,t),l(e,de,t),l(e,x,t),l(e,pe,t),c(V,e,t),l(e,re,t),l(e,N,t),l(e,ce,t),c(R,e,t),l(e,me,t),c($,e,t),l(e,ue,t),l(e,F,t),fe=!0},p:xe,i(e){fe||(m(M.$$.fragment,e),m(y.$$.fragment,e),m(J.$$.fragment,e),m(_.$$.fragment,e),m(Z.$$.fragment,e),m(U.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(R.$$.fragment,e),m($.$$.fragment,e),fe=!0)},o(e){u(M.$$.fragment,e),u(y.$$.fragment,e),u(J.$$.fragment,e),u(_.$$.fragment,e),u(Z.$$.fragment,e),u(U.$$.fragment,e),u(B.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u($.$$.fragment,e),fe=!1},d(e){e&&(n(Q),n(E),n(G),n(A),n(H),n(T),n(X),n(w),n(Y),n(D),n(b),n(L),n(g),n(S),n(P),n(q),n(O),n(K),n(j),n(ee),n(I),n(te),n(ne),n(z),n(le),n(v),n(ae),n(W),n(oe),n(C),n(se),n(k),n(ie),n(de),n(x),n(pe),n(re),n(N),n(ce),n(me),n(ue),n(F)),n(h),f(M,e),f(y,e),f(J,e),f(_,e),f(Z,e),f(U,e),f(B,e),f(V,e),f(R,e),f($,e)}}}const Ae='{"title":"NVIDIA ModelOpt","local":"nvidia-modelopt","sections":[{"title":"NVIDIAModelOptConfig","local":"nvidiamodeloptconfig","sections":[],"depth":2},{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Serializing and Deserializing quantized models","local":"serializing-and-deserializing-quantized-models","sections":[],"depth":2}],"depth":1}';function He(ye){return Ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pe extends Ne{constructor(h){super(),Re(this,h,He,Ge,Be,{})}}export{Pe as component};
