import{s as Se,n as De,o as Ke}from"../chunks/scheduler.53228c21.js";import{S as Oe,i as et,e as l,s,c as r,h as tt,a as o,d as n,b as a,f as Ne,g as f,j as p,k as _e,l as nt,m as i,n as u,t as m,o as c,p as d}from"../chunks/index.100fac89.js";import{C as it}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{C as P}from"../chunks/CodeBlock.d30a6509.js";import{H as N,E as st}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function at(Be){let y,S,Y,D,w,K,b,O,g,ve="Quantization focuses on representing data with fewer bits while also trying to preserve the precision of the original data. This often means converting a data type to represent the same information with fewer bits. For example, if your model weights are stored as 32-bit floating points and they’re quantized to 16-bit floating points, this halves the model size which makes it easier to store and reduces memory usage. Lower precision can also speedup inference because it takes less time to perform calculations with fewer bits.",ee,T,ke='Diffusers supports multiple quantization backends to make large diffusion models like <a href="../api/pipelines/flux">Flux</a> more accessible. This guide shows how to use the <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> class to quantize a pipeline during its initialization from a pretrained or non-quantized checkpoint.',te,J,ne,U,$e='There are two ways to use <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> depending on how much customization you want to apply to the quantization configuration.',ie,C,Qe="<li>for basic use cases, define the <code>quant_backend</code>, <code>quant_kwargs</code>, and <code>components_to_quantize</code> arguments</li> <li>for granular quantization control, define a <code>quant_mapping</code> that provides the quantization configuration for individual model components</li>",se,z,ae,q,Ge='Initialize <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> with the following parameters.',le,j,Ie="<li><code>quant_backend</code> specifies which quantization backend to use. Currently supported backends include: <code>bitsandbytes_4bit</code>, <code>bitsandbytes_8bit</code>, <code>gguf</code>, <code>quanto</code>, and <code>torchao</code>.</li> <li><code>quant_kwargs</code> specifies the quantization arguments to use.</li>",oe,M,We='<p>These <code>quant_kwargs</code> arguments are different for each backend. Refer to the <a href="../api/quantization">Quantization API</a> docs to view the arguments for each backend.</p>',pe,Z,Xe='<li><p><code>components_to_quantize</code> specifies which component(s) of the pipeline to quantize. Typically, you should quantize the most compute intensive components like the transformer. The text encoder is another component to consider quantizing if a pipeline has more than one such as <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a>. The example below quantizes the T5 text encoder in <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> while keeping the CLIP model intact.</p> <p><code>components_to_quantize</code> accepts either a list for multiple models or a string for a single model.</p></li>',re,_,Re='The example below loads the bitsandbytes backend with the following arguments from <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>, <code>load_in_4bit</code>, <code>bnb_4bit_quant_type</code>, and <code>bnb_4bit_compute_dtype</code>.',fe,B,ue,v,xe='Pass the <code>pipeline_quant_config</code> to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to quantize the pipeline.',me,k,ce,$,de,Q,Fe="The <code>quant_mapping</code> argument provides more options for how to quantize each individual component in a pipeline, like combining different quantization backends.",ye,G,Ae='Initialize <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> and pass a <code>quant_mapping</code> to it. The <code>quant_mapping</code> allows you to specify the quantization options for each component in the pipeline such as the transformer and text encoder.',Me,I,Ee='The example below uses two quantization backends, <a href="/docs/diffusers/main/en/api/quantization#diffusers.QuantoConfig">QuantoConfig</a> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a>, for the transformer and text encoder.',he,W,we,X,He='There is a separate bitsandbytes backend in <a href="https://huggingface.co/docs/transformers/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">Transformers</a>. You need to import and use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> for components that come from Transformers. For example, <code>text_encoder_2</code> in <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> is a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a> from Transformers so you need to use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> instead of <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">diffusers.BitsAndBytesConfig</a>.',be,h,Ve='<p>Use the <a href="#basic-quantization">basic quantization</a> method above if you don’t want to manage these distinct imports or aren’t sure where each pipeline component comes from.</p>',ge,R,Te,x,Ye='Pass the <code>pipeline_quant_config</code> to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to quantize the pipeline.',Je,F,Ue,A,Ce,E,Le="Check out the resources below to learn more about quantization.",ze,H,Pe='<li><p>If you are new to quantization, we recommend checking out the following beginner-friendly courses in collaboration with DeepLearning.AI.</p> <ul><li><a href="https://www.deeplearning.ai/short-courses/quantization-fundamentals-with-hugging-face/" rel="nofollow">Quantization Fundamentals with Hugging Face</a></li> <li><a href="https://www.deeplearning.ai/short-courses/quantization-in-depth/" rel="nofollow">Quantization in Depth</a></li></ul></li> <li><p>Refer to the <a href="https://huggingface.co/docs/transformers/main/en/quantization/contribute" rel="nofollow">Contribute new quantization method guide</a> if you’re interested in adding a new quantization method.</p></li> <li><p>The Transformers quantization <a href="https://huggingface.co/docs/transformers/quantization/overview#when-to-use-what" rel="nofollow">Overview</a> provides an overview of the pros and cons of different quantization backends.</p></li> <li><p>Read the <a href="https://huggingface.co/blog/diffusers-quantization" rel="nofollow">Exploring Quantization Backends in Diffusers</a> blog post for a brief introduction to each quantization backend, how to choose a backend, and combining quantization with other memory optimizations.</p></li>',qe,V,je,L,Ze;return w=new it({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new N({props:{title:"Getting started",local:"getting-started",headingTag:"h1"}}),J=new N({props:{title:"Pipeline-level quantization",local:"pipeline-level-quantization",headingTag:"h2"}}),z=new N({props:{title:"Basic quantization",local:"basic-quantization",headingTag:"h3"}}),B=new P({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X2JhY2tlbmQlM0QlMjJiaXRzYW5kYnl0ZXNfNGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50X2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fNGJpdCUyMiUzQSUyMFRydWUlMkMlMjAlMjJibmJfNGJpdF9xdWFudF90eXBlJTIyJTNBJTIwJTIybmY0JTIyJTJDJTIwJTIyYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUyMiUzQSUyMHRvcmNoLmJmbG9hdDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwY29tcG9uZW50c190b19xdWFudGl6ZSUzRCU1QiUyMnRyYW5zZm9ybWVyJTIyJTJDJTIwJTIydGV4dF9lbmNvZGVyXzIlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)`,wrap:!1}}),k=new P({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIycGhvdG8lMjBvZiUyMGElMjBjdXRlJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(<span class="hljs-string">&quot;photo of a cute dog&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),$=new N({props:{title:"Advanced quantization",local:"advanced-quantization",headingTag:"h3"}}),W=new P({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMucXVhbnRpemF0aW9uX2NvbmZpZyUyMGltcG9ydCUyMFF1YW50b0NvbmZpZyUwQWZyb20lMjBkaWZmdXNlcnMucXVhbnRpemVycyUyMGltcG9ydCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcGlwZWxpbmVfcXVhbnRfY29uZmlnJTIwJTNEJTIwUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcXVhbnRfbWFwcGluZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyJTIyJTNBJTIwUXVhbnRvQ29uZmlnKHdlaWdodHNfZHR5cGUlM0QlMjJpbnQ4JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> diffusers.quantizers.quantization_config <span class="hljs-keyword">import</span> QuantoConfig
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={
        <span class="hljs-string">&quot;transformer&quot;</span>: QuantoConfig(weights_dtype=<span class="hljs-string">&quot;int8&quot;</span>),
        <span class="hljs-string">&quot;text_encoder_2&quot;</span>: TransformersBitsAndBytesConfig(
            load_in_4bit=<span class="hljs-literal">True</span>, compute_dtype=torch.bfloat16
        ),
    }
)`,wrap:!1}}),R=new P({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMjBhcyUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X21hcHBpbmclM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lciUyMiUzQSUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={
        <span class="hljs-string">&quot;transformer&quot;</span>: DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16),
        <span class="hljs-string">&quot;text_encoder_2&quot;</span>: TransformersBitsAndBytesConfig(
            load_in_4bit=<span class="hljs-literal">True</span>, compute_dtype=torch.bfloat16
        ),
    }
)`,wrap:!1}}),F=new P({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIycGhvdG8lMjBvZiUyMGElMjBjdXRlJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(<span class="hljs-string">&quot;photo of a cute dog&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new N({props:{title:"Resources",local:"resources",headingTag:"h2"}}),V=new st({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/overview.md"}}),{c(){y=l("meta"),S=s(),Y=l("p"),D=s(),r(w.$$.fragment),K=s(),r(b.$$.fragment),O=s(),g=l("p"),g.textContent=ve,ee=s(),T=l("p"),T.innerHTML=ke,te=s(),r(J.$$.fragment),ne=s(),U=l("p"),U.innerHTML=$e,ie=s(),C=l("ul"),C.innerHTML=Qe,se=s(),r(z.$$.fragment),ae=s(),q=l("p"),q.innerHTML=Ge,le=s(),j=l("ul"),j.innerHTML=Ie,oe=s(),M=l("blockquote"),M.innerHTML=We,pe=s(),Z=l("ul"),Z.innerHTML=Xe,re=s(),_=l("p"),_.innerHTML=Re,fe=s(),r(B.$$.fragment),ue=s(),v=l("p"),v.innerHTML=xe,me=s(),r(k.$$.fragment),ce=s(),r($.$$.fragment),de=s(),Q=l("p"),Q.innerHTML=Fe,ye=s(),G=l("p"),G.innerHTML=Ae,Me=s(),I=l("p"),I.innerHTML=Ee,he=s(),r(W.$$.fragment),we=s(),X=l("p"),X.innerHTML=He,be=s(),h=l("blockquote"),h.innerHTML=Ve,ge=s(),r(R.$$.fragment),Te=s(),x=l("p"),x.innerHTML=Ye,Je=s(),r(F.$$.fragment),Ue=s(),r(A.$$.fragment),Ce=s(),E=l("p"),E.textContent=Le,ze=s(),H=l("ul"),H.innerHTML=Pe,qe=s(),r(V.$$.fragment),je=s(),L=l("p"),this.h()},l(e){const t=tt("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(n),S=a(e),Y=o(e,"P",{}),Ne(Y).forEach(n),D=a(e),f(w.$$.fragment,e),K=a(e),f(b.$$.fragment,e),O=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-16bsuce"&&(g.textContent=ve),ee=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-6eg90x"&&(T.innerHTML=ke),te=a(e),f(J.$$.fragment,e),ne=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-2kbfj0"&&(U.innerHTML=$e),ie=a(e),C=o(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-1xtak7u"&&(C.innerHTML=Qe),se=a(e),f(z.$$.fragment,e),ae=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-11lseqg"&&(q.innerHTML=Ge),le=a(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-10xkd3n"&&(j.innerHTML=Ie),oe=a(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-19z24wg"&&(M.innerHTML=We),pe=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-qn9gg1"&&(Z.innerHTML=Xe),re=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1xwpu7e"&&(_.innerHTML=Re),fe=a(e),f(B.$$.fragment,e),ue=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-3c78ko"&&(v.innerHTML=xe),me=a(e),f(k.$$.fragment,e),ce=a(e),f($.$$.fragment,e),de=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-s8jyg6"&&(Q.innerHTML=Fe),ye=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1bi47yb"&&(G.innerHTML=Ae),Me=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-g00viz"&&(I.innerHTML=Ee),he=a(e),f(W.$$.fragment,e),we=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1072co4"&&(X.innerHTML=He),be=a(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-b04iji"&&(h.innerHTML=Ve),ge=a(e),f(R.$$.fragment,e),Te=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-3c78ko"&&(x.innerHTML=Ye),Je=a(e),f(F.$$.fragment,e),Ue=a(e),f(A.$$.fragment,e),Ce=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-kva6dz"&&(E.textContent=Le),ze=a(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-yr6gzk"&&(H.innerHTML=Pe),qe=a(e),f(V.$$.fragment,e),je=a(e),L=o(e,"P",{}),Ne(L).forEach(n),this.h()},h(){_e(y,"name","hf:doc:metadata"),_e(y,"content",lt),_e(M,"class","tip"),_e(h,"class","tip")},m(e,t){nt(document.head,y),i(e,S,t),i(e,Y,t),i(e,D,t),u(w,e,t),i(e,K,t),u(b,e,t),i(e,O,t),i(e,g,t),i(e,ee,t),i(e,T,t),i(e,te,t),u(J,e,t),i(e,ne,t),i(e,U,t),i(e,ie,t),i(e,C,t),i(e,se,t),u(z,e,t),i(e,ae,t),i(e,q,t),i(e,le,t),i(e,j,t),i(e,oe,t),i(e,M,t),i(e,pe,t),i(e,Z,t),i(e,re,t),i(e,_,t),i(e,fe,t),u(B,e,t),i(e,ue,t),i(e,v,t),i(e,me,t),u(k,e,t),i(e,ce,t),u($,e,t),i(e,de,t),i(e,Q,t),i(e,ye,t),i(e,G,t),i(e,Me,t),i(e,I,t),i(e,he,t),u(W,e,t),i(e,we,t),i(e,X,t),i(e,be,t),i(e,h,t),i(e,ge,t),u(R,e,t),i(e,Te,t),i(e,x,t),i(e,Je,t),u(F,e,t),i(e,Ue,t),u(A,e,t),i(e,Ce,t),i(e,E,t),i(e,ze,t),i(e,H,t),i(e,qe,t),u(V,e,t),i(e,je,t),i(e,L,t),Ze=!0},p:De,i(e){Ze||(m(w.$$.fragment,e),m(b.$$.fragment,e),m(J.$$.fragment,e),m(z.$$.fragment,e),m(B.$$.fragment,e),m(k.$$.fragment,e),m($.$$.fragment,e),m(W.$$.fragment,e),m(R.$$.fragment,e),m(F.$$.fragment,e),m(A.$$.fragment,e),m(V.$$.fragment,e),Ze=!0)},o(e){c(w.$$.fragment,e),c(b.$$.fragment,e),c(J.$$.fragment,e),c(z.$$.fragment,e),c(B.$$.fragment,e),c(k.$$.fragment,e),c($.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(A.$$.fragment,e),c(V.$$.fragment,e),Ze=!1},d(e){e&&(n(S),n(Y),n(D),n(K),n(O),n(g),n(ee),n(T),n(te),n(ne),n(U),n(ie),n(C),n(se),n(ae),n(q),n(le),n(j),n(oe),n(M),n(pe),n(Z),n(re),n(_),n(fe),n(ue),n(v),n(me),n(ce),n(de),n(Q),n(ye),n(G),n(Me),n(I),n(he),n(we),n(X),n(be),n(h),n(ge),n(Te),n(x),n(Je),n(Ue),n(Ce),n(E),n(ze),n(H),n(qe),n(je),n(L)),n(y),d(w,e),d(b,e),d(J,e),d(z,e),d(B,e),d(k,e),d($,e),d(W,e),d(R,e),d(F,e),d(A,e),d(V,e)}}}const lt='{"title":"Getting started","local":"getting-started","sections":[{"title":"Pipeline-level quantization","local":"pipeline-level-quantization","sections":[{"title":"Basic quantization","local":"basic-quantization","sections":[],"depth":3},{"title":"Advanced quantization","local":"advanced-quantization","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ot(Be){return Ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Oe{constructor(y){super(),et(this,y,ot,at,Se,{})}}export{ct as component};
