import{s as tt,n as st,o as at}from"../chunks/scheduler.53228c21.js";import{S as nt,i as it,e as i,s as a,c as r,h as pt,a as p,d as t,b as n,f as lt,g as c,j as o,k as Ul,l as ot,m as s,n as m,t as d,o as M,p as J}from"../chunks/index.100fac89.js";import{C as rt}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{C as y}from"../chunks/CodeBlock.d30a6509.js";import{H as we,E as ct}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function mt(Il){let u,fe,he,be,T,je,f,Ue,b,Zl="Distributed inference splits the workload across multiple GPUs. It a useful technique for fitting larger models in memory and can process multiple prompts for higher throughput.",Ie,j,gl='This guide will show you how to use <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a> for distributed inference.',Ze,U,ge,I,Cl="Accelerate is a library designed to simplify inference and training on multiple accelerators by handling the setup, allowing users to focus on their PyTorch code.",Ce,Z,Bl="Install Accelerate with the following command.",Be,g,Ge,C,Gl='Initialize a <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> class in a Python file to create a distributed environment. The <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> class manages process management, device control and distribution, and process coordination.',ke,B,kl='Move the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>accelerate.PartialState.device</code> to assign a GPU to each process.',ve,G,We,k,vl='Use the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',_e,v,$e,W,Wl="Call <code>accelerate launch</code> to run the script and use the <code>--num_processes</code> argument to set the number of GPUs to use.",Xe,_,Ee,w,_l='<p>Refer to this minimal example <a href="https://gist.github.com/sayakpaul/cfaebd221820d7b43fae638b4dfa01ba" rel="nofollow">script</a> for running inference across multiple GPUs. To learn more, take a look at the <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed Inference with 🤗 Accelerate</a> guide.</p>',Ne,$,Re,X,$l='PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel</a> enables <a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=data_parallelism" rel="nofollow">data parallelism</a>, which replicates the same model on each device, to process different batches of data in parallel.',xe,E,Xl="Import <code>torch.distributed</code> and <code>torch.multiprocessing</code> into a Python file to set up the distributed process group and to spawn the processes for inference on each GPU.",Ve,N,He,R,El='Create a function for inference with <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow">init_process_group</a>. This method creates a distributed environment with the backend type, the <code>rank</code> of the current process, and the <code>world_size</code> or number of processes participating (for example, 2 GPUs would be <code>world_size=2</code>).',Ye,x,Nl="Move the pipeline to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process. Each process handles a different prompt.",Ae,V,Qe,H,Rl='Use <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow">mp.spawn</a> to create the number of processes defined in <code>world_size</code>.',Fe,Y,ze,A,xl="Call <code>torchrun</code> to run the inference script and use the <code>--nproc_per_node</code> argument to set the number of GPUs to use.",Se,Q,qe,F,Pe,z,Vl="The <code>device_map</code> argument enables distributed inference by automatically placing model components on separate GPUs. This is especially useful when a model doesn’t fit on a single GPU. You can use <code>device_map</code> to selectively load and unload the required model components at a given stage as shown in the example below (assumes two GPUs are available).",Le,S,Hl="Set <code>device_map=&quot;balanced&quot;</code> to evenly distributes the text encoders on all available GPUs. You can use the <code>max_memory</code> argument to allocate a maximum amount of memory for each text encoder. Don’t load any other pipeline components to avoid memory usage.",De,q,Ke,P,Yl="After the text embeddings are computed, remove them from the GPU to make space for the diffusion transformer.",Oe,L,el,D,Al="Set <code>device_map=&quot;auto&quot;</code> to automatically distribute the model on the two GPUs. This strategy places a model on the fastest device first before placing a model on a slower device like a CPU or hard drive if needed. The trade-off of storing model parameters on slower devices is slower inference latency.",ll,K,tl,h,Ql="<p>Run <code>pipeline.hf_device_map</code> to see how the various models are distributed across devices. This is useful for tracking model device placement. You can also call <code>hf_device_map</code> on the transformer model to see how it is distributed.</p>",sl,O,Fl="Add the transformer model to the pipeline and set the <code>output_type=&quot;latent&quot;</code> to generate the latents.",al,ee,nl,le,zl="Remove the pipeline and transformer from memory and load a VAE to decode the latents. The VAE is typically small enough to be loaded on a single device.",il,te,pl,se,Sl="By selectively loading and unloading the models you need at a given stage and sharding the largest models across multiple GPUs, it is possible to run inference with large models on consumer GPUs.",ol,ae,rl,ne,ql='<a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=context_parallelism" rel="nofollow">Context parallelism</a> splits input sequences across multiple GPUs to reduce memory usage. Each GPU processes its own slice of the sequence.',cl,ie,Pl='Use <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.set_attention_backend">set_attention_backend()</a> to switch to a more optimized attention backend. Refer to this <a href="../optimization/attention_backends#available-backends">table</a> for a complete list of available backends.',ml,pe,dl,oe,Ll='Key (K) and value (V) representations communicate between devices using <a href="https://huggingface.co/papers/2310.01889" rel="nofollow">Ring Attention</a>. This ensures each split sees every other token’s K/V. Each GPU computes attention for its local K/V and passes it to the next GPU in the ring. No single GPU holds the full sequence, which reduces communication latency.',Ml,re,Dl='Pass a <a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> to the <code>parallel_config</code> argument of the transformer model. The config supports the <code>ring_degree</code> argument that determines how many devices to use for Ring Attention.',Jl,ce,yl,me,ul,de,Kl='<a href="https://huggingface.co/papers/2309.14509" rel="nofollow">Ulysses Attention</a> splits a sequence across GPUs and performs an <em>all-to-all</em> communication (every device sends/receives data to every other device). Each GPU ends up with all tokens for only a subset of attention heads. Each GPU computes attention locally on all tokens for its head, then performs another all-to-all to regroup results by tokens for the next layer.',wl,Me,Ol='<a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> supports Ulysses Attention through the <code>ulysses_degree</code> argument. This determines how many devices to use for Ulysses Attention.',hl,Je,et='Pass the <a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> to <code>enable_parallelism()</code>.',Tl,ye,fl,ue,bl,Te,jl;return T=new rt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new we({props:{title:"Distributed inference",local:"distributed-inference",headingTag:"h1"}}),U=new we({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),g=new y({props:{code:"dXYlMjBwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:"uv pip install accelerate",wrap:!1}}),G=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQWRpc3RyaWJ1dGVkX3N0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEFwaXBlbGluZS50byhkaXN0cmlidXRlZF9zdGF0ZS5kZXZpY2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.float16
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)`,wrap:!1}}),v=new y({props:{code:"d2l0aCUyMGRpc3RyaWJ1dGVkX3N0YXRlLnNwbGl0X2JldHdlZW5fcHJvY2Vzc2VzKCU1QiUyMmElMjBkb2clMjIlMkMlMjAlMjJhJTIwY2F0JTIyJTVEKSUyMGFzJTIwcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmVzdWx0LnNhdmUoZiUyMnJlc3VsdF8lN0JkaXN0cmlidXRlZF9zdGF0ZS5wcm9jZXNzX2luZGV4JTdELnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),_=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),$=new we({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),N=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.float16,
)`,wrap:!1}}),V=new y({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBwaXBlbGluZS50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    pipeline.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),Y=new y({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),Q=new y({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),F=new we({props:{title:"device_map",local:"devicemap",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEElMEFwaXBlbGluZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9tZW1vcnklM0QlN0IwJTNBJTIwJTIyMTZHQiUyMiUyQyUyMDElM0ElMjAlMjIxNkdCJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyRW5jb2RpbmclMjBwcm9tcHRzLiUyMiklMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMjB0ZXh0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwcHJvbXB0XzIlM0ROb25lJTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline
<span class="hljs-keyword">import</span> torch

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>},
    torch_dtype=torch.bfloat16
)
<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Encoding prompts.&quot;</span>)
    prompt_embeds, pooled_prompt_embeds, text_ids = pipeline.encode_prompt(
        prompt=prompt, prompt_2=<span class="hljs-literal">None</span>, max_sequence_length=<span class="hljs-number">512</span>
    )`,wrap:!1}}),L=new y({props:{code:"aW1wb3J0JTIwZ2MlMjAlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9tYXhfbWVtb3J5X2FsbG9jYXRlZCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9wZWFrX21lbW9yeV9zdGF0cygpJTBBJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyXzIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXJfMiUwQWRlbCUyMHBpcGVsaW5lJTBBJTBBZmx1c2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gc 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()
    torch.cuda.reset_max_memory_allocated()
    torch.cuda.reset_peak_memory_stats()

<span class="hljs-keyword">del</span> pipeline.text_encoder
<span class="hljs-keyword">del</span> pipeline.text_encoder_2
<span class="hljs-keyword">del</span> pipeline.tokenizer
<span class="hljs-keyword">del</span> pipeline.tokenizer_2
<span class="hljs-keyword">del</span> pipeline

flush()`,wrap:!1}}),K=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTIwJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">import</span> torch 

transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),ee=new y({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyXzIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQXByaW50KCUyMlJ1bm5pbmclMjBkZW5vaXNpbmcuJTIyKSUwQWhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwNzY4JTJDJTIwMTM2MCUwQWxhdGVudHMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMHBvb2xlZF9wcm9tcHRfZW1iZWRzJTNEcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuNSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRGhlaWdodCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEd2lkdGglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2Vz",highlighted:`pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    text_encoder_2=<span class="hljs-literal">None</span>,
    tokenizer=<span class="hljs-literal">None</span>,
    tokenizer_2=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running denoising.&quot;</span>)
height, width = <span class="hljs-number">768</span>, <span class="hljs-number">1360</span>
latents = pipeline(
    prompt_embeds=prompt_embeds,
    pooled_prompt_embeds=pooled_prompt_embeds,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=<span class="hljs-number">3.5</span>,
    height=height,
    width=width,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images`,wrap:!1}}),te=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUwQWZyb20lMjBkaWZmdXNlcnMuaW1hZ2VfcHJvY2Vzc29yJTIwaW1wb3J0JTIwVmFlSW1hZ2VQcm9jZXNzb3IlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZChja3B0X2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydmFlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEF2YWVfc2NhbGVfZmFjdG9yJTIwJTNEJTIwMiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWYWVJbWFnZVByb2Nlc3Nvcih2YWVfc2NhbGVfZmFjdG9yJTNEdmFlX3NjYWxlX2ZhY3RvciklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyUnVubmluZyUyMGRlY29kaW5nLiUyMiklMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwRmx1eFBpcGVsaW5lLl91bnBhY2tfbGF0ZW50cyhsYXRlbnRzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGglMkMlMjB2YWVfc2NhbGVfZmFjdG9yKSUwQSUyMCUyMCUyMCUyMGxhdGVudHMlMjAlM0QlMjAobGF0ZW50cyUyMCUyRiUyMHZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IpJTIwJTJCJTIwdmFlLmNvbmZpZy5zaGlmdF9mYWN0b3IlMEElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHZhZS5kZWNvZGUobGF0ZW50cyUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlNUIwJTVELnNhdmUoJTIyc3BsaXRfdHJhbnNmb3JtZXIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> VaeImageProcessor

vae = AutoencoderKL.from_pretrained(ckpt_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
vae_scale_factor = <span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>)
image_processor = VaeImageProcessor(vae_scale_factor=vae_scale_factor)

<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running decoding.&quot;</span>)
    latents = FluxPipeline._unpack_latents(latents, height, width, vae_scale_factor)
    latents = (latents / vae.config.scaling_factor) + vae.config.shift_factor

    image = vae.decode(latents, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
    image = image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)
    image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;split_transformer.png&quot;</span>)`,wrap:!1}}),ae=new we({props:{title:"Context parallelism",local:"context-parallelism",headingTag:"h2"}}),pe=new we({props:{title:"Ring Attention",local:"ring-attention",headingTag:"h3"}}),ce=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwUXdlbkltYWdlUGlwZWxpbmUlMkMlMjBDb250ZXh0UGFyYWxsZWxDb25maWclMEElMEF0cnklM0ElMEElMjAlMjAlMjAlMjB0b3JjaC5kaXN0cmlidXRlZC5pbml0X3Byb2Nlc3NfZ3JvdXAoJTIybmNjbCUyMiklMEElMjAlMjAlMjAlMjByYW5rJTIwJTNEJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUwQSUyMCUyMCUyMCUyMGRldmljZSUyMCUzRCUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyJTJDJTIwcmFuayUyMCUyNSUyMHRvcmNoLmN1ZGEuZGV2aWNlX2NvdW50KCkpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5zZXRfZGV2aWNlKGRldmljZSklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4tSW1hZ2UlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBwYXJhbGxlbF9jb25maWclM0RDb250ZXh0UGFyYWxsZWxDb25maWcocmluZ19kZWdyZWUlM0QyKSklMEElMjAlMjAlMjAlMjBwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIpJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmUudHJhbnNmb3JtZXIuc2V0X2F0dGVudGlvbl9iYWNrZW5kKCUyMmZsYXNoJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwYSUyMGNhdCUyMHNpcHBpbmclMjBhJTIwbWFyZ2FyaXRhJTIwaW4lMjBhJTIwcG9vbCUyMGluJTIwUGFsbSUyMFNwcmluZ3MlMkMlMjBDYWxpZm9ybmlhJTBBJTIwJTIwJTIwJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwTXVzdCUyMHNwZWNpZnklMjBnZW5lcmF0b3IlMjBzbyUyMGFsbCUyMHJhbmtzJTIwc3RhcnQlMjB3aXRoJTIwc2FtZSUyMGxhdGVudHMlMjAob3IlMjBwYXNzJTIweW91ciUyMG93biklMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoKS5tYW51YWxfc2VlZCg0MiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGlmJTIwcmFuayUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZS5zYXZlKCUyMm91dHB1dC5wbmclMjIpJTBBJTBBZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkFuJTIwZXJyb3IlMjBvY2N1cnJlZCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwdG9yY2guZGlzdHJpYnV0ZWQuYnJlYWtwb2ludCgpJTBBJTIwJTIwJTIwJTIwcmFpc2UlMEElMEFmaW5hbGx5JTNBJTBBJTIwJTIwJTIwJTIwaWYlMjB0b3JjaC5kaXN0cmlidXRlZC5pc19pbml0aWFsaXplZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guZGlzdHJpYnV0ZWQuZGVzdHJveV9wcm9jZXNzX2dyb3VwKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, QwenImagePipeline, ContextParallelConfig

<span class="hljs-keyword">try</span>:
    torch.distributed.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>)
    rank = torch.distributed.get_rank()
    device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>, rank % torch.cuda.device_count())
    torch.cuda.set_device(device)
    
    transformer = AutoModel.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16, parallel_config=ContextParallelConfig(ring_degree=<span class="hljs-number">2</span>))
    pipeline = QwenImagePipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, transformer=transformer, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)
    pipeline.transformer.set_attention_backend(<span class="hljs-string">&quot;flash&quot;</span>)

    prompt = <span class="hljs-string">&quot;&quot;&quot;
    cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
    highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Must specify generator so all ranks start with same latents (or pass your own)</span>
    generator = torch.Generator().manual_seed(<span class="hljs-number">42</span>)
    image = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=generator).images[<span class="hljs-number">0</span>]
    
    <span class="hljs-keyword">if</span> rank == <span class="hljs-number">0</span>:
        image.save(<span class="hljs-string">&quot;output.png&quot;</span>)

<span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;An error occurred: <span class="hljs-subst">{e}</span>&quot;</span>)
    torch.distributed.<span class="hljs-built_in">breakpoint</span>()
    <span class="hljs-keyword">raise</span>

<span class="hljs-keyword">finally</span>:
    <span class="hljs-keyword">if</span> torch.distributed.is_initialized():
        torch.distributed.destroy_process_group()`,wrap:!1}}),me=new we({props:{title:"Ulysses Attention",local:"ulysses-attention",headingTag:"h3"}}),ye=new y({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIuZW5hYmxlX3BhcmFsbGVsaXNtKGNvbmZpZyUzRENvbnRleHRQYXJhbGxlbENvbmZpZyh1bHlzc2VzX2RlZ3JlZSUzRDIpKQ==",highlighted:'pipeline.transformer.enable_parallelism(config=ContextParallelConfig(ulysses_degree=<span class="hljs-number">2</span>))',wrap:!1}}),ue=new ct({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/distributed_inference.md"}}),{c(){u=i("meta"),fe=a(),he=i("p"),be=a(),r(T.$$.fragment),je=a(),r(f.$$.fragment),Ue=a(),b=i("p"),b.textContent=Zl,Ie=a(),j=i("p"),j.innerHTML=gl,Ze=a(),r(U.$$.fragment),ge=a(),I=i("p"),I.textContent=Cl,Ce=a(),Z=i("p"),Z.textContent=Bl,Be=a(),r(g.$$.fragment),Ge=a(),C=i("p"),C.innerHTML=Gl,ke=a(),B=i("p"),B.innerHTML=kl,ve=a(),r(G.$$.fragment),We=a(),k=i("p"),k.innerHTML=vl,_e=a(),r(v.$$.fragment),$e=a(),W=i("p"),W.innerHTML=Wl,Xe=a(),r(_.$$.fragment),Ee=a(),w=i("blockquote"),w.innerHTML=_l,Ne=a(),r($.$$.fragment),Re=a(),X=i("p"),X.innerHTML=$l,xe=a(),E=i("p"),E.innerHTML=Xl,Ve=a(),r(N.$$.fragment),He=a(),R=i("p"),R.innerHTML=El,Ye=a(),x=i("p"),x.innerHTML=Nl,Ae=a(),r(V.$$.fragment),Qe=a(),H=i("p"),H.innerHTML=Rl,Fe=a(),r(Y.$$.fragment),ze=a(),A=i("p"),A.innerHTML=xl,Se=a(),r(Q.$$.fragment),qe=a(),r(F.$$.fragment),Pe=a(),z=i("p"),z.innerHTML=Vl,Le=a(),S=i("p"),S.innerHTML=Hl,De=a(),r(q.$$.fragment),Ke=a(),P=i("p"),P.textContent=Yl,Oe=a(),r(L.$$.fragment),el=a(),D=i("p"),D.innerHTML=Al,ll=a(),r(K.$$.fragment),tl=a(),h=i("blockquote"),h.innerHTML=Ql,sl=a(),O=i("p"),O.innerHTML=Fl,al=a(),r(ee.$$.fragment),nl=a(),le=i("p"),le.textContent=zl,il=a(),r(te.$$.fragment),pl=a(),se=i("p"),se.textContent=Sl,ol=a(),r(ae.$$.fragment),rl=a(),ne=i("p"),ne.innerHTML=ql,cl=a(),ie=i("p"),ie.innerHTML=Pl,ml=a(),r(pe.$$.fragment),dl=a(),oe=i("p"),oe.innerHTML=Ll,Ml=a(),re=i("p"),re.innerHTML=Dl,Jl=a(),r(ce.$$.fragment),yl=a(),r(me.$$.fragment),ul=a(),de=i("p"),de.innerHTML=Kl,wl=a(),Me=i("p"),Me.innerHTML=Ol,hl=a(),Je=i("p"),Je.innerHTML=et,Tl=a(),r(ye.$$.fragment),fl=a(),r(ue.$$.fragment),bl=a(),Te=i("p"),this.h()},l(e){const l=pt("svelte-u9bgzb",document.head);u=p(l,"META",{name:!0,content:!0}),l.forEach(t),fe=n(e),he=p(e,"P",{}),lt(he).forEach(t),be=n(e),c(T.$$.fragment,e),je=n(e),c(f.$$.fragment,e),Ue=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-eljq9f"&&(b.textContent=Zl),Ie=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-og4l62"&&(j.innerHTML=gl),Ze=n(e),c(U.$$.fragment,e),ge=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-nz1tds"&&(I.textContent=Cl),Ce=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1st21a7"&&(Z.textContent=Bl),Be=n(e),c(g.$$.fragment,e),Ge=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-s7f0yp"&&(C.innerHTML=Gl),ke=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1ibki3b"&&(B.innerHTML=kl),ve=n(e),c(G.$$.fragment,e),We=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-dxnfoj"&&(k.innerHTML=vl),_e=n(e),c(v.$$.fragment,e),$e=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-xu0wll"&&(W.innerHTML=Wl),Xe=n(e),c(_.$$.fragment,e),Ee=n(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-djm11n"&&(w.innerHTML=_l),Ne=n(e),c($.$$.fragment,e),Re=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-nym58p"&&(X.innerHTML=$l),xe=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1q3d069"&&(E.innerHTML=Xl),Ve=n(e),c(N.$$.fragment,e),He=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1vva4uo"&&(R.innerHTML=El),Ye=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1329uwh"&&(x.innerHTML=Nl),Ae=n(e),c(V.$$.fragment,e),Qe=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-84sp40"&&(H.innerHTML=Rl),Fe=n(e),c(Y.$$.fragment,e),ze=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-17g6264"&&(A.innerHTML=xl),Se=n(e),c(Q.$$.fragment,e),qe=n(e),c(F.$$.fragment,e),Pe=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-19ricyq"&&(z.innerHTML=Vl),Le=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-uepizv"&&(S.innerHTML=Hl),De=n(e),c(q.$$.fragment,e),Ke=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-m088j3"&&(P.textContent=Yl),Oe=n(e),c(L.$$.fragment,e),el=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-18jqegg"&&(D.innerHTML=Al),ll=n(e),c(K.$$.fragment,e),tl=n(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(h)!=="svelte-eiyj9h"&&(h.innerHTML=Ql),sl=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-128ts8i"&&(O.innerHTML=Fl),al=n(e),c(ee.$$.fragment,e),nl=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-jp9jpz"&&(le.textContent=zl),il=n(e),c(te.$$.fragment,e),pl=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-3tqui3"&&(se.textContent=Sl),ol=n(e),c(ae.$$.fragment,e),rl=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1bsyx0k"&&(ne.innerHTML=ql),cl=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-rgekxt"&&(ie.innerHTML=Pl),ml=n(e),c(pe.$$.fragment,e),dl=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-wnvqc8"&&(oe.innerHTML=Ll),Ml=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1kqjh5x"&&(re.innerHTML=Dl),Jl=n(e),c(ce.$$.fragment,e),yl=n(e),c(me.$$.fragment,e),ul=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1b28cdv"&&(de.innerHTML=Kl),wl=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1i9x1om"&&(Me.innerHTML=Ol),hl=n(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-9gv0zf"&&(Je.innerHTML=et),Tl=n(e),c(ye.$$.fragment,e),fl=n(e),c(ue.$$.fragment,e),bl=n(e),Te=p(e,"P",{}),lt(Te).forEach(t),this.h()},h(){Ul(u,"name","hf:doc:metadata"),Ul(u,"content",dt),Ul(w,"class","tip"),Ul(h,"class","tip")},m(e,l){ot(document.head,u),s(e,fe,l),s(e,he,l),s(e,be,l),m(T,e,l),s(e,je,l),m(f,e,l),s(e,Ue,l),s(e,b,l),s(e,Ie,l),s(e,j,l),s(e,Ze,l),m(U,e,l),s(e,ge,l),s(e,I,l),s(e,Ce,l),s(e,Z,l),s(e,Be,l),m(g,e,l),s(e,Ge,l),s(e,C,l),s(e,ke,l),s(e,B,l),s(e,ve,l),m(G,e,l),s(e,We,l),s(e,k,l),s(e,_e,l),m(v,e,l),s(e,$e,l),s(e,W,l),s(e,Xe,l),m(_,e,l),s(e,Ee,l),s(e,w,l),s(e,Ne,l),m($,e,l),s(e,Re,l),s(e,X,l),s(e,xe,l),s(e,E,l),s(e,Ve,l),m(N,e,l),s(e,He,l),s(e,R,l),s(e,Ye,l),s(e,x,l),s(e,Ae,l),m(V,e,l),s(e,Qe,l),s(e,H,l),s(e,Fe,l),m(Y,e,l),s(e,ze,l),s(e,A,l),s(e,Se,l),m(Q,e,l),s(e,qe,l),m(F,e,l),s(e,Pe,l),s(e,z,l),s(e,Le,l),s(e,S,l),s(e,De,l),m(q,e,l),s(e,Ke,l),s(e,P,l),s(e,Oe,l),m(L,e,l),s(e,el,l),s(e,D,l),s(e,ll,l),m(K,e,l),s(e,tl,l),s(e,h,l),s(e,sl,l),s(e,O,l),s(e,al,l),m(ee,e,l),s(e,nl,l),s(e,le,l),s(e,il,l),m(te,e,l),s(e,pl,l),s(e,se,l),s(e,ol,l),m(ae,e,l),s(e,rl,l),s(e,ne,l),s(e,cl,l),s(e,ie,l),s(e,ml,l),m(pe,e,l),s(e,dl,l),s(e,oe,l),s(e,Ml,l),s(e,re,l),s(e,Jl,l),m(ce,e,l),s(e,yl,l),m(me,e,l),s(e,ul,l),s(e,de,l),s(e,wl,l),s(e,Me,l),s(e,hl,l),s(e,Je,l),s(e,Tl,l),m(ye,e,l),s(e,fl,l),m(ue,e,l),s(e,bl,l),s(e,Te,l),jl=!0},p:st,i(e){jl||(d(T.$$.fragment,e),d(f.$$.fragment,e),d(U.$$.fragment,e),d(g.$$.fragment,e),d(G.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d($.$$.fragment,e),d(N.$$.fragment,e),d(V.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(ue.$$.fragment,e),jl=!0)},o(e){M(T.$$.fragment,e),M(f.$$.fragment,e),M(U.$$.fragment,e),M(g.$$.fragment,e),M(G.$$.fragment,e),M(v.$$.fragment,e),M(_.$$.fragment,e),M($.$$.fragment,e),M(N.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(Q.$$.fragment,e),M(F.$$.fragment,e),M(q.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),M(ue.$$.fragment,e),jl=!1},d(e){e&&(t(fe),t(he),t(be),t(je),t(Ue),t(b),t(Ie),t(j),t(Ze),t(ge),t(I),t(Ce),t(Z),t(Be),t(Ge),t(C),t(ke),t(B),t(ve),t(We),t(k),t(_e),t($e),t(W),t(Xe),t(Ee),t(w),t(Ne),t(Re),t(X),t(xe),t(E),t(Ve),t(He),t(R),t(Ye),t(x),t(Ae),t(Qe),t(H),t(Fe),t(ze),t(A),t(Se),t(qe),t(Pe),t(z),t(Le),t(S),t(De),t(Ke),t(P),t(Oe),t(el),t(D),t(ll),t(tl),t(h),t(sl),t(O),t(al),t(nl),t(le),t(il),t(pl),t(se),t(ol),t(rl),t(ne),t(cl),t(ie),t(ml),t(dl),t(oe),t(Ml),t(re),t(Jl),t(yl),t(ul),t(de),t(wl),t(Me),t(hl),t(Je),t(Tl),t(fl),t(bl),t(Te)),t(u),J(T,e),J(f,e),J(U,e),J(g,e),J(G,e),J(v,e),J(_,e),J($,e),J(N,e),J(V,e),J(Y,e),J(Q,e),J(F,e),J(q,e),J(L,e),J(K,e),J(ee,e),J(te,e),J(ae,e),J(pe,e),J(ce,e),J(me,e),J(ye,e),J(ue,e)}}}const dt='{"title":"Distributed inference","local":"distributed-inference","sections":[{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2},{"title":"device_map","local":"devicemap","sections":[],"depth":2},{"title":"Context parallelism","local":"context-parallelism","sections":[{"title":"Ring Attention","local":"ring-attention","sections":[],"depth":3},{"title":"Ulysses Attention","local":"ulysses-attention","sections":[],"depth":3}],"depth":2}],"depth":1}';function Mt(Il){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends nt{constructor(u){super(),it(this,u,Mt,mt,tt,{})}}export{Tt as component};
