import{s as me,n as pe,o as ue}from"../chunks/scheduler.53228c21.js";import{S as fe,i as ge,e as l,s as a,c as r,h as ye,a as o,d as s,b as n,f as re,g as c,j as h,k as ce,l as we,m as i,n as m,t as p,o as u,p as f}from"../chunks/index.100fac89.js";import{C as Me}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{C as he}from"../chunks/CodeBlock.d30a6509.js";import{H as O,E as be}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function Je(ee){let d,x,B,Y,g,R,y,V,w,te='<a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">ConsisID</a> is an identity-preserving text-to-video generation model that keeps the face consistent in the generated video by frequency decomposition. The main features of ConsisID are:',C,M,se="<li>Frequency decomposition: The characteristics of the DiT architecture are analyzed from the frequency domain perspective, and based on these characteristics, a reasonable control information injection method is designed.</li> <li>Consistency training strategy: A coarse-to-fine training strategy, dynamic masking loss, and dynamic cross-face loss further enhance the model’s generalization ability and identity preservation performance.</li> <li>Inference without finetuning: Previous methods required case-by-case finetuning of the input ID before inference, leading to significant time and computational costs. In contrast, ConsisID is tuning-free.</li>",N,b,ie="This guide will walk you through using ConsisID for use cases.",$,J,H,T,ae='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method.',Q,Z,z,v,F,U,ne="For identity-preserving text-to-video, pass a text prompt and an image contain clear face (e.g., preferably half-body or full-body). By default, ConsisID generates a 720x480 video for the best results.",E,G,D,j,le='<tbody><tr><th style="text-align: center;">Face Image</th> <th style="text-align: center;">Video</th> <th style="text-align: center;">Description</th> </tr><tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_0.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_0.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The video, in a beautifully crafted animated style, features a confident woman riding a horse through a lush forest clearing. Her expression is focused yet serene as she adjusts her wide-brimmed hat with a practiced hand. She wears a flowy bohemian dress, which moves gracefully with the rhythm of the horse, the fabric flowing fluidly in the animated motion. The dappled sunlight filters through the trees, casting soft, painterly patterns on the forest floor. Her posture is poised, showing both control and elegance as she guides the horse with ease. The animation&#39;s gentle, fluid style adds a dreamlike quality to the scene, with the woman’s calm demeanor and the peaceful surroundings evoking a sense of freedom and harmony.</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_1.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_1.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The video, in a captivating animated style, shows a woman standing in the center of a snowy forest, her eyes narrowed in concentration as she extends her hand forward. She is dressed in a deep blue cloak, her breath visible in the cold air, which is rendered with soft, ethereal strokes. A faint smile plays on her lips as she summons a wisp of ice magic, watching with focus as the surrounding trees and ground begin to shimmer and freeze, covered in delicate ice crystals. The animation’s fluid motion brings the magic to life, with the frost spreading outward in intricate, sparkling patterns. The environment is painted with soft, watercolor-like hues, enhancing the magical, dreamlike atmosphere. The overall mood is serene yet powerful, with the quiet winter air amplifying the delicate beauty of the frozen scene.</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_2.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_2.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The animation features a whimsical portrait of a balloon seller standing in a gentle breeze, captured with soft, hazy brushstrokes that evoke the feel of a serene spring day. His face is framed by a gentle smile, his eyes squinting slightly against the sun, while a few wisps of hair flutter in the wind. He is dressed in a light, pastel-colored shirt, and the balloons around him sway with the wind, adding a sense of playfulness to the scene. The background blurs softly, with hints of a vibrant market or park, enhancing the light-hearted, yet tender mood of the moment.</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_3.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_3.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#39;s lost in contemplation. The film grain adds a textured, timeless quality to the image, evoking a sense of nostalgia. Around him, the cityscape is filled with vintage buildings, cobblestone sidewalks, and softly blurred figures passing by, their outlines faint and indistinct. Streetlights cast a gentle glow, while shadows play across the boy&#39;s path, adding depth to the scene. The lighting highlights the boy&#39;s subtle smile, hinting at a fleeting moment of curiosity. The overall cinematic atmosphere, complete with classic film still aesthetics and dramatic contrasts, gives the scene an evocative and introspective feel.</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_4.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_4.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The video features a baby wearing a bright superhero cape, standing confidently with arms raised in a powerful pose. The baby has a determined look on their face, with eyes wide and lips pursed in concentration, as if ready to take on a challenge. The setting appears playful, with colorful toys scattered around and a soft rug underfoot, while sunlight streams through a nearby window, highlighting the fluttering cape and adding to the impression of heroism. The overall atmosphere is lighthearted and fun, with the baby&#39;s expressions capturing a mix of innocence and an adorable attempt at bravery, as if truly ready to save the day.</td></tr></tbody>',q,I,S,_,oe="Learn more about ConsisID with the following resources.",L,W,de='<li>A <a href="https://www.youtube.com/watch?v=PhlgC-bI5SQ" rel="nofollow">video</a> demonstrating ConsisID’s main features.</li> <li>The research paper, <a href="https://hf.co/papers/2411.17440" rel="nofollow">Identity-Preserving Text-to-Video Generation by Frequency Decomposition</a> for more details.</li>',P,k,A,X,K;return g=new Me({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new O({props:{title:"ConsisID",local:"consisid",headingTag:"h1"}}),J=new O({props:{title:"Load Model Checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),Z=new he({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBjb25zaXNpZF9ldmFfY2xpcCUyMGluc2lnaHRmYWNlJTIwZmFjZXhsaWIlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBDb25zaXNJRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMuY29uc2lzaWQuY29uc2lzaWRfdXRpbHMlMjBpbXBvcnQlMjBwcmVwYXJlX2ZhY2VfbW9kZWxzJTJDJTIwcHJvY2Vzc19mYWNlX2VtYmVkZGluZ3NfaW5mZXIlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwc25hcHNob3RfZG93bmxvYWQlMEElMEElMjMlMjBEb3dubG9hZCUyMGNrcHRzJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiUyQyUyMGxvY2FsX2RpciUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiklMEElMEElMjMlMjBMb2FkJTIwZmFjZSUyMGhlbHBlciUyMG1vZGVsJTIwdG8lMjBwcmVwcm9jZXNzJTIwaW5wdXQlMjBmYWNlJTIwaW1hZ2UlMEFmYWNlX2hlbHBlcl8xJTJDJTIwZmFjZV9oZWxwZXJfMiUyQyUyMGZhY2VfY2xpcF9tb2RlbCUyQyUyMGZhY2VfbWFpbl9tb2RlbCUyQyUyMGV2YV90cmFuc2Zvcm1fbWVhbiUyQyUyMGV2YV90cmFuc2Zvcm1fc3RkJTIwJTNEJTIwcHJlcGFyZV9mYWNlX21vZGVscyglMjJCZXN0V2lzaFlzaCUyRkNvbnNpc0lELXByZXZpZXclMjIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEElMEElMjMlMjBMb2FkJTIwY29uc2lzaWQlMjBiYXNlJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwQ29uc2lzSURQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyQmVzdFdpc2hZc2glMkZDb25zaXNJRC1wcmV2aWV3JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-comment"># !pip install consisid_eva_clip insightface facexlib</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ConsisIDPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.consisid.consisid_utils <span class="hljs-keyword">import</span> prepare_face_models, process_face_embeddings_infer
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

<span class="hljs-comment"># Download ckpts</span>
snapshot_download(repo_id=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, local_dir=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>)

<span class="hljs-comment"># Load face helper model to preprocess input face image</span>
face_helper_1, face_helper_2, face_clip_model, face_main_model, eva_transform_mean, eva_transform_std = prepare_face_models(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)

<span class="hljs-comment"># Load consisid base model</span>
pipe = ConsisIDPipeline.from_pretrained(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),v=new O({props:{title:"Identity-Preserving Text-to-Video",local:"identity-preserving-text-to-video",headingTag:"h2"}}),G=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQXByb21wdCUyMCUzRCUyMCUyMlRoZSUyMHZpZGVvJTIwY2FwdHVyZXMlMjBhJTIwYm95JTIwd2Fsa2luZyUyMGFsb25nJTIwYSUyMGNpdHklMjBzdHJlZXQlMkMlMjBmaWxtZWQlMjBpbiUyMGJsYWNrJTIwYW5kJTIwd2hpdGUlMjBvbiUyMGElMjBjbGFzc2ljJTIwMzVtbSUyMGNhbWVyYS4lMjBIaXMlMjBleHByZXNzaW9uJTIwaXMlMjB0aG91Z2h0ZnVsJTJDJTIwaGlzJTIwYnJvdyUyMHNsaWdodGx5JTIwZnVycm93ZWQlMjBhcyUyMGlmJTIwaGUncyUyMGxvc3QlMjBpbiUyMGNvbnRlbXBsYXRpb24uJTIwVGhlJTIwZmlsbSUyMGdyYWluJTIwYWRkcyUyMGElMjB0ZXh0dXJlZCUyQyUyMHRpbWVsZXNzJTIwcXVhbGl0eSUyMHRvJTIwdGhlJTIwaW1hZ2UlMkMlMjBldm9raW5nJTIwYSUyMHNlbnNlJTIwb2YlMjBub3N0YWxnaWEuJTIwQXJvdW5kJTIwaGltJTJDJTIwdGhlJTIwY2l0eXNjYXBlJTIwaXMlMjBmaWxsZWQlMjB3aXRoJTIwdmludGFnZSUyMGJ1aWxkaW5ncyUyQyUyMGNvYmJsZXN0b25lJTIwc2lkZXdhbGtzJTJDJTIwYW5kJTIwc29mdGx5JTIwYmx1cnJlZCUyMGZpZ3VyZXMlMjBwYXNzaW5nJTIwYnklMkMlMjB0aGVpciUyMG91dGxpbmVzJTIwZmFpbnQlMjBhbmQlMjBpbmRpc3RpbmN0LiUyMFN0cmVldGxpZ2h0cyUyMGNhc3QlMjBhJTIwZ2VudGxlJTIwZ2xvdyUyQyUyMHdoaWxlJTIwc2hhZG93cyUyMHBsYXklMjBhY3Jvc3MlMjB0aGUlMjBib3kncyUyMHBhdGglMkMlMjBhZGRpbmclMjBkZXB0aCUyMHRvJTIwdGhlJTIwc2NlbmUuJTIwVGhlJTIwbGlnaHRpbmclMjBoaWdobGlnaHRzJTIwdGhlJTIwYm95J3MlMjBzdWJ0bGUlMjBzbWlsZSUyQyUyMGhpbnRpbmclMjBhdCUyMGElMjBmbGVldGluZyUyMG1vbWVudCUyMG9mJTIwY3VyaW9zaXR5LiUyMFRoZSUyMG92ZXJhbGwlMjBjaW5lbWF0aWMlMjBhdG1vc3BoZXJlJTJDJTIwY29tcGxldGUlMjB3aXRoJTIwY2xhc3NpYyUyMGZpbG0lMjBzdGlsbCUyMGFlc3RoZXRpY3MlMjBhbmQlMjBkcmFtYXRpYyUyMGNvbnRyYXN0cyUyQyUyMGdpdmVzJTIwdGhlJTIwc2NlbmUlMjBhbiUyMGV2b2NhdGl2ZSUyMGFuZCUyMGludHJvc3BlY3RpdmUlMjBmZWVsLiUyMiUwQWltYWdlJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY29uc2lzaWQlMkZjb25zaXNpZF9pbnB1dC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIlMEElMEFpZF9jb25kJTJDJTIwaWRfdml0X2hpZGRlbiUyQyUyMGltYWdlJTJDJTIwZmFjZV9rcHMlMjAlM0QlMjBwcm9jZXNzX2ZhY2VfZW1iZWRkaW5nc19pbmZlcihmYWNlX2hlbHBlcl8xJTJDJTIwZmFjZV9jbGlwX21vZGVsJTJDJTIwZmFjZV9oZWxwZXJfMiUyQyUyMGV2YV90cmFuc2Zvcm1fbWVhbiUyQyUyMGV2YV90cmFuc2Zvcm1fc3RkJTJDJTIwZmFjZV9tYWluX21vZGVsJTJDJTIwJTIyY3VkYSUyMiUyQyUyMHRvcmNoLmJmbG9hdDE2JTJDJTIwaW1hZ2UlMkMlMjBpc19hbGlnbl9mYWNlJTNEVHJ1ZSklMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoaW1hZ2UlM0RpbWFnZSUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENi4wJTJDJTIwdXNlX2R5bmFtaWNfY2ZnJTNERmFsc2UlMkMlMjBpZF92aXRfaGlkZGVuJTNEaWRfdml0X2hpZGRlbiUyQyUyMGlkX2NvbmQlM0RpZF9jb25kJTJDJTIwa3BzX2NvbmQlM0RmYWNlX2twcyUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg0MikpJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvLmZyYW1lcyU1QjAlNUQlMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEOCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

prompt = <span class="hljs-string">&quot;The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#x27;s lost in contemplation. The film grain adds a textured, timeless quality to the image, evoking a sense of nostalgia. Around him, the cityscape is filled with vintage buildings, cobblestone sidewalks, and softly blurred figures passing by, their outlines faint and indistinct. Streetlights cast a gentle glow, while shadows play across the boy&#x27;s path, adding depth to the scene. The lighting highlights the boy&#x27;s subtle smile, hinting at a fleeting moment of curiosity. The overall cinematic atmosphere, complete with classic film still aesthetics and dramatic contrasts, gives the scene an evocative and introspective feel.&quot;</span>
image = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_input.png?download=true&quot;</span>

id_cond, id_vit_hidden, image, face_kps = process_face_embeddings_infer(face_helper_1, face_clip_model, face_helper_2, eva_transform_mean, eva_transform_std, face_main_model, <span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16, image, is_align_face=<span class="hljs-literal">True</span>)

video = pipe(image=image, prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">6.0</span>, use_dynamic_cfg=<span class="hljs-literal">False</span>, id_vit_hidden=id_vit_hidden, id_cond=id_cond, kps_cond=face_kps, generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>))
export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),I=new O({props:{title:"Resources",local:"resources",headingTag:"h2"}}),k=new be({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/consisid.md"}}),{c(){d=l("meta"),x=a(),B=l("p"),Y=a(),r(g.$$.fragment),R=a(),r(y.$$.fragment),V=a(),w=l("p"),w.innerHTML=te,C=a(),M=l("ul"),M.innerHTML=se,N=a(),b=l("p"),b.textContent=ie,$=a(),r(J.$$.fragment),H=a(),T=l("p"),T.innerHTML=ae,Q=a(),r(Z.$$.fragment),z=a(),r(v.$$.fragment),F=a(),U=l("p"),U.textContent=ne,E=a(),r(G.$$.fragment),D=a(),j=l("table"),j.innerHTML=le,q=a(),r(I.$$.fragment),S=a(),_=l("p"),_.textContent=oe,L=a(),W=l("ul"),W.innerHTML=de,P=a(),r(k.$$.fragment),A=a(),X=l("p"),this.h()},l(e){const t=ye("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(s),x=n(e),B=o(e,"P",{}),re(B).forEach(s),Y=n(e),c(g.$$.fragment,e),R=n(e),c(y.$$.fragment,e),V=n(e),w=o(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-436irt"&&(w.innerHTML=te),C=n(e),M=o(e,"UL",{"data-svelte-h":!0}),h(M)!=="svelte-14veasm"&&(M.innerHTML=se),N=n(e),b=o(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1msmrce"&&(b.textContent=ie),$=n(e),c(J.$$.fragment,e),H=n(e),T=o(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-1ia8sef"&&(T.innerHTML=ae),Q=n(e),c(Z.$$.fragment,e),z=n(e),c(v.$$.fragment,e),F=n(e),U=o(e,"P",{"data-svelte-h":!0}),h(U)!=="svelte-1bshl1z"&&(U.textContent=ne),E=n(e),c(G.$$.fragment,e),D=n(e),j=o(e,"TABLE",{"data-svelte-h":!0}),h(j)!=="svelte-1lt1e5d"&&(j.innerHTML=le),q=n(e),c(I.$$.fragment,e),S=n(e),_=o(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1qlvco3"&&(_.textContent=oe),L=n(e),W=o(e,"UL",{"data-svelte-h":!0}),h(W)!=="svelte-169u4r5"&&(W.innerHTML=de),P=n(e),c(k.$$.fragment,e),A=n(e),X=o(e,"P",{}),re(X).forEach(s),this.h()},h(){ce(d,"name","hf:doc:metadata"),ce(d,"content",Te)},m(e,t){we(document.head,d),i(e,x,t),i(e,B,t),i(e,Y,t),m(g,e,t),i(e,R,t),m(y,e,t),i(e,V,t),i(e,w,t),i(e,C,t),i(e,M,t),i(e,N,t),i(e,b,t),i(e,$,t),m(J,e,t),i(e,H,t),i(e,T,t),i(e,Q,t),m(Z,e,t),i(e,z,t),m(v,e,t),i(e,F,t),i(e,U,t),i(e,E,t),m(G,e,t),i(e,D,t),i(e,j,t),i(e,q,t),m(I,e,t),i(e,S,t),i(e,_,t),i(e,L,t),i(e,W,t),i(e,P,t),m(k,e,t),i(e,A,t),i(e,X,t),K=!0},p:pe,i(e){K||(p(g.$$.fragment,e),p(y.$$.fragment,e),p(J.$$.fragment,e),p(Z.$$.fragment,e),p(v.$$.fragment,e),p(G.$$.fragment,e),p(I.$$.fragment,e),p(k.$$.fragment,e),K=!0)},o(e){u(g.$$.fragment,e),u(y.$$.fragment,e),u(J.$$.fragment,e),u(Z.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(I.$$.fragment,e),u(k.$$.fragment,e),K=!1},d(e){e&&(s(x),s(B),s(Y),s(R),s(V),s(w),s(C),s(M),s(N),s(b),s($),s(H),s(T),s(Q),s(z),s(F),s(U),s(E),s(D),s(j),s(q),s(S),s(_),s(L),s(W),s(P),s(A),s(X)),s(d),f(g,e),f(y,e),f(J,e),f(Z,e),f(v,e),f(G,e),f(I,e),f(k,e)}}}const Te='{"title":"ConsisID","local":"consisid","sections":[{"title":"Load Model Checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Identity-Preserving Text-to-Video","local":"identity-preserving-text-to-video","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Ze(ee){return ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends fe{constructor(d){super(),ge(this,d,Ze,Je,me,{})}}export{_e as component};
