import{s as es,n as ls,o as ts}from"../chunks/scheduler.53228c21.js";import{S as as,i as ss,e as n,s,c as o,h as is,a as m,d as t,b as i,f as Oa,g as r,j as p,k as M,l as ns,m as a,n as c,t as d,o as g,p as y}from"../chunks/index.100fac89.js";import{C as ms}from"../chunks/CopyLLMTxtMenu.494046bd.js";import{C as u}from"../chunks/CodeBlock.d30a6509.js";import{D as ps}from"../chunks/DocNotebookDropdown.74a16910.js";import{H as b,E as os}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8999c127.js";function rs(ea){let f,ol,ml,rl,X,cl,_,dl,k,gl,F,la='Image-to-image is similar to <a href="conditional_image_generation">text-to-image</a>, but in addition to a prompt, you can also pass an initial image as a starting point for the diffusion process. The initial image is encoded to latent space and noise is added to it. Then the latent diffusion model takes a prompt and the noisy latent image, predicts the added noise, and removes the predicted noise from the initial latent image to get the new latent image. Lastly, a decoder decodes the new latent image back into an image.',yl,Q,ta="With 🤗 Diffusers, this is as easy as 1-2-3:",ul,R,aa='<li>Load a checkpoint into the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> class; this pipeline automatically handles loading the correct pipeline class  based on the checkpoint:</li>',bl,C,Ml,J,sa='<p>You’ll notice throughout the guide, we use <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a>, to save memory and increase inference speed. If you’re using PyTorch 2.0, then you don’t need to call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on your pipeline because it’ll already be using PyTorch 2.0’s native <a href="../optimization/fp16#scaled-dot-product-attention">scaled-dot product attention</a>.</p>',fl,h,ia="<li>Load an image to pass to the pipeline:</li>",Jl,S,hl,Z,na="<li>Pass a prompt and image to the pipeline to generate an image:</li>",Zl,$,wl,w,ma='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Ul,Y,Tl,N,pa='The most popular image-to-image models are <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">Stable Diffusion v1.5</a>, <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">Stable Diffusion XL (SDXL)</a>, and <a href="https://huggingface.co/kandinsky-community/kandinsky-2-2-decoder" rel="nofollow">Kandinsky 2.2</a>. The results from the Stable Diffusion and Kandinsky models vary due to their architecture differences and training process; you can generally expect SDXL to produce higher quality images than Stable Diffusion v1.5. Let’s take a quick look at how to use each of these models and compare their results.',Wl,H,Gl,z,oa="Stable Diffusion v1.5 is a latent diffusion model initialized from an earlier checkpoint, and further finetuned for 595K steps on 512x512 images. To use this pipeline for image-to-image, you’ll need to prepare an initial image to pass to the pipeline. Then you can pass a prompt and the image to the pipeline to generate a new image:",jl,E,vl,U,ra='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdv1.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Il,q,Bl,L,ca='SDXL is a more powerful version of the Stable Diffusion model. It uses a larger base model, and an additional refiner model to increase the quality of the base model’s output. Read the <a href="sdxl">SDXL</a> guide for a more detailed walkthrough of how to use this model, and other techniques it uses to produce high quality images.',Vl,D,xl,T,da='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Xl,A,_l,P,ga="The Kandinsky model is different from the Stable Diffusion models because it uses an image prior model to create image embeddings. The embeddings help create a better alignment between text and images, allowing the latent diffusion model to generate better images.",kl,K,ya="The simplest way to use Kandinsky 2.2 is:",Fl,O,Ql,W,ua='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-kandinsky.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Rl,ee,Cl,le,ba="There are several important parameters you can configure in the pipeline that’ll affect the image generation process and image quality. Let’s take a closer look at what these parameters do and how changing them affects the output.",Sl,te,$l,ae,Ma="<code>strength</code> is one of the most important parameters to consider and it’ll have a huge impact on your generated image. It determines how much the generated image resembles the initial image. In other words:",Yl,se,fa="<li>📈 a higher <code>strength</code> value gives the model more “creativity” to generate an image that’s different from the initial image; a <code>strength</code> value of 1.0 means the initial image is more or less ignored</li> <li>📉 a lower <code>strength</code> value means the generated image is more similar to the initial image</li>",Nl,ie,Ja="The <code>strength</code> and <code>num_inference_steps</code> parameters are related because <code>strength</code> determines the number of noise steps to add. For example, if the <code>num_inference_steps</code> is 50 and <code>strength</code> is 0.8, then this means adding 40 (50 * 0.8) steps of noise to the initial image and then denoising for 40 steps to get the newly generated image.",Hl,ne,zl,G,ha='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-0.4.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.4</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-0.6.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.6</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-1.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 1.0</figcaption></div>',El,me,ql,pe,Za="The <code>guidance_scale</code> parameter is used to control how closely aligned the generated image and text prompt are. A higher <code>guidance_scale</code> value means your generated image is more aligned with the prompt, while a lower <code>guidance_scale</code> value means your generated image has more space to deviate from the prompt.",Ll,oe,wa="You can combine <code>guidance_scale</code> with <code>strength</code> for even more precise control over how expressive the model is. For example, combine a high <code>strength + guidance_scale</code> for maximum creativity or use a combination of low <code>strength</code> and low <code>guidance_scale</code> to generate an image that resembles the initial image but is not as strictly bound to the prompt.",Dl,re,Al,j,Ua='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-0.1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 0.1</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-3.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 5.0</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-7.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 10.0</figcaption></div>',Pl,ce,Kl,de,Ta="A negative prompt conditions the model to <em>not</em> include things in an image, and it can be used to improve image quality or modify an image. For example, you can improve image quality by including negative prompts like “poor details” or “blurry” to encourage the model to generate a higher quality image. Or you can modify an image by specifying things to exclude from an image.",Ol,ge,et,v,Wa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-negative-1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative_prompt = &quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-negative-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative_prompt = &quot;jungle&quot;</figcaption></div>',lt,ye,tt,ue,Ga="There are some other interesting ways you can use an image-to-image pipeline aside from just generating an image (although that is pretty cool too). You can take it a step further and chain it with other pipelines.",at,be,st,Me,ja="Chaining a text-to-image and image-to-image pipeline allows you to generate an image from text and use the generated image as the initial image for the image-to-image pipeline. This is useful if you want to generate an image entirely from scratch. For example, let’s chain a Stable Diffusion and a Kandinsky model.",it,fe,va="Start by generating an image with the text-to-image pipeline:",nt,Je,mt,he,Ia="Now you can pass this generated image to the image-to-image pipeline:",pt,Ze,ot,we,rt,Ue,Ba="You can also chain multiple image-to-image pipelines together to create more interesting images. This can be useful for iteratively performing style transfer on an image, generating short GIFs, restoring color to an image, or restoring missing areas of an image.",ct,Te,Va="Start by generating an image:",dt,We,gt,I,xa="<p>It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in latent space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE.</p>",yt,Ge,Xa='Pass the latent output from this pipeline to the next pipeline to generate an image in a <a href="https://huggingface.co/ogkalu/Comic-Diffusion" rel="nofollow">comic book art style</a>:',ut,je,bt,ve,_a='Repeat one more time to generate the final image in a <a href="https://huggingface.co/kohbanye/pixel-art-style" rel="nofollow">pixel art style</a>:',Mt,Ie,ft,Be,Jt,Ve,ka="Another way you can chain your image-to-image pipeline is with an upscaler and super-resolution pipeline to really increase the level of details in an image.",ht,xe,Fa="Start with an image-to-image pipeline:",Zt,Xe,wt,B,Qa="<p>It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in <em>latent</em> space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE.</p>",Ut,_e,Ra="Chain it to an upscaler pipeline to increase the image resolution:",Tt,ke,Wt,Fe,Ca="Finally, chain it to a super-resolution pipeline to further enhance the resolution:",Gt,Qe,jt,Re,vt,Ce,Sa="Trying to generate an image that looks exactly the way you want can be difficult, which is why controlled generation techniques and models are so useful. While you can use the <code>negative_prompt</code> to partially control image generation, there are more robust methods like prompt weighting and ControlNets.",It,Se,Bt,$e,$a='Prompt weighting allows you to scale the representation of each concept in a prompt. For example, in a prompt like “Astronaut in a jungle, cold color palette, muted colors, detailed, 8k”, you can choose to increase or decrease the embeddings of “astronaut” and “jungle”. The <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a> library provides a simple syntax for adjusting prompt weights and generating the embeddings. You can learn how to create the embeddings in the <a href="weighted_prompts">Prompt weighting</a> guide.',Vt,Ye,Ya='<a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> has a <code>prompt_embeds</code> (and <code>negative_prompt_embeds</code> if you’re using a negative prompt) parameter where you can pass the embeddings which replaces the <code>prompt</code> parameter.',xt,Ne,Xt,He,_t,ze,Na="ControlNets provide a more flexible and accurate way to control image generation because you can use an additional conditioning image. The conditioning image can be a canny image, depth map, image segmentation, and even scribbles! Whatever type of conditioning image you choose, the ControlNet generates an image that preserves the information in it.",kt,Ee,Ha="For example, let’s condition an image with a depth map to keep the spatial information in the image.",Ft,qe,Qt,Le,za='Load a ControlNet model conditioned on depth maps and the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a>:',Rt,De,Ct,Ae,Ea="Now generate a new image conditioned on the depth map, initial image, and prompt:",St,Pe,$t,V,qa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/lllyasviel/control_v11f1p_sd15_depth/resolve/main/images/control.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ControlNet image</figcaption></div>',Yt,Ke,La='Let’s apply a new <a href="https://huggingface.co/nitrosocke/elden-ring-diffusion" rel="nofollow">style</a> to the image generated from the ControlNet by chaining it with an image-to-image pipeline:',Nt,Oe,Ht,x,Da='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-elden-ring.png"/>',zt,el,Et,ll,Aa='Running diffusion models is computationally expensive and intensive, but with a few optimization tricks, it is entirely possible to run them on consumer and free-tier GPUs. For example, you can use a more memory-efficient form of attention such as PyTorch 2.0’s <a href="../optimization/fp16#scaled-dot-product-attention">scaled-dot product attention</a> or <a href="../optimization/xformers">xFormers</a> (you can use one or the other, but there’s no need to use both). You can also offload the model to the GPU while the other pipeline components wait on the CPU.',qt,tl,Lt,al,Pa='With <a href="../optimization/fp16#torchcompile"><code>torch.compile</code></a>, you can boost your inference speed even more by wrapping your UNet with it:',Dt,sl,At,il,Ka='To learn more, take a look at the <a href="../optimization/memory">Reduce memory usage</a> and <a href="../optimization/fp16">Accelerate inference</a> guides.',Pt,nl,Kt,pl,Ot;return X=new ms({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_=new ps({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/img2img.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/img2img.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/img2img.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/img2img.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/img2img.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/img2img.ipynb"}]}}),k=new b({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h1"}}),C=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),S=new u({props:{code:"aW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY2F0LnBuZyUyMik=",highlighted:'init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)',wrap:!1}}),$=new u({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Y=new b({props:{title:"Popular models",local:"popular-models",headingTag:"h2"}}),H=new b({props:{title:"Stable Diffusion v1.5",local:"stable-diffusion-v15",headingTag:"h3"}}),E=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),q=new b({props:{title:"Stable Diffusion XL (SDXL)",local:"stable-diffusion-xl-sdxl",headingTag:"h3"}}),D=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctc2R4bC1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjUpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),A=new b({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h3"}}),O=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ee=new b({props:{title:"Configure pipeline parameters",local:"configure-pipeline-parameters",headingTag:"h2"}}),te=new b({props:{title:"Strength",local:"strength",headingTag:"h3"}}),ne=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC44KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.8</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),me=new b({props:{title:"Guidance scale",local:"guidance-scale",headingTag:"h3"}}),re=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, guidance_scale=<span class="hljs-number">8.0</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ce=new b({props:{title:"Negative prompt",local:"negative-prompt",headingTag:"h3"}}),ge=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMnVnbHklMkMlMjBkZWZvcm1lZCUyQyUyMGRpc2ZpZ3VyZWQlMkMlMjBwb29yJTIwZGV0YWlscyUyQyUyMGJhZCUyMGFuYXRvbXklMjIlMEElMEElMjMlMjBwYXNzJTIwcHJvbXB0JTIwYW5kJTIwaW1hZ2UlMjB0byUyMHBpcGVsaW5lJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, negative_prompt=negative_prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ye=new b({props:{title:"Chained image-to-image pipelines",local:"chained-image-to-image-pipelines",headingTag:"h2"}}),be=new b({props:{title:"Text-to-image-to-image",local:"text-to-image-to-image",headingTag:"h3"}}),Je=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBdGV4dDJpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIpLmltYWdlcyU1QjAlNUQlMEF0ZXh0MmltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

text2image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>).images[<span class="hljs-number">0</span>]
text2image`,wrap:!1}}),Ze=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFpbWFnZTJpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBpbWFnZSUzRHRleHQyaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCdGV4dDJpbWFnZSUyQyUyMGltYWdlMmltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image2image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=text2image).images[<span class="hljs-number">0</span>]
make_image_grid([text2image, image2image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),we=new b({props:{title:"Image-to-image-to-image",local:"image-to-image-to-image",headingTag:"h3"}}),We=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),je=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb2drYWx1JTJGQ29taWMtRGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbmVlZCUyMHRvJTIwaW5jbHVkZSUyMHRoZSUyMHRva2VuJTIwJTIyY2hhcmxpZWJvJTIwYXJ0c3R5bGUlMjIlMjBpbiUyMHRoZSUyMHByb21wdCUyMHRvJTIwdXNlJTIwdGhpcyUyMGNoZWNrcG9pbnQlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNoYXJsaWVibyUyMGFydHN0eWxlJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;ogkalu/Comic-Diffusion&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># need to include the token &quot;charliebo artstyle&quot; in the prompt to use this checkpoint</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, charliebo artstyle&quot;</span>, image=image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ie=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya29oYmFueWUlMkZwaXhlbC1hcnQtc3R5bGUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBuZWVkJTIwdG8lMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJwaXhlbGFydHN0eWxlJTIyJTIwaW4lMjB0aGUlMjBwcm9tcHQlMjB0byUyMHVzZSUyMHRoaXMlMjBjaGVja3BvaW50JTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBwaXhlbGFydHN0eWxlJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kohbanye/pixel-art-style&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># need to include the token &quot;pixelartstyle&quot; in the prompt to use this checkpoint</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, pixelartstyle&quot;</span>, image=image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Be=new b({props:{title:"Image-to-upscaler-to-super-resolution",local:"image-to-upscaler-to-super-resolution",headingTag:"h3"}}),Xe=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZV8xJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image_1 = pipeline(prompt, image=init_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ke=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUwQSUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdXBzY2FsZXIuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEF1cHNjYWxlci5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlXzIlMjAlM0QlMjB1cHNjYWxlcihwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlXzEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline

upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
upscaler.enable_model_cpu_offload()
upscaler.enable_xformers_memory_efficient_attention()

image_2 = upscaler(prompt, image=image_1).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Qe=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQSUwQXN1cGVyX3JlcyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXg0LXVwc2NhbGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXN1cGVyX3Jlcy5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXN1cGVyX3Jlcy5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlXzMlMjAlM0QlMjBzdXBlcl9yZXMocHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZV8yKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZV8zLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline

super_res = StableDiffusionUpscalePipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
super_res.enable_model_cpu_offload()
super_res.enable_xformers_memory_efficient_attention()

image_3 = super_res(prompt, image=image_2).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image_3.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Re=new b({props:{title:"Control image generation",local:"control-image-generation",headingTag:"h2"}}),Se=new b({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h3"}}),Ne=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTJDJTIwJTIzJTIwZ2VuZXJhdGVkJTIwZnJvbSUyMENvbXBlbCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTJDJTIwJTIzJTIwZ2VuZXJhdGVkJTIwZnJvbSUyMENvbXBlbCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt_embeds=prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    negative_prompt_embeds=negative_prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    image=init_image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),He=new b({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),qe=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbWcyaW1nLWluaXQucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoOTU4JTJDJTIwOTYwKSklMjAlMjMlMjByZXNpemUlMjB0byUyMGRlcHRoJTIwaW1hZ2UlMjBkaW1lbnNpb25zJTBBZGVwdGhfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyRnJlc29sdmUlMkZtYWluJTJGaW1hZ2VzJTJGY29udHJvbC5wbmclMjIpJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)
init_image = init_image.resize((<span class="hljs-number">958</span>, <span class="hljs-number">960</span>)) <span class="hljs-comment"># resize to depth image dimensions</span>
depth_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11f1p_sd15_depth/resolve/main/images/control.png&quot;</span>)
make_image_grid([init_image, depth_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),De=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),Pe=new u({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlX2NvbnRyb2xfbmV0JTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGRlcHRoX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyQyUyMGltYWdlX2NvbnRyb2xfbmV0JTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image_control_net = pipeline(prompt, image=init_image, control_image=depth_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, depth_image, image_control_net], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),Oe=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybml0cm9zb2NrZSUyRmVsZGVuLXJpbmctZGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZWxkZW4lMjByaW5nJTIwc3R5bGUlMjBhc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMjIlMjAlMjMlMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJlbGRlbiUyMHJpbmclMjBzdHlsZSUyMiUyMGluJTIwdGhlJTIwcHJvbXB0JTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIydWdseSUyQyUyMGRlZm9ybWVkJTJDJTIwZGlzZmlndXJlZCUyQyUyMHBvb3IlMjBkZXRhaWxzJTJDJTIwYmFkJTIwYW5hdG9teSUyMiUwQSUwQWltYWdlX2VsZGVuX3JpbmclMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlX2NvbnRyb2xfbmV0JTJDJTIwc3RyZW5ndGglM0QwLjQ1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMC41KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyQyUyMGltYWdlX2NvbnRyb2xfbmV0JTJDJTIwaW1hZ2VfZWxkZW5fcmluZyU1RCUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDIp",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;nitrosocke/elden-ring-diffusion&quot;</span>, torch_dtype=torch.float16,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;elden ring style astronaut in a jungle&quot;</span> <span class="hljs-comment"># include the token &quot;elden ring style&quot; in the prompt</span>
negative_prompt = <span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>

image_elden_ring = pipeline(prompt, negative_prompt=negative_prompt, image=image_control_net, strength=<span class="hljs-number">0.45</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, depth_image, image_control_net, image_elden_ring], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),el=new b({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),tl=new u({props:{code:"JTJCJTIwcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipeline.enable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),sl=new u({props:{code:"cGlwZWxpbmUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:'pipeline.unet = torch.<span class="hljs-built_in">compile</span>(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),nl=new os({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/img2img.md"}}),{c(){f=n("meta"),ol=s(),ml=n("p"),rl=s(),o(X.$$.fragment),cl=s(),o(_.$$.fragment),dl=s(),o(k.$$.fragment),gl=s(),F=n("p"),F.innerHTML=la,yl=s(),Q=n("p"),Q.textContent=ta,ul=s(),R=n("ol"),R.innerHTML=aa,bl=s(),o(C.$$.fragment),Ml=s(),J=n("blockquote"),J.innerHTML=sa,fl=s(),h=n("ol"),h.innerHTML=ia,Jl=s(),o(S.$$.fragment),hl=s(),Z=n("ol"),Z.innerHTML=na,Zl=s(),o($.$$.fragment),wl=s(),w=n("div"),w.innerHTML=ma,Ul=s(),o(Y.$$.fragment),Tl=s(),N=n("p"),N.innerHTML=pa,Wl=s(),o(H.$$.fragment),Gl=s(),z=n("p"),z.textContent=oa,jl=s(),o(E.$$.fragment),vl=s(),U=n("div"),U.innerHTML=ra,Il=s(),o(q.$$.fragment),Bl=s(),L=n("p"),L.innerHTML=ca,Vl=s(),o(D.$$.fragment),xl=s(),T=n("div"),T.innerHTML=da,Xl=s(),o(A.$$.fragment),_l=s(),P=n("p"),P.textContent=ga,kl=s(),K=n("p"),K.textContent=ya,Fl=s(),o(O.$$.fragment),Ql=s(),W=n("div"),W.innerHTML=ua,Rl=s(),o(ee.$$.fragment),Cl=s(),le=n("p"),le.textContent=ba,Sl=s(),o(te.$$.fragment),$l=s(),ae=n("p"),ae.innerHTML=Ma,Yl=s(),se=n("ul"),se.innerHTML=fa,Nl=s(),ie=n("p"),ie.innerHTML=Ja,Hl=s(),o(ne.$$.fragment),zl=s(),G=n("div"),G.innerHTML=ha,El=s(),o(me.$$.fragment),ql=s(),pe=n("p"),pe.innerHTML=Za,Ll=s(),oe=n("p"),oe.innerHTML=wa,Dl=s(),o(re.$$.fragment),Al=s(),j=n("div"),j.innerHTML=Ua,Pl=s(),o(ce.$$.fragment),Kl=s(),de=n("p"),de.innerHTML=Ta,Ol=s(),o(ge.$$.fragment),et=s(),v=n("div"),v.innerHTML=Wa,lt=s(),o(ye.$$.fragment),tt=s(),ue=n("p"),ue.textContent=Ga,at=s(),o(be.$$.fragment),st=s(),Me=n("p"),Me.textContent=ja,it=s(),fe=n("p"),fe.textContent=va,nt=s(),o(Je.$$.fragment),mt=s(),he=n("p"),he.textContent=Ia,pt=s(),o(Ze.$$.fragment),ot=s(),o(we.$$.fragment),rt=s(),Ue=n("p"),Ue.textContent=Ba,ct=s(),Te=n("p"),Te.textContent=Va,dt=s(),o(We.$$.fragment),gt=s(),I=n("blockquote"),I.innerHTML=xa,yt=s(),Ge=n("p"),Ge.innerHTML=Xa,ut=s(),o(je.$$.fragment),bt=s(),ve=n("p"),ve.innerHTML=_a,Mt=s(),o(Ie.$$.fragment),ft=s(),o(Be.$$.fragment),Jt=s(),Ve=n("p"),Ve.textContent=ka,ht=s(),xe=n("p"),xe.textContent=Fa,Zt=s(),o(Xe.$$.fragment),wt=s(),B=n("blockquote"),B.innerHTML=Qa,Ut=s(),_e=n("p"),_e.textContent=Ra,Tt=s(),o(ke.$$.fragment),Wt=s(),Fe=n("p"),Fe.textContent=Ca,Gt=s(),o(Qe.$$.fragment),jt=s(),o(Re.$$.fragment),vt=s(),Ce=n("p"),Ce.innerHTML=Sa,It=s(),o(Se.$$.fragment),Bt=s(),$e=n("p"),$e.innerHTML=$a,Vt=s(),Ye=n("p"),Ye.innerHTML=Ya,xt=s(),o(Ne.$$.fragment),Xt=s(),o(He.$$.fragment),_t=s(),ze=n("p"),ze.textContent=Na,kt=s(),Ee=n("p"),Ee.textContent=Ha,Ft=s(),o(qe.$$.fragment),Qt=s(),Le=n("p"),Le.innerHTML=za,Rt=s(),o(De.$$.fragment),Ct=s(),Ae=n("p"),Ae.textContent=Ea,St=s(),o(Pe.$$.fragment),$t=s(),V=n("div"),V.innerHTML=qa,Yt=s(),Ke=n("p"),Ke.innerHTML=La,Nt=s(),o(Oe.$$.fragment),Ht=s(),x=n("div"),x.innerHTML=Da,zt=s(),o(el.$$.fragment),Et=s(),ll=n("p"),ll.innerHTML=Aa,qt=s(),o(tl.$$.fragment),Lt=s(),al=n("p"),al.innerHTML=Pa,Dt=s(),o(sl.$$.fragment),At=s(),il=n("p"),il.innerHTML=Ka,Pt=s(),o(nl.$$.fragment),Kt=s(),pl=n("p"),this.h()},l(e){const l=is("svelte-u9bgzb",document.head);f=m(l,"META",{name:!0,content:!0}),l.forEach(t),ol=i(e),ml=m(e,"P",{}),Oa(ml).forEach(t),rl=i(e),r(X.$$.fragment,e),cl=i(e),r(_.$$.fragment,e),dl=i(e),r(k.$$.fragment,e),gl=i(e),F=m(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-190i437"&&(F.innerHTML=la),yl=i(e),Q=m(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-18jurtu"&&(Q.textContent=ta),ul=i(e),R=m(e,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-1fqulv3"&&(R.innerHTML=aa),bl=i(e),r(C.$$.fragment,e),Ml=i(e),J=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(J)!=="svelte-6k8ium"&&(J.innerHTML=sa),fl=i(e),h=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(h)!=="svelte-1yttwto"&&(h.innerHTML=ia),Jl=i(e),r(S.$$.fragment,e),hl=i(e),Z=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(Z)!=="svelte-17g0twj"&&(Z.innerHTML=na),Zl=i(e),r($.$$.fragment,e),wl=i(e),w=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-192ix8m"&&(w.innerHTML=ma),Ul=i(e),r(Y.$$.fragment,e),Tl=i(e),N=m(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-c2zerw"&&(N.innerHTML=pa),Wl=i(e),r(H.$$.fragment,e),Gl=i(e),z=m(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-23k6o9"&&(z.textContent=oa),jl=i(e),r(E.$$.fragment,e),vl=i(e),U=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-muzf0t"&&(U.innerHTML=ra),Il=i(e),r(q.$$.fragment,e),Bl=i(e),L=m(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-x0iv90"&&(L.innerHTML=ca),Vl=i(e),r(D.$$.fragment,e),xl=i(e),T=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-1ki51a7"&&(T.innerHTML=da),Xl=i(e),r(A.$$.fragment,e),_l=i(e),P=m(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-c3e484"&&(P.textContent=ga),kl=i(e),K=m(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-tfl439"&&(K.textContent=ya),Fl=i(e),r(O.$$.fragment,e),Ql=i(e),W=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1tge0cq"&&(W.innerHTML=ua),Rl=i(e),r(ee.$$.fragment,e),Cl=i(e),le=m(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-j0fbzb"&&(le.textContent=ba),Sl=i(e),r(te.$$.fragment,e),$l=i(e),ae=m(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1bx3wp7"&&(ae.innerHTML=Ma),Yl=i(e),se=m(e,"UL",{"data-svelte-h":!0}),p(se)!=="svelte-1oz5aud"&&(se.innerHTML=fa),Nl=i(e),ie=m(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-wy7ow0"&&(ie.innerHTML=Ja),Hl=i(e),r(ne.$$.fragment,e),zl=i(e),G=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-1hvatx7"&&(G.innerHTML=ha),El=i(e),r(me.$$.fragment,e),ql=i(e),pe=m(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-mfa26b"&&(pe.innerHTML=Za),Ll=i(e),oe=m(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1629z5b"&&(oe.innerHTML=wa),Dl=i(e),r(re.$$.fragment,e),Al=i(e),j=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-k63kz7"&&(j.innerHTML=Ua),Pl=i(e),r(ce.$$.fragment,e),Kl=i(e),de=m(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1qpoxoh"&&(de.innerHTML=Ta),Ol=i(e),r(ge.$$.fragment,e),et=i(e),v=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-1fvp45w"&&(v.innerHTML=Wa),lt=i(e),r(ye.$$.fragment,e),tt=i(e),ue=m(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-bxn4p5"&&(ue.textContent=Ga),at=i(e),r(be.$$.fragment,e),st=i(e),Me=m(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-xxuxjq"&&(Me.textContent=ja),it=i(e),fe=m(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1edszux"&&(fe.textContent=va),nt=i(e),r(Je.$$.fragment,e),mt=i(e),he=m(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-3cniud"&&(he.textContent=Ia),pt=i(e),r(Ze.$$.fragment,e),ot=i(e),r(we.$$.fragment,e),rt=i(e),Ue=m(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1r5hoyw"&&(Ue.textContent=Ba),ct=i(e),Te=m(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-19cg56z"&&(Te.textContent=Va),dt=i(e),r(We.$$.fragment,e),gt=i(e),I=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-1xahv4j"&&(I.innerHTML=xa),yt=i(e),Ge=m(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-clpsz0"&&(Ge.innerHTML=Xa),ut=i(e),r(je.$$.fragment,e),bt=i(e),ve=m(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-w98xng"&&(ve.innerHTML=_a),Mt=i(e),r(Ie.$$.fragment,e),ft=i(e),r(Be.$$.fragment,e),Jt=i(e),Ve=m(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1ojjd40"&&(Ve.textContent=ka),ht=i(e),xe=m(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-18merz0"&&(xe.textContent=Fa),Zt=i(e),r(Xe.$$.fragment,e),wt=i(e),B=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-1eyfdjm"&&(B.innerHTML=Qa),Ut=i(e),_e=m(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-cmxlpu"&&(_e.textContent=Ra),Tt=i(e),r(ke.$$.fragment,e),Wt=i(e),Fe=m(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-vr292z"&&(Fe.textContent=Ca),Gt=i(e),r(Qe.$$.fragment,e),jt=i(e),r(Re.$$.fragment,e),vt=i(e),Ce=m(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-14io5mk"&&(Ce.innerHTML=Sa),It=i(e),r(Se.$$.fragment,e),Bt=i(e),$e=m(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-10g432e"&&($e.innerHTML=$a),Vt=i(e),Ye=m(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1q40btg"&&(Ye.innerHTML=Ya),xt=i(e),r(Ne.$$.fragment,e),Xt=i(e),r(He.$$.fragment,e),_t=i(e),ze=m(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1enrnw9"&&(ze.textContent=Na),kt=i(e),Ee=m(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1dqw2pd"&&(Ee.textContent=Ha),Ft=i(e),r(qe.$$.fragment,e),Qt=i(e),Le=m(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-aafidq"&&(Le.innerHTML=za),Rt=i(e),r(De.$$.fragment,e),Ct=i(e),Ae=m(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-kmdmdi"&&(Ae.textContent=Ea),St=i(e),r(Pe.$$.fragment,e),$t=i(e),V=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-nm98y9"&&(V.innerHTML=qa),Yt=i(e),Ke=m(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-77whwd"&&(Ke.innerHTML=La),Nt=i(e),r(Oe.$$.fragment,e),Ht=i(e),x=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-9lkq3b"&&(x.innerHTML=Da),zt=i(e),r(el.$$.fragment,e),Et=i(e),ll=m(e,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-1vtgt6h"&&(ll.innerHTML=Aa),qt=i(e),r(tl.$$.fragment,e),Lt=i(e),al=m(e,"P",{"data-svelte-h":!0}),p(al)!=="svelte-hnnorq"&&(al.innerHTML=Pa),Dt=i(e),r(sl.$$.fragment,e),At=i(e),il=m(e,"P",{"data-svelte-h":!0}),p(il)!=="svelte-jwocdx"&&(il.innerHTML=Ka),Pt=i(e),r(nl.$$.fragment,e),Kt=i(e),pl=m(e,"P",{}),Oa(pl).forEach(t),this.h()},h(){M(f,"name","hf:doc:metadata"),M(f,"content",cs),M(J,"class","tip"),M(h,"start","2"),M(Z,"start","3"),M(w,"class","flex gap-4"),M(U,"class","flex gap-4"),M(T,"class","flex gap-4"),M(W,"class","flex gap-4"),M(G,"class","flex flex-row gap-4"),M(j,"class","flex flex-row gap-4"),M(v,"class","flex flex-row gap-4"),M(I,"class","tip"),M(B,"class","tip"),M(V,"class","flex flex-row gap-4"),M(x,"class","flex justify-center")},m(e,l){ns(document.head,f),a(e,ol,l),a(e,ml,l),a(e,rl,l),c(X,e,l),a(e,cl,l),c(_,e,l),a(e,dl,l),c(k,e,l),a(e,gl,l),a(e,F,l),a(e,yl,l),a(e,Q,l),a(e,ul,l),a(e,R,l),a(e,bl,l),c(C,e,l),a(e,Ml,l),a(e,J,l),a(e,fl,l),a(e,h,l),a(e,Jl,l),c(S,e,l),a(e,hl,l),a(e,Z,l),a(e,Zl,l),c($,e,l),a(e,wl,l),a(e,w,l),a(e,Ul,l),c(Y,e,l),a(e,Tl,l),a(e,N,l),a(e,Wl,l),c(H,e,l),a(e,Gl,l),a(e,z,l),a(e,jl,l),c(E,e,l),a(e,vl,l),a(e,U,l),a(e,Il,l),c(q,e,l),a(e,Bl,l),a(e,L,l),a(e,Vl,l),c(D,e,l),a(e,xl,l),a(e,T,l),a(e,Xl,l),c(A,e,l),a(e,_l,l),a(e,P,l),a(e,kl,l),a(e,K,l),a(e,Fl,l),c(O,e,l),a(e,Ql,l),a(e,W,l),a(e,Rl,l),c(ee,e,l),a(e,Cl,l),a(e,le,l),a(e,Sl,l),c(te,e,l),a(e,$l,l),a(e,ae,l),a(e,Yl,l),a(e,se,l),a(e,Nl,l),a(e,ie,l),a(e,Hl,l),c(ne,e,l),a(e,zl,l),a(e,G,l),a(e,El,l),c(me,e,l),a(e,ql,l),a(e,pe,l),a(e,Ll,l),a(e,oe,l),a(e,Dl,l),c(re,e,l),a(e,Al,l),a(e,j,l),a(e,Pl,l),c(ce,e,l),a(e,Kl,l),a(e,de,l),a(e,Ol,l),c(ge,e,l),a(e,et,l),a(e,v,l),a(e,lt,l),c(ye,e,l),a(e,tt,l),a(e,ue,l),a(e,at,l),c(be,e,l),a(e,st,l),a(e,Me,l),a(e,it,l),a(e,fe,l),a(e,nt,l),c(Je,e,l),a(e,mt,l),a(e,he,l),a(e,pt,l),c(Ze,e,l),a(e,ot,l),c(we,e,l),a(e,rt,l),a(e,Ue,l),a(e,ct,l),a(e,Te,l),a(e,dt,l),c(We,e,l),a(e,gt,l),a(e,I,l),a(e,yt,l),a(e,Ge,l),a(e,ut,l),c(je,e,l),a(e,bt,l),a(e,ve,l),a(e,Mt,l),c(Ie,e,l),a(e,ft,l),c(Be,e,l),a(e,Jt,l),a(e,Ve,l),a(e,ht,l),a(e,xe,l),a(e,Zt,l),c(Xe,e,l),a(e,wt,l),a(e,B,l),a(e,Ut,l),a(e,_e,l),a(e,Tt,l),c(ke,e,l),a(e,Wt,l),a(e,Fe,l),a(e,Gt,l),c(Qe,e,l),a(e,jt,l),c(Re,e,l),a(e,vt,l),a(e,Ce,l),a(e,It,l),c(Se,e,l),a(e,Bt,l),a(e,$e,l),a(e,Vt,l),a(e,Ye,l),a(e,xt,l),c(Ne,e,l),a(e,Xt,l),c(He,e,l),a(e,_t,l),a(e,ze,l),a(e,kt,l),a(e,Ee,l),a(e,Ft,l),c(qe,e,l),a(e,Qt,l),a(e,Le,l),a(e,Rt,l),c(De,e,l),a(e,Ct,l),a(e,Ae,l),a(e,St,l),c(Pe,e,l),a(e,$t,l),a(e,V,l),a(e,Yt,l),a(e,Ke,l),a(e,Nt,l),c(Oe,e,l),a(e,Ht,l),a(e,x,l),a(e,zt,l),c(el,e,l),a(e,Et,l),a(e,ll,l),a(e,qt,l),c(tl,e,l),a(e,Lt,l),a(e,al,l),a(e,Dt,l),c(sl,e,l),a(e,At,l),a(e,il,l),a(e,Pt,l),c(nl,e,l),a(e,Kt,l),a(e,pl,l),Ot=!0},p:ls,i(e){Ot||(d(X.$$.fragment,e),d(_.$$.fragment,e),d(k.$$.fragment,e),d(C.$$.fragment,e),d(S.$$.fragment,e),d($.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(me.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(ge.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(Je.$$.fragment,e),d(Ze.$$.fragment,e),d(we.$$.fragment,e),d(We.$$.fragment,e),d(je.$$.fragment,e),d(Ie.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(ke.$$.fragment,e),d(Qe.$$.fragment,e),d(Re.$$.fragment,e),d(Se.$$.fragment,e),d(Ne.$$.fragment,e),d(He.$$.fragment,e),d(qe.$$.fragment,e),d(De.$$.fragment,e),d(Pe.$$.fragment,e),d(Oe.$$.fragment,e),d(el.$$.fragment,e),d(tl.$$.fragment,e),d(sl.$$.fragment,e),d(nl.$$.fragment,e),Ot=!0)},o(e){g(X.$$.fragment,e),g(_.$$.fragment,e),g(k.$$.fragment,e),g(C.$$.fragment,e),g(S.$$.fragment,e),g($.$$.fragment,e),g(Y.$$.fragment,e),g(H.$$.fragment,e),g(E.$$.fragment,e),g(q.$$.fragment,e),g(D.$$.fragment,e),g(A.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(me.$$.fragment,e),g(re.$$.fragment,e),g(ce.$$.fragment,e),g(ge.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g(we.$$.fragment,e),g(We.$$.fragment,e),g(je.$$.fragment,e),g(Ie.$$.fragment,e),g(Be.$$.fragment,e),g(Xe.$$.fragment,e),g(ke.$$.fragment,e),g(Qe.$$.fragment,e),g(Re.$$.fragment,e),g(Se.$$.fragment,e),g(Ne.$$.fragment,e),g(He.$$.fragment,e),g(qe.$$.fragment,e),g(De.$$.fragment,e),g(Pe.$$.fragment,e),g(Oe.$$.fragment,e),g(el.$$.fragment,e),g(tl.$$.fragment,e),g(sl.$$.fragment,e),g(nl.$$.fragment,e),Ot=!1},d(e){e&&(t(ol),t(ml),t(rl),t(cl),t(dl),t(gl),t(F),t(yl),t(Q),t(ul),t(R),t(bl),t(Ml),t(J),t(fl),t(h),t(Jl),t(hl),t(Z),t(Zl),t(wl),t(w),t(Ul),t(Tl),t(N),t(Wl),t(Gl),t(z),t(jl),t(vl),t(U),t(Il),t(Bl),t(L),t(Vl),t(xl),t(T),t(Xl),t(_l),t(P),t(kl),t(K),t(Fl),t(Ql),t(W),t(Rl),t(Cl),t(le),t(Sl),t($l),t(ae),t(Yl),t(se),t(Nl),t(ie),t(Hl),t(zl),t(G),t(El),t(ql),t(pe),t(Ll),t(oe),t(Dl),t(Al),t(j),t(Pl),t(Kl),t(de),t(Ol),t(et),t(v),t(lt),t(tt),t(ue),t(at),t(st),t(Me),t(it),t(fe),t(nt),t(mt),t(he),t(pt),t(ot),t(rt),t(Ue),t(ct),t(Te),t(dt),t(gt),t(I),t(yt),t(Ge),t(ut),t(bt),t(ve),t(Mt),t(ft),t(Jt),t(Ve),t(ht),t(xe),t(Zt),t(wt),t(B),t(Ut),t(_e),t(Tt),t(Wt),t(Fe),t(Gt),t(jt),t(vt),t(Ce),t(It),t(Bt),t($e),t(Vt),t(Ye),t(xt),t(Xt),t(_t),t(ze),t(kt),t(Ee),t(Ft),t(Qt),t(Le),t(Rt),t(Ct),t(Ae),t(St),t($t),t(V),t(Yt),t(Ke),t(Nt),t(Ht),t(x),t(zt),t(Et),t(ll),t(qt),t(Lt),t(al),t(Dt),t(At),t(il),t(Pt),t(Kt),t(pl)),t(f),y(X,e),y(_,e),y(k,e),y(C,e),y(S,e),y($,e),y(Y,e),y(H,e),y(E,e),y(q,e),y(D,e),y(A,e),y(O,e),y(ee,e),y(te,e),y(ne,e),y(me,e),y(re,e),y(ce,e),y(ge,e),y(ye,e),y(be,e),y(Je,e),y(Ze,e),y(we,e),y(We,e),y(je,e),y(Ie,e),y(Be,e),y(Xe,e),y(ke,e),y(Qe,e),y(Re,e),y(Se,e),y(Ne,e),y(He,e),y(qe,e),y(De,e),y(Pe,e),y(Oe,e),y(el,e),y(tl,e),y(sl,e),y(nl,e)}}}const cs='{"title":"Image-to-image","local":"image-to-image","sections":[{"title":"Popular models","local":"popular-models","sections":[{"title":"Stable Diffusion v1.5","local":"stable-diffusion-v15","sections":[],"depth":3},{"title":"Stable Diffusion XL (SDXL)","local":"stable-diffusion-xl-sdxl","sections":[],"depth":3},{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[],"depth":3}],"depth":2},{"title":"Configure pipeline parameters","local":"configure-pipeline-parameters","sections":[{"title":"Strength","local":"strength","sections":[],"depth":3},{"title":"Guidance scale","local":"guidance-scale","sections":[],"depth":3},{"title":"Negative prompt","local":"negative-prompt","sections":[],"depth":3}],"depth":2},{"title":"Chained image-to-image pipelines","local":"chained-image-to-image-pipelines","sections":[{"title":"Text-to-image-to-image","local":"text-to-image-to-image","sections":[],"depth":3},{"title":"Image-to-image-to-image","local":"image-to-image-to-image","sections":[],"depth":3},{"title":"Image-to-upscaler-to-super-resolution","local":"image-to-upscaler-to-super-resolution","sections":[],"depth":3}],"depth":2},{"title":"Control image generation","local":"control-image-generation","sections":[{"title":"Prompt weighting","local":"prompt-weighting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3}],"depth":2},{"title":"Optimize","local":"optimize","sections":[],"depth":2}],"depth":1}';function ds(ea){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends as{constructor(f){super(),ss(this,f,ds,rs,es,{})}}export{Js as component};
