# CosineDPMSolverMultistepScheduler

The [CosineDPMSolverMultistepScheduler](/docs/diffusers/main/en/api/schedulers/cosine_dpm#diffusers.CosineDPMSolverMultistepScheduler) is a variant of [DPMSolverMultistepScheduler](/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler) with cosine schedule, proposed by Nichol and Dhariwal (2021).
It is being used in the [Stable Audio Open](https://huggingface.co/papers/2407.14358) paper and the [Stability-AI/stable-audio-tool](https://github.com/Stability-AI/stable-audio-tools) codebase.

This scheduler was contributed by [Yoach Lacombe](https://huggingface.co/ylacombe).

## CosineDPMSolverMultistepScheduler[[diffusers.CosineDPMSolverMultistepScheduler]]
#### diffusers.CosineDPMSolverMultistepScheduler[[diffusers.CosineDPMSolverMultistepScheduler]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L28)

Implements a variant of `DPMSolverMultistepScheduler` with cosine schedule, proposed by Nichol and Dhariwal (2021).
This scheduler was used in Stable Audio Open [1].

[1] Evans, Parker, et al. "Stable Audio Open" https://huggingface.co/papers/2407.14358

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.

convert_model_outputdiffusers.CosineDPMSolverMultistepScheduler.convert_model_outputhttps://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L297[{"name": "model_output", "val": ": Tensor"}, {"name": "sample", "val": ": Tensor = None"}]- **model_output** (`torch.Tensor`) --
  The direct output from the learned diffusion model.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.0`torch.Tensor`The converted model output.

Convert the model output to the corresponding type the DPMSolver/DPMSolver++ algorithm needs. DPM-Solver is
designed to discretize an integral of the noise prediction model, and DPM-Solver++ is designed to discretize an
integral of the data prediction model.

> [!TIP] > The algorithm and model type are decoupled. You can use either DPMSolver or DPMSolver++ for both
noise > prediction and data prediction models.

**Parameters:**

sigma_min (`float`, *optional*, defaults to 0.3) : Minimum noise magnitude in the sigma schedule. This was set to 0.3 in Stable Audio Open [1].

sigma_max (`float`, *optional*, defaults to 500) : Maximum noise magnitude in the sigma schedule. This was set to 500 in Stable Audio Open [1].

sigma_data (`float`, *optional*, defaults to 1.0) : The standard deviation of the data distribution. This is set to 1.0 in Stable Audio Open [1].

sigma_schedule (`str`, *optional*, defaults to `exponential`) : Sigma schedule to compute the `sigmas`. By default, we the schedule introduced in the EDM paper (https://huggingface.co/papers/2206.00364). Other acceptable value is "exponential". The exponential schedule was incorporated in this model: https://huggingface.co/stabilityai/cosxl.

num_train_timesteps (`int`, defaults to 1000) : The number of diffusion steps to train the model.

solver_order (`int`, defaults to 2) : The DPMSolver order which can be `1` or `2`. It is recommended to use `solver_order=2`.

prediction_type (`str`, defaults to `v_prediction`, *optional*) : Prediction type of the scheduler function; can be `epsilon` (predicts the noise of the diffusion process), `sample` (directly predicts the noisy sample`) or `v_prediction` (see section 2.4 of [Imagen Video](https://imagen.research.google/video/paper.pdf) paper).

solver_type (`str`, defaults to `midpoint`) : Solver type for the second-order solver; can be `midpoint` or `heun`. The solver type slightly affects the sample quality, especially for a small number of steps. It is recommended to use `midpoint` solvers.

lower_order_final (`bool`, defaults to `True`) : Whether to use lower-order solvers in the final steps. Only valid for < 15 inference steps. This can stabilize the sampling of DPMSolver for steps < 15, especially for steps <= 10.

euler_at_final (`bool`, defaults to `False`) : Whether to use Euler's method in the final step. It is a trade-off between numerical stability and detail richness. This can stabilize the sampling of the SDE variant of DPMSolver for small number of inference steps, but sometimes may result in blurring.

final_sigmas_type (`str`, defaults to `"zero"`) : The final `sigma` value for the noise schedule during the sampling process. If `"sigma_min"`, the final sigma is the same as the last sigma in the training schedule. If `zero`, the final sigma is set to 0.

**Returns:**

``torch.Tensor``

The converted model output.
#### dpm_solver_first_order_update[[diffusers.CosineDPMSolverMultistepScheduler.dpm_solver_first_order_update]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L325)

One step for the first-order DPMSolver (equivalent to DDIM).

**Parameters:**

model_output (`torch.Tensor`) : The direct output from the learned diffusion model.

sample (`torch.Tensor`) : A current instance of a sample created by the diffusion process.

**Returns:**

``torch.Tensor``

The sample tensor at the previous timestep.
#### multistep_dpm_solver_second_order_update[[diffusers.CosineDPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L360)

One step for the second-order multistep DPMSolver.

**Parameters:**

model_output_list (`List[torch.Tensor]`) : The direct outputs from learned diffusion model at current and latter timesteps.

sample (`torch.Tensor`) : A current instance of a sample created by the diffusion process.

**Returns:**

``torch.Tensor``

The sample tensor at the previous timestep.
#### scale_model_input[[diffusers.CosineDPMSolverMultistepScheduler.scale_model_input]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L174)

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep. Scales the denoising model input by `(sigma**2 + 1) ** 0.5` to match the Euler algorithm.

**Parameters:**

sample (`torch.Tensor`) : The input sample.

timestep (`int`, *optional*) : The current timestep in the diffusion chain.

**Returns:**

``torch.Tensor``

A scaled input sample.
#### set_begin_index[[diffusers.CosineDPMSolverMultistepScheduler.set_begin_index]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L135)

Sets the begin index for the scheduler. This function should be run from pipeline before the inference.

**Parameters:**

begin_index (`int`) : The begin index for the scheduler.
#### set_timesteps[[diffusers.CosineDPMSolverMultistepScheduler.set_timesteps]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L198)

Sets the discrete timesteps used for the diffusion chain (to be run before inference).

**Parameters:**

num_inference_steps (`int`) : The number of diffusion steps used when generating samples with a pre-trained model.

device (`str` or `torch.device`, *optional*) : The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.
#### step[[diffusers.CosineDPMSolverMultistepScheduler.step]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L451)

Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep DPMSolver.

**Parameters:**

model_output (`torch.Tensor`) : The direct output from learned diffusion model.

timestep (`int`) : The current discrete timestep in the diffusion chain.

sample (`torch.Tensor`) : A current instance of a sample created by the diffusion process.

generator (`torch.Generator`, *optional*) : A random number generator.

return_dict (`bool`) : Whether or not to return a [SchedulerOutput](/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput) or `tuple`.

**Returns:**

`[SchedulerOutput](/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput) or `tuple``

If return_dict is `True`, [SchedulerOutput](/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput) is returned, otherwise a
tuple is returned where the first element is the sample tensor.

## SchedulerOutput[[diffusers.schedulers.scheduling_utils.SchedulerOutput]]
#### diffusers.schedulers.scheduling_utils.SchedulerOutput[[diffusers.schedulers.scheduling_utils.SchedulerOutput]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L62)

Base class for the output of a scheduler's `step` function.

**Parameters:**

prev_sample (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) : Computed sample `(x_{t-1})` of previous timestep. `prev_sample` should be used as next model input in the denoising loop.

