import{s as Dt,n as Et,o as Ot}from"../chunks/scheduler.23542ac5.js";import{S as Kt,i as el,e as p,s as i,c as f,h as tl,a,d as l,b as n,f as zt,g as m,j as o,k as bt,l as ll,m as s,n as r,t as u,o as M,p as d}from"../chunks/index.9b1f405b.js";import{C as sl,H as c,E as il}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.cf8449cd.js";import{C as y}from"../chunks/CodeBlock.6a4e8f39.js";function nl(yt){let h,be,ce,ye,U,Ue,C,Ce,w,Ut='<a href="https://developer.apple.com/documentation/coreml" rel="nofollow">Core ML</a>은 Apple 프레임워크에서 지원하는 모델 형식 및 머신 러닝 라이브러리입니다. macOS 또는 iOS/iPadOS 앱 내에서 Stable Diffusion 모델을 실행하는 데 관심이 있는 경우, 이 가이드에서는 기존 PyTorch 체크포인트를 Core ML 형식으로 변환하고 이를 Python 또는 Swift로 추론에 사용하는 방법을 설명합니다.',we,$,Ct="Core ML 모델은 Apple 기기에서 사용할 수 있는 모든 컴퓨팅 엔진들, 즉 CPU, GPU, Apple Neural Engine(또는 Apple Silicon Mac 및 최신 iPhone/iPad에서 사용할 수 있는 텐서 최적화 가속기인 ANE)을 활용할 수 있습니다. 모델과 실행 중인 기기에 따라 Core ML은 컴퓨팅 엔진도 혼합하여 사용할 수 있으므로, 예를 들어 모델의 일부가 CPU에서 실행되는 반면 다른 부분은 GPU에서 실행될 수 있습니다.",$e,b,wt="<p>PyTorch에 내장된 <code>mps</code> 가속기를 사용하여 Apple Silicon Macs에서 <code>diffusers</code> Python 코드베이스를 실행할 수도 있습니다. 이 방법은 [mps 가이드]에 자세히 설명되어 있지만 네이티브 앱과 호환되지 않습니다.</p>",Te,T,ge,g,$t="Stable Diffusion 가중치(또는 체크포인트)는 PyTorch 형식으로 저장되기 때문에 네이티브 앱에서 사용하기 위해서는 Core ML 형식으로 변환해야 합니다.",ve,v,Tt='다행히도 Apple 엔지니어들이 <code>diffusers</code>를 기반으로 한 <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">변환 툴</a>을 개발하여 PyTorch 체크포인트를 Core ML로 변환할 수 있습니다.',Je,J,gt="모델을 변환하기 전에 잠시 시간을 내어 Hugging Face Hub를 살펴보세요. 관심 있는 모델이 이미 Core ML 형식으로 제공되고 있을 가능성이 높습니다:",je,j,vt='<li><a href="https://huggingface.co/apple" rel="nofollow">Apple</a> organization에는 Stable Diffusion 버전 1.4, 1.5, 2.0 base 및 2.1 base가 포함되어 있습니다.</li> <li><a href="https://huggingface.co/coreml" rel="nofollow">coreml</a> organization에는 커스텀 DreamBooth가 적용되거나, 파인튜닝된 모델이 포함되어 있습니다.</li> <li>이 <a href="https://huggingface.co/models?pipeline_tag=text-to-image&amp;library=coreml&amp;p=2&amp;sort=likes" rel="nofollow">필터</a>를 사용하여 사용 가능한 모든 Core ML 체크포인트들을 반환합니다.</li>',Ge,G,Jt='원하는 모델을 찾을 수 없는 경우 Apple의 <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">모델을 Core ML로 변환하기</a> 지침을 따르는 것이 좋습니다.',Le,L,_e,_,jt="Stable Diffusion 모델은 다양한 목적에 따라 다른 Core ML 변형으로 변환할 수 있습니다:",ke,k,Gt='<li><p>사용되는 어텐션 블록 유형. 어텐션 연산은 이미지 표현의 여러 영역 간의 관계에 ‘주의를 기울이고’ 이미지와 텍스트 표현이 어떻게 연관되어 있는지 이해하는 데 사용됩니다. 어텐션 연산은 컴퓨팅 및 메모리 집약적이므로 다양한 장치의 하드웨어 특성을 고려한 다양한 구현이 존재합니다. Core ML Stable Diffusion 모델의 경우 두 가지 주의 변형이 있습니다:</p> <ul><li><code>split_einsum</code> (<a href="https://machinelearning.apple.com/research/neural-engine-transformers" rel="nofollow">Apple에서 도입</a>은 최신 iPhone, iPad 및 M 시리즈 컴퓨터에서 사용할 수 있는 ANE 장치에 최적화되어 있습니다.</li> <li>“원본” 어텐션(<code>diffusers</code>에 사용되는 기본 구현)는 CPU/GPU와만 호환되며 ANE와는 호환되지 않습니다. “원본” 어텐션을 사용하여 CPU + GPU에서 모델을 실행하는 것이 ANE보다 <em>더</em> 빠를 수 있습니다. 자세한 내용은 <a href="https://huggingface.co/blog/fast-mac-diffusers#performance-benchmarks" rel="nofollow">이 성능 벤치마크</a>와 커뮤니티에서 제공하는 일부 <a href="https://github.com/huggingface/swift-coreml-diffusers/issues/31" rel="nofollow">추가 측정</a>을 참조하십시오.</li></ul></li> <li><p>지원되는 추론 프레임워크</p> <ul><li><code>packages</code>는 Python 추론에 적합합니다. 네이티브 앱에 통합하기 전에 변환된 Core ML 모델을 테스트하거나, Core ML 성능을 알고 싶지만 네이티브 앱을 지원할 필요는 없는 경우에 사용할 수 있습니다. 예를 들어, 웹 UI가 있는 애플리케이션은 Python Core ML 백엔드를 완벽하게 사용할 수 있습니다.</li> <li>Swift 코드에는 <code>컴파일된</code> 모델이 필요합니다. Hub의 <code>컴파일된</code> 모델은 iOS 및 iPadOS 기기와의 호환성을 위해 큰 UNet 모델 가중치를 여러 파일로 분할합니다. 이는 <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow"><code>--chunk-unet</code> 변환 옵션</a>에 해당합니다. 네이티브 앱을 지원하려면 <code>컴파일된</code> 변형을 선택해야 합니다.</li></ul></li>',Ze,Z,Lt='공식 Core ML Stable Diffusion <a href="https://huggingface.co/apple/coreml-stable-diffusion-v1-4/tree/main" rel="nofollow">모델</a>에는 이러한 변형이 포함되어 있지만 커뮤니티 버전은 다를 수 있습니다:',xe,x,Be,B,_t="아래와 같이 필요한 변형을 다운로드하여 사용할 수 있습니다.",Xe,X,Ne,N,kt="Python에서 Core ML 추론을 실행하려면 다음 라이브러리를 설치하세요:",We,W,Pe,P,Se,S,Zt="<code>컴파일된</code> 버전은 Swift와만 호환되므로 Python에서 추론을 실행하려면 <code>packages</code> 폴더에 저장된 버전 중 하나를 사용하세요. <code>원본</code> 또는 <code>split_einsum</code> 어텐션 중 어느 것을 사용할지 선택할 수 있습니다.",Re,R,xt="다음은 Hub에서 ‘models’라는 디렉토리로 ‘original’ 어텐션 변형을 다운로드하는 방법입니다:",He,H,Ye,Y,Ie,I,Bt="모델의 snapshot을 다운로드한 후에는 Apple의 Python 스크립트를 사용하여 테스트할 수 있습니다.",Fe,F,Ae,A,Xt="<code>&lt;output-mlpackages-directory&gt;</code>는 위 단계에서 다운로드한 체크포인트를 가리켜야 하며, <code>--compute-unit</code>은 추론을 허용할 하드웨어를 나타냅니다. 이는 다음 옵션 중 하나이어야 합니다: <code>ALL</code>, <code>CPU_AND_GPU</code>, <code>CPU_ONLY</code>, <code>CPU_AND_NE</code>. 선택적 출력 경로와 재현성을 위한 시드를 제공할 수도 있습니다.",Ve,V,Nt="추론 스크립트에서는 Stable Diffusion 모델의 원래 버전인 <code>CompVis/stable-diffusion-v1-4</code>를 사용한다고 가정합니다. 다른 모델을 사용하는 경우 추론 명령줄에서 <code>--model-version</code> 옵션을 사용하여 해당 허브 ID를 <em>지정</em>해야 합니다. 이는 이미 지원되는 모델과 사용자가 직접 학습하거나 파인튜닝한 사용자 지정 모델에 적용됩니다.",qe,q,Wt='예를 들어, <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>를 사용하려는 경우입니다:',Qe,Q,ze,z,De,D,Pt="Swift에서 추론을 실행하는 것은 모델이 이미 <code>mlmodelc</code> 형식으로 컴파일되어 있기 때문에 Python보다 약간 빠릅니다. 이는 앱이 시작될 때 모델이 불러와지는 것이 눈에 띄지만, 이후 여러 번 실행하면 눈에 띄지 않을 것입니다.",Ee,E,Oe,O,St="Mac에서 Swift에서 추론을 실행하려면 <code>컴파일된</code> 체크포인트 버전 중 하나가 필요합니다. 이전 예제와 유사하지만 <code>컴파일된</code> 변형 중 하나를 사용하여 Python 코드를 로컬로 다운로드하는 것이 좋습니다:",Ke,K,et,ee,tt,te,Rt="추론을 실행하기 위해서, Apple의 리포지토리를 복제하세요:",lt,le,st,se,Ht='그 다음 Apple의 명령어 도구인 <a href="https://www.swift.org/package-manager/#" rel="nofollow">Swift 패키지 관리자</a>를 사용합니다:',it,ie,nt,ne,Yt="<code>--resource-path</code>에 이전 단계에서 다운로드한 체크포인트 중 하나를 지정해야 하므로 확장자가 <code>.mlmodelc</code>인 컴파일된 Core ML 번들이 포함되어 있는지 확인하시기 바랍니다. <code>--compute-units</code>는 다음 값 중 하나이어야 합니다: <code>all</code>, <code>cpuOnly</code>, <code>cpuAndGPU</code>, <code>cpuAndNeuralEngine</code>.",pt,pe,It='자세한 내용은 <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">Apple의 리포지토리 안의 지침</a>을 참고하시기 바랍니다.',at,ae,ot,oe,Ft="Core ML 모델과 추론 코드는 🧨 Diffusers의 많은 기능, 옵션 및 유연성을 지원하지 않습니다. 다음은 유의해야 할 몇 가지 제한 사항입니다:",ft,fe,At="<li>Core ML 모델은 추론에만 적합합니다. 학습이나 파인튜닝에는 사용할 수 없습니다.</li> <li>Swift에 포팅된 스케줄러는 Stable Diffusion에서 사용하는 기본 스케줄러와 <code>diffusers</code> 구현에서 Swift로 포팅한 <code>DPMSolverMultistepScheduler</code> 두 개뿐입니다. 이들 중 약 절반의 스텝으로 동일한 품질을 생성하는 <code>DPMSolverMultistepScheduler</code>를 사용하는 것이 좋습니다.</li> <li>추론 코드에서 네거티브 프롬프트, classifier-free guidance scale 및 image-to-image 작업을 사용할 수 있습니다. depth guidance, ControlNet, latent upscalers와 같은 고급 기능은 아직 사용할 수 없습니다.</li>",mt,me,Vt='Apple의 <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">변환 및 추론 리포지토리</a>와 자체 <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">swift-coreml-diffusers</a> 리포지토리는 다른 개발자들이 구축할 수 있는 기술적인 데모입니다.',rt,re,qt="누락된 기능이 있다고 생각되면 언제든지 기능을 요청하거나, 더 좋은 방법은 기여 PR을 열어주세요. :)",ut,ue,Mt,Me,Qt='자체 Apple 하드웨어에서 Stable Diffusion을 실행하는 쉬운 방법 중 하나는 <code>diffusers</code>와 Apple의 변환 및 추론 리포지토리를 기반으로 하는 <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">자체 오픈 소스 Swift 리포지토리</a>를 사용하는 것입니다. 코드를 공부하고 <a href="https://developer.apple.com/xcode/" rel="nofollow">Xcode</a>로 컴파일하여 필요에 맞게 조정할 수 있습니다. 편의를 위해 앱스토어에 <a href="https://apps.apple.com/app/diffusers/id1666309574" rel="nofollow">독립형 Mac 앱</a>도 있으므로 코드나 IDE를 다루지 않고도 사용할 수 있습니다. 개발자로서 Core ML이 Stable Diffusion 앱을 구축하는 데 가장 적합한 솔루션이라고 판단했다면, 이 가이드의 나머지 부분을 사용하여 프로젝트를 시작할 수 있습니다. 여러분이 무엇을 빌드할지 기대됩니다. :)',dt,de,ct,he,ht;return U=new sl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new c({props:{title:"Core ML로 Stable Diffusion을 실행하는 방법",local:"core-ml로-stable-diffusion을-실행하는-방법",headingTag:"h1"}}),T=new c({props:{title:"Stable Diffusion Core ML 체크포인트",local:"stable-diffusion-core-ml-체크포인트",headingTag:"h2"}}),L=new c({props:{title:"사용할 Core ML 변형(Variant) 선택하기",local:"사용할-core-ml-변형variant-선택하기",headingTag:"h2"}}),x=new y({props:{code:"Y29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFJFQURNRS5tZCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMG9yaWdpbmFsJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29tcGlsZWQlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBwYWNrYWdlcyUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHNwbGl0X2VpbnN1bSUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbXBpbGVkJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcGFja2FnZXM=",highlighted:`coreml-stable-<span class="hljs-keyword">diffusion-v1-4
</span>├── README.md
├── <span class="hljs-keyword">original
</span>│   ├── compiled
│   └── packages
└── split_einsum
    ├── compiled
    └── packages`,wrap:!1}}),X=new c({props:{title:"Python에서 Core ML 추론",local:"python에서-core-ml-추론",headingTag:"h2"}}),W=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`pip install huggingface_hub
pip install git+https://github.com/apple/ml-stable-diffusion`,wrap:!1}}),P=new c({props:{title:"모델 체크포인트 다운로드하기",local:"모델-체크포인트-다운로드하기",headingTag:"h3"}}),H=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRnBhY2thZ2VzJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/packages&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`,wrap:!1}}),Y=new c({props:{title:"추론",local:"python-inference",headingTag:"h3"}}),F=new y({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTRfb3JpZ2luYWxfcGFja2FnZXMlMjAtbyUyMCUzQyUyRnBhdGglMkZ0byUyRm91dHB1dCUyRmltYWdlJTNFJTIwLS1jb21wdXRlLXVuaXQlMjBDUFVfQU5EX0dQVSUyMC0tc2VlZCUyMDkz",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; -i models/coreml-stable-diffusion-v1-4_original_packages -o &lt;/path/to/output/image&gt; --compute-unit CPU_AND_GPU --seed 93",wrap:!1}}),Q=new y({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtLWNvbXB1dGUtdW5pdCUyMEFMTCUyMC1vJTIwb3V0cHV0JTIwLS1zZWVkJTIwOTMlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTVfb3JpZ2luYWxfcGFja2FnZXMlMjAtLW1vZGVsLXZlcnNpb24lMjBzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTU=",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; --compute-unit ALL -o output --seed 93 -i models/coreml-stable-diffusion-v1-5_original_packages --model-version stable-diffusion-v1-5/stable-diffusion-v1-5",wrap:!1}}),z=new c({props:{title:"Swift에서 Core ML 추론하기",local:"swift에서-core-ml-추론하기",headingTag:"h2"}}),E=new c({props:{title:"다운로드",local:"다운로드",headingTag:"h3"}}),K=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRmNvbXBpbGVkJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/compiled&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`,wrap:!1}}),ee=new c({props:{title:"추론",local:"swift-inference",headingTag:"h3"}}),le=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24lMEFjZCUyMG1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/apple/ml-stable-diffusion
<span class="hljs-built_in">cd</span> ml-stable-diffusion`,wrap:!1}}),ie=new y({props:{code:"c3dpZnQlMjBydW4lMjBTdGFibGVEaWZmdXNpb25TYW1wbGUlMjAtLXJlc291cmNlLXBhdGglMjBtb2RlbHMlMkZjb3JlbWwtc3RhYmxlLWRpZmZ1c2lvbi12MS00X29yaWdpbmFsX2NvbXBpbGVkJTIwLS1jb21wdXRlLXVuaXRzJTIwYWxsJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMg==",highlighted:'swift run StableDiffusionSample --resource-path models/coreml-stable-diffusion-v1-4_original_compiled --compute-units all <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>',wrap:!1}}),ae=new c({props:{title:"지원되는 Diffusers 기능",local:"지원되는-diffusers-기능",headingTag:"h2"}}),ue=new c({props:{title:"네이티브 Diffusers Swift 앱",local:"네이티브-diffusers-swift-앱",headingTag:"h2"}}),de=new il({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ko/optimization/coreml.md"}}),{c(){h=p("meta"),be=i(),ce=p("p"),ye=i(),f(U.$$.fragment),Ue=i(),f(C.$$.fragment),Ce=i(),w=p("p"),w.innerHTML=Ut,we=i(),$=p("p"),$.textContent=Ct,$e=i(),b=p("blockquote"),b.innerHTML=wt,Te=i(),f(T.$$.fragment),ge=i(),g=p("p"),g.textContent=$t,ve=i(),v=p("p"),v.innerHTML=Tt,Je=i(),J=p("p"),J.textContent=gt,je=i(),j=p("ul"),j.innerHTML=vt,Ge=i(),G=p("p"),G.innerHTML=Jt,Le=i(),f(L.$$.fragment),_e=i(),_=p("p"),_.textContent=jt,ke=i(),k=p("ul"),k.innerHTML=Gt,Ze=i(),Z=p("p"),Z.innerHTML=Lt,xe=i(),f(x.$$.fragment),Be=i(),B=p("p"),B.textContent=_t,Xe=i(),f(X.$$.fragment),Ne=i(),N=p("p"),N.textContent=kt,We=i(),f(W.$$.fragment),Pe=i(),f(P.$$.fragment),Se=i(),S=p("p"),S.innerHTML=Zt,Re=i(),R=p("p"),R.textContent=xt,He=i(),f(H.$$.fragment),Ye=i(),f(Y.$$.fragment),Ie=i(),I=p("p"),I.textContent=Bt,Fe=i(),f(F.$$.fragment),Ae=i(),A=p("p"),A.innerHTML=Xt,Ve=i(),V=p("p"),V.innerHTML=Nt,qe=i(),q=p("p"),q.innerHTML=Wt,Qe=i(),f(Q.$$.fragment),ze=i(),f(z.$$.fragment),De=i(),D=p("p"),D.innerHTML=Pt,Ee=i(),f(E.$$.fragment),Oe=i(),O=p("p"),O.innerHTML=St,Ke=i(),f(K.$$.fragment),et=i(),f(ee.$$.fragment),tt=i(),te=p("p"),te.textContent=Rt,lt=i(),f(le.$$.fragment),st=i(),se=p("p"),se.innerHTML=Ht,it=i(),f(ie.$$.fragment),nt=i(),ne=p("p"),ne.innerHTML=Yt,pt=i(),pe=p("p"),pe.innerHTML=It,at=i(),f(ae.$$.fragment),ot=i(),oe=p("p"),oe.textContent=Ft,ft=i(),fe=p("ul"),fe.innerHTML=At,mt=i(),me=p("p"),me.innerHTML=Vt,rt=i(),re=p("p"),re.textContent=qt,ut=i(),f(ue.$$.fragment),Mt=i(),Me=p("p"),Me.innerHTML=Qt,dt=i(),f(de.$$.fragment),ct=i(),he=p("p"),this.h()},l(e){const t=tl("svelte-u9bgzb",document.head);h=a(t,"META",{name:!0,content:!0}),t.forEach(l),be=n(e),ce=a(e,"P",{}),zt(ce).forEach(l),ye=n(e),m(U.$$.fragment,e),Ue=n(e),m(C.$$.fragment,e),Ce=n(e),w=a(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-bbaeul"&&(w.innerHTML=Ut),we=n(e),$=a(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-25bb3r"&&($.textContent=Ct),$e=n(e),b=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-11chmz2"&&(b.innerHTML=wt),Te=n(e),m(T.$$.fragment,e),ge=n(e),g=a(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1n0wpaz"&&(g.textContent=$t),ve=n(e),v=a(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-11ljk8w"&&(v.innerHTML=Tt),Je=n(e),J=a(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1635zp"&&(J.textContent=gt),je=n(e),j=a(e,"UL",{"data-svelte-h":!0}),o(j)!=="svelte-q784xv"&&(j.innerHTML=vt),Ge=n(e),G=a(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-b7xjel"&&(G.innerHTML=Jt),Le=n(e),m(L.$$.fragment,e),_e=n(e),_=a(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1t091it"&&(_.textContent=jt),ke=n(e),k=a(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1rrqib3"&&(k.innerHTML=Gt),Ze=n(e),Z=a(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1itv6a4"&&(Z.innerHTML=Lt),xe=n(e),m(x.$$.fragment,e),Be=n(e),B=a(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1pm7gvi"&&(B.textContent=_t),Xe=n(e),m(X.$$.fragment,e),Ne=n(e),N=a(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-106wisv"&&(N.textContent=kt),We=n(e),m(W.$$.fragment,e),Pe=n(e),m(P.$$.fragment,e),Se=n(e),S=a(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-18035od"&&(S.innerHTML=Zt),Re=n(e),R=a(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1li68th"&&(R.textContent=xt),He=n(e),m(H.$$.fragment,e),Ye=n(e),m(Y.$$.fragment,e),Ie=n(e),I=a(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-18ld88r"&&(I.textContent=Bt),Fe=n(e),m(F.$$.fragment,e),Ae=n(e),A=a(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-mpzt9a"&&(A.innerHTML=Xt),Ve=n(e),V=a(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-lf923q"&&(V.innerHTML=Nt),qe=n(e),q=a(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1rdfmyj"&&(q.innerHTML=Wt),Qe=n(e),m(Q.$$.fragment,e),ze=n(e),m(z.$$.fragment,e),De=n(e),D=a(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-ker45t"&&(D.innerHTML=Pt),Ee=n(e),m(E.$$.fragment,e),Oe=n(e),O=a(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-3a5qkr"&&(O.innerHTML=St),Ke=n(e),m(K.$$.fragment,e),et=n(e),m(ee.$$.fragment,e),tt=n(e),te=a(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-2e0s68"&&(te.textContent=Rt),lt=n(e),m(le.$$.fragment,e),st=n(e),se=a(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1hqru1i"&&(se.innerHTML=Ht),it=n(e),m(ie.$$.fragment,e),nt=n(e),ne=a(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1rrvko7"&&(ne.innerHTML=Yt),pt=n(e),pe=a(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-2n9wsh"&&(pe.innerHTML=It),at=n(e),m(ae.$$.fragment,e),ot=n(e),oe=a(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1svsy93"&&(oe.textContent=Ft),ft=n(e),fe=a(e,"UL",{"data-svelte-h":!0}),o(fe)!=="svelte-upf8t6"&&(fe.innerHTML=At),mt=n(e),me=a(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-vgqart"&&(me.innerHTML=Vt),rt=n(e),re=a(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-e71cas"&&(re.textContent=qt),ut=n(e),m(ue.$$.fragment,e),Mt=n(e),Me=a(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1e0lp79"&&(Me.innerHTML=Qt),dt=n(e),m(de.$$.fragment,e),ct=n(e),he=a(e,"P",{}),zt(he).forEach(l),this.h()},h(){bt(h,"name","hf:doc:metadata"),bt(h,"content",pl),bt(b,"class","tip")},m(e,t){ll(document.head,h),s(e,be,t),s(e,ce,t),s(e,ye,t),r(U,e,t),s(e,Ue,t),r(C,e,t),s(e,Ce,t),s(e,w,t),s(e,we,t),s(e,$,t),s(e,$e,t),s(e,b,t),s(e,Te,t),r(T,e,t),s(e,ge,t),s(e,g,t),s(e,ve,t),s(e,v,t),s(e,Je,t),s(e,J,t),s(e,je,t),s(e,j,t),s(e,Ge,t),s(e,G,t),s(e,Le,t),r(L,e,t),s(e,_e,t),s(e,_,t),s(e,ke,t),s(e,k,t),s(e,Ze,t),s(e,Z,t),s(e,xe,t),r(x,e,t),s(e,Be,t),s(e,B,t),s(e,Xe,t),r(X,e,t),s(e,Ne,t),s(e,N,t),s(e,We,t),r(W,e,t),s(e,Pe,t),r(P,e,t),s(e,Se,t),s(e,S,t),s(e,Re,t),s(e,R,t),s(e,He,t),r(H,e,t),s(e,Ye,t),r(Y,e,t),s(e,Ie,t),s(e,I,t),s(e,Fe,t),r(F,e,t),s(e,Ae,t),s(e,A,t),s(e,Ve,t),s(e,V,t),s(e,qe,t),s(e,q,t),s(e,Qe,t),r(Q,e,t),s(e,ze,t),r(z,e,t),s(e,De,t),s(e,D,t),s(e,Ee,t),r(E,e,t),s(e,Oe,t),s(e,O,t),s(e,Ke,t),r(K,e,t),s(e,et,t),r(ee,e,t),s(e,tt,t),s(e,te,t),s(e,lt,t),r(le,e,t),s(e,st,t),s(e,se,t),s(e,it,t),r(ie,e,t),s(e,nt,t),s(e,ne,t),s(e,pt,t),s(e,pe,t),s(e,at,t),r(ae,e,t),s(e,ot,t),s(e,oe,t),s(e,ft,t),s(e,fe,t),s(e,mt,t),s(e,me,t),s(e,rt,t),s(e,re,t),s(e,ut,t),r(ue,e,t),s(e,Mt,t),s(e,Me,t),s(e,dt,t),r(de,e,t),s(e,ct,t),s(e,he,t),ht=!0},p:Et,i(e){ht||(u(U.$$.fragment,e),u(C.$$.fragment,e),u(T.$$.fragment,e),u(L.$$.fragment,e),u(x.$$.fragment,e),u(X.$$.fragment,e),u(W.$$.fragment,e),u(P.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(Q.$$.fragment,e),u(z.$$.fragment,e),u(E.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(ae.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),ht=!0)},o(e){M(U.$$.fragment,e),M(C.$$.fragment,e),M(T.$$.fragment,e),M(L.$$.fragment,e),M(x.$$.fragment,e),M(X.$$.fragment,e),M(W.$$.fragment,e),M(P.$$.fragment,e),M(H.$$.fragment,e),M(Y.$$.fragment,e),M(F.$$.fragment,e),M(Q.$$.fragment,e),M(z.$$.fragment,e),M(E.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(ae.$$.fragment,e),M(ue.$$.fragment,e),M(de.$$.fragment,e),ht=!1},d(e){e&&(l(be),l(ce),l(ye),l(Ue),l(Ce),l(w),l(we),l($),l($e),l(b),l(Te),l(ge),l(g),l(ve),l(v),l(Je),l(J),l(je),l(j),l(Ge),l(G),l(Le),l(_e),l(_),l(ke),l(k),l(Ze),l(Z),l(xe),l(Be),l(B),l(Xe),l(Ne),l(N),l(We),l(Pe),l(Se),l(S),l(Re),l(R),l(He),l(Ye),l(Ie),l(I),l(Fe),l(Ae),l(A),l(Ve),l(V),l(qe),l(q),l(Qe),l(ze),l(De),l(D),l(Ee),l(Oe),l(O),l(Ke),l(et),l(tt),l(te),l(lt),l(st),l(se),l(it),l(nt),l(ne),l(pt),l(pe),l(at),l(ot),l(oe),l(ft),l(fe),l(mt),l(me),l(rt),l(re),l(ut),l(Mt),l(Me),l(dt),l(ct),l(he)),l(h),d(U,e),d(C,e),d(T,e),d(L,e),d(x,e),d(X,e),d(W,e),d(P,e),d(H,e),d(Y,e),d(F,e),d(Q,e),d(z,e),d(E,e),d(K,e),d(ee,e),d(le,e),d(ie,e),d(ae,e),d(ue,e),d(de,e)}}}const pl='{"title":"Core ML로 Stable Diffusion을 실행하는 방법","local":"core-ml로-stable-diffusion을-실행하는-방법","sections":[{"title":"Stable Diffusion Core ML 체크포인트","local":"stable-diffusion-core-ml-체크포인트","sections":[],"depth":2},{"title":"사용할 Core ML 변형(Variant) 선택하기","local":"사용할-core-ml-변형variant-선택하기","sections":[],"depth":2},{"title":"Python에서 Core ML 추론","local":"python에서-core-ml-추론","sections":[{"title":"모델 체크포인트 다운로드하기","local":"모델-체크포인트-다운로드하기","sections":[],"depth":3},{"title":"추론","local":"python-inference","sections":[],"depth":3}],"depth":2},{"title":"Swift에서 Core ML 추론하기","local":"swift에서-core-ml-추론하기","sections":[{"title":"다운로드","local":"다운로드","sections":[],"depth":3},{"title":"추론","local":"swift-inference","sections":[],"depth":3}],"depth":2},{"title":"지원되는 Diffusers 기능","local":"지원되는-diffusers-기능","sections":[],"depth":2},{"title":"네이티브 Diffusers Swift 앱","local":"네이티브-diffusers-swift-앱","sections":[],"depth":2}],"depth":1}';function al(yt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends Kt{constructor(h){super(),el(this,h,al,nl,Dt,{})}}export{ul as component};
