import{s as Ae,n as Ye,o as He}from"../chunks/scheduler.8a2cc2fa.js";import{S as Ee,i as Qe,e as n,s as a,c as r,h as Fe,a as m,d as l,b as i,f as Be,g as o,j as p,k as X,l as Se,m as s,n as d,t as b,o as M,p as c}from"../chunks/index.7079e750.js";import{C as Xe,H as Je,E as Re}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.1373604b.js";import{C as Q}from"../chunks/CodeBlock.a49b289a.js";function Ve(je){let u,R,F,V,f,N,T,P,J,$e="With 8-bit optimizers, large models can be finetuned with 75% less GPU memory without losing any accuracy compared to training with standard 32-bit optimizers. The reduced memory requirements means 8-bit optimizers are 4x faster than a standard optimizer, and no hyperparameter tuning is required.",K,j,ge="This guide will show you how to use 8-bit optimizers.",O,y,Ue="<p>8-bit optimizers reduce memory usage and accelerate optimization on a wide range of tasks. However, since 8-bit optimizers only reduce memory proportional to the number of parameters, models that use large amounts of activation memory, such as convolutional networks, don’t really benefit from 8-bit optimizers. 8-bit optimizers are most beneficial for training or finetuning models with many parameters on highly memory-constrained GPUs.</p>",q,$,Ge='8-bit optimizers are a drop-in replacement for regular optimizers which means they also accept the same arguments as a regular optimizer. For NLP models, it is recommended to use the <a href="/docs/bitsandbytes/main/en/reference/nn/embeddings#bitsandbytes.nn.StableEmbedding">StableEmbedding</a> class to improve stability and results.',D,g,ee,U,ve="By default, all parameter tensors with less than 4096 elements are kept at 32-bits even if you initialize those parameters with 8-bit optimizers. This is done because small tensors do not save much memory and often contain highly variable parameters (biases) or parameters that require high precision (batch norm, layer norm).",te,G,xe="You can change this value with the <code>min_8bit_size</code> parameter. For example, if you want to optimize parameters to 8-bits only if the minimum size is 16384 values (it is recommended to use multiples of 4096):",le,v,se,x,Ze='Other parameters you can configure include the learning rate (<code>lr</code>), the decay rates (<code>betas</code>), the number of bits of the optimizer state (<code>optim_bits</code>), and percentile clipping (<code>percentile_clipping</code>) which can increase stability. For example, to initialize a 32-bit <a href="/docs/bitsandbytes/main/en/reference/optim/adam#bitsandbytes.optim.Adam">Adam</a> optimizer with 5th percentile clipping:',ae,Z,ie,k,ne,z,ke='To optimize some unstable parameters with 32-bit Adam and others with 8-bit Adam, use the <a href="/docs/bitsandbytes/main/en/reference/optim/optim_overview#bitsandbytes.optim.GlobalOptimManager">GlobalOptimManager</a> class to override the specific hyperparameters for a particular layer. You’ll need to:',me,_,ze="<li>Register the parameters while they’re on the CPU.</li>",pe,W,re,h,_e="<li>Override the config with the new desired hyperparameters. For example, let’s override the <code>model.fc1.weight</code> layer to use 32-bit Adam.</li>",oe,w,We="<p>Check the optimizer API documentation for more information about other hyperparameters you can override.</p>",de,C,be,L,Ce="You can also override multiple layers at once by passing them as a list and the new hyperparameters as a dictionary. For example, let’s override the <code>model.special.weight</code> and <code>model.also_special.weight</code> layers to use sparse optimization and a lower learning and decay rate.",Me,I,ce,B,Le='For a specific layer, we recommend overriding locally in each module. Pass the module, the parameter, and its attribute name to the <a href="/docs/bitsandbytes/main/en/reference/optim/optim_overview#bitsandbytes.optim.GlobalOptimManager">GlobalOptimManager</a>:',ue,A,ye,Y,he,H,Ie='For more conceptual details and explanation about 8-bit optimizers, take a look at the <a href="./explanations/optimizers">8-bit optimizers</a> guide.',we,E,fe,S,Te;return f=new Xe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new Je({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h1"}}),g=new Q({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEEtJTIwYWRhbSUyMCUzRCUyMHRvcmNoLm9wdGltLkFkYW0oLi4uKSUwQSUyQiUyMGFkYW0lMjAlM0QlMjBibmIub3B0aW0uQWRhbThiaXQoLi4uKSUwQSUwQSUyMyUyMHJlY29tbWVuZGVkJTIwZm9yJTIwTkxQJTIwbW9kZWxzJTBBLSUyMGJlZm9yZSUzQSUyMHRvcmNoLm5uLkVtYmVkZGluZyguLi4pJTBBJTJCJTIwYm5iLm5uLlN0YWJsZUVtYmVkZGluZyguLi4p",highlighted:`import bitsandbytes as bnb

<span class="hljs-deletion">- adam = torch.optim.Adam(...)</span>
<span class="hljs-addition">+ adam = bnb.optim.Adam8bit(...)</span>

# recommended for NLP models
<span class="hljs-deletion">- before: torch.nn.Embedding(...)</span>
<span class="hljs-addition">+ bnb.nn.StableEmbedding(...)</span>`,wrap:!1}}),v=new Q({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW04Yml0KG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMG1pbl84Yml0X3NpemUlM0QxNjM4NCk=",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

adam = bnb.optim.Adam8bit(model.parameters(), min_8bit_size=<span class="hljs-number">16384</span>)`,wrap:!1}}),Z=new Q({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW0obW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QwLjAwMSUyQyUyMGJldGFzJTNEKDAuOSUyQyUyMDAuOTk1KSUyQyUyMG9wdGltX2JpdHMlM0QzMiUyQyUyMHBlcmNlbnRpbGVfY2xpcHBpbmclM0Q1KQ==",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

adam = bnb.optim.Adam(model.parameters(), lr=<span class="hljs-number">0.001</span>, betas=(<span class="hljs-number">0.9</span>, <span class="hljs-number">0.995</span>), optim_bits=<span class="hljs-number">32</span>, percentile_clipping=<span class="hljs-number">5</span>)`,wrap:!1}}),k=new Je({props:{title:"Optimize unstable parameters",local:"optimize-unstable-parameters",headingTag:"h2"}}),W=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBiaXRzYW5kYnl0ZXMlMjBhcyUyMGJuYiUwQSUwQW1uZyUyMCUzRCUyMGJuYi5vcHRpbS5HbG9iYWxPcHRpbU1hbmFnZXIuZ2V0X2luc3RhbmNlKCklMEElMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoKSUwQW1uZy5yZWdpc3Rlcl9wYXJhbWV0ZXJzKG1vZGVsLnBhcmFtZXRlcnMoKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

mng = bnb.optim.GlobalOptimManager.get_instance()

model = MyModel()
mng.register_parameters(model.parameters())`,wrap:!1}}),C=new Q({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC5jdWRhKCklMEElMjMlMjB1c2UlMjA4LWJpdCUyMG9wdGltaXplciUyMHN0YXRlcyUyMGZvciUyMGFsbCUyMHBhcmFtZXRlcnMlMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW0obW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QwLjAwMSUyQyUyMG9wdGltX2JpdHMlM0Q4KSUwQSUwQSUyMyUyMG92ZXJyaWRlJTIwdGhlJTIwcGFyYW1ldGVyJTIwbW9kZWwuZmMxLndlaWdodCUyMG5vdyUyMHVzZXMlMjAzMi1iaXQlMjBBZGFtJTBBbW5nLm92ZXJyaWRlX2NvbmZpZyhtb2RlbC5mYzEud2VpZ2h0JTJDJTIwJTIyb3B0aW1fYml0cyUyMiUyQyUyMDMyKQ==",highlighted:`model = model.cuda()
<span class="hljs-comment"># use 8-bit optimizer states for all parameters</span>
adam = bnb.optim.Adam(model.parameters(), lr=<span class="hljs-number">0.001</span>, optim_bits=<span class="hljs-number">8</span>)

<span class="hljs-comment"># override the parameter model.fc1.weight now uses 32-bit Adam</span>
mng.override_config(model.fc1.weight, <span class="hljs-string">&quot;optim_bits&quot;</span>, <span class="hljs-number">32</span>)`,wrap:!1}}),I=new Q({props:{code:"bW5nLm92ZXJyaWRlX2NvbmZpZyglNUJtb2RlbC5zcGVjaWFsLndlaWdodCUyQyUyMG1vZGVsLmFsc29fc3BlY2lhbC53ZWlnaHQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXlfdmFsdWVfZGljdCUyMCUzRCU3Qidpc19zcGFyc2UnJTNBJTIwVHJ1ZSUyQyUyMCdsciclM0ElMjAxZS01JTJDJTIwJ2JldGFzJyUzRCgwLjklMkMlMjAwLjk4KSU3RCk=",highlighted:`mng.override_config([model.special.weight, model.also_special.weight],
                    key_value_dict ={<span class="hljs-string">&#x27;is_sparse&#x27;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&#x27;lr&#x27;</span>: <span class="hljs-number">1e-5</span>, <span class="hljs-string">&#x27;betas&#x27;</span>=(<span class="hljs-number">0.9</span>, <span class="hljs-number">0.98</span>)})`,wrap:!1}}),A=new Q({props:{code:"Y2xhc3MlMjBNeU1vZHVsZSh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwZGVmJTIwX19pbml0X18oZF9pbiUyQyUyMGRfb3V0KSUzQSUwQSUyMCUyMCUyMCUyMHN1cGVyKE15TW9kdWxlJTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKGRfaW4lMkMlMjBkX291dCklMEElMjAlMjAlMjAlMjAlMjMlMjBvcHRpbWl6YXRpb24lMjB3aWxsJTIwaGFwcGVuJTIwaW4lMjAzMi1iaXQlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjMlMjBsZWFybmluZyUyMHJhdGUlMjB3aWxsJTIwYmUlMjBzZXQlMjB0byUyMDAuMDAwMSUyMGluZGVwZW5kZW50JTIwb2YlMjB0aGUlMjBtYWluJTIwbGVhcm5pbmclMjByYXRlJTBBJTIwJTIwJTIwJTIwY29uZmlnJTIwJTNEJTIwJTdCJ29wdGltX2JpdHMnJTNBJTIwMzIlMkMlMjAnbHInJTIwJTNBJTIwMC4wMDAxJTdEJTBBJTIwJTIwJTIwJTIwR2xvYmFsT3B0aW1NYW5hZ2VyLmdldF9pbnN0YW5jZSgpLnJlZ2lzdGVyX21vZHVsZV9vdmVycmlkZShzZWxmJTJDJTIwJ3dlaWdodCclMkMlMjBjb25maWcpJTBB",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModule</span>(torch.nn.Module):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">d_in, d_out</span>):
    <span class="hljs-built_in">super</span>(MyModule, self).__init__()
    self.linear = torch.nn.Linear(d_in, d_out)
    <span class="hljs-comment"># optimization will happen in 32-bit and</span>
    <span class="hljs-comment"># learning rate will be set to 0.0001 independent of the main learning rate</span>
    config = {<span class="hljs-string">&#x27;optim_bits&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;lr&#x27;</span> : <span class="hljs-number">0.0001</span>}
    GlobalOptimManager.get_instance().register_module_override(self, <span class="hljs-string">&#x27;weight&#x27;</span>, config)
`,wrap:!1}}),Y=new Je({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),E=new Re({props:{source:"https://github.com/bitsandbytes-foundation/bitsandbytes/blob/main/docs/source/optimizers.mdx"}}),{c(){u=n("meta"),R=a(),F=n("p"),V=a(),r(f.$$.fragment),N=a(),r(T.$$.fragment),P=a(),J=n("p"),J.textContent=$e,K=a(),j=n("p"),j.textContent=ge,O=a(),y=n("blockquote"),y.innerHTML=Ue,q=a(),$=n("p"),$.innerHTML=Ge,D=a(),r(g.$$.fragment),ee=a(),U=n("p"),U.textContent=ve,te=a(),G=n("p"),G.innerHTML=xe,le=a(),r(v.$$.fragment),se=a(),x=n("p"),x.innerHTML=Ze,ae=a(),r(Z.$$.fragment),ie=a(),r(k.$$.fragment),ne=a(),z=n("p"),z.innerHTML=ke,me=a(),_=n("ol"),_.innerHTML=ze,pe=a(),r(W.$$.fragment),re=a(),h=n("ol"),h.innerHTML=_e,oe=a(),w=n("blockquote"),w.innerHTML=We,de=a(),r(C.$$.fragment),be=a(),L=n("p"),L.innerHTML=Ce,Me=a(),r(I.$$.fragment),ce=a(),B=n("p"),B.innerHTML=Le,ue=a(),r(A.$$.fragment),ye=a(),r(Y.$$.fragment),he=a(),H=n("p"),H.innerHTML=Ie,we=a(),r(E.$$.fragment),fe=a(),S=n("p"),this.h()},l(e){const t=Fe("svelte-u9bgzb",document.head);u=m(t,"META",{name:!0,content:!0}),t.forEach(l),R=i(e),F=m(e,"P",{}),Be(F).forEach(l),V=i(e),o(f.$$.fragment,e),N=i(e),o(T.$$.fragment,e),P=i(e),J=m(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-7xifi0"&&(J.textContent=$e),K=i(e),j=m(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-anq6iu"&&(j.textContent=ge),O=i(e),y=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-1n1g6xz"&&(y.innerHTML=Ue),q=i(e),$=m(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-42uda"&&($.innerHTML=Ge),D=i(e),o(g.$$.fragment,e),ee=i(e),U=m(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1swxts3"&&(U.textContent=ve),te=i(e),G=m(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-swi3zx"&&(G.innerHTML=xe),le=i(e),o(v.$$.fragment,e),se=i(e),x=m(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-198tc99"&&(x.innerHTML=Ze),ae=i(e),o(Z.$$.fragment,e),ie=i(e),o(k.$$.fragment,e),ne=i(e),z=m(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-t6ql1m"&&(z.innerHTML=ke),me=i(e),_=m(e,"OL",{"data-svelte-h":!0}),p(_)!=="svelte-1revex8"&&(_.innerHTML=ze),pe=i(e),o(W.$$.fragment,e),re=i(e),h=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(h)!=="svelte-127zgse"&&(h.innerHTML=_e),oe=i(e),w=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-pqrln3"&&(w.innerHTML=We),de=i(e),o(C.$$.fragment,e),be=i(e),L=m(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-kxfpon"&&(L.innerHTML=Ce),Me=i(e),o(I.$$.fragment,e),ce=i(e),B=m(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-sha7g0"&&(B.innerHTML=Le),ue=i(e),o(A.$$.fragment,e),ye=i(e),o(Y.$$.fragment,e),he=i(e),H=m(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1er8qov"&&(H.innerHTML=Ie),we=i(e),o(E.$$.fragment,e),fe=i(e),S=m(e,"P",{}),Be(S).forEach(l),this.h()},h(){X(u,"name","hf:doc:metadata"),X(u,"content",Ne),X(y,"class","warning"),X(h,"start","2"),X(w,"class","tip")},m(e,t){Se(document.head,u),s(e,R,t),s(e,F,t),s(e,V,t),d(f,e,t),s(e,N,t),d(T,e,t),s(e,P,t),s(e,J,t),s(e,K,t),s(e,j,t),s(e,O,t),s(e,y,t),s(e,q,t),s(e,$,t),s(e,D,t),d(g,e,t),s(e,ee,t),s(e,U,t),s(e,te,t),s(e,G,t),s(e,le,t),d(v,e,t),s(e,se,t),s(e,x,t),s(e,ae,t),d(Z,e,t),s(e,ie,t),d(k,e,t),s(e,ne,t),s(e,z,t),s(e,me,t),s(e,_,t),s(e,pe,t),d(W,e,t),s(e,re,t),s(e,h,t),s(e,oe,t),s(e,w,t),s(e,de,t),d(C,e,t),s(e,be,t),s(e,L,t),s(e,Me,t),d(I,e,t),s(e,ce,t),s(e,B,t),s(e,ue,t),d(A,e,t),s(e,ye,t),d(Y,e,t),s(e,he,t),s(e,H,t),s(e,we,t),d(E,e,t),s(e,fe,t),s(e,S,t),Te=!0},p:Ye,i(e){Te||(b(f.$$.fragment,e),b(T.$$.fragment,e),b(g.$$.fragment,e),b(v.$$.fragment,e),b(Z.$$.fragment,e),b(k.$$.fragment,e),b(W.$$.fragment,e),b(C.$$.fragment,e),b(I.$$.fragment,e),b(A.$$.fragment,e),b(Y.$$.fragment,e),b(E.$$.fragment,e),Te=!0)},o(e){M(f.$$.fragment,e),M(T.$$.fragment,e),M(g.$$.fragment,e),M(v.$$.fragment,e),M(Z.$$.fragment,e),M(k.$$.fragment,e),M(W.$$.fragment,e),M(C.$$.fragment,e),M(I.$$.fragment,e),M(A.$$.fragment,e),M(Y.$$.fragment,e),M(E.$$.fragment,e),Te=!1},d(e){e&&(l(R),l(F),l(V),l(N),l(P),l(J),l(K),l(j),l(O),l(y),l(q),l($),l(D),l(ee),l(U),l(te),l(G),l(le),l(se),l(x),l(ae),l(ie),l(ne),l(z),l(me),l(_),l(pe),l(re),l(h),l(oe),l(w),l(de),l(be),l(L),l(Me),l(ce),l(B),l(ue),l(ye),l(he),l(H),l(we),l(fe),l(S)),l(u),c(f,e),c(T,e),c(g,e),c(v,e),c(Z,e),c(k,e),c(W,e),c(C,e),c(I,e),c(A,e),c(Y,e),c(E,e)}}}const Ne='{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[{"title":"Optimize unstable parameters","local":"optimize-unstable-parameters","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Pe(je){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Ee{constructor(u){super(),Qe(this,u,Pe,Ve,Ae,{})}}export{et as component};
