import{s as Ll,o as Pl,n as Dl}from"../chunks/scheduler.7da89386.js";import{S as Ol,i as Kl,g as m,s as a,r as i,A as te,h as U,f as e,c as n,j as Nl,u as M,x as u,k as Il,y as le,a as s,v as o,d as p,t as y,w as r}from"../chunks/index.20910acc.js";import{T as ee}from"../chunks/Tip.53e22153.js";import{C as J}from"../chunks/CodeBlock.143bd81e.js";import{H as T,E as se}from"../chunks/getInferenceSnippets.7cf363b6.js";function ae(Ct){let c,j='All <a href="/docs/lighteval/v0.11.0/en/package_reference/tasks#lighteval.tasks.lighteval_task.LightevalTaskConfig">LightevalTaskConfig</a> parameters are strongly typed, including the inputs to the template function. Make sure to take advantage of your IDE’s functionality to make it easier to correctly fill these parameters.';return{c(){c=m("p"),c.innerHTML=j},l(w){c=U(w,"P",{"data-svelte-h":!0}),u(c)!=="svelte-1t1he9w"&&(c.innerHTML=j)},m(w,gt){s(w,c,gt)},p:Dl,d(w){w&&e(c)}}}function ne(Ct){let c,j,w,gt,C,ft,f,bl="Lighteval supports multilingual evaluations through a comprehensive system of translation literals and language-adapted templates.",It,I,bt,b,dt,d,dl="We define 19 <code>literals</code>, basic keywords or punctuation signs used when creating evaluation prompts in an automatic manner, such as <code>yes</code>, <code>no</code>, <code>because</code>, etc.",$t,$,$l="These literals are essential for:",vt,v,vl="<li><strong>Consistent prompt formatting</strong> across languages</li> <li><strong>Automatic prompt generation</strong> for multilingual tasks</li> <li><strong>Proper localization</strong> of evaluation templates</li>",Gt,G,kt,k,Gl="We welcome translations in your language! To contribute:",Bt,B,kl='<li><p><strong>Open the translation literals file</strong>: <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/utils/translation_literals.py" rel="nofollow">translation_literals.py</a></p></li> <li><p><strong>Edit the file</strong> to add or expand the literal for your language of interest</p></li> <li><p><strong>Open a PR</strong> with your modifications</p></li>',Zt,Z,Wt,W,At,A,Ft,F,Qt,Q,Bl="Before creating a new multilingual task, you should:",Xt,X,Zl='<li><strong>Read the custom task guide</strong>: <a href="adding-a-custom-task">Adding a Custom Task</a></li> <li><strong>Understand multilingual task structure</strong>: Review the <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/multilingual/tasks.py" rel="nofollow">multilingual tasks</a> file</li> <li><strong>Browse available templates</strong>: Check the <a href="https://github.com/huggingface/lighteval/tree/main/src/lighteval/tasks/templates" rel="nofollow">templates directory</a></li>',Rt,R,xt,x,St,S,Wl="For multilingual evaluations, the <code>prompt_function</code> should be implemented using language-adapted templates. These templates handle:",Yt,Y,Al="<li><strong>Correct formatting</strong> for each language</li> <li><strong>Consistent usage</strong> of language-adjusted prompt anchors (e.g., Question/Answer)</li> <li><strong>Proper punctuation</strong> and spacing conventions</li>",Vt,V,Et,E,Fl="Available template types include:",qt,q,Ql='<li><strong>XNLI</strong>: Natural language inference tasks - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/nli.py#L162" rel="nofollow"><code>get_nli_prompt_function</code></a></li> <li><strong>COPA</strong>: Causal reasoning tasks - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/copa.py#L76" rel="nofollow"><code>get_copa_prompt_function</code></a></li> <li><strong>Multiple Choice</strong>: Standard multiple choice questions - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/multichoice.py#L81" rel="nofollow"><code>get_mcq_prompt_function</code></a></li> <li><strong>Question Answering</strong>: Open-ended question answering - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/qa.py#L46" rel="nofollow"><code>get_qa_prompt_function</code></a></li> <li><strong>Custom</strong>: Specialized task templates</li>',Ht,H,_t,_,zt,z,Xl="Used for standard multiple choice questions where the model selects from lettered options:",Nt,N,Lt,L,Rl="<strong>Example output:</strong>",Pt,P,Dt,D,Ot,O,xl="Used for classification tasks where the model generates the answer directly:",Kt,K,tl,tt,Sl="<strong>Example output:</strong>",ll,lt,el,et,sl,st,Yl="Used for tasks that present choices but expect the full answer text:",al,at,nl,nt,Vl="<strong>Example output:</strong>",il,it,Ml,Mt,ol,ot,pl,pt,El="Create a Python file following the custom task guide structure.",yl,yt,rl,rt,ml,mt,Ul,Ut,ul,ut,Tl,Tt,ql="Follow the custom task guide to test if your task is correctly implemented.",cl,h,wl,ct,Jl,g,Hl='<li class="task-list-item"><input type="checkbox" disabled=""/> Translation literals are accurate and complete</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Task works correctly across all target languages</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Metrics are appropriate for the task type</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Documentation is clear and comprehensive</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Code follows project conventions</li>',hl,wt,gl,Jt,_l="<li><strong>GitHub Issues</strong>: Report bugs or ask questions</li> <li><strong>Discussions</strong>: Join community discussions</li> <li><strong>Documentation</strong>: Review existing guides and examples</li>",jl,ht,Cl,jt,fl;return C=new T({props:{title:"Contributing to Multilingual Evaluations",local:"contributing-to-multilingual-evaluations",headingTag:"h1"}}),I=new T({props:{title:"Contributing Translation Literals",local:"contributing-translation-literals",headingTag:"h2"}}),b=new T({props:{title:"What Are Translation Literals?",local:"what-are-translation-literals",headingTag:"h3"}}),G=new T({props:{title:"How to Contribute Translations",local:"how-to-contribute-translations",headingTag:"h3"}}),Z=new T({props:{title:"Translation Literals Structure",local:"translation-literals-structure",headingTag:"h3"}}),W=new J({props:{code:"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",highlighted:`Language.ENGLISH: TranslationLiterals(
    language=Language.ENGLISH,
    question_word=<span class="hljs-string">&quot;question&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Question: How are you?&quot;</span>
    answer=<span class="hljs-string">&quot;answer&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Answer: I am fine&quot;</span>
    confirmation_word=<span class="hljs-string">&quot;right&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, right?&quot;</span>
    yes=<span class="hljs-string">&quot;yes&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Yes, he is&quot;</span>
    no=<span class="hljs-string">&quot;no&quot;</span>,  <span class="hljs-comment"># Usage: &quot;No, he is not&quot;</span>
    also=<span class="hljs-string">&quot;also&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Also, she is smart.&quot;</span>
    cause_word=<span class="hljs-string">&quot;because&quot;</span>,  <span class="hljs-comment"># Usage: &quot;She is smart, because she is tall&quot;</span>
    effect_word=<span class="hljs-string">&quot;therefore&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is tall therefore he is smart&quot;</span>
    or_word=<span class="hljs-string">&quot;or&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is tall or small&quot;</span>
    true=<span class="hljs-string">&quot;true&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    false=<span class="hljs-string">&quot;false&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    neither=<span class="hljs-string">&quot;neither&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    <span class="hljs-comment"># Punctuation and spacing: only adjust if your language uses something different than in English</span>
    full_stop=<span class="hljs-string">&quot;.&quot;</span>,
    comma=<span class="hljs-string">&quot;,&quot;</span>,
    question_mark=<span class="hljs-string">&quot;?&quot;</span>,
    exclamation_mark=<span class="hljs-string">&quot;!&quot;</span>,
    word_space=<span class="hljs-string">&quot; &quot;</span>,
    sentence_space=<span class="hljs-string">&quot; &quot;</span>,
    colon=<span class="hljs-string">&quot;:&quot;</span>,
    <span class="hljs-comment"># The first characters of your alphabet used in enumerations, if different from English</span>
    indices=[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>, ...]
)`,wrap:!1}}),A=new T({props:{title:"Contributing New Multilingual Tasks",local:"contributing-new-multilingual-tasks",headingTag:"h2"}}),F=new T({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h3"}}),R=new T({props:{title:"Key Concepts",local:"key-concepts",headingTag:"h3"}}),x=new T({props:{title:"Language-Adapted Templates",local:"language-adapted-templates",headingTag:"h4"}}),V=new T({props:{title:"Template Types",local:"template-types",headingTag:"h4"}}),H=new T({props:{title:"Formulation Types",local:"formulation-types",headingTag:"h4"}}),_=new T({props:{title:"Multiple Choice Formulation (MCF)",local:"multiple-choice-formulation-mcf",headingTag:"h5"}}),N=new J({props:{code:"TUNGRm9ybXVsYXRpb24oKQ==",highlighted:"MCFFormulation()",wrap:!1}}),P=new J({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBLiUyMExvbmRvbiUwQUIuJTIwUGFyaXMlMEFDLiUyMEJlcmxpbiUwQUQuJTIwUm9tZSUwQUFuc3dlciUzQSUyMCU3QyUyMEElMkZCJTJGQyUyRkQ=",highlighted:`<span class="hljs-variable">Question</span><span class="hljs-operator">:</span> <span class="hljs-variable">What</span> <span class="hljs-variable">is</span> <span class="hljs-variable">the</span> <span class="hljs-variable">capital</span> <span class="hljs-variable">of</span> <span class="hljs-variable">France</span><span class="hljs-operator">?</span>
<span class="hljs-variable">A</span><span class="hljs-operator">.</span> <span class="hljs-variable">London</span>
<span class="hljs-variable">B</span><span class="hljs-operator">.</span> <span class="hljs-variable">Paris</span>
<span class="hljs-built_in">C</span><span class="hljs-operator">.</span> <span class="hljs-variable">Berlin</span>
<span class="hljs-built_in">D</span><span class="hljs-operator">.</span> <span class="hljs-variable">Rome</span>
<span class="hljs-variable">Answer</span><span class="hljs-operator">:</span> <span class="hljs-operator">|</span> <span class="hljs-variable">A</span><span class="hljs-operator">/</span><span class="hljs-variable">B</span><span class="hljs-operator">/</span><span class="hljs-built_in">C</span><span class="hljs-operator">/</span><span class="hljs-built_in">D</span>`,wrap:!1}}),D=new T({props:{title:"Classification Formulation (CF)",local:"classification-formulation-cf",headingTag:"h5"}}),K=new J({props:{code:"Q0ZGb3JtdWxhdGlvbigp",highlighted:"CFFormulation()",wrap:!1}}),lt=new J({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBbnN3ZXIlM0ElMjAlN0MlMjBQYXJpcw==",highlighted:`<span class="hljs-symbol">Question:</span> What <span class="hljs-built_in">is</span> the capital <span class="hljs-keyword">of</span> France?
<span class="hljs-symbol">Answer:</span> | Paris`,wrap:!1}}),et=new T({props:{title:"Hybrid Formulation",local:"hybrid-formulation",headingTag:"h5"}}),at=new J({props:{code:"SHlicmlkRm9ybXVsYXRpb24oKQ==",highlighted:"HybridFormulation()",wrap:!1}}),it=new J({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBLiUyMExvbmRvbiUwQUIuJTIwUGFyaXMlMEFDLiUyMEJlcmxpbiUwQUQuJTIwUm9tZSUwQUFuc3dlciUzQSUyMCU3QyUyMFBhcmlz",highlighted:`<span class="hljs-symbol">Question:</span> What <span class="hljs-built_in">is</span> the capital <span class="hljs-keyword">of</span> France?
A. London
B. Paris
C. Berlin
D. Rome
<span class="hljs-symbol">Answer:</span> | Paris`,wrap:!1}}),Mt=new T({props:{title:"Creating Your Multilingual Task",local:"creating-your-multilingual-task",headingTag:"h3"}}),ot=new T({props:{title:"Step 1: Create the Task File",local:"step-1-create-the-task-file",headingTag:"h4"}}),yt=new T({props:{title:"Step 2: Import Required Components",local:"step-2-import-required-components",headingTag:"h4"}}),rt=new J({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5saWdodGV2YWxfdGFzayUyMGltcG9ydCUyMExpZ2h0ZXZhbFRhc2tDb25maWclMEFmcm9tJTIwbGlnaHRldmFsLnRhc2tzLm11bHRpbGluZ3VhbC5sYW5ndWFnZSUyMGltcG9ydCUyMExhbmd1YWdlJTBBZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5tdWx0aWxpbmd1YWwuZm9ybXVsYXRpb25zJTIwaW1wb3J0JTIwTUNGRm9ybXVsYXRpb24lMkMlMjBDRkZvcm11bGF0aW9uJTJDJTIwSHlicmlkRm9ybXVsYXRpb24lMEFmcm9tJTIwbGlnaHRldmFsLnRhc2tzLm11bHRpbGluZ3VhbC50ZW1wbGF0ZXMlMjBpbXBvcnQlMjBnZXRfdGVtcGxhdGVfcHJvbXB0X2Z1bmN0aW9uJTBBZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5tdWx0aWxpbmd1YWwubWV0cmljcyUyMGltcG9ydCUyMGdldF9tZXRyaWNzX2Zvcl9mb3JtdWxhdGlvbiUyQyUyMGxvZ2xpa2VsaWhvb2RfYWNjX21ldHJpYyUwQWZyb20lMjBsaWdodGV2YWwudGFza3MubXVsdGlsaW5ndWFsLm5vcm1hbGl6YXRpb24lMjBpbXBvcnQlMjBMb2dQcm9iVG9rZW5Ob3JtJTJDJTIwTG9nUHJvYkNoYXJOb3Jt",highlighted:`<span class="hljs-keyword">from</span> lighteval.tasks.lighteval_task <span class="hljs-keyword">import</span> LightevalTaskConfig
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.language <span class="hljs-keyword">import</span> Language
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.formulations <span class="hljs-keyword">import</span> MCFFormulation, CFFormulation, HybridFormulation
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.templates <span class="hljs-keyword">import</span> get_template_prompt_function
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.metrics <span class="hljs-keyword">import</span> get_metrics_for_formulation, loglikelihood_acc_metric
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.normalization <span class="hljs-keyword">import</span> LogProbTokenNorm, LogProbCharNorm`,wrap:!1}}),mt=new T({props:{title:"Step 3: Define Your Tasks",local:"step-3-define-your-tasks",headingTag:"h4"}}),Ut=new J({props:{code:"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",highlighted:`your_tasks = [
    LightevalTaskConfig(
        <span class="hljs-comment"># Name of your evaluation</span>
        name=<span class="hljs-string">f&quot;evalname_<span class="hljs-subst">{language.value}</span>_<span class="hljs-subst">{formulation.name.lower()}</span>&quot;</span>,
        <span class="hljs-comment"># The evaluation is community contributed</span>
        suite=[<span class="hljs-string">&quot;community&quot;</span>],
        <span class="hljs-comment"># This will automatically get the correct metrics for your chosen formulation</span>
        metric=get_metrics_for_formulation(
            formulation,
            [
                LogLikelihoodAccMetric(normalization=<span class="hljs-literal">None</span>),
                LogLikelihoodAccMetric(normalization=LogProbTokenNorm()),
                LogLikelihoodAccMetric(normalization=LogProbCharNorm()),
            ],
        ),
        <span class="hljs-comment"># In this function, you choose which template to follow and for which language and formulation</span>
        prompt_function=get_template_prompt_function(
            language=language,
            <span class="hljs-comment"># Use the adapter to define the mapping between the</span>
            <span class="hljs-comment"># keys of the template (left), and the keys of your dataset</span>
            <span class="hljs-comment"># (right)</span>
            <span class="hljs-comment"># To know which template keys are required and available,</span>
            <span class="hljs-comment"># consult the appropriate adapter type and doc-string.</span>
            adapter=<span class="hljs-keyword">lambda</span> line: {
                <span class="hljs-string">&quot;key&quot;</span>: line[<span class="hljs-string">&quot;relevant_key&quot;</span>],
                <span class="hljs-comment"># Add more mappings as needed</span>
            },
            formulation=formulation,
        ),
        <span class="hljs-comment"># You can also add specific filters to remove irrelevant samples</span>
        hf_filter=<span class="hljs-keyword">lambda</span> line: line[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">in</span> &lt;condition&gt;,
        <span class="hljs-comment"># You then select your huggingface dataset as well as</span>
        <span class="hljs-comment"># the splits available for evaluation</span>
        hf_repo=&lt;dataset&gt;,
        hf_subset=&lt;subset&gt;,
        evaluation_splits=[<span class="hljs-string">&quot;train&quot;</span>],
        hf_avail_splits=[<span class="hljs-string">&quot;train&quot;</span>],
    )
    <span class="hljs-keyword">for</span> language <span class="hljs-keyword">in</span> [
        Language.YOUR_LANGUAGE,  <span class="hljs-comment"># Add your target languages</span>
        <span class="hljs-comment"># Language.SPANISH,</span>
        <span class="hljs-comment"># Language.FRENCH,</span>
        <span class="hljs-comment"># etc.</span>
    ]
    <span class="hljs-keyword">for</span> formulation <span class="hljs-keyword">in</span> [MCFFormulation(), CFFormulation(), HybridFormulation()]
]`,wrap:!1}}),ut=new T({props:{title:"Step 4: Test Your Implementation",local:"step-4-test-your-implementation",headingTag:"h4"}}),h=new ee({props:{warning:!1,$$slots:{default:[ae]},$$scope:{ctx:Ct}}}),ct=new T({props:{title:"Validation Checklist",local:"validation-checklist",headingTag:"h3"}}),wt=new T({props:{title:"Getting Help",local:"getting-help",headingTag:"h3"}}),ht=new se({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/contributing-to-multilingual-evaluations.mdx"}}),{c(){c=m("meta"),j=a(),w=m("p"),gt=a(),i(C.$$.fragment),ft=a(),f=m("p"),f.textContent=bl,It=a(),i(I.$$.fragment),bt=a(),i(b.$$.fragment),dt=a(),d=m("p"),d.innerHTML=dl,$t=a(),$=m("p"),$.textContent=$l,vt=a(),v=m("ul"),v.innerHTML=vl,Gt=a(),i(G.$$.fragment),kt=a(),k=m("p"),k.textContent=Gl,Bt=a(),B=m("ol"),B.innerHTML=kl,Zt=a(),i(Z.$$.fragment),Wt=a(),i(W.$$.fragment),At=a(),i(A.$$.fragment),Ft=a(),i(F.$$.fragment),Qt=a(),Q=m("p"),Q.textContent=Bl,Xt=a(),X=m("ol"),X.innerHTML=Zl,Rt=a(),i(R.$$.fragment),xt=a(),i(x.$$.fragment),St=a(),S=m("p"),S.innerHTML=Wl,Yt=a(),Y=m("ul"),Y.innerHTML=Al,Vt=a(),i(V.$$.fragment),Et=a(),E=m("p"),E.textContent=Fl,qt=a(),q=m("ul"),q.innerHTML=Ql,Ht=a(),i(H.$$.fragment),_t=a(),i(_.$$.fragment),zt=a(),z=m("p"),z.textContent=Xl,Nt=a(),i(N.$$.fragment),Lt=a(),L=m("p"),L.innerHTML=Rl,Pt=a(),i(P.$$.fragment),Dt=a(),i(D.$$.fragment),Ot=a(),O=m("p"),O.textContent=xl,Kt=a(),i(K.$$.fragment),tl=a(),tt=m("p"),tt.innerHTML=Sl,ll=a(),i(lt.$$.fragment),el=a(),i(et.$$.fragment),sl=a(),st=m("p"),st.textContent=Yl,al=a(),i(at.$$.fragment),nl=a(),nt=m("p"),nt.innerHTML=Vl,il=a(),i(it.$$.fragment),Ml=a(),i(Mt.$$.fragment),ol=a(),i(ot.$$.fragment),pl=a(),pt=m("p"),pt.textContent=El,yl=a(),i(yt.$$.fragment),rl=a(),i(rt.$$.fragment),ml=a(),i(mt.$$.fragment),Ul=a(),i(Ut.$$.fragment),ul=a(),i(ut.$$.fragment),Tl=a(),Tt=m("p"),Tt.textContent=ql,cl=a(),i(h.$$.fragment),wl=a(),i(ct.$$.fragment),Jl=a(),g=m("ul"),g.innerHTML=Hl,hl=a(),i(wt.$$.fragment),gl=a(),Jt=m("ul"),Jt.innerHTML=_l,jl=a(),i(ht.$$.fragment),Cl=a(),jt=m("p"),this.h()},l(t){const l=te("svelte-u9bgzb",document.head);c=U(l,"META",{name:!0,content:!0}),l.forEach(e),j=n(t),w=U(t,"P",{}),Nl(w).forEach(e),gt=n(t),M(C.$$.fragment,t),ft=n(t),f=U(t,"P",{"data-svelte-h":!0}),u(f)!=="svelte-1re6ahv"&&(f.textContent=bl),It=n(t),M(I.$$.fragment,t),bt=n(t),M(b.$$.fragment,t),dt=n(t),d=U(t,"P",{"data-svelte-h":!0}),u(d)!=="svelte-119kr4u"&&(d.innerHTML=dl),$t=n(t),$=U(t,"P",{"data-svelte-h":!0}),u($)!=="svelte-3mks6q"&&($.textContent=$l),vt=n(t),v=U(t,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-1dsw83j"&&(v.innerHTML=vl),Gt=n(t),M(G.$$.fragment,t),kt=n(t),k=U(t,"P",{"data-svelte-h":!0}),u(k)!=="svelte-awnkj1"&&(k.textContent=Gl),Bt=n(t),B=U(t,"OL",{"data-svelte-h":!0}),u(B)!=="svelte-1s61htl"&&(B.innerHTML=kl),Zt=n(t),M(Z.$$.fragment,t),Wt=n(t),M(W.$$.fragment,t),At=n(t),M(A.$$.fragment,t),Ft=n(t),M(F.$$.fragment,t),Qt=n(t),Q=U(t,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1k1ke89"&&(Q.textContent=Bl),Xt=n(t),X=U(t,"OL",{"data-svelte-h":!0}),u(X)!=="svelte-1v6bdr0"&&(X.innerHTML=Zl),Rt=n(t),M(R.$$.fragment,t),xt=n(t),M(x.$$.fragment,t),St=n(t),S=U(t,"P",{"data-svelte-h":!0}),u(S)!=="svelte-10zen67"&&(S.innerHTML=Wl),Yt=n(t),Y=U(t,"UL",{"data-svelte-h":!0}),u(Y)!=="svelte-1pehqym"&&(Y.innerHTML=Al),Vt=n(t),M(V.$$.fragment,t),Et=n(t),E=U(t,"P",{"data-svelte-h":!0}),u(E)!=="svelte-fj6wl8"&&(E.textContent=Fl),qt=n(t),q=U(t,"UL",{"data-svelte-h":!0}),u(q)!=="svelte-ewvrtu"&&(q.innerHTML=Ql),Ht=n(t),M(H.$$.fragment,t),_t=n(t),M(_.$$.fragment,t),zt=n(t),z=U(t,"P",{"data-svelte-h":!0}),u(z)!=="svelte-vecr4s"&&(z.textContent=Xl),Nt=n(t),M(N.$$.fragment,t),Lt=n(t),L=U(t,"P",{"data-svelte-h":!0}),u(L)!=="svelte-5gri02"&&(L.innerHTML=Rl),Pt=n(t),M(P.$$.fragment,t),Dt=n(t),M(D.$$.fragment,t),Ot=n(t),O=U(t,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1616vrk"&&(O.textContent=xl),Kt=n(t),M(K.$$.fragment,t),tl=n(t),tt=U(t,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-5gri02"&&(tt.innerHTML=Sl),ll=n(t),M(lt.$$.fragment,t),el=n(t),M(et.$$.fragment,t),sl=n(t),st=U(t,"P",{"data-svelte-h":!0}),u(st)!=="svelte-qvptvt"&&(st.textContent=Yl),al=n(t),M(at.$$.fragment,t),nl=n(t),nt=U(t,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-5gri02"&&(nt.innerHTML=Vl),il=n(t),M(it.$$.fragment,t),Ml=n(t),M(Mt.$$.fragment,t),ol=n(t),M(ot.$$.fragment,t),pl=n(t),pt=U(t,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-10cbov8"&&(pt.textContent=El),yl=n(t),M(yt.$$.fragment,t),rl=n(t),M(rt.$$.fragment,t),ml=n(t),M(mt.$$.fragment,t),Ul=n(t),M(Ut.$$.fragment,t),ul=n(t),M(ut.$$.fragment,t),Tl=n(t),Tt=U(t,"P",{"data-svelte-h":!0}),u(Tt)!=="svelte-xvg35t"&&(Tt.textContent=ql),cl=n(t),M(h.$$.fragment,t),wl=n(t),M(ct.$$.fragment,t),Jl=n(t),g=U(t,"UL",{class:!0,"data-svelte-h":!0}),u(g)!=="svelte-18pkgkh"&&(g.innerHTML=Hl),hl=n(t),M(wt.$$.fragment,t),gl=n(t),Jt=U(t,"UL",{"data-svelte-h":!0}),u(Jt)!=="svelte-47kvog"&&(Jt.innerHTML=_l),jl=n(t),M(ht.$$.fragment,t),Cl=n(t),jt=U(t,"P",{}),Nl(jt).forEach(e),this.h()},h(){Il(c,"name","hf:doc:metadata"),Il(c,"content",ie),Il(g,"class","contains-task-list")},m(t,l){le(document.head,c),s(t,j,l),s(t,w,l),s(t,gt,l),o(C,t,l),s(t,ft,l),s(t,f,l),s(t,It,l),o(I,t,l),s(t,bt,l),o(b,t,l),s(t,dt,l),s(t,d,l),s(t,$t,l),s(t,$,l),s(t,vt,l),s(t,v,l),s(t,Gt,l),o(G,t,l),s(t,kt,l),s(t,k,l),s(t,Bt,l),s(t,B,l),s(t,Zt,l),o(Z,t,l),s(t,Wt,l),o(W,t,l),s(t,At,l),o(A,t,l),s(t,Ft,l),o(F,t,l),s(t,Qt,l),s(t,Q,l),s(t,Xt,l),s(t,X,l),s(t,Rt,l),o(R,t,l),s(t,xt,l),o(x,t,l),s(t,St,l),s(t,S,l),s(t,Yt,l),s(t,Y,l),s(t,Vt,l),o(V,t,l),s(t,Et,l),s(t,E,l),s(t,qt,l),s(t,q,l),s(t,Ht,l),o(H,t,l),s(t,_t,l),o(_,t,l),s(t,zt,l),s(t,z,l),s(t,Nt,l),o(N,t,l),s(t,Lt,l),s(t,L,l),s(t,Pt,l),o(P,t,l),s(t,Dt,l),o(D,t,l),s(t,Ot,l),s(t,O,l),s(t,Kt,l),o(K,t,l),s(t,tl,l),s(t,tt,l),s(t,ll,l),o(lt,t,l),s(t,el,l),o(et,t,l),s(t,sl,l),s(t,st,l),s(t,al,l),o(at,t,l),s(t,nl,l),s(t,nt,l),s(t,il,l),o(it,t,l),s(t,Ml,l),o(Mt,t,l),s(t,ol,l),o(ot,t,l),s(t,pl,l),s(t,pt,l),s(t,yl,l),o(yt,t,l),s(t,rl,l),o(rt,t,l),s(t,ml,l),o(mt,t,l),s(t,Ul,l),o(Ut,t,l),s(t,ul,l),o(ut,t,l),s(t,Tl,l),s(t,Tt,l),s(t,cl,l),o(h,t,l),s(t,wl,l),o(ct,t,l),s(t,Jl,l),s(t,g,l),s(t,hl,l),o(wt,t,l),s(t,gl,l),s(t,Jt,l),s(t,jl,l),o(ht,t,l),s(t,Cl,l),s(t,jt,l),fl=!0},p(t,[l]){const zl={};l&2&&(zl.$$scope={dirty:l,ctx:t}),h.$set(zl)},i(t){fl||(p(C.$$.fragment,t),p(I.$$.fragment,t),p(b.$$.fragment,t),p(G.$$.fragment,t),p(Z.$$.fragment,t),p(W.$$.fragment,t),p(A.$$.fragment,t),p(F.$$.fragment,t),p(R.$$.fragment,t),p(x.$$.fragment,t),p(V.$$.fragment,t),p(H.$$.fragment,t),p(_.$$.fragment,t),p(N.$$.fragment,t),p(P.$$.fragment,t),p(D.$$.fragment,t),p(K.$$.fragment,t),p(lt.$$.fragment,t),p(et.$$.fragment,t),p(at.$$.fragment,t),p(it.$$.fragment,t),p(Mt.$$.fragment,t),p(ot.$$.fragment,t),p(yt.$$.fragment,t),p(rt.$$.fragment,t),p(mt.$$.fragment,t),p(Ut.$$.fragment,t),p(ut.$$.fragment,t),p(h.$$.fragment,t),p(ct.$$.fragment,t),p(wt.$$.fragment,t),p(ht.$$.fragment,t),fl=!0)},o(t){y(C.$$.fragment,t),y(I.$$.fragment,t),y(b.$$.fragment,t),y(G.$$.fragment,t),y(Z.$$.fragment,t),y(W.$$.fragment,t),y(A.$$.fragment,t),y(F.$$.fragment,t),y(R.$$.fragment,t),y(x.$$.fragment,t),y(V.$$.fragment,t),y(H.$$.fragment,t),y(_.$$.fragment,t),y(N.$$.fragment,t),y(P.$$.fragment,t),y(D.$$.fragment,t),y(K.$$.fragment,t),y(lt.$$.fragment,t),y(et.$$.fragment,t),y(at.$$.fragment,t),y(it.$$.fragment,t),y(Mt.$$.fragment,t),y(ot.$$.fragment,t),y(yt.$$.fragment,t),y(rt.$$.fragment,t),y(mt.$$.fragment,t),y(Ut.$$.fragment,t),y(ut.$$.fragment,t),y(h.$$.fragment,t),y(ct.$$.fragment,t),y(wt.$$.fragment,t),y(ht.$$.fragment,t),fl=!1},d(t){t&&(e(j),e(w),e(gt),e(ft),e(f),e(It),e(bt),e(dt),e(d),e($t),e($),e(vt),e(v),e(Gt),e(kt),e(k),e(Bt),e(B),e(Zt),e(Wt),e(At),e(Ft),e(Qt),e(Q),e(Xt),e(X),e(Rt),e(xt),e(St),e(S),e(Yt),e(Y),e(Vt),e(Et),e(E),e(qt),e(q),e(Ht),e(_t),e(zt),e(z),e(Nt),e(Lt),e(L),e(Pt),e(Dt),e(Ot),e(O),e(Kt),e(tl),e(tt),e(ll),e(el),e(sl),e(st),e(al),e(nl),e(nt),e(il),e(Ml),e(ol),e(pl),e(pt),e(yl),e(rl),e(ml),e(Ul),e(ul),e(Tl),e(Tt),e(cl),e(wl),e(Jl),e(g),e(hl),e(gl),e(Jt),e(jl),e(Cl),e(jt)),e(c),r(C,t),r(I,t),r(b,t),r(G,t),r(Z,t),r(W,t),r(A,t),r(F,t),r(R,t),r(x,t),r(V,t),r(H,t),r(_,t),r(N,t),r(P,t),r(D,t),r(K,t),r(lt,t),r(et,t),r(at,t),r(it,t),r(Mt,t),r(ot,t),r(yt,t),r(rt,t),r(mt,t),r(Ut,t),r(ut,t),r(h,t),r(ct,t),r(wt,t),r(ht,t)}}}const ie='{"title":"Contributing to Multilingual Evaluations","local":"contributing-to-multilingual-evaluations","sections":[{"title":"Contributing Translation Literals","local":"contributing-translation-literals","sections":[{"title":"What Are Translation Literals?","local":"what-are-translation-literals","sections":[],"depth":3},{"title":"How to Contribute Translations","local":"how-to-contribute-translations","sections":[],"depth":3},{"title":"Translation Literals Structure","local":"translation-literals-structure","sections":[],"depth":3}],"depth":2},{"title":"Contributing New Multilingual Tasks","local":"contributing-new-multilingual-tasks","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":3},{"title":"Key Concepts","local":"key-concepts","sections":[{"title":"Language-Adapted Templates","local":"language-adapted-templates","sections":[],"depth":4},{"title":"Template Types","local":"template-types","sections":[],"depth":4},{"title":"Formulation Types","local":"formulation-types","sections":[{"title":"Multiple Choice Formulation (MCF)","local":"multiple-choice-formulation-mcf","sections":[],"depth":5},{"title":"Classification Formulation (CF)","local":"classification-formulation-cf","sections":[],"depth":5},{"title":"Hybrid Formulation","local":"hybrid-formulation","sections":[],"depth":5}],"depth":4}],"depth":3},{"title":"Creating Your Multilingual Task","local":"creating-your-multilingual-task","sections":[{"title":"Step 1: Create the Task File","local":"step-1-create-the-task-file","sections":[],"depth":4},{"title":"Step 2: Import Required Components","local":"step-2-import-required-components","sections":[],"depth":4},{"title":"Step 3: Define Your Tasks","local":"step-3-define-your-tasks","sections":[],"depth":4},{"title":"Step 4: Test Your Implementation","local":"step-4-test-your-implementation","sections":[],"depth":4}],"depth":3},{"title":"Validation Checklist","local":"validation-checklist","sections":[],"depth":3},{"title":"Getting Help","local":"getting-help","sections":[],"depth":3}],"depth":2}],"depth":1}';function Me(Ct){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends Ol{constructor(c){super(),Kl(this,c,Me,ne,Ll,{})}}export{Ue as component};
