import{s as si,o as ii,n as vn}from"../chunks/scheduler.8c3d61f6.js";import{S as oi,i as ri,g as i,s as t,r as p,A as li,h as o,f as s,c as a,j as y,u as c,x as w,k as I,y as n,a as h,v as m,d as g,t as u,w as f}from"../chunks/index.da70eac4.js";import{T as ai}from"../chunks/Tip.1d9b8c37.js";import{D as v}from"../chunks/Docstring.2187c15d.js";import{C as pt}from"../chunks/CodeBlock.a9c4becf.js";import{E as mt}from"../chunks/ExampleCodeBlock.56cd5e98.js";import{H as D,E as di}from"../chunks/getInferenceSnippets.676f6ee5.js";function pi(j){let d,x='<a href="../../optimization/cache">Caching</a> may also speed up inference by storing and reusing intermediate outputs.';return{c(){d=i("p"),d.innerHTML=x},l(b){d=o(b,"P",{"data-svelte-h":!0}),w(d)!=="svelte-yvhnlz"&&(d.innerHTML=x)},m(b,_){h(b,d,_)},p:vn,d(b){b&&s(d)}}}function ci(j){let d,x="The <code>guidance_scale</code> parameter in the pipeline is there to support future guidance-distilled models when they come up. Note that passing <code>guidance_scale</code> to the pipeline is ineffective. To enable classifier-free guidance, please pass <code>true_cfg_scale</code> and <code>negative_prompt</code> (even an empty negative prompt like ” ”) should enable classifier-free guidance computations.";return{c(){d=i("p"),d.innerHTML=x},l(b){d=o(b,"P",{"data-svelte-h":!0}),w(d)!=="svelte-1ftpam8"&&(d.innerHTML=x)},m(b,_){h(b,d,_)},p:vn,d(b){b&&s(d)}}}function mi(j){let d,x="Examples:",b,_,T;return _=new pt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQSUyMyUyMERlcGVuZGluZyUyMG9uJTIwdGhlJTIwdmFyaWFudCUyMGJlaW5nJTIwdXNlZCUyQyUyMHRoZSUyMHBpcGVsaW5lJTIwY2FsbCUyMHdpbGwlMjBzbGlnaHRseSUyMHZhcnkuJTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTIwZG9jdW1lbnRhdGlvbiUyMGZvciUyMG1vcmUlMjBkZXRhaWxzLiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnF3ZW5pbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImagePipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(r){d=o(r,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(r),c(_.$$.fragment,r)},m(r,M){h(r,d,M),h(r,b,M),m(_,r,M),T=!0},p:vn,i(r){T||(g(_.$$.fragment,r),T=!0)},o(r){u(_.$$.fragment,r),T=!1},d(r){r&&(s(d),s(b)),f(_,r)}}}function gi(j){let d,x="Examples:",b,_,T;return _=new pt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCkucmVzaXplKCgxMDI0JTJDJTIwMTAyNCkpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMCUyMiUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC45NSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlcy5zYXZlKCUyMnF3ZW5pbWFnZV9pbWcyaW1nLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=init_image, strength=<span class="hljs-number">0.95</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images.save(<span class="hljs-string">&quot;qwenimage_img2img.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(r){d=o(r,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(r),c(_.$$.fragment,r)},m(r,M){h(r,d,M),h(r,b,M),m(_,r,M),T=!0},p:vn,i(r){T||(g(_.$$.fragment,r),T=!0)},o(r){u(_.$$.fragment,r),T=!1},d(r){r&&(s(d),s(b)),f(_,r)}}}function ui(j){let d,x="Examples:",b,_,T;return _=new pt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkZhY2UlMjBvZiUyMGElMjB5ZWxsb3clMjBjYXQlMkMlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHNpdHRpbmclMjBvbiUyMGElMjBwYXJrJTIwYmVuY2glMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQXNvdXJjZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIwJTIyJTJDJTIwaW1hZ2UlM0Rzb3VyY2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFzayUyQyUyMHN0cmVuZ3RoJTNEMC44NSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycXdlbmltYWdlX2lucGFpbnRpbmcucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=source, mask_image=mask, strength=<span class="hljs-number">0.85</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(r){d=o(r,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(r),c(_.$$.fragment,r)},m(r,M){h(r,d,M),h(r,b,M),m(_,r,M),T=!0},p:vn,i(r){T||(g(_.$$.fragment,r),T=!0)},o(r){u(_.$$.fragment,r),T=!1},d(r){r&&(s(d),s(b)),f(_,r)}}}function fi(j){let d,x="Examples:",b,_,T;return _=new pt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlRWRpdFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlRWRpdFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZS1FZGl0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnlhcm4tYXJ0LXBpa2FjaHUucG5nJTIyJTBBKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyTWFrZSUyMFBpa2FjaHUlMjBob2xkJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMCdRd2VuJTIwRWRpdCUyMGlzJTIwYXdlc29tZSclMkMlMjB5YXJuJTIwYXJ0JTIwc3R5bGUlMkMlMjBkZXRhaWxlZCUyQyUyMHZpYnJhbnQlMjBjb2xvcnMlMjIlMEEpJTBBJTIzJTIwRGVwZW5kaW5nJTIwb24lMjB0aGUlMjB2YXJpYW50JTIwYmVpbmclMjB1c2VkJTJDJTIwdGhlJTIwcGlwZWxpbmUlMjBjYWxsJTIwd2lsbCUyMHNsaWdodGx5JTIwdmFyeS4lMEElMjMlMjBSZWZlciUyMHRvJTIwdGhlJTIwcGlwZWxpbmUlMjBkb2N1bWVudGF0aW9uJTIwZm9yJTIwbW9yZSUyMGRldGFpbHMuJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJxd2VuaW1hZ2VfZWRpdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageEditPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageEditPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/yarn-art-pikachu.png&quot;</span>
<span class="hljs-meta">... </span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Make Pikachu hold a sign that says &#x27;Qwen Edit is awesome&#x27;, yarn art style, detailed, vibrant colors&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(image, prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_edit.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(r){d=o(r,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(r),c(_.$$.fragment,r)},m(r,M){h(r,d,M),h(r,b,M),m(_,r,M),T=!0},p:vn,i(r){T||(g(_.$$.fragment,r),T=!0)},o(r){u(_.$$.fragment,r),T=!1},d(r){r&&(s(d),s(b)),f(_,r)}}}function hi(j){let d,x="Examples:",b,_,T;return _=new pt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlRWRpdElucGFpbnRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMFF3ZW5JbWFnZUVkaXRJbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlLUVkaXQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFzb3VyY2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMCUyMiUyQyUyMGltYWdlJTNEc291cmNlJTJDJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMjBzdHJlbmd0aCUzRDEuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycXdlbmltYWdlX2lucGFpbnRpbmcucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageEditInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageEditInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=source, mask_image=mask, strength=<span class="hljs-number">1.0</span>, num_inference_steps=<span class="hljs-number">50</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(r){d=o(r,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(r),c(_.$$.fragment,r)},m(r,M){h(r,d,M),h(r,b,M),m(_,r,M),T=!0},p:vn,i(r){T||(g(_.$$.fragment,r),T=!0)},o(r){u(_.$$.fragment,r),T=!1},d(r){r&&(s(d),s(b)),f(_,r)}}}function _i(j){let d,x,b,_,T,r,M,us='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',gt,be,fs="Qwen-Image from the Qwen team is an image generation foundation model in the Qwen series that achieves significant advances in complex text rendering and precise image editing. Experiments show strong general capabilities in both image generation and editing, with exceptional performance in text rendering, especially for Chinese.",ut,ye,hs="Qwen-Image comes in the following variants:",ft,Ie,_s='<thead><tr><th align="center">model type</th> <th align="center">model id</th></tr></thead> <tbody><tr><td align="center">Qwen-Image</td> <td align="center"><a href="https://huggingface.co/Qwen/Qwen-Image" rel="nofollow"><code>Qwen/Qwen-Image</code></a></td></tr> <tr><td align="center">Qwen-Image-Edit</td> <td align="center"><a href="https://huggingface.co/Qwen/Qwen-Image-Edit" rel="nofollow"><code>Qwen/Qwen-Image-Edit</code></a></td></tr></tbody>',ht,R,_t,ve,wt,Te,ws=`Use a LoRA from <code>lightx2v/Qwen-Image-Lightning</code> to speed up inference by reducing the
number of steps. Refer to the code snippet below:`,bt,z,Tn,bs="Code",na,Me,yt,H,It,xe,vt,$,$e,ta,Mn,ys="The QwenImage pipeline for text-to-image generation.",aa,Z,ke,sa,xn,Is="Function invoked when calling the pipeline for generation.",ia,F,oa,A,Qe,ra,$n,vs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,la,Y,Je,da,kn,Ts=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,pa,S,Ue,ca,Qn,Ms=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ma,O,Pe,ga,Jn,xs=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ua,Un,je,Tt,Ce,Mt,k,Ee,fa,Pn,$s="The QwenImage pipeline for text-to-image generation.",ha,q,Le,_a,jn,ks="Function invoked when calling the pipeline for generation.",wa,K,ba,ee,We,ya,Cn,Qs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ia,ne,Ze,va,En,Js=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ta,te,qe,Ma,Ln,Us=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,xa,ae,Ve,$a,Wn,Ps=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ka,Zn,Ge,xt,Ne,$t,Q,Be,Qa,qn,js="The QwenImage pipeline for text-to-image generation.",Ja,V,Xe,Ua,Vn,Cs="Function invoked when calling the pipeline for generation.",Pa,se,ja,ie,De,Ca,Gn,Es=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ea,oe,Re,La,Nn,Ls=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Wa,re,ze,Za,Bn,Ws=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,qa,le,He,Va,Xn,Zs=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ga,Dn,Fe,kt,Ae,Qt,J,Ye,Na,Rn,qs="The Qwen-Image-Edit pipeline for image editing.",Ba,G,Se,Xa,zn,Vs="Function invoked when calling the pipeline for generation.",Da,de,Ra,pe,Oe,za,Hn,Gs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ha,ce,Ke,Fa,Fn,Ns=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Aa,me,en,Ya,An,Bs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Sa,ge,nn,Oa,Yn,Xs=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ka,Sn,tn,Jt,an,Ut,U,sn,es,On,Ds="The Qwen-Image-Edit pipeline for image editing.",ns,N,on,ts,Kn,Rs="Function invoked when calling the pipeline for generation.",as,ue,ss,fe,rn,is,et,zs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,os,he,ln,rs,nt,Hs=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,ls,_e,dn,ds,tt,Fs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ps,we,pn,cs,at,As=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ms,st,cn,Pt,mn,jt,gn,Ys="<li>all</li> <li><strong>call</strong></li>",Ct,un,Et,B,fn,gs,it,Ss="Output class for Stable Diffusion pipelines.",Lt,hn,Wt,ct,Zt;return T=new D({props:{title:"QwenImage",local:"qwenimage",headingTag:"h1"}}),R=new ai({props:{$$slots:{default:[pi]},$$scope:{ctx:j}}}),ve=new D({props:{title:"LoRA for faster inference",local:"lora-for-faster-inference",headingTag:"h2"}}),Me=new pt({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, FlowMatchEulerDiscreteScheduler
<span class="hljs-keyword">import</span> torch 
<span class="hljs-keyword">import</span> math

ckpt_id = <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>

<span class="hljs-comment"># From</span>
<span class="hljs-comment"># https://github.com/ModelTC/Qwen-Image-Lightning/blob/342260e8f5468d2f24d084ce04f55e101007118b/generate_with_diffusers.py#L82C9-L97C10</span>
scheduler_config = {
    <span class="hljs-string">&quot;base_image_seq_len&quot;</span>: <span class="hljs-number">256</span>,
    <span class="hljs-string">&quot;base_shift&quot;</span>: math.log(<span class="hljs-number">3</span>),  <span class="hljs-comment"># We use shift=3 in distillation</span>
    <span class="hljs-string">&quot;invert_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;max_image_seq_len&quot;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&quot;max_shift&quot;</span>: math.log(<span class="hljs-number">3</span>),  <span class="hljs-comment"># We use shift=3 in distillation</span>
    <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;shift&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;shift_terminal&quot;</span>: <span class="hljs-literal">None</span>,  <span class="hljs-comment"># set shift_terminal to None</span>
    <span class="hljs-string">&quot;stochastic_sampling&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;time_shift_type&quot;</span>: <span class="hljs-string">&quot;exponential&quot;</span>,
    <span class="hljs-string">&quot;use_beta_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;use_dynamic_shifting&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;use_exponential_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;use_karras_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
}
scheduler = FlowMatchEulerDiscreteScheduler.from_config(scheduler_config)
pipe = DiffusionPipeline.from_pretrained(
    ckpt_id, scheduler=scheduler, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;lightx2v/Qwen-Image-Lightning&quot;</span>, weight_name=<span class="hljs-string">&quot;Qwen-Image-Lightning-8steps-V1.0.safetensors&quot;</span>
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon, Ultra HD, 4K, cinematic composition.&quot;</span>
negative_prompt = <span class="hljs-string">&quot; &quot;</span>
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">8</span>,
    true_cfg_scale=<span class="hljs-number">1.0</span>,
    generator=torch.manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;qwen_fewsteps.png&quot;</span>)`,wrap:!1}}),H=new ai({props:{$$slots:{default:[ci]},$$scope:{ctx:j}}}),xe=new D({props:{title:"QwenImagePipeline",local:"diffusers.QwenImagePipeline",headingTag:"h2"}}),$e=new v({props:{name:"class diffusers.QwenImagePipeline",anchor:"diffusers.QwenImagePipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L132"}}),ke=new v({props:{name:"__call__",anchor:"diffusers.QwenImagePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImagePipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImagePipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImagePipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImagePipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImagePipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L451",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),F=new mt({props:{anchor:"diffusers.QwenImagePipeline.__call__.example",$$slots:{default:[mi]},$$scope:{ctx:j}}}),Qe=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImagePipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L359"}}),Je=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImagePipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L386"}}),Ue=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImagePipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L346"}}),Pe=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImagePipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L372"}}),je=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImagePipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L226"}}),Ce=new D({props:{title:"QwenImageImg2ImgPipeline",local:"diffusers.QwenImageImg2ImgPipeline",headingTag:"h2"}}),Ee=new v({props:{name:"class diffusers.QwenImageImg2ImgPipeline",anchor:"diffusers.QwenImageImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L134"}}),Le=new v({props:{name:"__call__",anchor:"diffusers.QwenImageImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L525",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),K=new mt({props:{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.example",$$slots:{default:[gi]},$$scope:{ctx:j}}}),We=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L408"}}),Ze=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageImg2ImgPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L435"}}),qe=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L395"}}),Ve=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageImg2ImgPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L421"}}),Ge=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L269"}}),Ne=new D({props:{title:"QwenImageInpaintPipeline",local:"diffusers.QwenImageInpaintPipeline",headingTag:"h2"}}),Be=new v({props:{name:"class diffusers.QwenImageInpaintPipeline",anchor:"diffusers.QwenImageInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L137"}}),Xe=new v({props:{name:"__call__",anchor:"diffusers.QwenImageInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will be generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L635",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),se=new mt({props:{anchor:"diffusers.QwenImageInpaintPipeline.__call__.example",$$slots:{default:[ui]},$$scope:{ctx:j}}}),De=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L435"}}),Re=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L462"}}),ze=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L422"}}),He=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L448"}}),Fe=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L280"}}),Ae=new D({props:{title:"QwenImageEditPipeline",local:"diffusers.QwenImageEditPipeline",headingTag:"h2"}}),Ye=new v({props:{name:"class diffusers.QwenImageEditPipeline",anchor:"diffusers.QwenImageEditPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"processor",val:": Qwen2VLProcessor"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageEditPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageEditPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageEditPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageEditPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L165"}}),Se=new v({props:{name:"__call__",anchor:"diffusers.QwenImageEditPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageEditPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
true_cfg_scale (<code>float</code>, <em>optional</em>, defaults to 1.0): Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free
Diffusion Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of
equation 2. of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is
enabled by setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale
encourages to generate images that are closely linked to the text <code>prompt</code>, usually at the expense of
lower image quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageEditPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageEditPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageEditPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageEditPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageEditPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageEditPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageEditPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageEditPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageEditPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageEditPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageEditPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageEditPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageEditPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageEditPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageEditPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L547",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),de=new mt({props:{anchor:"diffusers.QwenImageEditPipeline.__call__.example",$$slots:{default:[fi]},$$scope:{ctx:j}}}),Oe=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageEditPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L432"}}),Ke=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageEditPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L459"}}),en=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageEditPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L419"}}),nn=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageEditPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L445"}}),tn=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageEditPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
image to be encoded`,name:"image"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L274"}}),an=new D({props:{title:"QwenImageEditInpaintPipeline",local:"diffusers.QwenImageEditInpaintPipeline",headingTag:"h2"}}),sn=new v({props:{name:"class diffusers.QwenImageEditInpaintPipeline",anchor:"diffusers.QwenImageEditInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"processor",val:": Qwen2VLProcessor"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageEditInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageEditInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageEditInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageEditInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageEditInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L167"}}),on=new v({props:{name:"__call__",anchor:"diffusers.QwenImageEditInpaintPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
true_cfg_scale (<code>float</code>, <em>optional</em>, defaults to 1.0): Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free
Diffusion Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of
equation 2. of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is
enabled by setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale
encourages to generate images that are closely linked to the text <code>prompt</code>, usually at the expense of
lower image quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L679",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),ue=new mt({props:{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.example",$$slots:{default:[hi]},$$scope:{ctx:j}}}),rn=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageEditInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L477"}}),ln=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageEditInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L504"}}),dn=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageEditInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L464"}}),pn=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageEditInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L490"}}),cn=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
image to be encoded`,name:"image"},{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L285"}}),mn=new D({props:{title:"QwenImaggeControlNetPipeline",local:"qwenimaggecontrolnetpipeline",headingTag:"h2"}}),un=new D({props:{title:"QwenImagePipelineOutput",local:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",headingTag:"h2"}}),fn=new v({props:{name:"class diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",anchor:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_output.py#L11"}}),hn=new di({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/qwenimage.md"}}),{c(){d=i("meta"),x=t(),b=i("p"),_=t(),p(T.$$.fragment),r=t(),M=i("div"),M.innerHTML=us,gt=t(),be=i("p"),be.textContent=fs,ut=t(),ye=i("p"),ye.textContent=hs,ft=t(),Ie=i("table"),Ie.innerHTML=_s,ht=t(),p(R.$$.fragment),_t=t(),p(ve.$$.fragment),wt=t(),Te=i("p"),Te.innerHTML=ws,bt=t(),z=i("details"),Tn=i("summary"),Tn.textContent=bs,na=t(),p(Me.$$.fragment),yt=t(),p(H.$$.fragment),It=t(),p(xe.$$.fragment),vt=t(),$=i("div"),p($e.$$.fragment),ta=t(),Mn=i("p"),Mn.textContent=ys,aa=t(),Z=i("div"),p(ke.$$.fragment),sa=t(),xn=i("p"),xn.textContent=Is,ia=t(),p(F.$$.fragment),oa=t(),A=i("div"),p(Qe.$$.fragment),ra=t(),$n=i("p"),$n.innerHTML=vs,la=t(),Y=i("div"),p(Je.$$.fragment),da=t(),kn=i("p"),kn.innerHTML=Ts,pa=t(),S=i("div"),p(Ue.$$.fragment),ca=t(),Qn=i("p"),Qn.textContent=Ms,ma=t(),O=i("div"),p(Pe.$$.fragment),ga=t(),Jn=i("p"),Jn.textContent=xs,ua=t(),Un=i("div"),p(je.$$.fragment),Tt=t(),p(Ce.$$.fragment),Mt=t(),k=i("div"),p(Ee.$$.fragment),fa=t(),Pn=i("p"),Pn.textContent=$s,ha=t(),q=i("div"),p(Le.$$.fragment),_a=t(),jn=i("p"),jn.textContent=ks,wa=t(),p(K.$$.fragment),ba=t(),ee=i("div"),p(We.$$.fragment),ya=t(),Cn=i("p"),Cn.innerHTML=Qs,Ia=t(),ne=i("div"),p(Ze.$$.fragment),va=t(),En=i("p"),En.innerHTML=Js,Ta=t(),te=i("div"),p(qe.$$.fragment),Ma=t(),Ln=i("p"),Ln.textContent=Us,xa=t(),ae=i("div"),p(Ve.$$.fragment),$a=t(),Wn=i("p"),Wn.textContent=Ps,ka=t(),Zn=i("div"),p(Ge.$$.fragment),xt=t(),p(Ne.$$.fragment),$t=t(),Q=i("div"),p(Be.$$.fragment),Qa=t(),qn=i("p"),qn.textContent=js,Ja=t(),V=i("div"),p(Xe.$$.fragment),Ua=t(),Vn=i("p"),Vn.textContent=Cs,Pa=t(),p(se.$$.fragment),ja=t(),ie=i("div"),p(De.$$.fragment),Ca=t(),Gn=i("p"),Gn.innerHTML=Es,Ea=t(),oe=i("div"),p(Re.$$.fragment),La=t(),Nn=i("p"),Nn.innerHTML=Ls,Wa=t(),re=i("div"),p(ze.$$.fragment),Za=t(),Bn=i("p"),Bn.textContent=Ws,qa=t(),le=i("div"),p(He.$$.fragment),Va=t(),Xn=i("p"),Xn.textContent=Zs,Ga=t(),Dn=i("div"),p(Fe.$$.fragment),kt=t(),p(Ae.$$.fragment),Qt=t(),J=i("div"),p(Ye.$$.fragment),Na=t(),Rn=i("p"),Rn.textContent=qs,Ba=t(),G=i("div"),p(Se.$$.fragment),Xa=t(),zn=i("p"),zn.textContent=Vs,Da=t(),p(de.$$.fragment),Ra=t(),pe=i("div"),p(Oe.$$.fragment),za=t(),Hn=i("p"),Hn.innerHTML=Gs,Ha=t(),ce=i("div"),p(Ke.$$.fragment),Fa=t(),Fn=i("p"),Fn.innerHTML=Ns,Aa=t(),me=i("div"),p(en.$$.fragment),Ya=t(),An=i("p"),An.textContent=Bs,Sa=t(),ge=i("div"),p(nn.$$.fragment),Oa=t(),Yn=i("p"),Yn.textContent=Xs,Ka=t(),Sn=i("div"),p(tn.$$.fragment),Jt=t(),p(an.$$.fragment),Ut=t(),U=i("div"),p(sn.$$.fragment),es=t(),On=i("p"),On.textContent=Ds,ns=t(),N=i("div"),p(on.$$.fragment),ts=t(),Kn=i("p"),Kn.textContent=Rs,as=t(),p(ue.$$.fragment),ss=t(),fe=i("div"),p(rn.$$.fragment),is=t(),et=i("p"),et.innerHTML=zs,os=t(),he=i("div"),p(ln.$$.fragment),rs=t(),nt=i("p"),nt.innerHTML=Hs,ls=t(),_e=i("div"),p(dn.$$.fragment),ds=t(),tt=i("p"),tt.textContent=Fs,ps=t(),we=i("div"),p(pn.$$.fragment),cs=t(),at=i("p"),at.textContent=As,ms=t(),st=i("div"),p(cn.$$.fragment),Pt=t(),p(mn.$$.fragment),jt=t(),gn=i("ul"),gn.innerHTML=Ys,Ct=t(),p(un.$$.fragment),Et=t(),B=i("div"),p(fn.$$.fragment),gs=t(),it=i("p"),it.textContent=Ss,Lt=t(),p(hn.$$.fragment),Wt=t(),ct=i("p"),this.h()},l(e){const l=li("svelte-u9bgzb",document.head);d=o(l,"META",{name:!0,content:!0}),l.forEach(s),x=a(e),b=o(e,"P",{}),y(b).forEach(s),_=a(e),c(T.$$.fragment,e),r=a(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),w(M)!=="svelte-si9ct8"&&(M.innerHTML=us),gt=a(e),be=o(e,"P",{"data-svelte-h":!0}),w(be)!=="svelte-f9n2hx"&&(be.textContent=fs),ut=a(e),ye=o(e,"P",{"data-svelte-h":!0}),w(ye)!=="svelte-1t9xj8p"&&(ye.textContent=hs),ft=a(e),Ie=o(e,"TABLE",{"data-svelte-h":!0}),w(Ie)!=="svelte-h5rfp5"&&(Ie.innerHTML=_s),ht=a(e),c(R.$$.fragment,e),_t=a(e),c(ve.$$.fragment,e),wt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),w(Te)!=="svelte-upho6n"&&(Te.innerHTML=ws),bt=a(e),z=o(e,"DETAILS",{});var _n=y(z);Tn=o(_n,"SUMMARY",{"data-svelte-h":!0}),w(Tn)!=="svelte-14caxiv"&&(Tn.textContent=bs),na=a(_n),c(Me.$$.fragment,_n),_n.forEach(s),yt=a(e),c(H.$$.fragment,e),It=a(e),c(xe.$$.fragment,e),vt=a(e),$=o(e,"DIV",{class:!0});var P=y($);c($e.$$.fragment,P),ta=a(P),Mn=o(P,"P",{"data-svelte-h":!0}),w(Mn)!=="svelte-1b1rx25"&&(Mn.textContent=ys),aa=a(P),Z=o(P,"DIV",{class:!0});var X=y(Z);c(ke.$$.fragment,X),sa=a(X),xn=o(X,"P",{"data-svelte-h":!0}),w(xn)!=="svelte-v78lg8"&&(xn.textContent=Is),ia=a(X),c(F.$$.fragment,X),X.forEach(s),oa=a(P),A=o(P,"DIV",{class:!0});var wn=y(A);c(Qe.$$.fragment,wn),ra=a(wn),$n=o(wn,"P",{"data-svelte-h":!0}),w($n)!=="svelte-1s3c06i"&&($n.innerHTML=vs),wn.forEach(s),la=a(P),Y=o(P,"DIV",{class:!0});var bn=y(Y);c(Je.$$.fragment,bn),da=a(bn),kn=o(bn,"P",{"data-svelte-h":!0}),w(kn)!=="svelte-pkn4ui"&&(kn.innerHTML=Ts),bn.forEach(s),pa=a(P),S=o(P,"DIV",{class:!0});var yn=y(S);c(Ue.$$.fragment,yn),ca=a(yn),Qn=o(yn,"P",{"data-svelte-h":!0}),w(Qn)!=="svelte-14bnrb6"&&(Qn.textContent=Ms),yn.forEach(s),ma=a(P),O=o(P,"DIV",{class:!0});var In=y(O);c(Pe.$$.fragment,In),ga=a(In),Jn=o(In,"P",{"data-svelte-h":!0}),w(Jn)!=="svelte-1xwrf7t"&&(Jn.textContent=xs),In.forEach(s),ua=a(P),Un=o(P,"DIV",{class:!0});var Os=y(Un);c(je.$$.fragment,Os),Os.forEach(s),P.forEach(s),Tt=a(e),c(Ce.$$.fragment,e),Mt=a(e),k=o(e,"DIV",{class:!0});var C=y(k);c(Ee.$$.fragment,C),fa=a(C),Pn=o(C,"P",{"data-svelte-h":!0}),w(Pn)!=="svelte-1b1rx25"&&(Pn.textContent=$s),ha=a(C),q=o(C,"DIV",{class:!0});var ot=y(q);c(Le.$$.fragment,ot),_a=a(ot),jn=o(ot,"P",{"data-svelte-h":!0}),w(jn)!=="svelte-v78lg8"&&(jn.textContent=ks),wa=a(ot),c(K.$$.fragment,ot),ot.forEach(s),ba=a(C),ee=o(C,"DIV",{class:!0});var qt=y(ee);c(We.$$.fragment,qt),ya=a(qt),Cn=o(qt,"P",{"data-svelte-h":!0}),w(Cn)!=="svelte-1s3c06i"&&(Cn.innerHTML=Qs),qt.forEach(s),Ia=a(C),ne=o(C,"DIV",{class:!0});var Vt=y(ne);c(Ze.$$.fragment,Vt),va=a(Vt),En=o(Vt,"P",{"data-svelte-h":!0}),w(En)!=="svelte-pkn4ui"&&(En.innerHTML=Js),Vt.forEach(s),Ta=a(C),te=o(C,"DIV",{class:!0});var Gt=y(te);c(qe.$$.fragment,Gt),Ma=a(Gt),Ln=o(Gt,"P",{"data-svelte-h":!0}),w(Ln)!=="svelte-14bnrb6"&&(Ln.textContent=Us),Gt.forEach(s),xa=a(C),ae=o(C,"DIV",{class:!0});var Nt=y(ae);c(Ve.$$.fragment,Nt),$a=a(Nt),Wn=o(Nt,"P",{"data-svelte-h":!0}),w(Wn)!=="svelte-1xwrf7t"&&(Wn.textContent=Ps),Nt.forEach(s),ka=a(C),Zn=o(C,"DIV",{class:!0});var Ks=y(Zn);c(Ge.$$.fragment,Ks),Ks.forEach(s),C.forEach(s),xt=a(e),c(Ne.$$.fragment,e),$t=a(e),Q=o(e,"DIV",{class:!0});var E=y(Q);c(Be.$$.fragment,E),Qa=a(E),qn=o(E,"P",{"data-svelte-h":!0}),w(qn)!=="svelte-1b1rx25"&&(qn.textContent=js),Ja=a(E),V=o(E,"DIV",{class:!0});var rt=y(V);c(Xe.$$.fragment,rt),Ua=a(rt),Vn=o(rt,"P",{"data-svelte-h":!0}),w(Vn)!=="svelte-v78lg8"&&(Vn.textContent=Cs),Pa=a(rt),c(se.$$.fragment,rt),rt.forEach(s),ja=a(E),ie=o(E,"DIV",{class:!0});var Bt=y(ie);c(De.$$.fragment,Bt),Ca=a(Bt),Gn=o(Bt,"P",{"data-svelte-h":!0}),w(Gn)!=="svelte-1s3c06i"&&(Gn.innerHTML=Es),Bt.forEach(s),Ea=a(E),oe=o(E,"DIV",{class:!0});var Xt=y(oe);c(Re.$$.fragment,Xt),La=a(Xt),Nn=o(Xt,"P",{"data-svelte-h":!0}),w(Nn)!=="svelte-pkn4ui"&&(Nn.innerHTML=Ls),Xt.forEach(s),Wa=a(E),re=o(E,"DIV",{class:!0});var Dt=y(re);c(ze.$$.fragment,Dt),Za=a(Dt),Bn=o(Dt,"P",{"data-svelte-h":!0}),w(Bn)!=="svelte-14bnrb6"&&(Bn.textContent=Ws),Dt.forEach(s),qa=a(E),le=o(E,"DIV",{class:!0});var Rt=y(le);c(He.$$.fragment,Rt),Va=a(Rt),Xn=o(Rt,"P",{"data-svelte-h":!0}),w(Xn)!=="svelte-1xwrf7t"&&(Xn.textContent=Zs),Rt.forEach(s),Ga=a(E),Dn=o(E,"DIV",{class:!0});var ei=y(Dn);c(Fe.$$.fragment,ei),ei.forEach(s),E.forEach(s),kt=a(e),c(Ae.$$.fragment,e),Qt=a(e),J=o(e,"DIV",{class:!0});var L=y(J);c(Ye.$$.fragment,L),Na=a(L),Rn=o(L,"P",{"data-svelte-h":!0}),w(Rn)!=="svelte-cjiar3"&&(Rn.textContent=qs),Ba=a(L),G=o(L,"DIV",{class:!0});var lt=y(G);c(Se.$$.fragment,lt),Xa=a(lt),zn=o(lt,"P",{"data-svelte-h":!0}),w(zn)!=="svelte-v78lg8"&&(zn.textContent=Vs),Da=a(lt),c(de.$$.fragment,lt),lt.forEach(s),Ra=a(L),pe=o(L,"DIV",{class:!0});var zt=y(pe);c(Oe.$$.fragment,zt),za=a(zt),Hn=o(zt,"P",{"data-svelte-h":!0}),w(Hn)!=="svelte-1s3c06i"&&(Hn.innerHTML=Gs),zt.forEach(s),Ha=a(L),ce=o(L,"DIV",{class:!0});var Ht=y(ce);c(Ke.$$.fragment,Ht),Fa=a(Ht),Fn=o(Ht,"P",{"data-svelte-h":!0}),w(Fn)!=="svelte-pkn4ui"&&(Fn.innerHTML=Ns),Ht.forEach(s),Aa=a(L),me=o(L,"DIV",{class:!0});var Ft=y(me);c(en.$$.fragment,Ft),Ya=a(Ft),An=o(Ft,"P",{"data-svelte-h":!0}),w(An)!=="svelte-14bnrb6"&&(An.textContent=Bs),Ft.forEach(s),Sa=a(L),ge=o(L,"DIV",{class:!0});var At=y(ge);c(nn.$$.fragment,At),Oa=a(At),Yn=o(At,"P",{"data-svelte-h":!0}),w(Yn)!=="svelte-1xwrf7t"&&(Yn.textContent=Xs),At.forEach(s),Ka=a(L),Sn=o(L,"DIV",{class:!0});var ni=y(Sn);c(tn.$$.fragment,ni),ni.forEach(s),L.forEach(s),Jt=a(e),c(an.$$.fragment,e),Ut=a(e),U=o(e,"DIV",{class:!0});var W=y(U);c(sn.$$.fragment,W),es=a(W),On=o(W,"P",{"data-svelte-h":!0}),w(On)!=="svelte-cjiar3"&&(On.textContent=Ds),ns=a(W),N=o(W,"DIV",{class:!0});var dt=y(N);c(on.$$.fragment,dt),ts=a(dt),Kn=o(dt,"P",{"data-svelte-h":!0}),w(Kn)!=="svelte-v78lg8"&&(Kn.textContent=Rs),as=a(dt),c(ue.$$.fragment,dt),dt.forEach(s),ss=a(W),fe=o(W,"DIV",{class:!0});var Yt=y(fe);c(rn.$$.fragment,Yt),is=a(Yt),et=o(Yt,"P",{"data-svelte-h":!0}),w(et)!=="svelte-1s3c06i"&&(et.innerHTML=zs),Yt.forEach(s),os=a(W),he=o(W,"DIV",{class:!0});var St=y(he);c(ln.$$.fragment,St),rs=a(St),nt=o(St,"P",{"data-svelte-h":!0}),w(nt)!=="svelte-pkn4ui"&&(nt.innerHTML=Hs),St.forEach(s),ls=a(W),_e=o(W,"DIV",{class:!0});var Ot=y(_e);c(dn.$$.fragment,Ot),ds=a(Ot),tt=o(Ot,"P",{"data-svelte-h":!0}),w(tt)!=="svelte-14bnrb6"&&(tt.textContent=Fs),Ot.forEach(s),ps=a(W),we=o(W,"DIV",{class:!0});var Kt=y(we);c(pn.$$.fragment,Kt),cs=a(Kt),at=o(Kt,"P",{"data-svelte-h":!0}),w(at)!=="svelte-1xwrf7t"&&(at.textContent=As),Kt.forEach(s),ms=a(W),st=o(W,"DIV",{class:!0});var ti=y(st);c(cn.$$.fragment,ti),ti.forEach(s),W.forEach(s),Pt=a(e),c(mn.$$.fragment,e),jt=a(e),gn=o(e,"UL",{"data-svelte-h":!0}),w(gn)!=="svelte-1p6h59i"&&(gn.innerHTML=Ys),Ct=a(e),c(un.$$.fragment,e),Et=a(e),B=o(e,"DIV",{class:!0});var ea=y(B);c(fn.$$.fragment,ea),gs=a(ea),it=o(ea,"P",{"data-svelte-h":!0}),w(it)!=="svelte-1qpjiuf"&&(it.textContent=Ss),ea.forEach(s),Lt=a(e),c(hn.$$.fragment,e),Wt=a(e),ct=o(e,"P",{}),y(ct).forEach(s),this.h()},h(){I(d,"name","hf:doc:metadata"),I(d,"content",wi),I(M,"class","flex flex-wrap space-x-1"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){n(document.head,d),h(e,x,l),h(e,b,l),h(e,_,l),m(T,e,l),h(e,r,l),h(e,M,l),h(e,gt,l),h(e,be,l),h(e,ut,l),h(e,ye,l),h(e,ft,l),h(e,Ie,l),h(e,ht,l),m(R,e,l),h(e,_t,l),m(ve,e,l),h(e,wt,l),h(e,Te,l),h(e,bt,l),h(e,z,l),n(z,Tn),n(z,na),m(Me,z,null),h(e,yt,l),m(H,e,l),h(e,It,l),m(xe,e,l),h(e,vt,l),h(e,$,l),m($e,$,null),n($,ta),n($,Mn),n($,aa),n($,Z),m(ke,Z,null),n(Z,sa),n(Z,xn),n(Z,ia),m(F,Z,null),n($,oa),n($,A),m(Qe,A,null),n(A,ra),n(A,$n),n($,la),n($,Y),m(Je,Y,null),n(Y,da),n(Y,kn),n($,pa),n($,S),m(Ue,S,null),n(S,ca),n(S,Qn),n($,ma),n($,O),m(Pe,O,null),n(O,ga),n(O,Jn),n($,ua),n($,Un),m(je,Un,null),h(e,Tt,l),m(Ce,e,l),h(e,Mt,l),h(e,k,l),m(Ee,k,null),n(k,fa),n(k,Pn),n(k,ha),n(k,q),m(Le,q,null),n(q,_a),n(q,jn),n(q,wa),m(K,q,null),n(k,ba),n(k,ee),m(We,ee,null),n(ee,ya),n(ee,Cn),n(k,Ia),n(k,ne),m(Ze,ne,null),n(ne,va),n(ne,En),n(k,Ta),n(k,te),m(qe,te,null),n(te,Ma),n(te,Ln),n(k,xa),n(k,ae),m(Ve,ae,null),n(ae,$a),n(ae,Wn),n(k,ka),n(k,Zn),m(Ge,Zn,null),h(e,xt,l),m(Ne,e,l),h(e,$t,l),h(e,Q,l),m(Be,Q,null),n(Q,Qa),n(Q,qn),n(Q,Ja),n(Q,V),m(Xe,V,null),n(V,Ua),n(V,Vn),n(V,Pa),m(se,V,null),n(Q,ja),n(Q,ie),m(De,ie,null),n(ie,Ca),n(ie,Gn),n(Q,Ea),n(Q,oe),m(Re,oe,null),n(oe,La),n(oe,Nn),n(Q,Wa),n(Q,re),m(ze,re,null),n(re,Za),n(re,Bn),n(Q,qa),n(Q,le),m(He,le,null),n(le,Va),n(le,Xn),n(Q,Ga),n(Q,Dn),m(Fe,Dn,null),h(e,kt,l),m(Ae,e,l),h(e,Qt,l),h(e,J,l),m(Ye,J,null),n(J,Na),n(J,Rn),n(J,Ba),n(J,G),m(Se,G,null),n(G,Xa),n(G,zn),n(G,Da),m(de,G,null),n(J,Ra),n(J,pe),m(Oe,pe,null),n(pe,za),n(pe,Hn),n(J,Ha),n(J,ce),m(Ke,ce,null),n(ce,Fa),n(ce,Fn),n(J,Aa),n(J,me),m(en,me,null),n(me,Ya),n(me,An),n(J,Sa),n(J,ge),m(nn,ge,null),n(ge,Oa),n(ge,Yn),n(J,Ka),n(J,Sn),m(tn,Sn,null),h(e,Jt,l),m(an,e,l),h(e,Ut,l),h(e,U,l),m(sn,U,null),n(U,es),n(U,On),n(U,ns),n(U,N),m(on,N,null),n(N,ts),n(N,Kn),n(N,as),m(ue,N,null),n(U,ss),n(U,fe),m(rn,fe,null),n(fe,is),n(fe,et),n(U,os),n(U,he),m(ln,he,null),n(he,rs),n(he,nt),n(U,ls),n(U,_e),m(dn,_e,null),n(_e,ds),n(_e,tt),n(U,ps),n(U,we),m(pn,we,null),n(we,cs),n(we,at),n(U,ms),n(U,st),m(cn,st,null),h(e,Pt,l),m(mn,e,l),h(e,jt,l),h(e,gn,l),h(e,Ct,l),m(un,e,l),h(e,Et,l),h(e,B,l),m(fn,B,null),n(B,gs),n(B,it),h(e,Lt,l),m(hn,e,l),h(e,Wt,l),h(e,ct,l),Zt=!0},p(e,[l]){const _n={};l&2&&(_n.$$scope={dirty:l,ctx:e}),R.$set(_n);const P={};l&2&&(P.$$scope={dirty:l,ctx:e}),H.$set(P);const X={};l&2&&(X.$$scope={dirty:l,ctx:e}),F.$set(X);const wn={};l&2&&(wn.$$scope={dirty:l,ctx:e}),K.$set(wn);const bn={};l&2&&(bn.$$scope={dirty:l,ctx:e}),se.$set(bn);const yn={};l&2&&(yn.$$scope={dirty:l,ctx:e}),de.$set(yn);const In={};l&2&&(In.$$scope={dirty:l,ctx:e}),ue.$set(In)},i(e){Zt||(g(T.$$.fragment,e),g(R.$$.fragment,e),g(ve.$$.fragment,e),g(Me.$$.fragment,e),g(H.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(ke.$$.fragment,e),g(F.$$.fragment,e),g(Qe.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(Pe.$$.fragment,e),g(je.$$.fragment,e),g(Ce.$$.fragment,e),g(Ee.$$.fragment,e),g(Le.$$.fragment,e),g(K.$$.fragment,e),g(We.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(Ge.$$.fragment,e),g(Ne.$$.fragment,e),g(Be.$$.fragment,e),g(Xe.$$.fragment,e),g(se.$$.fragment,e),g(De.$$.fragment,e),g(Re.$$.fragment,e),g(ze.$$.fragment,e),g(He.$$.fragment,e),g(Fe.$$.fragment,e),g(Ae.$$.fragment,e),g(Ye.$$.fragment,e),g(Se.$$.fragment,e),g(de.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(en.$$.fragment,e),g(nn.$$.fragment,e),g(tn.$$.fragment,e),g(an.$$.fragment,e),g(sn.$$.fragment,e),g(on.$$.fragment,e),g(ue.$$.fragment,e),g(rn.$$.fragment,e),g(ln.$$.fragment,e),g(dn.$$.fragment,e),g(pn.$$.fragment,e),g(cn.$$.fragment,e),g(mn.$$.fragment,e),g(un.$$.fragment,e),g(fn.$$.fragment,e),g(hn.$$.fragment,e),Zt=!0)},o(e){u(T.$$.fragment,e),u(R.$$.fragment,e),u(ve.$$.fragment,e),u(Me.$$.fragment,e),u(H.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(ke.$$.fragment,e),u(F.$$.fragment,e),u(Qe.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(Pe.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(K.$$.fragment,e),u(We.$$.fragment,e),u(Ze.$$.fragment,e),u(qe.$$.fragment,e),u(Ve.$$.fragment,e),u(Ge.$$.fragment,e),u(Ne.$$.fragment,e),u(Be.$$.fragment,e),u(Xe.$$.fragment,e),u(se.$$.fragment,e),u(De.$$.fragment,e),u(Re.$$.fragment,e),u(ze.$$.fragment,e),u(He.$$.fragment,e),u(Fe.$$.fragment,e),u(Ae.$$.fragment,e),u(Ye.$$.fragment,e),u(Se.$$.fragment,e),u(de.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(en.$$.fragment,e),u(nn.$$.fragment,e),u(tn.$$.fragment,e),u(an.$$.fragment,e),u(sn.$$.fragment,e),u(on.$$.fragment,e),u(ue.$$.fragment,e),u(rn.$$.fragment,e),u(ln.$$.fragment,e),u(dn.$$.fragment,e),u(pn.$$.fragment,e),u(cn.$$.fragment,e),u(mn.$$.fragment,e),u(un.$$.fragment,e),u(fn.$$.fragment,e),u(hn.$$.fragment,e),Zt=!1},d(e){e&&(s(x),s(b),s(_),s(r),s(M),s(gt),s(be),s(ut),s(ye),s(ft),s(Ie),s(ht),s(_t),s(wt),s(Te),s(bt),s(z),s(yt),s(It),s(vt),s($),s(Tt),s(Mt),s(k),s(xt),s($t),s(Q),s(kt),s(Qt),s(J),s(Jt),s(Ut),s(U),s(Pt),s(jt),s(gn),s(Ct),s(Et),s(B),s(Lt),s(Wt),s(ct)),s(d),f(T,e),f(R,e),f(ve,e),f(Me),f(H,e),f(xe,e),f($e),f(ke),f(F),f(Qe),f(Je),f(Ue),f(Pe),f(je),f(Ce,e),f(Ee),f(Le),f(K),f(We),f(Ze),f(qe),f(Ve),f(Ge),f(Ne,e),f(Be),f(Xe),f(se),f(De),f(Re),f(ze),f(He),f(Fe),f(Ae,e),f(Ye),f(Se),f(de),f(Oe),f(Ke),f(en),f(nn),f(tn),f(an,e),f(sn),f(on),f(ue),f(rn),f(ln),f(dn),f(pn),f(cn),f(mn,e),f(un,e),f(fn),f(hn,e)}}}const wi='{"title":"QwenImage","local":"qwenimage","sections":[{"title":"LoRA for faster inference","local":"lora-for-faster-inference","sections":[],"depth":2},{"title":"QwenImagePipeline","local":"diffusers.QwenImagePipeline","sections":[],"depth":2},{"title":"QwenImageImg2ImgPipeline","local":"diffusers.QwenImageImg2ImgPipeline","sections":[],"depth":2},{"title":"QwenImageInpaintPipeline","local":"diffusers.QwenImageInpaintPipeline","sections":[],"depth":2},{"title":"QwenImageEditPipeline","local":"diffusers.QwenImageEditPipeline","sections":[],"depth":2},{"title":"QwenImageEditInpaintPipeline","local":"diffusers.QwenImageEditInpaintPipeline","sections":[],"depth":2},{"title":"QwenImaggeControlNetPipeline","local":"qwenimaggecontrolnetpipeline","sections":[],"depth":2},{"title":"QwenImagePipelineOutput","local":"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function bi(j){return ii(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ki extends oi{constructor(d){super(),ri(this,d,bi,_i,si,{})}}export{ki as component};
