import{s as ut,o as gt,n as he}from"../chunks/scheduler.8c3d61f6.js";import{S as ht,i as _t,g as c,s as r,r as b,A as bt,h as d,f as o,c as p,j as J,u as y,x as U,k as D,y as a,a as f,v,d as w,t as $,w as x}from"../chunks/index.da70eac4.js";import{T as Ye}from"../chunks/Tip.1d9b8c37.js";import{D as E}from"../chunks/Docstring.2187c15d.js";import{C as et}from"../chunks/CodeBlock.a9c4becf.js";import{E as Oe}from"../chunks/ExampleCodeBlock.56cd5e98.js";import{H as Ke,E as yt}from"../chunks/getInferenceSnippets.676f6ee5.js";function vt(M){let n,_='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',l,s,u='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=c("p"),n.innerHTML=_,l=r(),s=c("p"),s.innerHTML=u},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-1j961ct"&&(n.innerHTML=_),l=p(t),s=d(t,"P",{"data-svelte-h":!0}),U(s)!=="svelte-z4pn9c"&&(s.innerHTML=u)},m(t,h){f(t,n,h),f(t,l,h),f(t,s,h)},p:he,d(t){t&&(o(n),o(l),o(s))}}}function wt(M){let n,_="Examples:",l,s,u;return s=new et({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teDQtdXBzY2FsZXIlMjIlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwbGV0J3MlMjBkb3dubG9hZCUyMGFuJTIwJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2QyLXVwc2NhbGUlMkZsb3dfcmVzX2NhdC5wbmclMjIlMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBbG93X3Jlc19pbWclMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWxvd19yZXNfaW1nJTIwJTNEJTIwbG93X3Jlc19pbWcucmVzaXplKCgxMjglMkMlMjAxMjgpKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjB3aGl0ZSUyMGNhdCUyMiUwQSUwQXVwc2NhbGVkX2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rsb3dfcmVzX2ltZykuaW1hZ2VzJTVCMCU1RCUwQXVwc2NhbGVkX2ltYWdlLnNhdmUoJTIydXBzYW1wbGVkX2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model and scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionUpscalePipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an  image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd2-upscale/low_res_cat.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = low_res_img.resize((<span class="hljs-number">128</span>, <span class="hljs-number">128</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a white cat&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = pipeline(prompt=prompt, image=low_res_img).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;upsampled_cat.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,l=r(),b(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=_),l=p(t),y(s.$$.fragment,t)},m(t,h){f(t,n,h),f(t,l,h),v(s,t,h),u=!0},p:he,i(t){u||(w(s.$$.fragment,t),u=!0)},o(t){$(s.$$.fragment,t),u=!1},d(t){t&&(o(n),o(l)),x(s,t)}}}function $t(M){let n,_=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=c("p"),n.innerHTML=_},l(l){n=d(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-ackzsn"&&(n.innerHTML=_)},m(l,s){f(l,n,s)},p:he,d(l){l&&o(n)}}}function xt(M){let n,_="Examples:",l,s,u;return s=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,l=r(),b(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=_),l=p(t),y(s.$$.fragment,t)},m(t,h){f(t,n,h),f(t,l,h),v(s,t,h),u=!0},p:he,i(t){u||(w(s.$$.fragment,t),u=!0)},o(t){$(s.$$.fragment,t),u=!1},d(t){t&&(o(n),o(l)),x(s,t)}}}function Ut(M){let n,_=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=c("p"),n.textContent=_},l(l){n=d(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-17p1lpg"&&(n.textContent=_)},m(l,s){f(l,n,s)},p:he,d(l){l&&o(n)}}}function Mt(M){let n,_="Examples:",l,s,u;return s=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,l=r(),b(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=_),l=p(t),y(s.$$.fragment,t)},m(t,h){f(t,n,h),f(t,l,h),v(s,t,h),u=!0},p:he,i(t){u||(w(s.$$.fragment,t),u=!0)},o(t){$(s.$$.fragment,t),u=!1},d(t){t&&(o(n),o(l)),x(s,t)}}}function Tt(M){let n,_,l,s,u,t,h,tt='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',be,R,nt='The Stable Diffusion upscaler diffusion model was created by the researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. It is used to enhance the resolution of input images by a factor of 4.',ye,Z,ve,A,we,m,F,Pe,oe,st="Pipeline for text-guided image super-resolution using Stable Diffusion 2.",De,ie,at=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ce,le,ot="The pipeline also inherits the following loading methods:",Je,re,it='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',ke,C,H,je,pe,lt="The call function to the pipeline for generation.",Ze,G,Ge,T,q,Le,ce,rt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,We,L,Ne,W,Ve,N,Q,Xe,de,pt=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Be,I,Y,ze,fe,ct=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Ee,V,Re,X,Ae,B,O,Fe,me,dt='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',He,z,K,qe,ue,ft="Encodes the prompt into text encoder hidden states.",$e,ee,xe,k,te,Qe,ge,mt="Output class for Stable Diffusion pipelines.",Ue,ne,Me,_e,Te;return u=new Ke({props:{title:"Super-resolution",local:"super-resolution",headingTag:"h1"}}),Z=new Ye({props:{$$slots:{default:[vt]},$$scope:{ctx:M}}}),A=new Ke({props:{title:"StableDiffusionUpscalePipeline",local:"diffusers.StableDiffusionUpscalePipeline",headingTag:"h2"}}),F=new E({props:{name:"class diffusers.StableDiffusionUpscalePipeline",anchor:"diffusers.StableDiffusionUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"low_res_scheduler",val:": DDPMScheduler"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": typing.Optional[typing.Any] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.image_processing_clip.CLIPImageProcessor] = None"},{name:"watermarker",val:": typing.Optional[typing.Any] = None"},{name:"max_noise_level",val:": int = 350"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionUpscalePipeline.low_res_scheduler",description:`<strong>low_res_scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler used to add initial noise to the low resolution conditioning image. It must be an instance of
<a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>.`,name:"low_res_scheduler"},{anchor:"diffusers.StableDiffusionUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L82"}}),H=new E({props:{name:"__call__",anchor:"diffusers.StableDiffusionUpscalePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"noise_level",val:": int = 20"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled.`,name:"image"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L548",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new Oe({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.example",$$slots:{default:[wt]},$$scope:{ctx:M}}}),q=new E({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1995"}}),L=new Ye({props:{warning:!0,$$slots:{default:[$t]},$$scope:{ctx:M}}}),W=new Oe({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[xt]},$$scope:{ctx:M}}}),Q=new E({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2035"}}),Y=new E({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1934"}}),V=new Ye({props:{warning:!0,$$slots:{default:[Ut]},$$scope:{ctx:M}}}),X=new Oe({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Mt]},$$scope:{ctx:M}}}),O=new E({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1969"}}),K=new E({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L221"}}),ee=new Ke({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),te=new E({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),ne=new yt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/upscale.md"}}),{c(){n=c("meta"),_=r(),l=c("p"),s=r(),b(u.$$.fragment),t=r(),h=c("div"),h.innerHTML=tt,be=r(),R=c("p"),R.innerHTML=nt,ye=r(),b(Z.$$.fragment),ve=r(),b(A.$$.fragment),we=r(),m=c("div"),b(F.$$.fragment),Pe=r(),oe=c("p"),oe.textContent=st,De=r(),ie=c("p"),ie.innerHTML=at,Ce=r(),le=c("p"),le.textContent=ot,Je=r(),re=c("ul"),re.innerHTML=it,ke=r(),C=c("div"),b(H.$$.fragment),je=r(),pe=c("p"),pe.textContent=lt,Ze=r(),b(G.$$.fragment),Ge=r(),T=c("div"),b(q.$$.fragment),Le=r(),ce=c("p"),ce.textContent=rt,We=r(),b(L.$$.fragment),Ne=r(),b(W.$$.fragment),Ve=r(),N=c("div"),b(Q.$$.fragment),Xe=r(),de=c("p"),de.innerHTML=pt,Be=r(),I=c("div"),b(Y.$$.fragment),ze=r(),fe=c("p"),fe.innerHTML=ct,Ee=r(),b(V.$$.fragment),Re=r(),b(X.$$.fragment),Ae=r(),B=c("div"),b(O.$$.fragment),Fe=r(),me=c("p"),me.innerHTML=dt,He=r(),z=c("div"),b(K.$$.fragment),qe=r(),ue=c("p"),ue.textContent=ft,$e=r(),b(ee.$$.fragment),xe=r(),k=c("div"),b(te.$$.fragment),Qe=r(),ge=c("p"),ge.textContent=mt,Ue=r(),b(ne.$$.fragment),Me=r(),_e=c("p"),this.h()},l(e){const i=bt("svelte-u9bgzb",document.head);n=d(i,"META",{name:!0,content:!0}),i.forEach(o),_=p(e),l=d(e,"P",{}),J(l).forEach(o),s=p(e),y(u.$$.fragment,e),t=p(e),h=d(e,"DIV",{class:!0,"data-svelte-h":!0}),U(h)!=="svelte-si9ct8"&&(h.innerHTML=tt),be=p(e),R=d(e,"P",{"data-svelte-h":!0}),U(R)!=="svelte-1rmru20"&&(R.innerHTML=nt),ye=p(e),y(Z.$$.fragment,e),ve=p(e),y(A.$$.fragment,e),we=p(e),m=d(e,"DIV",{class:!0});var g=J(m);y(F.$$.fragment,g),Pe=p(g),oe=d(g,"P",{"data-svelte-h":!0}),U(oe)!=="svelte-gmgvzq"&&(oe.textContent=st),De=p(g),ie=d(g,"P",{"data-svelte-h":!0}),U(ie)!=="svelte-496sm0"&&(ie.innerHTML=at),Ce=p(g),le=d(g,"P",{"data-svelte-h":!0}),U(le)!=="svelte-14s6m4u"&&(le.textContent=ot),Je=p(g),re=d(g,"UL",{"data-svelte-h":!0}),U(re)!=="svelte-1m94ukp"&&(re.innerHTML=it),ke=p(g),C=d(g,"DIV",{class:!0});var j=J(C);y(H.$$.fragment,j),je=p(j),pe=d(j,"P",{"data-svelte-h":!0}),U(pe)!=="svelte-50j04k"&&(pe.textContent=lt),Ze=p(j),y(G.$$.fragment,j),j.forEach(o),Ge=p(g),T=d(g,"DIV",{class:!0});var S=J(T);y(q.$$.fragment,S),Le=p(S),ce=d(S,"P",{"data-svelte-h":!0}),U(ce)!=="svelte-10jaql7"&&(ce.textContent=rt),We=p(S),y(L.$$.fragment,S),Ne=p(S),y(W.$$.fragment,S),S.forEach(o),Ve=p(g),N=d(g,"DIV",{class:!0});var se=J(N);y(Q.$$.fragment,se),Xe=p(se),de=d(se,"P",{"data-svelte-h":!0}),U(de)!=="svelte-1lh0nh5"&&(de.innerHTML=pt),se.forEach(o),Be=p(g),I=d(g,"DIV",{class:!0});var P=J(I);y(Y.$$.fragment,P),ze=p(P),fe=d(P,"P",{"data-svelte-h":!0}),U(fe)!=="svelte-e03q3e"&&(fe.innerHTML=ct),Ee=p(P),y(V.$$.fragment,P),Re=p(P),y(X.$$.fragment,P),P.forEach(o),Ae=p(g),B=d(g,"DIV",{class:!0});var ae=J(B);y(O.$$.fragment,ae),Fe=p(ae),me=d(ae,"P",{"data-svelte-h":!0}),U(me)!=="svelte-1vfte1e"&&(me.innerHTML=dt),ae.forEach(o),He=p(g),z=d(g,"DIV",{class:!0});var Ie=J(z);y(K.$$.fragment,Ie),qe=p(Ie),ue=d(Ie,"P",{"data-svelte-h":!0}),U(ue)!=="svelte-16q0ax1"&&(ue.textContent=ft),Ie.forEach(o),g.forEach(o),$e=p(e),y(ee.$$.fragment,e),xe=p(e),k=d(e,"DIV",{class:!0});var Se=J(k);y(te.$$.fragment,Se),Qe=p(Se),ge=d(Se,"P",{"data-svelte-h":!0}),U(ge)!=="svelte-1qpjiuf"&&(ge.textContent=mt),Se.forEach(o),Ue=p(e),y(ne.$$.fragment,e),Me=p(e),_e=d(e,"P",{}),J(_e).forEach(o),this.h()},h(){D(n,"name","hf:doc:metadata"),D(n,"content",It),D(h,"class","flex flex-wrap space-x-1"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){a(document.head,n),f(e,_,i),f(e,l,i),f(e,s,i),v(u,e,i),f(e,t,i),f(e,h,i),f(e,be,i),f(e,R,i),f(e,ye,i),v(Z,e,i),f(e,ve,i),v(A,e,i),f(e,we,i),f(e,m,i),v(F,m,null),a(m,Pe),a(m,oe),a(m,De),a(m,ie),a(m,Ce),a(m,le),a(m,Je),a(m,re),a(m,ke),a(m,C),v(H,C,null),a(C,je),a(C,pe),a(C,Ze),v(G,C,null),a(m,Ge),a(m,T),v(q,T,null),a(T,Le),a(T,ce),a(T,We),v(L,T,null),a(T,Ne),v(W,T,null),a(m,Ve),a(m,N),v(Q,N,null),a(N,Xe),a(N,de),a(m,Be),a(m,I),v(Y,I,null),a(I,ze),a(I,fe),a(I,Ee),v(V,I,null),a(I,Re),v(X,I,null),a(m,Ae),a(m,B),v(O,B,null),a(B,Fe),a(B,me),a(m,He),a(m,z),v(K,z,null),a(z,qe),a(z,ue),f(e,$e,i),v(ee,e,i),f(e,xe,i),f(e,k,i),v(te,k,null),a(k,Qe),a(k,ge),f(e,Ue,i),v(ne,e,i),f(e,Me,i),f(e,_e,i),Te=!0},p(e,[i]){const g={};i&2&&(g.$$scope={dirty:i,ctx:e}),Z.$set(g);const j={};i&2&&(j.$$scope={dirty:i,ctx:e}),G.$set(j);const S={};i&2&&(S.$$scope={dirty:i,ctx:e}),L.$set(S);const se={};i&2&&(se.$$scope={dirty:i,ctx:e}),W.$set(se);const P={};i&2&&(P.$$scope={dirty:i,ctx:e}),V.$set(P);const ae={};i&2&&(ae.$$scope={dirty:i,ctx:e}),X.$set(ae)},i(e){Te||(w(u.$$.fragment,e),w(Z.$$.fragment,e),w(A.$$.fragment,e),w(F.$$.fragment,e),w(H.$$.fragment,e),w(G.$$.fragment,e),w(q.$$.fragment,e),w(L.$$.fragment,e),w(W.$$.fragment,e),w(Q.$$.fragment,e),w(Y.$$.fragment,e),w(V.$$.fragment,e),w(X.$$.fragment,e),w(O.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ne.$$.fragment,e),Te=!0)},o(e){$(u.$$.fragment,e),$(Z.$$.fragment,e),$(A.$$.fragment,e),$(F.$$.fragment,e),$(H.$$.fragment,e),$(G.$$.fragment,e),$(q.$$.fragment,e),$(L.$$.fragment,e),$(W.$$.fragment,e),$(Q.$$.fragment,e),$(Y.$$.fragment,e),$(V.$$.fragment,e),$(X.$$.fragment,e),$(O.$$.fragment,e),$(K.$$.fragment,e),$(ee.$$.fragment,e),$(te.$$.fragment,e),$(ne.$$.fragment,e),Te=!1},d(e){e&&(o(_),o(l),o(s),o(t),o(h),o(be),o(R),o(ye),o(ve),o(we),o(m),o($e),o(xe),o(k),o(Ue),o(Me),o(_e)),o(n),x(u,e),x(Z,e),x(A,e),x(F),x(H),x(G),x(q),x(L),x(W),x(Q),x(Y),x(V),x(X),x(O),x(K),x(ee,e),x(te),x(ne,e)}}}const It='{"title":"Super-resolution","local":"super-resolution","sections":[{"title":"StableDiffusionUpscalePipeline","local":"diffusers.StableDiffusionUpscalePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function St(M){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends ht{constructor(n){super(),_t(this,n,St,Tt,ut,{})}}export{Gt as component};
