import{s as Ze,n as ge,o as ke}from"../chunks/scheduler.8c3d61f6.js";import{S as Ge,i as Be,g as i,s as a,r as o,A as _e,h as p,f as l,c as n,j as Ie,u as M,x as c,k as Ce,y as Re,a as t,v as m,d as J,t as y,w as u}from"../chunks/index.da70eac4.js";import{C as N}from"../chunks/CodeBlock.a9c4becf.js";import{H as oe,E as Xe}from"../chunks/getInferenceSnippets.676f6ee5.js";function We(Me){let r,S,Q,E,w,$,h,me='A callback is a function that modifies <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> behavior and it is executed at the end of a denoising step. The changes are propagated to subsequent steps in the denoising process. It is useful for adjusting pipeline attributes or tensor variables to support new features without rewriting the underlying pipeline code.',x,b,Je='Diffusers provides several callbacks in the pipeline <a href="../api/pipelines/overview#callbacks">overview</a>.',F,f,ye="To enable a callback, configure when the callback is executed after a certain number of denoising steps with one of the following arguments.",H,T,ue="<li><code>cutoff_step_ratio</code> specifies when a callback is activated as a percentage of the total denoising steps.</li> <li><code>cutoff_step_index</code> specifies the exact step number a callback is activated.</li>",A,d,we='The example below uses <code>cutoff_step_ratio=0.4</code>, which means the callback is activated once denoising reaches 40% of the total inference steps. <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.callbacks.SDXLCFGCutoffCallback">SDXLCFGCutoffCallback</a> disables classifier-free guidance (CFG) after a certain number of steps, which can help save compute without significantly affecting performance.',z,U,he="Define a callback with either of the <code>cutoff</code> arguments and pass it to the <code>callback_on_step_end</code> parameter in the pipeline.",D,j,L,I,be='If you want to add a new official callback, feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> or <a href="https://huggingface.co/docs/diffusers/main/en/conceptual/contribution#how-to-open-a-pr" rel="nofollow">submit a PR</a>. Otherwise, you can also create your own callback as shown below.',q,C,P,Z,fe="Early stopping is useful if you aren’t happy with the intermediate results during generation. This callback sets a hardcoded stop point after which the pipeline terminates by setting the <code>_interrupt</code> attribute to <code>True</code>.",K,g,O,k,ee,G,Te="Visualizing the intermediate images is useful for progress monitoring and assessing the quality of the generated content. This callback decodes the latent tensors at each step and converts them to images.",se,B,de='<a href="https://huggingface.co/blog/TimothyAlexisVass/explaining-the-sdxl-latent-space" rel="nofollow">Convert</a> the Stable Diffusion XL latents from latents (4 channels) to RGB tensors (3 tensors).',le,_,te,R,Ue="Extract the latents and convert the first image in the batch to RGB. Save the image as a PNG file with the step number.",ae,X,ne,W,je="Use the <code>callback_on_step_end_tensor_inputs</code> parameter to specify what input type to modify, which in this case, are the latents.",ie,Y,pe,v,ce,V,re;return w=new oe({props:{title:"Pipeline callbacks",local:"pipeline-callbacks",headingTag:"h1"}}),j=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMuY2FsbGJhY2tzJTIwaW1wb3J0JTIwU0RYTENGR0N1dG9mZkNhbGxiYWNrJTBBJTBBY2FsbGJhY2slMjAlM0QlMjBTRFhMQ0ZHQ3V0b2ZmQ2FsbGJhY2soY3V0b2ZmX3N0ZXBfcmF0aW8lM0QwLjQpJTBBJTIzJTIwaWYlMjB1c2luZyUyMGN1dG9mZl9zdGVwX2luZGV4JTBBJTIzJTIwY2FsbGJhY2slMjAlM0QlMjBTRFhMQ0ZHQ3V0b2ZmQ2FsbGJhY2soY3V0b2ZmX3N0ZXBfcmF0aW8lM0ROb25lJTJDJTIwY3V0b2ZmX3N0ZXBfaW5kZXglM0QxMCklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnJTJDJTIwdXNlX2thcnJhc19zaWdtYXMlM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBzcG9ydHMlMjBjYXIlMjBhdCUyMHRoZSUyMHJvYWQlMkMlMjBiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTJDJTIwaGlnaCUyMGRldGFpbCUyQyUyMDhrJTIwcmVzb2x1dGlvbiUyMiUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENi41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tfb25fc3RlcF9lbmQlM0RjYWxsYmFjayUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler, StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> diffusers.callbacks <span class="hljs-keyword">import</span> SDXLCFGCutoffCallback

callback = SDXLCFGCutoffCallback(cutoff_step_ratio=<span class="hljs-number">0.4</span>)
<span class="hljs-comment"># if using cutoff_step_index</span>
<span class="hljs-comment"># callback = SDXLCFGCutoffCallback(cutoff_step_ratio=None, cutoff_step_index=10)</span>

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config, use_karras_sigmas=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;a sports car at the road, best quality, high quality, high detail, 8k resolution&quot;</span>
output = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    guidance_scale=<span class="hljs-number">6.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    callback_on_step_end=callback,
)`,wrap:!1}}),C=new oe({props:{title:"Early stopping",local:"early-stopping",headingTag:"h2"}}),g=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFkZWYlMjBpbnRlcnJ1cHRfY2FsbGJhY2socGlwZWxpbmUlMkMlMjBpJTJDJTIwdCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjBzdG9wX2lkeCUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNEJTNEJTIwc3RvcF9pZHglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZS5faW50ZXJydXB0JTIwJTNEJTIwVHJ1ZSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNhbGxiYWNrX2t3YXJncyUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBKSUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjA1MCUwQSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tfb25fc3RlcF9lbmQlM0RpbnRlcnJ1cHRfY2FsbGJhY2slMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">interrupt_callback</span>(<span class="hljs-params">pipeline, i, t, callback_kwargs</span>):
    stop_idx = <span class="hljs-number">10</span>
    <span class="hljs-keyword">if</span> i == stop_idx:
        pipeline._interrupt = <span class="hljs-literal">True</span>

    <span class="hljs-keyword">return</span> callback_kwargs

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
)
num_inference_steps = <span class="hljs-number">50</span>

pipeline(
    <span class="hljs-string">&quot;A photo of a cat&quot;</span>,
    num_inference_steps=num_inference_steps,
    callback_on_step_end=interrupt_callback,
)`,wrap:!1}}),k=new oe({props:{title:"Display intermediate images",local:"display-intermediate-images",headingTag:"h2"}}),_=new N({props:{code:"ZGVmJTIwbGF0ZW50c190b19yZ2IobGF0ZW50cyklM0ElMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCg2MCUyQyUyMC02MCUyQyUyMDI1JTJDJTIwLTcwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCg2MCUyQyUyMCUyMC01JTJDJTIwMTUlMkMlMjAtNTApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKDYwJTJDJTIwJTIwMTAlMkMlMjAtNSUyQyUyMC0zNSklMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwd2VpZ2h0c190ZW5zb3IlMjAlM0QlMjB0b3JjaC50KHRvcmNoLnRlbnNvcih3ZWlnaHRzJTJDJTIwZHR5cGUlM0RsYXRlbnRzLmR0eXBlKS50byhsYXRlbnRzLmRldmljZSkpJTBBJTIwJTIwJTIwJTIwYmlhc2VzX3RlbnNvciUyMCUzRCUyMHRvcmNoLnRlbnNvcigoMTUwJTJDJTIwMTQwJTJDJTIwMTMwKSUyQyUyMGR0eXBlJTNEbGF0ZW50cy5kdHlwZSkudG8obGF0ZW50cy5kZXZpY2UpJTBBJTIwJTIwJTIwJTIwcmdiX3RlbnNvciUyMCUzRCUyMHRvcmNoLmVpbnN1bSglMjIuLi5seHklMkNsciUyMC0lM0UlMjAuLi5yeHklMjIlMkMlMjBsYXRlbnRzJTJDJTIwd2VpZ2h0c190ZW5zb3IpJTIwJTJCJTIwYmlhc2VzX3RlbnNvci51bnNxdWVlemUoLTEpLnVuc3F1ZWV6ZSgtMSklMEElMjAlMjAlMjAlMjBpbWFnZV9hcnJheSUyMCUzRCUyMHJnYl90ZW5zb3IuY2xhbXAoMCUyQyUyMDI1NSkuYnl0ZSgpLmNwdSgpLm51bXB5KCkudHJhbnNwb3NlKDElMkMlMjAyJTJDJTIwMCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2VfYXJyYXkp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">latents_to_rgb</span>(<span class="hljs-params">latents</span>):
    weights = (
        (<span class="hljs-number">60</span>, -<span class="hljs-number">60</span>, <span class="hljs-number">25</span>, -<span class="hljs-number">70</span>),
        (<span class="hljs-number">60</span>,  -<span class="hljs-number">5</span>, <span class="hljs-number">15</span>, -<span class="hljs-number">50</span>),
        (<span class="hljs-number">60</span>,  <span class="hljs-number">10</span>, -<span class="hljs-number">5</span>, -<span class="hljs-number">35</span>),
    )

    weights_tensor = torch.t(torch.tensor(weights, dtype=latents.dtype).to(latents.device))
    biases_tensor = torch.tensor((<span class="hljs-number">150</span>, <span class="hljs-number">140</span>, <span class="hljs-number">130</span>), dtype=latents.dtype).to(latents.device)
    rgb_tensor = torch.einsum(<span class="hljs-string">&quot;...lxy,lr -&gt; ...rxy&quot;</span>, latents, weights_tensor) + biases_tensor.unsqueeze(-<span class="hljs-number">1</span>).unsqueeze(-<span class="hljs-number">1</span>)
    image_array = rgb_tensor.clamp(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>).byte().cpu().numpy().transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>)

    <span class="hljs-keyword">return</span> Image.fromarray(image_array)`,wrap:!1}}),X=new N({props:{code:"ZGVmJTIwZGVjb2RlX3RlbnNvcnMocGlwZSUyQyUyMHN0ZXAlMkMlMjB0aW1lc3RlcCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwY2FsbGJhY2tfa3dhcmdzJTVCJTIybGF0ZW50cyUyMiU1RCUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbGF0ZW50c190b19yZ2IobGF0ZW50cyU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyJTdCc3RlcCU3RC5wbmclMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2FsbGJhY2tfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_tensors</span>(<span class="hljs-params">pipe, step, timestep, callback_kwargs</span>):
    latents = callback_kwargs[<span class="hljs-string">&quot;latents&quot;</span>]

    image = latents_to_rgb(latents[<span class="hljs-number">0</span>])
    image.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{step}</span>.png&quot;</span>)

    <span class="hljs-keyword">return</span> callback_kwargs`,wrap:!1}}),Y=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY3JvaXNzYW50JTIwc2hhcGVkJTIwbGlrZSUyMGElMjBjdXRlJTIwYmVhci4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJEZWZvcm1lZCUyQyUyMHVnbHklMkMlMjBiYWQlMjBhbmF0b215JTIyJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tfb25fc3RlcF9lbmQlM0RkZWNvZGVfdGVuc29ycyUyQyUwQSUyMCUyMCUyMCUyMGNhbGxiYWNrX29uX3N0ZXBfZW5kX3RlbnNvcl9pbnB1dHMlM0QlNUIlMjJsYXRlbnRzJTIyJTVEJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A croissant shaped like a cute bear.&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;Deformed, ugly, bad anatomy&quot;</span>,
    callback_on_step_end=decode_tensors,
    callback_on_step_end_tensor_inputs=[<span class="hljs-string">&quot;latents&quot;</span>],
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),v=new Xe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/callback.md"}}),{c(){r=i("meta"),S=a(),Q=i("p"),E=a(),o(w.$$.fragment),$=a(),h=i("p"),h.innerHTML=me,x=a(),b=i("p"),b.innerHTML=Je,F=a(),f=i("p"),f.textContent=ye,H=a(),T=i("ul"),T.innerHTML=ue,A=a(),d=i("p"),d.innerHTML=we,z=a(),U=i("p"),U.innerHTML=he,D=a(),o(j.$$.fragment),L=a(),I=i("p"),I.innerHTML=be,q=a(),o(C.$$.fragment),P=a(),Z=i("p"),Z.innerHTML=fe,K=a(),o(g.$$.fragment),O=a(),o(k.$$.fragment),ee=a(),G=i("p"),G.textContent=Te,se=a(),B=i("p"),B.innerHTML=de,le=a(),o(_.$$.fragment),te=a(),R=i("p"),R.textContent=Ue,ae=a(),o(X.$$.fragment),ne=a(),W=i("p"),W.innerHTML=je,ie=a(),o(Y.$$.fragment),pe=a(),o(v.$$.fragment),ce=a(),V=i("p"),this.h()},l(e){const s=_e("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(l),S=n(e),Q=p(e,"P",{}),Ie(Q).forEach(l),E=n(e),M(w.$$.fragment,e),$=n(e),h=p(e,"P",{"data-svelte-h":!0}),c(h)!=="svelte-hbnqop"&&(h.innerHTML=me),x=n(e),b=p(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-ojd8jd"&&(b.innerHTML=Je),F=n(e),f=p(e,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1puxk48"&&(f.textContent=ye),H=n(e),T=p(e,"UL",{"data-svelte-h":!0}),c(T)!=="svelte-ql1nw"&&(T.innerHTML=ue),A=n(e),d=p(e,"P",{"data-svelte-h":!0}),c(d)!=="svelte-phft5u"&&(d.innerHTML=we),z=n(e),U=p(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-bql70l"&&(U.innerHTML=he),D=n(e),M(j.$$.fragment,e),L=n(e),I=p(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1g7gqh6"&&(I.innerHTML=be),q=n(e),M(C.$$.fragment,e),P=n(e),Z=p(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-lglh11"&&(Z.innerHTML=fe),K=n(e),M(g.$$.fragment,e),O=n(e),M(k.$$.fragment,e),ee=n(e),G=p(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-17g5q6n"&&(G.textContent=Te),se=n(e),B=p(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1siywo4"&&(B.innerHTML=de),le=n(e),M(_.$$.fragment,e),te=n(e),R=p(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1nccmmk"&&(R.textContent=Ue),ae=n(e),M(X.$$.fragment,e),ne=n(e),W=p(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-14l4d3"&&(W.innerHTML=je),ie=n(e),M(Y.$$.fragment,e),pe=n(e),M(v.$$.fragment,e),ce=n(e),V=p(e,"P",{}),Ie(V).forEach(l),this.h()},h(){Ce(r,"name","hf:doc:metadata"),Ce(r,"content",Ye)},m(e,s){Re(document.head,r),t(e,S,s),t(e,Q,s),t(e,E,s),m(w,e,s),t(e,$,s),t(e,h,s),t(e,x,s),t(e,b,s),t(e,F,s),t(e,f,s),t(e,H,s),t(e,T,s),t(e,A,s),t(e,d,s),t(e,z,s),t(e,U,s),t(e,D,s),m(j,e,s),t(e,L,s),t(e,I,s),t(e,q,s),m(C,e,s),t(e,P,s),t(e,Z,s),t(e,K,s),m(g,e,s),t(e,O,s),m(k,e,s),t(e,ee,s),t(e,G,s),t(e,se,s),t(e,B,s),t(e,le,s),m(_,e,s),t(e,te,s),t(e,R,s),t(e,ae,s),m(X,e,s),t(e,ne,s),t(e,W,s),t(e,ie,s),m(Y,e,s),t(e,pe,s),m(v,e,s),t(e,ce,s),t(e,V,s),re=!0},p:ge,i(e){re||(J(w.$$.fragment,e),J(j.$$.fragment,e),J(C.$$.fragment,e),J(g.$$.fragment,e),J(k.$$.fragment,e),J(_.$$.fragment,e),J(X.$$.fragment,e),J(Y.$$.fragment,e),J(v.$$.fragment,e),re=!0)},o(e){y(w.$$.fragment,e),y(j.$$.fragment,e),y(C.$$.fragment,e),y(g.$$.fragment,e),y(k.$$.fragment,e),y(_.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(v.$$.fragment,e),re=!1},d(e){e&&(l(S),l(Q),l(E),l($),l(h),l(x),l(b),l(F),l(f),l(H),l(T),l(A),l(d),l(z),l(U),l(D),l(L),l(I),l(q),l(P),l(Z),l(K),l(O),l(ee),l(G),l(se),l(B),l(le),l(te),l(R),l(ae),l(ne),l(W),l(ie),l(pe),l(ce),l(V)),l(r),u(w,e),u(j,e),u(C,e),u(g,e),u(k,e),u(_,e),u(X,e),u(Y,e),u(v,e)}}}const Ye='{"title":"Pipeline callbacks","local":"pipeline-callbacks","sections":[{"title":"Early stopping","local":"early-stopping","sections":[],"depth":2},{"title":"Display intermediate images","local":"display-intermediate-images","sections":[],"depth":2}],"depth":1}';function ve(Me){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends Ge{constructor(r){super(),Be(this,r,ve,We,Ze,{})}}export{Ee as component};
