import{s as Ka,o as Oa,n as Kt}from"../chunks/scheduler.182ea377.js";import{S as es,i as ls,g as i,s,r as o,A as ts,h as m,f as t,c as n,j as Pa,u as r,x as p,k as b,y as as,a,v as c,d,t as g,w as u}from"../chunks/index.abf12888.js";import{T as Pt}from"../chunks/Tip.230e2334.js";import{C as M}from"../chunks/CodeBlock.57fe6e13.js";import{D as ss}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as f}from"../chunks/Heading.16916d63.js";function ns(T){let y,h='You’ll notice throughout the guide, we use <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> and <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a>, to save memory and increase inference speed. If you’re using PyTorch 2.0, then you don’t need to call <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on your pipeline because it’ll already be using PyTorch 2.0’s native <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a>.';return{c(){y=i("p"),y.innerHTML=h},l(J){y=m(J,"P",{"data-svelte-h":!0}),p(y)!=="svelte-swwwd0"&&(y.innerHTML=h)},m(J,Z){a(J,y,Z)},p:Kt,d(J){J&&t(y)}}}function is(T){let y,h="It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in latent space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE.";return{c(){y=i("p"),y.innerHTML=h},l(J){y=m(J,"P",{"data-svelte-h":!0}),p(y)!=="svelte-185do9q"&&(y.innerHTML=h)},m(J,Z){a(J,y,Z)},p:Kt,d(J){J&&t(y)}}}function ms(T){let y,h="It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in <em>latent</em> space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE.";return{c(){y=i("p"),y.innerHTML=h},l(J){y=m(J,"P",{"data-svelte-h":!0}),p(y)!=="svelte-vp1871"&&(y.innerHTML=h)},m(J,Z){a(J,y,Z)},p:Kt,d(J){J&&t(y)}}}function ps(T){let y,h,J,Z,R,rl,$,cl,C,Ot='Image-to-image is similar to <a href="conditional_image_generation">text-to-image</a>, but in addition to a prompt, you can also pass an initial image as a starting point for the diffusion process. The initial image is encoded to latent space and noise is added to it. Then the latent diffusion model takes a prompt and the noisy latent image, predicts the added noise, and removes the predicted noise from the initial latent image to get the new latent image. Lastly, a decoder decodes the new latent image back into an image.',dl,Y,ea="With 🤗 Diffusers, this is as easy as 1-2-3:",gl,Q,la='<li>Load a checkpoint into the <a href="/docs/diffusers/v0.27.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> class; this pipeline automatically handles loading the correct pipeline class  based on the checkpoint:</li>',ul,S,yl,w,Ml,W,ta="<li>Load an image to pass to the pipeline:</li>",Jl,H,fl,U,aa="<li>Pass a prompt and image to the pipeline to generate an image:</li>",hl,z,bl,G,sa='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Zl,N,Tl,E,na='The most popular image-to-image models are <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">Stable Diffusion v1.5</a>, <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">Stable Diffusion XL (SDXL)</a>, and <a href="https://huggingface.co/kandinsky-community/kandinsky-2-2-decoder" rel="nofollow">Kandinsky 2.2</a>. The results from the Stable Diffusion and Kandinsky models vary due to their architecture differences and training process; you can generally expect SDXL to produce higher quality images than Stable Diffusion v1.5. Let’s take a quick look at how to use each of these models and compare their results.',wl,L,Wl,q,ia="Stable Diffusion v1.5 is a latent diffusion model initialized from an earlier checkpoint, and further finetuned for 595K steps on 512x512 images. To use this pipeline for image-to-image, you’ll need to prepare an initial image to pass to the pipeline. Then you can pass a prompt and the image to the pipeline to generate a new image:",Ul,D,Gl,j,ma='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdv1.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',jl,A,Il,P,pa='SDXL is a more powerful version of the Stable Diffusion model. It uses a larger base model, and an additional refiner model to increase the quality of the base model’s output. Read the <a href="sdxl">SDXL</a> guide for a more detailed walkthrough of how to use this model, and other techniques it uses to produce high quality images.',Bl,K,vl,I,oa='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Vl,O,xl,ee,ra="The Kandinsky model is different from the Stable Diffusion models because it uses an image prior model to create image embeddings. The embeddings help create a better alignment between text and images, allowing the latent diffusion model to generate better images.",_l,le,ca="The simplest way to use Kandinsky 2.2 is:",kl,te,Xl,B,da='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-kandinsky.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Fl,ae,Rl,se,ga="There are several important parameters you can configure in the pipeline that’ll affect the image generation process and image quality. Let’s take a closer look at what these parameters do and how changing them affects the output.",$l,ne,Cl,ie,ua="<code>strength</code> is one of the most important parameters to consider and it’ll have a huge impact on your generated image. It determines how much the generated image resembles the initial image. In other words:",Yl,me,ya="<li>📈 a higher <code>strength</code> value gives the model more “creativity” to generate an image that’s different from the initial image; a <code>strength</code> value of 1.0 means the initial image is more or less ignored</li> <li>📉 a lower <code>strength</code> value means the generated image is more similar to the initial image</li>",Ql,pe,Ma="The <code>strength</code> and <code>num_inference_steps</code> parameters are related because <code>strength</code> determines the number of noise steps to add. For example, if the <code>num_inference_steps</code> is 50 and <code>strength</code> is 0.8, then this means adding 40 (50 * 0.8) steps of noise to the initial image and then denoising for 40 steps to get the newly generated image.",Sl,oe,Hl,v,Ja='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-0.4.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.4</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-0.6.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.6</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-1.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 1.0</figcaption></div>',zl,re,Nl,ce,fa="The <code>guidance_scale</code> parameter is used to control how closely aligned the generated image and text prompt are. A higher <code>guidance_scale</code> value means your generated image is more aligned with the prompt, while a lower <code>guidance_scale</code> value means your generated image has more space to deviate from the prompt.",El,de,ha="You can combine <code>guidance_scale</code> with <code>strength</code> for even more precise control over how expressive the model is. For example, combine a high <code>strength + guidance_scale</code> for maximum creativity or use a combination of low <code>strength</code> and low <code>guidance_scale</code> to generate an image that resembles the initial image but is not as strictly bound to the prompt.",Ll,ge,ql,V,ba='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-0.1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 0.1</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-3.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 5.0</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-7.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 10.0</figcaption></div>',Dl,ue,Al,ye,Za="A negative prompt conditions the model to <em>not</em> include things in an image, and it can be used to improve image quality or modify an image. For example, you can improve image quality by including negative prompts like “poor details” or “blurry” to encourage the model to generate a higher quality image. Or you can modify an image by specifying things to exclude from an image.",Pl,Me,Kl,x,Ta='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-negative-1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative_prompt = &quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-negative-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative_prompt = &quot;jungle&quot;</figcaption></div>',Ol,Je,et,fe,wa="There are some other interesting ways you can use an image-to-image pipeline aside from just generating an image (although that is pretty cool too). You can take it a step further and chain it with other pipelines.",lt,he,tt,be,Wa="Chaining a text-to-image and image-to-image pipeline allows you to generate an image from text and use the generated image as the initial image for the image-to-image pipeline. This is useful if you want to generate an image entirely from scratch. For example, let’s chain a Stable Diffusion and a Kandinsky model.",at,Ze,Ua="Start by generating an image with the text-to-image pipeline:",st,Te,nt,we,Ga="Now you can pass this generated image to the image-to-image pipeline:",it,We,mt,Ue,pt,Ge,ja="You can also chain multiple image-to-image pipelines together to create more interesting images. This can be useful for iteratively performing style transfer on an image, generating short GIFs, restoring color to an image, or restoring missing areas of an image.",ot,je,Ia="Start by generating an image:",rt,Ie,ct,_,dt,Be,Ba='Pass the latent output from this pipeline to the next pipeline to generate an image in a <a href="https://huggingface.co/ogkalu/Comic-Diffusion" rel="nofollow">comic book art style</a>:',gt,ve,ut,Ve,va='Repeat one more time to generate the final image in a <a href="https://huggingface.co/kohbanye/pixel-art-style" rel="nofollow">pixel art style</a>:',yt,xe,Mt,_e,Jt,ke,Va="Another way you can chain your image-to-image pipeline is with an upscaler and super-resolution pipeline to really increase the level of details in an image.",ft,Xe,xa="Start with an image-to-image pipeline:",ht,Fe,bt,k,Zt,Re,_a="Chain it to an upscaler pipeline to increase the image resolution:",Tt,$e,wt,Ce,ka="Finally, chain it to a super-resolution pipeline to further enhance the resolution:",Wt,Ye,Ut,Qe,Gt,Se,Xa="Trying to generate an image that looks exactly the way you want can be difficult, which is why controlled generation techniques and models are so useful. While you can use the <code>negative_prompt</code> to partially control image generation, there are more robust methods like prompt weighting and ControlNets.",jt,He,It,ze,Fa='Prompt weighting allows you to scale the representation of each concept in a prompt. For example, in a prompt like “Astronaut in a jungle, cold color palette, muted colors, detailed, 8k”, you can choose to increase or decrease the embeddings of “astronaut” and “jungle”. The <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a> library provides a simple syntax for adjusting prompt weights and generating the embeddings. You can learn how to create the embeddings in the <a href="weighted_prompts">Prompt weighting</a> guide.',Bt,Ne,Ra='<a href="/docs/diffusers/v0.27.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> has a <code>prompt_embeds</code> (and <code>negative_prompt_embeds</code> if you’re using a negative prompt) parameter where you can pass the embeddings which replaces the <code>prompt</code> parameter.',vt,Ee,Vt,Le,xt,qe,$a="ControlNets provide a more flexible and accurate way to control image generation because you can use an additional conditioning image. The conditioning image can be a canny image, depth map, image segmentation, and even scribbles! Whatever type of conditioning image you choose, the ControlNet generates an image that preserves the information in it.",_t,De,Ca="For example, let’s condition an image with a depth map to keep the spatial information in the image.",kt,Ae,Xt,Pe,Ya='Load a ControlNet model conditioned on depth maps and the <a href="/docs/diffusers/v0.27.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a>:',Ft,Ke,Rt,Oe,Qa="Now generate a new image conditioned on the depth map, initial image, and prompt:",$t,el,Ct,X,Sa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/lllyasviel/control_v11f1p_sd15_depth/resolve/main/images/control.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ControlNet image</figcaption></div>',Yt,ll,Ha='Let’s apply a new <a href="https://huggingface.co/nitrosocke/elden-ring-diffusion" rel="nofollow">style</a> to the image generated from the ControlNet by chaining it with an image-to-image pipeline:',Qt,tl,St,F,za='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-elden-ring.png"/>',Ht,al,zt,sl,Na='Running diffusion models is computationally expensive and intensive, but with a few optimization tricks, it is entirely possible to run them on consumer and free-tier GPUs. For example, you can use a more memory-efficient form of attention such as PyTorch 2.0’s <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a> or <a href="../optimization/xformers">xFormers</a> (you can use one or the other, but there’s no need to use both). You can also offload the model to the GPU while the other pipeline components wait on the CPU.',Nt,nl,Et,il,Ea='With <a href="../optimization/torch2.0#torchcompile"><code>torch.compile</code></a>, you can boost your inference speed even more by wrapping your UNet with it:',Lt,ml,qt,pl,La='To learn more, take a look at the <a href="../optimization/memory">Reduce memory usage</a> and <a href="../optimization/torch2.0">Torch 2.0</a> guides.',Dt,ol,At;return R=new f({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h1"}}),$=new ss({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/img2img.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/img2img.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/img2img.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/img2img.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/img2img.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/img2img.ipynb"}]}}),S=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),w=new Pt({props:{$$slots:{default:[ns]},$$scope:{ctx:T}}}),H=new M({props:{code:"aW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY2F0LnBuZyUyMik=",highlighted:'init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)',wrap:!1}}),z=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),N=new f({props:{title:"Popular models",local:"popular-models",headingTag:"h2"}}),L=new f({props:{title:"Stable Diffusion v1.5",local:"stable-diffusion-v15",headingTag:"h3"}}),D=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),A=new f({props:{title:"Stable Diffusion XL (SDXL)",local:"stable-diffusion-xl-sdxl",headingTag:"h3"}}),K=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctc2R4bC1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjUpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),O=new f({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h3"}}),te=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ae=new f({props:{title:"Configure pipeline parameters",local:"configure-pipeline-parameters",headingTag:"h2"}}),ne=new f({props:{title:"Strength",local:"strength",headingTag:"h3"}}),oe=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjgpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.8</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),re=new f({props:{title:"Guidance scale",local:"guidance-scale",headingTag:"h3"}}),ge=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjApLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, guidance_scale=<span class="hljs-number">8.0</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ue=new f({props:{title:"Negative prompt",local:"negative-prompt",headingTag:"h3"}}),Me=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMnVnbHklMkMlMjBkZWZvcm1lZCUyQyUyMGRpc2ZpZ3VyZWQlMkMlMjBwb29yJTIwZGV0YWlscyUyQyUyMGJhZCUyMGFuYXRvbXklMjIlMEElMEElMjMlMjBwYXNzJTIwcHJvbXB0JTIwYW5kJTIwaW1hZ2UlMjB0byUyMHBpcGVsaW5lJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, negative_prompt=negative_prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Je=new f({props:{title:"Chained image-to-image pipelines",local:"chained-image-to-image-pipelines",headingTag:"h2"}}),he=new f({props:{title:"Text-to-image-to-image",local:"text-to-image-to-image",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEF0ZXh0MmltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMikuaW1hZ2VzJTVCMCU1RCUwQXRleHQyaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

text2image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>).images[<span class="hljs-number">0</span>]
text2image`,wrap:!1}}),We=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFpbWFnZTJpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBpbWFnZSUzRHRleHQyaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCdGV4dDJpbWFnZSUyQyUyMGltYWdlMmltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image2image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=text2image).images[<span class="hljs-number">0</span>]
make_image_grid([text2image, image2image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ue=new f({props:{title:"Image-to-image-to-image",local:"image-to-image-to-image",headingTag:"h3"}}),Ie=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_=new Pt({props:{$$slots:{default:[is]},$$scope:{ctx:T}}}),ve=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb2drYWx1JTJGQ29taWMtRGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbmVlZCUyMHRvJTIwaW5jbHVkZSUyMHRoZSUyMHRva2VuJTIwJTIyY2hhcmxpZWJvJTIwYXJ0c3R5bGUlMjIlMjBpbiUyMHRoZSUyMHByb21wdCUyMHRvJTIwdXNlJTIwdGhpcyUyMGNoZWNrcG9pbnQlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNoYXJsaWVibyUyMGFydHN0eWxlJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;ogkalu/Comic-Diffusion&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># need to include the token &quot;charliebo artstyle&quot; in the prompt to use this checkpoint</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, charliebo artstyle&quot;</span>, image=image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),xe=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya29oYmFueWUlMkZwaXhlbC1hcnQtc3R5bGUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBuZWVkJTIwdG8lMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJwaXhlbGFydHN0eWxlJTIyJTIwaW4lMjB0aGUlMjBwcm9tcHQlMjB0byUyMHVzZSUyMHRoaXMlMjBjaGVja3BvaW50JTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBwaXhlbGFydHN0eWxlJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kohbanye/pixel-art-style&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># need to include the token &quot;pixelartstyle&quot; in the prompt to use this checkpoint</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, pixelartstyle&quot;</span>, image=image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),_e=new f({props:{title:"Image-to-upscaler-to-super-resolution",local:"image-to-upscaler-to-super-resolution",headingTag:"h3"}}),Fe=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlXzElMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image_1 = pipeline(prompt, image=init_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),k=new Pt({props:{$$slots:{default:[ms]},$$scope:{ctx:T}}}),$e=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUwQSUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEF1cHNjYWxlci5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXVwc2NhbGVyLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2VfMiUyMCUzRCUyMHVwc2NhbGVyKHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2VfMSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline

upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
upscaler.enable_model_cpu_offload()
upscaler.enable_xformers_memory_efficient_attention()

image_2 = upscaler(prompt, image=image_1, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ye=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQSUwQXN1cGVyX3JlcyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXg0LXVwc2NhbGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXN1cGVyX3Jlcy5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXN1cGVyX3Jlcy5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlXzMlMjAlM0QlMjBzdXBlcl9yZXMocHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZV8yKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZV8zLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline

super_res = StableDiffusionUpscalePipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
super_res.enable_model_cpu_offload()
super_res.enable_xformers_memory_efficient_attention()

image_3 = super_res(prompt, image=image_2).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image_3.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Qe=new f({props:{title:"Control image generation",local:"control-image-generation",headingTag:"h2"}}),He=new f({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h3"}}),Ee=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjAlMjMlMjBnZW5lcmF0ZWQlMjBmcm9tJTIwQ29tcGVsJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0X2VtYmVkcyUzRG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlMkMlMjAlMjMlMjBnZW5lcmF0ZWQlMjBmcm9tJTIwQ29tcGVsJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt_embeds=prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    negative_prompt_embeds=negative_prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    image=init_image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Le=new f({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),Ae=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbWcyaW1nLWluaXQucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoOTU4JTJDJTIwOTYwKSklMjAlMjMlMjByZXNpemUlMjB0byUyMGRlcHRoJTIwaW1hZ2UlMjBkaW1lbnNpb25zJTBBZGVwdGhfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyRnJlc29sdmUlMkZtYWluJTJGaW1hZ2VzJTJGY29udHJvbC5wbmclMjIpJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)
init_image = init_image.resize((<span class="hljs-number">958</span>, <span class="hljs-number">960</span>)) <span class="hljs-comment"># resize to depth image dimensions</span>
depth_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11f1p_sd15_depth/resolve/main/images/control.png&quot;</span>)
make_image_grid([init_image, depth_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ke=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),el=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlX2NvbnRyb2xfbmV0JTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGRlcHRoX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyQyUyMGltYWdlX2NvbnRyb2xfbmV0JTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image_control_net = pipeline(prompt, image=init_image, control_image=depth_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, depth_image, image_control_net], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),tl=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybml0cm9zb2NrZSUyRmVsZGVuLXJpbmctZGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZWxkZW4lMjByaW5nJTIwc3R5bGUlMjBhc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMjIlMjAlMjMlMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJlbGRlbiUyMHJpbmclMjBzdHlsZSUyMiUyMGluJTIwdGhlJTIwcHJvbXB0JTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIydWdseSUyQyUyMGRlZm9ybWVkJTJDJTIwZGlzZmlndXJlZCUyQyUyMHBvb3IlMjBkZXRhaWxzJTJDJTIwYmFkJTIwYW5hdG9teSUyMiUwQSUwQWltYWdlX2VsZGVuX3JpbmclMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlX2NvbnRyb2xfbmV0JTJDJTIwc3RyZW5ndGglM0QwLjQ1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMC41KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyQyUyMGltYWdlX2NvbnRyb2xfbmV0JTJDJTIwaW1hZ2VfZWxkZW5fcmluZyU1RCUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDIp",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;nitrosocke/elden-ring-diffusion&quot;</span>, torch_dtype=torch.float16,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;elden ring style astronaut in a jungle&quot;</span> <span class="hljs-comment"># include the token &quot;elden ring style&quot; in the prompt</span>
negative_prompt = <span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>

image_elden_ring = pipeline(prompt, negative_prompt=negative_prompt, image=image_control_net, strength=<span class="hljs-number">0.45</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, depth_image, image_control_net, image_elden_ring], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),al=new f({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),nl=new M({props:{code:"JTJCJTIwcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipeline.enable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),ml=new M({props:{code:"cGlwZWxpbmUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:'pipeline.unet = torch.<span class="hljs-built_in">compile</span>(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){y=i("meta"),h=s(),J=i("p"),Z=s(),o(R.$$.fragment),rl=s(),o($.$$.fragment),cl=s(),C=i("p"),C.innerHTML=Ot,dl=s(),Y=i("p"),Y.textContent=ea,gl=s(),Q=i("ol"),Q.innerHTML=la,ul=s(),o(S.$$.fragment),yl=s(),o(w.$$.fragment),Ml=s(),W=i("ol"),W.innerHTML=ta,Jl=s(),o(H.$$.fragment),fl=s(),U=i("ol"),U.innerHTML=aa,hl=s(),o(z.$$.fragment),bl=s(),G=i("div"),G.innerHTML=sa,Zl=s(),o(N.$$.fragment),Tl=s(),E=i("p"),E.innerHTML=na,wl=s(),o(L.$$.fragment),Wl=s(),q=i("p"),q.textContent=ia,Ul=s(),o(D.$$.fragment),Gl=s(),j=i("div"),j.innerHTML=ma,jl=s(),o(A.$$.fragment),Il=s(),P=i("p"),P.innerHTML=pa,Bl=s(),o(K.$$.fragment),vl=s(),I=i("div"),I.innerHTML=oa,Vl=s(),o(O.$$.fragment),xl=s(),ee=i("p"),ee.textContent=ra,_l=s(),le=i("p"),le.textContent=ca,kl=s(),o(te.$$.fragment),Xl=s(),B=i("div"),B.innerHTML=da,Fl=s(),o(ae.$$.fragment),Rl=s(),se=i("p"),se.textContent=ga,$l=s(),o(ne.$$.fragment),Cl=s(),ie=i("p"),ie.innerHTML=ua,Yl=s(),me=i("ul"),me.innerHTML=ya,Ql=s(),pe=i("p"),pe.innerHTML=Ma,Sl=s(),o(oe.$$.fragment),Hl=s(),v=i("div"),v.innerHTML=Ja,zl=s(),o(re.$$.fragment),Nl=s(),ce=i("p"),ce.innerHTML=fa,El=s(),de=i("p"),de.innerHTML=ha,Ll=s(),o(ge.$$.fragment),ql=s(),V=i("div"),V.innerHTML=ba,Dl=s(),o(ue.$$.fragment),Al=s(),ye=i("p"),ye.innerHTML=Za,Pl=s(),o(Me.$$.fragment),Kl=s(),x=i("div"),x.innerHTML=Ta,Ol=s(),o(Je.$$.fragment),et=s(),fe=i("p"),fe.textContent=wa,lt=s(),o(he.$$.fragment),tt=s(),be=i("p"),be.textContent=Wa,at=s(),Ze=i("p"),Ze.textContent=Ua,st=s(),o(Te.$$.fragment),nt=s(),we=i("p"),we.textContent=Ga,it=s(),o(We.$$.fragment),mt=s(),o(Ue.$$.fragment),pt=s(),Ge=i("p"),Ge.textContent=ja,ot=s(),je=i("p"),je.textContent=Ia,rt=s(),o(Ie.$$.fragment),ct=s(),o(_.$$.fragment),dt=s(),Be=i("p"),Be.innerHTML=Ba,gt=s(),o(ve.$$.fragment),ut=s(),Ve=i("p"),Ve.innerHTML=va,yt=s(),o(xe.$$.fragment),Mt=s(),o(_e.$$.fragment),Jt=s(),ke=i("p"),ke.textContent=Va,ft=s(),Xe=i("p"),Xe.textContent=xa,ht=s(),o(Fe.$$.fragment),bt=s(),o(k.$$.fragment),Zt=s(),Re=i("p"),Re.textContent=_a,Tt=s(),o($e.$$.fragment),wt=s(),Ce=i("p"),Ce.textContent=ka,Wt=s(),o(Ye.$$.fragment),Ut=s(),o(Qe.$$.fragment),Gt=s(),Se=i("p"),Se.innerHTML=Xa,jt=s(),o(He.$$.fragment),It=s(),ze=i("p"),ze.innerHTML=Fa,Bt=s(),Ne=i("p"),Ne.innerHTML=Ra,vt=s(),o(Ee.$$.fragment),Vt=s(),o(Le.$$.fragment),xt=s(),qe=i("p"),qe.textContent=$a,_t=s(),De=i("p"),De.textContent=Ca,kt=s(),o(Ae.$$.fragment),Xt=s(),Pe=i("p"),Pe.innerHTML=Ya,Ft=s(),o(Ke.$$.fragment),Rt=s(),Oe=i("p"),Oe.textContent=Qa,$t=s(),o(el.$$.fragment),Ct=s(),X=i("div"),X.innerHTML=Sa,Yt=s(),ll=i("p"),ll.innerHTML=Ha,Qt=s(),o(tl.$$.fragment),St=s(),F=i("div"),F.innerHTML=za,Ht=s(),o(al.$$.fragment),zt=s(),sl=i("p"),sl.innerHTML=Na,Nt=s(),o(nl.$$.fragment),Et=s(),il=i("p"),il.innerHTML=Ea,Lt=s(),o(ml.$$.fragment),qt=s(),pl=i("p"),pl.innerHTML=La,Dt=s(),ol=i("p"),this.h()},l(e){const l=ts("svelte-u9bgzb",document.head);y=m(l,"META",{name:!0,content:!0}),l.forEach(t),h=n(e),J=m(e,"P",{}),Pa(J).forEach(t),Z=n(e),r(R.$$.fragment,e),rl=n(e),r($.$$.fragment,e),cl=n(e),C=m(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-190i437"&&(C.innerHTML=Ot),dl=n(e),Y=m(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-18jurtu"&&(Y.textContent=ea),gl=n(e),Q=m(e,"OL",{"data-svelte-h":!0}),p(Q)!=="svelte-1kbbl1p"&&(Q.innerHTML=la),ul=n(e),r(S.$$.fragment,e),yl=n(e),r(w.$$.fragment,e),Ml=n(e),W=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(W)!=="svelte-1yttwto"&&(W.innerHTML=ta),Jl=n(e),r(H.$$.fragment,e),fl=n(e),U=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(U)!=="svelte-17g0twj"&&(U.innerHTML=aa),hl=n(e),r(z.$$.fragment,e),bl=n(e),G=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-192ix8m"&&(G.innerHTML=sa),Zl=n(e),r(N.$$.fragment,e),Tl=n(e),E=m(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-aj9wzw"&&(E.innerHTML=na),wl=n(e),r(L.$$.fragment,e),Wl=n(e),q=m(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-23k6o9"&&(q.textContent=ia),Ul=n(e),r(D.$$.fragment,e),Gl=n(e),j=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-muzf0t"&&(j.innerHTML=ma),jl=n(e),r(A.$$.fragment,e),Il=n(e),P=m(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-x0iv90"&&(P.innerHTML=pa),Bl=n(e),r(K.$$.fragment,e),vl=n(e),I=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-1ki51a7"&&(I.innerHTML=oa),Vl=n(e),r(O.$$.fragment,e),xl=n(e),ee=m(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-c3e484"&&(ee.textContent=ra),_l=n(e),le=m(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-tfl439"&&(le.textContent=ca),kl=n(e),r(te.$$.fragment,e),Xl=n(e),B=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-1tge0cq"&&(B.innerHTML=da),Fl=n(e),r(ae.$$.fragment,e),Rl=n(e),se=m(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-j0fbzb"&&(se.textContent=ga),$l=n(e),r(ne.$$.fragment,e),Cl=n(e),ie=m(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1bx3wp7"&&(ie.innerHTML=ua),Yl=n(e),me=m(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-1oz5aud"&&(me.innerHTML=ya),Ql=n(e),pe=m(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-wy7ow0"&&(pe.innerHTML=Ma),Sl=n(e),r(oe.$$.fragment,e),Hl=n(e),v=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-1hvatx7"&&(v.innerHTML=Ja),zl=n(e),r(re.$$.fragment,e),Nl=n(e),ce=m(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-mfa26b"&&(ce.innerHTML=fa),El=n(e),de=m(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1629z5b"&&(de.innerHTML=ha),Ll=n(e),r(ge.$$.fragment,e),ql=n(e),V=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-k63kz7"&&(V.innerHTML=ba),Dl=n(e),r(ue.$$.fragment,e),Al=n(e),ye=m(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1qpoxoh"&&(ye.innerHTML=Za),Pl=n(e),r(Me.$$.fragment,e),Kl=n(e),x=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-1fvp45w"&&(x.innerHTML=Ta),Ol=n(e),r(Je.$$.fragment,e),et=n(e),fe=m(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-bxn4p5"&&(fe.textContent=wa),lt=n(e),r(he.$$.fragment,e),tt=n(e),be=m(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-xxuxjq"&&(be.textContent=Wa),at=n(e),Ze=m(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1edszux"&&(Ze.textContent=Ua),st=n(e),r(Te.$$.fragment,e),nt=n(e),we=m(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-3cniud"&&(we.textContent=Ga),it=n(e),r(We.$$.fragment,e),mt=n(e),r(Ue.$$.fragment,e),pt=n(e),Ge=m(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1r5hoyw"&&(Ge.textContent=ja),ot=n(e),je=m(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-19cg56z"&&(je.textContent=Ia),rt=n(e),r(Ie.$$.fragment,e),ct=n(e),r(_.$$.fragment,e),dt=n(e),Be=m(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-clpsz0"&&(Be.innerHTML=Ba),gt=n(e),r(ve.$$.fragment,e),ut=n(e),Ve=m(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-w98xng"&&(Ve.innerHTML=va),yt=n(e),r(xe.$$.fragment,e),Mt=n(e),r(_e.$$.fragment,e),Jt=n(e),ke=m(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1ojjd40"&&(ke.textContent=Va),ft=n(e),Xe=m(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-18merz0"&&(Xe.textContent=xa),ht=n(e),r(Fe.$$.fragment,e),bt=n(e),r(k.$$.fragment,e),Zt=n(e),Re=m(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-cmxlpu"&&(Re.textContent=_a),Tt=n(e),r($e.$$.fragment,e),wt=n(e),Ce=m(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-vr292z"&&(Ce.textContent=ka),Wt=n(e),r(Ye.$$.fragment,e),Ut=n(e),r(Qe.$$.fragment,e),Gt=n(e),Se=m(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-14io5mk"&&(Se.innerHTML=Xa),jt=n(e),r(He.$$.fragment,e),It=n(e),ze=m(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-10g432e"&&(ze.innerHTML=Fa),Bt=n(e),Ne=m(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1jzy8gw"&&(Ne.innerHTML=Ra),vt=n(e),r(Ee.$$.fragment,e),Vt=n(e),r(Le.$$.fragment,e),xt=n(e),qe=m(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1enrnw9"&&(qe.textContent=$a),_t=n(e),De=m(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1dqw2pd"&&(De.textContent=Ca),kt=n(e),r(Ae.$$.fragment,e),Xt=n(e),Pe=m(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1eqc9aw"&&(Pe.innerHTML=Ya),Ft=n(e),r(Ke.$$.fragment,e),Rt=n(e),Oe=m(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-kmdmdi"&&(Oe.textContent=Qa),$t=n(e),r(el.$$.fragment,e),Ct=n(e),X=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(X)!=="svelte-nm98y9"&&(X.innerHTML=Sa),Yt=n(e),ll=m(e,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-77whwd"&&(ll.innerHTML=Ha),Qt=n(e),r(tl.$$.fragment,e),St=n(e),F=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(F)!=="svelte-9lkq3b"&&(F.innerHTML=za),Ht=n(e),r(al.$$.fragment,e),zt=n(e),sl=m(e,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1abeb6"&&(sl.innerHTML=Na),Nt=n(e),r(nl.$$.fragment,e),Et=n(e),il=m(e,"P",{"data-svelte-h":!0}),p(il)!=="svelte-1bncb5f"&&(il.innerHTML=Ea),Lt=n(e),r(ml.$$.fragment,e),qt=n(e),pl=m(e,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-10imubo"&&(pl.innerHTML=La),Dt=n(e),ol=m(e,"P",{}),Pa(ol).forEach(t),this.h()},h(){b(y,"name","hf:doc:metadata"),b(y,"content",os),b(W,"start","2"),b(U,"start","3"),b(G,"class","flex gap-4"),b(j,"class","flex gap-4"),b(I,"class","flex gap-4"),b(B,"class","flex gap-4"),b(v,"class","flex flex-row gap-4"),b(V,"class","flex flex-row gap-4"),b(x,"class","flex flex-row gap-4"),b(X,"class","flex flex-row gap-4"),b(F,"class","flex justify-center")},m(e,l){as(document.head,y),a(e,h,l),a(e,J,l),a(e,Z,l),c(R,e,l),a(e,rl,l),c($,e,l),a(e,cl,l),a(e,C,l),a(e,dl,l),a(e,Y,l),a(e,gl,l),a(e,Q,l),a(e,ul,l),c(S,e,l),a(e,yl,l),c(w,e,l),a(e,Ml,l),a(e,W,l),a(e,Jl,l),c(H,e,l),a(e,fl,l),a(e,U,l),a(e,hl,l),c(z,e,l),a(e,bl,l),a(e,G,l),a(e,Zl,l),c(N,e,l),a(e,Tl,l),a(e,E,l),a(e,wl,l),c(L,e,l),a(e,Wl,l),a(e,q,l),a(e,Ul,l),c(D,e,l),a(e,Gl,l),a(e,j,l),a(e,jl,l),c(A,e,l),a(e,Il,l),a(e,P,l),a(e,Bl,l),c(K,e,l),a(e,vl,l),a(e,I,l),a(e,Vl,l),c(O,e,l),a(e,xl,l),a(e,ee,l),a(e,_l,l),a(e,le,l),a(e,kl,l),c(te,e,l),a(e,Xl,l),a(e,B,l),a(e,Fl,l),c(ae,e,l),a(e,Rl,l),a(e,se,l),a(e,$l,l),c(ne,e,l),a(e,Cl,l),a(e,ie,l),a(e,Yl,l),a(e,me,l),a(e,Ql,l),a(e,pe,l),a(e,Sl,l),c(oe,e,l),a(e,Hl,l),a(e,v,l),a(e,zl,l),c(re,e,l),a(e,Nl,l),a(e,ce,l),a(e,El,l),a(e,de,l),a(e,Ll,l),c(ge,e,l),a(e,ql,l),a(e,V,l),a(e,Dl,l),c(ue,e,l),a(e,Al,l),a(e,ye,l),a(e,Pl,l),c(Me,e,l),a(e,Kl,l),a(e,x,l),a(e,Ol,l),c(Je,e,l),a(e,et,l),a(e,fe,l),a(e,lt,l),c(he,e,l),a(e,tt,l),a(e,be,l),a(e,at,l),a(e,Ze,l),a(e,st,l),c(Te,e,l),a(e,nt,l),a(e,we,l),a(e,it,l),c(We,e,l),a(e,mt,l),c(Ue,e,l),a(e,pt,l),a(e,Ge,l),a(e,ot,l),a(e,je,l),a(e,rt,l),c(Ie,e,l),a(e,ct,l),c(_,e,l),a(e,dt,l),a(e,Be,l),a(e,gt,l),c(ve,e,l),a(e,ut,l),a(e,Ve,l),a(e,yt,l),c(xe,e,l),a(e,Mt,l),c(_e,e,l),a(e,Jt,l),a(e,ke,l),a(e,ft,l),a(e,Xe,l),a(e,ht,l),c(Fe,e,l),a(e,bt,l),c(k,e,l),a(e,Zt,l),a(e,Re,l),a(e,Tt,l),c($e,e,l),a(e,wt,l),a(e,Ce,l),a(e,Wt,l),c(Ye,e,l),a(e,Ut,l),c(Qe,e,l),a(e,Gt,l),a(e,Se,l),a(e,jt,l),c(He,e,l),a(e,It,l),a(e,ze,l),a(e,Bt,l),a(e,Ne,l),a(e,vt,l),c(Ee,e,l),a(e,Vt,l),c(Le,e,l),a(e,xt,l),a(e,qe,l),a(e,_t,l),a(e,De,l),a(e,kt,l),c(Ae,e,l),a(e,Xt,l),a(e,Pe,l),a(e,Ft,l),c(Ke,e,l),a(e,Rt,l),a(e,Oe,l),a(e,$t,l),c(el,e,l),a(e,Ct,l),a(e,X,l),a(e,Yt,l),a(e,ll,l),a(e,Qt,l),c(tl,e,l),a(e,St,l),a(e,F,l),a(e,Ht,l),c(al,e,l),a(e,zt,l),a(e,sl,l),a(e,Nt,l),c(nl,e,l),a(e,Et,l),a(e,il,l),a(e,Lt,l),c(ml,e,l),a(e,qt,l),a(e,pl,l),a(e,Dt,l),a(e,ol,l),At=!0},p(e,[l]){const qa={};l&2&&(qa.$$scope={dirty:l,ctx:e}),w.$set(qa);const Da={};l&2&&(Da.$$scope={dirty:l,ctx:e}),_.$set(Da);const Aa={};l&2&&(Aa.$$scope={dirty:l,ctx:e}),k.$set(Aa)},i(e){At||(d(R.$$.fragment,e),d($.$$.fragment,e),d(S.$$.fragment,e),d(w.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(ge.$$.fragment,e),d(ue.$$.fragment,e),d(Me.$$.fragment,e),d(Je.$$.fragment,e),d(he.$$.fragment,e),d(Te.$$.fragment,e),d(We.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d(_.$$.fragment,e),d(ve.$$.fragment,e),d(xe.$$.fragment,e),d(_e.$$.fragment,e),d(Fe.$$.fragment,e),d(k.$$.fragment,e),d($e.$$.fragment,e),d(Ye.$$.fragment,e),d(Qe.$$.fragment,e),d(He.$$.fragment,e),d(Ee.$$.fragment,e),d(Le.$$.fragment,e),d(Ae.$$.fragment,e),d(Ke.$$.fragment,e),d(el.$$.fragment,e),d(tl.$$.fragment,e),d(al.$$.fragment,e),d(nl.$$.fragment,e),d(ml.$$.fragment,e),At=!0)},o(e){g(R.$$.fragment,e),g($.$$.fragment,e),g(S.$$.fragment,e),g(w.$$.fragment,e),g(H.$$.fragment,e),g(z.$$.fragment,e),g(N.$$.fragment,e),g(L.$$.fragment,e),g(D.$$.fragment,e),g(A.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(Me.$$.fragment,e),g(Je.$$.fragment,e),g(he.$$.fragment,e),g(Te.$$.fragment,e),g(We.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(_.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(_e.$$.fragment,e),g(Fe.$$.fragment,e),g(k.$$.fragment,e),g($e.$$.fragment,e),g(Ye.$$.fragment,e),g(Qe.$$.fragment,e),g(He.$$.fragment,e),g(Ee.$$.fragment,e),g(Le.$$.fragment,e),g(Ae.$$.fragment,e),g(Ke.$$.fragment,e),g(el.$$.fragment,e),g(tl.$$.fragment,e),g(al.$$.fragment,e),g(nl.$$.fragment,e),g(ml.$$.fragment,e),At=!1},d(e){e&&(t(h),t(J),t(Z),t(rl),t(cl),t(C),t(dl),t(Y),t(gl),t(Q),t(ul),t(yl),t(Ml),t(W),t(Jl),t(fl),t(U),t(hl),t(bl),t(G),t(Zl),t(Tl),t(E),t(wl),t(Wl),t(q),t(Ul),t(Gl),t(j),t(jl),t(Il),t(P),t(Bl),t(vl),t(I),t(Vl),t(xl),t(ee),t(_l),t(le),t(kl),t(Xl),t(B),t(Fl),t(Rl),t(se),t($l),t(Cl),t(ie),t(Yl),t(me),t(Ql),t(pe),t(Sl),t(Hl),t(v),t(zl),t(Nl),t(ce),t(El),t(de),t(Ll),t(ql),t(V),t(Dl),t(Al),t(ye),t(Pl),t(Kl),t(x),t(Ol),t(et),t(fe),t(lt),t(tt),t(be),t(at),t(Ze),t(st),t(nt),t(we),t(it),t(mt),t(pt),t(Ge),t(ot),t(je),t(rt),t(ct),t(dt),t(Be),t(gt),t(ut),t(Ve),t(yt),t(Mt),t(Jt),t(ke),t(ft),t(Xe),t(ht),t(bt),t(Zt),t(Re),t(Tt),t(wt),t(Ce),t(Wt),t(Ut),t(Gt),t(Se),t(jt),t(It),t(ze),t(Bt),t(Ne),t(vt),t(Vt),t(xt),t(qe),t(_t),t(De),t(kt),t(Xt),t(Pe),t(Ft),t(Rt),t(Oe),t($t),t(Ct),t(X),t(Yt),t(ll),t(Qt),t(St),t(F),t(Ht),t(zt),t(sl),t(Nt),t(Et),t(il),t(Lt),t(qt),t(pl),t(Dt),t(ol)),t(y),u(R,e),u($,e),u(S,e),u(w,e),u(H,e),u(z,e),u(N,e),u(L,e),u(D,e),u(A,e),u(K,e),u(O,e),u(te,e),u(ae,e),u(ne,e),u(oe,e),u(re,e),u(ge,e),u(ue,e),u(Me,e),u(Je,e),u(he,e),u(Te,e),u(We,e),u(Ue,e),u(Ie,e),u(_,e),u(ve,e),u(xe,e),u(_e,e),u(Fe,e),u(k,e),u($e,e),u(Ye,e),u(Qe,e),u(He,e),u(Ee,e),u(Le,e),u(Ae,e),u(Ke,e),u(el,e),u(tl,e),u(al,e),u(nl,e),u(ml,e)}}}const os='{"title":"Image-to-image","local":"image-to-image","sections":[{"title":"Popular models","local":"popular-models","sections":[{"title":"Stable Diffusion v1.5","local":"stable-diffusion-v15","sections":[],"depth":3},{"title":"Stable Diffusion XL (SDXL)","local":"stable-diffusion-xl-sdxl","sections":[],"depth":3},{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[],"depth":3}],"depth":2},{"title":"Configure pipeline parameters","local":"configure-pipeline-parameters","sections":[{"title":"Strength","local":"strength","sections":[],"depth":3},{"title":"Guidance scale","local":"guidance-scale","sections":[],"depth":3},{"title":"Negative prompt","local":"negative-prompt","sections":[],"depth":3}],"depth":2},{"title":"Chained image-to-image pipelines","local":"chained-image-to-image-pipelines","sections":[{"title":"Text-to-image-to-image","local":"text-to-image-to-image","sections":[],"depth":3},{"title":"Image-to-image-to-image","local":"image-to-image-to-image","sections":[],"depth":3},{"title":"Image-to-upscaler-to-super-resolution","local":"image-to-upscaler-to-super-resolution","sections":[],"depth":3}],"depth":2},{"title":"Control image generation","local":"control-image-generation","sections":[{"title":"Prompt weighting","local":"prompt-weighting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3}],"depth":2},{"title":"Optimize","local":"optimize","sections":[],"depth":2}],"depth":1}';function rs(T){return Oa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends es{constructor(y){super(),ls(this,y,rs,ps,Ka,{})}}export{Js as component};
