import{s as me,n as ge,o as ce}from"../chunks/scheduler.12fdeddc.js";import{S as we,i as de,g as a,s,r as p,A as ye,h as o,f as i,c as n,j as fe,u as h,x as r,k as et,y as $e,a as l,v as u,d as f,t as m,w as g}from"../chunks/index.88dae322.js";import{C as tt}from"../chunks/CodeBlock.8e54a086.js";import{H as b,E as be}from"../chunks/getInferenceSnippets.00466244.js";function Me(Nt){let c,st,it,nt,M,at,T,Qt="These next sections highlight features and additional information that you may find useful to make the most out of the Git repositories on the Hugging Face Hub.",ot,v,rt,k,Rt='Hugging Face supports accessing repos with Python via the <a href="https://huggingface.co/docs/huggingface_hub/index" rel="nofollow"><code>huggingface_hub</code> library</a>. The operations that we’ve explored, such as downloading repositories and uploading files, are available through the library, as well as other useful functions!',pt,j,At="If you prefer to use git directly, please read the sections below.",ht,H,ut,x,Xt='A good place to visit if you want to continue learning about Git is <a href="https://learngitbranching.js.org/" rel="nofollow">this Git tutorial</a>. For even more background on Git, you can take a look at <a href="https://github.com/git-guides" rel="nofollow">GitHub’s Git Guides</a>.',ft,L,mt,G,qt='To effectively use Git repos collaboratively and to work on features without releasing premature code you can use <strong>branches</strong>. Branches allow you to separate your “work in progress” code from your “production-ready” code, with the additional benefit of letting multiple people work on a project without frequently conflicting with each others’ contributions. You can use branches to isolate experiments in their own branch, and even <a href="https://ericmjl.github.io/essays-on-data-science/workflow/gitflow/" rel="nofollow">adopt team-wide practices for managing branches</a>.',gt,C,Dt='To learn about Git branching, you can try out the <a href="https://learngitbranching.js.org/" rel="nofollow">Learn Git Branching interactive tutorial</a>.',ct,_,wt,J,Et='Git allows you to <em>tag</em> commits so that you can easily note milestones in your project. As such, you can use tags to mark commits in your Hub repos! To learn about using tags, you can visit <a href="https://devconnected.com/how-to-create-git-tags/" rel="nofollow">this DevConnected post</a>.',dt,Z,Ot='Beyond making it easy to identify important commits in your repo’s history, using Git tags also allows you to do A/B testing, <a href="https://www.techiedelight.com/clone-specific-tag-with-git/" rel="nofollow">clone a repository at a specific tag</a>, and more! The <code>huggingface_hub</code> library also supports working with tags, such as <a href="https://huggingface.co/docs/huggingface_hub/main/en/how-to-downstream#hfhuburl" rel="nofollow">downloading files from a specific tagged commit</a>.',yt,I,$t,U,Kt="If you’d like to copy a repository, depending on whether you want to preserve the Git history there are two options.",bt,W,Mt,F,te='In many scenarios, if you want your own copy of a particular codebase you might not be concerned about the previous Git history. In this case, you can quickly duplicate a repo with the handy <a href="https://huggingface.co/spaces/huggingface-projects/repo_duplicator" rel="nofollow">Repo Duplicator</a>! You’ll have to create a User Access Token, which you can read more about in the <a href="./security-tokens">security documentation</a>.',Tt,B,vt,Y,ee="A duplicate of a repository with the commit history preserved is called a <em>fork</em>. You may choose to fork one of your own repos, but it also common to fork other people’s projects if you would like to tinker with them.",kt,P,ie='<strong>Note that you will need to <a href="https://git-lfs.github.com/" rel="nofollow">install Git LFS</a> and the <a href="https://huggingface.co/docs/huggingface_hub/index" rel="nofollow"><code>huggingface_hub</code> CLI</a> to follow this process</strong>. When you want to fork or <a href="https://git-scm.com/docs/git-rebase" rel="nofollow">rebase</a> a repository with LFS files you cannot use the usual Git approach that you might be familiar with since you need to be careful to not break the LFS pointers. Forking can take time depending on your bandwidth because you will have to fetch and re-upload all the LFS files in your fork.',jt,S,le="For example, say you have an upstream repository, <strong>upstream</strong>, and you just created your own repository on the Hub which is <strong>myfork</strong> in this example.",Ht,z,se='<li><p>Create a destination repository (e.g. <strong>myfork</strong>) in <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a></p></li> <li><p>Clone your fork repository:</p></li>',xt,V,Lt,w,ne="<li>Fetch non-LFS files:</li>",Gt,N,Ct,d,ae="<li>Fetch large files. This can take some time depending on your download bandwidth:</li>",_t,Q,Jt,R,oe="4.a. If you want to completely override the fork history (which should only have an initial commit), run:",Zt,A,It,X,re="4.b. If you want to rebase instead of overriding, run the following command and resolve any conflicts:",Ut,q,Wt,y,pe="<li>Prepare your LFS files to push:</li>",Ft,D,Bt,$,he="<li>And finally push:</li>",Yt,E,Pt,O,ue="Now you have your own fork or rebased repo in the Hub!",St,K,zt,lt,Vt;return M=new b({props:{title:"Next Steps",local:"next-steps",headingTag:"h1"}}),v=new b({props:{title:"How to programmatically manage repositories",local:"how-to-programmatically-manage-repositories",headingTag:"h2"}}),H=new b({props:{title:"Learning more about Git",local:"learning-more-about-git",headingTag:"h2"}}),L=new b({props:{title:"How to use branches",local:"how-to-use-branches",headingTag:"h2"}}),_=new b({props:{title:"Using tags",local:"using-tags",headingTag:"h2"}}),I=new b({props:{title:"How to duplicate or fork a repo (including LFS pointers)",local:"how-to-duplicate-or-fork-a-repo-including-lfs-pointers",headingTag:"h2"}}),W=new b({props:{title:"Duplicating without Git history",local:"duplicating-without-git-history",headingTag:"h3"}}),B=new b({props:{title:"Duplicating with the Git history (Fork)",local:"duplicating-with-the-git-history-fork",headingTag:"h3"}}),V=new tt({props:{code:"Z2l0JTIwY2xvbmUlMjBnaXQlNDBoZi5jbyUzQW1lJTJGbXlmb3Jr",highlighted:'git <span class="hljs-keyword">clone</span> <span class="hljs-title">git</span>@hf.co:me/myfork',wrap:!1}}),N=new tt({props:{code:"Y2QlMjBteWZvcmslMEFnaXQlMjBsZnMlMjBpbnN0YWxsJTIwLS1za2lwLXNtdWRnZSUyMC0tbG9jYWwlMjAlMjMlMjBhZmZlY3RzJTIwb25seSUyMHRoaXMlMjBjbG9uZSUwQWdpdCUyMHJlbW90ZSUyMGFkZCUyMHVwc3RyZWFtJTIwZ2l0JTQwaGYuY28lM0FmcmllbmQlMkZ1cHN0cmVhbSUwQWdpdCUyMGZldGNoJTIwdXBzdHJlYW0=",highlighted:`<span class="hljs-built_in">cd</span> myfork
git lfs install --skip-smudge --<span class="hljs-built_in">local</span> <span class="hljs-comment"># affects only this clone</span>
git remote add upstream git@hf.co:friend/upstream
git fetch upstream`,wrap:!1}}),Q=new tt({props:{code:"Z2l0JTIwbGZzJTIwZmV0Y2glMjAtLWFsbCUyMHVwc3RyZWFtJTIwJTIzJTIwdGhpcyUyMGNhbiUyMHRha2UlMjB0aW1lJTIwZGVwZW5kaW5nJTIwb24lMjB5b3VyJTIwZG93bmxvYWQlMjBiYW5kd2lkdGg=",highlighted:'<span class="hljs-string">git</span> <span class="hljs-string">lfs</span> <span class="hljs-string">fetch</span> <span class="hljs-built_in">--all</span> <span class="hljs-string">upstream</span> <span class="hljs-comment"># this can take time depending on your download bandwidth</span>',wrap:!1}}),A=new tt({props:{code:"Z2l0JTIwcmVzZXQlMjAtLWhhcmQlMjB1cHN0cmVhbSUyRm1haW4=",highlighted:'git reset <span class="hljs-attr">--hard</span> upstream/<span class="hljs-selector-tag">main</span>',wrap:!1}}),q=new tt({props:{code:"Z2l0JTIwcmViYXNlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:"git rebase upstream/main",wrap:!1}}),D=new tt({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUyMC0tZm9yY2UlMjAtLWxvY2FsJTIwJTIzJTIwdGhpcyUyMHJlaW5zdGFsbHMlMjB0aGUlMjBMRlMlMjBob29rcyUwQWhmJTIwbGZzLWVuYWJsZS1sYXJnZWZpbGVzJTIwLiUyMCUyMyUyMG5lZWRlZCUyMGlmJTIwc29tZSUyMGZpbGVzJTIwYXJlJTIwYmlnZ2VyJTIwdGhhbiUyMDVHQg==",highlighted:`<span class="hljs-string">git</span> <span class="hljs-string">lfs</span> <span class="hljs-string">install</span> <span class="hljs-built_in">--force</span> <span class="hljs-built_in">--local</span> <span class="hljs-comment"># this reinstalls the LFS hooks</span>
<span class="hljs-string">hf</span> <span class="hljs-string">lfs-enable-largefiles</span> . <span class="hljs-comment"># needed if some files are bigger than 5GB</span>`,wrap:!1}}),E=new tt({props:{code:"Z2l0JTIwcHVzaCUyMC0tZm9yY2UlMjBvcmlnaW4lMjBtYWluJTIwJTIzJTIwdGhpcyUyMGNhbiUyMHRha2UlMjB0aW1lJTIwZGVwZW5kaW5nJTIwb24lMjB5b3VyJTIwdXBsb2FkJTIwYmFuZHdpZHRo",highlighted:'git <span class="hljs-keyword">push</span> --<span class="hljs-literal">force</span> origin main <span class="hljs-comment"># this can take time depending on your upload bandwidth</span>',wrap:!1}}),K=new be({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/repositories-next-steps.md"}}),{c(){c=a("meta"),st=s(),it=a("p"),nt=s(),p(M.$$.fragment),at=s(),T=a("p"),T.textContent=Qt,ot=s(),p(v.$$.fragment),rt=s(),k=a("p"),k.innerHTML=Rt,pt=s(),j=a("p"),j.textContent=At,ht=s(),p(H.$$.fragment),ut=s(),x=a("p"),x.innerHTML=Xt,ft=s(),p(L.$$.fragment),mt=s(),G=a("p"),G.innerHTML=qt,gt=s(),C=a("p"),C.innerHTML=Dt,ct=s(),p(_.$$.fragment),wt=s(),J=a("p"),J.innerHTML=Et,dt=s(),Z=a("p"),Z.innerHTML=Ot,yt=s(),p(I.$$.fragment),$t=s(),U=a("p"),U.textContent=Kt,bt=s(),p(W.$$.fragment),Mt=s(),F=a("p"),F.innerHTML=te,Tt=s(),p(B.$$.fragment),vt=s(),Y=a("p"),Y.innerHTML=ee,kt=s(),P=a("p"),P.innerHTML=ie,jt=s(),S=a("p"),S.innerHTML=le,Ht=s(),z=a("ol"),z.innerHTML=se,xt=s(),p(V.$$.fragment),Lt=s(),w=a("ol"),w.innerHTML=ne,Gt=s(),p(N.$$.fragment),Ct=s(),d=a("ol"),d.innerHTML=ae,_t=s(),p(Q.$$.fragment),Jt=s(),R=a("p"),R.textContent=oe,Zt=s(),p(A.$$.fragment),It=s(),X=a("p"),X.textContent=re,Ut=s(),p(q.$$.fragment),Wt=s(),y=a("ol"),y.innerHTML=pe,Ft=s(),p(D.$$.fragment),Bt=s(),$=a("ol"),$.innerHTML=he,Yt=s(),p(E.$$.fragment),Pt=s(),O=a("p"),O.textContent=ue,St=s(),p(K.$$.fragment),zt=s(),lt=a("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(i),st=n(t),it=o(t,"P",{}),fe(it).forEach(i),nt=n(t),h(M.$$.fragment,t),at=n(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-btdqel"&&(T.textContent=Qt),ot=n(t),h(v.$$.fragment,t),rt=n(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1jazqdv"&&(k.innerHTML=Rt),pt=n(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-qsyw3y"&&(j.textContent=At),ht=n(t),h(H.$$.fragment,t),ut=n(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-164omu7"&&(x.innerHTML=Xt),ft=n(t),h(L.$$.fragment,t),mt=n(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-msdaia"&&(G.innerHTML=qt),gt=n(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-vufusn"&&(C.innerHTML=Dt),ct=n(t),h(_.$$.fragment,t),wt=n(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-23fdx"&&(J.innerHTML=Et),dt=n(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-9rjmgo"&&(Z.innerHTML=Ot),yt=n(t),h(I.$$.fragment,t),$t=n(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-o7wddi"&&(U.textContent=Kt),bt=n(t),h(W.$$.fragment,t),Mt=n(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-prc7et"&&(F.innerHTML=te),Tt=n(t),h(B.$$.fragment,t),vt=n(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-16x2jq4"&&(Y.innerHTML=ee),kt=n(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1rdylac"&&(P.innerHTML=ie),jt=n(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-g5hdh6"&&(S.innerHTML=le),Ht=n(t),z=o(t,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-1osxpc3"&&(z.innerHTML=se),xt=n(t),h(V.$$.fragment,t),Lt=n(t),w=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-1g3lxt"&&(w.innerHTML=ne),Gt=n(t),h(N.$$.fragment,t),Ct=n(t),d=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(d)!=="svelte-17yi54j"&&(d.innerHTML=ae),_t=n(t),h(Q.$$.fragment,t),Jt=n(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1h5q4od"&&(R.textContent=oe),Zt=n(t),h(A.$$.fragment,t),It=n(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-y11elx"&&(X.textContent=re),Ut=n(t),h(q.$$.fragment,t),Wt=n(t),y=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-17b7oso"&&(y.innerHTML=pe),Ft=n(t),h(D.$$.fragment,t),Bt=n(t),$=o(t,"OL",{start:!0,"data-svelte-h":!0}),r($)!=="svelte-t1bai4"&&($.innerHTML=he),Yt=n(t),h(E.$$.fragment,t),Pt=n(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-60fv4p"&&(O.textContent=ue),St=n(t),h(K.$$.fragment,t),zt=n(t),lt=o(t,"P",{}),fe(lt).forEach(i),this.h()},h(){et(c,"name","hf:doc:metadata"),et(c,"content",Te),et(w,"start","3"),et(d,"start","4"),et(y,"start","5"),et($,"start","6")},m(t,e){$e(document.head,c),l(t,st,e),l(t,it,e),l(t,nt,e),u(M,t,e),l(t,at,e),l(t,T,e),l(t,ot,e),u(v,t,e),l(t,rt,e),l(t,k,e),l(t,pt,e),l(t,j,e),l(t,ht,e),u(H,t,e),l(t,ut,e),l(t,x,e),l(t,ft,e),u(L,t,e),l(t,mt,e),l(t,G,e),l(t,gt,e),l(t,C,e),l(t,ct,e),u(_,t,e),l(t,wt,e),l(t,J,e),l(t,dt,e),l(t,Z,e),l(t,yt,e),u(I,t,e),l(t,$t,e),l(t,U,e),l(t,bt,e),u(W,t,e),l(t,Mt,e),l(t,F,e),l(t,Tt,e),u(B,t,e),l(t,vt,e),l(t,Y,e),l(t,kt,e),l(t,P,e),l(t,jt,e),l(t,S,e),l(t,Ht,e),l(t,z,e),l(t,xt,e),u(V,t,e),l(t,Lt,e),l(t,w,e),l(t,Gt,e),u(N,t,e),l(t,Ct,e),l(t,d,e),l(t,_t,e),u(Q,t,e),l(t,Jt,e),l(t,R,e),l(t,Zt,e),u(A,t,e),l(t,It,e),l(t,X,e),l(t,Ut,e),u(q,t,e),l(t,Wt,e),l(t,y,e),l(t,Ft,e),u(D,t,e),l(t,Bt,e),l(t,$,e),l(t,Yt,e),u(E,t,e),l(t,Pt,e),l(t,O,e),l(t,St,e),u(K,t,e),l(t,zt,e),l(t,lt,e),Vt=!0},p:ge,i(t){Vt||(f(M.$$.fragment,t),f(v.$$.fragment,t),f(H.$$.fragment,t),f(L.$$.fragment,t),f(_.$$.fragment,t),f(I.$$.fragment,t),f(W.$$.fragment,t),f(B.$$.fragment,t),f(V.$$.fragment,t),f(N.$$.fragment,t),f(Q.$$.fragment,t),f(A.$$.fragment,t),f(q.$$.fragment,t),f(D.$$.fragment,t),f(E.$$.fragment,t),f(K.$$.fragment,t),Vt=!0)},o(t){m(M.$$.fragment,t),m(v.$$.fragment,t),m(H.$$.fragment,t),m(L.$$.fragment,t),m(_.$$.fragment,t),m(I.$$.fragment,t),m(W.$$.fragment,t),m(B.$$.fragment,t),m(V.$$.fragment,t),m(N.$$.fragment,t),m(Q.$$.fragment,t),m(A.$$.fragment,t),m(q.$$.fragment,t),m(D.$$.fragment,t),m(E.$$.fragment,t),m(K.$$.fragment,t),Vt=!1},d(t){t&&(i(st),i(it),i(nt),i(at),i(T),i(ot),i(rt),i(k),i(pt),i(j),i(ht),i(ut),i(x),i(ft),i(mt),i(G),i(gt),i(C),i(ct),i(wt),i(J),i(dt),i(Z),i(yt),i($t),i(U),i(bt),i(Mt),i(F),i(Tt),i(vt),i(Y),i(kt),i(P),i(jt),i(S),i(Ht),i(z),i(xt),i(Lt),i(w),i(Gt),i(Ct),i(d),i(_t),i(Jt),i(R),i(Zt),i(It),i(X),i(Ut),i(Wt),i(y),i(Ft),i(Bt),i($),i(Yt),i(Pt),i(O),i(St),i(zt),i(lt)),i(c),g(M,t),g(v,t),g(H,t),g(L,t),g(_,t),g(I,t),g(W,t),g(B,t),g(V,t),g(N,t),g(Q,t),g(A,t),g(q,t),g(D,t),g(E,t),g(K,t)}}}const Te='{"title":"Next Steps","local":"next-steps","sections":[{"title":"How to programmatically manage repositories","local":"how-to-programmatically-manage-repositories","sections":[],"depth":2},{"title":"Learning more about Git","local":"learning-more-about-git","sections":[],"depth":2},{"title":"How to use branches","local":"how-to-use-branches","sections":[],"depth":2},{"title":"Using tags","local":"using-tags","sections":[],"depth":2},{"title":"How to duplicate or fork a repo (including LFS pointers)","local":"how-to-duplicate-or-fork-a-repo-including-lfs-pointers","sections":[{"title":"Duplicating without Git history","local":"duplicating-without-git-history","sections":[],"depth":3},{"title":"Duplicating with the Git history (Fork)","local":"duplicating-with-the-git-history-fork","sections":[],"depth":3}],"depth":2}],"depth":1}';function ve(Nt){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends we{constructor(c){super(),de(this,c,ve,Me,me,{})}}export{Le as component};
