import{s as Mt,y as bt,n as vt,o as Pt}from"../chunks/scheduler.12fdeddc.js";import{S as Gt,i as xt,g as a,s as i,r,A as Zt,h as o,f as s,c as n,j as Ut,u as c,x as p,k as Ne,l as Tt,y as Ct,a as l,v as m,d as u,t as f,w as g}from"../chunks/index.88dae322.js";import{C as Qe}from"../chunks/CodeBlock.8e54a086.js";import{H as d,E as Ht}from"../chunks/getInferenceSnippets.00466244.js";function St(Fe){let h,ne,le,ae,w,oe,$,qe,pe,y,Ke="ZeroGPU is a shared infrastructure that optimizes GPU usage for AI models and demos on Hugging Face Spaces. It dynamically allocates and releases NVIDIA H200 GPUs as needed, offering:",re,U,Oe="<li><strong>Free GPU Access</strong>: Enables cost-effective GPU usage for Spaces.</li> <li><strong>Multi-GPU Support</strong>: Allows Spaces to leverage multiple GPUs concurrently on a single application.</li>",ce,T,et="Unlike traditional single-GPU allocations, ZeroGPU’s efficient system lowers barriers for developers, researchers, and organizations to deploy AI models by maximizing resource utilization and power efficiency.",me,M,ue,b,tt='<li><strong>Using existing ZeroGPU Spaces</strong><ul><li>ZeroGPU Spaces are available to use for free to all users. (Visit <a href="https://huggingface.co/spaces/enzostvs/zero-gpu-spaces" rel="nofollow">the curated list</a>).</li> <li><a href="https://huggingface.co/subscribe/pro" rel="nofollow">PRO users</a> get x5 more daily usage quota and highest priority in GPU queues when using any ZeroGPU Spaces.</li></ul></li> <li><strong>Hosting your own ZeroGPU Spaces</strong><ul><li>Personal accounts: <a href="https://huggingface.co/settings/billing/subscription" rel="nofollow">Subscribe to PRO</a> to access ZeroGPU in the hardware options when creating a new Gradio SDK Space.</li> <li>Organizations: <a href="https://huggingface.co/enterprise" rel="nofollow">Subscribe to the Enterprise Hub</a> to enable ZeroGPU Spaces for all organization members.</li></ul></li>',fe,v,ge,P,st="<li><strong>GPU Type</strong>: Nvidia H200 slice</li> <li><strong>Available VRAM</strong>: 70GB per workload</li>",de,G,he,x,lt="ZeroGPU Spaces are designed to be compatible with most PyTorch-based GPU Spaces. While compatibility is enhanced for high-level Hugging Face libraries like <code>transformers</code> and <code>diffusers</code>, users should be aware that:",$e,Z,it="<li>Currently, ZeroGPU Spaces are exclusively compatible with the <strong>Gradio SDK</strong>.</li> <li>ZeroGPU Spaces may have limited compatibility compared to standard GPU Spaces.</li> <li>Unexpected issues may arise in some scenarios.</li>",we,C,ye,H,nt="<li><p><strong>Gradio</strong>: 4+</p></li> <li><p><strong>PyTorch</strong>: Almost all versions from <strong>2.1.0</strong> to <strong>latest</strong> are supported</p> <details><summary>See full list</summary> <ul><li>2.1.0</li> <li>2.1.1</li> <li>2.1.2</li> <li>2.2.0</li> <li>2.2.2</li> <li>2.4.0</li> <li>2.5.1</li> <li>2.6.0</li> <li>2.7.1</li> <li>2.8.0</li></ul></details></li> <li><p><strong>Python</strong>: 3.10.13</p></li>",Ue,S,Te,J,at="To utilize ZeroGPU in your Space, follow these steps:",Me,_,ot="<li>Make sure the ZeroGPU hardware is selected in your Space settings.</li> <li>Import the <code>spaces</code> module.</li> <li>Decorate GPU-dependent functions with <code>@spaces.GPU</code>.</li>",be,B,pt="This decoration process allows the Space to request a GPU when the function is called and release it upon completion.",ve,j,Pe,k,Ge,L,rt="Note: The <code>@spaces.GPU</code> decorator is designed to be effect-free in non-ZeroGPU environments, ensuring compatibility across different setups.",xe,z,Ze,I,ct="For functions expected to exceed the default 60-second of GPU runtime, you can specify a custom duration:",Ce,R,He,E,mt="This sets the maximum function runtime to 120 seconds. Specifying shorter durations for quicker functions will improve queue priority for Space visitors.",Se,V,Je,A,ut="<code>@spaces.GPU</code> also supports dynamic durations.",_e,X,ft="Instead of directly passing a duration, simply pass a callable that takes the same inputs as your decorated function and returns a duration value:",Be,D,je,Y,ke,W,gt="ZeroGPU does not support <code>torch.compile</code>, but you can use PyTorch <strong>ahead-of-time</strong> compilation (requires torch <code>2.8+</code>)",Le,N,dt='Check out this <a href="https://huggingface.co/blog/zerogpu-aoti" rel="nofollow">blogpost</a> for a complete guide on ahead-of-time compilation on ZeroGPU.',ze,Q,Ie,F,ht='<li><strong>Personal accounts (<a href="https://huggingface.co/subscribe/pro" rel="nofollow">PRO subscribers</a>)</strong>: Maximum of 10 ZeroGPU Spaces.</li> <li><strong>Organization accounts (<a href="https://huggingface.co/enterprise" rel="nofollow">Enterprise Hub</a>)</strong>: Maximum of 50 ZeroGPU Spaces.</li>',Re,q,$t="By leveraging ZeroGPU, developers can create more efficient and scalable Spaces, maximizing GPU utilization while minimizing costs.",Ee,K,Ve,O,wt=`If your demo uses a large model, we recommend using optimizations like ahead-of-time compilation and flash-attention 3. You can learn how to leverage these with
ZeroGPU in <a href="https://huggingface.co/blog/zerogpu-aoti" rel="nofollow">this post</a>. These optimizations will help you to maximize the advantages of ZeroGPU hours and provide
a better user experience.`,Ae,ee,Xe,te,yt='You can share your feedback on Spaces ZeroGPU directly on the HF Hub: <a href="https://huggingface.co/spaces/zero-gpu-explorers/README/discussions" rel="nofollow">https://huggingface.co/spaces/zero-gpu-explorers/README/discussions</a>',De,se,Ye,ie,We;return w=new d({props:{title:"Spaces ZeroGPU: Dynamic GPU Allocation for Spaces",local:"spaces-zerogpu-dynamic-gpu-allocation-for-spaces",headingTag:"h1"}}),M=new d({props:{title:"Using and hosting ZeroGPU Spaces",local:"using-and-hosting-zerogpu-spaces",headingTag:"h2"}}),v=new d({props:{title:"Technical Specifications",local:"technical-specifications",headingTag:"h2"}}),G=new d({props:{title:"Compatibility",local:"compatibility",headingTag:"h2"}}),C=new d({props:{title:"Supported Versions",local:"supported-versions",headingTag:"h3"}}),S=new d({props:{title:"Getting started with ZeroGPU",local:"getting-started-with-zerogpu",headingTag:"h2"}}),j=new d({props:{title:"Example Usage",local:"example-usage",headingTag:"h3"}}),k=new Qe({props:{code:"aW1wb3J0JTIwc3BhY2VzJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCguLi4pJTBBcGlwZS50bygnY3VkYScpJTBBJTBBJTQwc3BhY2VzLkdQVSUwQWRlZiUyMGdlbmVyYXRlKHByb21wdCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBwaXBlKHByb21wdCkuaW1hZ2VzJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEZ2VuZXJhdGUlMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5UZXh0KCklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuR2FsbGVyeSgpJTJDJTBBKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> spaces
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(...)
pipe.to(<span class="hljs-string">&#x27;cuda&#x27;</span>)

<span class="hljs-meta">@spaces.GPU</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">prompt</span>):
    <span class="hljs-keyword">return</span> pipe(prompt).images

gr.Interface(
    fn=generate,
    inputs=gr.Text(),
    outputs=gr.Gallery(),
).launch()`,wrap:!1}}),z=new d({props:{title:"Duration Management",local:"duration-management",headingTag:"h2"}}),R=new Qe({props:{code:"JTQwc3BhY2VzLkdQVShkdXJhdGlvbiUzRDEyMCklMEFkZWYlMjBnZW5lcmF0ZShwcm9tcHQpJTNBJTBBJTIwJTIwJTIwcmV0dXJuJTIwcGlwZShwcm9tcHQpLmltYWdlcw==",highlighted:`<span class="hljs-meta">@spaces.GPU(<span class="hljs-params">duration=<span class="hljs-number">120</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">prompt</span>):
   <span class="hljs-keyword">return</span> pipe(prompt).images`,wrap:!1}}),V=new d({props:{title:"Dynamic duration",local:"dynamic-duration",headingTag:"h3"}}),D=new Qe({props:{code:"ZGVmJTIwZ2V0X2R1cmF0aW9uKHByb21wdCUyQyUyMHN0ZXBzKSUzQSUwQSUyMCUyMCUyMCUyMHN0ZXBfZHVyYXRpb24lMjAlM0QlMjAzLjc1JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RlcHMlMjAqJTIwc3RlcF9kdXJhdGlvbiUwQSUwQSU0MHNwYWNlcy5HUFUoZHVyYXRpb24lM0RnZXRfZHVyYXRpb24pJTBBZGVmJTIwZ2VuZXJhdGUocHJvbXB0JTJDJTIwc3RlcHMpJTNBJTBBJTIwJTIwJTIwcmV0dXJuJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEc3RlcHMpLmltYWdlcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_duration</span>(<span class="hljs-params">prompt, steps</span>):
    step_duration = <span class="hljs-number">3.75</span>
    <span class="hljs-keyword">return</span> steps * step_duration

<span class="hljs-meta">@spaces.GPU(<span class="hljs-params">duration=get_duration</span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">prompt, steps</span>):
   <span class="hljs-keyword">return</span> pipe(prompt, num_inference_steps=steps).images`,wrap:!1}}),Y=new d({props:{title:"Compilation",local:"compilation",headingTag:"h2"}}),Q=new d({props:{title:"Hosting Limitations",local:"hosting-limitations",headingTag:"h2"}}),K=new d({props:{title:"Recommendations",local:"recommendations",headingTag:"h2"}}),ee=new d({props:{title:"Feedback",local:"feedback",headingTag:"h2"}}),se=new Ht({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-zerogpu.md"}}),{c(){h=a("meta"),ne=i(),le=a("p"),ae=i(),r(w.$$.fragment),oe=i(),$=a("img"),pe=i(),y=a("p"),y.textContent=Ke,re=i(),U=a("ol"),U.innerHTML=Oe,ce=i(),T=a("p"),T.textContent=et,me=i(),r(M.$$.fragment),ue=i(),b=a("ul"),b.innerHTML=tt,fe=i(),r(v.$$.fragment),ge=i(),P=a("ul"),P.innerHTML=st,de=i(),r(G.$$.fragment),he=i(),x=a("p"),x.innerHTML=lt,$e=i(),Z=a("ul"),Z.innerHTML=it,we=i(),r(C.$$.fragment),ye=i(),H=a("ul"),H.innerHTML=nt,Ue=i(),r(S.$$.fragment),Te=i(),J=a("p"),J.textContent=at,Me=i(),_=a("ol"),_.innerHTML=ot,be=i(),B=a("p"),B.textContent=pt,ve=i(),r(j.$$.fragment),Pe=i(),r(k.$$.fragment),Ge=i(),L=a("p"),L.innerHTML=rt,xe=i(),r(z.$$.fragment),Ze=i(),I=a("p"),I.textContent=ct,Ce=i(),r(R.$$.fragment),He=i(),E=a("p"),E.textContent=mt,Se=i(),r(V.$$.fragment),Je=i(),A=a("p"),A.innerHTML=ut,_e=i(),X=a("p"),X.textContent=ft,Be=i(),r(D.$$.fragment),je=i(),r(Y.$$.fragment),ke=i(),W=a("p"),W.innerHTML=gt,Le=i(),N=a("p"),N.innerHTML=dt,ze=i(),r(Q.$$.fragment),Ie=i(),F=a("ul"),F.innerHTML=ht,Re=i(),q=a("p"),q.textContent=$t,Ee=i(),r(K.$$.fragment),Ve=i(),O=a("p"),O.innerHTML=wt,Ae=i(),r(ee.$$.fragment),Xe=i(),te=a("p"),te.innerHTML=yt,De=i(),r(se.$$.fragment),Ye=i(),ie=a("p"),this.h()},l(e){const t=Zt("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(s),ne=n(e),le=o(e,"P",{}),Ut(le).forEach(s),ae=n(e),c(w.$$.fragment,e),oe=n(e),$=o(e,"IMG",{src:!0,style:!0,alt:!0}),pe=n(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-g988kx"&&(y.textContent=Ke),re=n(e),U=o(e,"OL",{"data-svelte-h":!0}),p(U)!=="svelte-65gla3"&&(U.innerHTML=Oe),ce=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-pj747c"&&(T.textContent=et),me=n(e),c(M.$$.fragment,e),ue=n(e),b=o(e,"UL",{"data-svelte-h":!0}),p(b)!=="svelte-1y31yyi"&&(b.innerHTML=tt),fe=n(e),c(v.$$.fragment,e),ge=n(e),P=o(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-1oy57dy"&&(P.innerHTML=st),de=n(e),c(G.$$.fragment,e),he=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-j2qxf7"&&(x.innerHTML=lt),$e=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-110cvgv"&&(Z.innerHTML=it),we=n(e),c(C.$$.fragment,e),ye=n(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-xaegat"&&(H.innerHTML=nt),Ue=n(e),c(S.$$.fragment,e),Te=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-jrr1x0"&&(J.textContent=at),Me=n(e),_=o(e,"OL",{"data-svelte-h":!0}),p(_)!=="svelte-x3o8nz"&&(_.innerHTML=ot),be=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1yptkag"&&(B.textContent=pt),ve=n(e),c(j.$$.fragment,e),Pe=n(e),c(k.$$.fragment,e),Ge=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-a8f3oh"&&(L.innerHTML=rt),xe=n(e),c(z.$$.fragment,e),Ze=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-3yvsln"&&(I.textContent=ct),Ce=n(e),c(R.$$.fragment,e),He=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1wod5f7"&&(E.textContent=mt),Se=n(e),c(V.$$.fragment,e),Je=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1mt8ddv"&&(A.innerHTML=ut),_e=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1h1a748"&&(X.textContent=ft),Be=n(e),c(D.$$.fragment,e),je=n(e),c(Y.$$.fragment,e),ke=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1emxvdp"&&(W.innerHTML=gt),Le=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1ureykr"&&(N.innerHTML=dt),ze=n(e),c(Q.$$.fragment,e),Ie=n(e),F=o(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-1dm64tu"&&(F.innerHTML=ht),Re=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1kz6an0"&&(q.textContent=$t),Ee=n(e),c(K.$$.fragment,e),Ve=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-18oqbye"&&(O.innerHTML=wt),Ae=n(e),c(ee.$$.fragment,e),Xe=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-m8a1b0"&&(te.innerHTML=yt),De=n(e),c(se.$$.fragment,e),Ye=n(e),ie=o(e,"P",{}),Ut(ie).forEach(s),this.h()},h(){Ne(h,"name","hf:doc:metadata"),Ne(h,"content",Jt),bt($.src,qe="https://cdn-uploads.huggingface.co/production/uploads/5f17f0a0925b9863e28ad517/naVZI-v41zNxmGlhEhGDJ.gif")||Ne($,"src",qe),Tt($,"max-width","440px"),Tt($,"width","100%"),Ne($,"alt","ZeroGPU schema")},m(e,t){Ct(document.head,h),l(e,ne,t),l(e,le,t),l(e,ae,t),m(w,e,t),l(e,oe,t),l(e,$,t),l(e,pe,t),l(e,y,t),l(e,re,t),l(e,U,t),l(e,ce,t),l(e,T,t),l(e,me,t),m(M,e,t),l(e,ue,t),l(e,b,t),l(e,fe,t),m(v,e,t),l(e,ge,t),l(e,P,t),l(e,de,t),m(G,e,t),l(e,he,t),l(e,x,t),l(e,$e,t),l(e,Z,t),l(e,we,t),m(C,e,t),l(e,ye,t),l(e,H,t),l(e,Ue,t),m(S,e,t),l(e,Te,t),l(e,J,t),l(e,Me,t),l(e,_,t),l(e,be,t),l(e,B,t),l(e,ve,t),m(j,e,t),l(e,Pe,t),m(k,e,t),l(e,Ge,t),l(e,L,t),l(e,xe,t),m(z,e,t),l(e,Ze,t),l(e,I,t),l(e,Ce,t),m(R,e,t),l(e,He,t),l(e,E,t),l(e,Se,t),m(V,e,t),l(e,Je,t),l(e,A,t),l(e,_e,t),l(e,X,t),l(e,Be,t),m(D,e,t),l(e,je,t),m(Y,e,t),l(e,ke,t),l(e,W,t),l(e,Le,t),l(e,N,t),l(e,ze,t),m(Q,e,t),l(e,Ie,t),l(e,F,t),l(e,Re,t),l(e,q,t),l(e,Ee,t),m(K,e,t),l(e,Ve,t),l(e,O,t),l(e,Ae,t),m(ee,e,t),l(e,Xe,t),l(e,te,t),l(e,De,t),m(se,e,t),l(e,Ye,t),l(e,ie,t),We=!0},p:vt,i(e){We||(u(w.$$.fragment,e),u(M.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(C.$$.fragment,e),u(S.$$.fragment,e),u(j.$$.fragment,e),u(k.$$.fragment,e),u(z.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(D.$$.fragment,e),u(Y.$$.fragment,e),u(Q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),We=!0)},o(e){f(w.$$.fragment,e),f(M.$$.fragment,e),f(v.$$.fragment,e),f(G.$$.fragment,e),f(C.$$.fragment,e),f(S.$$.fragment,e),f(j.$$.fragment,e),f(k.$$.fragment,e),f(z.$$.fragment,e),f(R.$$.fragment,e),f(V.$$.fragment,e),f(D.$$.fragment,e),f(Y.$$.fragment,e),f(Q.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),We=!1},d(e){e&&(s(ne),s(le),s(ae),s(oe),s($),s(pe),s(y),s(re),s(U),s(ce),s(T),s(me),s(ue),s(b),s(fe),s(ge),s(P),s(de),s(he),s(x),s($e),s(Z),s(we),s(ye),s(H),s(Ue),s(Te),s(J),s(Me),s(_),s(be),s(B),s(ve),s(Pe),s(Ge),s(L),s(xe),s(Ze),s(I),s(Ce),s(He),s(E),s(Se),s(Je),s(A),s(_e),s(X),s(Be),s(je),s(ke),s(W),s(Le),s(N),s(ze),s(Ie),s(F),s(Re),s(q),s(Ee),s(Ve),s(O),s(Ae),s(Xe),s(te),s(De),s(Ye),s(ie)),s(h),g(w,e),g(M,e),g(v,e),g(G,e),g(C,e),g(S,e),g(j,e),g(k,e),g(z,e),g(R,e),g(V,e),g(D,e),g(Y,e),g(Q,e),g(K,e),g(ee,e),g(se,e)}}}const Jt='{"title":"Spaces ZeroGPU: Dynamic GPU Allocation for Spaces","local":"spaces-zerogpu-dynamic-gpu-allocation-for-spaces","sections":[{"title":"Using and hosting ZeroGPU Spaces","local":"using-and-hosting-zerogpu-spaces","sections":[],"depth":2},{"title":"Technical Specifications","local":"technical-specifications","sections":[],"depth":2},{"title":"Compatibility","local":"compatibility","sections":[{"title":"Supported Versions","local":"supported-versions","sections":[],"depth":3}],"depth":2},{"title":"Getting started with ZeroGPU","local":"getting-started-with-zerogpu","sections":[{"title":"Example Usage","local":"example-usage","sections":[],"depth":3}],"depth":2},{"title":"Duration Management","local":"duration-management","sections":[{"title":"Dynamic duration","local":"dynamic-duration","sections":[],"depth":3}],"depth":2},{"title":"Compilation","local":"compilation","sections":[],"depth":2},{"title":"Hosting Limitations","local":"hosting-limitations","sections":[],"depth":2},{"title":"Recommendations","local":"recommendations","sections":[],"depth":2},{"title":"Feedback","local":"feedback","sections":[],"depth":2}],"depth":1}';function _t(Fe){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Gt{constructor(h){super(),xt(this,h,_t,St,Mt,{})}}export{zt as component};
