import{s as _e,o as $e,n as Se}from"../chunks/scheduler.12fdeddc.js";import{S as Ze,i as Re,g as o,s as l,r as h,A as Ve,h as i,f as s,c as n,j as He,u,x as p,k as pt,y as xe,a,v as r,d,t as m,w as M}from"../chunks/index.88dae322.js";import{T as Le}from"../chunks/Tip.64e66512.js";import{C as ct}from"../chunks/CodeBlock.8e54a086.js";import{H as ht,E as Ge}from"../chunks/getInferenceSnippets.00466244.js";function Qe(ut){let c,J="Webhooks are now publicly available!";return{c(){c=o("p"),c.textContent=J},l(T){c=i(T,"P",{"data-svelte-h":!0}),p(c)!=="svelte-s7j76s"&&(c.textContent=J)},m(T,ot){a(T,c,ot)},p:Se,d(T){T&&s(c)}}}function qe(ut){let c,J,T,ot,b,rt,w,dt,g,ee=`This guide will help walk you through the setup of an automatic training pipeline on the Hugging Face platform
using HF Datasets, Webhooks, Spaces, and AutoTrain.`,mt,U,se=`We will build a Webhook that listens to changes on an image classification dataset and triggers a fine-tuning
of <a href="https://huggingface.co/microsoft/resnet-50" rel="nofollow">microsoft/resnet-50</a> using <a href="https://huggingface.co/autotrain" rel="nofollow">AutoTrain</a>.`,Mt,k,Tt,v,ae=`We will use a <a href="https://huggingface.co/datasets/huggingface-projects/auto-retrain-input-dataset" rel="nofollow">simple image classification dataset</a> for the sake
of the example. Learn more about uploading your data to the Hub <a href="https://huggingface.co/docs/datasets/upload_dataset" rel="nofollow">here</a>.`,wt,B,le='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/dataset.png" alt="dataset"/>',ft,C,jt,W,ne='First, let’s create a Webhook from your <a href="https://huggingface.co/settings/webhooks" rel="nofollow">settings</a>.',yt,E,oe='<li>Select your dataset as the target repository. We will target <a href="https://huggingface.co/datasets/huggingface-projects/input-dataset" rel="nofollow">huggingface-projects/input-dataset</a> in this example.</li> <li>You can put a dummy Webhook URL for now. Defining your Webhook will let you look at the events that will be sent to it. You can also replay them, which will be useful for debugging!</li> <li>Input a secret to make it more secure.</li> <li>Subscribe to “Repo update” events as we want to react to data changes</li>',Jt,I,ie="Your Webhook will look like this:",bt,H,pe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/webhook-creation.png" alt="webhook-creation"/>',gt,_,Ut,$,ce='We now need a way to react to your Webhook events. An easy way to do this is to use a <a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">Space</a>!',kt,S,he='You can find an example Space <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/tree/main" rel="nofollow">here</a>.',vt,Z,ue='This Space uses Docker, Python, <a href="https://fastapi.tiangolo.com/" rel="nofollow">FastAPI</a>, and <a href="https://www.uvicorn.org" rel="nofollow">uvicorn</a> to run a simple HTTP server. Read more about Docker Spaces <a href="https://huggingface.co/docs/hub/spaces-sdks-docker" rel="nofollow">here</a>.',Bt,R,re='The entry point is <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/blob/main/src/main.py" rel="nofollow">src/main.py</a>. Let’s walk through this file and detail what it does:',Ct,V,de="<li>It spawns a FastAPI app that will listen to HTTP <code>POST</code> requests on <code>/webhook</code>:</li>",Wt,x,Et,f,me='<li><ol start="2"><li>This route checks that the <code>X-Webhook-Secret</code> header is present and that its value is the same as the one you set in your Webhook’s settings. The <code>WEBHOOK_SECRET</code> secret must be set in the Space’s settings and be the same as the secret set in your Webhook.</li></ol></li>',It,L,Ht,j,Me="<li>The event’s payload is encoded as JSON. Here, we’ll be using pydantic models to parse the event payload. We also specify that we will run our Webhook only when:</li>",_t,G,Te="<li>the event concerns the input dataset</li> <li>the event is an update on the repo’s content, i.e., there has been a new commit</li>",$t,Q,St,y,we="<li>If the payload is valid, the next step is to create a project on AutoTrain, schedule a fine-tuning of the input model (<code>microsoft/resnet-50</code> in our example) on the input dataset, and create a discussion on the dataset when it’s done!</li>",Zt,q,Rt,Y,fe="Visit the link inside the comment to review the training cost estimate, and start fine-tuning the model!",Vt,X,je='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/notification.png" alt="community tab notification"/>',xt,A,ye="In this example, we used Hugging Face AutoTrain to fine-tune our model quickly, but you can of course plug in your training infrastructure!",Lt,N,Je="Feel free to duplicate the Space to your personal namespace and play with it. You will need to provide two secrets:",Gt,z,be='<li><code>WEBHOOK_SECRET</code> : the secret from your Webhook.</li> <li><code>HF_ACCESS_TOKEN</code> : a User Access Token with <code>write</code> rights. You can create one <a href="https://huggingface.co/settings/tokens" rel="nofollow">from your settings</a>.</li>',Qt,F,ge='You will also need to tweak the <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/blob/main/config.json" rel="nofollow"><code>config.json</code> file</a> to use the dataset and model of you choice:',qt,P,Yt,O,Xt,D,Ue="Last but not least, you’ll need to configure your webhook to send POST requests to your Space.",At,K,ke="Let’s first grab our Space’s “direct URL” from the contextual menu. Click on “Embed this Space” and copy the “Direct URL”.",Nt,tt,ve='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/duplicate-space.png" alt="embed this Space"/>',zt,et,Be='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/direct-url.png" alt="direct URL"/>',Ft,st,Ce="Update your Webhook to send requests to that URL:",Pt,at,We='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/update-webhook.png" alt="webhook settings"/>',Ot,lt,Ee="And that’s it! Now every commit to the input dataset will trigger a fine-tuning of ResNet-50 with AutoTrain 🎉",Dt,nt,Kt,it,te;return b=new ht({props:{title:"Webhook guide: Setup an automatic system to re-train a model when a dataset changes",local:"webhook-guide-setup-an-automatic-system-to-re-train-a-model-when-a-dataset-changes",headingTag:"h1"}}),w=new Le({props:{$$slots:{default:[Qe]},$$scope:{ctx:ut}}}),k=new ht({props:{title:"Prerequisite: Upload your dataset to the Hub",local:"prerequisite-upload-your-dataset-to-the-hub",headingTag:"h2"}}),C=new ht({props:{title:"Create a Webhook to react to the dataset’s changes",local:"create-a-webhook-to-react-to-the-datasets-changes",headingTag:"h2"}}),_=new ht({props:{title:"Create a Space to react to your Webhook",local:"create-a-space-to-react-to-your-webhook",headingTag:"h2"}}),x=new ct({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBJTIzJTIwJTVCLi4uJTVEJTBBJTQwYXBwLnBvc3QoJTIyJTJGd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHBvc3Rfd2ViaG9vayglMEElMDklMjMlMjAuLi4lMEEpJTNBJTBBJTBBJTIzJTIwLi4u",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

<span class="hljs-comment"># [...]</span>
<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># ...</span>
</span>):

<span class="hljs-comment"># ...</span>`,wrap:!1}}),L=new ct({props:{code:"JTIzJTIwJTVCLi4uJTVEJTBBJTBBV0VCSE9PS19TRUNSRVQlMjAlM0QlMjBvcy5nZXRlbnYoJTIyV0VCSE9PS19TRUNSRVQlMjIpJTBBJTBBJTIzJTIwJTVCLi4uJTVEJTBBJTBBJTQwYXBwLnBvc3QoJTIyJTJGd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHBvc3Rfd2ViaG9vayglMEElMDklMjMlMjAlNUIuLi4lNUQlMEElMDl4X3dlYmhvb2tfc2VjcmV0JTNBJTIwJTIwT3B0aW9uYWwlNUJzdHIlNUQlMjAlM0QlMjBIZWFkZXIoZGVmYXVsdCUzRE5vbmUpJTJDJTBBJTA5JTIzJTIwJTVFJTIwY2hlY2tzJTIwZm9yJTIwdGhlJTIwWC1XZWJob29rLVNlY3JldCUyMEhUVFAlMjBoZWFkZXIlMEEpJTNBJTBBJTA5aWYlMjB4X3dlYmhvb2tfc2VjcmV0JTIwaXMlMjBOb25lJTNBJTBBJTA5JTA5cmFpc2UlMjBIVFRQRXhjZXB0aW9uKDQwMSklMEElMDlpZiUyMHhfd2ViaG9va19zZWNyZXQlMjAhJTNEJTIwV0VCSE9PS19TRUNSRVQlM0ElMEElMDklMDlyYWlzZSUyMEhUVFBFeGNlcHRpb24oNDAzKSUwQSUwOSUyMyUyMCU1Qi4uLiU1RA==",highlighted:`<span class="hljs-comment"># [...]</span>

WEBHOOK_SECRET = os.getenv(<span class="hljs-string">&quot;WEBHOOK_SECRET&quot;</span>)

<span class="hljs-comment"># [...]</span>

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># [...]</span>
	x_webhook_secret:  <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = Header(<span class="hljs-params">default=<span class="hljs-literal">None</span></span>),
	<span class="hljs-comment"># ^ checks for the X-Webhook-Secret HTTP header</span>
</span>):
	<span class="hljs-keyword">if</span> x_webhook_secret <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
		<span class="hljs-keyword">raise</span> HTTPException(<span class="hljs-number">401</span>)
	<span class="hljs-keyword">if</span> x_webhook_secret != WEBHOOK_SECRET:
		<span class="hljs-keyword">raise</span> HTTPException(<span class="hljs-number">403</span>)
	<span class="hljs-comment"># [...]</span>`,wrap:!1}}),Q=new ct({props:{code:"JTIzJTIwZGVmaW5lZCUyMGluJTIwc3JjJTJGbW9kZWxzLnB5JTBBY2xhc3MlMjBXZWJob29rUGF5bG9hZEV2ZW50KEJhc2VNb2RlbCklM0ElMEElMDlhY3Rpb24lM0ElMjBMaXRlcmFsJTVCJTIyY3JlYXRlJTIyJTJDJTIwJTIydXBkYXRlJTIyJTJDJTIwJTIyZGVsZXRlJTIyJTVEJTBBJTA5c2NvcGUlM0ElMjBzdHIlMEElMEFjbGFzcyUyMFdlYmhvb2tQYXlsb2FkUmVwbyhCYXNlTW9kZWwpJTNBJTBBJTA5dHlwZSUzQSUyMExpdGVyYWwlNUIlMjJkYXRhc2V0JTIyJTJDJTIwJTIybW9kZWwlMjIlMkMlMjAlMjJzcGFjZSUyMiU1RCUwQSUwOW5hbWUlM0ElMjBzdHIlMEElMDlpZCUzQSUyMHN0ciUwQSUwOXByaXZhdGUlM0ElMjBib29sJTBBJTA5aGVhZFNoYSUzQSUyMHN0ciUwQSUwQWNsYXNzJTIwV2ViaG9va1BheWxvYWQoQmFzZU1vZGVsKSUzQSUwQSUwOWV2ZW50JTNBJTIwV2ViaG9va1BheWxvYWRFdmVudCUwQSUwOXJlcG8lM0ElMjBXZWJob29rUGF5bG9hZFJlcG8lMEElMEElMjMlMjAlNUIuLi4lNUQlMEElMEElNDBhcHAucG9zdCglMjIlMkZ3ZWJob29rJTIyKSUwQWFzeW5jJTIwZGVmJTIwcG9zdF93ZWJob29rKCUwQSUwOSUyMyUyMCU1Qi4uLiU1RCUwQSUwOXBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCUyQyUwQSUwOSUyMyUyMCU1RSUyMFB5ZGFudGljJTIwbW9kZWwlMjBkZWZpbmluZyUyMHRoZSUyMHBheWxvYWQlMjBmb3JtYXQlMEEpJTNBJTBBJTA5JTIzJTIwJTVCLi4uJTVEJTBBJTA5aWYlMjBub3QlMjAoJTBBJTA5JTA5cGF5bG9hZC5ldmVudC5hY3Rpb24lMjAlM0QlM0QlMjAlMjJ1cGRhdGUlMjIlMEElMDklMDlhbmQlMjBwYXlsb2FkLmV2ZW50LnNjb3BlLnN0YXJ0c3dpdGgoJTIycmVwby5jb250ZW50JTIyKSUwQSUwOSUwOWFuZCUyMHBheWxvYWQucmVwby5uYW1lJTIwJTNEJTNEJTIwY29uZmlnLmlucHV0X2RhdGFzZXQlMEElMDklMDlhbmQlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMEElMDkpJTNBJTBBJTA5JTA5JTIzJTIwbm8tb3AlMjBpZiUyMHRoZSUyMHBheWxvYWQlMjBkb2VzJTIwbm90JTIwbWF0Y2glMjBvdXIlMjBleHBlY3RhdGlvbnMlMEElMDklMDlyZXR1cm4lMjAlN0IlMjJwcm9jZXNzZWQlMjIlM0ElMjBGYWxzZSU3RCUwQSUwOSUyMyU1Qi4uLiU1RA==",highlighted:`<span class="hljs-comment"># defined in src/models.py</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayloadEvent</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	action: <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;create&quot;</span>, <span class="hljs-string">&quot;update&quot;</span>, <span class="hljs-string">&quot;delete&quot;</span>]
	scope: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayloadRepo</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	<span class="hljs-built_in">type</span>: <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;dataset&quot;</span>, <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-string">&quot;space&quot;</span>]
	name: <span class="hljs-built_in">str</span>
	<span class="hljs-built_in">id</span>: <span class="hljs-built_in">str</span>
	private: <span class="hljs-built_in">bool</span>
	headSha: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayload</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	event: WebhookPayloadEvent
	repo: WebhookPayloadRepo

<span class="hljs-comment"># [...]</span>

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># [...]</span>
	payload: WebhookPayload,
	<span class="hljs-comment"># ^ Pydantic model defining the payload format</span>
</span>):
	<span class="hljs-comment"># [...]</span>
	<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> (
		payload.event.action == <span class="hljs-string">&quot;update&quot;</span>
		<span class="hljs-keyword">and</span> payload.event.scope.startswith(<span class="hljs-string">&quot;repo.content&quot;</span>)
		<span class="hljs-keyword">and</span> payload.repo.name == config.input_dataset
		<span class="hljs-keyword">and</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span>
	):
		<span class="hljs-comment"># no-op if the payload does not match our expectations</span>
		<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;processed&quot;</span>: <span class="hljs-literal">False</span>}
	<span class="hljs-comment">#[...]</span>`,wrap:!1}}),q=new ct({props:{code:"ZGVmJTIwc2NoZWR1bGVfcmV0cmFpbihwYXlsb2FkJTNBJTIwV2ViaG9va1BheWxvYWQpJTNBJTBBJTA5JTIzJTIwQ3JlYXRlJTIwdGhlJTIwYXV0b3RyYWluJTIwcHJvamVjdCUwQSUwOXRyeSUzQSUwQSUwOSUwOXByb2plY3QlMjAlM0QlMjBBdXRvVHJhaW4uY3JlYXRlX3Byb2plY3QocGF5bG9hZCklMEElMDklMDlBdXRvVHJhaW4uYWRkX2RhdGEocHJvamVjdF9pZCUzRHByb2plY3QlNUIlMjJpZCUyMiU1RCklMEElMDklMDlBdXRvVHJhaW4uc3RhcnRfcHJvY2Vzc2luZyhwcm9qZWN0X2lkJTNEcHJvamVjdCU1QiUyMmlkJTIyJTVEKSUwQSUwOWV4Y2VwdCUyMHJlcXVlc3RzLkhUVFBFcnJvciUyMGFzJTIwZXJyJTNBJTBBJTA5JTA5cHJpbnQoJTIyRVJST1IlMjB3aGlsZSUyMHJlcXVlc3RpbmclMjBBdXRvVHJhaW4lMjBBUEklM0ElMjIpJTBBJTA5JTA5cHJpbnQoZiUyMiUyMCUyMGNvZGUlM0ElMjAlN0JlcnIucmVzcG9uc2Uuc3RhdHVzX2NvZGUlN0QlMjIpJTBBJTA5JTA5cHJpbnQoZiUyMiUyMCUyMCU3QmVyci5yZXNwb25zZS5qc29uKCklN0QlMjIpJTBBJTA5JTA5cmFpc2UlMEElMDklMjMlMjBOb3RpZnklMjBpbiUyMHRoZSUyMGNvbW11bml0eSUyMHRhYiUwQSUwOW5vdGlmeV9zdWNjZXNzKHByb2plY3QlNUIlMjJpZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">schedule_retrain</span>(<span class="hljs-params">payload: WebhookPayload</span>):
	<span class="hljs-comment"># Create the autotrain project</span>
	<span class="hljs-keyword">try</span>:
		project = AutoTrain.create_project(payload)
		AutoTrain.add_data(project_id=project[<span class="hljs-string">&quot;id&quot;</span>])
		AutoTrain.start_processing(project_id=project[<span class="hljs-string">&quot;id&quot;</span>])
	<span class="hljs-keyword">except</span> requests.HTTPError <span class="hljs-keyword">as</span> err:
		<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR while requesting AutoTrain API:&quot;</span>)
		<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  code: <span class="hljs-subst">{err.response.status_code}</span>&quot;</span>)
		<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{err.response.json()}</span>&quot;</span>)
		<span class="hljs-keyword">raise</span>
	<span class="hljs-comment"># Notify in the community tab</span>
	notify_success(project[<span class="hljs-string">&quot;id&quot;</span>])`,wrap:!1}}),P=new ct({props:{code:"JTdCJTBBJTA5JTIydGFyZ2V0X25hbWVzcGFjZSUyMiUzQSUyMCUyMnRoZSUyMG5hbWVzcGFjZSUyMHdoZXJlJTIwdGhlJTIwdHJhaW5lZCUyMG1vZGVsJTIwc2hvdWxkJTIwZW5kJTIwdXAlMjIlMkMlMEElMDklMjJpbnB1dF9kYXRhc2V0JTIyJTNBJTIwJTIydGhlJTIwZGF0YXNldCUyMG9uJTIwd2hpY2glMjB0aGUlMjBtb2RlbCUyMHdpbGwlMjBiZSUyMHRyYWluZWQlMjIlMkMlMEElMDklMjJpbnB1dF9tb2RlbCUyMiUzQSUyMCUyMnRoZSUyMGJhc2UlMjBtb2RlbCUyMHRvJTIwcmUtdHJhaW4lMjIlMkMlMEElMDklMjJhdXRvdHJhaW5fcHJvamVjdF9wcmVmaXglMjIlM0ElMjAlMjJBJTIwcHJlZml4JTIwZm9yJTIwdGhlJTIwQXV0b1RyYWluJTIwcHJvamVjdCUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;target_namespace&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the namespace where the trained model should end up&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;input_dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the dataset on which the model will be trained&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;input_model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the base model to re-train&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;autotrain_project_prefix&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A prefix for the AutoTrain project&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),O=new ht({props:{title:"Configure your Webhook to send events to your Space",local:"configure-your-webhook-to-send-events-to-your-space",headingTag:"h2"}}),nt=new Ge({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/webhooks-guide-auto-retrain.md"}}),{c(){c=o("meta"),J=l(),T=o("p"),ot=l(),h(b.$$.fragment),rt=l(),h(w.$$.fragment),dt=l(),g=o("p"),g.textContent=ee,mt=l(),U=o("p"),U.innerHTML=se,Mt=l(),h(k.$$.fragment),Tt=l(),v=o("p"),v.innerHTML=ae,wt=l(),B=o("p"),B.innerHTML=le,ft=l(),h(C.$$.fragment),jt=l(),W=o("p"),W.innerHTML=ne,yt=l(),E=o("ul"),E.innerHTML=oe,Jt=l(),I=o("p"),I.textContent=ie,bt=l(),H=o("p"),H.innerHTML=pe,gt=l(),h(_.$$.fragment),Ut=l(),$=o("p"),$.innerHTML=ce,kt=l(),S=o("p"),S.innerHTML=he,vt=l(),Z=o("p"),Z.innerHTML=ue,Bt=l(),R=o("p"),R.innerHTML=re,Ct=l(),V=o("ol"),V.innerHTML=de,Wt=l(),h(x.$$.fragment),Et=l(),f=o("ol"),f.innerHTML=me,It=l(),h(L.$$.fragment),Ht=l(),j=o("ol"),j.innerHTML=Me,_t=l(),G=o("ul"),G.innerHTML=Te,$t=l(),h(Q.$$.fragment),St=l(),y=o("ol"),y.innerHTML=we,Zt=l(),h(q.$$.fragment),Rt=l(),Y=o("p"),Y.textContent=fe,Vt=l(),X=o("p"),X.innerHTML=je,xt=l(),A=o("p"),A.textContent=ye,Lt=l(),N=o("p"),N.textContent=Je,Gt=l(),z=o("ul"),z.innerHTML=be,Qt=l(),F=o("p"),F.innerHTML=ge,qt=l(),h(P.$$.fragment),Yt=l(),h(O.$$.fragment),Xt=l(),D=o("p"),D.textContent=Ue,At=l(),K=o("p"),K.textContent=ke,Nt=l(),tt=o("p"),tt.innerHTML=ve,zt=l(),et=o("p"),et.innerHTML=Be,Ft=l(),st=o("p"),st.textContent=Ce,Pt=l(),at=o("p"),at.innerHTML=We,Ot=l(),lt=o("p"),lt.textContent=Ee,Dt=l(),h(nt.$$.fragment),Kt=l(),it=o("p"),this.h()},l(t){const e=Ve("svelte-u9bgzb",document.head);c=i(e,"META",{name:!0,content:!0}),e.forEach(s),J=n(t),T=i(t,"P",{}),He(T).forEach(s),ot=n(t),u(b.$$.fragment,t),rt=n(t),u(w.$$.fragment,t),dt=n(t),g=i(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-ze8gh0"&&(g.textContent=ee),mt=n(t),U=i(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-8my4lw"&&(U.innerHTML=se),Mt=n(t),u(k.$$.fragment,t),Tt=n(t),v=i(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1bbg0un"&&(v.innerHTML=ae),wt=n(t),B=i(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-l6l0rz"&&(B.innerHTML=le),ft=n(t),u(C.$$.fragment,t),jt=n(t),W=i(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-15jch62"&&(W.innerHTML=ne),yt=n(t),E=i(t,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-vx6oz2"&&(E.innerHTML=oe),Jt=n(t),I=i(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1kjjv0e"&&(I.textContent=ie),bt=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1lz55rf"&&(H.innerHTML=pe),gt=n(t),u(_.$$.fragment,t),Ut=n(t),$=i(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-fqh90s"&&($.innerHTML=ce),kt=n(t),S=i(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-sual4m"&&(S.innerHTML=he),vt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-j52eq3"&&(Z.innerHTML=ue),Bt=n(t),R=i(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1euo8xv"&&(R.innerHTML=re),Ct=n(t),V=i(t,"OL",{"data-svelte-h":!0}),p(V)!=="svelte-1xhscr8"&&(V.innerHTML=de),Wt=n(t),u(x.$$.fragment,t),Et=n(t),f=i(t,"OL",{start:!0,"data-svelte-h":!0}),p(f)!=="svelte-147ibmb"&&(f.innerHTML=me),It=n(t),u(L.$$.fragment,t),Ht=n(t),j=i(t,"OL",{start:!0,"data-svelte-h":!0}),p(j)!=="svelte-18lnge2"&&(j.innerHTML=Me),_t=n(t),G=i(t,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-1gbdb1z"&&(G.innerHTML=Te),$t=n(t),u(Q.$$.fragment,t),St=n(t),y=i(t,"OL",{start:!0,"data-svelte-h":!0}),p(y)!=="svelte-1jgt1rb"&&(y.innerHTML=we),Zt=n(t),u(q.$$.fragment,t),Rt=n(t),Y=i(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-2wkt37"&&(Y.textContent=fe),Vt=n(t),X=i(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-17amjt1"&&(X.innerHTML=je),xt=n(t),A=i(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1upb8bg"&&(A.textContent=ye),Lt=n(t),N=i(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1ieosw8"&&(N.textContent=Je),Gt=n(t),z=i(t,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1mva7ee"&&(z.innerHTML=be),Qt=n(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-ch6cio"&&(F.innerHTML=ge),qt=n(t),u(P.$$.fragment,t),Yt=n(t),u(O.$$.fragment,t),Xt=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-14g7hz7"&&(D.textContent=Ue),At=n(t),K=i(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-51uzae"&&(K.textContent=ke),Nt=n(t),tt=i(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1gxz68g"&&(tt.innerHTML=ve),zt=n(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-h01i34"&&(et.innerHTML=Be),Ft=n(t),st=i(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1w4uowt"&&(st.textContent=Ce),Pt=n(t),at=i(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-lpgybe"&&(at.innerHTML=We),Ot=n(t),lt=i(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-9f0m9n"&&(lt.textContent=Ee),Dt=n(t),u(nt.$$.fragment,t),Kt=n(t),it=i(t,"P",{}),He(it).forEach(s),this.h()},h(){pt(c,"name","hf:doc:metadata"),pt(c,"content",Ye),pt(f,"start","2"),pt(j,"start","3"),pt(y,"start","4")},m(t,e){xe(document.head,c),a(t,J,e),a(t,T,e),a(t,ot,e),r(b,t,e),a(t,rt,e),r(w,t,e),a(t,dt,e),a(t,g,e),a(t,mt,e),a(t,U,e),a(t,Mt,e),r(k,t,e),a(t,Tt,e),a(t,v,e),a(t,wt,e),a(t,B,e),a(t,ft,e),r(C,t,e),a(t,jt,e),a(t,W,e),a(t,yt,e),a(t,E,e),a(t,Jt,e),a(t,I,e),a(t,bt,e),a(t,H,e),a(t,gt,e),r(_,t,e),a(t,Ut,e),a(t,$,e),a(t,kt,e),a(t,S,e),a(t,vt,e),a(t,Z,e),a(t,Bt,e),a(t,R,e),a(t,Ct,e),a(t,V,e),a(t,Wt,e),r(x,t,e),a(t,Et,e),a(t,f,e),a(t,It,e),r(L,t,e),a(t,Ht,e),a(t,j,e),a(t,_t,e),a(t,G,e),a(t,$t,e),r(Q,t,e),a(t,St,e),a(t,y,e),a(t,Zt,e),r(q,t,e),a(t,Rt,e),a(t,Y,e),a(t,Vt,e),a(t,X,e),a(t,xt,e),a(t,A,e),a(t,Lt,e),a(t,N,e),a(t,Gt,e),a(t,z,e),a(t,Qt,e),a(t,F,e),a(t,qt,e),r(P,t,e),a(t,Yt,e),r(O,t,e),a(t,Xt,e),a(t,D,e),a(t,At,e),a(t,K,e),a(t,Nt,e),a(t,tt,e),a(t,zt,e),a(t,et,e),a(t,Ft,e),a(t,st,e),a(t,Pt,e),a(t,at,e),a(t,Ot,e),a(t,lt,e),a(t,Dt,e),r(nt,t,e),a(t,Kt,e),a(t,it,e),te=!0},p(t,[e]){const Ie={};e&2&&(Ie.$$scope={dirty:e,ctx:t}),w.$set(Ie)},i(t){te||(d(b.$$.fragment,t),d(w.$$.fragment,t),d(k.$$.fragment,t),d(C.$$.fragment,t),d(_.$$.fragment,t),d(x.$$.fragment,t),d(L.$$.fragment,t),d(Q.$$.fragment,t),d(q.$$.fragment,t),d(P.$$.fragment,t),d(O.$$.fragment,t),d(nt.$$.fragment,t),te=!0)},o(t){m(b.$$.fragment,t),m(w.$$.fragment,t),m(k.$$.fragment,t),m(C.$$.fragment,t),m(_.$$.fragment,t),m(x.$$.fragment,t),m(L.$$.fragment,t),m(Q.$$.fragment,t),m(q.$$.fragment,t),m(P.$$.fragment,t),m(O.$$.fragment,t),m(nt.$$.fragment,t),te=!1},d(t){t&&(s(J),s(T),s(ot),s(rt),s(dt),s(g),s(mt),s(U),s(Mt),s(Tt),s(v),s(wt),s(B),s(ft),s(jt),s(W),s(yt),s(E),s(Jt),s(I),s(bt),s(H),s(gt),s(Ut),s($),s(kt),s(S),s(vt),s(Z),s(Bt),s(R),s(Ct),s(V),s(Wt),s(Et),s(f),s(It),s(Ht),s(j),s(_t),s(G),s($t),s(St),s(y),s(Zt),s(Rt),s(Y),s(Vt),s(X),s(xt),s(A),s(Lt),s(N),s(Gt),s(z),s(Qt),s(F),s(qt),s(Yt),s(Xt),s(D),s(At),s(K),s(Nt),s(tt),s(zt),s(et),s(Ft),s(st),s(Pt),s(at),s(Ot),s(lt),s(Dt),s(Kt),s(it)),s(c),M(b,t),M(w,t),M(k,t),M(C,t),M(_,t),M(x,t),M(L,t),M(Q,t),M(q,t),M(P,t),M(O,t),M(nt,t)}}}const Ye='{"title":"Webhook guide: Setup an automatic system to re-train a model when a dataset changes","local":"webhook-guide-setup-an-automatic-system-to-re-train-a-model-when-a-dataset-changes","sections":[{"title":"Prerequisite: Upload your dataset to the Hub","local":"prerequisite-upload-your-dataset-to-the-hub","sections":[],"depth":2},{"title":"Create a Webhook to react to the dataset’s changes","local":"create-a-webhook-to-react-to-the-datasets-changes","sections":[],"depth":2},{"title":"Create a Space to react to your Webhook","local":"create-a-space-to-react-to-your-webhook","sections":[],"depth":2},{"title":"Configure your Webhook to send events to your Space","local":"configure-your-webhook-to-send-events-to-your-space","sections":[],"depth":2}],"depth":1}';function Xe(ut){return $e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ze{constructor(c){super(),Re(this,c,Xe,qe,_e,{})}}export{Oe as component};
