import{s as ys,y as ws,n as Ms,o as Ts}from"../chunks/scheduler.12fdeddc.js";import{S as $s,i as ks,g as i,s as n,r as u,A as vs,h as p,f as s,c as l,j as bs,u as r,x as o,k as ve,y as Js,a,v as c,d as h,t as m,w as g}from"../chunks/index.88dae322.js";import{C as f}from"../chunks/CodeBlock.8e54a086.js";import{H as d,E as Is}from"../chunks/getInferenceSnippets.00466244.js";function Cs(Ut){let j,Je,$e,Ie,w,Ce,M,Ht="Spark enables real-time, large-scale data processing in a distributed environment.",Se,T,Lt="You can use <code>pyspark_huggingface</code> to access Hugging Face datasets repositories in PySpark via the “huggingface” Data Source.",qe,$,Wt='Try out <a href="https://huggingface.co/spaces/Dataset-Tools/Spark-Notebooks" rel="nofollow">Spark Notebooks</a> on Hugging Face Spaces to get Notebooks with PySpark and <code>pyspark_huggingface</code> pre-installed.',_e,Te,Ft,Ze,k,xe,v,Ue,J,Pt="To be able to read and write to Hugging Face Datasets, you need to install the <code>pyspark_huggingface</code> library:",He,I,Le,C,Gt="This will also install required dependencies like <code>huggingface_hub</code> for authentication, and <code>pyarrow</code> for reading and writing datasets.",We,S,Fe,q,zt="You need to authenticate to Hugging Face to read private/gated dataset repositories or to write to your dataset repositories.",Pe,_,Bt="You can use the CLI for example:",Ge,Z,ze,x,Nt=`It’s also possible to provide your Hugging Face token with the <code>HF_TOKEN</code> environment variable or passing the <code>token</code> option to the reader.
For more details about authentication, check out <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">this guide</a>.`,Be,U,Ne,H,At=`PySpark 4 came with a new Data Source API which allows to use datasets from custom sources.
If <code>pyspark_huggingface</code> is installed, PySpark auto-imports it and enables the “huggingface” Data Source.`,Ae,L,Yt=`The library also backports the Data Source API for the “huggingface” Data Source for PySpark 3.5, 3.4 and 3.3.
However in this case <code>pyspark_huggingface</code> should be imported explicitly to activate the backport and enable the “huggingface” Data Dource:`,Ye,W,Qe,F,Xe,P,Qt=`The “huggingface” Data Source allows to read datasets from Hugging Face, using <code>pyarrow</code> under the hood to stream Arrow data.
This is compatible with all the dataset in <a href="https://huggingface.co/docs/hub/datasets-adding#file-formats" rel="nofollow">supported format</a> on Hugging Face, like Parquet datasets.`,Ee,G,Xt='For example here is how to load the <a href="https://huggingface.co/stanfordnlp/imdb" rel="nofollow">stanfordnlp/imdb</a> dataset:',De,z,Re,B,Et=`Here is another example with the <a href="https://huggingface.co/datasets/BAAI/Infinity-Instruct" rel="nofollow">BAAI/Infinity-Instruct</a> dataset.
It is a gated repository, users have to accept the terms of use before accessing it.
It also has multiple subsets, namely, “3M” and “7M”. So we need to specify which one to load.`,Ve,b,Dt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/datasets-spark-infinity-instruct-7M-min.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/datasets-spark-infinity-instruct-7M-dark-min.png"/>',Ke,N,Rt="We use the <code>.format()</code> function to use the “huggingface” Data Source, and <code>.load()</code> to load the dataset (more precisely the config or subset named “7M” containing 7M samples). Then we compute the number of dialogue per language and filter the dataset.",Oe,A,Vt="After logging-in to access the gated repository, we can run:",et,Y,tt,Q,Kt="This loads the dataset in a streaming fashion, and the output DataFrame has one partition per data file in the dataset to enable efficient distributed processing.",st,X,Ot=`To compute the number of dialogues per language we run this code that uses the <code>columns</code> option and a <code>groupBy()</code> operation.
The <code>columns</code> option is useful to only load the data we need, since PySpark doesn’t enable predicate push-down with the Data Source API.
There is also a <code>filters</code> option to only load data with values within a certain range.`,at,E,nt,D,es="To filter the dataset and only keep dialogues in Chinese:",lt,R,it,V,ts=`It is also possible to apply filters or remove columns on the loaded DataFrame, but it is more efficient to do it while loading, especially on Parquet datasets.
Indeed, Parquet contains metadata at the file and row group level, which allows to skip entire parts of the dataset that don’t contain samples that satisfy the criteria. Columns in Parquet can also be loaded independently, whch allows to skip the excluded columns and avoid loading unnecessary data.`,pt,K,ot,O,ss="Here is the list of available options you can pass to <code>read..option()</code>:",ut,ee,as="<li><code>config</code> (string): select a dataset subset/config</li> <li><code>split</code> (string): select a dataset split (default is “train”)</li> <li><code>token</code> (string): your Hugging Face token</li>",rt,te,ns="For Parquet datasets:",ct,se,ls='<li><code>columns</code> (string): select a subset of columns to load, e.g. <code>&#39;[&quot;id&quot;]&#39;</code></li> <li><code>filters</code> (string): to skip files and row groups that don’t match a criteria, e.g. <code>&#39;[&quot;source&quot;, &quot;=&quot;, &quot;code_exercises&quot;]&#39;</code>. Filters are passed to <a href="https://arrow.apache.org/docs/python/generated/pyarrow.parquet.ParquetDataset.html" rel="nofollow">pyarrow.parquet.ParquetDataset</a>.</li>',ht,ae,is='Any other option is passed as an argument to [datasets.load_dataset] (<a href="https://huggingface.co/docs/datasets/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">https://huggingface.co/docs/datasets/en/package_reference/loading_methods#datasets.load_dataset</a>)',mt,ne,gt,le,ps="Once you have your PySpark Dataframe ready, you can run SQL queries using <code>spark.sql</code>:",dt,ie,ft,pe,os="Again, specifying the <code>columns</code> option is not necessary, but is useful to avoid loading unnecessary data and make the query faster.",jt,oe,bt,ue,us=`You can write a PySpark Dataframe to Hugging Face with the “huggingface” Data Source.
It uploads Parquet files in parallel in a distributed manner, and only commits the files once they’re all uploaded.
It works like this:`,yt,re,wt,ce,rs='Here is how we can use this function to write the filtered version of the <a href="https://huggingface.co/datasets/BAAI/Infinity-Instruct" rel="nofollow">BAAI/Infinity-Instruct</a> dataset back to Hugging Face.',Mt,he,cs=`First you need to <a href="https://huggingface.co/new-dataset" rel="nofollow">create a dataset repository</a>, e.g. <code>username/Infinity-Instruct-Chinese-Only</code> (you can set it to private if you want).
Then, make sure you are authenticated and you can use the “huggingface” Data Source, set the <code>mode</code> to “overwrite” (or “append” if you want to extend an existing dataset), and push to Hugging Face with <code>.save()</code>:`,Tt,me,$t,y,hs='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/datasets-spark-infinity-instruct-chinese-only-min.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/datasets-spark-infinity-instruct-chinese-only-dark-min.png"/>',kt,ge,vt,de,ms="Two modes are available when pushing a dataset to Hugging Face:",Jt,fe,gs="<li>“overwrite”: overwrite the dataset if it already exists</li> <li>“append”: append the dataset to an existing dataset</li>",It,je,Ct,be,ds="Here is the list of available options you can pass to <code>write.option()</code>:",St,ye,fs="<li><code>token</code> (string): your Hugging Face token</li>",qt,we,js="Contributions are welcome to add more options here, in particular <code>subset</code> and <code>split</code>.",_t,Me,Zt,ke,xt;return w=new d({props:{title:"Spark",local:"spark",headingTag:"h1"}}),k=new d({props:{title:"Set up",local:"set-up",headingTag:"h2"}}),v=new d({props:{title:"Installation",local:"installation",headingTag:"h3"}}),I=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHB5c3BhcmtfaHVnZ2luZ2ZhY2U=",highlighted:'pip <span class="hljs-keyword">install</span> pyspark_huggingface',wrap:!1}}),S=new d({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),Z=new f({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:'<span class="hljs-attribute">hf auth login</span>',wrap:!1}}),U=new d({props:{title:"Enable the “huggingface” Data Source",local:"enable-the-huggingface-data-source",headingTag:"h3"}}),W=new f({props:{code:"aW1wb3J0JTIwcHlzcGFya19odWdnaW5nZmFjZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pyspark_huggingface
huggingface datasource enabled <span class="hljs-keyword">for</span> pyspark <span class="hljs-number">3.</span>x.x (backport <span class="hljs-keyword">from</span> pyspark <span class="hljs-number">4</span>)`,wrap:!1}}),F=new d({props:{title:"Read",local:"read",headingTag:"h2"}}),z=new f({props:{code:"aW1wb3J0JTIwcHlzcGFya19odWdnaW5nZmFjZSUwQWZyb20lMjBweXNwYXJrLnNxbCUyMGltcG9ydCUyMFNwYXJrU2Vzc2lvbiUwQXNwYXJrJTIwJTNEJTIwU3BhcmtTZXNzaW9uLmJ1aWxkZXIuYXBwTmFtZSglMjJkZW1vJTIyKS5nZXRPckNyZWF0ZSgpJTBBZGYlMjAlM0QlMjBzcGFyay5yZWFkLmZvcm1hdCglMjJodWdnaW5nZmFjZSUyMikubG9hZCglMjJzdGFuZm9yZG5scCUyRmltZGIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pyspark_huggingface
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pyspark.sql <span class="hljs-keyword">import</span> SparkSession
<span class="hljs-meta">&gt;&gt;&gt; </span>spark = SparkSession.builder.appName(<span class="hljs-string">&quot;demo&quot;</span>).getOrCreate()
<span class="hljs-meta">&gt;&gt;&gt; </span>df = spark.read.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;huggingface&quot;</span>).load(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>)`,wrap:!1}}),Y=new f({props:{code:"aW1wb3J0JTIwcHlzcGFya19odWdnaW5nZmFjZSUwQWZyb20lMjBweXNwYXJrLnNxbCUyMGltcG9ydCUyMFNwYXJrU2Vzc2lvbiUwQXNwYXJrJTIwJTNEJTIwU3BhcmtTZXNzaW9uLmJ1aWxkZXIuYXBwTmFtZSglMjJkZW1vJTIyKS5nZXRPckNyZWF0ZSgpJTBBZGYlMjAlM0QlMjBzcGFyay5yZWFkLmZvcm1hdCglMjJodWdnaW5nZmFjZSUyMikub3B0aW9uKCUyMmNvbmZpZyUyMiUyQyUyMCUyMjdNJTIyKS5sb2FkKCUyMkJBQUklMkZJbmZpbml0eS1JbnN0cnVjdCUyMiklMEFkZi5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pyspark_huggingface
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pyspark.sql <span class="hljs-keyword">import</span> SparkSession
<span class="hljs-meta">&gt;&gt;&gt; </span>spark = SparkSession.builder.appName(<span class="hljs-string">&quot;demo&quot;</span>).getOrCreate()
<span class="hljs-meta">&gt;&gt;&gt; </span>df = spark.read.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;huggingface&quot;</span>).option(<span class="hljs-string">&quot;config&quot;</span>, <span class="hljs-string">&quot;7M&quot;</span>).load(<span class="hljs-string">&quot;BAAI/Infinity-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df.show()
+---+----------------------------+-----+----------+--------------------+        
| <span class="hljs-built_in">id</span>|               conversations|label|langdetect|              source|
+---+----------------------------+-----+----------+--------------------+
|  <span class="hljs-number">0</span>|        [{human, <span class="hljs-keyword">def</span> <span class="hljs-title function_">exti</span>...|     |        en|      code_exercises|
|  <span class="hljs-number">1</span>|        [{human, See the ...|     |        en|                flan|
|  <span class="hljs-number">2</span>|        [{human, This <span class="hljs-keyword">is</span> ...|     |        en|                flan|
|  <span class="hljs-number">3</span>|        [{human, If you d...|     |        en|                flan|
|  <span class="hljs-number">4</span>|        [{human, In a Uni...|     |        en|                flan|
|  <span class="hljs-number">5</span>|        [{human, Read the...|     |        en|                flan|
|  <span class="hljs-number">6</span>|        [{human, You are ...|     |        en|          code_bagel|
|  <span class="hljs-number">7</span>|        [{human, I want y...|     |        en|          Subjective|
|  <span class="hljs-number">8</span>|        [{human, Given th...|     |        en|                flan|
|  <span class="hljs-number">9</span>|[{human, 因果联系原则是法...|     |     zh-cn|          Subjective|
| <span class="hljs-number">10</span>|        [{human, Provide ...|     |        en|self-oss-instruct...|
| <span class="hljs-number">11</span>|        [{human, The univ...|     |        en|                flan|
| <span class="hljs-number">12</span>|        [{human, Q: I am ...|     |        en|                flan|
| <span class="hljs-number">13</span>|        [{human, What <span class="hljs-keyword">is</span> ...|     |        en|      OpenHermes-<span class="hljs-number">2.5</span>|
| <span class="hljs-number">14</span>|        [{human, In react...|     |        en|                flan|
| <span class="hljs-number">15</span>|        [{human, Write Py...|     |        en|      code_exercises|
| <span class="hljs-number">16</span>|        [{human, Find the...|     |        en|            MetaMath|
| <span class="hljs-number">17</span>|        [{human, Three of...|     |        en|            MetaMath|
| <span class="hljs-number">18</span>|        [{human, Chandra ...|     |        en|            MetaMath|
| <span class="hljs-number">19</span>|[{human, 用经济学知识分析...|     |     zh-cn|          Subjective|
+---+----------------------------+-----+----------+--------------------+`,wrap:!1}}),E=new f({props:{code:"ZGZfbGFuZ2RldGVjdF9vbmx5JTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHNwYXJrLnJlYWQuZm9ybWF0KCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUyMCUyMCUyMCUyMC5vcHRpb24oJTIyY29uZmlnJTIyJTJDJTIwJTIyN00lMjIpJTBBJTIwJTIwJTIwJTIwLm9wdGlvbiglMjJjb2x1bW5zJTIyJTJDJTIwJyU1QiUyMmxhbmdkZXRlY3QlMjIlNUQnKSUwQSUyMCUyMCUyMCUyMC5sb2FkKCUyMkJBQUklMkZJbmZpbml0eS1JbnN0cnVjdCUyMiklMEEpJTBBZGZfbGFuZ2RldGVjdF9vbmx5Lmdyb3VwQnkoJTIybGFuZ2RldGVjdCUyMikuY291bnQoKS5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>df_langdetect_only = (
<span class="hljs-meta">... </span>    spark.read.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;huggingface&quot;</span>)
<span class="hljs-meta">... </span>    .option(<span class="hljs-string">&quot;config&quot;</span>, <span class="hljs-string">&quot;7M&quot;</span>)
<span class="hljs-meta">... </span>    .option(<span class="hljs-string">&quot;columns&quot;</span>, <span class="hljs-string">&#x27;[&quot;langdetect&quot;]&#x27;</span>)
<span class="hljs-meta">... </span>    .load(<span class="hljs-string">&quot;BAAI/Infinity-Instruct&quot;</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df_langdetect_only.groupBy(<span class="hljs-string">&quot;langdetect&quot;</span>).count().show()
+----------+-------+                                                            
|langdetect|  count|
+----------+-------+
|        en|<span class="hljs-number">6697793</span>|
|     zh-cn| <span class="hljs-number">751313</span>|
+----------+-------+`,wrap:!1}}),R=new f({props:{code:"ZGZfY2hpbmVzZV9vbmx5JTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHNwYXJrLnJlYWQuZm9ybWF0KCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUyMCUyMCUyMCUyMC5vcHRpb24oJTIyY29uZmlnJTIyJTJDJTIwJTIyN00lMjIpJTBBJTIwJTIwJTIwJTIwLm9wdGlvbiglMjJmaWx0ZXJzJTIyJTJDJTIwJyU1QiglMjJsYW5nZGV0ZWN0JTIyJTJDJTIwJTIyJTNEJTIyJTJDJTIwJTIyemgtY24lMjIpJTVEJyklMEElMjAlMjAlMjAlMjAubG9hZCglMjJCQUFJJTJGSW5maW5pdHktSW5zdHJ1Y3QlMjIpJTBBKSUwQWRmX2NoaW5lc2Vfb25seS5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>df_chinese_only = (
<span class="hljs-meta">... </span>    spark.read.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;huggingface&quot;</span>)
<span class="hljs-meta">... </span>    .option(<span class="hljs-string">&quot;config&quot;</span>, <span class="hljs-string">&quot;7M&quot;</span>)
<span class="hljs-meta">... </span>    .option(<span class="hljs-string">&quot;filters&quot;</span>, <span class="hljs-string">&#x27;[(&quot;langdetect&quot;, &quot;=&quot;, &quot;zh-cn&quot;)]&#x27;</span>)
<span class="hljs-meta">... </span>    .load(<span class="hljs-string">&quot;BAAI/Infinity-Instruct&quot;</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df_chinese_only.show()
+---+----------------------------+-----+----------+----------+                  
| <span class="hljs-built_in">id</span>|               conversations|label|langdetect|    source|
+---+----------------------------+-----+----------+----------+
|  <span class="hljs-number">9</span>|[{human, 因果联系原则是法...|     |     zh-cn|Subjective|
| <span class="hljs-number">19</span>|[{human, 用经济学知识分析...|     |     zh-cn|Subjective|
| <span class="hljs-number">38</span>| [{human, 某个考试共有A、...|     |     zh-cn|Subjective|
| <span class="hljs-number">39</span>|[{human, 撰写一篇关于斐波...|     |     zh-cn|Subjective|
| <span class="hljs-number">57</span>|[{human, 总结世界历史上的...|     |     zh-cn|Subjective|
| <span class="hljs-number">61</span>|[{human, 生成一则广告词。...|     |     zh-cn|Subjective|
| <span class="hljs-number">66</span>|[{human, 描述一个有效的团...|     |     zh-cn|Subjective|
| <span class="hljs-number">94</span>|[{human, 如果比利和蒂芙尼...|     |     zh-cn|Subjective|
|<span class="hljs-number">102</span>|[{human, 生成一句英文名言...|     |     zh-cn|Subjective|
|<span class="hljs-number">106</span>|[{human, 写一封感谢信，感...|     |     zh-cn|Subjective|
|<span class="hljs-number">118</span>| [{human, 生成一个故事。}...|     |     zh-cn|Subjective|
|<span class="hljs-number">174</span>|[{human, 高胆固醇水平的后...|     |     zh-cn|Subjective|
|<span class="hljs-number">180</span>|[{human, 基于以下角色信息...|     |     zh-cn|Subjective|
|<span class="hljs-number">192</span>|[{human, 请写一篇文章，概...|     |     zh-cn|Subjective|
|<span class="hljs-number">221</span>|[{human, 以诗歌形式表达对...|     |     zh-cn|Subjective|
|<span class="hljs-number">228</span>|[{human, 根据给定的指令，...|     |     zh-cn|Subjective|
|<span class="hljs-number">236</span>|[{human, 打开一个新的生成...|     |     zh-cn|Subjective|
|<span class="hljs-number">260</span>|[{human, 生成一个有关未来...|     |     zh-cn|Subjective|
|<span class="hljs-number">268</span>|[{human, 如果有一定数量的...|     |     zh-cn|Subjective|
|<span class="hljs-number">273</span>| [{human, 题目：小明有<span class="hljs-number">5</span>个...|     |     zh-cn|Subjective|
+---+----------------------------+-----+----------+----------+`,wrap:!1}}),K=new d({props:{title:"Options",local:"options",headingTag:"h3"}}),ne=new d({props:{title:"Run SQL queries",local:"run-sql-queries",headingTag:"h3"}}),ie=new f({props:{code:"aW1wb3J0JTIwcHlzcGFya19odWdnaW5nZmFjZSUwQWZyb20lMjBweXNwYXJrLnNxbCUyMGltcG9ydCUyMFNwYXJrU2Vzc2lvbiUwQXNwYXJrJTIwJTNEJTIwU3BhcmtTZXNzaW9uLmJ1aWxkZXIuYXBwTmFtZSglMjJkZW1vJTIyKS5nZXRPckNyZWF0ZSgpJTBBZGYlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwc3BhcmsucmVhZC5mb3JtYXQoJTIyaHVnZ2luZ2ZhY2UlMjIpJTBBJTIwJTIwJTIwJTIwLm9wdGlvbiglMjJjb25maWclMjIlMkMlMjAlMjI3TSUyMiklMEElMjAlMjAlMjAlMjAub3B0aW9uKCUyMmNvbHVtbnMlMjIlMkMlMjAnJTVCJTIyc291cmNlJTIyJTVEJyklMEElMjAlMjAlMjAlMjAubG9hZCglMjJCQUFJJTJGSW5maW5pdHktSW5zdHJ1Y3QlMjIpJTBBKSUwQXNwYXJrLnNxbCglMjJTRUxFQ1QlMjBzb3VyY2UlMkMlMjBjb3VudCgqKSUyMEFTJTIwdG90YWwlMjBGUk9NJTIwJTdCZGYlN0QlMjBHUk9VUCUyMEJZJTIwc291cmNlJTIwT1JERVIlMjBCWSUyMHRvdGFsJTIwREVTQyUyMiUyQyUyMGRmJTNEZGYpLnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pyspark_huggingface
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pyspark.sql <span class="hljs-keyword">import</span> SparkSession
<span class="hljs-meta">&gt;&gt;&gt; </span>spark = SparkSession.builder.appName(<span class="hljs-string">&quot;demo&quot;</span>).getOrCreate()
<span class="hljs-meta">&gt;&gt;&gt; </span>df = (
<span class="hljs-meta">... </span>    spark.read.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;huggingface&quot;</span>)
<span class="hljs-meta">... </span>    .option(<span class="hljs-string">&quot;config&quot;</span>, <span class="hljs-string">&quot;7M&quot;</span>)
<span class="hljs-meta">... </span>    .option(<span class="hljs-string">&quot;columns&quot;</span>, <span class="hljs-string">&#x27;[&quot;source&quot;]&#x27;</span>)
<span class="hljs-meta">... </span>    .load(<span class="hljs-string">&quot;BAAI/Infinity-Instruct&quot;</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>spark.sql(<span class="hljs-string">&quot;SELECT source, count(*) AS total FROM {df} GROUP BY source ORDER BY total DESC&quot;</span>, df=df).show()
+--------------------+-------+
|              source|  total|
+--------------------+-------+
|                flan|<span class="hljs-number">2435840</span>|
|          Subjective|<span class="hljs-number">1342427</span>|
|      OpenHermes-<span class="hljs-number">2.5</span>| <span class="hljs-number">855478</span>|
|            MetaMath| <span class="hljs-number">690138</span>|
|      code_exercises| <span class="hljs-number">590958</span>|
|Orca-math-word-pr...| <span class="hljs-number">398168</span>|
|          code_bagel| <span class="hljs-number">386649</span>|
|        MathInstruct| <span class="hljs-number">329254</span>|
|python-code-datas...|  <span class="hljs-number">88632</span>|
|instructional_cod...|  <span class="hljs-number">82920</span>|
|        CodeFeedback|  <span class="hljs-number">79513</span>|
|self-oss-instruct...|  <span class="hljs-number">50467</span>|
|Evol-Instruct-Cod...|  <span class="hljs-number">43354</span>|
|CodeExercise-Pyth...|  <span class="hljs-number">27159</span>|
|code_instructions...|  <span class="hljs-number">23130</span>|
|  Code-Instruct-700k|  <span class="hljs-number">10860</span>|
|Glaive-code-assis...|   <span class="hljs-number">9281</span>|
|python_code_instr...|   <span class="hljs-number">2581</span>|
|Python-Code-23k-S...|   <span class="hljs-number">2297</span>|
+--------------------+-------+`,wrap:!1}}),oe=new d({props:{title:"Write",local:"write",headingTag:"h2"}}),re=new f({props:{code:"aW1wb3J0JTIwcHlzcGFya19odWdnaW5nZmFjZSUwQWRmLndyaXRlLmZvcm1hdCglMjJodWdnaW5nZmFjZSUyMikuc2F2ZSglMjJ1c2VybmFtZSUyRmRhdGFzZXRfbmFtZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pyspark_huggingface
<span class="hljs-meta">&gt;&gt;&gt; </span>df.write.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;huggingface&quot;</span>).save(<span class="hljs-string">&quot;username/dataset_name&quot;</span>)`,wrap:!1}}),me=new f({props:{code:"ZGZfY2hpbmVzZV9vbmx5LndyaXRlLmZvcm1hdCglMjJodWdnaW5nZmFjZSUyMikubW9kZSglMjJvdmVyd3JpdGUlMjIpLnNhdmUoJTIydXNlcm5hbWUlMkZJbmZpbml0eS1JbnN0cnVjdC1DaGluZXNlLU9ubHklMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>df_chinese_only.write.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;huggingface&quot;</span>).mode(<span class="hljs-string">&quot;overwrite&quot;</span>).save(<span class="hljs-string">&quot;username/Infinity-Instruct-Chinese-Only&quot;</span>)',wrap:!1}}),ge=new d({props:{title:"Mode",local:"mode",headingTag:"h3"}}),je=new d({props:{title:"Options",local:"options",headingTag:"h3"}}),Me=new Is({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-spark.md"}}),{c(){j=i("meta"),Je=n(),$e=i("p"),Ie=n(),u(w.$$.fragment),Ce=n(),M=i("p"),M.textContent=Ht,Se=n(),T=i("p"),T.innerHTML=Lt,qe=n(),$=i("p"),$.innerHTML=Wt,_e=n(),Te=i("img"),Ze=n(),u(k.$$.fragment),xe=n(),u(v.$$.fragment),Ue=n(),J=i("p"),J.innerHTML=Pt,He=n(),u(I.$$.fragment),Le=n(),C=i("p"),C.innerHTML=Gt,We=n(),u(S.$$.fragment),Fe=n(),q=i("p"),q.textContent=zt,Pe=n(),_=i("p"),_.textContent=Bt,Ge=n(),u(Z.$$.fragment),ze=n(),x=i("p"),x.innerHTML=Nt,Be=n(),u(U.$$.fragment),Ne=n(),H=i("p"),H.innerHTML=At,Ae=n(),L=i("p"),L.innerHTML=Yt,Ye=n(),u(W.$$.fragment),Qe=n(),u(F.$$.fragment),Xe=n(),P=i("p"),P.innerHTML=Qt,Ee=n(),G=i("p"),G.innerHTML=Xt,De=n(),u(z.$$.fragment),Re=n(),B=i("p"),B.innerHTML=Et,Ve=n(),b=i("div"),b.innerHTML=Dt,Ke=n(),N=i("p"),N.innerHTML=Rt,Oe=n(),A=i("p"),A.textContent=Vt,et=n(),u(Y.$$.fragment),tt=n(),Q=i("p"),Q.textContent=Kt,st=n(),X=i("p"),X.innerHTML=Ot,at=n(),u(E.$$.fragment),nt=n(),D=i("p"),D.textContent=es,lt=n(),u(R.$$.fragment),it=n(),V=i("p"),V.textContent=ts,pt=n(),u(K.$$.fragment),ot=n(),O=i("p"),O.innerHTML=ss,ut=n(),ee=i("ul"),ee.innerHTML=as,rt=n(),te=i("p"),te.textContent=ns,ct=n(),se=i("ul"),se.innerHTML=ls,ht=n(),ae=i("p"),ae.innerHTML=is,mt=n(),u(ne.$$.fragment),gt=n(),le=i("p"),le.innerHTML=ps,dt=n(),u(ie.$$.fragment),ft=n(),pe=i("p"),pe.innerHTML=os,jt=n(),u(oe.$$.fragment),bt=n(),ue=i("p"),ue.textContent=us,yt=n(),u(re.$$.fragment),wt=n(),ce=i("p"),ce.innerHTML=rs,Mt=n(),he=i("p"),he.innerHTML=cs,Tt=n(),u(me.$$.fragment),$t=n(),y=i("div"),y.innerHTML=hs,kt=n(),u(ge.$$.fragment),vt=n(),de=i("p"),de.textContent=ms,Jt=n(),fe=i("ul"),fe.innerHTML=gs,It=n(),u(je.$$.fragment),Ct=n(),be=i("p"),be.innerHTML=ds,St=n(),ye=i("ul"),ye.innerHTML=fs,qt=n(),we=i("p"),we.innerHTML=js,_t=n(),u(Me.$$.fragment),Zt=n(),ke=i("p"),this.h()},l(e){const t=vs("svelte-u9bgzb",document.head);j=p(t,"META",{name:!0,content:!0}),t.forEach(s),Je=l(e),$e=p(e,"P",{}),bs($e).forEach(s),Ie=l(e),r(w.$$.fragment,e),Ce=l(e),M=p(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-s0r53o"&&(M.textContent=Ht),Se=l(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-ireapg"&&(T.innerHTML=Lt),qe=l(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-17lvzmk"&&($.innerHTML=Wt),_e=l(e),Te=p(e,"IMG",{src:!0}),Ze=l(e),r(k.$$.fragment,e),xe=l(e),r(v.$$.fragment,e),Ue=l(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1i6u7b2"&&(J.innerHTML=Pt),He=l(e),r(I.$$.fragment,e),Le=l(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1dyqnq0"&&(C.innerHTML=Gt),We=l(e),r(S.$$.fragment,e),Fe=l(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-aqw7kt"&&(q.textContent=zt),Pe=l(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-pdivv8"&&(_.textContent=Bt),Ge=l(e),r(Z.$$.fragment,e),ze=l(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-dcl8ev"&&(x.innerHTML=Nt),Be=l(e),r(U.$$.fragment,e),Ne=l(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-8zj7ot"&&(H.innerHTML=At),Ae=l(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-5pp20"&&(L.innerHTML=Yt),Ye=l(e),r(W.$$.fragment,e),Qe=l(e),r(F.$$.fragment,e),Xe=l(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1k66fhy"&&(P.innerHTML=Qt),Ee=l(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-yczgy2"&&(G.innerHTML=Xt),De=l(e),r(z.$$.fragment,e),Re=l(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1q9wgqv"&&(B.innerHTML=Et),Ve=l(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1ct11n9"&&(b.innerHTML=Dt),Ke=l(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-phbdhi"&&(N.innerHTML=Rt),Oe=l(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-19d7o0j"&&(A.textContent=Vt),et=l(e),r(Y.$$.fragment,e),tt=l(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-rdc7zs"&&(Q.textContent=Kt),st=l(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1du45l"&&(X.innerHTML=Ot),at=l(e),r(E.$$.fragment,e),nt=l(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-e2gcj5"&&(D.textContent=es),lt=l(e),r(R.$$.fragment,e),it=l(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-omqngt"&&(V.textContent=ts),pt=l(e),r(K.$$.fragment,e),ot=l(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1s464mf"&&(O.innerHTML=ss),ut=l(e),ee=p(e,"UL",{"data-svelte-h":!0}),o(ee)!=="svelte-1tfwhkx"&&(ee.innerHTML=as),rt=l(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-luhsa2"&&(te.textContent=ns),ct=l(e),se=p(e,"UL",{"data-svelte-h":!0}),o(se)!=="svelte-85k25g"&&(se.innerHTML=ls),ht=l(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1reyf4q"&&(ae.innerHTML=is),mt=l(e),r(ne.$$.fragment,e),gt=l(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-13i529n"&&(le.innerHTML=ps),dt=l(e),r(ie.$$.fragment,e),ft=l(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-fpkb7l"&&(pe.innerHTML=os),jt=l(e),r(oe.$$.fragment,e),bt=l(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-140g2zh"&&(ue.textContent=us),yt=l(e),r(re.$$.fragment,e),wt=l(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1d35p3o"&&(ce.innerHTML=rs),Mt=l(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-vthxjd"&&(he.innerHTML=cs),Tt=l(e),r(me.$$.fragment,e),$t=l(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-tmflad"&&(y.innerHTML=hs),kt=l(e),r(ge.$$.fragment,e),vt=l(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-zuvewl"&&(de.textContent=ms),Jt=l(e),fe=p(e,"UL",{"data-svelte-h":!0}),o(fe)!=="svelte-e9isj"&&(fe.innerHTML=gs),It=l(e),r(je.$$.fragment,e),Ct=l(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1acq8iy"&&(be.innerHTML=ds),St=l(e),ye=p(e,"UL",{"data-svelte-h":!0}),o(ye)!=="svelte-sthc9l"&&(ye.innerHTML=fs),qt=l(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-cukjdh"&&(we.innerHTML=js),_t=l(e),r(Me.$$.fragment,e),Zt=l(e),ke=p(e,"P",{}),bs(ke).forEach(s),this.h()},h(){ve(j,"name","hf:doc:metadata"),ve(j,"content",Ss),ws(Te.src,Ft="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spark-notebooks-min.png")||ve(Te,"src",Ft),ve(b,"class","flex justify-center"),ve(y,"class","flex justify-center")},m(e,t){Js(document.head,j),a(e,Je,t),a(e,$e,t),a(e,Ie,t),c(w,e,t),a(e,Ce,t),a(e,M,t),a(e,Se,t),a(e,T,t),a(e,qe,t),a(e,$,t),a(e,_e,t),a(e,Te,t),a(e,Ze,t),c(k,e,t),a(e,xe,t),c(v,e,t),a(e,Ue,t),a(e,J,t),a(e,He,t),c(I,e,t),a(e,Le,t),a(e,C,t),a(e,We,t),c(S,e,t),a(e,Fe,t),a(e,q,t),a(e,Pe,t),a(e,_,t),a(e,Ge,t),c(Z,e,t),a(e,ze,t),a(e,x,t),a(e,Be,t),c(U,e,t),a(e,Ne,t),a(e,H,t),a(e,Ae,t),a(e,L,t),a(e,Ye,t),c(W,e,t),a(e,Qe,t),c(F,e,t),a(e,Xe,t),a(e,P,t),a(e,Ee,t),a(e,G,t),a(e,De,t),c(z,e,t),a(e,Re,t),a(e,B,t),a(e,Ve,t),a(e,b,t),a(e,Ke,t),a(e,N,t),a(e,Oe,t),a(e,A,t),a(e,et,t),c(Y,e,t),a(e,tt,t),a(e,Q,t),a(e,st,t),a(e,X,t),a(e,at,t),c(E,e,t),a(e,nt,t),a(e,D,t),a(e,lt,t),c(R,e,t),a(e,it,t),a(e,V,t),a(e,pt,t),c(K,e,t),a(e,ot,t),a(e,O,t),a(e,ut,t),a(e,ee,t),a(e,rt,t),a(e,te,t),a(e,ct,t),a(e,se,t),a(e,ht,t),a(e,ae,t),a(e,mt,t),c(ne,e,t),a(e,gt,t),a(e,le,t),a(e,dt,t),c(ie,e,t),a(e,ft,t),a(e,pe,t),a(e,jt,t),c(oe,e,t),a(e,bt,t),a(e,ue,t),a(e,yt,t),c(re,e,t),a(e,wt,t),a(e,ce,t),a(e,Mt,t),a(e,he,t),a(e,Tt,t),c(me,e,t),a(e,$t,t),a(e,y,t),a(e,kt,t),c(ge,e,t),a(e,vt,t),a(e,de,t),a(e,Jt,t),a(e,fe,t),a(e,It,t),c(je,e,t),a(e,Ct,t),a(e,be,t),a(e,St,t),a(e,ye,t),a(e,qt,t),a(e,we,t),a(e,_t,t),c(Me,e,t),a(e,Zt,t),a(e,ke,t),xt=!0},p:Ms,i(e){xt||(h(w.$$.fragment,e),h(k.$$.fragment,e),h(v.$$.fragment,e),h(I.$$.fragment,e),h(S.$$.fragment,e),h(Z.$$.fragment,e),h(U.$$.fragment,e),h(W.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(Y.$$.fragment,e),h(E.$$.fragment,e),h(R.$$.fragment,e),h(K.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(je.$$.fragment,e),h(Me.$$.fragment,e),xt=!0)},o(e){m(w.$$.fragment,e),m(k.$$.fragment,e),m(v.$$.fragment,e),m(I.$$.fragment,e),m(S.$$.fragment,e),m(Z.$$.fragment,e),m(U.$$.fragment,e),m(W.$$.fragment,e),m(F.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(R.$$.fragment,e),m(K.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(ge.$$.fragment,e),m(je.$$.fragment,e),m(Me.$$.fragment,e),xt=!1},d(e){e&&(s(Je),s($e),s(Ie),s(Ce),s(M),s(Se),s(T),s(qe),s($),s(_e),s(Te),s(Ze),s(xe),s(Ue),s(J),s(He),s(Le),s(C),s(We),s(Fe),s(q),s(Pe),s(_),s(Ge),s(ze),s(x),s(Be),s(Ne),s(H),s(Ae),s(L),s(Ye),s(Qe),s(Xe),s(P),s(Ee),s(G),s(De),s(Re),s(B),s(Ve),s(b),s(Ke),s(N),s(Oe),s(A),s(et),s(tt),s(Q),s(st),s(X),s(at),s(nt),s(D),s(lt),s(it),s(V),s(pt),s(ot),s(O),s(ut),s(ee),s(rt),s(te),s(ct),s(se),s(ht),s(ae),s(mt),s(gt),s(le),s(dt),s(ft),s(pe),s(jt),s(bt),s(ue),s(yt),s(wt),s(ce),s(Mt),s(he),s(Tt),s($t),s(y),s(kt),s(vt),s(de),s(Jt),s(fe),s(It),s(Ct),s(be),s(St),s(ye),s(qt),s(we),s(_t),s(Zt),s(ke)),s(j),g(w,e),g(k,e),g(v,e),g(I,e),g(S,e),g(Z,e),g(U,e),g(W,e),g(F,e),g(z,e),g(Y,e),g(E,e),g(R,e),g(K,e),g(ne,e),g(ie,e),g(oe,e),g(re,e),g(me,e),g(ge,e),g(je,e),g(Me,e)}}}const Ss='{"title":"Spark","local":"spark","sections":[{"title":"Set up","local":"set-up","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3},{"title":"Enable the “huggingface” Data Source","local":"enable-the-huggingface-data-source","sections":[],"depth":3}],"depth":2},{"title":"Read","local":"read","sections":[{"title":"Options","local":"options","sections":[],"depth":3},{"title":"Run SQL queries","local":"run-sql-queries","sections":[],"depth":3}],"depth":2},{"title":"Write","local":"write","sections":[{"title":"Mode","local":"mode","sections":[],"depth":3},{"title":"Options","local":"options","sections":[],"depth":3}],"depth":2}],"depth":1}';function qs(Ut){return Ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends $s{constructor(j){super(),ks(this,j,qs,Cs,ys,{})}}export{Hs as component};
