import{s as qt,o as St,n as Nt}from"../chunks/scheduler.12fdeddc.js";import{S as zt,i as Pt,g as i,s as n,r as f,A as At,h as o,f as s,c as a,j as Xt,u as d,x as p,k as ht,y as Qt,a as l,v as m,d as c,t as h,w as u}from"../chunks/index.88dae322.js";import{T as Yt}from"../chunks/Tip.64e66512.js";import{C as ye}from"../chunks/CodeBlock.8e54a086.js";import{H as j,E as Kt}from"../chunks/getInferenceSnippets.00466244.js";function Ot(ge){let r,U="We welcome contributions with open arms!",y,g,b='To create a widely adopted file format, we need early feedback from the community. Nothing is set in stone, and we value everyone’s input. Is your use case not covered? Please let us know in the DDUF organization <a href="https://huggingface.co/spaces/DDUF/README/discussions/2" rel="nofollow">discussions</a>.';return{c(){r=i("p"),r.textContent=U,y=n(),g=i("p"),g.innerHTML=b},l(M){r=o(M,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1pgjqzf"&&(r.textContent=U),y=a(M),g=o(M,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1i0xj7t"&&(g.innerHTML=b)},m(M,w){l(M,r,w),l(M,y,w),l(M,g,w)},p:Nt,d(M){M&&(s(r),s(y),s(g))}}}function es(ge){let r,U="<code>as_mmap</code> must be used in a context manager to benefit from the memory-mapping properties.";return{c(){r=i("p"),r.innerHTML=U},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-7y8anc"&&(r.innerHTML=U)},m(y,g){l(y,r,g)},p:Nt,d(y){y&&s(r)}}}function ts(ge){let r,U,y,g,b,M,w,ut='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/DDUF/DDUF-Banner.svg"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/DDUF/DDUF-Banner-dark.svg"/>',je,v,we,Z,yt="DDUF (<strong>D</strong>DUF’s <strong>D</strong>iffusion <strong>U</strong>nified <strong>F</strong>ormat) is a single-file format for diffusion models that aims to unify the different model distribution methods and weight-saving formats by packaging all model components into a single file. It is language-agnostic and built to be parsable from a remote location without downloading the entire file.",Ue,J,gt='This work draws inspiration from the <a href="https://github.com/ggerganov/ggml/blob/master/docs/gguf.md" rel="nofollow">GGUF</a> format.',be,_,Mt='Check out the <a href="https://huggingface.co/DDUF" rel="nofollow">DDUF</a> org to start using some of the most popular diffusion models in DDUF.',Te,T,$e,G,jt="Its key features include the following.",ve,C,wt='<li><strong>Single file</strong> packaging.</li> <li>Based on <strong>ZIP file format</strong> to leverage existing tooling.</li> <li>No compression, ensuring <strong><code>mmap</code> compatibility</strong> for fast loading and saving.</li> <li><strong>Language-agnostic</strong>: tooling can be implemented in Python, JavaScript, Rust, C++, etc.</li> <li><strong>HTTP-friendly</strong>: metadata and file structure can be fetched remotely using HTTP Range requests.</li> <li><strong>Flexible</strong>: each model component is stored in its own directory, following the current Diffusers structure.</li> <li><strong>Safe</strong>: uses <a href="https://huggingface.co/docs/diffusers/using-diffusers/other-formats#safetensors" rel="nofollow">Safetensors</a> as a weight-saving format and prohibits nested directories to prevent ZIP bombs.</li>',Ze,k,Je,D,Ut='Technically, a <code>.dduf</code> file <strong>is</strong> a <a href="https://en.wikipedia.org/wiki/ZIP_(file_format)" rel="nofollow"><code>.zip</code> archive</a>. By building on a universally supported file format, we ensure robust tooling already exists. However, some constraints are enforced to meet diffusion models’ requirements:',_e,x,bt="<li>Data must be stored uncompressed (flag <code>0</code>), allowing lazy-loading using memory-mapping.</li> <li>Data must be stored using ZIP64 protocol, enabling saving files above 4GB.</li> <li>The archive can only contain <code>.json</code>, <code>.safetensors</code>, <code>.model</code> and <code>.txt</code> files.</li> <li>A <code>model_index.json</code> file must be present at the root of the archive. It must contain a key-value mapping with metadata about the model and its components.</li> <li>Each component must be stored in its own directory (e.g., <code>vae/</code>, <code>text_encoder/</code>). Nested files must use UNIX-style path separators (<code>/</code>).</li> <li>Each directory must correspond to a component in the <code>model_index.json</code> index.</li> <li>Each directory must contain a json config file (one of <code>config.json</code>, <code>tokenizer_config.json</code>, <code>preprocessor_config.json</code>, <code>scheduler_config.json</code>).</li> <li>Sub-directories are forbidden.</li>",Ge,I,Tt='Want to check if your file is valid? Check it out using this Space: <a href="https://huggingface.co/spaces/DDUF/dduf-check" rel="nofollow">https://huggingface.co/spaces/DDUF/dduf-check</a>.',Ce,F,ke,W,$t="The <code>huggingface_hub</code> provides tooling to handle DDUF files in Python. It includes built-in rules to validate file integrity and helpers to read and export DDUF files. The goal is to see this tooling adopted in the Python ecosystem, such as in the <code>diffusers</code> integration. Similar tooling can be developed for other languages (JavaScript, Rust, C++, etc.).",De,R,xe,L,vt='Pass a path to <code>read_dduf_file</code> to read a DDUF file. Only the metadata is read, meaning this is a lightweight call that won’t explode your memory. In the example below, we consider that you’ve already downloaded the <a href="https://huggingface.co/DDUF/FLUX.1-dev-DDUF/blob/main/FLUX.1-dev.dduf" rel="nofollow"><code>FLUX.1-dev.dduf</code></a> file locally.',Ie,H,Fe,B,Zt="<code>read_dduf_file</code> returns a mapping where each entry corresponds to a file in the DDUF archive. A file is represented by a <code>DDUFEntry</code> dataclass that contains the filename, offset, and length of the entry in the original DDUF file. This information is useful to read its content without loading the whole file. In practice, you won’t have to handle low-level reading but rely on helpers instead.",We,V,Jt="For instance, here is how to load the <code>model_index.json</code> content:",Re,E,Le,X,_t="For binary files, you’ll want to access the raw bytes using <code>as_mmap</code>. This returns bytes as a memory-mapping on the original file. The memory-mapping allows you to read only the bytes you need without loading everything in memory. For instance, here is how to load safetensors weights:",He,Y,Be,$,Ve,N,Ee,q,Gt="Pass a folder path to <code>export_folder_as_dduf</code> to export a DDUF file.",Xe,S,Ye,z,Ct="This tool scans the folder, adds the relevant entries and ensures the exported file is valid. If anything goes wrong during the process, a <code>DDUFExportError</code> is raised.",Ne,P,kt="For more flexibility, use [<code>export_entries_as_dduf</code>] to explicitly specify a list of files to include in the final DDUF file:",qe,A,Se,Q,Dt="<code>export_entries_as_dduf</code> works well if you’ve already saved your model on the disk. But what if you have a model loaded in memory and want to serialize it directly into a DDUF file? <code>export_entries_as_dduf</code> lets you do that by providing a Python <code>generator</code> that tells how to serialize the data iteratively:",ze,K,Pe,O,Ae,ee,xt="Diffusers has a built-in integration for DDUF files. Here is an example on how to load a pipeline from a stored checkpoint on the Hub:",Qe,te,Ke,se,Oe,le,et,ne,It="ZIP provides several advantages:",tt,ae,Ft="<li>Universally supported file format</li> <li>No additional dependencies for reading</li> <li>Built-in file indexing</li> <li>Wide language support</li>",st,ie,lt,oe,Wt='See the explanation in this <a href="https://github.com/huggingface/huggingface_hub/pull/2692#issuecomment-2519863726" rel="nofollow">comment</a>.',nt,pe,at,re,Rt="<li>Enables direct memory mapping of large files</li> <li>Ensures consistent and predictable remote file access</li> <li>Prevents CPU overhead during file reading</li> <li>Maintains compatibility with safetensors</li>",it,fe,ot,de,Lt="No. For now, DDUF files are designed to be immutable. To update a model, create a new DDUF file.",pt,me,rt,ce,Ht='<li><a href="https://github.com/huggingface/diffusers" rel="nofollow">Diffusers</a></li>',ft,he,Bt='We are constantly reaching out to other libraries and frameworks. If you are interested in adding support to your project, open a Discussion in the <a href="https://huggingface.co/spaces/DDUF/README/discussions" rel="nofollow">DDUF org</a>.',dt,ue,mt,Me,ct;return b=new j({props:{title:"DDUF",local:"dduf",headingTag:"h1"}}),v=new j({props:{title:"Overview",local:"overview",headingTag:"h2"}}),T=new Yt({props:{$$slots:{default:[Ot]},$$scope:{ctx:ge}}}),k=new j({props:{title:"Technical specifications",local:"technical-specifications",headingTag:"h2"}}),F=new j({props:{title:"Usage",local:"usage",headingTag:"h2"}}),R=new j({props:{title:"How to read a DDUF file?",local:"how-to-read-a-dduf-file",headingTag:"h3"}}),H=new ye({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJlYWRfZGR1Zl9maWxlJTBBJTBBZGR1Zl9lbnRyaWVzJTIwJTNEJTIwcmVhZF9kZHVmX2ZpbGUoJTIyRkxVWC4xLWRldi5kZHVmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> read_dduf_file

<span class="hljs-comment"># Read DDUF metadata</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dduf_entries = read_dduf_file(<span class="hljs-string">&quot;FLUX.1-dev.dduf&quot;</span>)`,wrap:!1}}),E=new ye({props:{code:"aW1wb3J0JTIwanNvbiUwQWpzb24ubG9hZHMoZGR1Zl9lbnRyaWVzJTVCJTIybW9kZWxfaW5kZXguanNvbiUyMiU1RC5yZWFkX3RleHQoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(dduf_entries[<span class="hljs-string">&quot;model_index.json&quot;</span>].read_text())
{<span class="hljs-string">&#x27;_class_name&#x27;</span>: <span class="hljs-string">&#x27;FluxPipeline&#x27;</span>, <span class="hljs-string">&#x27;_diffusers_version&#x27;</span>: <span class="hljs-string">&#x27;0.32.0.dev0&#x27;</span>, <span class="hljs-string">&#x27;_name_or_path&#x27;</span>: <span class="hljs-string">&#x27;black-forest-labs/FLUX.1-dev&#x27;</span>, ...`,wrap:!1}}),Y=new ye({props:{code:"aW1wb3J0JTIwc2FmZXRlbnNvcnMudG9yY2glMEF3aXRoJTIwZGR1Zl9lbnRyaWVzJTVCJTIydmFlJTJGZGlmZnVzaW9uX3B5dG9yY2hfbW9kZWwuc2FmZXRlbnNvcnMlMjIlNUQuYXNfbW1hcCgpJTIwYXMlMjBtbSUzQSUwQSUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlMjAlM0QlMjBzYWZldGVuc29ycy50b3JjaC5sb2FkKG1tKSUyMCUyMyUyMCU2MG1tJTYwJTIwaXMlMjBhJTIwYnl0ZXMlMjBvYmplY3Q=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> safetensors.torch\n<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> dduf_entries[<span class="hljs-string">&quot;vae/diffusion_pytorch_model.safetensors&quot;</span>].as_mmap() <span class="hljs-keyword">as</span> mm:\n<span class="hljs-meta">... </span>    state_dict = safetensors.torch.load(mm) <span class="hljs-comment"># `mm` is a bytes object</span>',wrap:!1}}),$=new Yt({props:{warning:!1,$$slots:{default:[es]},$$scope:{ctx:ge}}}),N=new j({props:{title:"How to write a DDUF file?",local:"how-to-write-a-dduf-file",headingTag:"h3"}}),S=new ye({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGV4cG9ydF9mb2xkZXJfYXNfZGR1ZiUwQWV4cG9ydF9mb2xkZXJfYXNfZGR1ZiglMjJGTFVYLjEtZGV2LmRkdWYlMjIlMkMlMjBmb2xkZXJfcGF0aCUzRCUyMnBhdGglMkZ0byUyRkZMVVguMS1kZXYlMjIp",highlighted:`<span class="hljs-comment"># Export a folder as a DDUF file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> export_folder_as_dduf
<span class="hljs-meta">&gt;&gt;&gt; </span>export_folder_as_dduf(<span class="hljs-string">&quot;FLUX.1-dev.dduf&quot;</span>, folder_path=<span class="hljs-string">&quot;path/to/FLUX.1-dev&quot;</span>)`,wrap:!1}}),A=new ye({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGV4cG9ydF9lbnRyaWVzX2FzX2RkdWYlMEFleHBvcnRfZW50cmllc19hc19kZHVmKCUwQSUyMCUyMCUyMCUyMGRkdWZfcGF0aCUzRCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNC1GUDE2LmRkdWYlMjIlMkMlMEElMjAlMjAlMjAlMjBlbnRyaWVzJTNEJTVCJTIwJTIzJTIwTGlzdCUyMGVudHJpZXMlMjB0byUyMGFkZCUyMHRvJTIwdGhlJTIwRERVRiUyMGZpbGUlMjAoaGVyZSUyQyUyMG9ubHklMjBGUDE2JTIwd2VpZ2h0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJTIybW9kZWxfaW5kZXguanNvbiUyMiUyQyUyMCUyMnBhdGglMkZ0byUyRm1vZGVsX2luZGV4Lmpzb24lMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCUyMnZhZSUyRmNvbmZpZy5qc29uJTIyJTJDJTIwJTIycGF0aCUyRnRvJTJGdmFlJTJGY29uZmlnLmpzb24lMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCUyMnZhZSUyRmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmZwMTYuc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJwYXRoJTJGdG8lMkZ2YWUlMkZkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5mcDE2LnNhZmV0ZW5zb3JzJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCglMjJ0ZXh0X2VuY29kZXIlMkZjb25maWcuanNvbiUyMiUyQyUyMCUyMnBhdGglMkZ0byUyRnRleHRfZW5jb2RlciUyRmNvbmZpZy5qc29uJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCglMjJ0ZXh0X2VuY29kZXIlMkZtb2RlbC5mcDE2LnNhZmV0ZW5zb3JzJTIyJTJDJTIwJTIycGF0aCUyRnRvJTJGdGV4dF9lbmNvZGVyJTJGbW9kZWwuZnAxNi5zYWZldGVuc29ycyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBhZGQlMjBtb3JlJTIwZW50cmllcyUyMGhlcmUlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-comment"># Export specific files from the local disk.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> export_entries_as_dduf
<span class="hljs-meta">&gt;&gt;&gt; </span>export_entries_as_dduf(
<span class="hljs-meta">... </span>    dduf_path=<span class="hljs-string">&quot;stable-diffusion-v1-4-FP16.dduf&quot;</span>,
<span class="hljs-meta">... </span>    entries=[ <span class="hljs-comment"># List entries to add to the DDUF file (here, only FP16 weights)</span>
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;model_index.json&quot;</span>, <span class="hljs-string">&quot;path/to/model_index.json&quot;</span>),
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;vae/config.json&quot;</span>, <span class="hljs-string">&quot;path/to/vae/config.json&quot;</span>),
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;vae/diffusion_pytorch_model.fp16.safetensors&quot;</span>, <span class="hljs-string">&quot;path/to/vae/diffusion_pytorch_model.fp16.safetensors&quot;</span>),
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;text_encoder/config.json&quot;</span>, <span class="hljs-string">&quot;path/to/text_encoder/config.json&quot;</span>),
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;text_encoder/model.fp16.safetensors&quot;</span>, <span class="hljs-string">&quot;path/to/text_encoder/model.fp16.safetensors&quot;</span>),
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ... add more entries here</span>
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new ye({props:{code:"JTBBZGVmJTIwYXNfZW50cmllcyhwaXBlJTNBJTIwRGlmZnVzaW9uUGlwZWxpbmUpJTIwLSUzRSUyMEdlbmVyYXRvciU1QlR1cGxlJTVCc3RyJTJDJTIwYnl0ZXMlNUQlMkMlMjBOb25lJTJDJTIwTm9uZSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEJ1aWxkJTIwYSUyMGdlbmVyYXRvciUyMHRoYXQlMjB5aWVsZHMlMjB0aGUlMjBlbnRyaWVzJTIwdG8lMjBhZGQlMjB0byUyMHRoZSUyMEREVUYlMjBmaWxlLiUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZSUyMGZpcnN0JTIwZWxlbWVudCUyMG9mJTIwdGhlJTIwdHVwbGUlMjBpcyUyMHRoZSUyMGZpbGVuYW1lJTIwaW4lMjB0aGUlMjBERFVGJTIwYXJjaGl2ZS4lMjBUaGUlMjBzZWNvbmQlMjBlbGVtZW50JTIwaXMlMjB0aGUlMjBjb250ZW50JTIwb2YlMjB0aGUlMjBmaWxlLiUwQSUyMCUyMCUyMCUyMCUyMyUyMEVudHJpZXMlMjB3aWxsJTIwYmUlMjBldmFsdWF0ZWQlMjBsYXppbHklMjB3aGVuJTIwdGhlJTIwRERVRiUyMGZpbGUlMjBpcyUyMGNyZWF0ZWQlMjAob25seSUyMDElMjBlbnRyeSUyMGlzJTIwbG9hZGVkJTIwaW4lMjBtZW1vcnklMjBhdCUyMGElMjB0aW1lKSUwQSUyMCUyMCUyMCUyMHlpZWxkJTIwJTIydmFlJTJGY29uZmlnLmpzb24lMjIlMkMlMjBwaXBlLnZhZS50b19qc29uX3N0cmluZygpLmVuY29kZSgpJTBBJTIwJTIwJTIwJTIweWllbGQlMjAlMjJ2YWUlMkZkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5zYWZldGVuc29ycyUyMiUyQyUyMHNhZmV0ZW5zb3JzLnRvcmNoLnNhdmUocGlwZS52YWUuc3RhdGVfZGljdCgpKSUwQSUyMCUyMCUyMCUyMHlpZWxkJTIwJTIydGV4dF9lbmNvZGVyJTJGY29uZmlnLmpzb24lMjIlMkMlMjBwaXBlLnRleHRfZW5jb2Rlci5jb25maWcudG9fanNvbl9zdHJpbmcoKS5lbmNvZGUoKSUwQSUyMCUyMCUyMCUyMHlpZWxkJTIwJTIydGV4dF9lbmNvZGVyJTJGbW9kZWwuc2FmZXRlbnNvcnMlMjIlMkMlMjBzYWZldGVuc29ycy50b3JjaC5zYXZlKHBpcGUudGV4dF9lbmNvZGVyLnN0YXRlX2RpY3QoKSklMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBhZGQlMjBtb3JlJTIwZW50cmllcyUyMGhlcmUlMEElMEFleHBvcnRfZW50cmllc19hc19kZHVmKGRkdWZfcGF0aCUzRCUyMm15LWNvb2wtZGlmZnVzaW9uLW1vZGVsLmRkdWYlMjIlMkMlMjBlbnRyaWVzJTNEYXNfZW50cmllcyhwaXBlKSk=",highlighted:`(...)

<span class="hljs-comment"># Export state_dicts one by one from a loaded pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">as_entries</span>(<span class="hljs-params">pipe: DiffusionPipeline</span>) -&gt; Generator[<span class="hljs-type">Tuple</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bytes</span>], <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Build a generator that yields the entries to add to the DDUF file.</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># The first element of the tuple is the filename in the DDUF archive. The second element is the content of the file.</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Entries will be evaluated lazily when the DDUF file is created (only 1 entry is loaded in memory at a time)</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;vae/config.json&quot;</span>, pipe.vae.to_json_string().encode()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;vae/diffusion_pytorch_model.safetensors&quot;</span>, safetensors.torch.save(pipe.vae.state_dict())
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;text_encoder/config.json&quot;</span>, pipe.text_encoder.config.to_json_string().encode()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;text_encoder/model.safetensors&quot;</span>, safetensors.torch.save(pipe.text_encoder.state_dict())
<span class="hljs-meta">... </span>    <span class="hljs-comment"># ... add more entries here</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>export_entries_as_dduf(dduf_path=<span class="hljs-string">&quot;my-cool-diffusion-model.dduf&quot;</span>, entries=as_entries(pipe))`,wrap:!1}}),O=new j({props:{title:"Loading a DDUF file with Diffusers",local:"loading-a-dduf-file-with-diffusers",headingTag:"h3"}}),te=new ye({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkREVUYlMkZGTFVYLjEtZGV2LUREVUYlMjIlMkMlMjBkZHVmX2ZpbGUlM0QlMjJGTFVYLjEtZGV2LmRkdWYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJwaG90byUyMGElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMERpZmZ1c2VycyUyMiUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMy41JTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;DDUF/FLUX.1-dev-DDUF&quot;</span>, dduf_file=<span class="hljs-string">&quot;FLUX.1-dev.dduf&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image = pipe(
    <span class="hljs-string">&quot;photo a cat holding a sign that says Diffusers&quot;</span>, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">3.5</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),se=new j({props:{title:"F.A.Q.",local:"faq",headingTag:"h2"}}),le=new j({props:{title:"Why build on top of ZIP?",local:"why-build-on-top-of-zip",headingTag:"h3"}}),ie=new j({props:{title:"Why not use a TAR with a table of contents at the beginning of the archive?",local:"why-not-use-a-tar-with-a-table-of-contents-at-the-beginning-of-the-archive",headingTag:"h3"}}),pe=new j({props:{title:"Why no compression?",local:"why-no-compression",headingTag:"h3"}}),fe=new j({props:{title:"Can I modify a DDUF file?",local:"can-i-modify-a-dduf-file",headingTag:"h3"}}),me=new j({props:{title:"Which frameworks/apps support DDUFs?",local:"which-frameworksapps-support-ddufs",headingTag:"h3"}}),ue=new Kt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/dduf.md"}}),{c(){r=i("meta"),U=n(),y=i("p"),g=n(),f(b.$$.fragment),M=n(),w=i("div"),w.innerHTML=ut,je=n(),f(v.$$.fragment),we=n(),Z=i("p"),Z.innerHTML=yt,Ue=n(),J=i("p"),J.innerHTML=gt,be=n(),_=i("p"),_.innerHTML=Mt,Te=n(),f(T.$$.fragment),$e=n(),G=i("p"),G.textContent=jt,ve=n(),C=i("ol"),C.innerHTML=wt,Ze=n(),f(k.$$.fragment),Je=n(),D=i("p"),D.innerHTML=Ut,_e=n(),x=i("ul"),x.innerHTML=bt,Ge=n(),I=i("p"),I.innerHTML=Tt,Ce=n(),f(F.$$.fragment),ke=n(),W=i("p"),W.innerHTML=$t,De=n(),f(R.$$.fragment),xe=n(),L=i("p"),L.innerHTML=vt,Ie=n(),f(H.$$.fragment),Fe=n(),B=i("p"),B.innerHTML=Zt,We=n(),V=i("p"),V.innerHTML=Jt,Re=n(),f(E.$$.fragment),Le=n(),X=i("p"),X.innerHTML=_t,He=n(),f(Y.$$.fragment),Be=n(),f($.$$.fragment),Ve=n(),f(N.$$.fragment),Ee=n(),q=i("p"),q.innerHTML=Gt,Xe=n(),f(S.$$.fragment),Ye=n(),z=i("p"),z.innerHTML=Ct,Ne=n(),P=i("p"),P.innerHTML=kt,qe=n(),f(A.$$.fragment),Se=n(),Q=i("p"),Q.innerHTML=Dt,ze=n(),f(K.$$.fragment),Pe=n(),f(O.$$.fragment),Ae=n(),ee=i("p"),ee.textContent=xt,Qe=n(),f(te.$$.fragment),Ke=n(),f(se.$$.fragment),Oe=n(),f(le.$$.fragment),et=n(),ne=i("p"),ne.textContent=It,tt=n(),ae=i("ul"),ae.innerHTML=Ft,st=n(),f(ie.$$.fragment),lt=n(),oe=i("p"),oe.innerHTML=Wt,nt=n(),f(pe.$$.fragment),at=n(),re=i("ul"),re.innerHTML=Rt,it=n(),f(fe.$$.fragment),ot=n(),de=i("p"),de.textContent=Lt,pt=n(),f(me.$$.fragment),rt=n(),ce=i("ul"),ce.innerHTML=Ht,ft=n(),he=i("p"),he.innerHTML=Bt,dt=n(),f(ue.$$.fragment),mt=n(),Me=i("p"),this.h()},l(e){const t=At("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(s),U=a(e),y=o(e,"P",{}),Xt(y).forEach(s),g=a(e),d(b.$$.fragment,e),M=a(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-uwodo1"&&(w.innerHTML=ut),je=a(e),d(v.$$.fragment,e),we=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-7klt1s"&&(Z.innerHTML=yt),Ue=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-16sdl9o"&&(J.innerHTML=gt),be=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-umdzam"&&(_.innerHTML=Mt),Te=a(e),d(T.$$.fragment,e),$e=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-5akq1a"&&(G.textContent=jt),ve=a(e),C=o(e,"OL",{"data-svelte-h":!0}),p(C)!=="svelte-5rkj06"&&(C.innerHTML=wt),Ze=a(e),d(k.$$.fragment,e),Je=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-ym2fu5"&&(D.innerHTML=Ut),_e=a(e),x=o(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-1c0l6r6"&&(x.innerHTML=bt),Ge=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-ewlv6m"&&(I.innerHTML=Tt),Ce=a(e),d(F.$$.fragment,e),ke=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1y6ujs0"&&(W.innerHTML=$t),De=a(e),d(R.$$.fragment,e),xe=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-61z4jx"&&(L.innerHTML=vt),Ie=a(e),d(H.$$.fragment,e),Fe=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-3tn1oa"&&(B.innerHTML=Zt),We=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1p2f8zq"&&(V.innerHTML=Jt),Re=a(e),d(E.$$.fragment,e),Le=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-143uvwp"&&(X.innerHTML=_t),He=a(e),d(Y.$$.fragment,e),Be=a(e),d($.$$.fragment,e),Ve=a(e),d(N.$$.fragment,e),Ee=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1wt9r80"&&(q.innerHTML=Gt),Xe=a(e),d(S.$$.fragment,e),Ye=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-umutob"&&(z.innerHTML=Ct),Ne=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1qiwegn"&&(P.innerHTML=kt),qe=a(e),d(A.$$.fragment,e),Se=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-82mgo8"&&(Q.innerHTML=Dt),ze=a(e),d(K.$$.fragment,e),Pe=a(e),d(O.$$.fragment,e),Ae=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1yk4tz4"&&(ee.textContent=xt),Qe=a(e),d(te.$$.fragment,e),Ke=a(e),d(se.$$.fragment,e),Oe=a(e),d(le.$$.fragment,e),et=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-jn7vtl"&&(ne.textContent=It),tt=a(e),ae=o(e,"UL",{"data-svelte-h":!0}),p(ae)!=="svelte-k91t7b"&&(ae.innerHTML=Ft),st=a(e),d(ie.$$.fragment,e),lt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-nx5ek0"&&(oe.innerHTML=Wt),nt=a(e),d(pe.$$.fragment,e),at=a(e),re=o(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-g8evt1"&&(re.innerHTML=Rt),it=a(e),d(fe.$$.fragment,e),ot=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-2hybhj"&&(de.textContent=Lt),pt=a(e),d(me.$$.fragment,e),rt=a(e),ce=o(e,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-11bupfp"&&(ce.innerHTML=Ht),ft=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1niq24m"&&(he.innerHTML=Bt),dt=a(e),d(ue.$$.fragment,e),mt=a(e),Me=o(e,"P",{}),Xt(Me).forEach(s),this.h()},h(){ht(r,"name","hf:doc:metadata"),ht(r,"content",ss),ht(w,"class","flex justify-center")},m(e,t){Qt(document.head,r),l(e,U,t),l(e,y,t),l(e,g,t),m(b,e,t),l(e,M,t),l(e,w,t),l(e,je,t),m(v,e,t),l(e,we,t),l(e,Z,t),l(e,Ue,t),l(e,J,t),l(e,be,t),l(e,_,t),l(e,Te,t),m(T,e,t),l(e,$e,t),l(e,G,t),l(e,ve,t),l(e,C,t),l(e,Ze,t),m(k,e,t),l(e,Je,t),l(e,D,t),l(e,_e,t),l(e,x,t),l(e,Ge,t),l(e,I,t),l(e,Ce,t),m(F,e,t),l(e,ke,t),l(e,W,t),l(e,De,t),m(R,e,t),l(e,xe,t),l(e,L,t),l(e,Ie,t),m(H,e,t),l(e,Fe,t),l(e,B,t),l(e,We,t),l(e,V,t),l(e,Re,t),m(E,e,t),l(e,Le,t),l(e,X,t),l(e,He,t),m(Y,e,t),l(e,Be,t),m($,e,t),l(e,Ve,t),m(N,e,t),l(e,Ee,t),l(e,q,t),l(e,Xe,t),m(S,e,t),l(e,Ye,t),l(e,z,t),l(e,Ne,t),l(e,P,t),l(e,qe,t),m(A,e,t),l(e,Se,t),l(e,Q,t),l(e,ze,t),m(K,e,t),l(e,Pe,t),m(O,e,t),l(e,Ae,t),l(e,ee,t),l(e,Qe,t),m(te,e,t),l(e,Ke,t),m(se,e,t),l(e,Oe,t),m(le,e,t),l(e,et,t),l(e,ne,t),l(e,tt,t),l(e,ae,t),l(e,st,t),m(ie,e,t),l(e,lt,t),l(e,oe,t),l(e,nt,t),m(pe,e,t),l(e,at,t),l(e,re,t),l(e,it,t),m(fe,e,t),l(e,ot,t),l(e,de,t),l(e,pt,t),m(me,e,t),l(e,rt,t),l(e,ce,t),l(e,ft,t),l(e,he,t),l(e,dt,t),m(ue,e,t),l(e,mt,t),l(e,Me,t),ct=!0},p(e,[t]){const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),T.$set(Vt);const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),$.$set(Et)},i(e){ct||(c(b.$$.fragment,e),c(v.$$.fragment,e),c(T.$$.fragment,e),c(k.$$.fragment,e),c(F.$$.fragment,e),c(R.$$.fragment,e),c(H.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c($.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(A.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(fe.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),ct=!0)},o(e){h(b.$$.fragment,e),h(v.$$.fragment,e),h(T.$$.fragment,e),h(k.$$.fragment,e),h(F.$$.fragment,e),h(R.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h($.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),ct=!1},d(e){e&&(s(U),s(y),s(g),s(M),s(w),s(je),s(we),s(Z),s(Ue),s(J),s(be),s(_),s(Te),s($e),s(G),s(ve),s(C),s(Ze),s(Je),s(D),s(_e),s(x),s(Ge),s(I),s(Ce),s(ke),s(W),s(De),s(xe),s(L),s(Ie),s(Fe),s(B),s(We),s(V),s(Re),s(Le),s(X),s(He),s(Be),s(Ve),s(Ee),s(q),s(Xe),s(Ye),s(z),s(Ne),s(P),s(qe),s(Se),s(Q),s(ze),s(Pe),s(Ae),s(ee),s(Qe),s(Ke),s(Oe),s(et),s(ne),s(tt),s(ae),s(st),s(lt),s(oe),s(nt),s(at),s(re),s(it),s(ot),s(de),s(pt),s(rt),s(ce),s(ft),s(he),s(dt),s(mt),s(Me)),s(r),u(b,e),u(v,e),u(T,e),u(k,e),u(F,e),u(R,e),u(H,e),u(E,e),u(Y,e),u($,e),u(N,e),u(S,e),u(A,e),u(K,e),u(O,e),u(te,e),u(se,e),u(le,e),u(ie,e),u(pe,e),u(fe,e),u(me,e),u(ue,e)}}}const ss='{"title":"DDUF","local":"dduf","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Technical specifications","local":"technical-specifications","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"How to read a DDUF file?","local":"how-to-read-a-dduf-file","sections":[],"depth":3},{"title":"How to write a DDUF file?","local":"how-to-write-a-dduf-file","sections":[],"depth":3},{"title":"Loading a DDUF file with Diffusers","local":"loading-a-dduf-file-with-diffusers","sections":[],"depth":3}],"depth":2},{"title":"F.A.Q.","local":"faq","sections":[{"title":"Why build on top of ZIP?","local":"why-build-on-top-of-zip","sections":[],"depth":3},{"title":"Why not use a TAR with a table of contents at the beginning of the archive?","local":"why-not-use-a-tar-with-a-table-of-contents-at-the-beginning-of-the-archive","sections":[],"depth":3},{"title":"Why no compression?","local":"why-no-compression","sections":[],"depth":3},{"title":"Can I modify a DDUF file?","local":"can-i-modify-a-dduf-file","sections":[],"depth":3},{"title":"Which frameworks/apps support DDUFs?","local":"which-frameworksapps-support-ddufs","sections":[],"depth":3}],"depth":2}],"depth":1}';function ls(ge){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends zt{constructor(r){super(),Pt(this,r,ls,ts,qt,{})}}export{rs as component};
