import{s as Gl,o as _l,n as I}from"../chunks/scheduler.8c3d61f6.js";import{S as Wl,i as vl,g as r,s as n,r as d,A as xl,h as c,f as l,c as i,j as Zl,u as h,x as u,k as Ul,y as kl,a as s,v as b,d as y,t as M,w}from"../chunks/index.da70eac4.js";import{T as Re}from"../chunks/Tip.1d9b8c37.js";import{C as G}from"../chunks/CodeBlock.a9c4becf.js";import{H as W,E as Cl}from"../chunks/getInferenceSnippets.4986d68f.js";import{H as Bl,a as Ft}from"../chunks/HfOption.6ab18950.js";function Xl(J){let a,T="bfloat16 is similar to float16 but it is more robust to numerical errors. Hardware support for bfloat16 varies, but most modern GPUs are capable of supporting bfloat16.",o,f,$;return f=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=r("p"),a.textContent=T,o=n(),d(f.$$.fragment)},l(m){a=c(m,"P",{"data-svelte-h":!0}),u(a)!=="svelte-kz0em0"&&(a.textContent=T),o=i(m),h(f.$$.fragment,m)},m(m,p){s(m,a,p),s(m,o,p),b(f,m,p),$=!0},p:I,i(m){$||(y(f.$$.fragment,m),$=!0)},o(m){M(f.$$.fragment,m),$=!1},d(m){m&&(l(a),l(o)),w(f,m)}}}function Rl(J){let a,T="float16 is similar to bfloat16 but may be more prone to numerical errors.",o,f,$;return f=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=r("p"),a.textContent=T,o=n(),d(f.$$.fragment)},l(m){a=c(m,"P",{"data-svelte-h":!0}),u(a)!=="svelte-nzm7ns"&&(a.textContent=T),o=i(m),h(f.$$.fragment,m)},m(m,p){s(m,a,p),s(m,o,p),b(f,m,p),$=!0},p:I,i(m){$||(y(f.$$.fragment,m),$=!0)},o(m){M(f.$$.fragment,m),$=!1},d(m){m&&(l(a),l(o)),w(f,m)}}}function Il(J){let a,T='<a href="https://blogs.nvidia.com/blog/2020/05/14/tensorfloat-32-precision-format/" rel="nofollow">TensorFloat-32 (tf32)</a> mode is supported on NVIDIA Ampere GPUs and it computes the convolution and matrix multiplication operations in tf32. Storage and other operations are kept in float32. This enables significantly faster computations when combined with bfloat16 or float16.',o,f,$="PyTorch only enables tf32 mode for convolutions by default and you’ll need to explicitly enable it for matrix multiplications.",m,p,j,Z,_='Refer to the <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_one#mixed-precision" rel="nofollow">mixed precision training</a> docs for more details.',v;return p=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXRvcmNoLmJhY2tlbmRzLmN1ZGEubWF0bXVsLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=r("p"),a.innerHTML=T,o=n(),f=r("p"),f.textContent=$,m=n(),d(p.$$.fragment),j=n(),Z=r("p"),Z.innerHTML=_},l(g){a=c(g,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1sdg1x4"&&(a.innerHTML=T),o=i(g),f=c(g,"P",{"data-svelte-h":!0}),u(f)!=="svelte-13cgegp"&&(f.textContent=$),m=i(g),h(p.$$.fragment,g),j=i(g),Z=c(g,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-uy7wpj"&&(Z.innerHTML=_)},m(g,U){s(g,a,U),s(g,o,U),s(g,f,U),s(g,m,U),b(p,g,U),s(g,j,U),s(g,Z,U),v=!0},p:I,i(g){v||(y(p.$$.fragment,g),v=!0)},o(g){M(p.$$.fragment,g),v=!1},d(g){g&&(l(a),l(o),l(f),l(m),l(j),l(Z)),w(p,g)}}}function Vl(J){let a,T,o,f,$,m;return a=new Ft({props:{id:"dtypes",option:"bfloat16",$$slots:{default:[Xl]},$$scope:{ctx:J}}}),o=new Ft({props:{id:"dtypes",option:"float16",$$slots:{default:[Rl]},$$scope:{ctx:J}}}),$=new Ft({props:{id:"dtypes",option:"TensorFloat-32",$$slots:{default:[Il]},$$scope:{ctx:J}}}),{c(){d(a.$$.fragment),T=n(),d(o.$$.fragment),f=n(),d($.$$.fragment)},l(p){h(a.$$.fragment,p),T=i(p),h(o.$$.fragment,p),f=i(p),h($.$$.fragment,p)},m(p,j){b(a,p,j),s(p,T,j),b(o,p,j),s(p,f,j),b($,p,j),m=!0},p(p,j){const Z={};j&2&&(Z.$$scope={dirty:j,ctx:p}),a.$set(Z);const _={};j&2&&(_.$$scope={dirty:j,ctx:p}),o.$set(_);const v={};j&2&&(v.$$scope={dirty:j,ctx:p}),$.$set(v)},i(p){m||(y(a.$$.fragment,p),y(o.$$.fragment,p),y($.$$.fragment,p),m=!0)},o(p){M(a.$$.fragment,p),M(o.$$.fragment,p),M($.$$.fragment,p),m=!1},d(p){p&&(l(T),l(f)),w(a,p),w(o,p),w($,p)}}}function Hl(J){let a,T='Memory-efficient attention optimizes for inference speed <em>and</em> <a href="./memory#memory-efficient-attention">memory usage</a>!';return{c(){a=r("p"),a.innerHTML=T},l(o){a=c(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-nfsjqr"&&(a.innerHTML=T)},m(o,f){s(o,a,f)},p:I,d(o){o&&l(a)}}}function Ll(J){let a,T='With PyTorch 2.3.1, you can control the caching behavior of torch.compile. This is particularly beneficial for compilation modes like <code>&quot;max-autotune&quot;</code> which performs a grid-search over several compilation flags to find the optimal configuration. Learn more in the <a href="https://pytorch.org/tutorials/recipes/torch_compile_caching_tutorial.html" rel="nofollow">Compile Time Caching in torch.compile</a> tutorial.';return{c(){a=r("p"),a.innerHTML=T},l(o){a=c(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1a730av"&&(a.innerHTML=T)},m(o,f){s(o,a,f)},p:I,d(o){o&&l(a)}}}function Nl(J){let a,T="Make sure to always use the nightly version of PyTorch for better support.";return{c(){a=r("p"),a.textContent=T},l(o){a=c(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1nw49au"&&(a.textContent=T)},m(o,f){s(o,a,f)},p:I,d(o){o&&l(a)}}}function Fl(J){let a,T='Refer to our <a href="../quantization/torchao">torchao</a> docs to learn more about how to use the Diffusers torchao integration.';return{c(){a=r("p"),a.innerHTML=T},l(o){a=c(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1h2qhs5"&&(a.innerHTML=T)},m(o,f){s(o,a,f)},p:I,d(o){o&&l(a)}}}function zl(J){let a,T='The <a href="https://github.com/huggingface/diffusers/blob/58431f102cf39c3c8a569f32d71b2ea8caa461e1/src/diffusers/pipelines/pipeline_utils.py#L2034" rel="nofollow">fuse_qkv_projections</a> method is experimental and support is limited to mostly Stable Diffusion pipelines. Take a look at this <a href="https://github.com/huggingface/diffusers/pull/6179" rel="nofollow">PR</a> to learn more about how to enable it for other pipelines';return{c(){a=r("p"),a.innerHTML=T},l(o){a=c(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-o2jj7j"&&(a.innerHTML=T)},m(o,f){s(o,a,f)},p:I,d(o){o&&l(a)}}}function Yl(J){let a,T,o,f,$,m,p,j='Diffusion models are slow at inference because generation is an iterative process where noise is gradually refined into an image or video over a certain number of “steps”. To speedup this process, you can try experimenting with different <a href="../api/schedulers/overview">schedulers</a>, reduce the precision of the model weights for faster computations, use more memory-efficient attention mechanisms, and more.',Z,_,v="Combine and use these techniques together to make inference faster than using any single technique on its own.",g,U,zt="This guide will go over how to accelerate inference.",Ie,V,Ve,H,Yt="The precision and data type of the model weights affect inference speed because a higher precision requires more memory to load and more time to perform the computations. PyTorch loads model weights in float32 or full precision by default, so changing the data type is a simple way to quickly get faster inference.",He,x,Le,L,Ne,k,Fe,N,Et='<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">Scaled dot product attention (SDPA)</a> implements several attention backends, <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a>, <a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a>, and a native C++ implementation. It automatically selects the most optimal backend for your hardware.',ze,F,St='SDPA is enabled by default if you’re using PyTorch &gt;= 2.0 and no additional changes are required to your code. You could try experimenting with other attention backends though if you’d like to choose your own. The example below uses the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html" rel="nofollow">torch.nn.attention.sdpa_kernel</a> context manager to enable efficient attention.',Ye,z,Ee,Y,Se,E,Qt='<a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> accelerates inference by compiling PyTorch code and operations into optimized kernels. Diffusers typically compiles the more compute-intensive models like the UNet, transformer, or VAE.',Qe,S,At='Enable the following compiler settings for maximum speed (refer to the <a href="https://github.com/pytorch/pytorch/blob/main/torch/_inductor/config.py" rel="nofollow">full list</a> for more options).',Ae,Q,qe,A,qt="Load and compile the UNet and VAE. There are several different modes you can choose from, but <code>&quot;max-autotune&quot;</code> optimizes for the fastest speed by compiling to a CUDA graph. CUDA graphs effectively reduces the overhead by launching multiple GPU operations through a single CPU operation.",Pe,C,De,q,Pt='Changing the memory layout to <a href="./memory#torchchannels_last">channels_last</a> also optimizes memory and inference speed.',Ke,P,Oe,D,Dt="Compilation is slow the first time, but once compiled, it is significantly faster. Try to only use the compiled pipeline on the same type of inference operations. Calling the compiled pipeline on a different image size retriggers compilation which is slow and inefficient.",et,K,tt,B,lt,O,Kt="<code>torch.compile</code> keeps track of input shapes and conditions, and if these are different, it recompiles the model. For example, if a model is compiled on a 1024x1024 resolution image and used on an image with a different resolution, it triggers recompilation.",st,ee,Ot="To avoid recompilation, add <code>dynamic=True</code> to try and generate a more dynamic kernel to avoid recompilation when conditions change.",at,te,nt,le,el='Specifying <code>use_duck_shape=False</code> instructs the compiler if it should use the same symbolic variable to represent input sizes that are the same. For more details, check out this <a href="https://github.com/huggingface/diffusers/pull/11327#discussion_r2047659790" rel="nofollow">comment</a>.',it,se,tl='Not all models may benefit from dynamic compilation out of the box and may require changes. Refer to this <a href="https://github.com/huggingface/diffusers/pull/11297/" rel="nofollow">PR</a> that improved the <a href="/docs/diffusers/main/en/api/pipelines/aura_flow#diffusers.AuraFlowPipeline">AuraFlowPipeline</a> implementation to benefit from dynamic compilation.',ot,ae,ll="Feel free to open an issue if dynamic compilation doesn’t work as expected for a Diffusers model.",pt,ne,rt,ie,sl=`<a href="https://docs.pytorch.org/tutorials/recipes/regional_compilation.html" rel="nofollow">Regional compilation</a> trims cold-start latency by compiling <strong>only the small, frequently-repeated block(s)</strong> of a model, typically a Transformer layer, enabling reuse of compiled artifacts for every subsequent occurrence.
For many diffusion architectures this delivers the <em>same</em> runtime speed-ups as full-graph compilation yet cuts compile time by <strong>8–10 ×</strong>.`,ct,oe,al='To make this effortless, <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> exposes <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.compile_repeated_blocks">ModelMixin.compile_repeated_blocks()</a> API, a helper that wraps <code>torch.compile</code> around any sub-modules you designate as repeatable:',mt,pe,ft,re,nl="To enable a new model with regional compilation, add a <code>_repeated_blocks</code> attribute to your model class containing the class names (as strings) of the blocks you want compiled:",ut,ce,dt,me,il='For more examples, see the reference <a href="https://github.com/huggingface/diffusers/pull/11705" rel="nofollow">PR</a>.',ht,fe,ol='<strong>Relation to Accelerate compile_regions</strong> There is also a separate API in <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">accelerate</a> - <a href="https://github.com/huggingface/accelerate/blob/273799c85d849a1954a4f2e65767216eb37fa089/src/accelerate/utils/other.py#L78" rel="nofollow">compile_regions</a>. It takes a fully automatic approach: it walks the module, picks candidate blocks, then compiles the remaining graph separately. That hands-off experience is handy for quick experiments, but it also leaves fewer knobs when you want to fine-tune which blocks are compiled or adjust compilation flags.',bt,ue,yt,de,pl="<code>compile_repeated_blocks</code>, by contrast, is intentionally explicit. You list the repeated blocks once (via <code>_repeated_blocks</code>) and the helper compiles exactly those, nothing more. In practice this small dose of control hits a sweet spot for diffusion models: predictable behavior, easy reasoning about cache reuse, and still a one-liner for users.",Mt,he,wt,be,rl="It is important to specify <code>fullgraph=True</code> in torch.compile to ensure there are no graph breaks in the underlying model. This allows you to take advantage of torch.compile without any performance degradation. For the UNet and VAE, this changes how you access the return variables.",Tt,ye,$t,Me,gt,we,cl='The <code>step()</code> function is <a href="https://github.com/huggingface/diffusers/blob/1d686bac8146037e97f3fd8c56e4063230f71751/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl.py#L1228" rel="nofollow">called</a> on the scheduler each time after the denoiser makes a prediction, and the <code>sigmas</code> variable is <a href="https://github.com/huggingface/diffusers/blob/1d686bac8146037e97f3fd8c56e4063230f71751/src/diffusers/schedulers/scheduling_euler_discrete.py#L476" rel="nofollow">indexed</a>. When placed on the GPU, it introduces latency because of the communication sync between the CPU and GPU. It becomes more evident when the denoiser has already been compiled.',Jt,Te,ml='In general, the <code>sigmas</code> should <a href="https://github.com/huggingface/diffusers/blob/35a969d297cba69110d175ee79c59312b9f49e1e/src/diffusers/schedulers/scheduling_euler_discrete.py#L240" rel="nofollow">stay on the CPU</a> to avoid the communication sync and latency.',jt,$e,Zt,ge,fl='Refer to the <a href="https://huggingface.co/datasets/diffusers/benchmarks" rel="nofollow">diffusers/benchmarks</a> dataset to see inference latency and memory usage data for compiled pipelines.',Ut,Je,ul='The <a href="https://github.com/sayakpaul/diffusers-torchao#benchmarking-results" rel="nofollow">diffusers-torchao</a> repository also contains benchmarking results for compiled versions of Flux and CogVideoX.',Gt,je,_t,Ze,dl='<a href="https://pytorch.org/tutorials/recipes/recipes/dynamic_quantization.html" rel="nofollow">Dynamic quantization</a> improves inference speed by reducing precision to enable faster math operations. This particular type of quantization determines how to scale the activations based on the data at runtime rather than using a fixed scaling factor. As a result, the scaling factor is more accurately aligned with the data.',Wt,Ue,hl='The example below applies <a href="https://pytorch.org/tutorials/recipes/recipes/dynamic_quantization.html" rel="nofollow">dynamic int8 quantization</a> to the UNet and VAE with the <a href="../quantization/torchao">torchao</a> library.',vt,X,xt,Ge,bl="Configure the compiler tags for maximum speed.",kt,_e,Ct,We,yl='Filter out some linear layers in the UNet and VAE which don’t benefit from dynamic quantization with the <a href="https://github.com/huggingface/diffusion-fast/blob/0f169640b1db106fe6a479f78c1ed3bfaeba3386/utils/pipeline_utils.py#L16" rel="nofollow">dynamic_quant_filter_fn</a>.',Bt,ve,Xt,xe,Rt,R,It,ke,Ml="An input is projected into three subspaces, represented by the projection matrices Q, K, and V, in an attention block. These projections are typically calculated separately, but you can horizontally combine these into a single matrix and perform the projection in a single step. It increases the size of the matrix multiplications of the input projections and also improves the impact of quantization.",Vt,Ce,Ht,Be,Lt,Xe,Nt;return $=new W({props:{title:"Accelerate inference",local:"accelerate-inference",headingTag:"h1"}}),V=new W({props:{title:"Model data type",local:"model-data-type",headingTag:"h2"}}),x=new Bl({props:{id:"dtypes",options:["bfloat16","float16","TensorFloat-32"],$$slots:{default:[Vl]},$$scope:{ctx:J}}}),L=new W({props:{title:"Scaled dot product attention",local:"scaled-dot-product-attention",headingTag:"h2"}}),k=new Re({props:{warning:!1,$$slots:{default:[Hl]},$$scope:{ctx:J}}}),z=new G({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmF0dGVudGlvbiUyMGltcG9ydCUyMFNEUEJhY2tlbmQlMkMlMjBzZHBhX2tlcm5lbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQXdpdGglMjBzZHBhX2tlcm5lbChTRFBCYWNrZW5kLkVGRklDSUVOVF9BVFRFTlRJT04pJTNBJTBBJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.EFFICIENT_ATTENTION):
  image = pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Y=new W({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),Q=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWU=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>`,wrap:!1}}),C=new Re({props:{warning:!1,$$slots:{default:[Ll]},$$scope:{ctx:J}}}),P=new G({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudW5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlbGluZS52YWUudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBcGlwZWxpbmUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUoJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlJTBBKSUwQXBpcGVsaW5lLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKCUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lLnZhZS5kZWNvZGUlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnVsbGdyYXBoJTNEVHJ1ZSUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.unet.to(memory_format=torch.channels_last)
pipeline.vae.to(memory_format=torch.channels_last)
pipeline.unet = torch.<span class="hljs-built_in">compile</span>(
    pipeline.unet, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>
)
pipeline.vae.decode = torch.<span class="hljs-built_in">compile</span>(
    pipeline.vae.decode,
    mode=<span class="hljs-string">&quot;max-autotune&quot;</span>,
    fullgraph=<span class="hljs-literal">True</span>
)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),K=new W({props:{title:"Dynamic shape compilation",local:"dynamic-shape-compilation",headingTag:"h3"}}),B=new Re({props:{warning:!1,$$slots:{default:[Nl]},$$scope:{ctx:J}}}),te=new G({props:{code:"JTJCJTIwdG9yY2guZnguZXhwZXJpbWVudGFsLl9jb25maWcudXNlX2R1Y2tfc2hhcGUlMjAlM0QlMjBGYWxzZSUwQSUyQiUyMHBpcGVsaW5lLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKCUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lLnVuZXQlMkMlMjBmdWxsZ3JhcGglM0RUcnVlJTJDJTIwZHluYW1pYyUzRFRydWUlMEEp",highlighted:`<span class="hljs-addition">+ torch.fx.experimental._config.use_duck_shape = False</span>
<span class="hljs-addition">+ pipeline.unet = torch.compile(</span>
    pipeline.unet, fullgraph=True, dynamic=True
)`,wrap:!1}}),ne=new W({props:{title:"Regional compilation",local:"regional-compilation",headingTag:"h3"}}),pe=new G({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMC1VJTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwQ29tcGlsZSUyMG9ubHklMjB0aGUlMjByZXBlYXRlZCUyMFRyYW5zZm9ybWVyJTIwbGF5ZXJzJTIwaW5zaWRlJTIwdGhlJTIwVU5ldCUwQXBpcGUudW5ldC5jb21waWxlX3JlcGVhdGVkX2Jsb2NrcyhmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`<span class="hljs-comment"># pip install -U diffusers</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Compile only the repeated Transformer layers inside the UNet</span>
pipe.unet.compile_repeated_blocks(fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),ce=new G({props:{code:"Y2xhc3MlMjBNeVVOZXQoTW9kZWxNaXhpbiklM0ElMEElMjAlMjAlMjAlMjBfcmVwZWF0ZWRfYmxvY2tzJTIwJTNEJTIwKCUyMlRyYW5zZm9ybWVyMkRNb2RlbCUyMiUyQyklMjAlMjAlMjMlMjAlRTIlODYlOTAlMjBjb21waWxlZCUyMGJ5JTIwZGVmYXVsdA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyUNet</span>(<span class="hljs-title class_ inherited__">ModelMixin</span>):
    _repeated_blocks = (<span class="hljs-string">&quot;Transformer2DModel&quot;</span>,)  <span class="hljs-comment"># ← compiled by default</span>`,wrap:!1}}),ue=new G({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMC1VJTIwYWNjZWxlcmF0ZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMGNvbXBpbGUlMjByZWdpb25zJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudW5ldCUyMCUzRCUyMGNvbXBpbGVfcmVnaW9ucyhwaXBlbGluZS51bmV0JTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUp",highlighted:`<span class="hljs-comment"># pip install -U accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> <span class="hljs-built_in">compile</span> regions

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.unet = compile_regions(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),he=new W({props:{title:"Graph breaks",local:"graph-breaks",headingTag:"h3"}}),ye=new G({props:{code:"LSUyMGxhdGVudHMlMjAlM0QlMjB1bmV0KCUwQS0lMjAlMjAlMjBsYXRlbnRzJTJDJTIwdGltZXN0ZXAlM0R0aW1lc3RlcCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRHByb21wdF9lbWJlZHMlMEEtKS5zYW1wbGUlMEElMEElMkIlMjBsYXRlbnRzJTIwJTNEJTIwdW5ldCglMEElMkIlMjAlMjAlMjBsYXRlbnRzJTJDJTIwdGltZXN0ZXAlM0R0aW1lc3RlcCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRHByb21wdF9lbWJlZHMlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlJTBBJTJCKSU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- latents = unet(</span>
<span class="hljs-deletion">-   latents, timestep=timestep, encoder_hidden_states=prompt_embeds</span>
<span class="hljs-deletion">-).sample</span>

<span class="hljs-addition">+ latents = unet(</span>
<span class="hljs-addition">+   latents, timestep=timestep, encoder_hidden_states=prompt_embeds, return_dict=False</span>
<span class="hljs-addition">+)[0]</span>`,wrap:!1}}),Me=new W({props:{title:"GPU sync",local:"gpu-sync",headingTag:"h3"}}),$e=new W({props:{title:"Benchmarks",local:"benchmarks",headingTag:"h3"}}),je=new W({props:{title:"Dynamic quantization",local:"dynamic-quantization",headingTag:"h2"}}),X=new Re({props:{warning:!1,$$slots:{default:[Fl]},$$scope:{ctx:J}}}),_e=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2hhbyUyMGltcG9ydCUyMGFwcGx5X2R5bmFtaWNfcXVhbnQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWUlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmZvcmNlX2Z1c2VfaW50X21tX3dpdGhfbXVsJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcudXNlX21peGVkX21tJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torchao <span class="hljs-keyword">import</span> apply_dynamic_quant
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>
torch._inductor.config.force_fuse_int_mm_with_mul = <span class="hljs-literal">True</span>
torch._inductor.config.use_mixed_mm = <span class="hljs-literal">True</span>`,wrap:!1}}),ve=new G({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWFwcGx5X2R5bmFtaWNfcXVhbnQocGlwZWxpbmUudW5ldCUyQyUyMGR5bmFtaWNfcXVhbnRfZmlsdGVyX2ZuKSUwQWFwcGx5X2R5bmFtaWNfcXVhbnQocGlwZWxpbmUudmFlJTJDJTIwZHluYW1pY19xdWFudF9maWx0ZXJfZm4pJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQXBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

apply_dynamic_quant(pipeline.unet, dynamic_quant_filter_fn)
apply_dynamic_quant(pipeline.vae, dynamic_quant_filter_fn)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),xe=new W({props:{title:"Fused projection matrices",local:"fused-projection-matrices",headingTag:"h2"}}),R=new Re({props:{warning:!0,$$slots:{default:[zl]},$$scope:{ctx:J}}}),Ce=new G({props:{code:"cGlwZWxpbmUuZnVzZV9xa3ZfcHJvamVjdGlvbnMoKQ==",highlighted:"pipeline.fuse_qkv_projections()",wrap:!1}}),Be=new Cl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/fp16.md"}}),{c(){a=r("meta"),T=n(),o=r("p"),f=n(),d($.$$.fragment),m=n(),p=r("p"),p.innerHTML=j,Z=n(),_=r("p"),_.textContent=v,g=n(),U=r("p"),U.textContent=zt,Ie=n(),d(V.$$.fragment),Ve=n(),H=r("p"),H.textContent=Yt,He=n(),d(x.$$.fragment),Le=n(),d(L.$$.fragment),Ne=n(),d(k.$$.fragment),Fe=n(),N=r("p"),N.innerHTML=Et,ze=n(),F=r("p"),F.innerHTML=St,Ye=n(),d(z.$$.fragment),Ee=n(),d(Y.$$.fragment),Se=n(),E=r("p"),E.innerHTML=Qt,Qe=n(),S=r("p"),S.innerHTML=At,Ae=n(),d(Q.$$.fragment),qe=n(),A=r("p"),A.innerHTML=qt,Pe=n(),d(C.$$.fragment),De=n(),q=r("p"),q.innerHTML=Pt,Ke=n(),d(P.$$.fragment),Oe=n(),D=r("p"),D.textContent=Dt,et=n(),d(K.$$.fragment),tt=n(),d(B.$$.fragment),lt=n(),O=r("p"),O.innerHTML=Kt,st=n(),ee=r("p"),ee.innerHTML=Ot,at=n(),d(te.$$.fragment),nt=n(),le=r("p"),le.innerHTML=el,it=n(),se=r("p"),se.innerHTML=tl,ot=n(),ae=r("p"),ae.textContent=ll,pt=n(),d(ne.$$.fragment),rt=n(),ie=r("p"),ie.innerHTML=sl,ct=n(),oe=r("p"),oe.innerHTML=al,mt=n(),d(pe.$$.fragment),ft=n(),re=r("p"),re.innerHTML=nl,ut=n(),d(ce.$$.fragment),dt=n(),me=r("p"),me.innerHTML=il,ht=n(),fe=r("p"),fe.innerHTML=ol,bt=n(),d(ue.$$.fragment),yt=n(),de=r("p"),de.innerHTML=pl,Mt=n(),d(he.$$.fragment),wt=n(),be=r("p"),be.innerHTML=rl,Tt=n(),d(ye.$$.fragment),$t=n(),d(Me.$$.fragment),gt=n(),we=r("p"),we.innerHTML=cl,Jt=n(),Te=r("p"),Te.innerHTML=ml,jt=n(),d($e.$$.fragment),Zt=n(),ge=r("p"),ge.innerHTML=fl,Ut=n(),Je=r("p"),Je.innerHTML=ul,Gt=n(),d(je.$$.fragment),_t=n(),Ze=r("p"),Ze.innerHTML=dl,Wt=n(),Ue=r("p"),Ue.innerHTML=hl,vt=n(),d(X.$$.fragment),xt=n(),Ge=r("p"),Ge.textContent=bl,kt=n(),d(_e.$$.fragment),Ct=n(),We=r("p"),We.innerHTML=yl,Bt=n(),d(ve.$$.fragment),Xt=n(),d(xe.$$.fragment),Rt=n(),d(R.$$.fragment),It=n(),ke=r("p"),ke.textContent=Ml,Vt=n(),d(Ce.$$.fragment),Ht=n(),d(Be.$$.fragment),Lt=n(),Xe=r("p"),this.h()},l(e){const t=xl("svelte-u9bgzb",document.head);a=c(t,"META",{name:!0,content:!0}),t.forEach(l),T=i(e),o=c(e,"P",{}),Zl(o).forEach(l),f=i(e),h($.$$.fragment,e),m=i(e),p=c(e,"P",{"data-svelte-h":!0}),u(p)!=="svelte-1m782be"&&(p.innerHTML=j),Z=i(e),_=c(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-wa2eaw"&&(_.textContent=v),g=i(e),U=c(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-1cgitz1"&&(U.textContent=zt),Ie=i(e),h(V.$$.fragment,e),Ve=i(e),H=c(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-18445ux"&&(H.textContent=Yt),He=i(e),h(x.$$.fragment,e),Le=i(e),h(L.$$.fragment,e),Ne=i(e),h(k.$$.fragment,e),Fe=i(e),N=c(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-zmbjuq"&&(N.innerHTML=Et),ze=i(e),F=c(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-5i9w75"&&(F.innerHTML=St),Ye=i(e),h(z.$$.fragment,e),Ee=i(e),h(Y.$$.fragment,e),Se=i(e),E=c(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-nqxvwk"&&(E.innerHTML=Qt),Qe=i(e),S=c(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-17o6ivw"&&(S.innerHTML=At),Ae=i(e),h(Q.$$.fragment,e),qe=i(e),A=c(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-dwk3fl"&&(A.innerHTML=qt),Pe=i(e),h(C.$$.fragment,e),De=i(e),q=c(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-lm2asr"&&(q.innerHTML=Pt),Ke=i(e),h(P.$$.fragment,e),Oe=i(e),D=c(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1jdqgot"&&(D.textContent=Dt),et=i(e),h(K.$$.fragment,e),tt=i(e),h(B.$$.fragment,e),lt=i(e),O=c(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-qjj81o"&&(O.innerHTML=Kt),st=i(e),ee=c(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-8dx0b8"&&(ee.innerHTML=Ot),at=i(e),h(te.$$.fragment,e),nt=i(e),le=c(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-1xsy0lm"&&(le.innerHTML=el),it=i(e),se=c(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-8qzwwy"&&(se.innerHTML=tl),ot=i(e),ae=c(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-ebyy21"&&(ae.textContent=ll),pt=i(e),h(ne.$$.fragment,e),rt=i(e),ie=c(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-7euy5i"&&(ie.innerHTML=sl),ct=i(e),oe=c(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-15kmr04"&&(oe.innerHTML=al),mt=i(e),h(pe.$$.fragment,e),ft=i(e),re=c(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1wy9oi8"&&(re.innerHTML=nl),ut=i(e),h(ce.$$.fragment,e),dt=i(e),me=c(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-rqg9pg"&&(me.innerHTML=il),ht=i(e),fe=c(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-196ol8t"&&(fe.innerHTML=ol),bt=i(e),h(ue.$$.fragment,e),yt=i(e),de=c(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-od0pok"&&(de.innerHTML=pl),Mt=i(e),h(he.$$.fragment,e),wt=i(e),be=c(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-12tqltr"&&(be.innerHTML=rl),Tt=i(e),h(ye.$$.fragment,e),$t=i(e),h(Me.$$.fragment,e),gt=i(e),we=c(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1gyzgx0"&&(we.innerHTML=cl),Jt=i(e),Te=c(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-13ty8ou"&&(Te.innerHTML=ml),jt=i(e),h($e.$$.fragment,e),Zt=i(e),ge=c(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-10dnlua"&&(ge.innerHTML=fl),Ut=i(e),Je=c(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-1kb6ks2"&&(Je.innerHTML=ul),Gt=i(e),h(je.$$.fragment,e),_t=i(e),Ze=c(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-13773d2"&&(Ze.innerHTML=dl),Wt=i(e),Ue=c(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1wm8cfw"&&(Ue.innerHTML=hl),vt=i(e),h(X.$$.fragment,e),xt=i(e),Ge=c(e,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-1rguzol"&&(Ge.textContent=bl),kt=i(e),h(_e.$$.fragment,e),Ct=i(e),We=c(e,"P",{"data-svelte-h":!0}),u(We)!=="svelte-applj5"&&(We.innerHTML=yl),Bt=i(e),h(ve.$$.fragment,e),Xt=i(e),h(xe.$$.fragment,e),Rt=i(e),h(R.$$.fragment,e),It=i(e),ke=c(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-1h88cib"&&(ke.textContent=Ml),Vt=i(e),h(Ce.$$.fragment,e),Ht=i(e),h(Be.$$.fragment,e),Lt=i(e),Xe=c(e,"P",{}),Zl(Xe).forEach(l),this.h()},h(){Ul(a,"name","hf:doc:metadata"),Ul(a,"content",El)},m(e,t){kl(document.head,a),s(e,T,t),s(e,o,t),s(e,f,t),b($,e,t),s(e,m,t),s(e,p,t),s(e,Z,t),s(e,_,t),s(e,g,t),s(e,U,t),s(e,Ie,t),b(V,e,t),s(e,Ve,t),s(e,H,t),s(e,He,t),b(x,e,t),s(e,Le,t),b(L,e,t),s(e,Ne,t),b(k,e,t),s(e,Fe,t),s(e,N,t),s(e,ze,t),s(e,F,t),s(e,Ye,t),b(z,e,t),s(e,Ee,t),b(Y,e,t),s(e,Se,t),s(e,E,t),s(e,Qe,t),s(e,S,t),s(e,Ae,t),b(Q,e,t),s(e,qe,t),s(e,A,t),s(e,Pe,t),b(C,e,t),s(e,De,t),s(e,q,t),s(e,Ke,t),b(P,e,t),s(e,Oe,t),s(e,D,t),s(e,et,t),b(K,e,t),s(e,tt,t),b(B,e,t),s(e,lt,t),s(e,O,t),s(e,st,t),s(e,ee,t),s(e,at,t),b(te,e,t),s(e,nt,t),s(e,le,t),s(e,it,t),s(e,se,t),s(e,ot,t),s(e,ae,t),s(e,pt,t),b(ne,e,t),s(e,rt,t),s(e,ie,t),s(e,ct,t),s(e,oe,t),s(e,mt,t),b(pe,e,t),s(e,ft,t),s(e,re,t),s(e,ut,t),b(ce,e,t),s(e,dt,t),s(e,me,t),s(e,ht,t),s(e,fe,t),s(e,bt,t),b(ue,e,t),s(e,yt,t),s(e,de,t),s(e,Mt,t),b(he,e,t),s(e,wt,t),s(e,be,t),s(e,Tt,t),b(ye,e,t),s(e,$t,t),b(Me,e,t),s(e,gt,t),s(e,we,t),s(e,Jt,t),s(e,Te,t),s(e,jt,t),b($e,e,t),s(e,Zt,t),s(e,ge,t),s(e,Ut,t),s(e,Je,t),s(e,Gt,t),b(je,e,t),s(e,_t,t),s(e,Ze,t),s(e,Wt,t),s(e,Ue,t),s(e,vt,t),b(X,e,t),s(e,xt,t),s(e,Ge,t),s(e,kt,t),b(_e,e,t),s(e,Ct,t),s(e,We,t),s(e,Bt,t),b(ve,e,t),s(e,Xt,t),b(xe,e,t),s(e,Rt,t),b(R,e,t),s(e,It,t),s(e,ke,t),s(e,Vt,t),b(Ce,e,t),s(e,Ht,t),b(Be,e,t),s(e,Lt,t),s(e,Xe,t),Nt=!0},p(e,[t]){const wl={};t&2&&(wl.$$scope={dirty:t,ctx:e}),x.$set(wl);const Tl={};t&2&&(Tl.$$scope={dirty:t,ctx:e}),k.$set(Tl);const $l={};t&2&&($l.$$scope={dirty:t,ctx:e}),C.$set($l);const gl={};t&2&&(gl.$$scope={dirty:t,ctx:e}),B.$set(gl);const Jl={};t&2&&(Jl.$$scope={dirty:t,ctx:e}),X.$set(Jl);const jl={};t&2&&(jl.$$scope={dirty:t,ctx:e}),R.$set(jl)},i(e){Nt||(y($.$$.fragment,e),y(V.$$.fragment,e),y(x.$$.fragment,e),y(L.$$.fragment,e),y(k.$$.fragment,e),y(z.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(C.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(B.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(ue.$$.fragment,e),y(he.$$.fragment,e),y(ye.$$.fragment,e),y(Me.$$.fragment,e),y($e.$$.fragment,e),y(je.$$.fragment,e),y(X.$$.fragment,e),y(_e.$$.fragment,e),y(ve.$$.fragment,e),y(xe.$$.fragment,e),y(R.$$.fragment,e),y(Ce.$$.fragment,e),y(Be.$$.fragment,e),Nt=!0)},o(e){M($.$$.fragment,e),M(V.$$.fragment,e),M(x.$$.fragment,e),M(L.$$.fragment,e),M(k.$$.fragment,e),M(z.$$.fragment,e),M(Y.$$.fragment,e),M(Q.$$.fragment,e),M(C.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(B.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(pe.$$.fragment,e),M(ce.$$.fragment,e),M(ue.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(Me.$$.fragment,e),M($e.$$.fragment,e),M(je.$$.fragment,e),M(X.$$.fragment,e),M(_e.$$.fragment,e),M(ve.$$.fragment,e),M(xe.$$.fragment,e),M(R.$$.fragment,e),M(Ce.$$.fragment,e),M(Be.$$.fragment,e),Nt=!1},d(e){e&&(l(T),l(o),l(f),l(m),l(p),l(Z),l(_),l(g),l(U),l(Ie),l(Ve),l(H),l(He),l(Le),l(Ne),l(Fe),l(N),l(ze),l(F),l(Ye),l(Ee),l(Se),l(E),l(Qe),l(S),l(Ae),l(qe),l(A),l(Pe),l(De),l(q),l(Ke),l(Oe),l(D),l(et),l(tt),l(lt),l(O),l(st),l(ee),l(at),l(nt),l(le),l(it),l(se),l(ot),l(ae),l(pt),l(rt),l(ie),l(ct),l(oe),l(mt),l(ft),l(re),l(ut),l(dt),l(me),l(ht),l(fe),l(bt),l(yt),l(de),l(Mt),l(wt),l(be),l(Tt),l($t),l(gt),l(we),l(Jt),l(Te),l(jt),l(Zt),l(ge),l(Ut),l(Je),l(Gt),l(_t),l(Ze),l(Wt),l(Ue),l(vt),l(xt),l(Ge),l(kt),l(Ct),l(We),l(Bt),l(Xt),l(Rt),l(It),l(ke),l(Vt),l(Ht),l(Lt),l(Xe)),l(a),w($,e),w(V,e),w(x,e),w(L,e),w(k,e),w(z,e),w(Y,e),w(Q,e),w(C,e),w(P,e),w(K,e),w(B,e),w(te,e),w(ne,e),w(pe,e),w(ce,e),w(ue,e),w(he,e),w(ye,e),w(Me,e),w($e,e),w(je,e),w(X,e),w(_e,e),w(ve,e),w(xe,e),w(R,e),w(Ce,e),w(Be,e)}}}const El='{"title":"Accelerate inference","local":"accelerate-inference","sections":[{"title":"Model data type","local":"model-data-type","sections":[],"depth":2},{"title":"Scaled dot product attention","local":"scaled-dot-product-attention","sections":[],"depth":2},{"title":"torch.compile","local":"torchcompile","sections":[{"title":"Dynamic shape compilation","local":"dynamic-shape-compilation","sections":[],"depth":3},{"title":"Regional compilation","local":"regional-compilation","sections":[],"depth":3},{"title":"Graph breaks","local":"graph-breaks","sections":[],"depth":3},{"title":"GPU sync","local":"gpu-sync","sections":[],"depth":3},{"title":"Benchmarks","local":"benchmarks","sections":[],"depth":3}],"depth":2},{"title":"Dynamic quantization","local":"dynamic-quantization","sections":[],"depth":2},{"title":"Fused projection matrices","local":"fused-projection-matrices","sections":[],"depth":2}],"depth":1}';function Sl(J){return _l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Wl{constructor(a){super(),vl(this,a,Sl,Yl,Gl,{})}}export{Ol as component};
