import{s as Xt,o as jt,n as It}from"../chunks/scheduler.182ea377.js";import{S as kt,i as Lt,g as a,s as o,r as g,A as Jt,h as r,f as n,c as s,j as w,u as h,x as f,k as M,y as t,a as p,v as _,d as b,t as v,w as y}from"../chunks/index.abf12888.js";import{T as Zt}from"../chunks/Tip.230e2334.js";import{D as $}from"../chunks/Docstring.93f6f462.js";import{C as Wt}from"../chunks/CodeBlock.57fe6e13.js";import{E as Gt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as pt}from"../chunks/Heading.16916d63.js";function Ft(se){let c,N='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=a("p"),c.innerHTML=N},l(u){c=r(u,"P",{"data-svelte-h":!0}),f(c)!=="svelte-1wmc0l4"&&(c.innerHTML=N)},m(u,S){p(u,c,S)},p:It,d(u){u&&n(c)}}}function Bt(se){let c,N="Examples:",u,S,x;return S=new Wt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetXSPipeline, ControlNetXSModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>   <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initialize the models and pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetXSModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;UmerHA/ConrolNetXS-SD2.1-canny&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetXSPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt, controlnet_conditioning_scale=controlnet_conditioning_scale, image=canny_image
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){c=a("p"),c.textContent=N,u=o(),g(S.$$.fragment)},l(m){c=r(m,"P",{"data-svelte-h":!0}),f(c)!=="svelte-kvfsh7"&&(c.textContent=N),u=s(m),h(S.$$.fragment,m)},m(m,T){p(m,c,T),p(m,u,T),_(S,m,T),x=!0},p:It,i(m){x||(b(S.$$.fragment,m),x=!0)},o(m){v(S.$$.fragment,m),x=!1},d(m){m&&(n(c),n(u)),y(S,m)}}}function Et(se){let c,N,u,S,x,m,T,ct='ControlNet-XS was introduced in <a href="https://vislearn.github.io/ControlNet-XS/" rel="nofollow">ControlNet-XS</a> by Denis Zavadski and Carsten Rother. It is based on the observation that the control model in the <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">original ControlNet</a> can be made much smaller and still produce good results.',Se,F,ft="Like the original ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",xe,B,mt='ControlNet-XS generates images with comparable quality to a regular ControlNet, but it is 20-25% faster (<a href="https://github.com/UmerHA/controlnet-xs-benchmark/blob/main/Speed%20Benchmark.ipynb" rel="nofollow">see benchmark</a> with StableDiffusion-XL) and uses ~45% less memory.',Ce,E,ut='Here’s the overview from the <a href="https://vislearn.github.io/ControlNet-XS/" rel="nofollow">project page</a>:',we,H,gt="<em>With increasing computing capabilities, current model architectures appear to follow the trend of simply upscaling all components without validating the necessity for doing so. In this project we investigate the size and architectural design of ControlNet [Zhang et al., 2023] for controlling the image generation process with stable diffusion-based models. We show that a new architecture with as little as 1% of the parameters of the base model achieves state-of-the art results, considerably better than ControlNet in terms of FID score. Hence we call it ControlNet-XS. We provide the code for controlling StableDiffusion-XL [Podell et al., 2023] (Model B, 48M Parameters) and StableDiffusion 2.1 [Rombach et al. 2022] (Model B, 14M Parameters), all under openrail license.</em>",Me,A,ht='This model was contributed by <a href="https://twitter.com/UmerHAdil" rel="nofollow">UmerHA</a>. ❤️',Te,I,Ne,Q,Pe,l,R,Ge,ie,_t="Pipeline for text-to-image generation using Stable Diffusion with ControlNet-XS guidance.",Fe,ae,bt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Be,re,vt="The pipeline also inherits the following loading methods:",Ee,le,yt='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">loaders.FromSingleFileMixin.from_single_file()</a> for loading <code>.ckpt</code> files</li>',He,P,Y,Ae,de,St="The call function to the pipeline for generation.",Qe,X,Re,j,V,Ye,pe,xt="Disables the FreeU mechanism if enabled.",Ve,k,z,ze,ce,Ct=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Oe,L,O,qe,fe,wt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ke,C,q,et,me,Mt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',tt,ue,Tt="The suffixes after the scaling factors represent the stages where they are being applied.",nt,ge,Nt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ot,J,K,st,he,Pt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,it,Z,ee,at,_e,$t=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,rt,W,te,lt,be,Dt="Encodes the prompt into text encoder hidden states.",$e,ne,De,D,oe,dt,ve,Ut="Output class for Stable Diffusion pipelines.",Ue,ye,Ie;return x=new pt({props:{title:"ControlNet-XS",local:"controlnet-xs",headingTag:"h1"}}),I=new Zt({props:{$$slots:{default:[Ft]},$$scope:{ctx:se}}}),Q=new pt({props:{title:"StableDiffusionControlNetXSPipeline",local:"diffusers.StableDiffusionControlNetXSPipeline",headingTag:"h2"}}),R=new $({props:{name:"class diffusers.StableDiffusionControlNetXSPipeline",anchor:"diffusers.StableDiffusionControlNetXSPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": ControlNetXSModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetXSPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.controlnet",description:`<strong>controlnet</strong> (<code>ControlNetXSModel</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L90"}}),Y=new $({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_guidance_start",val:": float = 0.0"},{name:"control_guidance_end",val:": float = 1.0"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L669",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),X=new Gt({props:{anchor:"diffusers.StableDiffusionControlNetXSPipeline.__call__.example",$$slots:{default:[Bt]},$$scope:{ctx:se}}}),V=new $({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionControlNetXSPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L665"}}),z=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetXSPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L193"}}),O=new $({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetXSPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L210"}}),q=new $({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionControlNetXSPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetXSPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L642"}}),K=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetXSPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L185"}}),ee=new $({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetXSPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L201"}}),te=new $({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetXSPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs.py#L251"}}),ne=new pt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),oe=new $({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),{c(){c=a("meta"),N=o(),u=a("p"),S=o(),g(x.$$.fragment),m=o(),T=a("p"),T.innerHTML=ct,Se=o(),F=a("p"),F.textContent=ft,xe=o(),B=a("p"),B.innerHTML=mt,Ce=o(),E=a("p"),E.innerHTML=ut,we=o(),H=a("p"),H.innerHTML=gt,Me=o(),A=a("p"),A.innerHTML=ht,Te=o(),g(I.$$.fragment),Ne=o(),g(Q.$$.fragment),Pe=o(),l=a("div"),g(R.$$.fragment),Ge=o(),ie=a("p"),ie.textContent=_t,Fe=o(),ae=a("p"),ae.innerHTML=bt,Be=o(),re=a("p"),re.textContent=vt,Ee=o(),le=a("ul"),le.innerHTML=yt,He=o(),P=a("div"),g(Y.$$.fragment),Ae=o(),de=a("p"),de.textContent=St,Qe=o(),g(X.$$.fragment),Re=o(),j=a("div"),g(V.$$.fragment),Ye=o(),pe=a("p"),pe.textContent=xt,Ve=o(),k=a("div"),g(z.$$.fragment),ze=o(),ce=a("p"),ce.innerHTML=Ct,Oe=o(),L=a("div"),g(O.$$.fragment),qe=o(),fe=a("p"),fe.innerHTML=wt,Ke=o(),C=a("div"),g(q.$$.fragment),et=o(),me=a("p"),me.innerHTML=Mt,tt=o(),ue=a("p"),ue.textContent=Tt,nt=o(),ge=a("p"),ge.innerHTML=Nt,ot=o(),J=a("div"),g(K.$$.fragment),st=o(),he=a("p"),he.textContent=Pt,it=o(),Z=a("div"),g(ee.$$.fragment),at=o(),_e=a("p"),_e.textContent=$t,rt=o(),W=a("div"),g(te.$$.fragment),lt=o(),be=a("p"),be.textContent=Dt,$e=o(),g(ne.$$.fragment),De=o(),D=a("div"),g(oe.$$.fragment),dt=o(),ve=a("p"),ve.textContent=Ut,Ue=o(),ye=a("p"),this.h()},l(e){const i=Jt("svelte-u9bgzb",document.head);c=r(i,"META",{name:!0,content:!0}),i.forEach(n),N=s(e),u=r(e,"P",{}),w(u).forEach(n),S=s(e),h(x.$$.fragment,e),m=s(e),T=r(e,"P",{"data-svelte-h":!0}),f(T)!=="svelte-p0mo4d"&&(T.innerHTML=ct),Se=s(e),F=r(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-6nd4qa"&&(F.textContent=ft),xe=s(e),B=r(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1ov0ouq"&&(B.innerHTML=mt),Ce=s(e),E=r(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1dkixh6"&&(E.innerHTML=ut),we=s(e),H=r(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1e1zrpk"&&(H.innerHTML=gt),Me=s(e),A=r(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-udfi85"&&(A.innerHTML=ht),Te=s(e),h(I.$$.fragment,e),Ne=s(e),h(Q.$$.fragment,e),Pe=s(e),l=r(e,"DIV",{class:!0});var d=w(l);h(R.$$.fragment,d),Ge=s(d),ie=r(d,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1jl2gdm"&&(ie.textContent=_t),Fe=s(d),ae=r(d,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-496sm0"&&(ae.innerHTML=bt),Be=s(d),re=r(d,"P",{"data-svelte-h":!0}),f(re)!=="svelte-14s6m4u"&&(re.textContent=vt),Ee=s(d),le=r(d,"UL",{"data-svelte-h":!0}),f(le)!=="svelte-1r7omn8"&&(le.innerHTML=yt),He=s(d),P=r(d,"DIV",{class:!0});var U=w(P);h(Y.$$.fragment,U),Ae=s(U),de=r(U,"P",{"data-svelte-h":!0}),f(de)!=="svelte-50j04k"&&(de.textContent=St),Qe=s(U),h(X.$$.fragment,U),U.forEach(n),Re=s(d),j=r(d,"DIV",{class:!0});var Xe=w(j);h(V.$$.fragment,Xe),Ye=s(Xe),pe=r(Xe,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-psupw6"&&(pe.textContent=xt),Xe.forEach(n),Ve=s(d),k=r(d,"DIV",{class:!0});var je=w(k);h(z.$$.fragment,je),ze=s(je),ce=r(je,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-1s3c06i"&&(ce.innerHTML=Ct),je.forEach(n),Oe=s(d),L=r(d,"DIV",{class:!0});var ke=w(L);h(O.$$.fragment,ke),qe=s(ke),fe=r(ke,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-pkn4ui"&&(fe.innerHTML=wt),ke.forEach(n),Ke=s(d),C=r(d,"DIV",{class:!0});var G=w(C);h(q.$$.fragment,G),et=s(G),me=r(G,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1f3tmq1"&&(me.innerHTML=Mt),tt=s(G),ue=r(G,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-xjijlp"&&(ue.textContent=Tt),nt=s(G),ge=r(G,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-hy0nzs"&&(ge.innerHTML=Nt),G.forEach(n),ot=s(d),J=r(d,"DIV",{class:!0});var Le=w(J);h(K.$$.fragment,Le),st=s(Le),he=r(Le,"P",{"data-svelte-h":!0}),f(he)!=="svelte-14bnrb6"&&(he.textContent=Pt),Le.forEach(n),it=s(d),Z=r(d,"DIV",{class:!0});var Je=w(Z);h(ee.$$.fragment,Je),at=s(Je),_e=r(Je,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-1xwrf7t"&&(_e.textContent=$t),Je.forEach(n),rt=s(d),W=r(d,"DIV",{class:!0});var Ze=w(W);h(te.$$.fragment,Ze),lt=s(Ze),be=r(Ze,"P",{"data-svelte-h":!0}),f(be)!=="svelte-16q0ax1"&&(be.textContent=Dt),Ze.forEach(n),d.forEach(n),$e=s(e),h(ne.$$.fragment,e),De=s(e),D=r(e,"DIV",{class:!0});var We=w(D);h(oe.$$.fragment,We),dt=s(We),ve=r(We,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-1qpjiuf"&&(ve.textContent=Ut),We.forEach(n),Ue=s(e),ye=r(e,"P",{}),w(ye).forEach(n),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",Ht),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,c),p(e,N,i),p(e,u,i),p(e,S,i),_(x,e,i),p(e,m,i),p(e,T,i),p(e,Se,i),p(e,F,i),p(e,xe,i),p(e,B,i),p(e,Ce,i),p(e,E,i),p(e,we,i),p(e,H,i),p(e,Me,i),p(e,A,i),p(e,Te,i),_(I,e,i),p(e,Ne,i),_(Q,e,i),p(e,Pe,i),p(e,l,i),_(R,l,null),t(l,Ge),t(l,ie),t(l,Fe),t(l,ae),t(l,Be),t(l,re),t(l,Ee),t(l,le),t(l,He),t(l,P),_(Y,P,null),t(P,Ae),t(P,de),t(P,Qe),_(X,P,null),t(l,Re),t(l,j),_(V,j,null),t(j,Ye),t(j,pe),t(l,Ve),t(l,k),_(z,k,null),t(k,ze),t(k,ce),t(l,Oe),t(l,L),_(O,L,null),t(L,qe),t(L,fe),t(l,Ke),t(l,C),_(q,C,null),t(C,et),t(C,me),t(C,tt),t(C,ue),t(C,nt),t(C,ge),t(l,ot),t(l,J),_(K,J,null),t(J,st),t(J,he),t(l,it),t(l,Z),_(ee,Z,null),t(Z,at),t(Z,_e),t(l,rt),t(l,W),_(te,W,null),t(W,lt),t(W,be),p(e,$e,i),_(ne,e,i),p(e,De,i),p(e,D,i),_(oe,D,null),t(D,dt),t(D,ve),p(e,Ue,i),p(e,ye,i),Ie=!0},p(e,[i]){const d={};i&2&&(d.$$scope={dirty:i,ctx:e}),I.$set(d);const U={};i&2&&(U.$$scope={dirty:i,ctx:e}),X.$set(U)},i(e){Ie||(b(x.$$.fragment,e),b(I.$$.fragment,e),b(Q.$$.fragment,e),b(R.$$.fragment,e),b(Y.$$.fragment,e),b(X.$$.fragment,e),b(V.$$.fragment,e),b(z.$$.fragment,e),b(O.$$.fragment,e),b(q.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(oe.$$.fragment,e),Ie=!0)},o(e){v(x.$$.fragment,e),v(I.$$.fragment,e),v(Q.$$.fragment,e),v(R.$$.fragment,e),v(Y.$$.fragment,e),v(X.$$.fragment,e),v(V.$$.fragment,e),v(z.$$.fragment,e),v(O.$$.fragment,e),v(q.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(ne.$$.fragment,e),v(oe.$$.fragment,e),Ie=!1},d(e){e&&(n(N),n(u),n(S),n(m),n(T),n(Se),n(F),n(xe),n(B),n(Ce),n(E),n(we),n(H),n(Me),n(A),n(Te),n(Ne),n(Pe),n(l),n($e),n(De),n(D),n(Ue),n(ye)),n(c),y(x,e),y(I,e),y(Q,e),y(R),y(Y),y(X),y(V),y(z),y(O),y(q),y(K),y(ee),y(te),y(ne,e),y(oe)}}}const Ht='{"title":"ControlNet-XS","local":"controlnet-xs","sections":[{"title":"StableDiffusionControlNetXSPipeline","local":"diffusers.StableDiffusionControlNetXSPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function At(se){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends kt{constructor(c){super(),Lt(this,c,At,Et,Xt,{})}}export{Kt as component};
