import{s as ws,n as Ps,o as Ms}from"../chunks/scheduler.0219f8bd.js";import{S as As,i as Rs,g as d,s as u,r as c,A as Qs,h as a,f as l,c as r,j as n,u as p,x as s,k as o,y as Es,a as i,v as h,d as f,t as m,w as T}from"../chunks/index.f61edf3b.js";import{H as y,E as Ns}from"../chunks/getInferenceSnippets.d4250027.js";function gs(Bd){let $,Cl,Ll,xl,_,kl,L,bl,v,Fd="Custom data structures.",Hl,C,Od=`These are only used internally, meaning an end-user shouldn’t
need to access anything here.`,wl,x,Gd='<li><a href="#module_utils/data-structures">utils/data-structures</a><ul><li><em>static</em><ul><li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+_siftUpFrom"><code>._siftUpFrom(node)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array.&lt;string&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li></ul></li> <li><a href="#module_utils/data-structures.DictionarySplitter">.DictionarySplitter</a><ul><li><a href="#new_module_utils/data-structures.DictionarySplitter_new"><code>new DictionarySplitter(dictionary)</code></a></li> <li><a href="#module_utils/data-structures.DictionarySplitter+split"><code>.split(text)</code></a> ⇒ <code>Array.&lt;string&gt;</code></li></ul></li> <li><a href="#module_utils/data-structures.LRUCache">.LRUCache</a><ul><li><a href="#new_module_utils/data-structures.LRUCache_new"><code>new LRUCache(capacity)</code></a></li> <li><a href="#module_utils/data-structures.LRUCache+get"><code>.get(key)</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.LRUCache+put"><code>.put(key, value)</code></a></li> <li><a href="#module_utils/data-structures.LRUCache+clear"><code>.clear()</code></a></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li> <li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li></ul></li></ul></li>',Pl,Ml,Al,k,Rl,b,Ql,H,Jd=`Efficient Heap-based Implementation of a Priority Queue.
It uses an array-based binary heap, where the root is at index <code>0</code>, and the
children of node <code>i</code> are located at indices <code>2i + 1</code> and <code>2i + 2</code>, respectively.`,El,w,Vd="Adapted from the following sources:",Nl,P,Wd='<li><a href="https://stackoverflow.com/a/42919752/13989043" rel="nofollow">https://stackoverflow.com/a/42919752/13989043</a> (original)</li> <li><a href="https://github.com/belladoreai/llama-tokenizer-js" rel="nofollow">https://github.com/belladoreai/llama-tokenizer-js</a> (minor improvements)</li>',gl,M,Xd='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',ql,A,Yd='<li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+_siftUpFrom"><code>._siftUpFrom(node)</code></a></li></ul></li>',Ul,Il,Dl,R,Sl,Q,zl,E,Zd="Create a new PriorityQueue.",Kl,N,ta="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>comparator</td><td><code>function</code></td><td><p>Comparator function to determine priority. Defaults to a MaxHeap.</p></td></tr></tbody>",jl,Bl,Fl,g,Ol,q,Gl,U,ea="The size of the queue",Jl,I,la='<strong>Kind</strong>: instance property of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',Vl,Wl,Xl,D,Yl,S,Zl,z,ia="Check if the queue is empty.",ti,K,ua='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - <code>true</code> if the queue is empty, <code>false</code> otherwise.',ei,li,ii,j,ui,B,ri,F,ra="Return the element with the highest priority in the queue.",di,O,da='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The highest priority element in the queue.',ai,si,oi,G,ni,J,ci,V,aa="Add one or more elements to the queue.",pi,W,sa='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',hi,X,oa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...values</td><td><code>any</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",fi,mi,Ti,Y,yi,Z,$i,tt,na="Add multiple elements to the queue.",_i,et,ca='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Li,lt,pa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>values</td><td><code>Array.&lt;any&gt;</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",vi,Ci,xi,it,ki,ut,bi,rt,ha="Remove and return the element with the highest priority in the queue.",Hi,dt,fa='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The element with the highest priority in the queue.',wi,Pi,Mi,at,Ai,st,Ri,ot,ma="Replace the element with the highest priority in the queue with a new value.",Qi,nt,Ta='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>*</code> - The replaced value.',Ei,ct,ya="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>value</td><td><code>*</code></td><td><p>The new value.</p></td></tr></tbody>",Ni,gi,qi,pt,Ui,ht,Ii,ft,$a="Helper function to sift up from a given node.",Di,mt,_a='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',Si,Tt,La="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>node</td><td><code>number</code></td><td><p>The index of the node to start sifting up from.</p></td></tr></tbody>",zi,Ki,ji,yt,Bi,$t,Fi,_t,va="A trie structure to efficiently store and search for strings.",Oi,Lt,Ca='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Gi,vt,xa='<li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li>',Ji,Vi,Wi,Ct,Xi,xt,Yi,kt,ka="Adds one or more <code>texts</code> to the trie.",Zi,bt,ba='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',tu,Ht,Ha="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;string&gt;</code></td><td><p>The strings to add to the trie.</p></td></tr></tbody>",eu,lu,iu,wt,uu,Pt,ru,Mt,wa="Adds text to the trie.",du,At,Pa='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',au,Rt,Ma="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The string to add to the trie.</p></td></tr></tbody>",su,ou,nu,Qt,cu,Et,pu,Nt,Aa="Searches the trie for all strings with a common prefix of <code>text</code>.",hu,gt,Ra='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',fu,qt,Qa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The common prefix to search for.</p></td></tr></tbody>",mu,Tu,yu,Ut,$u,It,_u,Dt,Ea="A lattice data structure to be used for tokenization.",Lu,St,Na='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',vu,zt,ga='<li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array.&lt;string&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li></ul></li>',Cu,xu,ku,Kt,bu,jt,Hu,Bt,qa="Creates a new TokenLattice instance.",wu,Ft,Ua="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>sentence</td><td><code>string</code></td><td><p>The input sentence to be tokenized.</p></td> </tr><tr><td>bosTokenId</td><td><code>number</code></td><td><p>The beginning-of-sequence token ID.</p></td> </tr><tr><td>eosTokenId</td><td><code>number</code></td><td><p>The end-of-sequence token ID.</p></td></tr></tbody>",Pu,Mu,Au,Ot,Ru,Gt,Qu,Jt,Ia="Inserts a new token node into the token lattice.",Eu,Vt,Da='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a>',Nu,Wt,Sa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score of the token.</p></td> </tr><tr><td>tokenId</td><td><code>number</code></td><td><p>The token ID of the token.</p></td></tr></tbody>",gu,qu,Uu,Xt,Iu,Yt,Du,Zt,za="Implements the Viterbi algorithm to compute the most likely sequence of tokens.",Su,te,Ka='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;TokenLatticeNode&gt;</code> - The most likely sequence of tokens.',zu,Ku,ju,ee,Bu,le,Fu,ie,ja='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>string</code> - The array of nodes representing the most likely sequence of tokens.',Ou,ue,Ba="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>node</td><td><code>TokenLatticeNode</code></td></tr></tbody>",Gu,Ju,Vu,re,Wu,de,Xu,ae,Fa='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;string&gt;</code> - The most likely sequence of tokens.',Yu,Zu,tr,se,er,oe,lr,ne,Oa='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The most likely sequence of token ids.',ir,ur,rr,ce,dr,pe,ar,he,Ga=`A data structure which uses a trie to split a string into tokens based on a dictionary.
It can also use a regular expression to preprocess the input text before splitting.`,sr,fe,Ja="NOTE: To ensure multi-byte characters are handled correctly, we operate at byte-level instead of character-level.",or,me,Va='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',nr,Te,Wa='<li><a href="#module_utils/data-structures.DictionarySplitter">.DictionarySplitter</a><ul><li><a href="#new_module_utils/data-structures.DictionarySplitter_new"><code>new DictionarySplitter(dictionary)</code></a></li> <li><a href="#module_utils/data-structures.DictionarySplitter+split"><code>.split(text)</code></a> ⇒ <code>Array.&lt;string&gt;</code></li></ul></li>',cr,pr,hr,ye,fr,$e,mr,_e,Xa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>dictionary</td><td><code>Array.&lt;string&gt;</code></td><td><p>The dictionary of words to use for splitting.</p></td></tr></tbody>",Tr,yr,$r,Le,_r,ve,Lr,Ce,Ya="Splits the input text into tokens based on the dictionary.",vr,xe,Za='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.DictionarySplitter"><code>DictionarySplitter</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;string&gt;</code> - An array of tokens.',Cr,ke,ts="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The input text to split.</p></td></tr></tbody>",xr,kr,br,be,Hr,He,wr,we,es=`A simple Least Recently Used (LRU) cache implementation in JavaScript.
This cache stores key-value pairs and evicts the least recently used item
when the capacity is exceeded.`,Pr,Pe,ls='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Mr,Me,is='<li><a href="#module_utils/data-structures.LRUCache">.LRUCache</a><ul><li><a href="#new_module_utils/data-structures.LRUCache_new"><code>new LRUCache(capacity)</code></a></li> <li><a href="#module_utils/data-structures.LRUCache+get"><code>.get(key)</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.LRUCache+put"><code>.put(key, value)</code></a></li> <li><a href="#module_utils/data-structures.LRUCache+clear"><code>.clear()</code></a></li></ul></li>',Ar,Rr,Qr,Ae,Er,Re,Nr,Qe,us="Creates an LRUCache instance.",gr,Ee,rs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>capacity</td><td><code>number</code></td><td><p>The maximum number of items the cache can hold.</p></td></tr></tbody>",qr,Ur,Ir,Ne,Dr,ge,Sr,qe,ds="Retrieves the value associated with the given key and marks the key as recently used.",zr,Ue,as='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.LRUCache"><code>LRUCache</code></a><br/> <strong>Returns</strong>: <code>any</code> - The value associated with the key, or undefined if the key does not exist.',Kr,Ie,ss="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>key</td><td><code>any</code></td><td><p>The key to retrieve.</p></td></tr></tbody>",jr,Br,Fr,De,Or,Se,Gr,ze,os=`Inserts or updates the key-value pair in the cache.
If the key already exists, it is updated and marked as recently used.
If the cache exceeds its capacity, the least recently used item is evicted.`,Jr,Ke,ns='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.LRUCache"><code>LRUCache</code></a>',Vr,je,cs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>key</td><td><code>any</code></td><td><p>The key to add or update.</p></td> </tr><tr><td>value</td><td><code>any</code></td><td><p>The value to associate with the key.</p></td></tr></tbody>",Wr,Xr,Yr,Be,Zr,Fe,td,Oe,ps="Clears the cache.",ed,Ge,hs='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.LRUCache"><code>LRUCache</code></a>',ld,id,ud,Je,rd,Ve,dd,We,fs="Represents a node in a character trie.",ad,Xe,ms='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',sd,Ye,Ts='<li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li>',od,nd,cd,Ze,pd,tl,hd,el,ys="Create a new CharTrieNode.",fd,ll,$s="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>isLeaf</td><td><code>boolean</code></td><td><p>Whether the node is a leaf node or not.</p></td> </tr><tr><td>children</td><td><code>Map.&lt;string, CharTrieNode&gt;</code></td><td><p>A map containing the node&#39;s children, where the key is a character and the value is a <code>CharTrieNode</code>.</p></td></tr></tbody>",md,Td,yd,il,$d,ul,_d,rl,_s="Returns a new <code>CharTrieNode</code> instance with default values.",Ld,dl,Ls='<strong>Kind</strong>: static method of <a href="#module_utils/data-structures..CharTrieNode"><code>CharTrieNode</code></a><br/> <strong>Returns</strong>: <code>CharTrieNode</code> - A new <code>CharTrieNode</code> instance with <code>isLeaf</code> set to <code>false</code> and an empty <code>children</code> map.',vd,Cd,xd,al,kd,sl,bd,ol,vs='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Hd,nl,Cs='<li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li>',wd,Pd,Md,cl,Ad,pl,Rd,hl,xs="Represents a node in a token lattice for a given sentence.",Qd,fl,ks="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tokenId</td><td><code>number</code></td><td><p>The ID of the token associated with this node.</p></td> </tr><tr><td>nodeId</td><td><code>number</code></td><td><p>The ID of this node.</p></td> </tr><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token in the sentence.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score associated with the token.</p></td></tr></tbody>",Ed,Nd,gd,ml,qd,Tl,Ud,yl,bs="Returns a clone of this node.",Id,$l,Hs='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures..TokenLatticeNode"><code>TokenLatticeNode</code></a><br/> <strong>Returns</strong>: <code>TokenLatticeNode</code> - A clone of this node.',Dd,Sd,zd,_l,Kd,vl,jd;return L=new y({props:{title:"utils/data-structures",local:"utilsdata-structures",headingTag:"h1"}}),b=new y({props:{title:"utils/data-structures.PriorityQueue",local:"utilsdata-structurespriorityqueue",headingTag:"h2"}}),Q=new y({props:{title:"new PriorityQueue(comparator)",local:"new-priorityqueuecomparator",headingTag:"h3"}}),q=new y({props:{title:"priorityQueue.size",local:"priorityqueuesize",headingTag:"h3"}}),S=new y({props:{title:"priorityQueue.isEmpty() ⇒ <code> boolean </code>",local:"priorityqueueisempty--code-boolean-code",headingTag:"h3"}}),B=new y({props:{title:"priorityQueue.peek() ⇒ <code> any </code>",local:"priorityqueuepeek--code-any-code",headingTag:"h3"}}),J=new y({props:{title:"priorityQueue.push(...values) ⇒ <code> number </code>",local:"priorityqueuepushvalues--code-number-code",headingTag:"h3"}}),Z=new y({props:{title:"priorityQueue.extend(values) ⇒ <code> number </code>",local:"priorityqueueextendvalues--code-number-code",headingTag:"h3"}}),ut=new y({props:{title:"priorityQueue.pop() ⇒ <code> any </code>",local:"priorityqueuepop--code-any-code",headingTag:"h3"}}),st=new y({props:{title:"priorityQueue.replace(value) ⇒ <code> * </code>",local:"priorityqueuereplacevalue--code--code",headingTag:"h3"}}),ht=new y({props:{title:"priorityQueue._siftUpFrom(node)",local:"priorityqueuesiftupfromnode",headingTag:"h3"}}),$t=new y({props:{title:"utils/data-structures.CharTrie",local:"utilsdata-structureschartrie",headingTag:"h2"}}),xt=new y({props:{title:"charTrie.extend(texts)",local:"chartrieextendtexts",headingTag:"h3"}}),Pt=new y({props:{title:"charTrie.push(text)",local:"chartriepushtext",headingTag:"h3"}}),Et=new y({props:{title:"charTrie.commonPrefixSearch(text)",local:"chartriecommonprefixsearchtext",headingTag:"h3"}}),It=new y({props:{title:"utils/data-structures.TokenLattice",local:"utilsdata-structurestokenlattice",headingTag:"h2"}}),jt=new y({props:{title:"new TokenLattice(sentence, bosTokenId, eosTokenId)",local:"new-tokenlatticesentence-bostokenid-eostokenid",headingTag:"h3"}}),Gt=new y({props:{title:"tokenLattice.insert(pos, length, score, tokenId)",local:"tokenlatticeinsertpos-length-score-tokenid",headingTag:"h3"}}),Yt=new y({props:{title:"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>",local:"tokenlatticeviterbi--code-array--tokenlatticenode--code",headingTag:"h3"}}),le=new y({props:{title:"tokenLattice.piece(node) ⇒ <code> string </code>",local:"tokenlatticepiecenode--code-string-code",headingTag:"h3"}}),de=new y({props:{title:"tokenLattice.tokens() ⇒ <code> Array. < string > </code>",local:"tokenlatticetokens--code-array--string--code",headingTag:"h3"}}),oe=new y({props:{title:"tokenLattice.tokenIds() ⇒ <code> Array. < number > </code>",local:"tokenlatticetokenids--code-array--number--code",headingTag:"h3"}}),pe=new y({props:{title:"utils/data-structures.DictionarySplitter",local:"utilsdata-structuresdictionarysplitter",headingTag:"h2"}}),$e=new y({props:{title:"new DictionarySplitter(dictionary)",local:"new-dictionarysplitterdictionary",headingTag:"h3"}}),ve=new y({props:{title:"dictionarySplitter.split(text) ⇒ <code> Array. < string > </code>",local:"dictionarysplittersplittext--code-array--string--code",headingTag:"h3"}}),He=new y({props:{title:"utils/data-structures.LRUCache",local:"utilsdata-structureslrucache",headingTag:"h2"}}),Re=new y({props:{title:"new LRUCache(capacity)",local:"new-lrucachecapacity",headingTag:"h3"}}),ge=new y({props:{title:"lruCache.get(key) ⇒ <code> any </code>",local:"lrucachegetkey--code-any-code",headingTag:"h3"}}),Se=new y({props:{title:"lruCache.put(key, value)",local:"lrucacheputkey-value",headingTag:"h3"}}),Fe=new y({props:{title:"lruCache.clear()",local:"lrucacheclear",headingTag:"h3"}}),Ve=new y({props:{title:"utils/data-structures~CharTrieNode",local:"utilsdata-structureschartrienode",headingTag:"h2"}}),tl=new y({props:{title:"new CharTrieNode(isLeaf, children)",local:"new-chartrienodeisleaf-children",headingTag:"h3"}}),ul=new y({props:{title:"CharTrieNode.default() ⇒ <code> CharTrieNode </code>",local:"chartrienodedefault--code-chartrienode-code",headingTag:"h3"}}),sl=new y({props:{title:"utils/data-structures~TokenLatticeNode",local:"utilsdata-structurestokenlatticenode",headingTag:"h2"}}),pl=new y({props:{title:"new TokenLatticeNode(tokenId, nodeId, pos, length, score)",local:"new-tokenlatticenodetokenid-nodeid-pos-length-score",headingTag:"h3"}}),Tl=new y({props:{title:"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>",local:"tokenlatticenodeclone--code-tokenlatticenode-code",headingTag:"h3"}}),_l=new Ns({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/data-structures.md"}}),{c(){$=d("meta"),Cl=u(),Ll=d("p"),xl=u(),_=d("a"),kl=u(),c(L.$$.fragment),bl=u(),v=d("p"),v.textContent=Fd,Hl=u(),C=d("p"),C.textContent=Od,wl=u(),x=d("ul"),x.innerHTML=Gd,Pl=u(),Ml=d("hr"),Al=u(),k=d("a"),Rl=u(),c(b.$$.fragment),Ql=u(),H=d("p"),H.innerHTML=Jd,El=u(),w=d("p"),w.textContent=Vd,Nl=u(),P=d("ul"),P.innerHTML=Wd,gl=u(),M=d("p"),M.innerHTML=Xd,ql=u(),A=d("ul"),A.innerHTML=Yd,Ul=u(),Il=d("hr"),Dl=u(),R=d("a"),Sl=u(),c(Q.$$.fragment),zl=u(),E=d("p"),E.textContent=Zd,Kl=u(),N=d("table"),N.innerHTML=ta,jl=u(),Bl=d("hr"),Fl=u(),g=d("a"),Ol=u(),c(q.$$.fragment),Gl=u(),U=d("p"),U.textContent=ea,Jl=u(),I=d("p"),I.innerHTML=la,Vl=u(),Wl=d("hr"),Xl=u(),D=d("a"),Yl=u(),c(S.$$.fragment),Zl=u(),z=d("p"),z.textContent=ia,ti=u(),K=d("p"),K.innerHTML=ua,ei=u(),li=d("hr"),ii=u(),j=d("a"),ui=u(),c(B.$$.fragment),ri=u(),F=d("p"),F.textContent=ra,di=u(),O=d("p"),O.innerHTML=da,ai=u(),si=d("hr"),oi=u(),G=d("a"),ni=u(),c(J.$$.fragment),ci=u(),V=d("p"),V.textContent=aa,pi=u(),W=d("p"),W.innerHTML=sa,hi=u(),X=d("table"),X.innerHTML=oa,fi=u(),mi=d("hr"),Ti=u(),Y=d("a"),yi=u(),c(Z.$$.fragment),$i=u(),tt=d("p"),tt.textContent=na,_i=u(),et=d("p"),et.innerHTML=ca,Li=u(),lt=d("table"),lt.innerHTML=pa,vi=u(),Ci=d("hr"),xi=u(),it=d("a"),ki=u(),c(ut.$$.fragment),bi=u(),rt=d("p"),rt.textContent=ha,Hi=u(),dt=d("p"),dt.innerHTML=fa,wi=u(),Pi=d("hr"),Mi=u(),at=d("a"),Ai=u(),c(st.$$.fragment),Ri=u(),ot=d("p"),ot.textContent=ma,Qi=u(),nt=d("p"),nt.innerHTML=Ta,Ei=u(),ct=d("table"),ct.innerHTML=ya,Ni=u(),gi=d("hr"),qi=u(),pt=d("a"),Ui=u(),c(ht.$$.fragment),Ii=u(),ft=d("p"),ft.textContent=$a,Di=u(),mt=d("p"),mt.innerHTML=_a,Si=u(),Tt=d("table"),Tt.innerHTML=La,zi=u(),Ki=d("hr"),ji=u(),yt=d("a"),Bi=u(),c($t.$$.fragment),Fi=u(),_t=d("p"),_t.textContent=va,Oi=u(),Lt=d("p"),Lt.innerHTML=Ca,Gi=u(),vt=d("ul"),vt.innerHTML=xa,Ji=u(),Vi=d("hr"),Wi=u(),Ct=d("a"),Xi=u(),c(xt.$$.fragment),Yi=u(),kt=d("p"),kt.innerHTML=ka,Zi=u(),bt=d("p"),bt.innerHTML=ba,tu=u(),Ht=d("table"),Ht.innerHTML=Ha,eu=u(),lu=d("hr"),iu=u(),wt=d("a"),uu=u(),c(Pt.$$.fragment),ru=u(),Mt=d("p"),Mt.textContent=wa,du=u(),At=d("p"),At.innerHTML=Pa,au=u(),Rt=d("table"),Rt.innerHTML=Ma,su=u(),ou=d("hr"),nu=u(),Qt=d("a"),cu=u(),c(Et.$$.fragment),pu=u(),Nt=d("p"),Nt.innerHTML=Aa,hu=u(),gt=d("p"),gt.innerHTML=Ra,fu=u(),qt=d("table"),qt.innerHTML=Qa,mu=u(),Tu=d("hr"),yu=u(),Ut=d("a"),$u=u(),c(It.$$.fragment),_u=u(),Dt=d("p"),Dt.textContent=Ea,Lu=u(),St=d("p"),St.innerHTML=Na,vu=u(),zt=d("ul"),zt.innerHTML=ga,Cu=u(),xu=d("hr"),ku=u(),Kt=d("a"),bu=u(),c(jt.$$.fragment),Hu=u(),Bt=d("p"),Bt.textContent=qa,wu=u(),Ft=d("table"),Ft.innerHTML=Ua,Pu=u(),Mu=d("hr"),Au=u(),Ot=d("a"),Ru=u(),c(Gt.$$.fragment),Qu=u(),Jt=d("p"),Jt.textContent=Ia,Eu=u(),Vt=d("p"),Vt.innerHTML=Da,Nu=u(),Wt=d("table"),Wt.innerHTML=Sa,gu=u(),qu=d("hr"),Uu=u(),Xt=d("a"),Iu=u(),c(Yt.$$.fragment),Du=u(),Zt=d("p"),Zt.textContent=za,Su=u(),te=d("p"),te.innerHTML=Ka,zu=u(),Ku=d("hr"),ju=u(),ee=d("a"),Bu=u(),c(le.$$.fragment),Fu=u(),ie=d("p"),ie.innerHTML=ja,Ou=u(),ue=d("table"),ue.innerHTML=Ba,Gu=u(),Ju=d("hr"),Vu=u(),re=d("a"),Wu=u(),c(de.$$.fragment),Xu=u(),ae=d("p"),ae.innerHTML=Fa,Yu=u(),Zu=d("hr"),tr=u(),se=d("a"),er=u(),c(oe.$$.fragment),lr=u(),ne=d("p"),ne.innerHTML=Oa,ir=u(),ur=d("hr"),rr=u(),ce=d("a"),dr=u(),c(pe.$$.fragment),ar=u(),he=d("p"),he.textContent=Ga,sr=u(),fe=d("p"),fe.textContent=Ja,or=u(),me=d("p"),me.innerHTML=Va,nr=u(),Te=d("ul"),Te.innerHTML=Wa,cr=u(),pr=d("hr"),hr=u(),ye=d("a"),fr=u(),c($e.$$.fragment),mr=u(),_e=d("table"),_e.innerHTML=Xa,Tr=u(),yr=d("hr"),$r=u(),Le=d("a"),_r=u(),c(ve.$$.fragment),Lr=u(),Ce=d("p"),Ce.textContent=Ya,vr=u(),xe=d("p"),xe.innerHTML=Za,Cr=u(),ke=d("table"),ke.innerHTML=ts,xr=u(),kr=d("hr"),br=u(),be=d("a"),Hr=u(),c(He.$$.fragment),wr=u(),we=d("p"),we.textContent=es,Pr=u(),Pe=d("p"),Pe.innerHTML=ls,Mr=u(),Me=d("ul"),Me.innerHTML=is,Ar=u(),Rr=d("hr"),Qr=u(),Ae=d("a"),Er=u(),c(Re.$$.fragment),Nr=u(),Qe=d("p"),Qe.textContent=us,gr=u(),Ee=d("table"),Ee.innerHTML=rs,qr=u(),Ur=d("hr"),Ir=u(),Ne=d("a"),Dr=u(),c(ge.$$.fragment),Sr=u(),qe=d("p"),qe.textContent=ds,zr=u(),Ue=d("p"),Ue.innerHTML=as,Kr=u(),Ie=d("table"),Ie.innerHTML=ss,jr=u(),Br=d("hr"),Fr=u(),De=d("a"),Or=u(),c(Se.$$.fragment),Gr=u(),ze=d("p"),ze.textContent=os,Jr=u(),Ke=d("p"),Ke.innerHTML=ns,Vr=u(),je=d("table"),je.innerHTML=cs,Wr=u(),Xr=d("hr"),Yr=u(),Be=d("a"),Zr=u(),c(Fe.$$.fragment),td=u(),Oe=d("p"),Oe.textContent=ps,ed=u(),Ge=d("p"),Ge.innerHTML=hs,ld=u(),id=d("hr"),ud=u(),Je=d("a"),rd=u(),c(Ve.$$.fragment),dd=u(),We=d("p"),We.textContent=fs,ad=u(),Xe=d("p"),Xe.innerHTML=ms,sd=u(),Ye=d("ul"),Ye.innerHTML=Ts,od=u(),nd=d("hr"),cd=u(),Ze=d("a"),pd=u(),c(tl.$$.fragment),hd=u(),el=d("p"),el.textContent=ys,fd=u(),ll=d("table"),ll.innerHTML=$s,md=u(),Td=d("hr"),yd=u(),il=d("a"),$d=u(),c(ul.$$.fragment),_d=u(),rl=d("p"),rl.innerHTML=_s,Ld=u(),dl=d("p"),dl.innerHTML=Ls,vd=u(),Cd=d("hr"),xd=u(),al=d("a"),kd=u(),c(sl.$$.fragment),bd=u(),ol=d("p"),ol.innerHTML=vs,Hd=u(),nl=d("ul"),nl.innerHTML=Cs,wd=u(),Pd=d("hr"),Md=u(),cl=d("a"),Ad=u(),c(pl.$$.fragment),Rd=u(),hl=d("p"),hl.textContent=xs,Qd=u(),fl=d("table"),fl.innerHTML=ks,Ed=u(),Nd=d("hr"),gd=u(),ml=d("a"),qd=u(),c(Tl.$$.fragment),Ud=u(),yl=d("p"),yl.textContent=bs,Id=u(),$l=d("p"),$l.innerHTML=Hs,Dd=u(),Sd=d("hr"),zd=u(),c(_l.$$.fragment),Kd=u(),vl=d("p"),this.h()},l(t){const e=Qs("svelte-u9bgzb",document.head);$=a(e,"META",{name:!0,content:!0}),e.forEach(l),Cl=r(t),Ll=a(t,"P",{}),n(Ll).forEach(l),xl=r(t),_=a(t,"A",{id:!0,class:!0}),n(_).forEach(l),kl=r(t),p(L.$$.fragment,t),bl=r(t),v=a(t,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1aeeeid"&&(v.textContent=Fd),Hl=r(t),C=a(t,"P",{"data-svelte-h":!0}),s(C)!=="svelte-1r3ntfo"&&(C.textContent=Od),wl=r(t),x=a(t,"UL",{"data-svelte-h":!0}),s(x)!=="svelte-1qp7cca"&&(x.innerHTML=Gd),Pl=r(t),Ml=a(t,"HR",{}),Al=r(t),k=a(t,"A",{id:!0,class:!0}),n(k).forEach(l),Rl=r(t),p(b.$$.fragment,t),Ql=r(t),H=a(t,"P",{"data-svelte-h":!0}),s(H)!=="svelte-1ux83uj"&&(H.innerHTML=Jd),El=r(t),w=a(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-vi2pz9"&&(w.textContent=Vd),Nl=r(t),P=a(t,"UL",{"data-svelte-h":!0}),s(P)!=="svelte-qlvgg9"&&(P.innerHTML=Wd),gl=r(t),M=a(t,"P",{"data-svelte-h":!0}),s(M)!=="svelte-1saulos"&&(M.innerHTML=Xd),ql=r(t),A=a(t,"UL",{"data-svelte-h":!0}),s(A)!=="svelte-fzyqbp"&&(A.innerHTML=Yd),Ul=r(t),Il=a(t,"HR",{}),Dl=r(t),R=a(t,"A",{id:!0,class:!0}),n(R).forEach(l),Sl=r(t),p(Q.$$.fragment,t),zl=r(t),E=a(t,"P",{"data-svelte-h":!0}),s(E)!=="svelte-1dgukb8"&&(E.textContent=Zd),Kl=r(t),N=a(t,"TABLE",{"data-svelte-h":!0}),s(N)!=="svelte-15lsmj7"&&(N.innerHTML=ta),jl=r(t),Bl=a(t,"HR",{}),Fl=r(t),g=a(t,"A",{id:!0,class:!0}),n(g).forEach(l),Ol=r(t),p(q.$$.fragment,t),Gl=r(t),U=a(t,"P",{"data-svelte-h":!0}),s(U)!=="svelte-19ll7y9"&&(U.textContent=ea),Jl=r(t),I=a(t,"P",{"data-svelte-h":!0}),s(I)!=="svelte-1spompf"&&(I.innerHTML=la),Vl=r(t),Wl=a(t,"HR",{}),Xl=r(t),D=a(t,"A",{id:!0,class:!0}),n(D).forEach(l),Yl=r(t),p(S.$$.fragment,t),Zl=r(t),z=a(t,"P",{"data-svelte-h":!0}),s(z)!=="svelte-iwo0ja"&&(z.textContent=ia),ti=r(t),K=a(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-usw3zo"&&(K.innerHTML=ua),ei=r(t),li=a(t,"HR",{}),ii=r(t),j=a(t,"A",{id:!0,class:!0}),n(j).forEach(l),ui=r(t),p(B.$$.fragment,t),ri=r(t),F=a(t,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1g38rzl"&&(F.textContent=ra),di=r(t),O=a(t,"P",{"data-svelte-h":!0}),s(O)!=="svelte-1jn2os3"&&(O.innerHTML=da),ai=r(t),si=a(t,"HR",{}),oi=r(t),G=a(t,"A",{id:!0,class:!0}),n(G).forEach(l),ni=r(t),p(J.$$.fragment,t),ci=r(t),V=a(t,"P",{"data-svelte-h":!0}),s(V)!=="svelte-1o3p42d"&&(V.textContent=aa),pi=r(t),W=a(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-1hty3q7"&&(W.innerHTML=sa),hi=r(t),X=a(t,"TABLE",{"data-svelte-h":!0}),s(X)!=="svelte-19plha1"&&(X.innerHTML=oa),fi=r(t),mi=a(t,"HR",{}),Ti=r(t),Y=a(t,"A",{id:!0,class:!0}),n(Y).forEach(l),yi=r(t),p(Z.$$.fragment,t),$i=r(t),tt=a(t,"P",{"data-svelte-h":!0}),s(tt)!=="svelte-1rf8gmz"&&(tt.textContent=na),_i=r(t),et=a(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-1hty3q7"&&(et.innerHTML=ca),Li=r(t),lt=a(t,"TABLE",{"data-svelte-h":!0}),s(lt)!=="svelte-txh99d"&&(lt.innerHTML=pa),vi=r(t),Ci=a(t,"HR",{}),xi=r(t),it=a(t,"A",{id:!0,class:!0}),n(it).forEach(l),ki=r(t),p(ut.$$.fragment,t),bi=r(t),rt=a(t,"P",{"data-svelte-h":!0}),s(rt)!=="svelte-1l3oksc"&&(rt.textContent=ha),Hi=r(t),dt=a(t,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-vpswb8"&&(dt.innerHTML=fa),wi=r(t),Pi=a(t,"HR",{}),Mi=r(t),at=a(t,"A",{id:!0,class:!0}),n(at).forEach(l),Ai=r(t),p(st.$$.fragment,t),Ri=r(t),ot=a(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-7s4t0d"&&(ot.textContent=ma),Qi=r(t),nt=a(t,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-ckytvb"&&(nt.innerHTML=Ta),Ei=r(t),ct=a(t,"TABLE",{"data-svelte-h":!0}),s(ct)!=="svelte-1xv2m9q"&&(ct.innerHTML=ya),Ni=r(t),gi=a(t,"HR",{}),qi=r(t),pt=a(t,"A",{id:!0,class:!0}),n(pt).forEach(l),Ui=r(t),p(ht.$$.fragment,t),Ii=r(t),ft=a(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-hj5sse"&&(ft.textContent=$a),Di=r(t),mt=a(t,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-6p6lmz"&&(mt.innerHTML=_a),Si=r(t),Tt=a(t,"TABLE",{"data-svelte-h":!0}),s(Tt)!=="svelte-fj2fu5"&&(Tt.innerHTML=La),zi=r(t),Ki=a(t,"HR",{}),ji=r(t),yt=a(t,"A",{id:!0,class:!0}),n(yt).forEach(l),Bi=r(t),p($t.$$.fragment,t),Fi=r(t),_t=a(t,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-nklgrc"&&(_t.textContent=va),Oi=r(t),Lt=a(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-1saulos"&&(Lt.innerHTML=Ca),Gi=r(t),vt=a(t,"UL",{"data-svelte-h":!0}),s(vt)!=="svelte-1yt2jf0"&&(vt.innerHTML=xa),Ji=r(t),Vi=a(t,"HR",{}),Wi=r(t),Ct=a(t,"A",{id:!0,class:!0}),n(Ct).forEach(l),Xi=r(t),p(xt.$$.fragment,t),Yi=r(t),kt=a(t,"P",{"data-svelte-h":!0}),s(kt)!=="svelte-moeq8l"&&(kt.innerHTML=ka),Zi=r(t),bt=a(t,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-33rax3"&&(bt.innerHTML=ba),tu=r(t),Ht=a(t,"TABLE",{"data-svelte-h":!0}),s(Ht)!=="svelte-18dtsnv"&&(Ht.innerHTML=Ha),eu=r(t),lu=a(t,"HR",{}),iu=r(t),wt=a(t,"A",{id:!0,class:!0}),n(wt).forEach(l),uu=r(t),p(Pt.$$.fragment,t),ru=r(t),Mt=a(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-4q846v"&&(Mt.textContent=wa),du=r(t),At=a(t,"P",{"data-svelte-h":!0}),s(At)!=="svelte-33rax3"&&(At.innerHTML=Pa),au=r(t),Rt=a(t,"TABLE",{"data-svelte-h":!0}),s(Rt)!=="svelte-hqwgb9"&&(Rt.innerHTML=Ma),su=r(t),ou=a(t,"HR",{}),nu=r(t),Qt=a(t,"A",{id:!0,class:!0}),n(Qt).forEach(l),cu=r(t),p(Et.$$.fragment,t),pu=r(t),Nt=a(t,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-bmaw98"&&(Nt.innerHTML=Aa),hu=r(t),gt=a(t,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-33rax3"&&(gt.innerHTML=Ra),fu=r(t),qt=a(t,"TABLE",{"data-svelte-h":!0}),s(qt)!=="svelte-18qxh0x"&&(qt.innerHTML=Qa),mu=r(t),Tu=a(t,"HR",{}),yu=r(t),Ut=a(t,"A",{id:!0,class:!0}),n(Ut).forEach(l),$u=r(t),p(It.$$.fragment,t),_u=r(t),Dt=a(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-1xkinx1"&&(Dt.textContent=Ea),Lu=r(t),St=a(t,"P",{"data-svelte-h":!0}),s(St)!=="svelte-1saulos"&&(St.innerHTML=Na),vu=r(t),zt=a(t,"UL",{"data-svelte-h":!0}),s(zt)!=="svelte-12y4jvx"&&(zt.innerHTML=ga),Cu=r(t),xu=a(t,"HR",{}),ku=r(t),Kt=a(t,"A",{id:!0,class:!0}),n(Kt).forEach(l),bu=r(t),p(jt.$$.fragment,t),Hu=r(t),Bt=a(t,"P",{"data-svelte-h":!0}),s(Bt)!=="svelte-ziiz62"&&(Bt.textContent=qa),wu=r(t),Ft=a(t,"TABLE",{"data-svelte-h":!0}),s(Ft)!=="svelte-1h8dv5n"&&(Ft.innerHTML=Ua),Pu=r(t),Mu=a(t,"HR",{}),Au=r(t),Ot=a(t,"A",{id:!0,class:!0}),n(Ot).forEach(l),Ru=r(t),p(Gt.$$.fragment,t),Qu=r(t),Jt=a(t,"P",{"data-svelte-h":!0}),s(Jt)!=="svelte-1hzq3te"&&(Jt.textContent=Ia),Eu=r(t),Vt=a(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-1bjyh7n"&&(Vt.innerHTML=Da),Nu=r(t),Wt=a(t,"TABLE",{"data-svelte-h":!0}),s(Wt)!=="svelte-1a01i2a"&&(Wt.innerHTML=Sa),gu=r(t),qu=a(t,"HR",{}),Uu=r(t),Xt=a(t,"A",{id:!0,class:!0}),n(Xt).forEach(l),Iu=r(t),p(Yt.$$.fragment,t),Du=r(t),Zt=a(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-jv0r"&&(Zt.textContent=za),Su=r(t),te=a(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1hp113b"&&(te.innerHTML=Ka),zu=r(t),Ku=a(t,"HR",{}),ju=r(t),ee=a(t,"A",{id:!0,class:!0}),n(ee).forEach(l),Bu=r(t),p(le.$$.fragment,t),Fu=r(t),ie=a(t,"P",{"data-svelte-h":!0}),s(ie)!=="svelte-1n9zjoi"&&(ie.innerHTML=ja),Ou=r(t),ue=a(t,"TABLE",{"data-svelte-h":!0}),s(ue)!=="svelte-6nufyb"&&(ue.innerHTML=Ba),Gu=r(t),Ju=a(t,"HR",{}),Vu=r(t),re=a(t,"A",{id:!0,class:!0}),n(re).forEach(l),Wu=r(t),p(de.$$.fragment,t),Xu=r(t),ae=a(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1ipxykz"&&(ae.innerHTML=Fa),Yu=r(t),Zu=a(t,"HR",{}),tr=r(t),se=a(t,"A",{id:!0,class:!0}),n(se).forEach(l),er=r(t),p(oe.$$.fragment,t),lr=r(t),ne=a(t,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-1nolezc"&&(ne.innerHTML=Oa),ir=r(t),ur=a(t,"HR",{}),rr=r(t),ce=a(t,"A",{id:!0,class:!0}),n(ce).forEach(l),dr=r(t),p(pe.$$.fragment,t),ar=r(t),he=a(t,"P",{"data-svelte-h":!0}),s(he)!=="svelte-1d71m1c"&&(he.textContent=Ga),sr=r(t),fe=a(t,"P",{"data-svelte-h":!0}),s(fe)!=="svelte-13fkdt9"&&(fe.textContent=Ja),or=r(t),me=a(t,"P",{"data-svelte-h":!0}),s(me)!=="svelte-1saulos"&&(me.innerHTML=Va),nr=r(t),Te=a(t,"UL",{"data-svelte-h":!0}),s(Te)!=="svelte-728se6"&&(Te.innerHTML=Wa),cr=r(t),pr=a(t,"HR",{}),hr=r(t),ye=a(t,"A",{id:!0,class:!0}),n(ye).forEach(l),fr=r(t),p($e.$$.fragment,t),mr=r(t),_e=a(t,"TABLE",{"data-svelte-h":!0}),s(_e)!=="svelte-d113ps"&&(_e.innerHTML=Xa),Tr=r(t),yr=a(t,"HR",{}),$r=r(t),Le=a(t,"A",{id:!0,class:!0}),n(Le).forEach(l),_r=r(t),p(ve.$$.fragment,t),Lr=r(t),Ce=a(t,"P",{"data-svelte-h":!0}),s(Ce)!=="svelte-ussbd6"&&(Ce.textContent=Ya),vr=r(t),xe=a(t,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-kdhwpe"&&(xe.innerHTML=Za),Cr=r(t),ke=a(t,"TABLE",{"data-svelte-h":!0}),s(ke)!=="svelte-raiep6"&&(ke.innerHTML=ts),xr=r(t),kr=a(t,"HR",{}),br=r(t),be=a(t,"A",{id:!0,class:!0}),n(be).forEach(l),Hr=r(t),p(He.$$.fragment,t),wr=r(t),we=a(t,"P",{"data-svelte-h":!0}),s(we)!=="svelte-19p0c6a"&&(we.textContent=es),Pr=r(t),Pe=a(t,"P",{"data-svelte-h":!0}),s(Pe)!=="svelte-1saulos"&&(Pe.innerHTML=ls),Mr=r(t),Me=a(t,"UL",{"data-svelte-h":!0}),s(Me)!=="svelte-1m9fa6y"&&(Me.innerHTML=is),Ar=r(t),Rr=a(t,"HR",{}),Qr=r(t),Ae=a(t,"A",{id:!0,class:!0}),n(Ae).forEach(l),Er=r(t),p(Re.$$.fragment,t),Nr=r(t),Qe=a(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1wrhlc6"&&(Qe.textContent=us),gr=r(t),Ee=a(t,"TABLE",{"data-svelte-h":!0}),s(Ee)!=="svelte-1puj8on"&&(Ee.innerHTML=rs),qr=r(t),Ur=a(t,"HR",{}),Ir=r(t),Ne=a(t,"A",{id:!0,class:!0}),n(Ne).forEach(l),Dr=r(t),p(ge.$$.fragment,t),Sr=r(t),qe=a(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-u7qnnu"&&(qe.textContent=ds),zr=r(t),Ue=a(t,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-15ir7qc"&&(Ue.innerHTML=as),Kr=r(t),Ie=a(t,"TABLE",{"data-svelte-h":!0}),s(Ie)!=="svelte-7pa8k3"&&(Ie.innerHTML=ss),jr=r(t),Br=a(t,"HR",{}),Fr=r(t),De=a(t,"A",{id:!0,class:!0}),n(De).forEach(l),Or=r(t),p(Se.$$.fragment,t),Gr=r(t),ze=a(t,"P",{"data-svelte-h":!0}),s(ze)!=="svelte-13y3987"&&(ze.textContent=os),Jr=r(t),Ke=a(t,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-134bybf"&&(Ke.innerHTML=ns),Vr=r(t),je=a(t,"TABLE",{"data-svelte-h":!0}),s(je)!=="svelte-1urvam6"&&(je.innerHTML=cs),Wr=r(t),Xr=a(t,"HR",{}),Yr=r(t),Be=a(t,"A",{id:!0,class:!0}),n(Be).forEach(l),Zr=r(t),p(Fe.$$.fragment,t),td=r(t),Oe=a(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1rw967f"&&(Oe.textContent=ps),ed=r(t),Ge=a(t,"P",{"data-svelte-h":!0}),s(Ge)!=="svelte-134bybf"&&(Ge.innerHTML=hs),ld=r(t),id=a(t,"HR",{}),ud=r(t),Je=a(t,"A",{id:!0,class:!0}),n(Je).forEach(l),rd=r(t),p(Ve.$$.fragment,t),dd=r(t),We=a(t,"P",{"data-svelte-h":!0}),s(We)!=="svelte-1auz3rh"&&(We.textContent=fs),ad=r(t),Xe=a(t,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-1p9ver0"&&(Xe.innerHTML=ms),sd=r(t),Ye=a(t,"UL",{"data-svelte-h":!0}),s(Ye)!=="svelte-4v7sww"&&(Ye.innerHTML=Ts),od=r(t),nd=a(t,"HR",{}),cd=r(t),Ze=a(t,"A",{id:!0,class:!0}),n(Ze).forEach(l),pd=r(t),p(tl.$$.fragment,t),hd=r(t),el=a(t,"P",{"data-svelte-h":!0}),s(el)!=="svelte-mt1jex"&&(el.textContent=ys),fd=r(t),ll=a(t,"TABLE",{"data-svelte-h":!0}),s(ll)!=="svelte-nk427c"&&(ll.innerHTML=$s),md=r(t),Td=a(t,"HR",{}),yd=r(t),il=a(t,"A",{id:!0,class:!0}),n(il).forEach(l),$d=r(t),p(ul.$$.fragment,t),_d=r(t),rl=a(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-9cjdkj"&&(rl.innerHTML=_s),Ld=r(t),dl=a(t,"P",{"data-svelte-h":!0}),s(dl)!=="svelte-3pigfy"&&(dl.innerHTML=Ls),vd=r(t),Cd=a(t,"HR",{}),xd=r(t),al=a(t,"A",{id:!0,class:!0}),n(al).forEach(l),kd=r(t),p(sl.$$.fragment,t),bd=r(t),ol=a(t,"P",{"data-svelte-h":!0}),s(ol)!=="svelte-1p9ver0"&&(ol.innerHTML=vs),Hd=r(t),nl=a(t,"UL",{"data-svelte-h":!0}),s(nl)!=="svelte-r6qh2h"&&(nl.innerHTML=Cs),wd=r(t),Pd=a(t,"HR",{}),Md=r(t),cl=a(t,"A",{id:!0,class:!0}),n(cl).forEach(l),Ad=r(t),p(pl.$$.fragment,t),Rd=r(t),hl=a(t,"P",{"data-svelte-h":!0}),s(hl)!=="svelte-vrhdhn"&&(hl.textContent=xs),Qd=r(t),fl=a(t,"TABLE",{"data-svelte-h":!0}),s(fl)!=="svelte-5ahzuq"&&(fl.innerHTML=ks),Ed=r(t),Nd=a(t,"HR",{}),gd=r(t),ml=a(t,"A",{id:!0,class:!0}),n(ml).forEach(l),qd=r(t),p(Tl.$$.fragment,t),Ud=r(t),yl=a(t,"P",{"data-svelte-h":!0}),s(yl)!=="svelte-34g670"&&(yl.textContent=bs),Id=r(t),$l=a(t,"P",{"data-svelte-h":!0}),s($l)!=="svelte-7303j9"&&($l.innerHTML=Hs),Dd=r(t),Sd=a(t,"HR",{}),zd=r(t),p(_l.$$.fragment,t),Kd=r(t),vl=a(t,"P",{}),n(vl).forEach(l),this.h()},h(){o($,"name","hf:doc:metadata"),o($,"content",qs),o(_,"id","module_utils/data-structures"),o(_,"class","group"),o(k,"id","module_utils/data-structures.PriorityQueue"),o(k,"class","group"),o(R,"id","new_module_utils/data-structures.PriorityQueue_new"),o(R,"class","group"),o(g,"id","module_utils/data-structures.PriorityQueue+size"),o(g,"class","group"),o(D,"id","module_utils/data-structures.PriorityQueue+isEmpty"),o(D,"class","group"),o(j,"id","module_utils/data-structures.PriorityQueue+peek"),o(j,"class","group"),o(G,"id","module_utils/data-structures.PriorityQueue+push"),o(G,"class","group"),o(Y,"id","module_utils/data-structures.PriorityQueue+extend"),o(Y,"class","group"),o(it,"id","module_utils/data-structures.PriorityQueue+pop"),o(it,"class","group"),o(at,"id","module_utils/data-structures.PriorityQueue+replace"),o(at,"class","group"),o(pt,"id","module_utils/data-structures.PriorityQueue+_siftUpFrom"),o(pt,"class","group"),o(yt,"id","module_utils/data-structures.CharTrie"),o(yt,"class","group"),o(Ct,"id","module_utils/data-structures.CharTrie+extend"),o(Ct,"class","group"),o(wt,"id","module_utils/data-structures.CharTrie+push"),o(wt,"class","group"),o(Qt,"id","module_utils/data-structures.CharTrie+commonPrefixSearch"),o(Qt,"class","group"),o(Ut,"id","module_utils/data-structures.TokenLattice"),o(Ut,"class","group"),o(Kt,"id","new_module_utils/data-structures.TokenLattice_new"),o(Kt,"class","group"),o(Ot,"id","module_utils/data-structures.TokenLattice+insert"),o(Ot,"class","group"),o(Xt,"id","module_utils/data-structures.TokenLattice+viterbi"),o(Xt,"class","group"),o(ee,"id","module_utils/data-structures.TokenLattice+piece"),o(ee,"class","group"),o(re,"id","module_utils/data-structures.TokenLattice+tokens"),o(re,"class","group"),o(se,"id","module_utils/data-structures.TokenLattice+tokenIds"),o(se,"class","group"),o(ce,"id","module_utils/data-structures.DictionarySplitter"),o(ce,"class","group"),o(ye,"id","new_module_utils/data-structures.DictionarySplitter_new"),o(ye,"class","group"),o(Le,"id","module_utils/data-structures.DictionarySplitter+split"),o(Le,"class","group"),o(be,"id","module_utils/data-structures.LRUCache"),o(be,"class","group"),o(Ae,"id","new_module_utils/data-structures.LRUCache_new"),o(Ae,"class","group"),o(Ne,"id","module_utils/data-structures.LRUCache+get"),o(Ne,"class","group"),o(De,"id","module_utils/data-structures.LRUCache+put"),o(De,"class","group"),o(Be,"id","module_utils/data-structures.LRUCache+clear"),o(Be,"class","group"),o(Je,"id","module_utils/data-structures..CharTrieNode"),o(Je,"class","group"),o(Ze,"id","new_module_utils/data-structures..CharTrieNode_new"),o(Ze,"class","group"),o(il,"id","module_utils/data-structures..CharTrieNode.default"),o(il,"class","group"),o(al,"id","module_utils/data-structures..TokenLatticeNode"),o(al,"class","group"),o(cl,"id","new_module_utils/data-structures..TokenLatticeNode_new"),o(cl,"class","group"),o(ml,"id","module_utils/data-structures..TokenLatticeNode+clone"),o(ml,"class","group")},m(t,e){Es(document.head,$),i(t,Cl,e),i(t,Ll,e),i(t,xl,e),i(t,_,e),i(t,kl,e),h(L,t,e),i(t,bl,e),i(t,v,e),i(t,Hl,e),i(t,C,e),i(t,wl,e),i(t,x,e),i(t,Pl,e),i(t,Ml,e),i(t,Al,e),i(t,k,e),i(t,Rl,e),h(b,t,e),i(t,Ql,e),i(t,H,e),i(t,El,e),i(t,w,e),i(t,Nl,e),i(t,P,e),i(t,gl,e),i(t,M,e),i(t,ql,e),i(t,A,e),i(t,Ul,e),i(t,Il,e),i(t,Dl,e),i(t,R,e),i(t,Sl,e),h(Q,t,e),i(t,zl,e),i(t,E,e),i(t,Kl,e),i(t,N,e),i(t,jl,e),i(t,Bl,e),i(t,Fl,e),i(t,g,e),i(t,Ol,e),h(q,t,e),i(t,Gl,e),i(t,U,e),i(t,Jl,e),i(t,I,e),i(t,Vl,e),i(t,Wl,e),i(t,Xl,e),i(t,D,e),i(t,Yl,e),h(S,t,e),i(t,Zl,e),i(t,z,e),i(t,ti,e),i(t,K,e),i(t,ei,e),i(t,li,e),i(t,ii,e),i(t,j,e),i(t,ui,e),h(B,t,e),i(t,ri,e),i(t,F,e),i(t,di,e),i(t,O,e),i(t,ai,e),i(t,si,e),i(t,oi,e),i(t,G,e),i(t,ni,e),h(J,t,e),i(t,ci,e),i(t,V,e),i(t,pi,e),i(t,W,e),i(t,hi,e),i(t,X,e),i(t,fi,e),i(t,mi,e),i(t,Ti,e),i(t,Y,e),i(t,yi,e),h(Z,t,e),i(t,$i,e),i(t,tt,e),i(t,_i,e),i(t,et,e),i(t,Li,e),i(t,lt,e),i(t,vi,e),i(t,Ci,e),i(t,xi,e),i(t,it,e),i(t,ki,e),h(ut,t,e),i(t,bi,e),i(t,rt,e),i(t,Hi,e),i(t,dt,e),i(t,wi,e),i(t,Pi,e),i(t,Mi,e),i(t,at,e),i(t,Ai,e),h(st,t,e),i(t,Ri,e),i(t,ot,e),i(t,Qi,e),i(t,nt,e),i(t,Ei,e),i(t,ct,e),i(t,Ni,e),i(t,gi,e),i(t,qi,e),i(t,pt,e),i(t,Ui,e),h(ht,t,e),i(t,Ii,e),i(t,ft,e),i(t,Di,e),i(t,mt,e),i(t,Si,e),i(t,Tt,e),i(t,zi,e),i(t,Ki,e),i(t,ji,e),i(t,yt,e),i(t,Bi,e),h($t,t,e),i(t,Fi,e),i(t,_t,e),i(t,Oi,e),i(t,Lt,e),i(t,Gi,e),i(t,vt,e),i(t,Ji,e),i(t,Vi,e),i(t,Wi,e),i(t,Ct,e),i(t,Xi,e),h(xt,t,e),i(t,Yi,e),i(t,kt,e),i(t,Zi,e),i(t,bt,e),i(t,tu,e),i(t,Ht,e),i(t,eu,e),i(t,lu,e),i(t,iu,e),i(t,wt,e),i(t,uu,e),h(Pt,t,e),i(t,ru,e),i(t,Mt,e),i(t,du,e),i(t,At,e),i(t,au,e),i(t,Rt,e),i(t,su,e),i(t,ou,e),i(t,nu,e),i(t,Qt,e),i(t,cu,e),h(Et,t,e),i(t,pu,e),i(t,Nt,e),i(t,hu,e),i(t,gt,e),i(t,fu,e),i(t,qt,e),i(t,mu,e),i(t,Tu,e),i(t,yu,e),i(t,Ut,e),i(t,$u,e),h(It,t,e),i(t,_u,e),i(t,Dt,e),i(t,Lu,e),i(t,St,e),i(t,vu,e),i(t,zt,e),i(t,Cu,e),i(t,xu,e),i(t,ku,e),i(t,Kt,e),i(t,bu,e),h(jt,t,e),i(t,Hu,e),i(t,Bt,e),i(t,wu,e),i(t,Ft,e),i(t,Pu,e),i(t,Mu,e),i(t,Au,e),i(t,Ot,e),i(t,Ru,e),h(Gt,t,e),i(t,Qu,e),i(t,Jt,e),i(t,Eu,e),i(t,Vt,e),i(t,Nu,e),i(t,Wt,e),i(t,gu,e),i(t,qu,e),i(t,Uu,e),i(t,Xt,e),i(t,Iu,e),h(Yt,t,e),i(t,Du,e),i(t,Zt,e),i(t,Su,e),i(t,te,e),i(t,zu,e),i(t,Ku,e),i(t,ju,e),i(t,ee,e),i(t,Bu,e),h(le,t,e),i(t,Fu,e),i(t,ie,e),i(t,Ou,e),i(t,ue,e),i(t,Gu,e),i(t,Ju,e),i(t,Vu,e),i(t,re,e),i(t,Wu,e),h(de,t,e),i(t,Xu,e),i(t,ae,e),i(t,Yu,e),i(t,Zu,e),i(t,tr,e),i(t,se,e),i(t,er,e),h(oe,t,e),i(t,lr,e),i(t,ne,e),i(t,ir,e),i(t,ur,e),i(t,rr,e),i(t,ce,e),i(t,dr,e),h(pe,t,e),i(t,ar,e),i(t,he,e),i(t,sr,e),i(t,fe,e),i(t,or,e),i(t,me,e),i(t,nr,e),i(t,Te,e),i(t,cr,e),i(t,pr,e),i(t,hr,e),i(t,ye,e),i(t,fr,e),h($e,t,e),i(t,mr,e),i(t,_e,e),i(t,Tr,e),i(t,yr,e),i(t,$r,e),i(t,Le,e),i(t,_r,e),h(ve,t,e),i(t,Lr,e),i(t,Ce,e),i(t,vr,e),i(t,xe,e),i(t,Cr,e),i(t,ke,e),i(t,xr,e),i(t,kr,e),i(t,br,e),i(t,be,e),i(t,Hr,e),h(He,t,e),i(t,wr,e),i(t,we,e),i(t,Pr,e),i(t,Pe,e),i(t,Mr,e),i(t,Me,e),i(t,Ar,e),i(t,Rr,e),i(t,Qr,e),i(t,Ae,e),i(t,Er,e),h(Re,t,e),i(t,Nr,e),i(t,Qe,e),i(t,gr,e),i(t,Ee,e),i(t,qr,e),i(t,Ur,e),i(t,Ir,e),i(t,Ne,e),i(t,Dr,e),h(ge,t,e),i(t,Sr,e),i(t,qe,e),i(t,zr,e),i(t,Ue,e),i(t,Kr,e),i(t,Ie,e),i(t,jr,e),i(t,Br,e),i(t,Fr,e),i(t,De,e),i(t,Or,e),h(Se,t,e),i(t,Gr,e),i(t,ze,e),i(t,Jr,e),i(t,Ke,e),i(t,Vr,e),i(t,je,e),i(t,Wr,e),i(t,Xr,e),i(t,Yr,e),i(t,Be,e),i(t,Zr,e),h(Fe,t,e),i(t,td,e),i(t,Oe,e),i(t,ed,e),i(t,Ge,e),i(t,ld,e),i(t,id,e),i(t,ud,e),i(t,Je,e),i(t,rd,e),h(Ve,t,e),i(t,dd,e),i(t,We,e),i(t,ad,e),i(t,Xe,e),i(t,sd,e),i(t,Ye,e),i(t,od,e),i(t,nd,e),i(t,cd,e),i(t,Ze,e),i(t,pd,e),h(tl,t,e),i(t,hd,e),i(t,el,e),i(t,fd,e),i(t,ll,e),i(t,md,e),i(t,Td,e),i(t,yd,e),i(t,il,e),i(t,$d,e),h(ul,t,e),i(t,_d,e),i(t,rl,e),i(t,Ld,e),i(t,dl,e),i(t,vd,e),i(t,Cd,e),i(t,xd,e),i(t,al,e),i(t,kd,e),h(sl,t,e),i(t,bd,e),i(t,ol,e),i(t,Hd,e),i(t,nl,e),i(t,wd,e),i(t,Pd,e),i(t,Md,e),i(t,cl,e),i(t,Ad,e),h(pl,t,e),i(t,Rd,e),i(t,hl,e),i(t,Qd,e),i(t,fl,e),i(t,Ed,e),i(t,Nd,e),i(t,gd,e),i(t,ml,e),i(t,qd,e),h(Tl,t,e),i(t,Ud,e),i(t,yl,e),i(t,Id,e),i(t,$l,e),i(t,Dd,e),i(t,Sd,e),i(t,zd,e),h(_l,t,e),i(t,Kd,e),i(t,vl,e),jd=!0},p:Ps,i(t){jd||(f(L.$$.fragment,t),f(b.$$.fragment,t),f(Q.$$.fragment,t),f(q.$$.fragment,t),f(S.$$.fragment,t),f(B.$$.fragment,t),f(J.$$.fragment,t),f(Z.$$.fragment,t),f(ut.$$.fragment,t),f(st.$$.fragment,t),f(ht.$$.fragment,t),f($t.$$.fragment,t),f(xt.$$.fragment,t),f(Pt.$$.fragment,t),f(Et.$$.fragment,t),f(It.$$.fragment,t),f(jt.$$.fragment,t),f(Gt.$$.fragment,t),f(Yt.$$.fragment,t),f(le.$$.fragment,t),f(de.$$.fragment,t),f(oe.$$.fragment,t),f(pe.$$.fragment,t),f($e.$$.fragment,t),f(ve.$$.fragment,t),f(He.$$.fragment,t),f(Re.$$.fragment,t),f(ge.$$.fragment,t),f(Se.$$.fragment,t),f(Fe.$$.fragment,t),f(Ve.$$.fragment,t),f(tl.$$.fragment,t),f(ul.$$.fragment,t),f(sl.$$.fragment,t),f(pl.$$.fragment,t),f(Tl.$$.fragment,t),f(_l.$$.fragment,t),jd=!0)},o(t){m(L.$$.fragment,t),m(b.$$.fragment,t),m(Q.$$.fragment,t),m(q.$$.fragment,t),m(S.$$.fragment,t),m(B.$$.fragment,t),m(J.$$.fragment,t),m(Z.$$.fragment,t),m(ut.$$.fragment,t),m(st.$$.fragment,t),m(ht.$$.fragment,t),m($t.$$.fragment,t),m(xt.$$.fragment,t),m(Pt.$$.fragment,t),m(Et.$$.fragment,t),m(It.$$.fragment,t),m(jt.$$.fragment,t),m(Gt.$$.fragment,t),m(Yt.$$.fragment,t),m(le.$$.fragment,t),m(de.$$.fragment,t),m(oe.$$.fragment,t),m(pe.$$.fragment,t),m($e.$$.fragment,t),m(ve.$$.fragment,t),m(He.$$.fragment,t),m(Re.$$.fragment,t),m(ge.$$.fragment,t),m(Se.$$.fragment,t),m(Fe.$$.fragment,t),m(Ve.$$.fragment,t),m(tl.$$.fragment,t),m(ul.$$.fragment,t),m(sl.$$.fragment,t),m(pl.$$.fragment,t),m(Tl.$$.fragment,t),m(_l.$$.fragment,t),jd=!1},d(t){t&&(l(Cl),l(Ll),l(xl),l(_),l(kl),l(bl),l(v),l(Hl),l(C),l(wl),l(x),l(Pl),l(Ml),l(Al),l(k),l(Rl),l(Ql),l(H),l(El),l(w),l(Nl),l(P),l(gl),l(M),l(ql),l(A),l(Ul),l(Il),l(Dl),l(R),l(Sl),l(zl),l(E),l(Kl),l(N),l(jl),l(Bl),l(Fl),l(g),l(Ol),l(Gl),l(U),l(Jl),l(I),l(Vl),l(Wl),l(Xl),l(D),l(Yl),l(Zl),l(z),l(ti),l(K),l(ei),l(li),l(ii),l(j),l(ui),l(ri),l(F),l(di),l(O),l(ai),l(si),l(oi),l(G),l(ni),l(ci),l(V),l(pi),l(W),l(hi),l(X),l(fi),l(mi),l(Ti),l(Y),l(yi),l($i),l(tt),l(_i),l(et),l(Li),l(lt),l(vi),l(Ci),l(xi),l(it),l(ki),l(bi),l(rt),l(Hi),l(dt),l(wi),l(Pi),l(Mi),l(at),l(Ai),l(Ri),l(ot),l(Qi),l(nt),l(Ei),l(ct),l(Ni),l(gi),l(qi),l(pt),l(Ui),l(Ii),l(ft),l(Di),l(mt),l(Si),l(Tt),l(zi),l(Ki),l(ji),l(yt),l(Bi),l(Fi),l(_t),l(Oi),l(Lt),l(Gi),l(vt),l(Ji),l(Vi),l(Wi),l(Ct),l(Xi),l(Yi),l(kt),l(Zi),l(bt),l(tu),l(Ht),l(eu),l(lu),l(iu),l(wt),l(uu),l(ru),l(Mt),l(du),l(At),l(au),l(Rt),l(su),l(ou),l(nu),l(Qt),l(cu),l(pu),l(Nt),l(hu),l(gt),l(fu),l(qt),l(mu),l(Tu),l(yu),l(Ut),l($u),l(_u),l(Dt),l(Lu),l(St),l(vu),l(zt),l(Cu),l(xu),l(ku),l(Kt),l(bu),l(Hu),l(Bt),l(wu),l(Ft),l(Pu),l(Mu),l(Au),l(Ot),l(Ru),l(Qu),l(Jt),l(Eu),l(Vt),l(Nu),l(Wt),l(gu),l(qu),l(Uu),l(Xt),l(Iu),l(Du),l(Zt),l(Su),l(te),l(zu),l(Ku),l(ju),l(ee),l(Bu),l(Fu),l(ie),l(Ou),l(ue),l(Gu),l(Ju),l(Vu),l(re),l(Wu),l(Xu),l(ae),l(Yu),l(Zu),l(tr),l(se),l(er),l(lr),l(ne),l(ir),l(ur),l(rr),l(ce),l(dr),l(ar),l(he),l(sr),l(fe),l(or),l(me),l(nr),l(Te),l(cr),l(pr),l(hr),l(ye),l(fr),l(mr),l(_e),l(Tr),l(yr),l($r),l(Le),l(_r),l(Lr),l(Ce),l(vr),l(xe),l(Cr),l(ke),l(xr),l(kr),l(br),l(be),l(Hr),l(wr),l(we),l(Pr),l(Pe),l(Mr),l(Me),l(Ar),l(Rr),l(Qr),l(Ae),l(Er),l(Nr),l(Qe),l(gr),l(Ee),l(qr),l(Ur),l(Ir),l(Ne),l(Dr),l(Sr),l(qe),l(zr),l(Ue),l(Kr),l(Ie),l(jr),l(Br),l(Fr),l(De),l(Or),l(Gr),l(ze),l(Jr),l(Ke),l(Vr),l(je),l(Wr),l(Xr),l(Yr),l(Be),l(Zr),l(td),l(Oe),l(ed),l(Ge),l(ld),l(id),l(ud),l(Je),l(rd),l(dd),l(We),l(ad),l(Xe),l(sd),l(Ye),l(od),l(nd),l(cd),l(Ze),l(pd),l(hd),l(el),l(fd),l(ll),l(md),l(Td),l(yd),l(il),l($d),l(_d),l(rl),l(Ld),l(dl),l(vd),l(Cd),l(xd),l(al),l(kd),l(bd),l(ol),l(Hd),l(nl),l(wd),l(Pd),l(Md),l(cl),l(Ad),l(Rd),l(hl),l(Qd),l(fl),l(Ed),l(Nd),l(gd),l(ml),l(qd),l(Ud),l(yl),l(Id),l($l),l(Dd),l(Sd),l(zd),l(Kd),l(vl)),l($),T(L,t),T(b,t),T(Q,t),T(q,t),T(S,t),T(B,t),T(J,t),T(Z,t),T(ut,t),T(st,t),T(ht,t),T($t,t),T(xt,t),T(Pt,t),T(Et,t),T(It,t),T(jt,t),T(Gt,t),T(Yt,t),T(le,t),T(de,t),T(oe,t),T(pe,t),T($e,t),T(ve,t),T(He,t),T(Re,t),T(ge,t),T(Se,t),T(Fe,t),T(Ve,t),T(tl,t),T(ul,t),T(sl,t),T(pl,t),T(Tl,t),T(_l,t)}}}const qs='{"title":"utils/data-structures","local":"utilsdata-structures","sections":[{"title":"utils/data-structures.PriorityQueue","local":"utilsdata-structurespriorityqueue","sections":[{"title":"new PriorityQueue(comparator)","local":"new-priorityqueuecomparator","sections":[],"depth":3},{"title":"priorityQueue.size","local":"priorityqueuesize","sections":[],"depth":3},{"title":"priorityQueue.isEmpty() ⇒ <code> boolean </code>","local":"priorityqueueisempty--code-boolean-code","sections":[],"depth":3},{"title":"priorityQueue.peek() ⇒ <code> any </code>","local":"priorityqueuepeek--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.push(...values) ⇒ <code> number </code>","local":"priorityqueuepushvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.extend(values) ⇒ <code> number </code>","local":"priorityqueueextendvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.pop() ⇒ <code> any </code>","local":"priorityqueuepop--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.replace(value) ⇒ <code> * </code>","local":"priorityqueuereplacevalue--code--code","sections":[],"depth":3},{"title":"priorityQueue._siftUpFrom(node)","local":"priorityqueuesiftupfromnode","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.CharTrie","local":"utilsdata-structureschartrie","sections":[{"title":"charTrie.extend(texts)","local":"chartrieextendtexts","sections":[],"depth":3},{"title":"charTrie.push(text)","local":"chartriepushtext","sections":[],"depth":3},{"title":"charTrie.commonPrefixSearch(text)","local":"chartriecommonprefixsearchtext","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.TokenLattice","local":"utilsdata-structurestokenlattice","sections":[{"title":"new TokenLattice(sentence, bosTokenId, eosTokenId)","local":"new-tokenlatticesentence-bostokenid-eostokenid","sections":[],"depth":3},{"title":"tokenLattice.insert(pos, length, score, tokenId)","local":"tokenlatticeinsertpos-length-score-tokenid","sections":[],"depth":3},{"title":"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>","local":"tokenlatticeviterbi--code-array--tokenlatticenode--code","sections":[],"depth":3},{"title":"tokenLattice.piece(node) ⇒ <code> string </code>","local":"tokenlatticepiecenode--code-string-code","sections":[],"depth":3},{"title":"tokenLattice.tokens() ⇒ <code> Array. < string > </code>","local":"tokenlatticetokens--code-array--string--code","sections":[],"depth":3},{"title":"tokenLattice.tokenIds() ⇒ <code> Array. < number > </code>","local":"tokenlatticetokenids--code-array--number--code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.DictionarySplitter","local":"utilsdata-structuresdictionarysplitter","sections":[{"title":"new DictionarySplitter(dictionary)","local":"new-dictionarysplitterdictionary","sections":[],"depth":3},{"title":"dictionarySplitter.split(text) ⇒ <code> Array. < string > </code>","local":"dictionarysplittersplittext--code-array--string--code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.LRUCache","local":"utilsdata-structureslrucache","sections":[{"title":"new LRUCache(capacity)","local":"new-lrucachecapacity","sections":[],"depth":3},{"title":"lruCache.get(key) ⇒ <code> any </code>","local":"lrucachegetkey--code-any-code","sections":[],"depth":3},{"title":"lruCache.put(key, value)","local":"lrucacheputkey-value","sections":[],"depth":3},{"title":"lruCache.clear()","local":"lrucacheclear","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~CharTrieNode","local":"utilsdata-structureschartrienode","sections":[{"title":"new CharTrieNode(isLeaf, children)","local":"new-chartrienodeisleaf-children","sections":[],"depth":3},{"title":"CharTrieNode.default() ⇒ <code> CharTrieNode </code>","local":"chartrienodedefault--code-chartrienode-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~TokenLatticeNode","local":"utilsdata-structurestokenlatticenode","sections":[{"title":"new TokenLatticeNode(tokenId, nodeId, pos, length, score)","local":"new-tokenlatticenodetokenid-nodeid-pos-length-score","sections":[],"depth":3},{"title":"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>","local":"tokenlatticenodeclone--code-tokenlatticenode-code","sections":[],"depth":3}],"depth":2}],"depth":1}';function Us(Bd){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends As{constructor($){super(),Rs(this,$,Us,gs,ws,{})}}export{zs as component};
