import{S as Op,i as Kp,s as eJ,e as o,k as J,w as U,t as l,M as tJ,c as n,d as a,m as d,a as r,x as u,h as s,b as p,G as t,g as c,y as m,q as y,o as M,B as f,v as aJ}from"../../chunks/vendor-hf-doc-builder.js";import{T as Pp}from"../../chunks/Tip-hf-doc-builder.js";import{I as Xe}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{C as w}from"../../chunks/CodeBlock-hf-doc-builder.js";function lJ(qt){let h,V,T,v,A,b,x,B;return{c(){h=o("p"),V=l("\u{1F4A1} Read the "),T=o("a"),v=l("LLM.int8(): 8-bit Matrix Multiplication for Transformers at Scale"),A=l(" paper to learn more, or you can take a look at the corresponding "),b=o("a"),x=l("blog post"),B=l(" for a gentler introduction."),this.h()},l(k){h=n(k,"P",{});var g=r(h);V=s(g,"\u{1F4A1} Read the "),T=n(g,"A",{href:!0,rel:!0});var I=r(T);v=s(I,"LLM.int8(): 8-bit Matrix Multiplication for Transformers at Scale"),I.forEach(a),A=s(g," paper to learn more, or you can take a look at the corresponding "),b=n(g,"A",{href:!0,rel:!0});var Y=r(b);x=s(Y,"blog post"),Y.forEach(a),B=s(g," for a gentler introduction."),g.forEach(a),this.h()},h(){p(T,"href","https://arxiv.org/abs/2208.07339"),p(T,"rel","nofollow"),p(b,"href","https://huggingface.co/blog/hf-bitsandbytes-integration"),p(b,"rel","nofollow")},m(k,g){c(k,h,g),t(h,V),t(h,T),t(T,v),t(h,A),t(h,b),t(b,x),t(h,B)},d(k){k&&a(h)}}}function sJ(qt){let h,V,T,v,A,b,x,B,k,g,I,Y,ie,Ae,ce,pe,Be;return{c(){h=o("p"),V=l("\u{1F4A1} The weight matrix is scaled by "),T=o("code"),v=l("lora_alpha/r"),A=l(", and a higher "),b=o("code"),x=l("lora_alpha"),B=l(" value assigns more weight to the LoRA activations. For performance, we recommend setting bias to "),k=o("code"),g=l("None"),I=l(" first, and then "),Y=o("code"),ie=l("lora_only"),Ae=l(", before trying "),ce=o("code"),pe=l("all"),Be=l(".")},l(Je){h=n(Je,"P",{});var j=r(h);V=s(j,"\u{1F4A1} The weight matrix is scaled by "),T=n(j,"CODE",{});var zt=r(T);v=s(zt,"lora_alpha/r"),zt.forEach(a),A=s(j,", and a higher "),b=n(j,"CODE",{});var Dt=r(b);x=s(Dt,"lora_alpha"),Dt.forEach(a),B=s(j," value assigns more weight to the LoRA activations. For performance, we recommend setting bias to "),k=n(j,"CODE",{});var Ve=r(k);g=s(Ve,"None"),Ve.forEach(a),I=s(j," first, and then "),Y=n(j,"CODE",{});var H=r(Y);ie=s(H,"lora_only"),H.forEach(a),Ae=s(j,", before trying "),ce=n(j,"CODE",{});var Ye=r(ce);pe=s(Ye,"all"),Ye.forEach(a),Be=s(j,"."),j.forEach(a)},m(Je,j){c(Je,h,j),t(h,V),t(h,T),t(T,v),t(h,A),t(h,b),t(b,x),t(h,B),t(h,k),t(k,g),t(h,I),t(h,Y),t(Y,ie),t(h,Ae),t(h,ce),t(ce,pe),t(h,Be)},d(Je){Je&&a(h)}}}function oJ(qt){let h,V,T,v,A,b,x,B,k,g,I,Y,ie,Ae,ce,pe,Be,Je,j,zt,Dt,Ve,H,Ye,$,ao,$e,Ma,lo,so,fa,oo,no,Qe,ro,io,Wl,xt,co,Nl,Se,Fl,de,we,wa,qe,po,Ta,Jo,Rl,L,ho,ba,Uo,uo,ja,mo,yo,Xl,ze,Al,Ht,Mo,Bl,De,Vl,he,Te,Ia,xe,fo,Ea,wo,Yl,P,To,He,bo,jo,Le,Io,Eo,$l,C,_o,Pe,go,vo,_a,Co,Zo,ga,ko,Go,va,Wo,No,Ca,Fo,Ro,Ql,Oe,Sl,Ue,be,Za,Ke,Xo,ka,Ao,ql,Lt,Bo,zl,et,Dl,Q,Vo,Ga,Yo,$o,Wa,Qo,So,tt,qo,zo,xl,at,Hl,G,Do,Na,xo,Ho,lt,Lo,Po,Fa,Oo,Ko,Ra,en,tn,Ll,st,Pl,Pt,an,Ol,O,ot,ln,Xa,sn,on,nn,nt,rn,Aa,cn,pn,Jn,rt,dn,Ba,hn,Un,Kl,it,es,E,un,Va,mn,yn,ct,Mn,fn,Ya,wn,Tn,$a,bn,jn,Qa,In,En,Sa,_n,gn,ts,pt,as,K,vn,qa,Cn,Zn,za,kn,Gn,ls,Jt,ss,ue,je,Da,dt,Wn,xa,Nn,os,_,Fn,Ot,Ha,Rn,Xn,ht,An,Bn,La,Vn,Yn,Pa,$n,Qn,Oa,Sn,qn,Ka,zn,Dn,ns,Ut,rs,Ie,xn,el,Hn,Ln,is,ut,cs,ee,Pn,tl,On,Kn,mt,al,er,tr,ps,te,me,ar,ll,lr,sr,sl,or,nr,rr,ol,ir,cr,nl,pr,Js,yt,ds,Ee,Jr,Kt,dr,hr,hs,W,ea,rl,Ur,ur,mr,ta,il,yr,Mr,fr,ae,cl,wr,Tr,pl,br,jr,Jl,Ir,Er,_r,aa,dl,gr,vr,Cr,Mt,hl,Zr,kr,Ul,Gr,Us,_e,us,ft,ms,S,Wr,la,Nr,Fr,ul,Rr,Xr,sa,Ar,Br,ys,wt,Ms,N,Vr,Tt,Yr,$r,oa,Qr,Sr,ml,qr,zr,yl,Dr,xr,fs,bt,ws,ge,Hr,jt,Lr,Pr,Ts,It,bs,F,Or,Ml,Kr,ei,Et,ti,ai,fl,li,si,_t,oi,ni,js,gt,Is,ye,ve,wl,vt,ri,Tl,ii,Es,Ct,Zt,ci,pi,_s,kt,gs,q,Ji,Gt,bl,di,hi,jl,Ui,ui,Il,mi,yi,vs,Wt,Cs,Me,Ce,El,Nt,Mi,_l,fi,Zs,Ze,wi,Ft,Ti,bi,ks,Rt,Gs,fe,ke,gl,Xt,ji,vl,Ii,Ws,na,Ei,Ns,Z,_i,ra,gi,vi,ia,Ci,Zi,Cl,ki,Gi,Zl,Wi,Ni,kl,Fi,Ri,Fs,At,Rs,le,Xi,Bt,Ai,Bi,Vt,Vi,Yi,Xs,Yt,As,ca,$i,Bs,$t,Vs;return b=new Xe({}),H=new Pp({props:{$$slots:{default:[lJ]},$$scope:{ctx:qt}}}),Se=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMGFjY2VsZXJhdGUlMjBldmFsdWF0ZSUyMGppd2VyJTIwYml0c2FuZGJ5dGVz",highlighted:"!pip install -q peft transformers datasets accelerate evaluate jiwer bitsandbytes"}}),qe=new Xe({}),ze=new w({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIyQ1VEQV9WSVNJQkxFX0RFVklDRVMlMjIlNUQlMjAlM0QlMjAlMjIwJTIyJTBBbW9kZWxfbmFtZV9vcl9wYXRoJTIwJTNEJTIwJTIyb3BlbmFpJTJGd2hpc3Blci1sYXJnZS12MiUyMiUwQWxhbmd1YWdlJTIwJTNEJTIwJTIyTWFyYXRoaSUyMiUwQWxhbmd1YWdlX2FiYnIlMjAlM0QlMjAlMjJtciUyMiUwQXRhc2slMjAlM0QlMjAlMjJ0cmFuc2NyaWJlJTIyJTBBZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzExXzAlMjI=",highlighted:`<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;CUDA_VISIBLE_DEVICES&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
model_name_or_path = <span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>
language = <span class="hljs-string">&quot;Marathi&quot;</span>
language_abbr = <span class="hljs-string">&quot;mr&quot;</span>
task = <span class="hljs-string">&quot;transcribe&quot;</span>
dataset_name = <span class="hljs-string">&quot;mozilla-foundation/common_voice_11_0&quot;</span>`}}),De=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),xe=new Xe({}),Oe=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBEYXRhc2V0RGljdCgpJTBBJTBBY29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9uYW1lJTJDJTIwbGFuZ3VhZ2VfYWJiciUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ2YWxpZGF0aW9uJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9uYW1lJTJDJTIwbGFuZ3VhZ2VfYWJiciUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSklMEFjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

common_voice = DatasetDict()

common_voice[<span class="hljs-string">&quot;train&quot;</span>] = load_dataset(dataset_name, language_abbr, split=<span class="hljs-string">&quot;train+validation&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)
common_voice[<span class="hljs-string">&quot;test&quot;</span>] = load_dataset(dataset_name, language_abbr, split=<span class="hljs-string">&quot;test&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)
common_voice[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]`}}),Ke=new Xe({}),et=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lX29yX3BhdGgpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwbGFuZ3VhZ2UlM0RsYW5ndWFnZSUyQyUyMHRhc2slM0R0YXNrKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWVfb3JfcGF0aCUyQyUyMGxhbmd1YWdlJTNEbGFuZ3VhZ2UlMkMlMjB0YXNrJTNEdGFzayk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, AutoTokenizer, AutoProcessor

feature_extractor = AutoFeatureExtractor.from_pretrained(model_name_or_path)
tokenizer = AutoTokenizer.from_pretrained(model_name_or_path, language=language, task=task)
processor = AutoProcessor.from_pretrained(model_name_or_path, language=language, task=task)`}}),at=new w({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLnJlbW92ZV9jb2x1bW5zKCUwQSUyMCUyMCUyMCUyMCU1QiUyMmFjY2VudCUyMiUyQyUyMCUyMmFnZSUyMiUyQyUyMCUyMmNsaWVudF9pZCUyMiUyQyUyMCUyMmRvd25fdm90ZXMlMjIlMkMlMjAlMjJnZW5kZXIlMjIlMkMlMjAlMjJsb2NhbGUlMjIlMkMlMjAlMjJwYXRoJTIyJTJDJTIwJTIyc2VnbWVudCUyMiUyQyUyMCUyMnVwX3ZvdGVzJTIyJTVEJTBBKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QiUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjdlMWVmNmEyZDE0ZjIwMTk0OTk5YWFkNTA0MGM1ZDRiYjNlYWQxMzc3ZGUzZTFiYmM2ZTlkYmEzNGQxOGE4YSUyRmNvbW1vbl92b2ljZV9tcl8zMDU4NTYxMy5tcDMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjEuMTM2ODY4MzhlLTEzJTJDJTIwLTEuNDIxMDg1NDdlLTEzJTJDJTIwLTEuOTg5NTE5NjZlLTEzJTJDJTIwLi4uJTJDJTIwNC44MzQ3MjQyMmUtMDYlMkMlMjAzLjU0Nzk4NzAzZS0wNiUyQyUyMDEuNjMyMzE3NDNlLTA2JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjA0ODAwMCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNlbnRlbmNlJTIyJTNBJTIwJTIyJUUwJUE0JTg2JUUwJUE0JTg4JUUwJUE0JTlBJUUwJUE1JTg3JTIwJUUwJUE0JTg2JUUwJUE0JTlDJUUwJUE0JUJFJUUwJUE0JUIwJUUwJUE0JUFBJUUwJUE0JUEzJTIwJUUwJUE0JUI1JUUwJUE0JUJFJUUwJUE0JUEyJUUwJUE0JUE0JTIwJUUwJUE0JTlBJUUwJUE0JUJFJUUwJUE0JUIyJUUwJUE0JUIyJUUwJUE1JTg3JTJDJTIwJUUwJUE0JUE0JUUwJUE0JUI4JUUwJUE0JUE0JUUwJUE0JUI2JUUwJUE1JTgwJTIwJUUwJUE0JUFFJUUwJUE0JUE1JUUwJUE1JTgwJUUwJUE0JUI5JUUwJUE1JTgwJTIwJUUwJUE0JUE4JUUwJUE1JTgwJUUwJUE0JTlGJTIwJUUwJUE0JTk2JUUwJUE0JUJFJUUwJUE0JUE0JUUwJUE0JUFBJUUwJUE1JTgwJUUwJUE0JUE0JUUwJUE0JUE4JUUwJUE0JUJFJUUwJUE0JUI2JUUwJUE1JTgwJTIwJUUwJUE0JTlEJUUwJUE0JUJFJUUwJUE0JUIyJUUwJUE1JTgwLiUyMiUyQyUwQSU3RA==",highlighted:`common_voice = common_voice.remove_columns(
    [<span class="hljs-string">&quot;accent&quot;</span>, <span class="hljs-string">&quot;age&quot;</span>, <span class="hljs-string">&quot;client_id&quot;</span>, <span class="hljs-string">&quot;down_votes&quot;</span>, <span class="hljs-string">&quot;gender&quot;</span>, <span class="hljs-string">&quot;locale&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;segment&quot;</span>, <span class="hljs-string">&quot;up_votes&quot;</span>]
)
common_voice[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f7e1ef6a2d14f20194999aad5040c5d4bb3ead1377de3e1bbc6e9dba34d18a8a/common_voice_mr_30585613.mp3&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: array(
            [<span class="hljs-number">1.13686838e-13</span>, -<span class="hljs-number">1.42108547e-13</span>, -<span class="hljs-number">1.98951966e-13</span>, ..., <span class="hljs-number">4.83472422e-06</span>, <span class="hljs-number">3.54798703e-06</span>, <span class="hljs-number">1.63231743e-06</span>]
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">48000</span>,
    },
    <span class="hljs-string">&quot;sentence&quot;</span>: <span class="hljs-string">&quot;\u0906\u0908\u091A\u0947 \u0906\u091C\u093E\u0930\u092A\u0923 \u0935\u093E\u0922\u0924 \u091A\u093E\u0932\u0932\u0947, \u0924\u0938\u0924\u0936\u0940 \u092E\u0925\u0940\u0939\u0940 \u0928\u0940\u091F \u0916\u093E\u0924\u092A\u0940\u0924\u0928\u093E\u0936\u0940 \u091D\u093E\u0932\u0940.&quot;</span>,
}`}}),st=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBjb21tb25fdm9pY2UuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QiUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjdlMWVmNmEyZDE0ZjIwMTk0OTk5YWFkNTA0MGM1ZDRiYjNlYWQxMzc3ZGUzZTFiYmM2ZTlkYmEzNGQxOGE4YSUyRmNvbW1vbl92b2ljZV9tcl8zMDU4NTYxMy5tcDMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qi0zLjA2OTU0NDYyZS0xMiUyQyUyMC0zLjYzNzk3ODgxZS0xMiUyQyUyMC00LjU0NzQ3MzUxZS0xMiUyQyUyMC4uLiUyQyUyMC03Ljc0ODAwOTAxZS0wNiUyQyUyMC0xLjc0NzM4MTI1ZS0wNiUyQyUyMDQuMzYzMTI0MzllLTA2JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNlbnRlbmNlJTIyJTNBJTIwJTIyJUUwJUE0JTg2JUUwJUE0JTg4JUUwJUE0JTlBJUUwJUE1JTg3JTIwJUUwJUE0JTg2JUUwJUE0JTlDJUUwJUE0JUJFJUUwJUE0JUIwJUUwJUE0JUFBJUUwJUE0JUEzJTIwJUUwJUE0JUI1JUUwJUE0JUJFJUUwJUE0JUEyJUUwJUE0JUE0JTIwJUUwJUE0JTlBJUUwJUE0JUJFJUUwJUE0JUIyJUUwJUE0JUIyJUUwJUE1JTg3JTJDJTIwJUUwJUE0JUE0JUUwJUE0JUI4JUUwJUE0JUE0JUUwJUE0JUI2JUUwJUE1JTgwJTIwJUUwJUE0JUFFJUUwJUE0JUE1JUUwJUE1JTgwJUUwJUE0JUI5JUUwJUE1JTgwJTIwJUUwJUE0JUE4JUUwJUE1JTgwJUUwJUE0JTlGJTIwJUUwJUE0JTk2JUUwJUE0JUJFJUUwJUE0JUE0JUUwJUE0JUFBJUUwJUE1JTgwJUUwJUE0JUE0JUUwJUE0JUE4JUUwJUE0JUJFJUUwJUE0JUI2JUUwJUE1JTgwJTIwJUUwJUE0JTlEJUUwJUE0JUJFJUUwJUE0JUIyJUUwJUE1JTgwLiUyMiUyQyUwQSU3RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

common_voice = common_voice.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
common_voice[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f7e1ef6a2d14f20194999aad5040c5d4bb3ead1377de3e1bbc6e9dba34d18a8a/common_voice_mr_30585613.mp3&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: array(
            [-<span class="hljs-number">3.06954462e-12</span>, -<span class="hljs-number">3.63797881e-12</span>, -<span class="hljs-number">4.54747351e-12</span>, ..., -<span class="hljs-number">7.74800901e-06</span>, -<span class="hljs-number">1.74738125e-06</span>, <span class="hljs-number">4.36312439e-06</span>]
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-string">&quot;sentence&quot;</span>: <span class="hljs-string">&quot;\u0906\u0908\u091A\u0947 \u0906\u091C\u093E\u0930\u092A\u0923 \u0935\u093E\u0922\u0924 \u091A\u093E\u0932\u0932\u0947, \u0924\u0938\u0924\u0936\u0940 \u092E\u0925\u0940\u0939\u0940 \u0928\u0940\u091F \u0916\u093E\u0924\u092A\u0940\u0924\u0928\u093E\u0936\u0940 \u091D\u093E\u0932\u0940.&quot;</span>,
}`}}),it=new w({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwYmF0Y2glNUIlMjJhdWRpbyUyMiU1RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIyaW5wdXRfZmVhdHVyZXMlMjIlNUQlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihhdWRpbyU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCkuaW5wdXRfZmVhdHVyZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0b2tlbml6ZXIoYmF0Y2glNUIlMjJzZW50ZW5jZSUyMiU1RCkuaW5wdXRfaWRzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">batch</span>):
    audio = batch[<span class="hljs-string">&quot;audio&quot;</span>]
    batch[<span class="hljs-string">&quot;input_features&quot;</span>] = feature_extractor(audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]).input_features[<span class="hljs-number">0</span>]
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = tokenizer(batch[<span class="hljs-string">&quot;sentence&quot;</span>]).input_ids
    <span class="hljs-keyword">return</span> batch`}}),pt=new w({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLm1hcChwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGNvbW1vbl92b2ljZS5jb2x1bW5fbmFtZXMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMG51bV9wcm9jJTNEMik=",highlighted:'common_voice = common_voice.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=common_voice.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">2</span>)'}}),Jt=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwQW55JTJDJTIwRGljdCUyQyUyMExpc3QlMkMlMjBVbmlvbiUwQSUwQSUwQSU0MGRhdGFjbGFzcyUwQWNsYXNzJTIwRGF0YUNvbGxhdG9yU3BlZWNoU2VxMlNlcVdpdGhQYWRkaW5nJTNBJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29yJTNBJTIwQW55JTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGZlYXR1cmVzJTNBJTIwTGlzdCU1QkRpY3QlNUJzdHIlMkMlMjBVbmlvbiU1Qkxpc3QlNUJpbnQlNUQlMkMlMjB0b3JjaC5UZW5zb3IlNUQlNUQlNUQpJTIwLSUzRSUyMERpY3QlNUJzdHIlMkMlMjB0b3JjaC5UZW5zb3IlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9mZWF0dXJlcyUyMCUzRCUyMCU1QiU3QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTNBJTIwZmVhdHVyZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTdEJTIwZm9yJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYucHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yLnBhZChpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxfZmVhdHVyZXMlMjAlM0QlMjAlNUIlN0IlMjJpbnB1dF9pZHMlMjIlM0ElMjBmZWF0dXJlJTVCJTIybGFiZWxzJTIyJTVEJTdEJTIwZm9yJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbHNfYmF0Y2glMjAlM0QlMjBzZWxmLnByb2Nlc3Nvci50b2tlbml6ZXIucGFkKGxhYmVsX2ZlYXR1cmVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjBsYWJlbHNfYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQubWFza2VkX2ZpbGwobGFiZWxzX2JhdGNoLmF0dGVudGlvbl9tYXNrLm5lKDEpJTJDJTIwLTEwMCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMChsYWJlbHMlNUIlM0ElMkMlMjAwJTVEJTIwJTNEJTNEJTIwc2VsZi5wcm9jZXNzb3IudG9rZW5pemVyLmJvc190b2tlbl9pZCkuYWxsKCkuY3B1KCkuaXRlbSgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwbGFiZWxzJTVCJTNBJTJDJTIwMSUzQSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwbGFiZWxzJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yU3BlZWNoU2VxMlNlcVdpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorSpeechSeq2SeqWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_features = [{<span class="hljs-string">&quot;input_features&quot;</span>: feature[<span class="hljs-string">&quot;input_features&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        batch = self.processor.feature_extractor.pad(input_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        labels_batch = self.processor.tokenizer.pad(label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

        <span class="hljs-keyword">if</span> (labels[:, <span class="hljs-number">0</span>] == self.processor.tokenizer.bos_token_id).<span class="hljs-built_in">all</span>().cpu().item():
            labels = labels[:, <span class="hljs-number">1</span>:]

        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

        <span class="hljs-keyword">return</span> batch


data_collator = DataCollatorSpeechSeq2SeqWithPadding(processor=processor)`}}),dt=new Xe({}),Ut=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWVfb3JfcGF0aCUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSpeechSeq2Seq

model = AutoModelForSpeechSeq2Seq.from_pretrained(model_name_or_path, load_in_8bit=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`}}),ut=new w({props:{code:"bW9kZWwuY29uZmlnLmZvcmNlZF9kZWNvZGVyX2lkcyUyMCUzRCUyME5vbmUlMEFtb2RlbC5jb25maWcuc3VwcHJlc3NfdG9rZW5zJTIwJTNEJTIwJTVCJTVE",highlighted:`model.config.forced_decoder_ids = <span class="hljs-literal">None</span>
model.config.suppress_tokens = []`}}),yt=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9pbnQ4X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9pbnQ4X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_int8_training

model = prepare_model_for_int8_training(model)`}}),_e=new Pp({props:{$$slots:{default:[sJ]},$$scope:{ctx:qt}}}),ft=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwUGVmdE1vZGVsJTJDJTIwTG9yYU1vZGVsJTJDJTIwTG9yYUNvbmZpZyUyQyUyMGdldF9wZWZ0X21vZGVsJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhyJTNEMzIlMkMlMjBsb3JhX2FscGhhJTNENjQlMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMjBiaWFzJTNEJTIybm9uZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, PeftModel, LoraModel, LoraConfig, get_peft_model

config = LoraConfig(r=<span class="hljs-number">32</span>, lora_alpha=<span class="hljs-number">64</span>, target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>], lora_dropout=<span class="hljs-number">0.05</span>, bias=<span class="hljs-string">&quot;none&quot;</span>)`}}),wt=new w({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTU3Mjg2NDAlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjAxNTU5MDMzNjAwJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS4wMDg4NzExMzY1ODEwMjAzJTIy",highlighted:`model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 15728640 || all params: 1559033600 || trainable%: 1.0088711365810203&quot;</span>`}}),bt=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnlvdXItbmFtZSUyRmludDgtd2hpc3Blci1sYXJnZS12Mi1hc3IlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS0zJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMyUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9tYXhfbGVuZ3RoJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;your-name/int8-whisper-large-v2-asr&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">8</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,
    learning_rate=<span class="hljs-number">1e-3</span>,
    warmup_steps=<span class="hljs-number">50</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    fp16=<span class="hljs-literal">True</span>,
    per_device_eval_batch_size=<span class="hljs-number">8</span>,
    generation_max_length=<span class="hljs-number">128</span>,
    logging_steps=<span class="hljs-number">25</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`}}),It=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50cmFpbmVyX3V0aWxzJTIwaW1wb3J0JTIwUFJFRklYX0NIRUNLUE9JTlRfRElSJTBBJTBBJTBBY2xhc3MlMjBTYXZlUGVmdE1vZGVsQ2FsbGJhY2soVHJhaW5lckNhbGxiYWNrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMG9uX3NhdmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3MlM0ElMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTNBJTIwVHJhaW5lclN0YXRlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udHJvbCUzQSUyMFRyYWluZXJDb250cm9sJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKiprd2FyZ3MlMkMlMEElMjAlMjAlMjAlMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hlY2twb2ludF9mb2xkZXIlMjAlM0QlMjBvcy5wYXRoLmpvaW4oYXJncy5vdXRwdXRfZGlyJTJDJTIwZiUyMiU3QlBSRUZJWF9DSEVDS1BPSU5UX0RJUiU3RC0lN0JzdGF0ZS5nbG9iYWxfc3RlcCU3RCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwZWZ0X21vZGVsX3BhdGglMjAlM0QlMjBvcy5wYXRoLmpvaW4oY2hlY2twb2ludF9mb2xkZXIlMkMlMjAlMjJhZGFwdGVyX21vZGVsJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGt3YXJncyU1QiUyMm1vZGVsJTIyJTVELnNhdmVfcHJldHJhaW5lZChwZWZ0X21vZGVsX3BhdGgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0b3JjaF9tb2RlbF9wYXRoJTIwJTNEJTIwb3MucGF0aC5qb2luKGNoZWNrcG9pbnRfZm9sZGVyJTJDJTIwJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBvcy5wYXRoLmV4aXN0cyhweXRvcmNoX21vZGVsX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3MucmVtb3ZlKHB5dG9yY2hfbW9kZWxfcGF0aCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjb250cm9s",highlighted:`<span class="hljs-keyword">from</span> transformers.trainer_utils <span class="hljs-keyword">import</span> PREFIX_CHECKPOINT_DIR


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SavePeftModelCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_save</span>(<span class="hljs-params">
        self,
        args: TrainingArguments,
        state: TrainerState,
        control: TrainerControl,
        **kwargs,
    </span>):
        checkpoint_folder = os.path.join(args.output_dir, <span class="hljs-string">f&quot;<span class="hljs-subst">{PREFIX_CHECKPOINT_DIR}</span>-<span class="hljs-subst">{state.global_step}</span>&quot;</span>)

        peft_model_path = os.path.join(checkpoint_folder, <span class="hljs-string">&quot;adapter_model&quot;</span>)
        kwargs[<span class="hljs-string">&quot;model&quot;</span>].save_pretrained(peft_model_path)

        pytorch_model_path = os.path.join(checkpoint_folder, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
        <span class="hljs-keyword">if</span> os.path.exists(pytorch_model_path):
            os.remove(pytorch_model_path)
        <span class="hljs-keyword">return</span> control`}}),gt=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTJDJTIwVHJhaW5lckNhbGxiYWNrJTJDJTIwU2VxMlNlcVRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lclN0YXRlJTJDJTIwVHJhaW5lckNvbnRyb2wlMEElMEF0cmFpbmVyJTIwJTNEJTIwU2VxMlNlcVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGNvbW1vbl92b2ljZSU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEY29tbW9uX3ZvaWNlJTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tzJTNEJTVCU2F2ZVBlZnRNb2RlbENhbGxiYWNrJTVEJTJDJTBBKSUwQW1vZGVsLmNvbmZpZy51c2VfY2FjaGUlMjAlM0QlMjBGYWxzZSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer, TrainerCallback, Seq2SeqTrainingArguments, TrainerState, TrainerControl

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=common_voice[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=common_voice[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor.feature_extractor,
    callbacks=[SavePeftModelCallback],
)
model.config.use_cache = <span class="hljs-literal">False</span>
trainer.train()`}}),vt=new Xe({}),kt=new w({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`}}),Wt=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gc

eval_dataloader = DataLoader(common_voice[<span class="hljs-string">&quot;test&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator)

model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
    <span class="hljs-keyword">with</span> torch.cuda.amp.autocast():
        <span class="hljs-keyword">with</span> torch.no_grad():
            generated_tokens = (
                model.generate(
                    input_features=batch[<span class="hljs-string">&quot;input_features&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>),
                    decoder_input_ids=batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :<span class="hljs-number">4</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>),
                    max_new_tokens=<span class="hljs-number">255</span>,
                )
                .cpu()
                .numpy()
            )
            labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()
            labels = np.where(labels != -<span class="hljs-number">100</span>, labels, tokenizer.pad_token_id)
            decoded_preds = tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
            decoded_labels = tokenizer.batch_decode(labels, skip_special_tokens=<span class="hljs-literal">True</span>)
            metric.add_batch(
                predictions=decoded_preds,
                references=decoded_labels,
            )
    <span class="hljs-keyword">del</span> generated_tokens, labels, batch
    gc.collect()
wer = <span class="hljs-number">100</span> * metric.compute()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{wer=}</span>&quot;</span>)`}}),Nt=new Xe({}),Rt=new w({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIyeW91ci1uYW1lJTJGaW50OC13aGlzcGVyLWxhcmdlLXYyLWFzciUyMik=",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;your-name/int8-whisper-large-v2-asr&quot;</span>)'}}),Xt=new Xe({}),At=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnNtYW5ncnVsJTJGb3BlbmFpLXdoaXNwZXItbGFyZ2UtdjItTE9SQS1jb2xhYiUyMiUwQWxhbmd1YWdlJTIwJTNEJTIwJTIyTWFyYXRoaSUyMiUwQXRhc2slMjAlM0QlMjAlMjJ0cmFuc2NyaWJlJTIyJTBBcGVmdF9jb25maWclMjAlM0QlMjBQZWZ0Q29uZmlnLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWcuYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCklMEF0b2tlbml6ZXIlMjAlM0QlMjBXaGlzcGVyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChwZWZ0X2NvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMGxhbmd1YWdlJTNEbGFuZ3VhZ2UlMkMlMjB0YXNrJTNEdGFzayklMEFwcm9jZXNzb3IlMjAlM0QlMjBXaGlzcGVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChwZWZ0X2NvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMGxhbmd1YWdlJTNEbGFuZ3VhZ2UlMkMlMjB0YXNrJTNEdGFzayklMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciUwQWZvcmNlZF9kZWNvZGVyX2lkcyUyMCUzRCUyMHByb2Nlc3Nvci5nZXRfZGVjb2Rlcl9wcm9tcHRfaWRzKGxhbmd1YWdlJTNEbGFuZ3VhZ2UlMkMlMjB0YXNrJTNEdGFzayk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

peft_model_id = <span class="hljs-string">&quot;smangrul/openai-whisper-large-v2-LORA-colab&quot;</span>
language = <span class="hljs-string">&quot;Marathi&quot;</span>
task = <span class="hljs-string">&quot;transcribe&quot;</span>
peft_config = PeftConfig.from_pretrained(peft_model_id)
model = WhisperForConditionalGeneration.from_pretrained(
    peft_config.base_model_name_or_path, load_in_8bit=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)
model = PeftModel.from_pretrained(model, peft_model_id)
tokenizer = WhisperTokenizer.from_pretrained(peft_config.base_model_name_or_path, language=language, task=task)
processor = WhisperProcessor.from_pretrained(peft_config.base_model_name_or_path, language=language, task=task)
feature_extractor = processor.feature_extractor
forced_decoder_ids = processor.get_decoder_prompt_ids(language=language, task=task)`}}),Yt=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9tYXRpY1NwZWVjaFJlY29nbml0aW9uUGlwZWxpbmUlMEElMEFhdWRpbyUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnN0ZXZobGl1JTJGZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1ydF8wMTUyM18wMDAyODU0ODIwMy53YXYlMjIlMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9tYXRpY1NwZWVjaFJlY29nbml0aW9uUGlwZWxpbmUobW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutomaticSpeechRecognitionPipeline

audio = <span class="hljs-string">&quot;https://huggingface.co/datasets/stevhliu/dummy/resolve/main/mrt_01523_00028548203.wav&quot;</span>
pipeline = AutomaticSpeechRecognitionPipeline(model=model, tokenizer=tokenizer, feature_extractor=feature_extractor)`}}),$t=new w({props:{code:"d2l0aCUyMHRvcmNoLmN1ZGEuYW1wLmF1dG9jYXN0KCklM0ElMEElMjAlMjAlMjAlMjB0ZXh0JTIwJTNEJTIwcGlwZShhdWRpbyUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMmZvcmNlZF9kZWNvZGVyX2lkcyUyMiUzQSUyMGZvcmNlZF9kZWNvZGVyX2lkcyU3RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU1KSU1QiUyMnRleHQlMjIlNUQlMEF0ZXh0JTBBJTIyJUUwJUE0JUFFJUUwJUE1JTgwJTIwJUUwJUE0JUE0JUUwJUE1JTgxJUUwJUE0JUFFJUUwJUE0JTlBJUUwJUE1JThEJUUwJUE0JUFGJUUwJUE0JUJFJUUwJUE0JUI4JUUwJUE0JUJFJUUwJUE0JUEwJUUwJUE1JTgwJTIwJUUwJUE0JTk1JUUwJUE0JUJFJUUwJUE0JUI5JUUwJUE1JTgwJTIwJUUwJUE0JTk1JUUwJUE0JUIwJUUwJUE1JTgyJTIwJUUwJUE0JUI2JUUwJUE0JTk1JUUwJUE0JUE0JUUwJUE1JThCJTIwJUUwJUE0JTk1JUUwJUE0JUJFJTNGJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.cuda.amp.autocast():
    text = pipe(audio, generate_kwargs={<span class="hljs-string">&quot;forced_decoder_ids&quot;</span>: forced_decoder_ids}, max_new_tokens=<span class="hljs-number">255</span>)[<span class="hljs-string">&quot;text&quot;</span>]
text
<span class="hljs-string">&quot;\u092E\u0940 \u0924\u0941\u092E\u091A\u094D\u092F\u093E\u0938\u093E\u0920\u0940 \u0915\u093E\u0939\u0940 \u0915\u0930\u0942 \u0936\u0915\u0924\u094B \u0915\u093E?&quot;</span>`}}),{c(){h=o("meta"),V=J(),T=o("h1"),v=o("a"),A=o("span"),U(b.$$.fragment),x=J(),B=o("span"),k=l("int8 training for automatic speech recognition"),g=J(),I=o("p"),Y=l("Quantization reduces the precision of floating point data types, decreasing the memory required to store model weights. However, quantization degrades inference performance because you lose information when you reduce the precision. 8-bit or "),ie=o("code"),Ae=l("int8"),ce=l(" quantization uses only a quarter precision, but it does not degrade performance because it doesn\u2019t just drop the bits or data. Instead, "),pe=o("code"),Be=l("int8"),Je=l(" quantization "),j=o("em"),zt=l("rounds"),Dt=l(" from one data type to another."),Ve=J(),U(H.$$.fragment),Ye=J(),$=o("p"),ao=l("This guide will show you how to train a "),$e=o("a"),Ma=o("code"),lo=l("openai/whisper-large-v2"),so=l(" model for multilingual automatic speech recognition (ASR) using a combination of "),fa=o("code"),oo=l("int8"),no=l(" quantization and LoRA. You\u2019ll train Whisper for multilingual ASR on Marathi from the "),Qe=o("a"),ro=l("Common Voice 11.0"),io=l(" dataset."),Wl=J(),xt=o("p"),co=l("Before you start, make sure you have all the necessary libraries installed:"),Nl=J(),U(Se.$$.fragment),Fl=J(),de=o("h2"),we=o("a"),wa=o("span"),U(qe.$$.fragment),po=J(),Ta=o("span"),Jo=l("Setup"),Rl=J(),L=o("p"),ho=l("Let\u2019s take care of some of the setup first so you can start training faster later. Set the "),ba=o("code"),Uo=l("CUDA_VISIBLE_DEVICES"),uo=l(" to "),ja=o("code"),mo=l("0"),yo=l(" to use the first GPU on your machine. Then you can specify the model name (either a Hub model repository id or a path to a directory containing the model), language and language abbreviation to train on, the task type, and the dataset name:"),Xl=J(),U(ze.$$.fragment),Al=J(),Ht=o("p"),Mo=l("You can also log in to your Hugging Face account to save and share your trained model on the Hub if you\u2019d like:"),Bl=J(),U(De.$$.fragment),Vl=J(),he=o("h2"),Te=o("a"),Ia=o("span"),U(xe.$$.fragment),fo=J(),Ea=o("span"),wo=l("Load dataset and metric"),Yl=J(),P=o("p"),To=l("The "),He=o("a"),bo=l("Common Voice 11.0"),jo=l(" dataset contains many hours of recorded speech in many different languages. This guide uses the "),Le=o("a"),Io=l("Marathi"),Eo=l(" language as an example, but feel free to use any other language you\u2019re interested in."),$l=J(),C=o("p"),_o=l("Initialize a "),Pe=o("a"),go=l("DatasetDict"),vo=l(" structure, and load the "),_a=o("code"),Co=l("train"),Zo=l(" (load both the "),ga=o("code"),ko=l("train+validation"),Go=l(" split into "),va=o("code"),Wo=l("train"),No=l(") and "),Ca=o("code"),Fo=l("test"),Ro=l(" splits from the dataset into it:"),Ql=J(),U(Oe.$$.fragment),Sl=J(),Ue=o("h2"),be=o("a"),Za=o("span"),U(Ke.$$.fragment),Xo=J(),ka=o("span"),Ao=l("Preprocess dataset"),ql=J(),Lt=o("p"),Bo=l("Let\u2019s prepare the dataset for training. Load a feature extractor, tokenizer, and processor. You should also pass the language and task to the tokenizer and processor so they know how to process the inputs:"),zl=J(),U(et.$$.fragment),Dl=J(),Q=o("p"),Vo=l("You\u2019ll only be training on the "),Ga=o("code"),Yo=l("sentence"),$o=l(" and "),Wa=o("code"),Qo=l("audio"),So=l(" columns, so you can remove the rest of the metadata with "),tt=o("a"),qo=l("remove_columns"),zo=l(":"),xl=J(),U(at.$$.fragment),Hl=J(),G=o("p"),Do=l("If you look at the "),Na=o("code"),xo=l("sampling_rate"),Ho=l(", you\u2019ll see the audio was sampled at 48kHz. The Whisper model was pretrained on audio inputs at 16kHZ which means you\u2019ll need to downsample the audio inputs to match what the model was pretrained on. Downsample the audio by using the "),lt=o("a"),Lo=l("cast_column"),Po=l(" method on the "),Fa=o("code"),Oo=l("audio"),Ko=l(" column, and set the "),Ra=o("code"),en=l("sampling_rate"),tn=l(" to 16kHz. The audio input is resampled on the fly the next time you call it:"),Ll=J(),U(st.$$.fragment),Pl=J(),Pt=o("p"),an=l("Once you\u2019ve cleaned up the dataset, you can write a function to generate the correct model inputs. The function should:"),Ol=J(),O=o("ol"),ot=o("li"),ln=l("Resample the audio inputs to 16kHZ by loading the "),Xa=o("code"),sn=l("audio"),on=l(" column."),nn=J(),nt=o("li"),rn=l("Compute the input features from the audio "),Aa=o("code"),cn=l("array"),pn=l(" using the feature extractor."),Jn=J(),rt=o("li"),dn=l("Tokenize the "),Ba=o("code"),hn=l("sentence"),Un=l(" column to the input labels."),Kl=J(),U(it.$$.fragment),es=J(),E=o("p"),un=l("Apply the "),Va=o("code"),mn=l("prepare_dataset"),yn=l(" function to the dataset with the "),ct=o("a"),Mn=l("map"),fn=l(" function, and set the "),Ya=o("code"),wn=l("num_proc"),Tn=l(" argument to "),$a=o("code"),bn=l("2"),jn=l(" to enable multiprocessing (if "),Qa=o("code"),In=l("map"),En=l(" hangs, then set "),Sa=o("code"),_n=l("num_proc=1"),gn=l("):"),ts=J(),U(pt.$$.fragment),as=J(),K=o("p"),vn=l("Finally, create a "),qa=o("code"),Cn=l("DataCollator"),Zn=l(" class to pad the labels in each batch to the maximum length, and replace padding with "),za=o("code"),kn=l("-100"),Gn=l(" so they\u2019re ignored by the loss function. Then initialize an instance of the data collator:"),ls=J(),U(Jt.$$.fragment),ss=J(),ue=o("h2"),je=o("a"),Da=o("span"),U(dt.$$.fragment),Wn=J(),xa=o("span"),Nn=l("Train"),os=J(),_=o("p"),Fn=l("Now that the dataset is ready, you can turn your attention to the model. Start by loading the pretrained "),Ot=o("a"),Ha=o("code"),Rn=l("openai/whisper-large-v2"),Xn=l(" model from "),ht=o("a"),An=l("AutoModelForSpeechSeq2Seq"),Bn=l(", and make sure to set the "),La=o("code"),Vn=l("load_in_8bit"),Yn=l(" argument to "),Pa=o("code"),$n=l("True"),Qn=l(" to enable "),Oa=o("code"),Sn=l("int8"),qn=l(" quantization. The "),Ka=o("code"),zn=l("device_map=auto"),Dn=l(" argument automatically determines how to load and store the model weights:"),ns=J(),U(Ut.$$.fragment),rs=J(),Ie=o("p"),xn=l("You should configure "),el=o("code"),Hn=l("forced_decoder_ids=None"),Ln=l(" because no tokens are used before sampling, and you won\u2019t need to suppress any tokens during generation either:"),is=J(),U(ut.$$.fragment),cs=J(),ee=o("p"),Pn=l("To get the model ready for "),tl=o("code"),On=l("int8"),Kn=l(" quantization, use the utility function "),mt=o("a"),al=o("code"),er=l("prepare_model_for_int8_training"),tr=l(" to handle the following:"),ps=J(),te=o("ul"),me=o("li"),ar=l("casts all the non "),ll=o("code"),lr=l("int8"),sr=l(" modules to full precision ("),sl=o("code"),or=l("fp32"),nr=l(") for stability"),rr=J(),ol=o("li"),ir=l("adds a forward hook to the input embedding layer to calculate the gradients of the input hidden states"),cr=J(),nl=o("li"),pr=l("enables gradient checkpointing for more memory-efficient training"),Js=J(),U(yt.$$.fragment),ds=J(),Ee=o("p"),Jr=l("Let\u2019s also apply LoRA to the training to make it even more efficient. Load a "),Kt=o("a"),dr=l("LoraConfig"),hr=l(" and configure the following parameters:"),hs=J(),W=o("ul"),ea=o("li"),rl=o("code"),Ur=l("r"),ur=l(", the dimension of the low-rank matrices"),mr=J(),ta=o("li"),il=o("code"),yr=l("lora_alpha"),Mr=l(", scaling factor for the weight matrices"),fr=J(),ae=o("li"),cl=o("code"),wr=l("target_modules"),Tr=l(", the name of the attention matrices to apply LoRA to ("),pl=o("code"),br=l("q_proj"),jr=l(" and "),Jl=o("code"),Ir=l("v_proj"),Er=l(", or query and value in this case)"),_r=J(),aa=o("li"),dl=o("code"),gr=l("lora_dropout"),vr=l(", dropout probability of the LoRA layers"),Cr=J(),Mt=o("li"),hl=o("code"),Zr=l("bias"),kr=l(", set to "),Ul=o("code"),Gr=l("none"),Us=J(),U(_e.$$.fragment),us=J(),U(ft.$$.fragment),ms=J(),S=o("p"),Wr=l("After you set up the "),la=o("a"),Nr=l("LoraConfig"),Fr=l(", wrap it and the base model with the "),ul=o("code"),Rr=l("get_peft_model()"),Xr=l(" function to create a "),sa=o("a"),Ar=l("PeftModel"),Br=l(". Print out the number of trainable parameters to see how much more efficient LoRA is compared to fully training the model!"),ys=J(),U(wt.$$.fragment),Ms=J(),N=o("p"),Vr=l("Now you\u2019re ready to define some training hyperparameters in the "),Tt=o("a"),Yr=l("Seq2SeqTrainingArguments"),$r=l(" class, such as where to save the model to, batch size, learning rate, and number of epochs to train for. The "),oa=o("a"),Qr=l("PeftModel"),Sr=l(" doesn\u2019t have the same signature as the base model, so you\u2019ll need to explicitly set "),ml=o("code"),qr=l("remove_unused_columns=False"),zr=l(" and "),yl=o("code"),Dr=l('label_names=["labels"]'),xr=l("."),fs=J(),U(bt.$$.fragment),ws=J(),ge=o("p"),Hr=l("It is also a good idea to write a custom "),jt=o("a"),Lr=l("TrainerCallback"),Pr=l(" to save model checkpoints during training:"),Ts=J(),U(It.$$.fragment),bs=J(),F=o("p"),Or=l("Pass the "),Ml=o("code"),Kr=l("Seq2SeqTrainingArguments"),ei=l(", model, datasets, data collator, tokenizer, and callback to the "),Et=o("a"),ti=l("Seq2SeqTrainer"),ai=l(". You can optionally set "),fl=o("code"),li=l("model.config.use_cache = False"),si=l(" to silence any warnings. Once everything is ready, call "),_t=o("a"),oi=l("train"),ni=l(" to start training!"),js=J(),U(gt.$$.fragment),Is=J(),ye=o("h2"),ve=o("a"),wl=o("span"),U(vt.$$.fragment),ri=J(),Tl=o("span"),ii=l("Evaluate"),Es=J(),Ct=o("p"),Zt=o("a"),ci=l("Word error rate"),pi=l(" (WER) is a common metric for evaluating ASR models. Load the WER metric from \u{1F917} Evaluate:"),_s=J(),U(kt.$$.fragment),gs=J(),q=o("p"),Ji=l("Write a loop to evaluate the model performance. Set the model to evaluation mode first, and write the loop with "),Gt=o("a"),bl=o("code"),di=l("torch.cuda.amp.autocast()"),hi=l(" because "),jl=o("code"),Ui=l("int8"),ui=l(" training requires autocasting. Then, pass a batch of examples to the model to evaluate. Get the decoded predictions and labels, and add them as a batch to the WER metric before calling "),Il=o("code"),mi=l("compute"),yi=l(" to get the final WER score:"),vs=J(),U(Wt.$$.fragment),Cs=J(),Me=o("h2"),Ce=o("a"),El=o("span"),U(Nt.$$.fragment),Mi=J(),_l=o("span"),fi=l("Share model"),Zs=J(),Ze=o("p"),wi=l("Once you\u2019re happy with your results, you can upload your model to the Hub with the "),Ft=o("a"),Ti=l("push_to_hub"),bi=l(" method:"),ks=J(),U(Rt.$$.fragment),Gs=J(),fe=o("h2"),ke=o("a"),gl=o("span"),U(Xt.$$.fragment),ji=J(),vl=o("span"),Ii=l("Inference"),Ws=J(),na=o("p"),Ei=l("Let\u2019s test the model out now!"),Ns=J(),Z=o("p"),_i=l("Instantiate the model configuration from "),ra=o("a"),gi=l("PeftConfig"),vi=l(", and from here, you can use the configuration to load the base and "),ia=o("a"),Ci=l("PeftModel"),Zi=l(", tokenizer, processor, and feature extractor. Remember to define the "),Cl=o("code"),ki=l("language"),Gi=l(" and "),Zl=o("code"),Wi=l("task"),Ni=l(" in the tokenizer, processor, and "),kl=o("code"),Fi=l("forced_decoder_ids"),Ri=l(":"),Fs=J(),U(At.$$.fragment),Rs=J(),le=o("p"),Xi=l("Load an audio sample (you can listen to it in the "),Bt=o("a"),Ai=l("Dataset Preview"),Bi=l(") to transcribe, and the "),Vt=o("a"),Vi=l("AutomaticSpeechRecognitionPipeline"),Yi=l(":"),Xs=J(),U(Yt.$$.fragment),As=J(),ca=o("p"),$i=l("Then use the pipeline with autocast as a context manager on the audio sample:"),Bs=J(),U($t.$$.fragment),this.h()},l(e){const i=tJ('[data-svelte="svelte-1phssyn"]',document.head);h=n(i,"META",{name:!0,content:!0}),i.forEach(a),V=d(e),T=n(e,"H1",{class:!0});var Qt=r(T);v=n(Qt,"A",{id:!0,class:!0,href:!0});var Gl=r(v);A=n(Gl,"SPAN",{});var Di=r(A);u(b.$$.fragment,Di),Di.forEach(a),Gl.forEach(a),x=d(Qt),B=n(Qt,"SPAN",{});var xi=r(B);k=s(xi,"int8 training for automatic speech recognition"),xi.forEach(a),Qt.forEach(a),g=d(e),I=n(e,"P",{});var Ge=r(I);Y=s(Ge,"Quantization reduces the precision of floating point data types, decreasing the memory required to store model weights. However, quantization degrades inference performance because you lose information when you reduce the precision. 8-bit or "),ie=n(Ge,"CODE",{});var Hi=r(ie);Ae=s(Hi,"int8"),Hi.forEach(a),ce=s(Ge," quantization uses only a quarter precision, but it does not degrade performance because it doesn\u2019t just drop the bits or data. Instead, "),pe=n(Ge,"CODE",{});var Li=r(pe);Be=s(Li,"int8"),Li.forEach(a),Je=s(Ge," quantization "),j=n(Ge,"EM",{});var Pi=r(j);zt=s(Pi,"rounds"),Pi.forEach(a),Dt=s(Ge," from one data type to another."),Ge.forEach(a),Ve=d(e),u(H.$$.fragment,e),Ye=d(e),$=n(e,"P",{});var We=r($);ao=s(We,"This guide will show you how to train a "),$e=n(We,"A",{href:!0,rel:!0});var Oi=r($e);Ma=n(Oi,"CODE",{});var Ki=r(Ma);lo=s(Ki,"openai/whisper-large-v2"),Ki.forEach(a),Oi.forEach(a),so=s(We," model for multilingual automatic speech recognition (ASR) using a combination of "),fa=n(We,"CODE",{});var ec=r(fa);oo=s(ec,"int8"),ec.forEach(a),no=s(We," quantization and LoRA. You\u2019ll train Whisper for multilingual ASR on Marathi from the "),Qe=n(We,"A",{href:!0,rel:!0});var tc=r(Qe);ro=s(tc,"Common Voice 11.0"),tc.forEach(a),io=s(We," dataset."),We.forEach(a),Wl=d(e),xt=n(e,"P",{});var ac=r(xt);co=s(ac,"Before you start, make sure you have all the necessary libraries installed:"),ac.forEach(a),Nl=d(e),u(Se.$$.fragment,e),Fl=d(e),de=n(e,"H2",{class:!0});var Ys=r(de);we=n(Ys,"A",{id:!0,class:!0,href:!0});var lc=r(we);wa=n(lc,"SPAN",{});var sc=r(wa);u(qe.$$.fragment,sc),sc.forEach(a),lc.forEach(a),po=d(Ys),Ta=n(Ys,"SPAN",{});var oc=r(Ta);Jo=s(oc,"Setup"),oc.forEach(a),Ys.forEach(a),Rl=d(e),L=n(e,"P",{});var pa=r(L);ho=s(pa,"Let\u2019s take care of some of the setup first so you can start training faster later. Set the "),ba=n(pa,"CODE",{});var nc=r(ba);Uo=s(nc,"CUDA_VISIBLE_DEVICES"),nc.forEach(a),uo=s(pa," to "),ja=n(pa,"CODE",{});var rc=r(ja);mo=s(rc,"0"),rc.forEach(a),yo=s(pa," to use the first GPU on your machine. Then you can specify the model name (either a Hub model repository id or a path to a directory containing the model), language and language abbreviation to train on, the task type, and the dataset name:"),pa.forEach(a),Xl=d(e),u(ze.$$.fragment,e),Al=d(e),Ht=n(e,"P",{});var ic=r(Ht);Mo=s(ic,"You can also log in to your Hugging Face account to save and share your trained model on the Hub if you\u2019d like:"),ic.forEach(a),Bl=d(e),u(De.$$.fragment,e),Vl=d(e),he=n(e,"H2",{class:!0});var $s=r(he);Te=n($s,"A",{id:!0,class:!0,href:!0});var cc=r(Te);Ia=n(cc,"SPAN",{});var pc=r(Ia);u(xe.$$.fragment,pc),pc.forEach(a),cc.forEach(a),fo=d($s),Ea=n($s,"SPAN",{});var Jc=r(Ea);wo=s(Jc,"Load dataset and metric"),Jc.forEach(a),$s.forEach(a),Yl=d(e),P=n(e,"P",{});var Ja=r(P);To=s(Ja,"The "),He=n(Ja,"A",{href:!0,rel:!0});var dc=r(He);bo=s(dc,"Common Voice 11.0"),dc.forEach(a),jo=s(Ja," dataset contains many hours of recorded speech in many different languages. This guide uses the "),Le=n(Ja,"A",{href:!0,rel:!0});var hc=r(Le);Io=s(hc,"Marathi"),hc.forEach(a),Eo=s(Ja," language as an example, but feel free to use any other language you\u2019re interested in."),Ja.forEach(a),$l=d(e),C=n(e,"P",{});var z=r(C);_o=s(z,"Initialize a "),Pe=n(z,"A",{href:!0,rel:!0});var Uc=r(Pe);go=s(Uc,"DatasetDict"),Uc.forEach(a),vo=s(z," structure, and load the "),_a=n(z,"CODE",{});var uc=r(_a);Co=s(uc,"train"),uc.forEach(a),Zo=s(z," (load both the "),ga=n(z,"CODE",{});var mc=r(ga);ko=s(mc,"train+validation"),mc.forEach(a),Go=s(z," split into "),va=n(z,"CODE",{});var yc=r(va);Wo=s(yc,"train"),yc.forEach(a),No=s(z,") and "),Ca=n(z,"CODE",{});var Mc=r(Ca);Fo=s(Mc,"test"),Mc.forEach(a),Ro=s(z," splits from the dataset into it:"),z.forEach(a),Ql=d(e),u(Oe.$$.fragment,e),Sl=d(e),Ue=n(e,"H2",{class:!0});var Qs=r(Ue);be=n(Qs,"A",{id:!0,class:!0,href:!0});var fc=r(be);Za=n(fc,"SPAN",{});var wc=r(Za);u(Ke.$$.fragment,wc),wc.forEach(a),fc.forEach(a),Xo=d(Qs),ka=n(Qs,"SPAN",{});var Tc=r(ka);Ao=s(Tc,"Preprocess dataset"),Tc.forEach(a),Qs.forEach(a),ql=d(e),Lt=n(e,"P",{});var bc=r(Lt);Bo=s(bc,"Let\u2019s prepare the dataset for training. Load a feature extractor, tokenizer, and processor. You should also pass the language and task to the tokenizer and processor so they know how to process the inputs:"),bc.forEach(a),zl=d(e),u(et.$$.fragment,e),Dl=d(e),Q=n(e,"P",{});var Ne=r(Q);Vo=s(Ne,"You\u2019ll only be training on the "),Ga=n(Ne,"CODE",{});var jc=r(Ga);Yo=s(jc,"sentence"),jc.forEach(a),$o=s(Ne," and "),Wa=n(Ne,"CODE",{});var Ic=r(Wa);Qo=s(Ic,"audio"),Ic.forEach(a),So=s(Ne," columns, so you can remove the rest of the metadata with "),tt=n(Ne,"A",{href:!0,rel:!0});var Ec=r(tt);qo=s(Ec,"remove_columns"),Ec.forEach(a),zo=s(Ne,":"),Ne.forEach(a),xl=d(e),u(at.$$.fragment,e),Hl=d(e),G=n(e,"P",{});var se=r(G);Do=s(se,"If you look at the "),Na=n(se,"CODE",{});var _c=r(Na);xo=s(_c,"sampling_rate"),_c.forEach(a),Ho=s(se,", you\u2019ll see the audio was sampled at 48kHz. The Whisper model was pretrained on audio inputs at 16kHZ which means you\u2019ll need to downsample the audio inputs to match what the model was pretrained on. Downsample the audio by using the "),lt=n(se,"A",{href:!0,rel:!0});var gc=r(lt);Lo=s(gc,"cast_column"),gc.forEach(a),Po=s(se," method on the "),Fa=n(se,"CODE",{});var vc=r(Fa);Oo=s(vc,"audio"),vc.forEach(a),Ko=s(se," column, and set the "),Ra=n(se,"CODE",{});var Cc=r(Ra);en=s(Cc,"sampling_rate"),Cc.forEach(a),tn=s(se," to 16kHz. The audio input is resampled on the fly the next time you call it:"),se.forEach(a),Ll=d(e),u(st.$$.fragment,e),Pl=d(e),Pt=n(e,"P",{});var Zc=r(Pt);an=s(Zc,"Once you\u2019ve cleaned up the dataset, you can write a function to generate the correct model inputs. The function should:"),Zc.forEach(a),Ol=d(e),O=n(e,"OL",{});var da=r(O);ot=n(da,"LI",{});var Ss=r(ot);ln=s(Ss,"Resample the audio inputs to 16kHZ by loading the "),Xa=n(Ss,"CODE",{});var kc=r(Xa);sn=s(kc,"audio"),kc.forEach(a),on=s(Ss," column."),Ss.forEach(a),nn=d(da),nt=n(da,"LI",{});var qs=r(nt);rn=s(qs,"Compute the input features from the audio "),Aa=n(qs,"CODE",{});var Gc=r(Aa);cn=s(Gc,"array"),Gc.forEach(a),pn=s(qs," using the feature extractor."),qs.forEach(a),Jn=d(da),rt=n(da,"LI",{});var zs=r(rt);dn=s(zs,"Tokenize the "),Ba=n(zs,"CODE",{});var Wc=r(Ba);hn=s(Wc,"sentence"),Wc.forEach(a),Un=s(zs," column to the input labels."),zs.forEach(a),da.forEach(a),Kl=d(e),u(it.$$.fragment,e),es=d(e),E=n(e,"P",{});var R=r(E);un=s(R,"Apply the "),Va=n(R,"CODE",{});var Nc=r(Va);mn=s(Nc,"prepare_dataset"),Nc.forEach(a),yn=s(R," function to the dataset with the "),ct=n(R,"A",{href:!0,rel:!0});var Fc=r(ct);Mn=s(Fc,"map"),Fc.forEach(a),fn=s(R," function, and set the "),Ya=n(R,"CODE",{});var Rc=r(Ya);wn=s(Rc,"num_proc"),Rc.forEach(a),Tn=s(R," argument to "),$a=n(R,"CODE",{});var Xc=r($a);bn=s(Xc,"2"),Xc.forEach(a),jn=s(R," to enable multiprocessing (if "),Qa=n(R,"CODE",{});var Ac=r(Qa);In=s(Ac,"map"),Ac.forEach(a),En=s(R," hangs, then set "),Sa=n(R,"CODE",{});var Bc=r(Sa);_n=s(Bc,"num_proc=1"),Bc.forEach(a),gn=s(R,"):"),R.forEach(a),ts=d(e),u(pt.$$.fragment,e),as=d(e),K=n(e,"P",{});var ha=r(K);vn=s(ha,"Finally, create a "),qa=n(ha,"CODE",{});var Vc=r(qa);Cn=s(Vc,"DataCollator"),Vc.forEach(a),Zn=s(ha," class to pad the labels in each batch to the maximum length, and replace padding with "),za=n(ha,"CODE",{});var Yc=r(za);kn=s(Yc,"-100"),Yc.forEach(a),Gn=s(ha," so they\u2019re ignored by the loss function. Then initialize an instance of the data collator:"),ha.forEach(a),ls=d(e),u(Jt.$$.fragment,e),ss=d(e),ue=n(e,"H2",{class:!0});var Ds=r(ue);je=n(Ds,"A",{id:!0,class:!0,href:!0});var $c=r(je);Da=n($c,"SPAN",{});var Qc=r(Da);u(dt.$$.fragment,Qc),Qc.forEach(a),$c.forEach(a),Wn=d(Ds),xa=n(Ds,"SPAN",{});var Sc=r(xa);Nn=s(Sc,"Train"),Sc.forEach(a),Ds.forEach(a),os=d(e),_=n(e,"P",{});var X=r(_);Fn=s(X,"Now that the dataset is ready, you can turn your attention to the model. Start by loading the pretrained "),Ot=n(X,"A",{href:!0});var qc=r(Ot);Ha=n(qc,"CODE",{});var zc=r(Ha);Rn=s(zc,"openai/whisper-large-v2"),zc.forEach(a),qc.forEach(a),Xn=s(X," model from "),ht=n(X,"A",{href:!0,rel:!0});var Dc=r(ht);An=s(Dc,"AutoModelForSpeechSeq2Seq"),Dc.forEach(a),Bn=s(X,", and make sure to set the "),La=n(X,"CODE",{});var xc=r(La);Vn=s(xc,"load_in_8bit"),xc.forEach(a),Yn=s(X," argument to "),Pa=n(X,"CODE",{});var Hc=r(Pa);$n=s(Hc,"True"),Hc.forEach(a),Qn=s(X," to enable "),Oa=n(X,"CODE",{});var Lc=r(Oa);Sn=s(Lc,"int8"),Lc.forEach(a),qn=s(X," quantization. The "),Ka=n(X,"CODE",{});var Pc=r(Ka);zn=s(Pc,"device_map=auto"),Pc.forEach(a),Dn=s(X," argument automatically determines how to load and store the model weights:"),X.forEach(a),ns=d(e),u(Ut.$$.fragment,e),rs=d(e),Ie=n(e,"P",{});var xs=r(Ie);xn=s(xs,"You should configure "),el=n(xs,"CODE",{});var Oc=r(el);Hn=s(Oc,"forced_decoder_ids=None"),Oc.forEach(a),Ln=s(xs," because no tokens are used before sampling, and you won\u2019t need to suppress any tokens during generation either:"),xs.forEach(a),is=d(e),u(ut.$$.fragment,e),cs=d(e),ee=n(e,"P",{});var Ua=r(ee);Pn=s(Ua,"To get the model ready for "),tl=n(Ua,"CODE",{});var Kc=r(tl);On=s(Kc,"int8"),Kc.forEach(a),Kn=s(Ua," quantization, use the utility function "),mt=n(Ua,"A",{href:!0,rel:!0});var ep=r(mt);al=n(ep,"CODE",{});var tp=r(al);er=s(tp,"prepare_model_for_int8_training"),tp.forEach(a),ep.forEach(a),tr=s(Ua," to handle the following:"),Ua.forEach(a),ps=d(e),te=n(e,"UL",{});var ua=r(te);me=n(ua,"LI",{});var ma=r(me);ar=s(ma,"casts all the non "),ll=n(ma,"CODE",{});var ap=r(ll);lr=s(ap,"int8"),ap.forEach(a),sr=s(ma," modules to full precision ("),sl=n(ma,"CODE",{});var lp=r(sl);or=s(lp,"fp32"),lp.forEach(a),nr=s(ma,") for stability"),ma.forEach(a),rr=d(ua),ol=n(ua,"LI",{});var sp=r(ol);ir=s(sp,"adds a forward hook to the input embedding layer to calculate the gradients of the input hidden states"),sp.forEach(a),cr=d(ua),nl=n(ua,"LI",{});var op=r(nl);pr=s(op,"enables gradient checkpointing for more memory-efficient training"),op.forEach(a),ua.forEach(a),Js=d(e),u(yt.$$.fragment,e),ds=d(e),Ee=n(e,"P",{});var Hs=r(Ee);Jr=s(Hs,"Let\u2019s also apply LoRA to the training to make it even more efficient. Load a "),Kt=n(Hs,"A",{href:!0});var np=r(Kt);dr=s(np,"LoraConfig"),np.forEach(a),hr=s(Hs," and configure the following parameters:"),Hs.forEach(a),hs=d(e),W=n(e,"UL",{});var oe=r(W);ea=n(oe,"LI",{});var Qi=r(ea);rl=n(Qi,"CODE",{});var rp=r(rl);Ur=s(rp,"r"),rp.forEach(a),ur=s(Qi,", the dimension of the low-rank matrices"),Qi.forEach(a),mr=d(oe),ta=n(oe,"LI",{});var Si=r(ta);il=n(Si,"CODE",{});var ip=r(il);yr=s(ip,"lora_alpha"),ip.forEach(a),Mr=s(Si,", scaling factor for the weight matrices"),Si.forEach(a),fr=d(oe),ae=n(oe,"LI",{});var St=r(ae);cl=n(St,"CODE",{});var cp=r(cl);wr=s(cp,"target_modules"),cp.forEach(a),Tr=s(St,", the name of the attention matrices to apply LoRA to ("),pl=n(St,"CODE",{});var pp=r(pl);br=s(pp,"q_proj"),pp.forEach(a),jr=s(St," and "),Jl=n(St,"CODE",{});var Jp=r(Jl);Ir=s(Jp,"v_proj"),Jp.forEach(a),Er=s(St,", or query and value in this case)"),St.forEach(a),_r=d(oe),aa=n(oe,"LI",{});var qi=r(aa);dl=n(qi,"CODE",{});var dp=r(dl);gr=s(dp,"lora_dropout"),dp.forEach(a),vr=s(qi,", dropout probability of the LoRA layers"),qi.forEach(a),Cr=d(oe),Mt=n(oe,"LI",{});var Ls=r(Mt);hl=n(Ls,"CODE",{});var hp=r(hl);Zr=s(hp,"bias"),hp.forEach(a),kr=s(Ls,", set to "),Ul=n(Ls,"CODE",{});var Up=r(Ul);Gr=s(Up,"none"),Up.forEach(a),Ls.forEach(a),oe.forEach(a),Us=d(e),u(_e.$$.fragment,e),us=d(e),u(ft.$$.fragment,e),ms=d(e),S=n(e,"P",{});var Fe=r(S);Wr=s(Fe,"After you set up the "),la=n(Fe,"A",{href:!0});var up=r(la);Nr=s(up,"LoraConfig"),up.forEach(a),Fr=s(Fe,", wrap it and the base model with the "),ul=n(Fe,"CODE",{});var mp=r(ul);Rr=s(mp,"get_peft_model()"),mp.forEach(a),Xr=s(Fe," function to create a "),sa=n(Fe,"A",{href:!0});var yp=r(sa);Ar=s(yp,"PeftModel"),yp.forEach(a),Br=s(Fe,". Print out the number of trainable parameters to see how much more efficient LoRA is compared to fully training the model!"),Fe.forEach(a),ys=d(e),u(wt.$$.fragment,e),Ms=d(e),N=n(e,"P",{});var ne=r(N);Vr=s(ne,"Now you\u2019re ready to define some training hyperparameters in the "),Tt=n(ne,"A",{href:!0,rel:!0});var Mp=r(Tt);Yr=s(Mp,"Seq2SeqTrainingArguments"),Mp.forEach(a),$r=s(ne," class, such as where to save the model to, batch size, learning rate, and number of epochs to train for. The "),oa=n(ne,"A",{href:!0});var fp=r(oa);Qr=s(fp,"PeftModel"),fp.forEach(a),Sr=s(ne," doesn\u2019t have the same signature as the base model, so you\u2019ll need to explicitly set "),ml=n(ne,"CODE",{});var wp=r(ml);qr=s(wp,"remove_unused_columns=False"),wp.forEach(a),zr=s(ne," and "),yl=n(ne,"CODE",{});var Tp=r(yl);Dr=s(Tp,'label_names=["labels"]'),Tp.forEach(a),xr=s(ne,"."),ne.forEach(a),fs=d(e),u(bt.$$.fragment,e),ws=d(e),ge=n(e,"P",{});var Ps=r(ge);Hr=s(Ps,"It is also a good idea to write a custom "),jt=n(Ps,"A",{href:!0,rel:!0});var bp=r(jt);Lr=s(bp,"TrainerCallback"),bp.forEach(a),Pr=s(Ps," to save model checkpoints during training:"),Ps.forEach(a),Ts=d(e),u(It.$$.fragment,e),bs=d(e),F=n(e,"P",{});var re=r(F);Or=s(re,"Pass the "),Ml=n(re,"CODE",{});var jp=r(Ml);Kr=s(jp,"Seq2SeqTrainingArguments"),jp.forEach(a),ei=s(re,", model, datasets, data collator, tokenizer, and callback to the "),Et=n(re,"A",{href:!0,rel:!0});var Ip=r(Et);ti=s(Ip,"Seq2SeqTrainer"),Ip.forEach(a),ai=s(re,". You can optionally set "),fl=n(re,"CODE",{});var Ep=r(fl);li=s(Ep,"model.config.use_cache = False"),Ep.forEach(a),si=s(re," to silence any warnings. Once everything is ready, call "),_t=n(re,"A",{href:!0,rel:!0});var _p=r(_t);oi=s(_p,"train"),_p.forEach(a),ni=s(re," to start training!"),re.forEach(a),js=d(e),u(gt.$$.fragment,e),Is=d(e),ye=n(e,"H2",{class:!0});var Os=r(ye);ve=n(Os,"A",{id:!0,class:!0,href:!0});var gp=r(ve);wl=n(gp,"SPAN",{});var vp=r(wl);u(vt.$$.fragment,vp),vp.forEach(a),gp.forEach(a),ri=d(Os),Tl=n(Os,"SPAN",{});var Cp=r(Tl);ii=s(Cp,"Evaluate"),Cp.forEach(a),Os.forEach(a),Es=d(e),Ct=n(e,"P",{});var zi=r(Ct);Zt=n(zi,"A",{href:!0,rel:!0});var Zp=r(Zt);ci=s(Zp,"Word error rate"),Zp.forEach(a),pi=s(zi," (WER) is a common metric for evaluating ASR models. Load the WER metric from \u{1F917} Evaluate:"),zi.forEach(a),_s=d(e),u(kt.$$.fragment,e),gs=d(e),q=n(e,"P",{});var Re=r(q);Ji=s(Re,"Write a loop to evaluate the model performance. Set the model to evaluation mode first, and write the loop with "),Gt=n(Re,"A",{href:!0,rel:!0});var kp=r(Gt);bl=n(kp,"CODE",{});var Gp=r(bl);di=s(Gp,"torch.cuda.amp.autocast()"),Gp.forEach(a),kp.forEach(a),hi=s(Re," because "),jl=n(Re,"CODE",{});var Wp=r(jl);Ui=s(Wp,"int8"),Wp.forEach(a),ui=s(Re," training requires autocasting. Then, pass a batch of examples to the model to evaluate. Get the decoded predictions and labels, and add them as a batch to the WER metric before calling "),Il=n(Re,"CODE",{});var Np=r(Il);mi=s(Np,"compute"),Np.forEach(a),yi=s(Re," to get the final WER score:"),Re.forEach(a),vs=d(e),u(Wt.$$.fragment,e),Cs=d(e),Me=n(e,"H2",{class:!0});var Ks=r(Me);Ce=n(Ks,"A",{id:!0,class:!0,href:!0});var Fp=r(Ce);El=n(Fp,"SPAN",{});var Rp=r(El);u(Nt.$$.fragment,Rp),Rp.forEach(a),Fp.forEach(a),Mi=d(Ks),_l=n(Ks,"SPAN",{});var Xp=r(_l);fi=s(Xp,"Share model"),Xp.forEach(a),Ks.forEach(a),Zs=d(e),Ze=n(e,"P",{});var eo=r(Ze);wi=s(eo,"Once you\u2019re happy with your results, you can upload your model to the Hub with the "),Ft=n(eo,"A",{href:!0,rel:!0});var Ap=r(Ft);Ti=s(Ap,"push_to_hub"),Ap.forEach(a),bi=s(eo," method:"),eo.forEach(a),ks=d(e),u(Rt.$$.fragment,e),Gs=d(e),fe=n(e,"H2",{class:!0});var to=r(fe);ke=n(to,"A",{id:!0,class:!0,href:!0});var Bp=r(ke);gl=n(Bp,"SPAN",{});var Vp=r(gl);u(Xt.$$.fragment,Vp),Vp.forEach(a),Bp.forEach(a),ji=d(to),vl=n(to,"SPAN",{});var Yp=r(vl);Ii=s(Yp,"Inference"),Yp.forEach(a),to.forEach(a),Ws=d(e),na=n(e,"P",{});var $p=r(na);Ei=s($p,"Let\u2019s test the model out now!"),$p.forEach(a),Ns=d(e),Z=n(e,"P",{});var D=r(Z);_i=s(D,"Instantiate the model configuration from "),ra=n(D,"A",{href:!0});var Qp=r(ra);gi=s(Qp,"PeftConfig"),Qp.forEach(a),vi=s(D,", and from here, you can use the configuration to load the base and "),ia=n(D,"A",{href:!0});var Sp=r(ia);Ci=s(Sp,"PeftModel"),Sp.forEach(a),Zi=s(D,", tokenizer, processor, and feature extractor. Remember to define the "),Cl=n(D,"CODE",{});var qp=r(Cl);ki=s(qp,"language"),qp.forEach(a),Gi=s(D," and "),Zl=n(D,"CODE",{});var zp=r(Zl);Wi=s(zp,"task"),zp.forEach(a),Ni=s(D," in the tokenizer, processor, and "),kl=n(D,"CODE",{});var Dp=r(kl);Fi=s(Dp,"forced_decoder_ids"),Dp.forEach(a),Ri=s(D,":"),D.forEach(a),Fs=d(e),u(At.$$.fragment,e),Rs=d(e),le=n(e,"P",{});var ya=r(le);Xi=s(ya,"Load an audio sample (you can listen to it in the "),Bt=n(ya,"A",{href:!0,rel:!0});var xp=r(Bt);Ai=s(xp,"Dataset Preview"),xp.forEach(a),Bi=s(ya,") to transcribe, and the "),Vt=n(ya,"A",{href:!0,rel:!0});var Hp=r(Vt);Vi=s(Hp,"AutomaticSpeechRecognitionPipeline"),Hp.forEach(a),Yi=s(ya,":"),ya.forEach(a),Xs=d(e),u(Yt.$$.fragment,e),As=d(e),ca=n(e,"P",{});var Lp=r(ca);$i=s(Lp,"Then use the pipeline with autocast as a context manager on the audio sample:"),Lp.forEach(a),Bs=d(e),u($t.$$.fragment,e),this.h()},h(){p(h,"name","hf:doc:metadata"),p(h,"content",JSON.stringify(nJ)),p(v,"id","int8-training-for-automatic-speech-recognition"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#int8-training-for-automatic-speech-recognition"),p(T,"class","relative group"),p($e,"href","https://huggingface.co/openai/whisper-large-v2"),p($e,"rel","nofollow"),p(Qe,"href","https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0"),p(Qe,"rel","nofollow"),p(we,"id","setup"),p(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(we,"href","#setup"),p(de,"class","relative group"),p(Te,"id","load-dataset-and-metric"),p(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Te,"href","#load-dataset-and-metric"),p(he,"class","relative group"),p(He,"href","https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0"),p(He,"rel","nofollow"),p(Le,"href","https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0/viewer/mr/train"),p(Le,"rel","nofollow"),p(Pe,"href","https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.DatasetDict"),p(Pe,"rel","nofollow"),p(be,"id","preprocess-dataset"),p(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(be,"href","#preprocess-dataset"),p(Ue,"class","relative group"),p(tt,"href","https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.remove_columns"),p(tt,"rel","nofollow"),p(lt,"href","https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column"),p(lt,"rel","nofollow"),p(ct,"href","https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map"),p(ct,"rel","nofollow"),p(je,"id","train"),p(je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(je,"href","#train"),p(ue,"class","relative group"),p(Ot,"href",""),p(ht,"href","https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForSpeechSeq2Seq"),p(ht,"rel","nofollow"),p(mt,"href","https://github.com/huggingface/peft/blob/34027fe813756897767b9a6f19ae7f1c4c7b418c/src/peft/utils/other.py#L35"),p(mt,"rel","nofollow"),p(Kt,"href","/docs/peft/main/en/package_reference/tuners#peft.LoraConfig"),p(la,"href","/docs/peft/main/en/package_reference/tuners#peft.LoraConfig"),p(sa,"href","/docs/peft/main/en/package_reference/peft_model#peft.PeftModel"),p(Tt,"href","https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Seq2SeqTrainingArguments"),p(Tt,"rel","nofollow"),p(oa,"href","/docs/peft/main/en/package_reference/peft_model#peft.PeftModel"),p(jt,"href","https://huggingface.co/docs/transformers/main/en/main_classes/callback#transformers.TrainerCallback"),p(jt,"rel","nofollow"),p(Et,"href","https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Seq2SeqTrainer"),p(Et,"rel","nofollow"),p(_t,"href","https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train"),p(_t,"rel","nofollow"),p(ve,"id","evaluate"),p(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ve,"href","#evaluate"),p(ye,"class","relative group"),p(Zt,"href","https://huggingface.co/spaces/evaluate-metric/wer"),p(Zt,"rel","nofollow"),p(Gt,"href","https://pytorch.org/docs/stable/amp.html"),p(Gt,"rel","nofollow"),p(Ce,"id","share-model"),p(Ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ce,"href","#share-model"),p(Me,"class","relative group"),p(Ft,"href","https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub"),p(Ft,"rel","nofollow"),p(ke,"id","inference"),p(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ke,"href","#inference"),p(fe,"class","relative group"),p(ra,"href","/docs/peft/main/en/package_reference/config#peft.PeftConfig"),p(ia,"href","/docs/peft/main/en/package_reference/peft_model#peft.PeftModel"),p(Bt,"href","https://huggingface.co/datasets/stevhliu/dummy"),p(Bt,"rel","nofollow"),p(Vt,"href","https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline"),p(Vt,"rel","nofollow")},m(e,i){t(document.head,h),c(e,V,i),c(e,T,i),t(T,v),t(v,A),m(b,A,null),t(T,x),t(T,B),t(B,k),c(e,g,i),c(e,I,i),t(I,Y),t(I,ie),t(ie,Ae),t(I,ce),t(I,pe),t(pe,Be),t(I,Je),t(I,j),t(j,zt),t(I,Dt),c(e,Ve,i),m(H,e,i),c(e,Ye,i),c(e,$,i),t($,ao),t($,$e),t($e,Ma),t(Ma,lo),t($,so),t($,fa),t(fa,oo),t($,no),t($,Qe),t(Qe,ro),t($,io),c(e,Wl,i),c(e,xt,i),t(xt,co),c(e,Nl,i),m(Se,e,i),c(e,Fl,i),c(e,de,i),t(de,we),t(we,wa),m(qe,wa,null),t(de,po),t(de,Ta),t(Ta,Jo),c(e,Rl,i),c(e,L,i),t(L,ho),t(L,ba),t(ba,Uo),t(L,uo),t(L,ja),t(ja,mo),t(L,yo),c(e,Xl,i),m(ze,e,i),c(e,Al,i),c(e,Ht,i),t(Ht,Mo),c(e,Bl,i),m(De,e,i),c(e,Vl,i),c(e,he,i),t(he,Te),t(Te,Ia),m(xe,Ia,null),t(he,fo),t(he,Ea),t(Ea,wo),c(e,Yl,i),c(e,P,i),t(P,To),t(P,He),t(He,bo),t(P,jo),t(P,Le),t(Le,Io),t(P,Eo),c(e,$l,i),c(e,C,i),t(C,_o),t(C,Pe),t(Pe,go),t(C,vo),t(C,_a),t(_a,Co),t(C,Zo),t(C,ga),t(ga,ko),t(C,Go),t(C,va),t(va,Wo),t(C,No),t(C,Ca),t(Ca,Fo),t(C,Ro),c(e,Ql,i),m(Oe,e,i),c(e,Sl,i),c(e,Ue,i),t(Ue,be),t(be,Za),m(Ke,Za,null),t(Ue,Xo),t(Ue,ka),t(ka,Ao),c(e,ql,i),c(e,Lt,i),t(Lt,Bo),c(e,zl,i),m(et,e,i),c(e,Dl,i),c(e,Q,i),t(Q,Vo),t(Q,Ga),t(Ga,Yo),t(Q,$o),t(Q,Wa),t(Wa,Qo),t(Q,So),t(Q,tt),t(tt,qo),t(Q,zo),c(e,xl,i),m(at,e,i),c(e,Hl,i),c(e,G,i),t(G,Do),t(G,Na),t(Na,xo),t(G,Ho),t(G,lt),t(lt,Lo),t(G,Po),t(G,Fa),t(Fa,Oo),t(G,Ko),t(G,Ra),t(Ra,en),t(G,tn),c(e,Ll,i),m(st,e,i),c(e,Pl,i),c(e,Pt,i),t(Pt,an),c(e,Ol,i),c(e,O,i),t(O,ot),t(ot,ln),t(ot,Xa),t(Xa,sn),t(ot,on),t(O,nn),t(O,nt),t(nt,rn),t(nt,Aa),t(Aa,cn),t(nt,pn),t(O,Jn),t(O,rt),t(rt,dn),t(rt,Ba),t(Ba,hn),t(rt,Un),c(e,Kl,i),m(it,e,i),c(e,es,i),c(e,E,i),t(E,un),t(E,Va),t(Va,mn),t(E,yn),t(E,ct),t(ct,Mn),t(E,fn),t(E,Ya),t(Ya,wn),t(E,Tn),t(E,$a),t($a,bn),t(E,jn),t(E,Qa),t(Qa,In),t(E,En),t(E,Sa),t(Sa,_n),t(E,gn),c(e,ts,i),m(pt,e,i),c(e,as,i),c(e,K,i),t(K,vn),t(K,qa),t(qa,Cn),t(K,Zn),t(K,za),t(za,kn),t(K,Gn),c(e,ls,i),m(Jt,e,i),c(e,ss,i),c(e,ue,i),t(ue,je),t(je,Da),m(dt,Da,null),t(ue,Wn),t(ue,xa),t(xa,Nn),c(e,os,i),c(e,_,i),t(_,Fn),t(_,Ot),t(Ot,Ha),t(Ha,Rn),t(_,Xn),t(_,ht),t(ht,An),t(_,Bn),t(_,La),t(La,Vn),t(_,Yn),t(_,Pa),t(Pa,$n),t(_,Qn),t(_,Oa),t(Oa,Sn),t(_,qn),t(_,Ka),t(Ka,zn),t(_,Dn),c(e,ns,i),m(Ut,e,i),c(e,rs,i),c(e,Ie,i),t(Ie,xn),t(Ie,el),t(el,Hn),t(Ie,Ln),c(e,is,i),m(ut,e,i),c(e,cs,i),c(e,ee,i),t(ee,Pn),t(ee,tl),t(tl,On),t(ee,Kn),t(ee,mt),t(mt,al),t(al,er),t(ee,tr),c(e,ps,i),c(e,te,i),t(te,me),t(me,ar),t(me,ll),t(ll,lr),t(me,sr),t(me,sl),t(sl,or),t(me,nr),t(te,rr),t(te,ol),t(ol,ir),t(te,cr),t(te,nl),t(nl,pr),c(e,Js,i),m(yt,e,i),c(e,ds,i),c(e,Ee,i),t(Ee,Jr),t(Ee,Kt),t(Kt,dr),t(Ee,hr),c(e,hs,i),c(e,W,i),t(W,ea),t(ea,rl),t(rl,Ur),t(ea,ur),t(W,mr),t(W,ta),t(ta,il),t(il,yr),t(ta,Mr),t(W,fr),t(W,ae),t(ae,cl),t(cl,wr),t(ae,Tr),t(ae,pl),t(pl,br),t(ae,jr),t(ae,Jl),t(Jl,Ir),t(ae,Er),t(W,_r),t(W,aa),t(aa,dl),t(dl,gr),t(aa,vr),t(W,Cr),t(W,Mt),t(Mt,hl),t(hl,Zr),t(Mt,kr),t(Mt,Ul),t(Ul,Gr),c(e,Us,i),m(_e,e,i),c(e,us,i),m(ft,e,i),c(e,ms,i),c(e,S,i),t(S,Wr),t(S,la),t(la,Nr),t(S,Fr),t(S,ul),t(ul,Rr),t(S,Xr),t(S,sa),t(sa,Ar),t(S,Br),c(e,ys,i),m(wt,e,i),c(e,Ms,i),c(e,N,i),t(N,Vr),t(N,Tt),t(Tt,Yr),t(N,$r),t(N,oa),t(oa,Qr),t(N,Sr),t(N,ml),t(ml,qr),t(N,zr),t(N,yl),t(yl,Dr),t(N,xr),c(e,fs,i),m(bt,e,i),c(e,ws,i),c(e,ge,i),t(ge,Hr),t(ge,jt),t(jt,Lr),t(ge,Pr),c(e,Ts,i),m(It,e,i),c(e,bs,i),c(e,F,i),t(F,Or),t(F,Ml),t(Ml,Kr),t(F,ei),t(F,Et),t(Et,ti),t(F,ai),t(F,fl),t(fl,li),t(F,si),t(F,_t),t(_t,oi),t(F,ni),c(e,js,i),m(gt,e,i),c(e,Is,i),c(e,ye,i),t(ye,ve),t(ve,wl),m(vt,wl,null),t(ye,ri),t(ye,Tl),t(Tl,ii),c(e,Es,i),c(e,Ct,i),t(Ct,Zt),t(Zt,ci),t(Ct,pi),c(e,_s,i),m(kt,e,i),c(e,gs,i),c(e,q,i),t(q,Ji),t(q,Gt),t(Gt,bl),t(bl,di),t(q,hi),t(q,jl),t(jl,Ui),t(q,ui),t(q,Il),t(Il,mi),t(q,yi),c(e,vs,i),m(Wt,e,i),c(e,Cs,i),c(e,Me,i),t(Me,Ce),t(Ce,El),m(Nt,El,null),t(Me,Mi),t(Me,_l),t(_l,fi),c(e,Zs,i),c(e,Ze,i),t(Ze,wi),t(Ze,Ft),t(Ft,Ti),t(Ze,bi),c(e,ks,i),m(Rt,e,i),c(e,Gs,i),c(e,fe,i),t(fe,ke),t(ke,gl),m(Xt,gl,null),t(fe,ji),t(fe,vl),t(vl,Ii),c(e,Ws,i),c(e,na,i),t(na,Ei),c(e,Ns,i),c(e,Z,i),t(Z,_i),t(Z,ra),t(ra,gi),t(Z,vi),t(Z,ia),t(ia,Ci),t(Z,Zi),t(Z,Cl),t(Cl,ki),t(Z,Gi),t(Z,Zl),t(Zl,Wi),t(Z,Ni),t(Z,kl),t(kl,Fi),t(Z,Ri),c(e,Fs,i),m(At,e,i),c(e,Rs,i),c(e,le,i),t(le,Xi),t(le,Bt),t(Bt,Ai),t(le,Bi),t(le,Vt),t(Vt,Vi),t(le,Yi),c(e,Xs,i),m(Yt,e,i),c(e,As,i),c(e,ca,i),t(ca,$i),c(e,Bs,i),m($t,e,i),Vs=!0},p(e,[i]){const Qt={};i&2&&(Qt.$$scope={dirty:i,ctx:e}),H.$set(Qt);const Gl={};i&2&&(Gl.$$scope={dirty:i,ctx:e}),_e.$set(Gl)},i(e){Vs||(y(b.$$.fragment,e),y(H.$$.fragment,e),y(Se.$$.fragment,e),y(qe.$$.fragment,e),y(ze.$$.fragment,e),y(De.$$.fragment,e),y(xe.$$.fragment,e),y(Oe.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(at.$$.fragment,e),y(st.$$.fragment,e),y(it.$$.fragment,e),y(pt.$$.fragment,e),y(Jt.$$.fragment,e),y(dt.$$.fragment,e),y(Ut.$$.fragment,e),y(ut.$$.fragment,e),y(yt.$$.fragment,e),y(_e.$$.fragment,e),y(ft.$$.fragment,e),y(wt.$$.fragment,e),y(bt.$$.fragment,e),y(It.$$.fragment,e),y(gt.$$.fragment,e),y(vt.$$.fragment,e),y(kt.$$.fragment,e),y(Wt.$$.fragment,e),y(Nt.$$.fragment,e),y(Rt.$$.fragment,e),y(Xt.$$.fragment,e),y(At.$$.fragment,e),y(Yt.$$.fragment,e),y($t.$$.fragment,e),Vs=!0)},o(e){M(b.$$.fragment,e),M(H.$$.fragment,e),M(Se.$$.fragment,e),M(qe.$$.fragment,e),M(ze.$$.fragment,e),M(De.$$.fragment,e),M(xe.$$.fragment,e),M(Oe.$$.fragment,e),M(Ke.$$.fragment,e),M(et.$$.fragment,e),M(at.$$.fragment,e),M(st.$$.fragment,e),M(it.$$.fragment,e),M(pt.$$.fragment,e),M(Jt.$$.fragment,e),M(dt.$$.fragment,e),M(Ut.$$.fragment,e),M(ut.$$.fragment,e),M(yt.$$.fragment,e),M(_e.$$.fragment,e),M(ft.$$.fragment,e),M(wt.$$.fragment,e),M(bt.$$.fragment,e),M(It.$$.fragment,e),M(gt.$$.fragment,e),M(vt.$$.fragment,e),M(kt.$$.fragment,e),M(Wt.$$.fragment,e),M(Nt.$$.fragment,e),M(Rt.$$.fragment,e),M(Xt.$$.fragment,e),M(At.$$.fragment,e),M(Yt.$$.fragment,e),M($t.$$.fragment,e),Vs=!1},d(e){a(h),e&&a(V),e&&a(T),f(b),e&&a(g),e&&a(I),e&&a(Ve),f(H,e),e&&a(Ye),e&&a($),e&&a(Wl),e&&a(xt),e&&a(Nl),f(Se,e),e&&a(Fl),e&&a(de),f(qe),e&&a(Rl),e&&a(L),e&&a(Xl),f(ze,e),e&&a(Al),e&&a(Ht),e&&a(Bl),f(De,e),e&&a(Vl),e&&a(he),f(xe),e&&a(Yl),e&&a(P),e&&a($l),e&&a(C),e&&a(Ql),f(Oe,e),e&&a(Sl),e&&a(Ue),f(Ke),e&&a(ql),e&&a(Lt),e&&a(zl),f(et,e),e&&a(Dl),e&&a(Q),e&&a(xl),f(at,e),e&&a(Hl),e&&a(G),e&&a(Ll),f(st,e),e&&a(Pl),e&&a(Pt),e&&a(Ol),e&&a(O),e&&a(Kl),f(it,e),e&&a(es),e&&a(E),e&&a(ts),f(pt,e),e&&a(as),e&&a(K),e&&a(ls),f(Jt,e),e&&a(ss),e&&a(ue),f(dt),e&&a(os),e&&a(_),e&&a(ns),f(Ut,e),e&&a(rs),e&&a(Ie),e&&a(is),f(ut,e),e&&a(cs),e&&a(ee),e&&a(ps),e&&a(te),e&&a(Js),f(yt,e),e&&a(ds),e&&a(Ee),e&&a(hs),e&&a(W),e&&a(Us),f(_e,e),e&&a(us),f(ft,e),e&&a(ms),e&&a(S),e&&a(ys),f(wt,e),e&&a(Ms),e&&a(N),e&&a(fs),f(bt,e),e&&a(ws),e&&a(ge),e&&a(Ts),f(It,e),e&&a(bs),e&&a(F),e&&a(js),f(gt,e),e&&a(Is),e&&a(ye),f(vt),e&&a(Es),e&&a(Ct),e&&a(_s),f(kt,e),e&&a(gs),e&&a(q),e&&a(vs),f(Wt,e),e&&a(Cs),e&&a(Me),f(Nt),e&&a(Zs),e&&a(Ze),e&&a(ks),f(Rt,e),e&&a(Gs),e&&a(fe),f(Xt),e&&a(Ws),e&&a(na),e&&a(Ns),e&&a(Z),e&&a(Fs),f(At,e),e&&a(Rs),e&&a(le),e&&a(Xs),f(Yt,e),e&&a(As),e&&a(ca),e&&a(Bs),f($t,e)}}}const nJ={local:"int8-training-for-automatic-speech-recognition",sections:[{local:"setup",title:"Setup"},{local:"load-dataset-and-metric",title:"Load dataset and metric"},{local:"preprocess-dataset",title:"Preprocess dataset"},{local:"train",title:"Train"},{local:"evaluate",title:"Evaluate"},{local:"share-model",title:"Share model"},{local:"inference",title:"Inference"}],title:"int8 training for automatic speech recognition"};function rJ(qt){return aJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dJ extends Op{constructor(h){super();Kp(this,h,rJ,oJ,eJ,{})}}export{dJ as default,nJ as metadata};
