import{S as wn,i as Tn,s as jn,e as o,k as h,w as M,t as a,M as _n,c as r,d as l,m as d,a as i,x as u,h as n,b as c,G as t,g as p,y,q as m,o as f,B as J,v as Cn}from"../../chunks/vendor-hf-doc-builder.js";import{T as vn}from"../../chunks/Tip-hf-doc-builder.js";import{I as Be}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{C as j}from"../../chunks/CodeBlock-hf-doc-builder.js";import{D as In}from"../../chunks/DocNotebookDropdown-hf-doc-builder.js";function gn(Xl){let U,S,b,v,W;return{c(){U=o("p"),S=a("\u{1F4A1} Read "),b=o("a"),v=a("Prefix-Tuning: Optimizing Continuous Prompts for Generation"),W=a(" to learn more about prefix tuning."),this.h()},l(C){U=r(C,"P",{});var X=i(U);S=n(X,"\u{1F4A1} Read "),b=r(X,"A",{href:!0,rel:!0});var F=i(b);v=n(F,"Prefix-Tuning: Optimizing Continuous Prompts for Generation"),F.forEach(l),W=n(X," to learn more about prefix tuning."),X.forEach(l),this.h()},h(){c(b,"href","https://arxiv.org/abs/2101.00190"),c(b,"rel","nofollow")},m(C,X){p(C,U,X),t(U,S),t(U,b),t(b,v),t(U,W)},d(C){C&&l(U)}}}function kn(Xl){let U,S,b,v,W,C,X,F,kt,Rl,te,Zl,R,Xt,Oe,Rt,Zt,el,Et,Gt,El,z,Gl,I,Bt,se,ll,Vt,Wt,tl,xt,Qt,ae,$t,Nt,Bl,Ve,Yt,Vl,ne,Wl,x,q,sl,oe,At,al,St,xl,Z,Ft,nl,zt,qt,ol,Ht,Pt,Ql,re,$l,Q,H,rl,ie,Dt,il,Lt,Nl,E,Kt,pl,Ot,es,pe,cl,ls,ts,Yl,w,ss,ce,as,ns,he,os,rs,hl,is,ps,dl,cs,hs,de,ds,Ms,Al,Me,Sl,$,P,Ml,ue,us,ul,ys,Fl,G,ms,yl,fs,Js,ml,Us,bs,zl,ye,ql,B,ws,me,Ts,js,fl,_s,Cs,Hl,fe,Pl,_,vs,Je,Jl,Is,gs,Ul,ks,Xs,bl,Rs,Zs,wl,Es,Gs,Dl,Ue,Ll,N,D,Tl,be,Bs,jl,Vs,Kl,T,Ws,We,xs,Qs,_l,$s,Ns,we,Ys,As,xe,Ss,Fs,Qe,zs,qs,Ol,Te,et,$e,Hs,lt,je,tt,Ne,Ps,st,_e,at,Ye,Ds,nt,Ce,ot,Ae,Ls,rt,Y,L,Cl,ve,Ks,vl,Os,it,Se,ea,pt,Ie,ct,K,la,ge,ta,sa,ht,ke,dt,Fe,aa,Mt,A,O,Il,Xe,na,gl,oa,ut,ze,ra,yt,Re,mt,qe,ia,ft,Ze,Jt,ee,pa,kl,ca,ha,Ut,Ee,bt;return C=new Be({}),te=new In({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/seq2seq-prefix-tuning.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/pytorch/seq2seq-prefix-tuning.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/tensorflow/seq2seq-prefix-tuning.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/seq2seq-prefix-tuning.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/pytorch/seq2seq-prefix-tuning.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/tensorflow/seq2seq-prefix-tuning.ipynb"}]}}),z=new vn({props:{$$slots:{default:[gn]},$$scope:{ctx:Xl}}}),ne=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cw==",highlighted:"!pip install -q peft transformers datasets"}}),oe=new Be({}),re=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMkMlMjBkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBnZXRfbGluZWFyX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUyQyUyMGdldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QlMkMlMjBQcmVmaXhUdW5pbmdDb25maWclMkMlMjBUYXNrVHlwZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWZyb20lMjB0cWRtJTIwaW1wb3J0JTIwdHFkbSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTBBb3MuZW52aXJvbiU1QiUyMkNVREFfVklTSUJMRV9ERVZJQ0VTJTIyJTVEJTIwJTNEJTIwJTIyMyUyMiUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9uYW1lX29yX3BhdGglMjAlM0QlMjAlMjJ0NS1sYXJnZSUyMiUwQXRva2VuaXplcl9uYW1lX29yX3BhdGglMjAlM0QlMjAlMjJ0NS1sYXJnZSUyMiUwQSUwQXRleHRfY29sdW1uJTIwJTNEJTIwJTIyc2VudGVuY2UlMjIlMEFsYWJlbF9jb2x1bW4lMjAlM0QlMjAlMjJ0ZXh0X2xhYmVsJTIyJTBBbWF4X2xlbmd0aCUyMCUzRCUyMDEyOCUwQWxyJTIwJTNEJTIwMWUtMiUwQW51bV9lcG9jaHMlMjAlM0QlMjA1JTBBYmF0Y2hfc2l6ZSUyMCUzRCUyMDg=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM, default_data_collator, get_linear_schedule_with_warmup
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_config, get_peft_model, get_peft_model_state_dict, PrefixTuningConfig, TaskType
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>
os.environ[<span class="hljs-string">&quot;CUDA_VISIBLE_DEVICES&quot;</span>] = <span class="hljs-string">&quot;3&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_name_or_path = <span class="hljs-string">&quot;t5-large&quot;</span>
tokenizer_name_or_path = <span class="hljs-string">&quot;t5-large&quot;</span>

text_column = <span class="hljs-string">&quot;sentence&quot;</span>
label_column = <span class="hljs-string">&quot;text_label&quot;</span>
max_length = <span class="hljs-number">128</span>
lr = <span class="hljs-number">1e-2</span>
num_epochs = <span class="hljs-number">5</span>
batch_size = <span class="hljs-number">8</span>`}}),ie=new Be({}),Me=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmaW5hbmNpYWxfcGhyYXNlYmFuayUyMiUyQyUyMCUyMnNlbnRlbmNlc19hbGxhZ3JlZSUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC4xKSUwQWRhdGFzZXQlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEFkZWwlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUwQSUwQWNsYXNzZXMlMjAlM0QlMjBkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXMlNUIlMjJsYWJlbCUyMiU1RC5uYW1lcyUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwJTdCJTIydGV4dF9sYWJlbCUyMiUzQSUyMCU1QmNsYXNzZXMlNUJsYWJlbCU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjB4JTVCJTIybGFiZWwlMjIlNUQlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSklMEElMEFkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTBBJTdCJTIyc2VudGVuY2UlMjIlM0ElMjAlMjJQcm9maXQlMjBiZWZvcmUlMjB0YXhlcyUyMHdhcyUyMEVVUiUyMDQuMCUyMG1uJTIwJTJDJTIwZG93biUyMGZyb20lMjBFVVIlMjA0LjklMjBtbiUyMC4lMjIlMkMlMjAlMjJsYWJlbCUyMiUzQSUyMDAlMkMlMjAlMjJ0ZXh0X2xhYmVsJTIyJTNBJTIwJTIybmVnYXRpdmUlMjIlN0Q=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;financial_phrasebank&quot;</span>, <span class="hljs-string">&quot;sentences_allagree&quot;</span>)
dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>)
dataset[<span class="hljs-string">&quot;validation&quot;</span>] = dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-keyword">del</span> dataset[<span class="hljs-string">&quot;test&quot;</span>]

classes = dataset[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)

dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;sentence&quot;</span>: <span class="hljs-string">&quot;Profit before taxes was EUR 4.0 mn , down from EUR 4.9 mn .&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;text_label&quot;</span>: <span class="hljs-string">&quot;negative&quot;</span>}`}}),ue=new Be({}),ye=new j({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZV9vcl9wYXRoKSUwQSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwZXhhbXBsZXMlNUJ0ZXh0X2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjBleGFtcGxlcyU1QmxhYmVsX2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihpbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEbWF4X2xlbmd0aCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0YXJnZXRzJTJDJTIwbWF4X2xlbmd0aCUzRDIlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjBsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbHMlNUJsYWJlbHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1vZGVsX2lucHV0cw==",highlighted:`tokenizer = AutoTokenizer.from_pretrained(model_name_or_path)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    inputs = examples[text_column]
    targets = examples[label_column]
    model_inputs = tokenizer(inputs, max_length=max_length, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = tokenizer(targets, max_length=<span class="hljs-number">2</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    labels[labels == tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> model_inputs`}}),fe=new j({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19mdW5jdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoZWQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Byb2MlM0QxJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX2NvbHVtbnMlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuY29sdW1uX25hbWVzJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9mcm9tX2NhY2hlX2ZpbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2MlM0QlMjJSdW5uaW5nJTIwdG9rZW5pemVyJTIwb24lMjBkYXRhc2V0JTIyJTJDJTBBKQ==",highlighted:`processed_datasets = dataset.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=dataset[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`}}),Ue=new j({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMHByb2Nlc3NlZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBZXZhbF9kYXRhc2V0JTIwJTNEJTIwcHJvY2Vzc2VkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUwQSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlJTBBKSUwQWV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZXZhbF9kYXRhc2V0JTJDJTIwY29sbGF0ZV9mbiUzRGRlZmF1bHRfZGF0YV9jb2xsYXRvciUyQyUyMGJhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTIwcGluX21lbW9yeSUzRFRydWUp",highlighted:`train_dataset = processed_datasets[<span class="hljs-string">&quot;train&quot;</span>]
eval_dataset = processed_datasets[<span class="hljs-string">&quot;validation&quot;</span>]

train_dataloader = DataLoader(
    train_dataset, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>
)
eval_dataloader = DataLoader(eval_dataset, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`}}),be=new Be({}),Te=new j({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBQcmVmaXhUdW5pbmdDb25maWcodGFza190eXBlJTNEVGFza1R5cGUuU0VRXzJfU0VRX0xNJTJDJTIwaW5mZXJlbmNlX21vZGUlM0RGYWxzZSUyQyUyMG51bV92aXJ0dWFsX3Rva2VucyUzRDIwKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lX29yX3BhdGgpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA5ODMwNDAlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA3Mzg2NTExMzYlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzA4NTgzMDY1NjU5ODM1JTIy",highlighted:`peft_config = PrefixTuningConfig(task_type=TaskType.SEQ_2_SEQ_LM, inference_mode=<span class="hljs-literal">False</span>, num_virtual_tokens=<span class="hljs-number">20</span>)

model = AutoModelForSeq2SeqLM.from_pretrained(model_name_or_path)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 983040 || all params: 738651136 || trainable%: 0.13308583065659835&quot;</span>`}}),je=new j({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0RsciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfbGluZWFyX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBudW1fZXBvY2hzKSUyQyUwQSk=",highlighted:`optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`}}),_e=new j({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC50byhkZXZpY2UpJTBBJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwudHJhaW4oKSUwQSUyMCUyMCUyMCUyMHRvdGFsX2xvc3MlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RlcCUyQyUyMGJhdGNoJTIwaW4lMjBlbnVtZXJhdGUodHFkbSh0cmFpbl9kYXRhbG9hZGVyKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3RhbF9sb3NzJTIwJTJCJTNEJTIwbG9zcy5kZXRhY2goKS5mbG9hdCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMEElMjAlMjAlMjAlMjBtb2RlbC5ldmFsKCklMEElMjAlMjAlMjAlMjBldmFsX2xvc3MlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwZXZhbF9wcmVkcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHN0ZXAlMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRxZG0oZXZhbF9kYXRhbG9hZGVyKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9sb3NzJTIwJTJCJTNEJTIwbG9zcy5kZXRhY2goKS5mbG9hdCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9wcmVkcy5leHRlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZSh0b3JjaC5hcmdtYXgob3V0cHV0cy5sb2dpdHMlMkMlMjAtMSkuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBldmFsX2Vwb2NoX2xvc3MlMjAlM0QlMjBldmFsX2xvc3MlMjAlMkYlMjBsZW4oZXZhbF9kYXRhbG9hZGVyKSUwQSUyMCUyMCUyMCUyMGV2YWxfcHBsJTIwJTNEJTIwdG9yY2guZXhwKGV2YWxfZXBvY2hfbG9zcyklMEElMjAlMjAlMjAlMjB0cmFpbl9lcG9jaF9sb3NzJTIwJTNEJTIwdG90YWxfbG9zcyUyMCUyRiUyMGxlbih0cmFpbl9kYXRhbG9hZGVyKSUwQSUyMCUyMCUyMCUyMHRyYWluX3BwbCUyMCUzRCUyMHRvcmNoLmV4cCh0cmFpbl9lcG9jaF9sb3NzKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JlcG9jaCUzRCU3RCUzQSUyMCU3QnRyYWluX3BwbCUzRCU3RCUyMCU3QnRyYWluX2Vwb2NoX2xvc3MlM0QlN0QlMjAlN0JldmFsX3BwbCUzRCU3RCUyMCU3QmV2YWxfZXBvY2hfbG9zcyUzRCU3RCUyMik=",highlighted:`model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`}}),Ce=new j({props:{code:"Y29ycmVjdCUyMCUzRCUyMDAlMEF0b3RhbCUyMCUzRCUyMDAlMEFmb3IlMjBwcmVkJTJDJTIwdHJ1ZSUyMGluJTIwemlwKGV2YWxfcHJlZHMlMkMlMjBkYXRhc2V0JTVCJTIydmFsaWRhdGlvbiUyMiU1RCU1QiUyMnRleHRfbGFiZWwlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwcmVkLnN0cmlwKCklMjAlM0QlM0QlMjB0cnVlLnN0cmlwKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb3JyZWN0JTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMHRvdGFsJTIwJTJCJTNEJTIwMSUwQWFjY3VyYWN5JTIwJTNEJTIwY29ycmVjdCUyMCUyRiUyMHRvdGFsJTIwKiUyMDEwMCUwQXByaW50KGYlMjIlN0JhY2N1cmFjeSUzRCU3RCUyMCUyNSUyMG9uJTIwdGhlJTIwZXZhbHVhdGlvbiUyMGRhdGFzZXQlMjIpJTBBcHJpbnQoZiUyMiU3QmV2YWxfcHJlZHMlNUIlM0ExMCU1RCUzRCU3RCUyMiklMEFwcmludChmJTIyJTdCZGF0YXNldCU1Qid2YWxpZGF0aW9uJyU1RCU1Qid0ZXh0X2xhYmVsJyU1RCU1QiUzQTEwJTVEJTNEJTdEJTIyKSUwQSUyMmFjY3VyYWN5JTNEOTcuMzU2ODI4MTkzODMyNiUyMCUyNSUyMG9uJTIwdGhlJTIwZXZhbHVhdGlvbiUyMGRhdGFzZXQlMjIlMEElMjJldmFsX3ByZWRzJTVCJTNBMTAlNUQlM0QlNUInbmV1dHJhbCclMkMlMjAncG9zaXRpdmUnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ3Bvc2l0aXZlJyUyQyUyMCduZXV0cmFsJyUyQyUyMCduZWdhdGl2ZSclMkMlMjAnbmVnYXRpdmUnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ25ldXRyYWwnJTVEJTIyJTBBJTIyZGF0YXNldCU1Qid2YWxpZGF0aW9uJyU1RCU1Qid0ZXh0X2xhYmVsJyU1RCU1QiUzQTEwJTVEJTNEJTVCJ25ldXRyYWwnJTJDJTIwJ3Bvc2l0aXZlJyUyQyUyMCduZXV0cmFsJyUyQyUyMCdwb3NpdGl2ZSclMkMlMjAnbmV1dHJhbCclMkMlMjAnbmVnYXRpdmUnJTJDJTIwJ25lZ2F0aXZlJyUyQyUyMCduZXV0cmFsJyUyQyUyMCduZXV0cmFsJyUyQyUyMCduZXV0cmFsJyU1RCUyMg==",highlighted:`correct = <span class="hljs-number">0</span>
total = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> pred, true <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(eval_preds, dataset[<span class="hljs-string">&quot;validation&quot;</span>][<span class="hljs-string">&quot;text_label&quot;</span>]):
    <span class="hljs-keyword">if</span> pred.strip() == true.strip():
        correct += <span class="hljs-number">1</span>
    total += <span class="hljs-number">1</span>
accuracy = correct / total * <span class="hljs-number">100</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{accuracy=}</span> % on the evaluation dataset&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{eval_preds[:<span class="hljs-number">10</span>]=}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{dataset[<span class="hljs-string">&#x27;validation&#x27;</span>][<span class="hljs-string">&#x27;text_label&#x27;</span>][:<span class="hljs-number">10</span>]=}</span>&quot;</span>)
<span class="hljs-string">&quot;accuracy=97.3568281938326 % on the evaluation dataset&quot;</span>
<span class="hljs-string">&quot;eval_preds[:10]=[&#x27;neutral&#x27;, &#x27;positive&#x27;, &#x27;neutral&#x27;, &#x27;positive&#x27;, &#x27;neutral&#x27;, &#x27;negative&#x27;, &#x27;negative&#x27;, &#x27;neutral&#x27;, &#x27;neutral&#x27;, &#x27;neutral&#x27;]&quot;</span>
<span class="hljs-string">&quot;dataset[&#x27;validation&#x27;][&#x27;text_label&#x27;][:10]=[&#x27;neutral&#x27;, &#x27;positive&#x27;, &#x27;neutral&#x27;, &#x27;positive&#x27;, &#x27;neutral&#x27;, &#x27;negative&#x27;, &#x27;negative&#x27;, &#x27;neutral&#x27;, &#x27;neutral&#x27;, &#x27;neutral&#x27;]&quot;</span>`}}),ve=new Be({}),Ie=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),ke=new j({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnlvdXItbmFtZSUyRnQ1LWxhcmdlX1BSRUZJWF9UVU5JTkdfU0VRMlNFUSUyMiUwQW1vZGVsLnB1c2hfdG9faHViKCUyMnlvdXItbmFtZSUyRnQ1LWxhcmdlX1BSRUZJWF9UVU5JTkdfU0VRMlNFUSUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSk=",highlighted:`peft_model_id = <span class="hljs-string">&quot;your-name/t5-large_PREFIX_TUNING_SEQ2SEQ&quot;</span>
model.push_to_hub(<span class="hljs-string">&quot;your-name/t5-large_PREFIX_TUNING_SEQ2SEQ&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`}}),Xe=new Be({}),Re=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnN0ZXZobGl1JTJGdDUtbGFyZ2VfUFJFRklYX1RVTklOR19TRVEyU0VRJTIyJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoY29uZmlnLmJhc2VfbW9kZWxfbmFtZV9vcl9wYXRoKSUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

peft_model_id = <span class="hljs-string">&quot;stevhliu/t5-large_PREFIX_TUNING_SEQ2SEQ&quot;</span>

config = PeftConfig.from_pretrained(peft_model_id)
model = AutoModelForSeq2SeqLM.from_pretrained(config.base_model_name_or_path)
model = PeftModel.from_pretrained(model, peft_model_id)`}}),Ze=new j({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMlRoZSUyMExpdGh1YW5pYW4lMjBiZWVyJTIwbWFya2V0JTIwbWFkZSUyMHVwJTIwMTQuNDElMjBtaWxsaW9uJTIwbGl0ZXJzJTIwaW4lMjBKYW51YXJ5JTIwJTJDJTIwYSUyMHJpc2UlMjBvZiUyMDAuOCUyMHBlcmNlbnQlMjBmcm9tJTIwdGhlJTIweWVhci1lYXJsaWVyJTIwZmlndXJlJTIwJTJDJTIwdGhlJTIwTGl0aHVhbmlhbiUyMEJyZXdlcnMlMjAnJTIwQXNzb2NpYXRpb24lMjByZXBvcnRpbmclMjBjaXRpbmclMjB0aGUlMjByZXN1bHRzJTIwZnJvbSUyMGl0cyUyMG1lbWJlcnMlMjAuJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSk=",highlighted:`inputs = tokenizer(
    <span class="hljs-string">&quot;The Lithuanian beer market made up 14.41 million liters in January , a rise of 0.8 percent from the year-earlier figure , the Lithuanian Brewers &#x27; Association reporting citing the results from its members .&quot;</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)`}}),Ee=new j({props:{code:"bW9kZWwudG8oZGV2aWNlKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGlucHV0cy5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJTIycG9zaXRpdmUlMjIlNUQ=",highlighted:`model.to(device)

<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;positive&quot;</span>]`}}),{c(){U=o("meta"),S=h(),b=o("h1"),v=o("a"),W=o("span"),M(C.$$.fragment),X=h(),F=o("span"),kt=a("Prefix tuning for conditional generation"),Rl=h(),M(te.$$.fragment),Zl=h(),R=o("p"),Xt=a("Prefix tuning is an additive method where only a sequence of continuous task-specific vectors is attached to the beginning of the input, or "),Oe=o("em"),Rt=a("prefix"),Zt=a(". Only the prefix parameters are optimized and added to the hidden states in every layer of the model. The tokens of the input sequence can still attend to the prefix as "),el=o("em"),Et=a("virtual tokens"),Gt=a(". As a result, prefix tuning stores 1000x fewer parameters than a fully finetuned model, which means you can use one large language model for many tasks."),El=h(),M(z.$$.fragment),Gl=h(),I=o("p"),Bt=a("This guide will show you how to apply prefix tuning to train a "),se=o("a"),ll=o("code"),Vt=a("t5-large"),Wt=a(" model on the "),tl=o("code"),xt=a("sentences_allagree"),Qt=a(" subset of the "),ae=o("a"),$t=a("financial_phrasebank"),Nt=a(" dataset."),Bl=h(),Ve=o("p"),Yt=a("Before you begin, make sure you have all the necessary libraries installed:"),Vl=h(),M(ne.$$.fragment),Wl=h(),x=o("h2"),q=o("a"),sl=o("span"),M(oe.$$.fragment),At=h(),al=o("span"),St=a("Setup"),xl=h(),Z=o("p"),Ft=a("Start by defining the model and tokenizer, text and label columns, and some hyperparameters so it\u2019ll be easier to start training faster later. Set the environment variable "),nl=o("code"),zt=a("TOKENIZERS_PARALLELSIM"),qt=a(" to "),ol=o("code"),Ht=a("false"),Pt=a(" to disable the fast Rust-based tokenizer which processes data in parallel by default so you can use multiprocessing in Python."),Ql=h(),M(re.$$.fragment),$l=h(),Q=o("h2"),H=o("a"),rl=o("span"),M(ie.$$.fragment),Dt=h(),il=o("span"),Lt=a("Load dataset"),Nl=h(),E=o("p"),Kt=a("For this guide, you\u2019ll train on the "),pl=o("code"),Ot=a("sentences_allagree"),es=a(" subset of the "),pe=o("a"),cl=o("code"),ls=a("financial_phrasebank"),ts=a(" dataset. This dataset contains financial news categorized by sentiment."),Yl=h(),w=o("p"),ss=a("Use \u{1F917} "),ce=o("a"),as=a("Datasets"),ns=h(),he=o("a"),os=a("train_test_split"),rs=a(" function to create a training and validation split and convert the "),hl=o("code"),is=a("label"),ps=a(" value to the more readable "),dl=o("code"),cs=a("text_label"),hs=a(". All of the changes can be applied with the "),de=o("a"),ds=a("map"),Ms=a(" function:"),Al=h(),M(Me.$$.fragment),Sl=h(),$=o("h2"),P=o("a"),Ml=o("span"),M(ue.$$.fragment),us=h(),ul=o("span"),ys=a("Preprocess dataset"),Fl=h(),G=o("p"),ms=a("Initialize a tokenizer, and create a function to pad and truncate the "),yl=o("code"),fs=a("model_inputs"),Js=a(" and "),ml=o("code"),Us=a("labels"),bs=a(":"),zl=h(),M(ye.$$.fragment),ql=h(),B=o("p"),ws=a("Use the "),me=o("a"),Ts=a("map"),js=a(" function to apply the "),fl=o("code"),_s=a("preprocess_function"),Cs=a(" to the dataset. You can remove the unprocessed columns since the model doesn\u2019t need them anymore:"),Hl=h(),M(fe.$$.fragment),Pl=h(),_=o("p"),vs=a("Create a "),Je=o("a"),Jl=o("code"),Is=a("DataLoader"),gs=a(" from the "),Ul=o("code"),ks=a("train"),Xs=a(" and "),bl=o("code"),Rs=a("eval"),Zs=a(" datasets. Set "),wl=o("code"),Es=a("pin_memory=True"),Gs=a(" to speed up the data transfer to the GPU during training if the samples in your dataset are on a CPU."),Dl=h(),M(Ue.$$.fragment),Ll=h(),N=o("h2"),D=o("a"),Tl=o("span"),M(be.$$.fragment),Bs=h(),jl=o("span"),Vs=a("Train model"),Kl=h(),T=o("p"),Ws=a("Now you can setup your model and make sure it is ready for training. Specify the task in "),We=o("a"),xs=a("PrefixTuningConfig"),Qs=a(", create the base "),_l=o("code"),$s=a("t5-large"),Ns=a(" model from "),we=o("a"),Ys=a("AutoModelForSeq2SeqLM"),As=a(", and then wrap the model and configuration in a "),xe=o("a"),Ss=a("PeftModel"),Fs=a(". Feel free to print the "),Qe=o("a"),zs=a("PeftModel"),qs=a("\u2019s parameters and compare it to fully training all the model parameters to see how much more efficient it is!"),Ol=h(),M(Te.$$.fragment),et=h(),$e=o("p"),Hs=a("Setup the optimizer and learning rate scheduler:"),lt=h(),M(je.$$.fragment),tt=h(),Ne=o("p"),Ps=a("Move the model to the GPU, and then write a training loop to begin!"),st=h(),M(_e.$$.fragment),at=h(),Ye=o("p"),Ds=a("Let\u2019s see how well the model performs on the validation set:"),nt=h(),M(Ce.$$.fragment),ot=h(),Ae=o("p"),Ls=a("97% accuracy in just a few minutes; pretty good!"),rt=h(),Y=o("h2"),L=o("a"),Cl=o("span"),M(ve.$$.fragment),Ks=h(),vl=o("span"),Os=a("Share model"),it=h(),Se=o("p"),ea=a("You can store and share your model on the Hub if you\u2019d like. Login to your Hugging Face account and enter your token when prompted:"),pt=h(),M(Ie.$$.fragment),ct=h(),K=o("p"),la=a("Upload the model to a specifc model repository on the Hub with the "),ge=o("a"),ta=a("push_to_hub"),sa=a(" function:"),ht=h(),M(ke.$$.fragment),dt=h(),Fe=o("p"),aa=a("If you check the model file size in the repository, you\u2019ll see that it is only 3.93MB! \u{1F90F}"),Mt=h(),A=o("h2"),O=o("a"),Il=o("span"),M(Xe.$$.fragment),na=h(),gl=o("span"),oa=a("Inference"),ut=h(),ze=o("p"),ra=a("Once the model has been uploaded to the Hub, anyone can easily use it for inference. Load the configuration and model:"),yt=h(),M(Re.$$.fragment),mt=h(),qe=o("p"),ia=a("Get and tokenize some text about financial news:"),ft=h(),M(Ze.$$.fragment),Jt=h(),ee=o("p"),pa=a("Put the model on a GPU and "),kl=o("em"),ca=a("generate"),ha=a(" the predicted text sentiment:"),Ut=h(),M(Ee.$$.fragment),this.h()},l(e){const s=_n('[data-svelte="svelte-1phssyn"]',document.head);U=r(s,"META",{name:!0,content:!0}),s.forEach(l),S=d(e),b=r(e,"H1",{class:!0});var Ge=i(b);v=r(Ge,"A",{id:!0,class:!0,href:!0});var da=i(v);W=r(da,"SPAN",{});var Ma=i(W);u(C.$$.fragment,Ma),Ma.forEach(l),da.forEach(l),X=d(Ge),F=r(Ge,"SPAN",{});var ua=i(F);kt=n(ua,"Prefix tuning for conditional generation"),ua.forEach(l),Ge.forEach(l),Rl=d(e),u(te.$$.fragment,e),Zl=d(e),R=r(e,"P",{});var He=i(R);Xt=n(He,"Prefix tuning is an additive method where only a sequence of continuous task-specific vectors is attached to the beginning of the input, or "),Oe=r(He,"EM",{});var ya=i(Oe);Rt=n(ya,"prefix"),ya.forEach(l),Zt=n(He,". Only the prefix parameters are optimized and added to the hidden states in every layer of the model. The tokens of the input sequence can still attend to the prefix as "),el=r(He,"EM",{});var ma=i(el);Et=n(ma,"virtual tokens"),ma.forEach(l),Gt=n(He,". As a result, prefix tuning stores 1000x fewer parameters than a fully finetuned model, which means you can use one large language model for many tasks."),He.forEach(l),El=d(e),u(z.$$.fragment,e),Gl=d(e),I=r(e,"P",{});var le=i(I);Bt=n(le,"This guide will show you how to apply prefix tuning to train a "),se=r(le,"A",{href:!0,rel:!0});var fa=i(se);ll=r(fa,"CODE",{});var Ja=i(ll);Vt=n(Ja,"t5-large"),Ja.forEach(l),fa.forEach(l),Wt=n(le," model on the "),tl=r(le,"CODE",{});var Ua=i(tl);xt=n(Ua,"sentences_allagree"),Ua.forEach(l),Qt=n(le," subset of the "),ae=r(le,"A",{href:!0,rel:!0});var ba=i(ae);$t=n(ba,"financial_phrasebank"),ba.forEach(l),Nt=n(le," dataset."),le.forEach(l),Bl=d(e),Ve=r(e,"P",{});var wa=i(Ve);Yt=n(wa,"Before you begin, make sure you have all the necessary libraries installed:"),wa.forEach(l),Vl=d(e),u(ne.$$.fragment,e),Wl=d(e),x=r(e,"H2",{class:!0});var wt=i(x);q=r(wt,"A",{id:!0,class:!0,href:!0});var Ta=i(q);sl=r(Ta,"SPAN",{});var ja=i(sl);u(oe.$$.fragment,ja),ja.forEach(l),Ta.forEach(l),At=d(wt),al=r(wt,"SPAN",{});var _a=i(al);St=n(_a,"Setup"),_a.forEach(l),wt.forEach(l),xl=d(e),Z=r(e,"P",{});var Pe=i(Z);Ft=n(Pe,"Start by defining the model and tokenizer, text and label columns, and some hyperparameters so it\u2019ll be easier to start training faster later. Set the environment variable "),nl=r(Pe,"CODE",{});var Ca=i(nl);zt=n(Ca,"TOKENIZERS_PARALLELSIM"),Ca.forEach(l),qt=n(Pe," to "),ol=r(Pe,"CODE",{});var va=i(ol);Ht=n(va,"false"),va.forEach(l),Pt=n(Pe," to disable the fast Rust-based tokenizer which processes data in parallel by default so you can use multiprocessing in Python."),Pe.forEach(l),Ql=d(e),u(re.$$.fragment,e),$l=d(e),Q=r(e,"H2",{class:!0});var Tt=i(Q);H=r(Tt,"A",{id:!0,class:!0,href:!0});var Ia=i(H);rl=r(Ia,"SPAN",{});var ga=i(rl);u(ie.$$.fragment,ga),ga.forEach(l),Ia.forEach(l),Dt=d(Tt),il=r(Tt,"SPAN",{});var ka=i(il);Lt=n(ka,"Load dataset"),ka.forEach(l),Tt.forEach(l),Nl=d(e),E=r(e,"P",{});var De=i(E);Kt=n(De,"For this guide, you\u2019ll train on the "),pl=r(De,"CODE",{});var Xa=i(pl);Ot=n(Xa,"sentences_allagree"),Xa.forEach(l),es=n(De," subset of the "),pe=r(De,"A",{href:!0,rel:!0});var Ra=i(pe);cl=r(Ra,"CODE",{});var Za=i(cl);ls=n(Za,"financial_phrasebank"),Za.forEach(l),Ra.forEach(l),ts=n(De," dataset. This dataset contains financial news categorized by sentiment."),De.forEach(l),Yl=d(e),w=r(e,"P",{});var g=i(w);ss=n(g,"Use \u{1F917} "),ce=r(g,"A",{href:!0,rel:!0});var Ea=i(ce);as=n(Ea,"Datasets"),Ea.forEach(l),ns=d(g),he=r(g,"A",{href:!0,rel:!0});var Ga=i(he);os=n(Ga,"train_test_split"),Ga.forEach(l),rs=n(g," function to create a training and validation split and convert the "),hl=r(g,"CODE",{});var Ba=i(hl);is=n(Ba,"label"),Ba.forEach(l),ps=n(g," value to the more readable "),dl=r(g,"CODE",{});var Va=i(dl);cs=n(Va,"text_label"),Va.forEach(l),hs=n(g,". All of the changes can be applied with the "),de=r(g,"A",{href:!0,rel:!0});var Wa=i(de);ds=n(Wa,"map"),Wa.forEach(l),Ms=n(g," function:"),g.forEach(l),Al=d(e),u(Me.$$.fragment,e),Sl=d(e),$=r(e,"H2",{class:!0});var jt=i($);P=r(jt,"A",{id:!0,class:!0,href:!0});var xa=i(P);Ml=r(xa,"SPAN",{});var Qa=i(Ml);u(ue.$$.fragment,Qa),Qa.forEach(l),xa.forEach(l),us=d(jt),ul=r(jt,"SPAN",{});var $a=i(ul);ys=n($a,"Preprocess dataset"),$a.forEach(l),jt.forEach(l),Fl=d(e),G=r(e,"P",{});var Le=i(G);ms=n(Le,"Initialize a tokenizer, and create a function to pad and truncate the "),yl=r(Le,"CODE",{});var Na=i(yl);fs=n(Na,"model_inputs"),Na.forEach(l),Js=n(Le," and "),ml=r(Le,"CODE",{});var Ya=i(ml);Us=n(Ya,"labels"),Ya.forEach(l),bs=n(Le,":"),Le.forEach(l),zl=d(e),u(ye.$$.fragment,e),ql=d(e),B=r(e,"P",{});var Ke=i(B);ws=n(Ke,"Use the "),me=r(Ke,"A",{href:!0,rel:!0});var Aa=i(me);Ts=n(Aa,"map"),Aa.forEach(l),js=n(Ke," function to apply the "),fl=r(Ke,"CODE",{});var Sa=i(fl);_s=n(Sa,"preprocess_function"),Sa.forEach(l),Cs=n(Ke," to the dataset. You can remove the unprocessed columns since the model doesn\u2019t need them anymore:"),Ke.forEach(l),Hl=d(e),u(fe.$$.fragment,e),Pl=d(e),_=r(e,"P",{});var V=i(_);vs=n(V,"Create a "),Je=r(V,"A",{href:!0,rel:!0});var Fa=i(Je);Jl=r(Fa,"CODE",{});var za=i(Jl);Is=n(za,"DataLoader"),za.forEach(l),Fa.forEach(l),gs=n(V," from the "),Ul=r(V,"CODE",{});var qa=i(Ul);ks=n(qa,"train"),qa.forEach(l),Xs=n(V," and "),bl=r(V,"CODE",{});var Ha=i(bl);Rs=n(Ha,"eval"),Ha.forEach(l),Zs=n(V," datasets. Set "),wl=r(V,"CODE",{});var Pa=i(wl);Es=n(Pa,"pin_memory=True"),Pa.forEach(l),Gs=n(V," to speed up the data transfer to the GPU during training if the samples in your dataset are on a CPU."),V.forEach(l),Dl=d(e),u(Ue.$$.fragment,e),Ll=d(e),N=r(e,"H2",{class:!0});var _t=i(N);D=r(_t,"A",{id:!0,class:!0,href:!0});var Da=i(D);Tl=r(Da,"SPAN",{});var La=i(Tl);u(be.$$.fragment,La),La.forEach(l),Da.forEach(l),Bs=d(_t),jl=r(_t,"SPAN",{});var Ka=i(jl);Vs=n(Ka,"Train model"),Ka.forEach(l),_t.forEach(l),Kl=d(e),T=r(e,"P",{});var k=i(T);Ws=n(k,"Now you can setup your model and make sure it is ready for training. Specify the task in "),We=r(k,"A",{href:!0});var Oa=i(We);xs=n(Oa,"PrefixTuningConfig"),Oa.forEach(l),Qs=n(k,", create the base "),_l=r(k,"CODE",{});var en=i(_l);$s=n(en,"t5-large"),en.forEach(l),Ns=n(k," model from "),we=r(k,"A",{href:!0,rel:!0});var ln=i(we);Ys=n(ln,"AutoModelForSeq2SeqLM"),ln.forEach(l),As=n(k,", and then wrap the model and configuration in a "),xe=r(k,"A",{href:!0});var tn=i(xe);Ss=n(tn,"PeftModel"),tn.forEach(l),Fs=n(k,". Feel free to print the "),Qe=r(k,"A",{href:!0});var sn=i(Qe);zs=n(sn,"PeftModel"),sn.forEach(l),qs=n(k,"\u2019s parameters and compare it to fully training all the model parameters to see how much more efficient it is!"),k.forEach(l),Ol=d(e),u(Te.$$.fragment,e),et=d(e),$e=r(e,"P",{});var an=i($e);Hs=n(an,"Setup the optimizer and learning rate scheduler:"),an.forEach(l),lt=d(e),u(je.$$.fragment,e),tt=d(e),Ne=r(e,"P",{});var nn=i(Ne);Ps=n(nn,"Move the model to the GPU, and then write a training loop to begin!"),nn.forEach(l),st=d(e),u(_e.$$.fragment,e),at=d(e),Ye=r(e,"P",{});var on=i(Ye);Ds=n(on,"Let\u2019s see how well the model performs on the validation set:"),on.forEach(l),nt=d(e),u(Ce.$$.fragment,e),ot=d(e),Ae=r(e,"P",{});var rn=i(Ae);Ls=n(rn,"97% accuracy in just a few minutes; pretty good!"),rn.forEach(l),rt=d(e),Y=r(e,"H2",{class:!0});var Ct=i(Y);L=r(Ct,"A",{id:!0,class:!0,href:!0});var pn=i(L);Cl=r(pn,"SPAN",{});var cn=i(Cl);u(ve.$$.fragment,cn),cn.forEach(l),pn.forEach(l),Ks=d(Ct),vl=r(Ct,"SPAN",{});var hn=i(vl);Os=n(hn,"Share model"),hn.forEach(l),Ct.forEach(l),it=d(e),Se=r(e,"P",{});var dn=i(Se);ea=n(dn,"You can store and share your model on the Hub if you\u2019d like. Login to your Hugging Face account and enter your token when prompted:"),dn.forEach(l),pt=d(e),u(Ie.$$.fragment,e),ct=d(e),K=r(e,"P",{});var vt=i(K);la=n(vt,"Upload the model to a specifc model repository on the Hub with the "),ge=r(vt,"A",{href:!0,rel:!0});var Mn=i(ge);ta=n(Mn,"push_to_hub"),Mn.forEach(l),sa=n(vt," function:"),vt.forEach(l),ht=d(e),u(ke.$$.fragment,e),dt=d(e),Fe=r(e,"P",{});var un=i(Fe);aa=n(un,"If you check the model file size in the repository, you\u2019ll see that it is only 3.93MB! \u{1F90F}"),un.forEach(l),Mt=d(e),A=r(e,"H2",{class:!0});var It=i(A);O=r(It,"A",{id:!0,class:!0,href:!0});var yn=i(O);Il=r(yn,"SPAN",{});var mn=i(Il);u(Xe.$$.fragment,mn),mn.forEach(l),yn.forEach(l),na=d(It),gl=r(It,"SPAN",{});var fn=i(gl);oa=n(fn,"Inference"),fn.forEach(l),It.forEach(l),ut=d(e),ze=r(e,"P",{});var Jn=i(ze);ra=n(Jn,"Once the model has been uploaded to the Hub, anyone can easily use it for inference. Load the configuration and model:"),Jn.forEach(l),yt=d(e),u(Re.$$.fragment,e),mt=d(e),qe=r(e,"P",{});var Un=i(qe);ia=n(Un,"Get and tokenize some text about financial news:"),Un.forEach(l),ft=d(e),u(Ze.$$.fragment,e),Jt=d(e),ee=r(e,"P",{});var gt=i(ee);pa=n(gt,"Put the model on a GPU and "),kl=r(gt,"EM",{});var bn=i(kl);ca=n(bn,"generate"),bn.forEach(l),ha=n(gt," the predicted text sentiment:"),gt.forEach(l),Ut=d(e),u(Ee.$$.fragment,e),this.h()},h(){c(U,"name","hf:doc:metadata"),c(U,"content",JSON.stringify(Xn)),c(v,"id","prefix-tuning-for-conditional-generation"),c(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(v,"href","#prefix-tuning-for-conditional-generation"),c(b,"class","relative group"),c(se,"href","https://huggingface.co/t5-large"),c(se,"rel","nofollow"),c(ae,"href","https://huggingface.co/datasets/financial_phrasebank"),c(ae,"rel","nofollow"),c(q,"id","setup"),c(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(q,"href","#setup"),c(x,"class","relative group"),c(H,"id","load-dataset"),c(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(H,"href","#load-dataset"),c(Q,"class","relative group"),c(pe,"href","https://huggingface.co/datasets/financial_phrasebank"),c(pe,"rel","nofollow"),c(ce,"href","https://huggingface.co/docs/datasets/index"),c(ce,"rel","nofollow"),c(he,"href","https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.train_test_split"),c(he,"rel","nofollow"),c(de,"href","https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map"),c(de,"rel","nofollow"),c(P,"id","preprocess-dataset"),c(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(P,"href","#preprocess-dataset"),c($,"class","relative group"),c(me,"href","https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map"),c(me,"rel","nofollow"),c(Je,"href","https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader"),c(Je,"rel","nofollow"),c(D,"id","train-model"),c(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(D,"href","#train-model"),c(N,"class","relative group"),c(We,"href","/docs/peft/main/en/package_reference/tuners#peft.PrefixTuningConfig"),c(we,"href","https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForSeq2SeqLM"),c(we,"rel","nofollow"),c(xe,"href","/docs/peft/main/en/package_reference/peft_model#peft.PeftModel"),c(Qe,"href","/docs/peft/main/en/package_reference/peft_model#peft.PeftModel"),c(L,"id","share-model"),c(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(L,"href","#share-model"),c(Y,"class","relative group"),c(ge,"href","https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub"),c(ge,"rel","nofollow"),c(O,"id","inference"),c(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(O,"href","#inference"),c(A,"class","relative group")},m(e,s){t(document.head,U),p(e,S,s),p(e,b,s),t(b,v),t(v,W),y(C,W,null),t(b,X),t(b,F),t(F,kt),p(e,Rl,s),y(te,e,s),p(e,Zl,s),p(e,R,s),t(R,Xt),t(R,Oe),t(Oe,Rt),t(R,Zt),t(R,el),t(el,Et),t(R,Gt),p(e,El,s),y(z,e,s),p(e,Gl,s),p(e,I,s),t(I,Bt),t(I,se),t(se,ll),t(ll,Vt),t(I,Wt),t(I,tl),t(tl,xt),t(I,Qt),t(I,ae),t(ae,$t),t(I,Nt),p(e,Bl,s),p(e,Ve,s),t(Ve,Yt),p(e,Vl,s),y(ne,e,s),p(e,Wl,s),p(e,x,s),t(x,q),t(q,sl),y(oe,sl,null),t(x,At),t(x,al),t(al,St),p(e,xl,s),p(e,Z,s),t(Z,Ft),t(Z,nl),t(nl,zt),t(Z,qt),t(Z,ol),t(ol,Ht),t(Z,Pt),p(e,Ql,s),y(re,e,s),p(e,$l,s),p(e,Q,s),t(Q,H),t(H,rl),y(ie,rl,null),t(Q,Dt),t(Q,il),t(il,Lt),p(e,Nl,s),p(e,E,s),t(E,Kt),t(E,pl),t(pl,Ot),t(E,es),t(E,pe),t(pe,cl),t(cl,ls),t(E,ts),p(e,Yl,s),p(e,w,s),t(w,ss),t(w,ce),t(ce,as),t(w,ns),t(w,he),t(he,os),t(w,rs),t(w,hl),t(hl,is),t(w,ps),t(w,dl),t(dl,cs),t(w,hs),t(w,de),t(de,ds),t(w,Ms),p(e,Al,s),y(Me,e,s),p(e,Sl,s),p(e,$,s),t($,P),t(P,Ml),y(ue,Ml,null),t($,us),t($,ul),t(ul,ys),p(e,Fl,s),p(e,G,s),t(G,ms),t(G,yl),t(yl,fs),t(G,Js),t(G,ml),t(ml,Us),t(G,bs),p(e,zl,s),y(ye,e,s),p(e,ql,s),p(e,B,s),t(B,ws),t(B,me),t(me,Ts),t(B,js),t(B,fl),t(fl,_s),t(B,Cs),p(e,Hl,s),y(fe,e,s),p(e,Pl,s),p(e,_,s),t(_,vs),t(_,Je),t(Je,Jl),t(Jl,Is),t(_,gs),t(_,Ul),t(Ul,ks),t(_,Xs),t(_,bl),t(bl,Rs),t(_,Zs),t(_,wl),t(wl,Es),t(_,Gs),p(e,Dl,s),y(Ue,e,s),p(e,Ll,s),p(e,N,s),t(N,D),t(D,Tl),y(be,Tl,null),t(N,Bs),t(N,jl),t(jl,Vs),p(e,Kl,s),p(e,T,s),t(T,Ws),t(T,We),t(We,xs),t(T,Qs),t(T,_l),t(_l,$s),t(T,Ns),t(T,we),t(we,Ys),t(T,As),t(T,xe),t(xe,Ss),t(T,Fs),t(T,Qe),t(Qe,zs),t(T,qs),p(e,Ol,s),y(Te,e,s),p(e,et,s),p(e,$e,s),t($e,Hs),p(e,lt,s),y(je,e,s),p(e,tt,s),p(e,Ne,s),t(Ne,Ps),p(e,st,s),y(_e,e,s),p(e,at,s),p(e,Ye,s),t(Ye,Ds),p(e,nt,s),y(Ce,e,s),p(e,ot,s),p(e,Ae,s),t(Ae,Ls),p(e,rt,s),p(e,Y,s),t(Y,L),t(L,Cl),y(ve,Cl,null),t(Y,Ks),t(Y,vl),t(vl,Os),p(e,it,s),p(e,Se,s),t(Se,ea),p(e,pt,s),y(Ie,e,s),p(e,ct,s),p(e,K,s),t(K,la),t(K,ge),t(ge,ta),t(K,sa),p(e,ht,s),y(ke,e,s),p(e,dt,s),p(e,Fe,s),t(Fe,aa),p(e,Mt,s),p(e,A,s),t(A,O),t(O,Il),y(Xe,Il,null),t(A,na),t(A,gl),t(gl,oa),p(e,ut,s),p(e,ze,s),t(ze,ra),p(e,yt,s),y(Re,e,s),p(e,mt,s),p(e,qe,s),t(qe,ia),p(e,ft,s),y(Ze,e,s),p(e,Jt,s),p(e,ee,s),t(ee,pa),t(ee,kl),t(kl,ca),t(ee,ha),p(e,Ut,s),y(Ee,e,s),bt=!0},p(e,[s]){const Ge={};s&2&&(Ge.$$scope={dirty:s,ctx:e}),z.$set(Ge)},i(e){bt||(m(C.$$.fragment,e),m(te.$$.fragment,e),m(z.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(ie.$$.fragment,e),m(Me.$$.fragment,e),m(ue.$$.fragment,e),m(ye.$$.fragment,e),m(fe.$$.fragment,e),m(Ue.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m(_e.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(Ie.$$.fragment,e),m(ke.$$.fragment,e),m(Xe.$$.fragment,e),m(Re.$$.fragment,e),m(Ze.$$.fragment,e),m(Ee.$$.fragment,e),bt=!0)},o(e){f(C.$$.fragment,e),f(te.$$.fragment,e),f(z.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(ie.$$.fragment,e),f(Me.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f(fe.$$.fragment,e),f(Ue.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(je.$$.fragment,e),f(_e.$$.fragment,e),f(Ce.$$.fragment,e),f(ve.$$.fragment,e),f(Ie.$$.fragment,e),f(ke.$$.fragment,e),f(Xe.$$.fragment,e),f(Re.$$.fragment,e),f(Ze.$$.fragment,e),f(Ee.$$.fragment,e),bt=!1},d(e){l(U),e&&l(S),e&&l(b),J(C),e&&l(Rl),J(te,e),e&&l(Zl),e&&l(R),e&&l(El),J(z,e),e&&l(Gl),e&&l(I),e&&l(Bl),e&&l(Ve),e&&l(Vl),J(ne,e),e&&l(Wl),e&&l(x),J(oe),e&&l(xl),e&&l(Z),e&&l(Ql),J(re,e),e&&l($l),e&&l(Q),J(ie),e&&l(Nl),e&&l(E),e&&l(Yl),e&&l(w),e&&l(Al),J(Me,e),e&&l(Sl),e&&l($),J(ue),e&&l(Fl),e&&l(G),e&&l(zl),J(ye,e),e&&l(ql),e&&l(B),e&&l(Hl),J(fe,e),e&&l(Pl),e&&l(_),e&&l(Dl),J(Ue,e),e&&l(Ll),e&&l(N),J(be),e&&l(Kl),e&&l(T),e&&l(Ol),J(Te,e),e&&l(et),e&&l($e),e&&l(lt),J(je,e),e&&l(tt),e&&l(Ne),e&&l(st),J(_e,e),e&&l(at),e&&l(Ye),e&&l(nt),J(Ce,e),e&&l(ot),e&&l(Ae),e&&l(rt),e&&l(Y),J(ve),e&&l(it),e&&l(Se),e&&l(pt),J(Ie,e),e&&l(ct),e&&l(K),e&&l(ht),J(ke,e),e&&l(dt),e&&l(Fe),e&&l(Mt),e&&l(A),J(Xe),e&&l(ut),e&&l(ze),e&&l(yt),J(Re,e),e&&l(mt),e&&l(qe),e&&l(ft),J(Ze,e),e&&l(Jt),e&&l(ee),e&&l(Ut),J(Ee,e)}}}const Xn={local:"prefix-tuning-for-conditional-generation",sections:[{local:"setup",title:"Setup"},{local:"load-dataset",title:"Load dataset"},{local:"preprocess-dataset",title:"Preprocess dataset"},{local:"train-model",title:"Train model"},{local:"share-model",title:"Share model"},{local:"inference",title:"Inference"}],title:"Prefix tuning for conditional generation"};function Rn(Xl){return Cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends wn{constructor(U){super();Tn(this,U,Rn,kn,jn,{})}}export{Wn as default,Xn as metadata};
