import{s as fe,n as be,o as we}from"../chunks/scheduler.6e0d5ff7.js";import{S as ye,i as Me,g as i,s as n,r as c,E as Je,h as o,f as l,c as a,j as de,u,x as r,k as le,y as Te,a as s,v as d,d as f,t as b,w}from"../chunks/index.d7c1b260.js";import{C}from"../chunks/CodeBlock.09a08494.js";import{D as ge}from"../chunks/DocNotebookDropdown.0647ce65.js";import{H as he}from"../chunks/Heading.30a009b0.js";function _e(se){let p,G,x,Q,y,H,M,S,J,ne='<code>StableDiffusionPipeline</code>은  textual-inversion을 지원하는데, 이는 몇 개의 샘플 이미지만으로 stable diffusion과 같은 모델이 새로운 컨셉을 학습할 수 있도록 하는 기법입니다. 이를 통해 생성된 이미지를 더 잘 제어하고 특정 컨셉에 맞게 모델을 조정할 수 있습니다. 커뮤니티에서 만들어진 컨셉들의 컬렉션은 <a href="https://huggingface.co/spaces/sd-concepts-library/stable-diffusion-conceptualizer" rel="nofollow">Stable Diffusion Conceptualizer</a>를 통해 빠르게 사용해볼 수 있습니다.',z,T,ae='이 가이드에서는 Stable Diffusion Conceptualizer에서 사전학습한 컨셉을 사용하여 textual-inversion으로 추론을 실행하는 방법을 보여드립니다. textual-inversion으로 모델에 새로운 컨셉을 학습시키는 데 관심이 있으시다면,  <a href="./training/text_inversion">Textual Inversion</a>  훈련 가이드를 참조하세요.',N,g,ie="Hugging Face 계정으로 로그인하세요:",F,h,Y,_,oe="필요한 라이브러리를 불러오고 생성된 이미지를 시각화하기 위한 도우미 함수 <code>image_grid</code>를 만듭니다:",R,U,V,j,pe='Stable Diffusion과 <a href="https://huggingface.co/spaces/sd-concepts-library/stable-diffusion-conceptualizer" rel="nofollow">Stable Diffusion Conceptualizer</a>에서 사전학습된 컨셉을 선택합니다:',E,B,L,v,re="이제 파이프라인을 로드하고 사전학습된 컨셉을 파이프라인에 전달할 수 있습니다:",P,I,D,k,me="특별한 placeholder token ’<code>&lt;cat-toy&gt;</code>‘를 사용하여 사전학습된 컨셉으로 프롬프트를 만들고, 생성할 샘플의 수와 이미지 행의 수를 선택합니다:",q,Z,K,$,ce="그런 다음 파이프라인을 실행하고, 생성된 이미지들을 저장합니다. 그리고 처음에 만들었던 도우미 함수 <code>image_grid</code>를 사용하여 생성 결과들을 시각화합니다. 이 때 <code>num_inference_steps</code>와 <code>guidance_scale</code>과 같은 매개 변수들을 조정하여, 이것들이 이미지 품질에 어떠한 영향을 미치는지를 자유롭게 확인해보시기 바랍니다.",A,W,O,m,ue='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/textual_inversion_inference.png"/>',ee,X,te;return y=new he({props:{title:"Textual inversion",local:"textual-inversion",headingTag:"h1"}}),M=new ge({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/textual_inversion_inference.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/textual_inversion_inference.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/textual_inversion_inference.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/textual_inversion_inference.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/textual_inversion_inference.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/textual_inversion_inference.ipynb"}]}}),h=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),U=new C({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWltcG9ydCUyMFBJTCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBDTElQRmVhdHVyZUV4dHJhY3RvciUyQyUyMENMSVBUZXh0TW9kZWwlMkMlMjBDTElQVG9rZW5pemVyJTBBJTBBJTBBZGVmJTIwaW1hZ2VfZ3JpZChpbWdzJTJDJTIwcm93cyUyQyUyMGNvbHMpJTNBJTBBJTIwJTIwJTIwJTIwYXNzZXJ0JTIwbGVuKGltZ3MpJTIwJTNEJTNEJTIwcm93cyUyMColMjBjb2xzJTBBJTBBJTIwJTIwJTIwJTIwdyUyQyUyMGglMjAlM0QlMjBpbWdzJTVCMCU1RC5zaXplJTBBJTIwJTIwJTIwJTIwZ3JpZCUyMCUzRCUyMEltYWdlLm5ldyglMjJSR0IlMjIlMkMlMjBzaXplJTNEKGNvbHMlMjAqJTIwdyUyQyUyMHJvd3MlMjAqJTIwaCkpJTBBJTIwJTIwJTIwJTIwZ3JpZF93JTJDJTIwZ3JpZF9oJTIwJTNEJTIwZ3JpZC5zaXplJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGltZyUyMGluJTIwZW51bWVyYXRlKGltZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3JpZC5wYXN0ZShpbWclMkMlMjBib3glM0QoaSUyMCUyNSUyMGNvbHMlMjAqJTIwdyUyQyUyMGklMjAlMkYlMkYlMjBjb2xzJTIwKiUyMGgpKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGdyaWQ=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor, CLIPTextModel, CLIPTokenizer


<span class="hljs-keyword">def</span> <span class="hljs-title function_">image_grid</span>(<span class="hljs-params">imgs, rows, cols</span>):
    <span class="hljs-keyword">assert</span> <span class="hljs-built_in">len</span>(imgs) == rows * cols

    w, h = imgs[<span class="hljs-number">0</span>].size
    grid = Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, size=(cols * w, rows * h))
    grid_w, grid_h = grid.size

    <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(imgs):
        grid.paste(img, box=(i % cols * w, i // cols * h))
    <span class="hljs-keyword">return</span> grid`,wrap:!1}}),B=new C({props:{code:"cHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXJlcG9faWRfZW1iZWRzJTIwJTNEJTIwJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjI=",highlighted:`pretrained_model_name_or_path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
repo_id_embeds = <span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>`,wrap:!1}}),I=new C({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZWxpbmUubG9hZF90ZXh0dWFsX2ludmVyc2lvbihyZXBvX2lkX2VtYmVkcyk=",highlighted:`pipeline = StableDiffusionPipeline.from_pretrained(pretrained_model_name_or_path, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_textual_inversion(repo_id_embeds)`,wrap:!1}}),Z=new C({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdyYWZpdHRpJTIwaW4lMjBhJTIwZmF2ZWxhJTIwd2FsbCUyMHdpdGglMjBhJTIwJTNDY2F0LXRveSUzRSUyMG9uJTIwaXQlMjIlMEElMEFudW1fc2FtcGxlcyUyMCUzRCUyMDIlMEFudW1fcm93cyUyMCUzRCUyMDI=",highlighted:`prompt = <span class="hljs-string">&quot;a grafitti in a favela wall with a &lt;cat-toy&gt; on it&quot;</span>

num_samples = <span class="hljs-number">2</span>
num_rows = <span class="hljs-number">2</span>`,wrap:!1}}),W=new C({props:{code:"YWxsX2ltYWdlcyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKG51bV9yb3dzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEbnVtX3NhbXBsZXMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSkuaW1hZ2VzJTBBJTIwJTIwJTIwJTIwYWxsX2ltYWdlcy5leHRlbmQoaW1hZ2VzKSUwQSUwQWdyaWQlMjAlM0QlMjBpbWFnZV9ncmlkKGFsbF9pbWFnZXMlMkMlMjBudW1fc2FtcGxlcyUyQyUyMG51bV9yb3dzKSUwQWdyaWQ=",highlighted:`all_images = []
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_rows):
    images = pipe(prompt, num_images_per_prompt=num_samples, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7.5</span>).images
    all_images.extend(images)

grid = image_grid(all_images, num_samples, num_rows)
grid`,wrap:!1}}),{c(){p=i("meta"),G=n(),x=i("p"),Q=n(),c(y.$$.fragment),H=n(),c(M.$$.fragment),S=n(),J=i("p"),J.innerHTML=ne,z=n(),T=i("p"),T.innerHTML=ae,N=n(),g=i("p"),g.textContent=ie,F=n(),c(h.$$.fragment),Y=n(),_=i("p"),_.innerHTML=oe,R=n(),c(U.$$.fragment),V=n(),j=i("p"),j.innerHTML=pe,E=n(),c(B.$$.fragment),L=n(),v=i("p"),v.textContent=re,P=n(),c(I.$$.fragment),D=n(),k=i("p"),k.innerHTML=me,q=n(),c(Z.$$.fragment),K=n(),$=i("p"),$.innerHTML=ce,A=n(),c(W.$$.fragment),O=n(),m=i("div"),m.innerHTML=ue,ee=n(),X=i("p"),this.h()},l(e){const t=Je("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),G=a(e),x=o(e,"P",{}),de(x).forEach(l),Q=a(e),u(y.$$.fragment,e),H=a(e),u(M.$$.fragment,e),S=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-nm7oku"&&(J.innerHTML=ne),z=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-6ecc9h"&&(T.innerHTML=ae),N=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1nfmd9t"&&(g.textContent=ie),F=a(e),u(h.$$.fragment,e),Y=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1etucvv"&&(_.innerHTML=oe),R=a(e),u(U.$$.fragment,e),V=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-5ws1w4"&&(j.innerHTML=pe),E=a(e),u(B.$$.fragment,e),L=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-rgvcdq"&&(v.textContent=re),P=a(e),u(I.$$.fragment,e),D=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-g8ujvg"&&(k.innerHTML=me),q=a(e),u(Z.$$.fragment,e),K=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1fnsviy"&&($.innerHTML=ce),A=a(e),u(W.$$.fragment,e),O=a(e),m=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-1r5zq0s"&&(m.innerHTML=ue),ee=a(e),X=o(e,"P",{}),de(X).forEach(l),this.h()},h(){le(p,"name","hf:doc:metadata"),le(p,"content",Ue),le(m,"class","flex justify-center")},m(e,t){Te(document.head,p),s(e,G,t),s(e,x,t),s(e,Q,t),d(y,e,t),s(e,H,t),d(M,e,t),s(e,S,t),s(e,J,t),s(e,z,t),s(e,T,t),s(e,N,t),s(e,g,t),s(e,F,t),d(h,e,t),s(e,Y,t),s(e,_,t),s(e,R,t),d(U,e,t),s(e,V,t),s(e,j,t),s(e,E,t),d(B,e,t),s(e,L,t),s(e,v,t),s(e,P,t),d(I,e,t),s(e,D,t),s(e,k,t),s(e,q,t),d(Z,e,t),s(e,K,t),s(e,$,t),s(e,A,t),d(W,e,t),s(e,O,t),s(e,m,t),s(e,ee,t),s(e,X,t),te=!0},p:be,i(e){te||(f(y.$$.fragment,e),f(M.$$.fragment,e),f(h.$$.fragment,e),f(U.$$.fragment,e),f(B.$$.fragment,e),f(I.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),te=!0)},o(e){b(y.$$.fragment,e),b(M.$$.fragment,e),b(h.$$.fragment,e),b(U.$$.fragment,e),b(B.$$.fragment,e),b(I.$$.fragment,e),b(Z.$$.fragment,e),b(W.$$.fragment,e),te=!1},d(e){e&&(l(G),l(x),l(Q),l(H),l(S),l(J),l(z),l(T),l(N),l(g),l(F),l(Y),l(_),l(R),l(V),l(j),l(E),l(L),l(v),l(P),l(D),l(k),l(q),l(K),l($),l(A),l(O),l(m),l(ee),l(X)),l(p),w(y,e),w(M,e),w(h,e),w(U,e),w(B,e),w(I,e),w(Z,e),w(W,e)}}}const Ue='{"title":"Textual inversion","local":"textual-inversion","sections":[],"depth":1}';function je(se){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $e extends ye{constructor(p){super(),Me(this,p,je,_e,fe,{})}}export{$e as component};
