import{s as It,o as St,n as be}from"../chunks/scheduler.8c3d61f6.js";import{S as kt,i as Bt,g as l,s as o,r as g,A as Gt,h as p,f as n,c as s,j as he,u,x as d,k as _e,y as M,a as i,v as h,d as _,t as b,w as x}from"../chunks/index.da70eac4.js";import{T as Oe}from"../chunks/Tip.1d9b8c37.js";import{D as st}from"../chunks/Docstring.28bd4ce5.js";import{C as de}from"../chunks/CodeBlock.a9c4becf.js";import{E as Zt}from"../chunks/ExampleCodeBlock.ce69d7b7.js";import{H as rt,E as Lt}from"../chunks/getInferenceSnippets.cd165132.js";function Wt(v){let a,c='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=l("p"),a.innerHTML=c},l(r){a=p(r,"P",{"data-svelte-h":!0}),d(a)!=="svelte-1qn15hi"&&(a.innerHTML=c)},m(r,m){i(r,a,m)},p:be,d(r){r&&n(a)}}}function Ht(v){let a,c='You can further improve generation quality by passing the generated image from <a href="/docs/diffusers/main/en/api/pipelines/pixart_sigma#diffusers.PixArtSigmaPipeline">PixArtSigmaPipeline</a> to the <a href="../../using-diffusers/sdxl#base-to-refiner-model">SDXL refiner</a> model.';return{c(){a=l("p"),a.innerHTML=c},l(r){a=p(r,"P",{"data-svelte-h":!0}),d(a)!=="svelte-136wudk"&&(a.innerHTML=c)},m(r,m){i(r,a,m)},p:be,d(r){r&&n(a)}}}function Et(v){let a,c="Notice that while initializing <code>pipe</code>, you’re setting <code>text_encoder</code> to <code>None</code> so that it’s not loaded.";return{c(){a=l("p"),a.innerHTML=c},l(r){a=p(r,"P",{"data-svelte-h":!0}),d(a)!=="svelte-1of5pjk"&&(a.innerHTML=c)},m(r,m){i(r,a,m)},p:be,d(r){r&&n(a)}}}function Vt(v){let a,c="Text embeddings computed in 8-bit can impact the quality of the generated images because of the information loss in the representation space caused by the reduced precision. It’s recommended to compare the outputs with and without 8-bit.";return{c(){a=l("p"),a.textContent=c},l(r){a=p(r,"P",{"data-svelte-h":!0}),d(a)!=="svelte-1rutysd"&&(a.textContent=c)},m(r,m){i(r,a,m)},p:be,d(r){r&&n(a)}}}function Xt(v){let a,c="Examples:",r,m,y;return m=new de({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUGl4QXJ0U2lnbWFQaXBlbGluZSUwQSUwQSUyMyUyMFlvdSUyMGNhbiUyMHJlcGxhY2UlMjB0aGUlMjBjaGVja3BvaW50JTIwaWQlMjB3aXRoJTIwJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVNpZ21hLVhMLTItNTEyLU1TJTIyJTIwdG9vLiUwQXBpcGUlMjAlM0QlMjBQaXhBcnRTaWdtYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQSUyMyUyMEVuYWJsZSUyMG1lbW9yeSUyMG9wdGltaXphdGlvbnMuJTBBJTIzJTIwcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBzbWFsbCUyMGNhY3R1cyUyMHdpdGglMjBhJTIwaGFwcHklMjBmYWNlJTIwaW4lMjB0aGUlMjBTYWhhcmElMjBkZXNlcnQuJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtSigmaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can replace the checkpoint id with &quot;PixArt-alpha/PixArt-Sigma-XL-2-512-MS&quot; too.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PixArtSigmaPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable memory optimizations.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=c,r=o(),g(m.$$.fragment)},l(f){a=p(f,"P",{"data-svelte-h":!0}),d(a)!=="svelte-kvfsh7"&&(a.textContent=c),r=s(f),u(m.$$.fragment,f)},m(f,P){i(f,a,P),i(f,r,P),h(m,f,P),y=!0},p:be,i(f){y||(_(m.$$.fragment,f),y=!0)},o(f){b(m.$$.fragment,f),y=!1},d(f){f&&(n(a),n(r)),x(m,f)}}}function Rt(v){let a,c,r,m,y,f,P,lt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/header_collage_sigma.jpg"/>',xe,k,pt='<a href="https://huggingface.co/papers/2403.04692" rel="nofollow">PixArt-Σ: Weak-to-Strong Training of Diffusion Transformer for 4K Text-to-Image Generation</a> is Junsong Chen, Jincheng Yu, Chongjian Ge, Lewei Yao, Enze Xie, Yue Wu, Zhongdao Wang, James Kwok, Ping Luo, Huchuan Lu, and Zhenguo Li.',we,B,dt="The abstract from the paper is:",Me,G,mt="<em>In this paper, we introduce PixArt-Σ, a Diffusion Transformer model (DiT) capable of directly generating images at 4K resolution. PixArt-Σ represents a significant advancement over its predecessor, PixArt-α, offering images of markedly higher fidelity and improved alignment with text prompts. A key feature of PixArt-Σ is its training efficiency. Leveraging the foundational pre-training of PixArt-α, it evolves from the ‘weaker’ baseline to a ‘stronger’ model via incorporating higher quality data, a process we term “weak-to-strong training”. The advancements in PixArt-Σ are twofold: (1) High-Quality Training Data: PixArt-Σ incorporates superior-quality image data, paired with more precise and detailed image captions. (2) Efficient Token Compression: we propose a novel attention module within the DiT framework that compresses both keys and values, significantly improving efficiency and facilitating ultra-high-resolution image generation. Thanks to these improvements, PixArt-Σ achieves superior image quality and user prompt adherence capabilities with significantly smaller model size (0.6B parameters) than existing text-to-image diffusion models, such as SDXL (2.6B parameters) and SD Cascade (5.1B parameters). Moreover, PixArt-Σ’s capability to generate 4K images supports the creation of high-resolution posters and wallpapers, efficiently bolstering the production of highquality visual content in industries such as film and gaming.</em>",Te,Z,ct='You can find the original codebase at <a href="https://github.com/PixArt-alpha/PixArt-sigma" rel="nofollow">PixArt-alpha/PixArt-sigma</a> and all the available checkpoints at <a href="https://huggingface.co/PixArt-alpha" rel="nofollow">PixArt-alpha</a>.',ve,L,ft="Some notes about this pipeline:",ye,W,gt='<li>It uses a Transformer backbone (instead of a UNet) for denoising. As such it has a similar architecture as <a href="https://hf.co/docs/transformers/model_doc/dit" rel="nofollow">DiT</a>.</li> <li>It was trained using text conditions computed from T5. This aspect makes the pipeline better at following complex text prompts with intricate details.</li> <li>It is good at producing high-resolution images at different aspect ratios. To get the best results, the authors recommend some size brackets which can be found <a href="https://github.com/PixArt-alpha/PixArt-sigma/blob/master/diffusion/data/datasets/utils.py" rel="nofollow">here</a>.</li> <li>It rivals the quality of state-of-the-art text-to-image generation systems (as of this writing) such as PixArt-α, Stable Diffusion XL, Playground V2.0 and DALL-E 3, while being more efficient than them.</li> <li>It shows the ability of generating super high resolution images, such as 2048px or even 4K.</li> <li>It shows that text-to-image models can grow from a weak model to a stronger one through several improvements (VAEs, datasets, and so on.)</li>',Pe,A,$e,j,Je,H,Ae,E,ut='Run the <a href="/docs/diffusers/main/en/api/pipelines/pixart_sigma#diffusers.PixArtSigmaPipeline">PixArtSigmaPipeline</a> with under 8GB GPU VRAM by loading the text encoder in 8-bit precision. Let’s walk through a full-fledged example.',je,V,ht='First, install the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library:',Ue,X,Ce,R,_t="Then load the text encoder in 8-bit:",Ie,Q,Se,q,bt="Now, use the <code>pipe</code> to encode a prompt:",ke,N,Be,Y,xt="Since text embeddings have been computed, remove the <code>text_encoder</code> and <code>pipe</code> from the memory, and free up some GPU VRAM:",Ge,D,Ze,z,wt="Then compute the latents with the prompt embeddings as inputs:",Le,F,We,U,He,O,Mt="Once the latents are computed, pass it off to the VAE to decode into a real image:",Ee,K,Ve,ee,Tt='By deleting components you aren’t using and flushing the GPU VRAM, you should be able to run <a href="/docs/diffusers/main/en/api/pipelines/pixart_sigma#diffusers.PixArtSigmaPipeline">PixArtSigmaPipeline</a> with under 8GB GPU VRAM.',Xe,te,vt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/8bits_cat.png"/>',Re,ne,yt='If you want a report of your memory-usage, run this <a href="https://gist.github.com/sayakpaul/3ae0f847001d342af27018a96f467e4e" rel="nofollow">script</a>.',Qe,C,qe,ie,Pt="While loading the <code>text_encoder</code>, you set <code>load_in_8bit</code> to <code>True</code>. You could also specify <code>load_in_4bit</code> to bring your memory requirements down even further to under 7GB.",Ne,ae,Ye,w,oe,Ke,me,$t="Pipeline for text-to-image generation using PixArt-Sigma.",et,ce,Jt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,tt,$,se,nt,fe,At="Function invoked when calling the pipeline for generation.",it,I,at,S,re,ot,ge,jt="Encodes the prompt into text encoder hidden states.",De,le,ze,ue,Fe;return y=new rt({props:{title:"PixArt-Σ",local:"pixart-σ",headingTag:"h1"}}),A=new Oe({props:{$$slots:{default:[Wt]},$$scope:{ctx:v}}}),j=new Oe({props:{$$slots:{default:[Ht]},$$scope:{ctx:v}}}),H=new rt({props:{title:"Inference with under 8GB GPU VRAM",local:"inference-with-under-8gb-gpu-vram",headingTag:"h2"}}),X=new de({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes",wrap:!1}}),Q=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFBpeEFydFNpZ21hUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBQaXhBcnRTaWdtYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtSigmaPipeline
<span class="hljs-keyword">import</span> torch

text_encoder = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
pipe = PixArtSigmaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    text_encoder=text_encoder,
    transformer=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>
)`,wrap:!1}}),N=new de({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmN1dGUlMjBjYXQlMjIlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcHJvbXB0X2F0dGVudGlvbl9tYXNrJTJDJTIwbmVnYXRpdmVfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2F0dGVudGlvbl9tYXNrJTIwJTNEJTIwcGlwZS5lbmNvZGVfcHJvbXB0KHByb21wdCk=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    prompt = <span class="hljs-string">&quot;cute cat&quot;</span>
    prompt_embeds, prompt_attention_mask, negative_embeds, negative_prompt_attention_mask = pipe.encode_prompt(prompt)`,wrap:!1}}),D=new de({props:{code:"aW1wb3J0JTIwZ2MlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTBBZGVsJTIwdGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZSUwQWZsdXNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gc

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()

<span class="hljs-keyword">del</span> text_encoder
<span class="hljs-keyword">del</span> pipe
flush()`,wrap:!1}}),F=new de({props:{code:"cGlwZSUyMCUzRCUyMFBpeEFydFNpZ21hUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlBpeEFydC1hbHBoYSUyRlBpeEFydC1TaWdtYS1YTC0yLTEwMjQtTVMlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWxhdGVudHMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfYXR0ZW50aW9uX21hc2slM0Rwcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slM0RuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIlMkMlMEEpLmltYWdlcyUwQSUwQWRlbCUyMHBpcGUudHJhbnNmb3JtZXIlMEFmbHVzaCgp",highlighted:`pipe = PixArtSigmaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

latents = pipe(
    negative_prompt=<span class="hljs-literal">None</span>,
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    prompt_attention_mask=prompt_attention_mask,
    negative_prompt_attention_mask=negative_prompt_attention_mask,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images

<span class="hljs-keyword">del</span> pipe.transformer
flush()`,wrap:!1}}),U=new Oe({props:{$$slots:{default:[Et]},$$scope:{ctx:v}}}),K=new de({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZS52YWUuZGVjb2RlKGxhdGVudHMlMjAlMkYlMjBwaXBlLnZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSU1QjAlNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    image = pipe.vae.decode(latents / pipe.vae.config.scaling_factor, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
image = pipe.image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),C=new Oe({props:{warning:!0,$$slots:{default:[Vt]},$$scope:{ctx:v}}}),ae=new rt({props:{title:"PixArtSigmaPipeline",local:"diffusers.PixArtSigmaPipeline",headingTag:"h2"}}),oe=new st({props:{name:"class diffusers.PixArtSigmaPipeline",anchor:"diffusers.PixArtSigmaPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKL"},{name:"transformer",val:": PixArtTransformer2DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PixArtSigmaPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. PixArt-Alpha uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.PixArtSigmaPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.PixArtSigmaPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/pixart_transformer2d#diffusers.PixArtTransformer2DModel">PixArtTransformer2DModel</a>) &#x2014;
A text conditioned <code>PixArtTransformer2DModel</code> to denoise the encoded image latents. Initially published as
<a href="https://huggingface.co/PixArt-alpha/PixArt-Sigma-XL-2-1024-MS/blob/main/transformer/config.json#L2" rel="nofollow"><code>Transformer2DModel</code></a>
in the config, but the mismatch can be ignored.`,name:"transformer"},{anchor:"diffusers.PixArtSigmaPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L185"}}),se=new st({props:{name:"__call__",anchor:"diffusers.PixArtSigmaPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"max_sequence_length",val:": int = 300"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 300) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),I=new Zt({props:{anchor:"diffusers.PixArtSigmaPipeline.__call__.example",$$slots:{default:[Xt]},$$scope:{ctx:v}}}),re=new st({props:{name:"encode_prompt",anchor:"diffusers.PixArtSigmaPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha, it&#x2019;s should be the embeddings of the &quot;&quot;
string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L247"}}),le=new Lt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/pixart_sigma.md"}}),{c(){a=l("meta"),c=o(),r=l("p"),m=o(),g(y.$$.fragment),f=o(),P=l("p"),P.innerHTML=lt,xe=o(),k=l("p"),k.innerHTML=pt,we=o(),B=l("p"),B.textContent=dt,Me=o(),G=l("p"),G.innerHTML=mt,Te=o(),Z=l("p"),Z.innerHTML=ct,ve=o(),L=l("p"),L.textContent=ft,ye=o(),W=l("ul"),W.innerHTML=gt,Pe=o(),g(A.$$.fragment),$e=o(),g(j.$$.fragment),Je=o(),g(H.$$.fragment),Ae=o(),E=l("p"),E.innerHTML=ut,je=o(),V=l("p"),V.innerHTML=ht,Ue=o(),g(X.$$.fragment),Ce=o(),R=l("p"),R.textContent=_t,Ie=o(),g(Q.$$.fragment),Se=o(),q=l("p"),q.innerHTML=bt,ke=o(),g(N.$$.fragment),Be=o(),Y=l("p"),Y.innerHTML=xt,Ge=o(),g(D.$$.fragment),Ze=o(),z=l("p"),z.textContent=wt,Le=o(),g(F.$$.fragment),We=o(),g(U.$$.fragment),He=o(),O=l("p"),O.textContent=Mt,Ee=o(),g(K.$$.fragment),Ve=o(),ee=l("p"),ee.innerHTML=Tt,Xe=o(),te=l("p"),te.innerHTML=vt,Re=o(),ne=l("p"),ne.innerHTML=yt,Qe=o(),g(C.$$.fragment),qe=o(),ie=l("p"),ie.innerHTML=Pt,Ne=o(),g(ae.$$.fragment),Ye=o(),w=l("div"),g(oe.$$.fragment),Ke=o(),me=l("p"),me.textContent=$t,et=o(),ce=l("p"),ce.innerHTML=Jt,tt=o(),$=l("div"),g(se.$$.fragment),nt=o(),fe=l("p"),fe.textContent=At,it=o(),g(I.$$.fragment),at=o(),S=l("div"),g(re.$$.fragment),ot=o(),ge=l("p"),ge.textContent=jt,De=o(),g(le.$$.fragment),ze=o(),ue=l("p"),this.h()},l(e){const t=Gt("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(n),c=s(e),r=p(e,"P",{}),he(r).forEach(n),m=s(e),u(y.$$.fragment,e),f=s(e),P=p(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1h02zzr"&&(P.innerHTML=lt),xe=s(e),k=p(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1i25npg"&&(k.innerHTML=pt),we=s(e),B=p(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1cwsb16"&&(B.textContent=dt),Me=s(e),G=p(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-12smxu3"&&(G.innerHTML=mt),Te=s(e),Z=p(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-8e6u65"&&(Z.innerHTML=ct),ve=s(e),L=p(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-v1sn1g"&&(L.textContent=ft),ye=s(e),W=p(e,"UL",{"data-svelte-h":!0}),d(W)!=="svelte-8ca6jo"&&(W.innerHTML=gt),Pe=s(e),u(A.$$.fragment,e),$e=s(e),u(j.$$.fragment,e),Je=s(e),u(H.$$.fragment,e),Ae=s(e),E=p(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-bc67kz"&&(E.innerHTML=ut),je=s(e),V=p(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-c2h3fb"&&(V.innerHTML=ht),Ue=s(e),u(X.$$.fragment,e),Ce=s(e),R=p(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-5r7318"&&(R.textContent=_t),Ie=s(e),u(Q.$$.fragment,e),Se=s(e),q=p(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-rj1jgt"&&(q.innerHTML=bt),ke=s(e),u(N.$$.fragment,e),Be=s(e),Y=p(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1ux3xow"&&(Y.innerHTML=xt),Ge=s(e),u(D.$$.fragment,e),Ze=s(e),z=p(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-w3d4de"&&(z.textContent=wt),Le=s(e),u(F.$$.fragment,e),We=s(e),u(U.$$.fragment,e),He=s(e),O=p(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1yf7wfg"&&(O.textContent=Mt),Ee=s(e),u(K.$$.fragment,e),Ve=s(e),ee=p(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-o4igoy"&&(ee.innerHTML=Tt),Xe=s(e),te=p(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1g55ccf"&&(te.innerHTML=vt),Re=s(e),ne=p(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-11lvu0m"&&(ne.innerHTML=yt),Qe=s(e),u(C.$$.fragment,e),qe=s(e),ie=p(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1i82z60"&&(ie.innerHTML=Pt),Ne=s(e),u(ae.$$.fragment,e),Ye=s(e),w=p(e,"DIV",{class:!0});var T=he(w);u(oe.$$.fragment,T),Ke=s(T),me=p(T,"P",{"data-svelte-h":!0}),d(me)!=="svelte-bjkp5a"&&(me.textContent=$t),et=s(T),ce=p(T,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-wu1jmh"&&(ce.innerHTML=Jt),tt=s(T),$=p(T,"DIV",{class:!0});var J=he($);u(se.$$.fragment,J),nt=s(J),fe=p(J,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-v78lg8"&&(fe.textContent=At),it=s(J),u(I.$$.fragment,J),J.forEach(n),at=s(T),S=p(T,"DIV",{class:!0});var pe=he(S);u(re.$$.fragment,pe),ot=s(pe),ge=p(pe,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-16q0ax1"&&(ge.textContent=jt),pe.forEach(n),T.forEach(n),De=s(e),u(le.$$.fragment,e),ze=s(e),ue=p(e,"P",{}),he(ue).forEach(n),this.h()},h(){_e(a,"name","hf:doc:metadata"),_e(a,"content",Qt),_e($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_e(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_e(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){M(document.head,a),i(e,c,t),i(e,r,t),i(e,m,t),h(y,e,t),i(e,f,t),i(e,P,t),i(e,xe,t),i(e,k,t),i(e,we,t),i(e,B,t),i(e,Me,t),i(e,G,t),i(e,Te,t),i(e,Z,t),i(e,ve,t),i(e,L,t),i(e,ye,t),i(e,W,t),i(e,Pe,t),h(A,e,t),i(e,$e,t),h(j,e,t),i(e,Je,t),h(H,e,t),i(e,Ae,t),i(e,E,t),i(e,je,t),i(e,V,t),i(e,Ue,t),h(X,e,t),i(e,Ce,t),i(e,R,t),i(e,Ie,t),h(Q,e,t),i(e,Se,t),i(e,q,t),i(e,ke,t),h(N,e,t),i(e,Be,t),i(e,Y,t),i(e,Ge,t),h(D,e,t),i(e,Ze,t),i(e,z,t),i(e,Le,t),h(F,e,t),i(e,We,t),h(U,e,t),i(e,He,t),i(e,O,t),i(e,Ee,t),h(K,e,t),i(e,Ve,t),i(e,ee,t),i(e,Xe,t),i(e,te,t),i(e,Re,t),i(e,ne,t),i(e,Qe,t),h(C,e,t),i(e,qe,t),i(e,ie,t),i(e,Ne,t),h(ae,e,t),i(e,Ye,t),i(e,w,t),h(oe,w,null),M(w,Ke),M(w,me),M(w,et),M(w,ce),M(w,tt),M(w,$),h(se,$,null),M($,nt),M($,fe),M($,it),h(I,$,null),M(w,at),M(w,S),h(re,S,null),M(S,ot),M(S,ge),i(e,De,t),h(le,e,t),i(e,ze,t),i(e,ue,t),Fe=!0},p(e,[t]){const T={};t&2&&(T.$$scope={dirty:t,ctx:e}),A.$set(T);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),j.$set(J);const pe={};t&2&&(pe.$$scope={dirty:t,ctx:e}),U.$set(pe);const Ut={};t&2&&(Ut.$$scope={dirty:t,ctx:e}),C.$set(Ut);const Ct={};t&2&&(Ct.$$scope={dirty:t,ctx:e}),I.$set(Ct)},i(e){Fe||(_(y.$$.fragment,e),_(A.$$.fragment,e),_(j.$$.fragment,e),_(H.$$.fragment,e),_(X.$$.fragment,e),_(Q.$$.fragment,e),_(N.$$.fragment,e),_(D.$$.fragment,e),_(F.$$.fragment,e),_(U.$$.fragment,e),_(K.$$.fragment,e),_(C.$$.fragment,e),_(ae.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),_(I.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),Fe=!0)},o(e){b(y.$$.fragment,e),b(A.$$.fragment,e),b(j.$$.fragment,e),b(H.$$.fragment,e),b(X.$$.fragment,e),b(Q.$$.fragment,e),b(N.$$.fragment,e),b(D.$$.fragment,e),b(F.$$.fragment,e),b(U.$$.fragment,e),b(K.$$.fragment,e),b(C.$$.fragment,e),b(ae.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(I.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),Fe=!1},d(e){e&&(n(c),n(r),n(m),n(f),n(P),n(xe),n(k),n(we),n(B),n(Me),n(G),n(Te),n(Z),n(ve),n(L),n(ye),n(W),n(Pe),n($e),n(Je),n(Ae),n(E),n(je),n(V),n(Ue),n(Ce),n(R),n(Ie),n(Se),n(q),n(ke),n(Be),n(Y),n(Ge),n(Ze),n(z),n(Le),n(We),n(He),n(O),n(Ee),n(Ve),n(ee),n(Xe),n(te),n(Re),n(ne),n(Qe),n(qe),n(ie),n(Ne),n(Ye),n(w),n(De),n(ze),n(ue)),n(a),x(y,e),x(A,e),x(j,e),x(H,e),x(X,e),x(Q,e),x(N,e),x(D,e),x(F,e),x(U,e),x(K,e),x(C,e),x(ae,e),x(oe),x(se),x(I),x(re),x(le,e)}}}const Qt='{"title":"PixArt-Σ","local":"pixart-σ","sections":[{"title":"Inference with under 8GB GPU VRAM","local":"inference-with-under-8gb-gpu-vram","sections":[],"depth":2},{"title":"PixArtSigmaPipeline","local":"diffusers.PixArtSigmaPipeline","sections":[],"depth":2}],"depth":1}';function qt(v){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends kt{constructor(a){super(),Bt(this,a,qt,Rt,It,{})}}export{en as component};
