import{s as bi,o as yi,n as V}from"../chunks/scheduler.8c3d61f6.js";import{S as vi,i as Ii,g as l,s as i,r as f,A as wi,h as p,f as o,c as a,j as T,u,x as g,k as C,y as t,a as c,v as h,d as _,t as b,w as y}from"../chunks/index.da70eac4.js";import{T as Et}from"../chunks/Tip.1d9b8c37.js";import{D as J}from"../chunks/Docstring.28bd4ce5.js";import{C as Y}from"../chunks/CodeBlock.a9c4becf.js";import{E as zt}from"../chunks/ExampleCodeBlock.ce69d7b7.js";import{H as ot,E as Ui}from"../chunks/getInferenceSnippets.cd165132.js";function Mi(P){let n,v='For text-to-image we use <code>stabilityai/stable-diffusion-2-1-unclip-small</code> as it was trained on CLIP ViT-L/14 embedding, the same as the Karlo model prior. <a href="https://hf.co/stabilityai/stable-diffusion-2-1-unclip" rel="nofollow">stabilityai/stable-diffusion-2-1-unclip</a> was trained on OpenCLIP ViT-H, so we don’t recommend its use.';return{c(){n=l("p"),n.innerHTML=v},l(d){n=p(d,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ascgy4"&&(n.innerHTML=v)},m(d,m){c(d,n,m)},p:V,d(d){d&&o(n)}}}function $i(P){let n,v='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){n=l("p"),n.innerHTML=v},l(d){n=p(d,"P",{"data-svelte-h":!0}),g(n)!=="svelte-1qn15hi"&&(n.innerHTML=v)},m(d,m){c(d,n,m)},p:V,d(d){d&&o(n)}}}function xi(P){let n,v="Examples:",d,m,I;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZ1c2luZyUyRnN0YWJsZS11bmNsaXAtMi0xLWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTIwJTIwJTIzJTIwVE9ETyUyMHVwZGF0ZSUyMG1vZGVsJTIwcGF0aCUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyYXN0cm9uYXV0X2hvcnNlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_horse.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=i(),f(m.$$.fragment)},l(s){n=p(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),u(m.$$.fragment,s)},m(s,M){c(s,n,M),c(s,d,M),h(m,s,M),I=!0},p:V,i(s){I||(_(m.$$.fragment,s),I=!0)},o(s){b(m.$$.fragment,s),I=!1},d(s){s&&(o(n),o(d)),y(m,s)}}}function Pi(P){let n,v=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=v},l(d){n=p(d,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ackzsn"&&(n.innerHTML=v)},m(d,m){c(d,n,m)},p:V,d(d){d&&o(n)}}}function Ci(P){let n,v="Examples:",d,m,I;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=i(),f(m.$$.fragment)},l(s){n=p(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),u(m.$$.fragment,s)},m(s,M){c(s,n,M),c(s,d,M),h(m,s,M),I=!0},p:V,i(s){I||(_(m.$$.fragment,s),I=!0)},o(s){b(m.$$.fragment,s),I=!1},d(s){s&&(o(n),o(d)),y(m,s)}}}function Ti(P){let n,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=v},l(d){n=p(d,"P",{"data-svelte-h":!0}),g(n)!=="svelte-17p1lpg"&&(n.textContent=v)},m(d,m){c(d,n,m)},p:V,d(d){d&&o(n)}}}function Ji(P){let n,v="Examples:",d,m,I;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=i(),f(m.$$.fragment)},l(s){n=p(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),u(m.$$.fragment,s)},m(s,M){c(s,n,M),c(s,d,M),h(m,s,M),I=!0},p:V,i(s){I||(_(m.$$.fragment,s),I=!0)},o(s){b(m.$$.fragment,s),I=!1},d(s){s&&(o(n),o(d)),y(m,s)}}}function Li(P){let n,v="Examples:",d,m,I;return m=new Y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS11bmNsaXAtc21hbGwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDc2OCUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoaW5pdF9pbWFnZSUyQyUyMHByb21wdCkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(init_image, prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=i(),f(m.$$.fragment)},l(s){n=p(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),u(m.$$.fragment,s)},m(s,M){c(s,n,M),c(s,d,M),h(m,s,M),I=!0},p:V,i(s){I||(_(m.$$.fragment,s),I=!0)},o(s){b(m.$$.fragment,s),I=!1},d(s){s&&(o(n),o(d)),y(m,s)}}}function Zi(P){let n,v=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=v},l(d){n=p(d,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ackzsn"&&(n.innerHTML=v)},m(d,m){c(d,n,m)},p:V,d(d){d&&o(n)}}}function ji(P){let n,v="Examples:",d,m,I;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=i(),f(m.$$.fragment)},l(s){n=p(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),u(m.$$.fragment,s)},m(s,M){c(s,n,M),c(s,d,M),h(m,s,M),I=!0},p:V,i(s){I||(_(m.$$.fragment,s),I=!0)},o(s){b(m.$$.fragment,s),I=!1},d(s){s&&(o(n),o(d)),y(m,s)}}}function Si(P){let n,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=v},l(d){n=p(d,"P",{"data-svelte-h":!0}),g(n)!=="svelte-17p1lpg"&&(n.textContent=v)},m(d,m){c(d,n,m)},p:V,d(d){d&&o(n)}}}function ki(P){let n,v="Examples:",d,m,I;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=i(),f(m.$$.fragment)},l(s){n=p(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),u(m.$$.fragment,s)},m(s,M){c(s,n,M),c(s,d,M),h(m,s,M),I=!0},p:V,i(s){I||(_(m.$$.fragment,s),I=!0)},o(s){b(m.$$.fragment,s),I=!1},d(s){s&&(o(n),o(d)),y(m,s)}}}function Wi(P){let n,v,d,m,I,s,M,Js='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Ft,be,Ls=`Stable unCLIP checkpoints are finetuned from <a href="./stable_diffusion/stable_diffusion_2">Stable Diffusion 2.1</a> checkpoints to condition on CLIP image embeddings.
Stable unCLIP still conditions on text embeddings. Given the two separate conditionings, stable unCLIP can be used
for text guided image variation. When combined with an unCLIP prior, it can also be used for full text to image generation.`,Ht,ye,Zs="The abstract from the paper is:",Yt,ve,js="<em>Contrastive models like CLIP have been shown to learn robust representations of images that capture both semantics and style. To leverage these representations for image generation, we propose a two-stage model: a prior that generates a CLIP image embedding given a text caption, and a decoder that generates an image conditioned on the image embedding. We show that explicitly generating image representations improves image diversity with minimal loss in photorealism and caption similarity. Our decoders conditioned on image representations can also produce variations of an image that preserve both its semantics and style, while varying the non-essential details absent from the image representation. Moreover, the joint embedding space of CLIP enables language-guided image manipulations in a zero-shot fashion. We use diffusion models for the decoder and experiment with both autoregressive and diffusion models for the prior, finding that the latter are computationally more efficient and produce higher-quality samples.</em>",Qt,Ie,Dt,we,Ss="Stable unCLIP takes  <code>noise_level</code> as input during inference which determines how much noise is added to the image embeddings. A higher <code>noise_level</code> increases variation in the final un-noised images. By default, we do not add any additional noise to the image embeddings (<code>noise_level = 0</code>).",At,Ue,qt,Me,ks='Stable unCLIP can be leveraged for text-to-image generation by pipelining it with the prior model of KakaoBrain’s open source DALL-E 2 replication <a href="https://huggingface.co/kakaobrain/karlo-v1-alpha" rel="nofollow">Karlo</a>:',Ot,$e,Kt,Q,en,xe,tn,Pe,nn,Ce,Ws="Optionally, you can also pass a prompt to <code>pipe</code> such as:",sn,Te,an,D,on,Je,rn,w,Le,In,rt,Gs="Pipeline for text-to-image generation using stable unCLIP.",wn,lt,Bs=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Un,pt,Vs="The pipeline also inherits the following loading methods:",Mn,dt,Ns='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',$n,E,Ze,xn,mt,Xs="The call function to the pipeline for generation.",Pn,A,Cn,S,je,Tn,ct,Es=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Jn,q,Ln,O,Zn,K,Se,jn,gt,zs=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Sn,ee,ke,kn,ft,Rs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Wn,te,We,Gn,ut,Fs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Bn,k,Ge,Vn,ht,Hs=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Nn,ne,Xn,se,En,ie,Be,zn,_t,Ys='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Rn,ae,Ve,Fn,bt,Qs="Encodes the prompt into text encoder hidden states.",Hn,L,Ne,Yn,yt,Ds=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,Qn,vt,As="The noise is applied in two ways:",Dn,It,qs="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",An,wt,Os="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",qn,Ut,Ks="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",ln,Xe,pn,U,Ee,On,Mt,ei="Pipeline for text-guided image-to-image generation using stable unCLIP.",Kn,$t,ti=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,es,xt,ni="The pipeline also inherits the following loading methods:",ts,Pt,si='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',ns,z,ze,ss,Ct,ii="The call function to the pipeline for generation.",is,oe,as,W,Re,os,Tt,ai=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,rs,re,ls,le,ps,pe,Fe,ds,Jt,oi=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,ms,de,He,cs,Lt,ri=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,gs,me,Ye,fs,Zt,li=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,us,G,Qe,hs,jt,pi=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,_s,ce,bs,ge,ys,fe,De,vs,St,di='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Is,ue,Ae,ws,kt,mi="Encodes the prompt into text encoder hidden states.",Us,Z,qe,Ms,Wt,ci=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,$s,Gt,gi="The noise is applied in two ways:",xs,Bt,fi="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",Ps,Vt,ui="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",Cs,Nt,hi="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",dn,Oe,mn,R,Ke,Ts,Xt,_i="Output class for image pipelines.",cn,et,gn,Rt,fn;return I=new ot({props:{title:"Stable unCLIP",local:"stable-unclip",headingTag:"h1"}}),Ie=new ot({props:{title:"Tips",local:"tips",headingTag:"h2"}}),Ue=new ot({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h3"}}),$e=new Y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UnCLIPScheduler, DDPMScheduler, StableUnCLIPPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> PriorTransformer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTokenizer, CLIPTextModelWithProjection

prior_model_id = <span class="hljs-string">&quot;kakaobrain/karlo-v1-alpha&quot;</span>
data_type = torch.float16
prior = PriorTransformer.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior&quot;</span>, torch_dtype=data_type)

prior_text_model_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
prior_tokenizer = CLIPTokenizer.from_pretrained(prior_text_model_id)
prior_text_model = CLIPTextModelWithProjection.from_pretrained(prior_text_model_id, torch_dtype=data_type)
prior_scheduler = UnCLIPScheduler.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior_scheduler&quot;</span>)
prior_scheduler = DDPMScheduler.from_config(prior_scheduler.config)

stable_unclip_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>

pipe = StableUnCLIPPipeline.from_pretrained(
    stable_unclip_model_id,
    torch_dtype=data_type,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    prior_tokenizer=prior_tokenizer,
    prior_text_encoder=prior_text_model,
    prior=prior,
    prior_scheduler=prior_scheduler,
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
wave_prompt = <span class="hljs-string">&quot;dramatic wave, the Oceans roar, Strong wave spiral across the oceans as the waves unfurl into roaring crests; perfect wave form; perfect wave shape; dramatic wave shape; wave shape unbelievable; wave; wave shape spectacular&quot;</span>

image = pipe(prompt=wave_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Q=new Et({props:{warning:!0,$$slots:{default:[Mi]},$$scope:{ctx:P}}}),xe=new ot({props:{title:"Text guided Image-to-Image Variation",local:"text-guided-image-to-image-variation",headingTag:"h3"}}),Pe=new Y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLXVuY2xpcCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhdGlvbiUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3RhYmxlX3VuY2xpcCUyRnRhcnNpbGFfZG9fYW1hcmFsLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKGluaXRfaW1hZ2UpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJ2YXJpYXRpb25faW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip&quot;</span>, torch_dtype=torch.float16, variation=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/stable_unclip/tarsila_do_amaral.png&quot;</span>
init_image = load_image(url)

images = pipe(init_image).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;variation_image.png&quot;</span>)`,wrap:!1}}),Te=new Y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShpbml0X2ltYWdlJTJDJTIwcHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

image = pipe(init_image, prompt=prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new Et({props:{$$slots:{default:[$i]},$$scope:{ctx:P}}}),Je=new ot({props:{title:"StableUnCLIPPipeline",local:"diffusers.StableUnCLIPPipeline",headingTag:"h2"}}),Le=new J({props:{name:"class diffusers.StableUnCLIPPipeline",anchor:"diffusers.StableUnCLIPPipeline",parameters:[{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior",val:": PriorTransformer"},{name:"prior_scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"prior_tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen <code>CLIPTextModelWithProjection</code> text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.StableUnCLIPPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Scheduler used in the prior denoising process.`,name:"prior_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen <code>CLIPTextModel</code> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L70"}}),Ze=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"noise_level",val:": int = 0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_latents",val:": typing.Optional[torch.Tensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps in the prior denoising process. More denoising steps usually lead to a
higher quality image at the expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"prior_guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_latents",description:`<strong>prior_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
embedding generation in the prior denoising process. Can be used to tweak the same generation with
different prompts. If not provided, a latents tensor is generated by sampling using the supplied random
<code>generator</code>.`,name:"prior_latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),A=new zt({props:{anchor:"diffusers.StableUnCLIPPipeline.__call__.example",$$slots:{default:[xi]},$$scope:{ctx:P}}}),je=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2002"}}),q=new Et({props:{warning:!0,$$slots:{default:[Pi]},$$scope:{ctx:P}}}),O=new zt({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.example",$$slots:{default:[Ci]},$$scope:{ctx:P}}}),Se=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2042"}}),ke=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2207"}}),We=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2220"}}),Ge=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1941"}}),ne=new Et({props:{warning:!0,$$slots:{default:[Ti]},$$scope:{ctx:P}}}),se=new zt({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Ji]},$$scope:{ctx:P}}}),Be=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1976"}}),Ve=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L297"}}),Ne=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L599"}}),Xe=new ot({props:{title:"StableUnCLIPImg2ImgPipeline",local:"diffusers.StableUnCLIPImg2ImgPipeline",headingTag:"h2"}}),Ee=new J({props:{name:"class diffusers.StableUnCLIPImg2ImgPipeline",anchor:"diffusers.StableUnCLIPImg2ImgPipeline",parameters:[{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
Feature extractor for image pre-processing before being encoded.`,name:"feature_extractor"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
CLIP vision model for encoding images.`,name:"image_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>~transformers.CLIPTokenizer</code>) &#x2014;
A [<code>~transformers.CLIPTokenizer</code>)].`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L81"}}),ze=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__",parameters:[{name:"image",val:": typing.Union[torch.Tensor, PIL.Image.Image] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"noise_level",val:": int = 0"},{name:"image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, either <code>prompt_embeds</code> will be
used or prompt is initialized to <code>&quot;&quot;</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code> or tensor representing an image batch. The image is encoded to its CLIP embedding which the
<code>unet</code> is conditioned on. The image is <em>not</em> encoded by the <code>vae</code> and then used as the latents in the
denoising process like it is in the standard Stable Diffusion text-guided image variation process.`,name:"image"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated CLIP embeddings to condition the <code>unet</code> on. These latents are not used in the denoising
process. If you want to provide pre-generated latents, pass them to <code>__call__</code> as <code>latents</code>.`,name:"image_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L624",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),oe=new zt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.example",$$slots:{default:[Li]},$$scope:{ctx:P}}}),Re=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2002"}}),re=new Et({props:{warning:!0,$$slots:{default:[Zi]},$$scope:{ctx:P}}}),le=new zt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[ji]},$$scope:{ctx:P}}}),Fe=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2042"}}),He=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2207"}}),Ye=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2220"}}),Qe=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1941"}}),ce=new Et({props:{warning:!0,$$slots:{default:[Si]},$$scope:{ctx:P}}}),ge=new zt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ki]},$$scope:{ctx:P}}}),De=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1976"}}),Ae=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L259"}}),qe=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L578"}}),Oe=new ot({props:{title:"ImagePipelineOutput",local:"diffusers.ImagePipelineOutput",headingTag:"h2"}}),Ke=new J({props:{name:"class diffusers.ImagePipelineOutput",anchor:"diffusers.ImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.ImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L118"}}),et=new Ui({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_unclip.md"}}),{c(){n=l("meta"),v=i(),d=l("p"),m=i(),f(I.$$.fragment),s=i(),M=l("div"),M.innerHTML=Js,Ft=i(),be=l("p"),be.innerHTML=Ls,Ht=i(),ye=l("p"),ye.textContent=Zs,Yt=i(),ve=l("p"),ve.innerHTML=js,Qt=i(),f(Ie.$$.fragment),Dt=i(),we=l("p"),we.innerHTML=Ss,At=i(),f(Ue.$$.fragment),qt=i(),Me=l("p"),Me.innerHTML=ks,Ot=i(),f($e.$$.fragment),Kt=i(),f(Q.$$.fragment),en=i(),f(xe.$$.fragment),tn=i(),f(Pe.$$.fragment),nn=i(),Ce=l("p"),Ce.innerHTML=Ws,sn=i(),f(Te.$$.fragment),an=i(),f(D.$$.fragment),on=i(),f(Je.$$.fragment),rn=i(),w=l("div"),f(Le.$$.fragment),In=i(),rt=l("p"),rt.textContent=Gs,wn=i(),lt=l("p"),lt.innerHTML=Bs,Un=i(),pt=l("p"),pt.textContent=Vs,Mn=i(),dt=l("ul"),dt.innerHTML=Ns,$n=i(),E=l("div"),f(Ze.$$.fragment),xn=i(),mt=l("p"),mt.textContent=Xs,Pn=i(),f(A.$$.fragment),Cn=i(),S=l("div"),f(je.$$.fragment),Tn=i(),ct=l("p"),ct.textContent=Es,Jn=i(),f(q.$$.fragment),Ln=i(),f(O.$$.fragment),Zn=i(),K=l("div"),f(Se.$$.fragment),jn=i(),gt=l("p"),gt.innerHTML=zs,Sn=i(),ee=l("div"),f(ke.$$.fragment),kn=i(),ft=l("p"),ft.textContent=Rs,Wn=i(),te=l("div"),f(We.$$.fragment),Gn=i(),ut=l("p"),ut.innerHTML=Fs,Bn=i(),k=l("div"),f(Ge.$$.fragment),Vn=i(),ht=l("p"),ht.innerHTML=Hs,Nn=i(),f(ne.$$.fragment),Xn=i(),f(se.$$.fragment),En=i(),ie=l("div"),f(Be.$$.fragment),zn=i(),_t=l("p"),_t.innerHTML=Ys,Rn=i(),ae=l("div"),f(Ve.$$.fragment),Fn=i(),bt=l("p"),bt.textContent=Qs,Hn=i(),L=l("div"),f(Ne.$$.fragment),Yn=i(),yt=l("p"),yt.innerHTML=Ds,Qn=i(),vt=l("p"),vt.textContent=As,Dn=i(),It=l("ol"),It.innerHTML=qs,An=i(),wt=l("p"),wt.innerHTML=Os,qn=i(),Ut=l("p"),Ut.textContent=Ks,ln=i(),f(Xe.$$.fragment),pn=i(),U=l("div"),f(Ee.$$.fragment),On=i(),Mt=l("p"),Mt.textContent=ei,Kn=i(),$t=l("p"),$t.innerHTML=ti,es=i(),xt=l("p"),xt.textContent=ni,ts=i(),Pt=l("ul"),Pt.innerHTML=si,ns=i(),z=l("div"),f(ze.$$.fragment),ss=i(),Ct=l("p"),Ct.textContent=ii,is=i(),f(oe.$$.fragment),as=i(),W=l("div"),f(Re.$$.fragment),os=i(),Tt=l("p"),Tt.textContent=ai,rs=i(),f(re.$$.fragment),ls=i(),f(le.$$.fragment),ps=i(),pe=l("div"),f(Fe.$$.fragment),ds=i(),Jt=l("p"),Jt.innerHTML=oi,ms=i(),de=l("div"),f(He.$$.fragment),cs=i(),Lt=l("p"),Lt.textContent=ri,gs=i(),me=l("div"),f(Ye.$$.fragment),fs=i(),Zt=l("p"),Zt.innerHTML=li,us=i(),G=l("div"),f(Qe.$$.fragment),hs=i(),jt=l("p"),jt.innerHTML=pi,_s=i(),f(ce.$$.fragment),bs=i(),f(ge.$$.fragment),ys=i(),fe=l("div"),f(De.$$.fragment),vs=i(),St=l("p"),St.innerHTML=di,Is=i(),ue=l("div"),f(Ae.$$.fragment),ws=i(),kt=l("p"),kt.textContent=mi,Us=i(),Z=l("div"),f(qe.$$.fragment),Ms=i(),Wt=l("p"),Wt.innerHTML=ci,$s=i(),Gt=l("p"),Gt.textContent=gi,xs=i(),Bt=l("ol"),Bt.innerHTML=fi,Ps=i(),Vt=l("p"),Vt.innerHTML=ui,Cs=i(),Nt=l("p"),Nt.textContent=hi,dn=i(),f(Oe.$$.fragment),mn=i(),R=l("div"),f(Ke.$$.fragment),Ts=i(),Xt=l("p"),Xt.textContent=_i,cn=i(),f(et.$$.fragment),gn=i(),Rt=l("p"),this.h()},l(e){const r=wi("svelte-u9bgzb",document.head);n=p(r,"META",{name:!0,content:!0}),r.forEach(o),v=a(e),d=p(e,"P",{}),T(d).forEach(o),m=a(e),u(I.$$.fragment,e),s=a(e),M=p(e,"DIV",{class:!0,"data-svelte-h":!0}),g(M)!=="svelte-si9ct8"&&(M.innerHTML=Js),Ft=a(e),be=p(e,"P",{"data-svelte-h":!0}),g(be)!=="svelte-bd6hsa"&&(be.innerHTML=Ls),Ht=a(e),ye=p(e,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-1cwsb16"&&(ye.textContent=Zs),Yt=a(e),ve=p(e,"P",{"data-svelte-h":!0}),g(ve)!=="svelte-ha34c8"&&(ve.innerHTML=js),Qt=a(e),u(Ie.$$.fragment,e),Dt=a(e),we=p(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-ozodyw"&&(we.innerHTML=Ss),At=a(e),u(Ue.$$.fragment,e),qt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-1sz02mh"&&(Me.innerHTML=ks),Ot=a(e),u($e.$$.fragment,e),Kt=a(e),u(Q.$$.fragment,e),en=a(e),u(xe.$$.fragment,e),tn=a(e),u(Pe.$$.fragment,e),nn=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),g(Ce)!=="svelte-1mvqeru"&&(Ce.innerHTML=Ws),sn=a(e),u(Te.$$.fragment,e),an=a(e),u(D.$$.fragment,e),on=a(e),u(Je.$$.fragment,e),rn=a(e),w=p(e,"DIV",{class:!0});var $=T(w);u(Le.$$.fragment,$),In=a($),rt=p($,"P",{"data-svelte-h":!0}),g(rt)!=="svelte-2c89j6"&&(rt.textContent=Gs),wn=a($),lt=p($,"P",{"data-svelte-h":!0}),g(lt)!=="svelte-496sm0"&&(lt.innerHTML=Bs),Un=a($),pt=p($,"P",{"data-svelte-h":!0}),g(pt)!=="svelte-14s6m4u"&&(pt.textContent=Vs),Mn=a($),dt=p($,"UL",{"data-svelte-h":!0}),g(dt)!=="svelte-txtwv6"&&(dt.innerHTML=Ns),$n=a($),E=p($,"DIV",{class:!0});var F=T(E);u(Ze.$$.fragment,F),xn=a(F),mt=p(F,"P",{"data-svelte-h":!0}),g(mt)!=="svelte-50j04k"&&(mt.textContent=Xs),Pn=a(F),u(A.$$.fragment,F),F.forEach(o),Cn=a($),S=p($,"DIV",{class:!0});var N=T(S);u(je.$$.fragment,N),Tn=a(N),ct=p(N,"P",{"data-svelte-h":!0}),g(ct)!=="svelte-10jaql7"&&(ct.textContent=Es),Jn=a(N),u(q.$$.fragment,N),Ln=a(N),u(O.$$.fragment,N),N.forEach(o),Zn=a($),K=p($,"DIV",{class:!0});var tt=T(K);u(Se.$$.fragment,tt),jn=a(tt),gt=p(tt,"P",{"data-svelte-h":!0}),g(gt)!=="svelte-1lh0nh5"&&(gt.innerHTML=zs),tt.forEach(o),Sn=a($),ee=p($,"DIV",{class:!0});var nt=T(ee);u(ke.$$.fragment,nt),kn=a(nt),ft=p(nt,"P",{"data-svelte-h":!0}),g(ft)!=="svelte-14bnrb6"&&(ft.textContent=Rs),nt.forEach(o),Wn=a($),te=p($,"DIV",{class:!0});var st=T(te);u(We.$$.fragment,st),Gn=a(st),ut=p(st,"P",{"data-svelte-h":!0}),g(ut)!=="svelte-1s3c06i"&&(ut.innerHTML=Fs),st.forEach(o),Bn=a($),k=p($,"DIV",{class:!0});var X=T(k);u(Ge.$$.fragment,X),Vn=a(X),ht=p(X,"P",{"data-svelte-h":!0}),g(ht)!=="svelte-e03q3e"&&(ht.innerHTML=Hs),Nn=a(X),u(ne.$$.fragment,X),Xn=a(X),u(se.$$.fragment,X),X.forEach(o),En=a($),ie=p($,"DIV",{class:!0});var it=T(ie);u(Be.$$.fragment,it),zn=a(it),_t=p(it,"P",{"data-svelte-h":!0}),g(_t)!=="svelte-1vfte1e"&&(_t.innerHTML=Ys),it.forEach(o),Rn=a($),ae=p($,"DIV",{class:!0});var at=T(ae);u(Ve.$$.fragment,at),Fn=a(at),bt=p(at,"P",{"data-svelte-h":!0}),g(bt)!=="svelte-16q0ax1"&&(bt.textContent=Qs),at.forEach(o),Hn=a($),L=p($,"DIV",{class:!0});var j=T(L);u(Ne.$$.fragment,j),Yn=a(j),yt=p(j,"P",{"data-svelte-h":!0}),g(yt)!=="svelte-1e71opl"&&(yt.innerHTML=Ds),Qn=a(j),vt=p(j,"P",{"data-svelte-h":!0}),g(vt)!=="svelte-acyrt"&&(vt.textContent=As),Dn=a(j),It=p(j,"OL",{"data-svelte-h":!0}),g(It)!=="svelte-114uhci"&&(It.innerHTML=qs),An=a(j),wt=p(j,"P",{"data-svelte-h":!0}),g(wt)!=="svelte-46dthp"&&(wt.innerHTML=Os),qn=a(j),Ut=p(j,"P",{"data-svelte-h":!0}),g(Ut)!=="svelte-4ngutd"&&(Ut.textContent=Ks),j.forEach(o),$.forEach(o),ln=a(e),u(Xe.$$.fragment,e),pn=a(e),U=p(e,"DIV",{class:!0});var x=T(U);u(Ee.$$.fragment,x),On=a(x),Mt=p(x,"P",{"data-svelte-h":!0}),g(Mt)!=="svelte-y15i80"&&(Mt.textContent=ei),Kn=a(x),$t=p(x,"P",{"data-svelte-h":!0}),g($t)!=="svelte-496sm0"&&($t.innerHTML=ti),es=a(x),xt=p(x,"P",{"data-svelte-h":!0}),g(xt)!=="svelte-14s6m4u"&&(xt.textContent=ni),ts=a(x),Pt=p(x,"UL",{"data-svelte-h":!0}),g(Pt)!=="svelte-txtwv6"&&(Pt.innerHTML=si),ns=a(x),z=p(x,"DIV",{class:!0});var H=T(z);u(ze.$$.fragment,H),ss=a(H),Ct=p(H,"P",{"data-svelte-h":!0}),g(Ct)!=="svelte-50j04k"&&(Ct.textContent=ii),is=a(H),u(oe.$$.fragment,H),H.forEach(o),as=a(x),W=p(x,"DIV",{class:!0});var he=T(W);u(Re.$$.fragment,he),os=a(he),Tt=p(he,"P",{"data-svelte-h":!0}),g(Tt)!=="svelte-10jaql7"&&(Tt.textContent=ai),rs=a(he),u(re.$$.fragment,he),ls=a(he),u(le.$$.fragment,he),he.forEach(o),ps=a(x),pe=p(x,"DIV",{class:!0});var un=T(pe);u(Fe.$$.fragment,un),ds=a(un),Jt=p(un,"P",{"data-svelte-h":!0}),g(Jt)!=="svelte-1lh0nh5"&&(Jt.innerHTML=oi),un.forEach(o),ms=a(x),de=p(x,"DIV",{class:!0});var hn=T(de);u(He.$$.fragment,hn),cs=a(hn),Lt=p(hn,"P",{"data-svelte-h":!0}),g(Lt)!=="svelte-14bnrb6"&&(Lt.textContent=ri),hn.forEach(o),gs=a(x),me=p(x,"DIV",{class:!0});var _n=T(me);u(Ye.$$.fragment,_n),fs=a(_n),Zt=p(_n,"P",{"data-svelte-h":!0}),g(Zt)!=="svelte-1s3c06i"&&(Zt.innerHTML=li),_n.forEach(o),us=a(x),G=p(x,"DIV",{class:!0});var _e=T(G);u(Qe.$$.fragment,_e),hs=a(_e),jt=p(_e,"P",{"data-svelte-h":!0}),g(jt)!=="svelte-e03q3e"&&(jt.innerHTML=pi),_s=a(_e),u(ce.$$.fragment,_e),bs=a(_e),u(ge.$$.fragment,_e),_e.forEach(o),ys=a(x),fe=p(x,"DIV",{class:!0});var bn=T(fe);u(De.$$.fragment,bn),vs=a(bn),St=p(bn,"P",{"data-svelte-h":!0}),g(St)!=="svelte-1vfte1e"&&(St.innerHTML=di),bn.forEach(o),Is=a(x),ue=p(x,"DIV",{class:!0});var yn=T(ue);u(Ae.$$.fragment,yn),ws=a(yn),kt=p(yn,"P",{"data-svelte-h":!0}),g(kt)!=="svelte-16q0ax1"&&(kt.textContent=mi),yn.forEach(o),Us=a(x),Z=p(x,"DIV",{class:!0});var B=T(Z);u(qe.$$.fragment,B),Ms=a(B),Wt=p(B,"P",{"data-svelte-h":!0}),g(Wt)!=="svelte-1e71opl"&&(Wt.innerHTML=ci),$s=a(B),Gt=p(B,"P",{"data-svelte-h":!0}),g(Gt)!=="svelte-acyrt"&&(Gt.textContent=gi),xs=a(B),Bt=p(B,"OL",{"data-svelte-h":!0}),g(Bt)!=="svelte-114uhci"&&(Bt.innerHTML=fi),Ps=a(B),Vt=p(B,"P",{"data-svelte-h":!0}),g(Vt)!=="svelte-46dthp"&&(Vt.innerHTML=ui),Cs=a(B),Nt=p(B,"P",{"data-svelte-h":!0}),g(Nt)!=="svelte-4ngutd"&&(Nt.textContent=hi),B.forEach(o),x.forEach(o),dn=a(e),u(Oe.$$.fragment,e),mn=a(e),R=p(e,"DIV",{class:!0});var vn=T(R);u(Ke.$$.fragment,vn),Ts=a(vn),Xt=p(vn,"P",{"data-svelte-h":!0}),g(Xt)!=="svelte-19wetgi"&&(Xt.textContent=_i),vn.forEach(o),cn=a(e),u(et.$$.fragment,e),gn=a(e),Rt=p(e,"P",{}),T(Rt).forEach(o),this.h()},h(){C(n,"name","hf:doc:metadata"),C(n,"content",Gi),C(M,"class","flex flex-wrap space-x-1"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,n),c(e,v,r),c(e,d,r),c(e,m,r),h(I,e,r),c(e,s,r),c(e,M,r),c(e,Ft,r),c(e,be,r),c(e,Ht,r),c(e,ye,r),c(e,Yt,r),c(e,ve,r),c(e,Qt,r),h(Ie,e,r),c(e,Dt,r),c(e,we,r),c(e,At,r),h(Ue,e,r),c(e,qt,r),c(e,Me,r),c(e,Ot,r),h($e,e,r),c(e,Kt,r),h(Q,e,r),c(e,en,r),h(xe,e,r),c(e,tn,r),h(Pe,e,r),c(e,nn,r),c(e,Ce,r),c(e,sn,r),h(Te,e,r),c(e,an,r),h(D,e,r),c(e,on,r),h(Je,e,r),c(e,rn,r),c(e,w,r),h(Le,w,null),t(w,In),t(w,rt),t(w,wn),t(w,lt),t(w,Un),t(w,pt),t(w,Mn),t(w,dt),t(w,$n),t(w,E),h(Ze,E,null),t(E,xn),t(E,mt),t(E,Pn),h(A,E,null),t(w,Cn),t(w,S),h(je,S,null),t(S,Tn),t(S,ct),t(S,Jn),h(q,S,null),t(S,Ln),h(O,S,null),t(w,Zn),t(w,K),h(Se,K,null),t(K,jn),t(K,gt),t(w,Sn),t(w,ee),h(ke,ee,null),t(ee,kn),t(ee,ft),t(w,Wn),t(w,te),h(We,te,null),t(te,Gn),t(te,ut),t(w,Bn),t(w,k),h(Ge,k,null),t(k,Vn),t(k,ht),t(k,Nn),h(ne,k,null),t(k,Xn),h(se,k,null),t(w,En),t(w,ie),h(Be,ie,null),t(ie,zn),t(ie,_t),t(w,Rn),t(w,ae),h(Ve,ae,null),t(ae,Fn),t(ae,bt),t(w,Hn),t(w,L),h(Ne,L,null),t(L,Yn),t(L,yt),t(L,Qn),t(L,vt),t(L,Dn),t(L,It),t(L,An),t(L,wt),t(L,qn),t(L,Ut),c(e,ln,r),h(Xe,e,r),c(e,pn,r),c(e,U,r),h(Ee,U,null),t(U,On),t(U,Mt),t(U,Kn),t(U,$t),t(U,es),t(U,xt),t(U,ts),t(U,Pt),t(U,ns),t(U,z),h(ze,z,null),t(z,ss),t(z,Ct),t(z,is),h(oe,z,null),t(U,as),t(U,W),h(Re,W,null),t(W,os),t(W,Tt),t(W,rs),h(re,W,null),t(W,ls),h(le,W,null),t(U,ps),t(U,pe),h(Fe,pe,null),t(pe,ds),t(pe,Jt),t(U,ms),t(U,de),h(He,de,null),t(de,cs),t(de,Lt),t(U,gs),t(U,me),h(Ye,me,null),t(me,fs),t(me,Zt),t(U,us),t(U,G),h(Qe,G,null),t(G,hs),t(G,jt),t(G,_s),h(ce,G,null),t(G,bs),h(ge,G,null),t(U,ys),t(U,fe),h(De,fe,null),t(fe,vs),t(fe,St),t(U,Is),t(U,ue),h(Ae,ue,null),t(ue,ws),t(ue,kt),t(U,Us),t(U,Z),h(qe,Z,null),t(Z,Ms),t(Z,Wt),t(Z,$s),t(Z,Gt),t(Z,xs),t(Z,Bt),t(Z,Ps),t(Z,Vt),t(Z,Cs),t(Z,Nt),c(e,dn,r),h(Oe,e,r),c(e,mn,r),c(e,R,r),h(Ke,R,null),t(R,Ts),t(R,Xt),c(e,cn,r),h(et,e,r),c(e,gn,r),c(e,Rt,r),fn=!0},p(e,[r]){const $={};r&2&&($.$$scope={dirty:r,ctx:e}),Q.$set($);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),D.$set(F);const N={};r&2&&(N.$$scope={dirty:r,ctx:e}),A.$set(N);const tt={};r&2&&(tt.$$scope={dirty:r,ctx:e}),q.$set(tt);const nt={};r&2&&(nt.$$scope={dirty:r,ctx:e}),O.$set(nt);const st={};r&2&&(st.$$scope={dirty:r,ctx:e}),ne.$set(st);const X={};r&2&&(X.$$scope={dirty:r,ctx:e}),se.$set(X);const it={};r&2&&(it.$$scope={dirty:r,ctx:e}),oe.$set(it);const at={};r&2&&(at.$$scope={dirty:r,ctx:e}),re.$set(at);const j={};r&2&&(j.$$scope={dirty:r,ctx:e}),le.$set(j);const x={};r&2&&(x.$$scope={dirty:r,ctx:e}),ce.$set(x);const H={};r&2&&(H.$$scope={dirty:r,ctx:e}),ge.$set(H)},i(e){fn||(_(I.$$.fragment,e),_(Ie.$$.fragment,e),_(Ue.$$.fragment,e),_($e.$$.fragment,e),_(Q.$$.fragment,e),_(xe.$$.fragment,e),_(Pe.$$.fragment,e),_(Te.$$.fragment,e),_(D.$$.fragment,e),_(Je.$$.fragment,e),_(Le.$$.fragment,e),_(Ze.$$.fragment,e),_(A.$$.fragment,e),_(je.$$.fragment,e),_(q.$$.fragment,e),_(O.$$.fragment,e),_(Se.$$.fragment,e),_(ke.$$.fragment,e),_(We.$$.fragment,e),_(Ge.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(Be.$$.fragment,e),_(Ve.$$.fragment,e),_(Ne.$$.fragment,e),_(Xe.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(oe.$$.fragment,e),_(Re.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(Fe.$$.fragment,e),_(He.$$.fragment,e),_(Ye.$$.fragment,e),_(Qe.$$.fragment,e),_(ce.$$.fragment,e),_(ge.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),_(qe.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),fn=!0)},o(e){b(I.$$.fragment,e),b(Ie.$$.fragment,e),b(Ue.$$.fragment,e),b($e.$$.fragment,e),b(Q.$$.fragment,e),b(xe.$$.fragment,e),b(Pe.$$.fragment,e),b(Te.$$.fragment,e),b(D.$$.fragment,e),b(Je.$$.fragment,e),b(Le.$$.fragment,e),b(Ze.$$.fragment,e),b(A.$$.fragment,e),b(je.$$.fragment,e),b(q.$$.fragment,e),b(O.$$.fragment,e),b(Se.$$.fragment,e),b(ke.$$.fragment,e),b(We.$$.fragment,e),b(Ge.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(Be.$$.fragment,e),b(Ve.$$.fragment,e),b(Ne.$$.fragment,e),b(Xe.$$.fragment,e),b(Ee.$$.fragment,e),b(ze.$$.fragment,e),b(oe.$$.fragment,e),b(Re.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(Fe.$$.fragment,e),b(He.$$.fragment,e),b(Ye.$$.fragment,e),b(Qe.$$.fragment,e),b(ce.$$.fragment,e),b(ge.$$.fragment,e),b(De.$$.fragment,e),b(Ae.$$.fragment,e),b(qe.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),fn=!1},d(e){e&&(o(v),o(d),o(m),o(s),o(M),o(Ft),o(be),o(Ht),o(ye),o(Yt),o(ve),o(Qt),o(Dt),o(we),o(At),o(qt),o(Me),o(Ot),o(Kt),o(en),o(tn),o(nn),o(Ce),o(sn),o(an),o(on),o(rn),o(w),o(ln),o(pn),o(U),o(dn),o(mn),o(R),o(cn),o(gn),o(Rt)),o(n),y(I,e),y(Ie,e),y(Ue,e),y($e,e),y(Q,e),y(xe,e),y(Pe,e),y(Te,e),y(D,e),y(Je,e),y(Le),y(Ze),y(A),y(je),y(q),y(O),y(Se),y(ke),y(We),y(Ge),y(ne),y(se),y(Be),y(Ve),y(Ne),y(Xe,e),y(Ee),y(ze),y(oe),y(Re),y(re),y(le),y(Fe),y(He),y(Ye),y(Qe),y(ce),y(ge),y(De),y(Ae),y(qe),y(Oe,e),y(Ke),y(et,e)}}}const Gi='{"title":"Stable unCLIP","local":"stable-unclip","sections":[{"title":"Tips","local":"tips","sections":[{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":3},{"title":"Text guided Image-to-Image Variation","local":"text-guided-image-to-image-variation","sections":[],"depth":3}],"depth":2},{"title":"StableUnCLIPPipeline","local":"diffusers.StableUnCLIPPipeline","sections":[],"depth":2},{"title":"StableUnCLIPImg2ImgPipeline","local":"diffusers.StableUnCLIPImg2ImgPipeline","sections":[],"depth":2},{"title":"ImagePipelineOutput","local":"diffusers.ImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function Bi(P){return yi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hi extends vi{constructor(n){super(),Ii(this,n,Bi,Wi,bi,{})}}export{Hi as component};
