import{s as Se,o as De,n as Ne}from"../chunks/scheduler.8c3d61f6.js";import{S as Ke,i as Oe,g as o,s,r as u,A as et,h as p,f as n,c as a,j as Ye,u as m,x as r,k as Pe,y as tt,a as i,v as c,d,t as y,w as M}from"../chunks/index.da70eac4.js";import{T as Le}from"../chunks/Tip.1d9b8c37.js";import{C as S}from"../chunks/CodeBlock.a9c4becf.js";import{H as D,E as nt}from"../chunks/getInferenceSnippets.cd165132.js";function it(L){let l,h='These <code>quant_kwargs</code> arguments are different for each backend. Refer to the <a href="../api/quantization">Quantization API</a> docs to view the arguments for each backend.';return{c(){l=o("p"),l.innerHTML=h},l(f){l=p(f,"P",{"data-svelte-h":!0}),r(l)!=="svelte-195iiez"&&(l.innerHTML=h)},m(f,w){i(f,l,w)},p:Ne,d(f){f&&n(l)}}}function st(L){let l,h='Use the <a href="#basic-quantization">basic quantization</a> method above if you don’t want to manage these distinct imports or aren’t sure where each pipeline component comes from.';return{c(){l=o("p"),l.innerHTML=h},l(f){l=p(f,"P",{"data-svelte-h":!0}),r(l)!=="svelte-1dohkit"&&(l.innerHTML=h)},m(f,w){i(f,l,w)},p:Ne,d(f){f&&n(l)}}}function at(L){let l,h,f,w,T,K,J,qe="Quantization focuses on representing data with fewer bits while also trying to preserve the precision of the original data. This often means converting a data type to represent the same information with fewer bits. For example, if your model weights are stored as 32-bit floating points and they’re quantized to 16-bit floating points, this halves the model size which makes it easier to store and reduces memory usage. Lower precision can also speedup inference because it takes less time to perform calculations with fewer bits.",O,U,_e='Diffusers supports multiple quantization backends to make large diffusion models like <a href="../api/pipelines/flux">Flux</a> more accessible. This guide shows how to use the <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> class to quantize a pipeline during its initialization from a pretrained or non-quantized checkpoint.',ee,C,te,z,$e='There are two ways to use <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> depending on how much customization you want to apply to the quantization configuration.',ne,j,Be="<li>for basic use cases, define the <code>quant_backend</code>, <code>quant_kwargs</code>, and <code>components_to_quantize</code> arguments</li> <li>for granular quantization control, define a <code>quant_mapping</code> that provides the quantization configuration for individual model components</li>",ie,Z,se,q,ve='Initialize <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> with the following parameters.',ae,_,ke="<li><code>quant_backend</code> specifies which quantization backend to use. Currently supported backends include: <code>bitsandbytes_4bit</code>, <code>bitsandbytes_8bit</code>, <code>gguf</code>, <code>quanto</code>, and <code>torchao</code>.</li> <li><code>quant_kwargs</code> specifies the quantization arguments to use.</li>",le,b,oe,$,Ge='<li><p><code>components_to_quantize</code> specifies which component(s) of the pipeline to quantize. Typically, you should quantize the most compute intensive components like the transformer. The text encoder is another component to consider quantizing if a pipeline has more than one such as <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a>. The example below quantizes the T5 text encoder in <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> while keeping the CLIP model intact.</p> <p><code>components_to_quantize</code> accepts either a list for multiple models or a string for a single model.</p></li>',pe,B,Ie='The example below loads the bitsandbytes backend with the following arguments from <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>, <code>load_in_4bit</code>, <code>bnb_4bit_quant_type</code>, and <code>bnb_4bit_compute_dtype</code>.',re,v,fe,k,Qe='Pass the <code>pipeline_quant_config</code> to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to quantize the pipeline.',ue,G,me,I,ce,Q,We="The <code>quant_mapping</code> argument provides more options for how to quantize each individual component in a pipeline, like combining different quantization backends.",de,W,Xe='Initialize <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> and pass a <code>quant_mapping</code> to it. The <code>quant_mapping</code> allows you to specify the quantization options for each component in the pipeline such as the transformer and text encoder.',ye,X,Re='The example below uses two quantization backends, <a href="/docs/diffusers/main/en/api/quantization#diffusers.QuantoConfig">QuantoConfig</a> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a>, for the transformer and text encoder.',Me,R,he,F,Fe='There is a separate bitsandbytes backend in <a href="https://huggingface.co/docs/transformers/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">Transformers</a>. You need to import and use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> for components that come from Transformers. For example, <code>text_encoder_2</code> in <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> is a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a> from Transformers so you need to use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> instead of <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">diffusers.BitsAndBytesConfig</a>.',we,g,be,x,ge,A,xe='Pass the <code>pipeline_quant_config</code> to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to quantize the pipeline.',Te,H,Je,E,Ue,V,Ae="Check out the resources below to learn more about quantization.",Ce,Y,He='<li><p>If you are new to quantization, we recommend checking out the following beginner-friendly courses in collaboration with DeepLearning.AI.</p> <ul><li><a href="https://www.deeplearning.ai/short-courses/quantization-fundamentals-with-hugging-face/" rel="nofollow">Quantization Fundamentals with Hugging Face</a></li> <li><a href="https://www.deeplearning.ai/short-courses/quantization-in-depth/" rel="nofollow">Quantization in Depth</a></li></ul></li> <li><p>Refer to the <a href="https://huggingface.co/docs/transformers/main/en/quantization/contribute" rel="nofollow">Contribute new quantization method guide</a> if you’re interested in adding a new quantization method.</p></li> <li><p>The Transformers quantization <a href="https://huggingface.co/docs/transformers/quantization/overview#when-to-use-what" rel="nofollow">Overview</a> provides an overview of the pros and cons of different quantization backends.</p></li> <li><p>Read the <a href="https://huggingface.co/blog/diffusers-quantization" rel="nofollow">Exploring Quantization Backends in Diffusers</a> blog post for a brief introduction to each quantization backend, how to choose a backend, and combining quantization with other memory optimizations.</p></li>',ze,P,je,N,Ze;return T=new D({props:{title:"Getting started",local:"getting-started",headingTag:"h1"}}),C=new D({props:{title:"Pipeline-level quantization",local:"pipeline-level-quantization",headingTag:"h2"}}),Z=new D({props:{title:"Basic quantization",local:"basic-quantization",headingTag:"h3"}}),b=new Le({props:{warning:!1,$$slots:{default:[it]},$$scope:{ctx:L}}}),v=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X2JhY2tlbmQlM0QlMjJiaXRzYW5kYnl0ZXNfNGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50X2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fNGJpdCUyMiUzQSUyMFRydWUlMkMlMjAlMjJibmJfNGJpdF9xdWFudF90eXBlJTIyJTNBJTIwJTIybmY0JTIyJTJDJTIwJTIyYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUyMiUzQSUyMHRvcmNoLmJmbG9hdDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwY29tcG9uZW50c190b19xdWFudGl6ZSUzRCU1QiUyMnRyYW5zZm9ybWVyJTIyJTJDJTIwJTIydGV4dF9lbmNvZGVyXzIlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)`,wrap:!1}}),G=new S({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIycGhvdG8lMjBvZiUyMGElMjBjdXRlJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(<span class="hljs-string">&quot;photo of a cute dog&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),I=new D({props:{title:"Advanced quantization",local:"advanced-quantization",headingTag:"h3"}}),R=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMucXVhbnRpemF0aW9uX2NvbmZpZyUyMGltcG9ydCUyMFF1YW50b0NvbmZpZyUwQWZyb20lMjBkaWZmdXNlcnMucXVhbnRpemVycyUyMGltcG9ydCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcGlwZWxpbmVfcXVhbnRfY29uZmlnJTIwJTNEJTIwUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcXVhbnRfbWFwcGluZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyJTIyJTNBJTIwUXVhbnRvQ29uZmlnKHdlaWdodHNfZHR5cGUlM0QlMjJpbnQ4JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> diffusers.quantizers.quantization_config <span class="hljs-keyword">import</span> QuantoConfig
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={
        <span class="hljs-string">&quot;transformer&quot;</span>: QuantoConfig(weights_dtype=<span class="hljs-string">&quot;int8&quot;</span>),
        <span class="hljs-string">&quot;text_encoder_2&quot;</span>: TransformersBitsAndBytesConfig(
            load_in_4bit=<span class="hljs-literal">True</span>, compute_dtype=torch.bfloat16
        ),
    }
)`,wrap:!1}}),g=new Le({props:{warning:!1,$$slots:{default:[st]},$$scope:{ctx:L}}}),x=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMjBhcyUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X21hcHBpbmclM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lciUyMiUzQSUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={
        <span class="hljs-string">&quot;transformer&quot;</span>: DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16),
        <span class="hljs-string">&quot;text_encoder_2&quot;</span>: TransformersBitsAndBytesConfig(
            load_in_4bit=<span class="hljs-literal">True</span>, compute_dtype=torch.bfloat16
        ),
    }
)`,wrap:!1}}),H=new S({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIycGhvdG8lMjBvZiUyMGElMjBjdXRlJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(<span class="hljs-string">&quot;photo of a cute dog&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),E=new D({props:{title:"Resources",local:"resources",headingTag:"h2"}}),P=new nt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/overview.md"}}),{c(){l=o("meta"),h=s(),f=o("p"),w=s(),u(T.$$.fragment),K=s(),J=o("p"),J.textContent=qe,O=s(),U=o("p"),U.innerHTML=_e,ee=s(),u(C.$$.fragment),te=s(),z=o("p"),z.innerHTML=$e,ne=s(),j=o("ul"),j.innerHTML=Be,ie=s(),u(Z.$$.fragment),se=s(),q=o("p"),q.innerHTML=ve,ae=s(),_=o("ul"),_.innerHTML=ke,le=s(),u(b.$$.fragment),oe=s(),$=o("ul"),$.innerHTML=Ge,pe=s(),B=o("p"),B.innerHTML=Ie,re=s(),u(v.$$.fragment),fe=s(),k=o("p"),k.innerHTML=Qe,ue=s(),u(G.$$.fragment),me=s(),u(I.$$.fragment),ce=s(),Q=o("p"),Q.innerHTML=We,de=s(),W=o("p"),W.innerHTML=Xe,ye=s(),X=o("p"),X.innerHTML=Re,Me=s(),u(R.$$.fragment),he=s(),F=o("p"),F.innerHTML=Fe,we=s(),u(g.$$.fragment),be=s(),u(x.$$.fragment),ge=s(),A=o("p"),A.innerHTML=xe,Te=s(),u(H.$$.fragment),Je=s(),u(E.$$.fragment),Ue=s(),V=o("p"),V.textContent=Ae,Ce=s(),Y=o("ul"),Y.innerHTML=He,ze=s(),u(P.$$.fragment),je=s(),N=o("p"),this.h()},l(e){const t=et("svelte-u9bgzb",document.head);l=p(t,"META",{name:!0,content:!0}),t.forEach(n),h=a(e),f=p(e,"P",{}),Ye(f).forEach(n),w=a(e),m(T.$$.fragment,e),K=a(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-16bsuce"&&(J.textContent=qe),O=a(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-6eg90x"&&(U.innerHTML=_e),ee=a(e),m(C.$$.fragment,e),te=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-2kbfj0"&&(z.innerHTML=$e),ne=a(e),j=p(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1xtak7u"&&(j.innerHTML=Be),ie=a(e),m(Z.$$.fragment,e),se=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-11lseqg"&&(q.innerHTML=ve),ae=a(e),_=p(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-10xkd3n"&&(_.innerHTML=ke),le=a(e),m(b.$$.fragment,e),oe=a(e),$=p(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-qn9gg1"&&($.innerHTML=Ge),pe=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1xwpu7e"&&(B.innerHTML=Ie),re=a(e),m(v.$$.fragment,e),fe=a(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-3c78ko"&&(k.innerHTML=Qe),ue=a(e),m(G.$$.fragment,e),me=a(e),m(I.$$.fragment,e),ce=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-s8jyg6"&&(Q.innerHTML=We),de=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1bi47yb"&&(W.innerHTML=Xe),ye=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-g00viz"&&(X.innerHTML=Re),Me=a(e),m(R.$$.fragment,e),he=a(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1072co4"&&(F.innerHTML=Fe),we=a(e),m(g.$$.fragment,e),be=a(e),m(x.$$.fragment,e),ge=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-3c78ko"&&(A.innerHTML=xe),Te=a(e),m(H.$$.fragment,e),Je=a(e),m(E.$$.fragment,e),Ue=a(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-kva6dz"&&(V.textContent=Ae),Ce=a(e),Y=p(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-yr6gzk"&&(Y.innerHTML=He),ze=a(e),m(P.$$.fragment,e),je=a(e),N=p(e,"P",{}),Ye(N).forEach(n),this.h()},h(){Pe(l,"name","hf:doc:metadata"),Pe(l,"content",lt)},m(e,t){tt(document.head,l),i(e,h,t),i(e,f,t),i(e,w,t),c(T,e,t),i(e,K,t),i(e,J,t),i(e,O,t),i(e,U,t),i(e,ee,t),c(C,e,t),i(e,te,t),i(e,z,t),i(e,ne,t),i(e,j,t),i(e,ie,t),c(Z,e,t),i(e,se,t),i(e,q,t),i(e,ae,t),i(e,_,t),i(e,le,t),c(b,e,t),i(e,oe,t),i(e,$,t),i(e,pe,t),i(e,B,t),i(e,re,t),c(v,e,t),i(e,fe,t),i(e,k,t),i(e,ue,t),c(G,e,t),i(e,me,t),c(I,e,t),i(e,ce,t),i(e,Q,t),i(e,de,t),i(e,W,t),i(e,ye,t),i(e,X,t),i(e,Me,t),c(R,e,t),i(e,he,t),i(e,F,t),i(e,we,t),c(g,e,t),i(e,be,t),c(x,e,t),i(e,ge,t),i(e,A,t),i(e,Te,t),c(H,e,t),i(e,Je,t),c(E,e,t),i(e,Ue,t),i(e,V,t),i(e,Ce,t),i(e,Y,t),i(e,ze,t),c(P,e,t),i(e,je,t),i(e,N,t),Ze=!0},p(e,[t]){const Ee={};t&2&&(Ee.$$scope={dirty:t,ctx:e}),b.$set(Ee);const Ve={};t&2&&(Ve.$$scope={dirty:t,ctx:e}),g.$set(Ve)},i(e){Ze||(d(T.$$.fragment,e),d(C.$$.fragment,e),d(Z.$$.fragment,e),d(b.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(I.$$.fragment,e),d(R.$$.fragment,e),d(g.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),Ze=!0)},o(e){y(T.$$.fragment,e),y(C.$$.fragment,e),y(Z.$$.fragment,e),y(b.$$.fragment,e),y(v.$$.fragment,e),y(G.$$.fragment,e),y(I.$$.fragment,e),y(R.$$.fragment,e),y(g.$$.fragment,e),y(x.$$.fragment,e),y(H.$$.fragment,e),y(E.$$.fragment,e),y(P.$$.fragment,e),Ze=!1},d(e){e&&(n(h),n(f),n(w),n(K),n(J),n(O),n(U),n(ee),n(te),n(z),n(ne),n(j),n(ie),n(se),n(q),n(ae),n(_),n(le),n(oe),n($),n(pe),n(B),n(re),n(fe),n(k),n(ue),n(me),n(ce),n(Q),n(de),n(W),n(ye),n(X),n(Me),n(he),n(F),n(we),n(be),n(ge),n(A),n(Te),n(Je),n(Ue),n(V),n(Ce),n(Y),n(ze),n(je),n(N)),n(l),M(T,e),M(C,e),M(Z,e),M(b,e),M(v,e),M(G,e),M(I,e),M(R,e),M(g,e),M(x,e),M(H,e),M(E,e),M(P,e)}}}const lt='{"title":"Getting started","local":"getting-started","sections":[{"title":"Pipeline-level quantization","local":"pipeline-level-quantization","sections":[{"title":"Basic quantization","local":"basic-quantization","sections":[],"depth":3},{"title":"Advanced quantization","local":"advanced-quantization","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ot(L){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Ke{constructor(l){super(),Oe(this,l,ot,at,Se,{})}}export{ct as component};
