import{s as Re,o as Fe,n as xe}from"../chunks/scheduler.8c3d61f6.js";import{S as Ee,i as Ve,g as l,s,r as f,A as Ae,h as o,f as n,c as a,j as We,u,x as r,k as Xe,y as He,a as i,v as m,d as c,t as d,w as y}from"../chunks/index.da70eac4.js";import{T as Ye}from"../chunks/Tip.1d9b8c37.js";import{C as Y}from"../chunks/CodeBlock.a9c4becf.js";import{H as P,E as Pe}from"../chunks/getInferenceSnippets.a8672208.js";function Ne(N){let p,w='Use the <a href="#simple-quantization">simple quantization</a> method above if you don’t want to manage these distinct imports or aren’t sure where each pipeline component comes from.';return{c(){p=l("p"),p.innerHTML=w},l(M){p=o(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1nteivd"&&(p.innerHTML=w)},m(M,A){i(M,p,A)},p:xe,d(M){M&&n(p)}}}function Le(N){let p,w,M,A,b,L,g,Te="Quantization focuses on representing data with fewer bits while also trying to preserve the precision of the original data. This often means converting a data type to represent the same information with fewer bits. For example, if your model weights are stored as 32-bit floating points and they’re quantized to 16-bit floating points, this halves the model size which makes it easier to store and reduces memory usage. Lower precision can also speedup inference because it takes less time to perform calculations with fewer bits.",S,J,Ue='Diffusers supports multiple quantization backends to make large diffusion models like <a href="../api/pipelines/flux">Flux</a> more accessible. This guide shows how to use the <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> class to quantize a pipeline during its initialization from a pretrained or non-quantized checkpoint.',D,T,K,U,Ce='There are two ways you can use <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> depending on the level of control you want over the quantization specifications of each model in the pipeline.',O,C,ze="<li>for more basic and simple use cases, you only need to define the <code>quant_backend</code>, <code>quant_kwargs</code>, and <code>components_to_quantize</code></li> <li>for more granular quantization control, provide a <code>quant_mapping</code> that provides the quantization specifications for the individual model components</li>",ee,z,te,j,je='Initialize <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> with the following parameters.',ne,Z,Ze='<li><code>quant_backend</code> specifies which quantization backend to use. Currently supported backends include: <code>bitsandbytes_4bit</code>, <code>bitsandbytes_8bit</code>, <code>gguf</code>, <code>quanto</code>, and <code>torchao</code>.</li> <li><code>quant_kwargs</code> contains the specific quantization arguments to use.</li> <li><code>components_to_quantize</code> specifies which components of the pipeline to quantize. Typically, you should quantize the most compute intensive components like the transformer. The text encoder is another component to consider quantizing if a pipeline has more than one such as <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a>. The example below quantizes the T5 text encoder in <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> while keeping the CLIP model intact.</li>',ie,q,se,_,qe='Pass the <code>pipeline_quant_config</code> to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to quantize the pipeline.',ae,B,le,$,oe,v,_e="The <code>quant_mapping</code> argument provides more flexible options for how to quantize each individual component in a pipeline, like combining different quantization backends.",pe,k,Be='Initialize <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> and pass a <code>quant_mapping</code> to it. The <code>quant_mapping</code> allows you to specify the quantization options for each component in the pipeline such as the transformer and text encoder.',re,Q,$e='The example below uses two quantization backends, <code>~quantizers.QuantoConfig</code> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a>, for the transformer and text encoder.',fe,G,ue,I,ve='There is a separate bitsandbytes backend in <a href="https://huggingface.co/docs/transformers/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">Transformers</a>. You need to import and use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> for components that come from Transformers. For example, <code>text_encoder_2</code> in <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> is a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a> from Transformers so you need to use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> instead of <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">diffusers.BitsAndBytesConfig</a>.',me,h,ce,W,de,X,ke='Pass the <code>pipeline_quant_config</code> to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to quantize the pipeline.',ye,R,Me,F,he,x,Qe="Check out the resources below to learn more about quantization.",we,E,Ge='<li><p>If you are new to quantization, we recommend checking out the following beginner-friendly courses in collaboration with DeepLearning.AI.</p> <ul><li><a href="https://www.deeplearning.ai/short-courses/quantization-fundamentals-with-hugging-face/" rel="nofollow">Quantization Fundamentals with Hugging Face</a></li> <li><a href="https://www.deeplearning.ai/short-courses/quantization-in-depth/" rel="nofollow">Quantization in Depth</a></li></ul></li> <li><p>Refer to the <a href="https://huggingface.co/docs/transformers/main/en/quantization/contribute" rel="nofollow">Contribute new quantization method guide</a> if you’re interested in adding a new quantization method.</p></li> <li><p>The Transformers quantization <a href="https://huggingface.co/docs/transformers/quantization/overview#when-to-use-what" rel="nofollow">Overview</a> provides an overview of the pros and cons of different quantization backends.</p></li> <li><p>Read the <a href="https://huggingface.co/blog/diffusers-quantization" rel="nofollow">Exploring Quantization Backends in Diffusers</a> blog post for a brief introduction to each quantization backend, how to choose a backend, and combining quantization with other memory optimizations.</p></li>',be,V,ge,H,Je;return b=new P({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),T=new P({props:{title:"Pipeline-level quantization",local:"pipeline-level-quantization",headingTag:"h2"}}),z=new P({props:{title:"Simple quantization",local:"simple-quantization",headingTag:"h3"}}),q=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X2JhY2tlbmQlM0QlMjJiaXRzYW5kYnl0ZXNfNGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50X2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fNGJpdCUyMiUzQSUyMFRydWUlMkMlMjAlMjJibmJfNGJpdF9xdWFudF90eXBlJTIyJTNBJTIwJTIybmY0JTIyJTJDJTIwJTIyYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUyMiUzQSUyMHRvcmNoLmJmbG9hdDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwY29tcG9uZW50c190b19xdWFudGl6ZSUzRCU1QiUyMnRyYW5zZm9ybWVyJTIyJTJDJTIwJTIydGV4dF9lbmNvZGVyXzIlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)`,wrap:!1}}),B=new Y({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIycGhvdG8lMjBvZiUyMGElMjBjdXRlJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(<span class="hljs-string">&quot;photo of a cute dog&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),$=new P({props:{title:"quant_mapping",local:"quantmapping",headingTag:"h3"}}),G=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMucXVhbnRpemF0aW9uX2NvbmZpZyUyMGltcG9ydCUyMFF1YW50b0NvbmZpZyUwQWZyb20lMjBkaWZmdXNlcnMucXVhbnRpemVycyUyMGltcG9ydCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcGlwZWxpbmVfcXVhbnRfY29uZmlnJTIwJTNEJTIwUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcXVhbnRfbWFwcGluZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyJTIyJTNBJTIwUXVhbnRvQ29uZmlnKHdlaWdodHNfZHR5cGUlM0QlMjJpbnQ4JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> diffusers.quantizers.quantization_config <span class="hljs-keyword">import</span> QuantoConfig
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={
        <span class="hljs-string">&quot;transformer&quot;</span>: QuantoConfig(weights_dtype=<span class="hljs-string">&quot;int8&quot;</span>),
        <span class="hljs-string">&quot;text_encoder_2&quot;</span>: TransformersBitsAndBytesConfig(
            load_in_4bit=<span class="hljs-literal">True</span>, compute_dtype=torch.bfloat16
        ),
    }
)`,wrap:!1}}),h=new Ye({props:{warning:!1,$$slots:{default:[Ne]},$$scope:{ctx:N}}}),W=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMjBhcyUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X21hcHBpbmclM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lciUyMiUzQSUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={
        <span class="hljs-string">&quot;transformer&quot;</span>: DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16),
        <span class="hljs-string">&quot;text_encoder_2&quot;</span>: TransformersBitsAndBytesConfig(
            load_in_4bit=<span class="hljs-literal">True</span>, compute_dtype=torch.bfloat16
        ),
    }
)`,wrap:!1}}),R=new Y({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIycGhvdG8lMjBvZiUyMGElMjBjdXRlJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(<span class="hljs-string">&quot;photo of a cute dog&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),F=new P({props:{title:"Resources",local:"resources",headingTag:"h2"}}),V=new Pe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/overview.md"}}),{c(){p=l("meta"),w=s(),M=l("p"),A=s(),f(b.$$.fragment),L=s(),g=l("p"),g.textContent=Te,S=s(),J=l("p"),J.innerHTML=Ue,D=s(),f(T.$$.fragment),K=s(),U=l("p"),U.innerHTML=Ce,O=s(),C=l("ul"),C.innerHTML=ze,ee=s(),f(z.$$.fragment),te=s(),j=l("p"),j.innerHTML=je,ne=s(),Z=l("ul"),Z.innerHTML=Ze,ie=s(),f(q.$$.fragment),se=s(),_=l("p"),_.innerHTML=qe,ae=s(),f(B.$$.fragment),le=s(),f($.$$.fragment),oe=s(),v=l("p"),v.innerHTML=_e,pe=s(),k=l("p"),k.innerHTML=Be,re=s(),Q=l("p"),Q.innerHTML=$e,fe=s(),f(G.$$.fragment),ue=s(),I=l("p"),I.innerHTML=ve,me=s(),f(h.$$.fragment),ce=s(),f(W.$$.fragment),de=s(),X=l("p"),X.innerHTML=ke,ye=s(),f(R.$$.fragment),Me=s(),f(F.$$.fragment),he=s(),x=l("p"),x.textContent=Qe,we=s(),E=l("ul"),E.innerHTML=Ge,be=s(),f(V.$$.fragment),ge=s(),H=l("p"),this.h()},l(e){const t=Ae("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(n),w=a(e),M=o(e,"P",{}),We(M).forEach(n),A=a(e),u(b.$$.fragment,e),L=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-16bsuce"&&(g.textContent=Te),S=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-6eg90x"&&(J.innerHTML=Ue),D=a(e),u(T.$$.fragment,e),K=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-13djtpk"&&(U.innerHTML=Ce),O=a(e),C=o(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-r6z8v4"&&(C.innerHTML=ze),ee=a(e),u(z.$$.fragment,e),te=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-11lseqg"&&(j.innerHTML=je),ne=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-jj6c5s"&&(Z.innerHTML=Ze),ie=a(e),u(q.$$.fragment,e),se=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-3c78ko"&&(_.innerHTML=qe),ae=a(e),u(B.$$.fragment,e),le=a(e),u($.$$.fragment,e),oe=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1jertmf"&&(v.innerHTML=_e),pe=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1bi47yb"&&(k.innerHTML=Be),re=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-8638wm"&&(Q.innerHTML=$e),fe=a(e),u(G.$$.fragment,e),ue=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1072co4"&&(I.innerHTML=ve),me=a(e),u(h.$$.fragment,e),ce=a(e),u(W.$$.fragment,e),de=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-3c78ko"&&(X.innerHTML=ke),ye=a(e),u(R.$$.fragment,e),Me=a(e),u(F.$$.fragment,e),he=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-kva6dz"&&(x.textContent=Qe),we=a(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-yr6gzk"&&(E.innerHTML=Ge),be=a(e),u(V.$$.fragment,e),ge=a(e),H=o(e,"P",{}),We(H).forEach(n),this.h()},h(){Xe(p,"name","hf:doc:metadata"),Xe(p,"content",Se)},m(e,t){He(document.head,p),i(e,w,t),i(e,M,t),i(e,A,t),m(b,e,t),i(e,L,t),i(e,g,t),i(e,S,t),i(e,J,t),i(e,D,t),m(T,e,t),i(e,K,t),i(e,U,t),i(e,O,t),i(e,C,t),i(e,ee,t),m(z,e,t),i(e,te,t),i(e,j,t),i(e,ne,t),i(e,Z,t),i(e,ie,t),m(q,e,t),i(e,se,t),i(e,_,t),i(e,ae,t),m(B,e,t),i(e,le,t),m($,e,t),i(e,oe,t),i(e,v,t),i(e,pe,t),i(e,k,t),i(e,re,t),i(e,Q,t),i(e,fe,t),m(G,e,t),i(e,ue,t),i(e,I,t),i(e,me,t),m(h,e,t),i(e,ce,t),m(W,e,t),i(e,de,t),i(e,X,t),i(e,ye,t),m(R,e,t),i(e,Me,t),m(F,e,t),i(e,he,t),i(e,x,t),i(e,we,t),i(e,E,t),i(e,be,t),m(V,e,t),i(e,ge,t),i(e,H,t),Je=!0},p(e,[t]){const Ie={};t&2&&(Ie.$$scope={dirty:t,ctx:e}),h.$set(Ie)},i(e){Je||(c(b.$$.fragment,e),c(T.$$.fragment,e),c(z.$$.fragment,e),c(q.$$.fragment,e),c(B.$$.fragment,e),c($.$$.fragment,e),c(G.$$.fragment,e),c(h.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(V.$$.fragment,e),Je=!0)},o(e){d(b.$$.fragment,e),d(T.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(B.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(h.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(V.$$.fragment,e),Je=!1},d(e){e&&(n(w),n(M),n(A),n(L),n(g),n(S),n(J),n(D),n(K),n(U),n(O),n(C),n(ee),n(te),n(j),n(ne),n(Z),n(ie),n(se),n(_),n(ae),n(le),n(oe),n(v),n(pe),n(k),n(re),n(Q),n(fe),n(ue),n(I),n(me),n(ce),n(de),n(X),n(ye),n(Me),n(he),n(x),n(we),n(E),n(be),n(ge),n(H)),n(p),y(b,e),y(T,e),y(z,e),y(q,e),y(B,e),y($,e),y(G,e),y(h,e),y(W,e),y(R,e),y(F,e),y(V,e)}}}const Se='{"title":"Quantization","local":"quantization","sections":[{"title":"Pipeline-level quantization","local":"pipeline-level-quantization","sections":[{"title":"Simple quantization","local":"simple-quantization","sections":[],"depth":3},{"title":"quant_mapping","local":"quantmapping","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function De(N){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends Ee{constructor(p){super(),Ve(this,p,De,Le,Re,{})}}export{it as component};
