import{s as Fl,n as Ll,o as Kl}from"../chunks/scheduler.35aab934.js";import{S as Pl,i as ql,e as i,s as n,c as p,h as Ol,a as o,d as t,b as a,f as Gl,g as r,j as M,k as Dl,l as et,m as s,n as w,t as m,o as c,p as y}from"../chunks/index.de17b971.js";import{C as lt}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as Tl}from"../chunks/CodeBlock.c1f62de5.js";import{H as u,E as tt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function st(hl){let T,Te,ye,he,h,Je,J,je,j,Jl="MobileNet is a type of neural network architecture designed for mobile devices. It was developed by Google’s research team and first introduced in 2017. The primary goal of MobileNet is to provide high-performance, low-latency image classification and object detection on smartphones, tablets, and other resource-constrained devices.",fe,f,jl="MobileNet achieves this by using depthwise separable convolutions, which are a more efficient alternative to standard convolutions. Depthwise separable convolutions break down the computation into two separate steps: depthwise convolution followed by pointwise convolution. This results in a significant reduction of parameters and computational complexity, allowing MobileNet to run efficiently on mobile devices.",Ue,U,Ce,C,fl="By replacing regular convolutional layers with these depthwise separable convolutions and pointwise convolutions, MobileNet achieves high accuracy while minimizing computational overhead, making it well-suited for mobile devices and other resource-limited platforms. There are two types of convolutions used in MobileNet:",be,b,de,d,Ul="In traditional convolutional layers, each filter applies its weight across all input channels simultaneously. Depthwise separable convolutions break this down into two steps: depthwise convolution followed by pointwise convolution.",Ie,I,Cl="This step performs a convolution separately for each channel (a single color or feature) in the input image using a small filter (usually 3x3). The output of this step is the same size as the input but with fewer channels.",ve,v,xe,x,bl="This type of convolution applies a single filter (usually 1x1) across all channels in both input and output layers. It has fewer parameters than regular convolution and can be seen as an alternative to fully connected layers, making it suitable for mobile devices that have limited computational resources.",ge,g,dl="After depthwise convolution, this step combines the filtered outputs from previous steps using another 1x1 convolutional layer. This operation effectively aggregates the features learned by the depthwise convolutions into a smaller set of features, reducing the overall complexity while retaining important information.",Ae,A,Be,B,Il="To better understand, let’s simplify it and explain:",$e,$,ke,k,vl="Imagine you have a big, thick filter (like a sponge with many layers). This filter is applied over the entire image. It processes all parts of the image and all its features (like colors) at once. This requires a lot of work (computation) and a big filter (memory).",Ze,Z,Ee,E,xl="MobileNet does this process basic. It splits the big filter into two smaller, simpler steps:",Ne,N,gl=`<li><strong>Step 1 - Depthwise Convolution:</strong> First, it uses a thin filter (like a single layer of a sponge) for each feature of the image
separately (like processing each color individually). This is less work because each filter is small and simple.</li> <li><strong>Step 2 - Pointwise Convolution:</strong> Then, it uses another small filter (just a tiny dot) to mix these features back together. This step is like taking a summary of what the first filters found.</li>`,_e,_,Se,S,Al="MobileNet uses these two smaller steps instead of one big step, it’s like doing a lighter version of the work needed in regular convolutions. It’s more efficient, especially on devices that aren’t very powerful, like smartphones.",He,H,Bl="With smaller filters, MobileNet doesn’t need as much memory. It’s like needing a smaller box to store all your tools, making it easier to fit into smaller devices.",We,W,Re,R,ze,z,$l="<li>Normal convolutions use a larger kernel (like 3x3 or 5x5) to look at a group of pixels in the image at once. It’s like observing a small patch of a picture to understand a part of the scene.</li> <li>These convolutions are good at understanding features like edges, corners, and textures by analyzing how pixels are arranged next to each other.</li>",Qe,Q,Ye,Y,kl="<li>A 1x1 convolution, looks at one pixel at a time. It doesn’t try to understand the arrangement of neighboring pixels.</li> <li>Even though it’s looking at one pixel, it considers all the information from different channels (like the RGB channels in a color image). It combines these channels to create a new version of that pixel.</li> <li>The 1x1 convolution can either increase or decrease the number of channels. This means it can simplify the information (by reducing channels) or create more complex information (by increasing channels).</li>",Ve,V,Xe,X,Zl="<li><strong>Area of Focus:</strong> Normal convolutions analyze a set of pixels together to understand patterns, whereas 1x1 convolutions focus on individual pixels, combining the information from different channels.</li> <li><strong>Purpose:</strong> Normal convolutions are used for detecting patterns and features in an image. In contrast, 1x1 convolutions are mainly used to alter the channel depth, helping in adjusting the complexity of the information for subsequent layers in a neural network for efficiency in weak devices.</li>",Ge,G,El="MobileNet also employs techniques like channel-wise linear bottleneck layers, which improve model accuracy while reducing the number of parameters. The architecture is designed with optimizations for various hardware platforms, including CPUs, GPUs, and even specialized hardware such as Google’s Tensor Processing Units (TPUs).",De,D,Fe,F,Nl="Channel-wise linear bottleneck layers help to further reduce the number of parameters and computational cost while maintaining high accuracy in image classification tasks.",Le,L,_l="A channel-wise linear bottleneck layer consists of three main operations applied sequentially:",Ke,K,Sl="<li><strong>Depthwise convolution:</strong> This step performs a convolution separately for each channel (a single color or feature) in the input image using a small filter (usually 3x3). The output of this step is the same size as the input but with fewer channels.</li> <li><strong>Batch normalization:</strong> This operation normalizes the activation values across each channel, helping to stabilize the training process and improve generalization performance.</li> <li><strong>Activation function:</strong> Typically, a ReLU (Rectified Linear Unit) activation function is used after batch normalization to introduce non-linearity in the network.</li>",Pe,P,qe,q,Hl="Some problems may occur during training. We will explain them first, then we explain what ReLU does to this problems.",Oe,O,el,ee,Wl="In deep neural networks, especially during backpropagation, the vanishing gradient problem can occur. This happens when gradients (which are used to update the network’s weights) become very small as they are passed back through the network’s layers. If these gradients become too small, they “vanish,” making it hard for the network to learn and adjust its weights effectively.",ll,le,Rl="ReLU has a linear, non-saturating form for positive values (where it simply outputs the input if it’s positive), it ensures that the gradients do not become too small, allowing for faster learning and more effective weight adjustments in the network.",tl,te,sl,se,zl="Without non-linearity, a neural network, no matter how many layers it has, would function as a linear model, incapable of learning complex patterns.",nl,ne,Ql="Non-linear functions like ReLU enable neural networks to capture and learn complex relationships in the data.",al,ae,il,ie,Yl="You can use Hugging Face transformers to infer with a variation of transformers models like below:",ol,oe,Ml,Me,pl,pe,rl,re,Vl="You can find an example implementation of MobileNet for PyTorch below:",wl,we,ml,me,Xl='You can also find a pretrained MobileNet model checkpoint on this HuggingFace <a href="https://huggingface.co/google/mobilenet_v2_1.0_224" rel="nofollow">link</a>.',cl,ce,yl,ue,ul;return h=new lt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new u({props:{title:"MobileNet",local:"mobilenet",headingTag:"h1"}}),U=new u({props:{title:"Convolution Types on MobileNet",local:"convolution-types-on-mobilenet",headingTag:"h2"}}),b=new u({props:{title:"Depthwise Seperable Convolutions",local:"depthwise-seperable-convolutions",headingTag:"h3"}}),v=new u({props:{title:"Pointwise Seperable Convolutions",local:"pointwise-seperable-convolutions",headingTag:"h3"}}),A=new u({props:{title:"Why Do We Use These Convolutions Instead of Regular Convolutions?",local:"why-do-we-use-these-convolutions-instead-of-regular-convolutions",headingTag:"h3"}}),$=new u({props:{title:"Regular Convolutions, a big, All-in-one Filter",local:"regular-convolutions-a-big-all-in-one-filter",headingTag:"h4"}}),Z=new u({props:{title:"Depthwise Separable Convolutions - Two-Step, Lighter Process:",local:"depthwise-separable-convolutions---two-step-lighter-process",headingTag:"h4"}}),_=new u({props:{title:"What are these steps about?",local:"what-are-these-steps-about",headingTag:"h4"}}),W=new u({props:{title:"How Do 1x1 Convolutions Work Compared to Normal Convolutions?",local:"how-do-1x1-convolutions-work-compared-to-normal-convolutions",headingTag:"h3"}}),R=new u({props:{title:"Normal Convolutions",local:"normal-convolutions",headingTag:"h4"}}),Q=new u({props:{title:"1x1 Convolutions",local:"1x1-convolutions",headingTag:"h4"}}),V=new u({props:{title:"Key Differences",local:"key-differences",headingTag:"h4"}}),D=new u({props:{title:"Channel-wise Linear Bottleneck Layers",local:"channel-wise-linear-bottleneck-layers",headingTag:"h3"}}),P=new u({props:{title:"What does ReLU do?",local:"what-does-relu-do",headingTag:"h3"}}),O=new u({props:{title:"Vanishing Gradient Problem",local:"vanishing-gradient-problem",headingTag:"h4"}}),te=new u({props:{title:"Non-Linearity",local:"non-linearity",headingTag:"h4"}}),ae=new u({props:{title:"Inference",local:"inference",headingTag:"h3"}}),oe=new Tl({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEElMjMlMjBpbml0aWFsaXplJTIwcHJvY2Vzc29yJTIwYW5kJTIwbW9kZWwlMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm1vYmlsZW5ldF92Ml8xLjBfMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbW9iaWxlbmV0X3YyXzEuMF8yMjQlMjIpJTBBJTBBJTIzJTIwcHJlcHJvY2VzcyUyMHRoZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZ2V0JTIwdGhlJTIwb3V0cHV0JTIwYW5kJTIwdGhlJTIwY2xhc3MlMjBsYWJlbHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWR4JTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQoJTIyUHJlZGljdGVkJTIwY2xhc3MlM0ElMjIlMkMlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWR4JTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForImageClassification
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># initialize processor and model</span>
preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/mobilenet_v2_1.0_224&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/mobilenet_v2_1.0_224&quot;</span>)

<span class="hljs-comment"># preprocess the inputs</span>
inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># get the output and the class labels</span>
outputs = model(**inputs)
logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),Me=new Tl({props:{code:"UHJlZGljdGVkJTIwY2xhc3MlM0ElMjB0YWJieSUyQyUyMHRhYmJ5JTIwY2F0",highlighted:'Predicted <span class="hljs-keyword">class</span>: <span class="hljs-symbol">tabby, <span class="hljs-symbol">tabby</span></span> <span class="hljs-symbol">cat</span>',wrap:!1}}),pe=new u({props:{title:"Example Implementation using PyTorch",local:"example-implementation-using-pytorch",headingTag:"h3"}}),we=new Tl({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DepthwiseSeparableConv</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, out_channels, stride</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.depthwise = nn.Conv2d(
            in_channels,
            in_channels,
            kernel_size=<span class="hljs-number">3</span>,
            stride=stride,
            padding=<span class="hljs-number">1</span>,
            groups=in_channels,
        )
        self.pointwise = nn.Conv2d(
            in_channels, out_channels, kernel_size=<span class="hljs-number">1</span>, stride=<span class="hljs-number">1</span>, padding=<span class="hljs-number">0</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.depthwise(x)
        x = self.pointwise(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MobileNet</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">1000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.conv1 = nn.Conv2d(<span class="hljs-number">3</span>, <span class="hljs-number">32</span>, kernel_size=<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment"># MobileNet body</span>
        self.dw_conv2 = DepthwiseSeparableConv(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">1</span>)
        self.dw_conv3 = DepthwiseSeparableConv(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, <span class="hljs-number">2</span>)
        self.dw_conv4 = DepthwiseSeparableConv(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
        self.dw_conv5 = DepthwiseSeparableConv(<span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">2</span>)
        self.dw_conv6 = DepthwiseSeparableConv(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">1</span>)
        self.dw_conv7 = DepthwiseSeparableConv(<span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)

        <span class="hljs-comment"># 5 depthwise separable convolutions with stride 1</span>
        self.dw_conv8 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv9 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv10 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv11 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv12 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)

        self.dw_conv13 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">1024</span>, <span class="hljs-number">2</span>)
        self.dw_conv14 = DepthwiseSeparableConv(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>, <span class="hljs-number">1</span>)

        self.avg_pool = nn.AdaptiveAvgPool2d(<span class="hljs-number">1</span>)
        self.fc = nn.Linear(<span class="hljs-number">1024</span>, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.conv1(x)
        x = F.relu(x)

        x = self.dw_conv2(x)
        x = F.relu(x)
        x = self.dw_conv3(x)
        x = F.relu(x)
        x = self.dw_conv4(x)
        x = F.relu(x)
        x = self.dw_conv5(x)
        x = F.relu(x)
        x = self.dw_conv6(x)
        x = F.relu(x)
        x = self.dw_conv7(x)
        x = F.relu(x)

        x = self.dw_conv8(x)
        x = F.relu(x)
        x = self.dw_conv9(x)
        x = F.relu(x)
        x = self.dw_conv10(x)
        x = F.relu(x)
        x = self.dw_conv11(x)
        x = F.relu(x)
        x = self.dw_conv12(x)
        x = F.relu(x)

        x = self.dw_conv13(x)
        x = F.relu(x)
        x = self.dw_conv14(x)
        x = F.relu(x)

        x = self.avg_pool(x)
        x = x.view(x.size(<span class="hljs-number">0</span>), -<span class="hljs-number">1</span>)
        x = self.fc(x)

        <span class="hljs-keyword">return</span> x


<span class="hljs-comment"># Create the model</span>
mobilenet = MobileNet(num_classes=<span class="hljs-number">1000</span>)
<span class="hljs-built_in">print</span>(mobilenet)`,wrap:!1}}),ce=new tt({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit2/cnns/mobilenet.mdx"}}),{c(){T=i("meta"),Te=n(),ye=i("p"),he=n(),p(h.$$.fragment),Je=n(),p(J.$$.fragment),je=n(),j=i("p"),j.textContent=Jl,fe=n(),f=i("p"),f.textContent=jl,Ue=n(),p(U.$$.fragment),Ce=n(),C=i("p"),C.textContent=fl,be=n(),p(b.$$.fragment),de=n(),d=i("p"),d.textContent=Ul,Ie=n(),I=i("p"),I.textContent=Cl,ve=n(),p(v.$$.fragment),xe=n(),x=i("p"),x.textContent=bl,ge=n(),g=i("p"),g.textContent=dl,Ae=n(),p(A.$$.fragment),Be=n(),B=i("p"),B.textContent=Il,$e=n(),p($.$$.fragment),ke=n(),k=i("p"),k.textContent=vl,Ze=n(),p(Z.$$.fragment),Ee=n(),E=i("p"),E.textContent=xl,Ne=n(),N=i("ul"),N.innerHTML=gl,_e=n(),p(_.$$.fragment),Se=n(),S=i("p"),S.textContent=Al,He=n(),H=i("p"),H.textContent=Bl,We=n(),p(W.$$.fragment),Re=n(),p(R.$$.fragment),ze=n(),z=i("ul"),z.innerHTML=$l,Qe=n(),p(Q.$$.fragment),Ye=n(),Y=i("ul"),Y.innerHTML=kl,Ve=n(),p(V.$$.fragment),Xe=n(),X=i("ul"),X.innerHTML=Zl,Ge=n(),G=i("p"),G.textContent=El,De=n(),p(D.$$.fragment),Fe=n(),F=i("p"),F.textContent=Nl,Le=n(),L=i("p"),L.textContent=_l,Ke=n(),K=i("ol"),K.innerHTML=Sl,Pe=n(),p(P.$$.fragment),qe=n(),q=i("p"),q.textContent=Hl,Oe=n(),p(O.$$.fragment),el=n(),ee=i("p"),ee.textContent=Wl,ll=n(),le=i("p"),le.textContent=Rl,tl=n(),p(te.$$.fragment),sl=n(),se=i("p"),se.textContent=zl,nl=n(),ne=i("p"),ne.textContent=Ql,al=n(),p(ae.$$.fragment),il=n(),ie=i("p"),ie.textContent=Yl,ol=n(),p(oe.$$.fragment),Ml=n(),p(Me.$$.fragment),pl=n(),p(pe.$$.fragment),rl=n(),re=i("p"),re.textContent=Vl,wl=n(),p(we.$$.fragment),ml=n(),me=i("p"),me.innerHTML=Xl,cl=n(),p(ce.$$.fragment),yl=n(),ue=i("p"),this.h()},l(e){const l=Ol("svelte-u9bgzb",document.head);T=o(l,"META",{name:!0,content:!0}),l.forEach(t),Te=a(e),ye=o(e,"P",{}),Gl(ye).forEach(t),he=a(e),r(h.$$.fragment,e),Je=a(e),r(J.$$.fragment,e),je=a(e),j=o(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-sijmec"&&(j.textContent=Jl),fe=a(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-174b0qn"&&(f.textContent=jl),Ue=a(e),r(U.$$.fragment,e),Ce=a(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1wb1rsu"&&(C.textContent=fl),be=a(e),r(b.$$.fragment,e),de=a(e),d=o(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-ponep"&&(d.textContent=Ul),Ie=a(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-161c9o7"&&(I.textContent=Cl),ve=a(e),r(v.$$.fragment,e),xe=a(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-2y0hnt"&&(x.textContent=bl),ge=a(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1phmdq0"&&(g.textContent=dl),Ae=a(e),r(A.$$.fragment,e),Be=a(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-7o9nvi"&&(B.textContent=Il),$e=a(e),r($.$$.fragment,e),ke=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1aqrp0c"&&(k.textContent=vl),Ze=a(e),r(Z.$$.fragment,e),Ee=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1n7p8h5"&&(E.textContent=xl),Ne=a(e),N=o(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-1erfm5m"&&(N.innerHTML=gl),_e=a(e),r(_.$$.fragment,e),Se=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-ucrnk0"&&(S.textContent=Al),He=a(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1q9jr09"&&(H.textContent=Bl),We=a(e),r(W.$$.fragment,e),Re=a(e),r(R.$$.fragment,e),ze=a(e),z=o(e,"UL",{"data-svelte-h":!0}),M(z)!=="svelte-141ia0e"&&(z.innerHTML=$l),Qe=a(e),r(Q.$$.fragment,e),Ye=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),M(Y)!=="svelte-1fof3jx"&&(Y.innerHTML=kl),Ve=a(e),r(V.$$.fragment,e),Xe=a(e),X=o(e,"UL",{"data-svelte-h":!0}),M(X)!=="svelte-20uax5"&&(X.innerHTML=Zl),Ge=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1wb1jef"&&(G.textContent=El),De=a(e),r(D.$$.fragment,e),Fe=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-3ec6p4"&&(F.textContent=Nl),Le=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1jsp81n"&&(L.textContent=_l),Ke=a(e),K=o(e,"OL",{"data-svelte-h":!0}),M(K)!=="svelte-123p5si"&&(K.innerHTML=Sl),Pe=a(e),r(P.$$.fragment,e),qe=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-iz02dd"&&(q.textContent=Hl),Oe=a(e),r(O.$$.fragment,e),el=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1kof70t"&&(ee.textContent=Wl),ll=a(e),le=o(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1t9atje"&&(le.textContent=Rl),tl=a(e),r(te.$$.fragment,e),sl=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-17n9xro"&&(se.textContent=zl),nl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1cfo99"&&(ne.textContent=Ql),al=a(e),r(ae.$$.fragment,e),il=a(e),ie=o(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-gwdx3y"&&(ie.textContent=Yl),ol=a(e),r(oe.$$.fragment,e),Ml=a(e),r(Me.$$.fragment,e),pl=a(e),r(pe.$$.fragment,e),rl=a(e),re=o(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-10vxwno"&&(re.textContent=Vl),wl=a(e),r(we.$$.fragment,e),ml=a(e),me=o(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1fc7bef"&&(me.innerHTML=Xl),cl=a(e),r(ce.$$.fragment,e),yl=a(e),ue=o(e,"P",{}),Gl(ue).forEach(t),this.h()},h(){Dl(T,"name","hf:doc:metadata"),Dl(T,"content",nt)},m(e,l){et(document.head,T),s(e,Te,l),s(e,ye,l),s(e,he,l),w(h,e,l),s(e,Je,l),w(J,e,l),s(e,je,l),s(e,j,l),s(e,fe,l),s(e,f,l),s(e,Ue,l),w(U,e,l),s(e,Ce,l),s(e,C,l),s(e,be,l),w(b,e,l),s(e,de,l),s(e,d,l),s(e,Ie,l),s(e,I,l),s(e,ve,l),w(v,e,l),s(e,xe,l),s(e,x,l),s(e,ge,l),s(e,g,l),s(e,Ae,l),w(A,e,l),s(e,Be,l),s(e,B,l),s(e,$e,l),w($,e,l),s(e,ke,l),s(e,k,l),s(e,Ze,l),w(Z,e,l),s(e,Ee,l),s(e,E,l),s(e,Ne,l),s(e,N,l),s(e,_e,l),w(_,e,l),s(e,Se,l),s(e,S,l),s(e,He,l),s(e,H,l),s(e,We,l),w(W,e,l),s(e,Re,l),w(R,e,l),s(e,ze,l),s(e,z,l),s(e,Qe,l),w(Q,e,l),s(e,Ye,l),s(e,Y,l),s(e,Ve,l),w(V,e,l),s(e,Xe,l),s(e,X,l),s(e,Ge,l),s(e,G,l),s(e,De,l),w(D,e,l),s(e,Fe,l),s(e,F,l),s(e,Le,l),s(e,L,l),s(e,Ke,l),s(e,K,l),s(e,Pe,l),w(P,e,l),s(e,qe,l),s(e,q,l),s(e,Oe,l),w(O,e,l),s(e,el,l),s(e,ee,l),s(e,ll,l),s(e,le,l),s(e,tl,l),w(te,e,l),s(e,sl,l),s(e,se,l),s(e,nl,l),s(e,ne,l),s(e,al,l),w(ae,e,l),s(e,il,l),s(e,ie,l),s(e,ol,l),w(oe,e,l),s(e,Ml,l),w(Me,e,l),s(e,pl,l),w(pe,e,l),s(e,rl,l),s(e,re,l),s(e,wl,l),w(we,e,l),s(e,ml,l),s(e,me,l),s(e,cl,l),w(ce,e,l),s(e,yl,l),s(e,ue,l),ul=!0},p:Ll,i(e){ul||(m(h.$$.fragment,e),m(J.$$.fragment,e),m(U.$$.fragment,e),m(b.$$.fragment,e),m(v.$$.fragment,e),m(A.$$.fragment,e),m($.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(W.$$.fragment,e),m(R.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(Me.$$.fragment,e),m(pe.$$.fragment,e),m(we.$$.fragment,e),m(ce.$$.fragment,e),ul=!0)},o(e){c(h.$$.fragment,e),c(J.$$.fragment,e),c(U.$$.fragment,e),c(b.$$.fragment,e),c(v.$$.fragment,e),c(A.$$.fragment,e),c($.$$.fragment,e),c(Z.$$.fragment,e),c(_.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(Q.$$.fragment,e),c(V.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(pe.$$.fragment,e),c(we.$$.fragment,e),c(ce.$$.fragment,e),ul=!1},d(e){e&&(t(Te),t(ye),t(he),t(Je),t(je),t(j),t(fe),t(f),t(Ue),t(Ce),t(C),t(be),t(de),t(d),t(Ie),t(I),t(ve),t(xe),t(x),t(ge),t(g),t(Ae),t(Be),t(B),t($e),t(ke),t(k),t(Ze),t(Ee),t(E),t(Ne),t(N),t(_e),t(Se),t(S),t(He),t(H),t(We),t(Re),t(ze),t(z),t(Qe),t(Ye),t(Y),t(Ve),t(Xe),t(X),t(Ge),t(G),t(De),t(Fe),t(F),t(Le),t(L),t(Ke),t(K),t(Pe),t(qe),t(q),t(Oe),t(el),t(ee),t(ll),t(le),t(tl),t(sl),t(se),t(nl),t(ne),t(al),t(il),t(ie),t(ol),t(Ml),t(pl),t(rl),t(re),t(wl),t(ml),t(me),t(cl),t(yl),t(ue)),t(T),y(h,e),y(J,e),y(U,e),y(b,e),y(v,e),y(A,e),y($,e),y(Z,e),y(_,e),y(W,e),y(R,e),y(Q,e),y(V,e),y(D,e),y(P,e),y(O,e),y(te,e),y(ae,e),y(oe,e),y(Me,e),y(pe,e),y(we,e),y(ce,e)}}}const nt='{"title":"MobileNet","local":"mobilenet","sections":[{"title":"Convolution Types on MobileNet","local":"convolution-types-on-mobilenet","sections":[{"title":"Depthwise Seperable Convolutions","local":"depthwise-seperable-convolutions","sections":[],"depth":3},{"title":"Pointwise Seperable Convolutions","local":"pointwise-seperable-convolutions","sections":[],"depth":3},{"title":"Why Do We Use These Convolutions Instead of Regular Convolutions?","local":"why-do-we-use-these-convolutions-instead-of-regular-convolutions","sections":[{"title":"Regular Convolutions, a big, All-in-one Filter","local":"regular-convolutions-a-big-all-in-one-filter","sections":[],"depth":4},{"title":"Depthwise Separable Convolutions - Two-Step, Lighter Process:","local":"depthwise-separable-convolutions---two-step-lighter-process","sections":[],"depth":4},{"title":"What are these steps about?","local":"what-are-these-steps-about","sections":[],"depth":4}],"depth":3},{"title":"How Do 1x1 Convolutions Work Compared to Normal Convolutions?","local":"how-do-1x1-convolutions-work-compared-to-normal-convolutions","sections":[{"title":"Normal Convolutions","local":"normal-convolutions","sections":[],"depth":4},{"title":"1x1 Convolutions","local":"1x1-convolutions","sections":[],"depth":4},{"title":"Key Differences","local":"key-differences","sections":[],"depth":4}],"depth":3},{"title":"Channel-wise Linear Bottleneck Layers","local":"channel-wise-linear-bottleneck-layers","sections":[],"depth":3},{"title":"What does ReLU do?","local":"what-does-relu-do","sections":[{"title":"Vanishing Gradient Problem","local":"vanishing-gradient-problem","sections":[],"depth":4},{"title":"Non-Linearity","local":"non-linearity","sections":[],"depth":4}],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3},{"title":"Example Implementation using PyTorch","local":"example-implementation-using-pytorch","sections":[],"depth":3}],"depth":2}],"depth":1}';function at(hl){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends Pl{constructor(T){super(),ql(this,T,at,st,Fl,{})}}export{wt as component};
