import{s as q,n as ll,o as sl}from"../chunks/scheduler.35aab934.js";import{S as Ml,i as nl,e as d,s as a,c as T,h as al,a as B,d as M,b as e,f as P,g as y,j as _,k as O,l as el,m as n,n as j,t as w,o as p,p as t}from"../chunks/index.de17b971.js";import{C as Jl}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as Tl}from"../chunks/CodeBlock.c1f62de5.js";import{H as G,E as yl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function jl(L){let J,g,k,E,U,Z,I,Q,r,x,i,Y="The VGG architecture was developed in 2014 by Karen Simonyan and Andrew Zisserman from the Visual Geometry Group -and hence named VGG- at Oxford University. The model demonstrated significant improvements over the past models at that time- to be specific 2014 Imagenet challange also known as ILSVRC.",D,m,N,c,F="<li>Inputs are 224x224 images.</li> <li>Convolution kernel shape is (3,3) and max pooling window shape is (2,2).</li> <li>Number of channels for each convolutional layer 64 -&gt; 128 -&gt; 256 -&gt; 512 -&gt; 512.</li> <li>VGG16 has 16 hidden layers (13 convolutional layers and 3 fully connected layers).</li> <li>VGG19 has 19 hidden layers (16 convolutional layers and 3 fully connected layers).</li>",S,u,v,o,K="<li>VGG (16 or 19 layers) was relatively deeper than other SOTA networks at the time. AlexNet, the winning model for ILSVRC 2012 only has 8 layers.</li> <li>Multiple small (3X3) receptive field filters with ReLU activation instead of one large (7X7 or 11X11) filter lead to better learning of complex features. Smaller filters also mean fewer parameters per layer, with additional nonlinearity introduced in between.</li> <li>Multiscale training and inference. Each image was trained in multiple rounds with varying scales to ensure similar characteristics were captured at different sizes.</li> <li>Consistency and simplicity of the VGG network make it easier to scale or modify for future improvements.</li>",V,A,R,C,H="Below you can find the PyTorch implementation of VGG19.",z,h,X,b,W,f,$;return U=new Jl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new G({props:{title:"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)",local:"very-deep-convolutional-networks-for-large-scale-image-recognition-2014",headingTag:"h1"}}),r=new G({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),m=new G({props:{title:"VGG Network Architechture",local:"vgg-network-architechture",headingTag:"h2"}}),u=new G({props:{title:"Key Comparisons",local:"key-comparisons",headingTag:"h2"}}),A=new G({props:{title:"PyTorch Example",local:"pytorch-example",headingTag:"h2"}}),h=new Tl({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">VGG19</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">1000</span></span>):
        <span class="hljs-built_in">super</span>(VGG19, self).__init__()

        <span class="hljs-comment"># Feature extraction layers: Convolutional and pooling layers</span>
        self.feature_extractor = nn.Sequential(
            nn.Conv2d(
                <span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>
            ),  <span class="hljs-comment"># 3 input channels, 64 output channels, 3x3 kernel, 1 padding</span>
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(
                kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>
            ),  <span class="hljs-comment"># Max pooling with 2x2 kernel and stride 2</span>
            nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">128</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
        )

        <span class="hljs-comment"># Pooling Layer</span>
        self.avgpool = nn.AdaptiveAvgPool2d(output_size=(<span class="hljs-number">7</span>, <span class="hljs-number">7</span>))

        <span class="hljs-comment"># Fully connected layers for classification</span>
        self.classifier = nn.Sequential(
            nn.Linear(
                <span class="hljs-number">512</span> * <span class="hljs-number">7</span> * <span class="hljs-number">7</span>, <span class="hljs-number">4096</span>
            ),  <span class="hljs-comment"># 512 channels, 7x7 spatial dimensions after max pooling</span>
            nn.ReLU(),
            nn.Dropout(<span class="hljs-number">0.5</span>),  <span class="hljs-comment"># Dropout layer with 0.5 dropout probability</span>
            nn.Linear(<span class="hljs-number">4096</span>, <span class="hljs-number">4096</span>),
            nn.ReLU(),
            nn.Dropout(<span class="hljs-number">0.5</span>),
            nn.Linear(<span class="hljs-number">4096</span>, num_classes),  <span class="hljs-comment"># Output layer with &#x27;num_classes&#x27; output units</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.feature_extractor(x)  <span class="hljs-comment"># Pass input through the feature extractor layers</span>
        x = self.avgpool(x)  <span class="hljs-comment"># Pass Data through a pooling layer</span>
        x = x.view(x.size(<span class="hljs-number">0</span>), -<span class="hljs-number">1</span>)  <span class="hljs-comment"># Flatten the output for the fully connected layers</span>
        x = self.classifier(x)  <span class="hljs-comment"># Pass flattened output through the classifier layers</span>
        <span class="hljs-keyword">return</span> x`,wrap:!1}}),b=new yl({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit2/cnns/vgg.mdx"}}),{c(){J=d("meta"),g=a(),k=d("p"),E=a(),T(U.$$.fragment),Z=a(),T(I.$$.fragment),Q=a(),T(r.$$.fragment),x=a(),i=d("p"),i.textContent=Y,D=a(),T(m.$$.fragment),N=a(),c=d("ul"),c.innerHTML=F,S=a(),T(u.$$.fragment),v=a(),o=d("ul"),o.innerHTML=K,V=a(),T(A.$$.fragment),R=a(),C=d("p"),C.textContent=H,z=a(),T(h.$$.fragment),X=a(),T(b.$$.fragment),W=a(),f=d("p"),this.h()},l(l){const s=al("svelte-u9bgzb",document.head);J=B(s,"META",{name:!0,content:!0}),s.forEach(M),g=e(l),k=B(l,"P",{}),P(k).forEach(M),E=e(l),y(U.$$.fragment,l),Z=e(l),y(I.$$.fragment,l),Q=e(l),y(r.$$.fragment,l),x=e(l),i=B(l,"P",{"data-svelte-h":!0}),_(i)!=="svelte-13pxk3z"&&(i.textContent=Y),D=e(l),y(m.$$.fragment,l),N=e(l),c=B(l,"UL",{"data-svelte-h":!0}),_(c)!=="svelte-1rax18l"&&(c.innerHTML=F),S=e(l),y(u.$$.fragment,l),v=e(l),o=B(l,"UL",{"data-svelte-h":!0}),_(o)!=="svelte-qri0w"&&(o.innerHTML=K),V=e(l),y(A.$$.fragment,l),R=e(l),C=B(l,"P",{"data-svelte-h":!0}),_(C)!=="svelte-1i2dftw"&&(C.textContent=H),z=e(l),y(h.$$.fragment,l),X=e(l),y(b.$$.fragment,l),W=e(l),f=B(l,"P",{}),P(f).forEach(M),this.h()},h(){O(J,"name","hf:doc:metadata"),O(J,"content",wl)},m(l,s){el(document.head,J),n(l,g,s),n(l,k,s),n(l,E,s),j(U,l,s),n(l,Z,s),j(I,l,s),n(l,Q,s),j(r,l,s),n(l,x,s),n(l,i,s),n(l,D,s),j(m,l,s),n(l,N,s),n(l,c,s),n(l,S,s),j(u,l,s),n(l,v,s),n(l,o,s),n(l,V,s),j(A,l,s),n(l,R,s),n(l,C,s),n(l,z,s),j(h,l,s),n(l,X,s),j(b,l,s),n(l,W,s),n(l,f,s),$=!0},p:ll,i(l){$||(w(U.$$.fragment,l),w(I.$$.fragment,l),w(r.$$.fragment,l),w(m.$$.fragment,l),w(u.$$.fragment,l),w(A.$$.fragment,l),w(h.$$.fragment,l),w(b.$$.fragment,l),$=!0)},o(l){p(U.$$.fragment,l),p(I.$$.fragment,l),p(r.$$.fragment,l),p(m.$$.fragment,l),p(u.$$.fragment,l),p(A.$$.fragment,l),p(h.$$.fragment,l),p(b.$$.fragment,l),$=!1},d(l){l&&(M(g),M(k),M(E),M(Z),M(Q),M(x),M(i),M(D),M(N),M(c),M(S),M(v),M(o),M(V),M(R),M(C),M(z),M(X),M(W),M(f)),M(J),t(U,l),t(I,l),t(r,l),t(m,l),t(u,l),t(A,l),t(h,l),t(b,l)}}}const wl='{"title":"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)","local":"very-deep-convolutional-networks-for-large-scale-image-recognition-2014","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"VGG Network Architechture","local":"vgg-network-architechture","sections":[],"depth":2},{"title":"Key Comparisons","local":"key-comparisons","sections":[],"depth":2},{"title":"PyTorch Example","local":"pytorch-example","sections":[],"depth":2}],"depth":1}';function pl(L){return sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends Ml{constructor(J){super(),nl(this,J,pl,jl,q,{})}}export{ml as component};
