import{s as Me,n as ee,o as se}from"../chunks/scheduler.35aab934.js";import{S as te,i as ne,e as a,s as t,c as U,h as ae,a as y,d as e,b as n,f as le,g as T,j as i,k as jl,l as ye,m as s,n as o,t as J,o as w,p as C}from"../chunks/index.de17b971.js";import{C as ie}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as rl}from"../chunks/CodeBlock.c1f62de5.js";import{H as r,E as Ue}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function Te(mM){let j,cl,pl,ml,d,dl,h,hl,A,dM='In this section, we will be doing a deep dive into Convolutional Vision Transformer (CvT) which is a variant of Vision Transformer (ViT)<a href="#vision-transformer">[1]</a> and extensively used for the Image Classification task in Computer Vision.',Al,u,ul,f,hM="Before going into CvT, let’s have a small recap on ViT architecture covered in the previous sections to better appreciate the CvT architecture. ViT decomposes each image into a sequence of tokens (i.e. non-overlapping patches) with a fixed length and then applies multiple standard Transformer layers, consisting of Multi-head Self Attention and Position-wise Feed-forward module (FFN) to model global relations for classification.",fl,b,bl,g,AM='Convolutional Vision Transformer (CvT) model was proposed in CvT: Introducing Convolutions to Vision Transformers <a href="#cvt">[2]</a> by Haiping Wu, Bin Xiao, Noel Codella, Mengchen Liu, Xiyang Dai, Lu Yuan and Lei Zhang. CvT employs all the benefits of CNNs: <em>local receptive fields</em>, <em>shared weights</em>, and <em>spatial subsampling</em> along with <em>shift</em>, <em>scale</em>, <em>distortion invariance</em> while keeping merits of Transformers: <em>dynamic attention</em>, <em>global context fusion</em>, and <em>better generalization</em>. CvT achieves superior performance while maintaining computational efficiency compared to ViT. Furthermore, due to built-in local context structure introduced by convolutions, CvT no longer requires a position embedding, giving it a potential advantage for adaption to a wide range of vision tasks requiring variable input resolution.',gl,B,Bl,k,uM='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/cvt_architecture.png" alt="CvT Architecture"/> <em>(a) Overall architecture, showing the hierarchical multi-stage structure facilitated by the Convolutional Token Embedding layer. (b) Details of the Convolutional Transformer Block, which contains the convolutional projection as the first layer. <a href="#cvt">[2]</a></em>',kl,v,fM="The above image of CvT architecture illustrates the main steps of 3-stage pipeline. At its core, CvT blends two convolution-based operations into the Vision Transformer architecture:",vl,E,bM="<li><strong>Convolutional Token Embedding</strong>: Imagine splitting the input image into overlapping patches, reshaping them into tokens, and then feeding them to a convolution layer. This reduces the number of tokens (like pixels in a downsampled image) while boosting their feature richness, similar to traditional CNNs. Unlike other Transformers, we skip adding pre-defined position information to the tokens, relying solely on convolutional operations to capture spatial relationships.</li>",El,_,gM='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/cvt_conv_proj.png" alt="Projection Layer"/> <em>(a) Linear Projection in ViT. (b) Convolutional Projection. (c) Squeezed Convolutional Projection (Default in CvT). <a href="#cvt">[2]</a></em>',_l,Q,BM="<li><strong>Convolutional Transformer Blocks</strong>: Each stage in CvT contains a stack of these blocks. Here, instead of the usual linear projections in ViT, we use depth-wise separable convolutions (Convolutional Projection) to process the “query,” “key,” and “value” components of the self-attention module as shown in the above image. This maintains the benefits of Transformers while improving efficiency. Note that the “classification token” (used for final prediction) is only added in the last stage. Finally, a standard fully-connected layer analyzes the final classification token to predict the image class.</li>",Ql,Z,Zl,R,kM="The below table shows the key differences in terms of the necessity of positional encodings, type of token embedding, type of projection, and Transformer structure in the backbone, between the above representative concurrent works and CvT.",Rl,V,vM='<thead><tr><th>Model</th> <th>Needs Position Encoding (PE)</th> <th>Token Embedding</th> <th>Projection for Attention</th> <th>Hierarchical Transformers</th></tr></thead> <tbody><tr><td>ViT<a href="#vision-transformer">[1]</a>, DeiT <a href="#deit">[3]</a></td> <td>Yes</td> <td>Non-overlapping</td> <td>Linear</td> <td>No</td></tr> <tr><td>CPVT<a href="#cpvt">[4]</a></td> <td>No (w/PE Generator)</td> <td>Non-Overlapping</td> <td>Linear</td> <td>No</td></tr> <tr><td>TNT<a href="#tnt">[5]</a></td> <td>Yes</td> <td>Non-overlapping (Patch + Pixel)</td> <td>Linear</td> <td>No</td></tr> <tr><td>T2T<a href="#t2t">[6]</a></td> <td>Yes</td> <td>Overlapping (Concatenate)</td> <td>Linear</td> <td>Partial (Tokenization)</td></tr> <tr><td>PVT<a href="#pvt">[7]</a></td> <td>Yes</td> <td>Non-overlapping</td> <td>Spatial Reduction</td> <td>Yes</td></tr> <tr><td><em>CvT</em><a href="#cvt">[2]</a></td> <td><em>No</em></td> <td><em>Overlapping (Convolution)</em></td> <td><em>Convolution</em></td> <td><em>Yes</em></td></tr></tbody>',Vl,N,Nl,S,EM="The four main highlights of CvT that helped achieve superior performance and computational efficiency are the following:",Sl,G,_M="<li><strong>Hierarchy of Transformers</strong> containing a new <strong>Convolutional token embedding</strong>.</li> <li>Convolutional Transformer block leveraging a <strong>Convolutional Projection</strong>.</li> <li><strong>Removal of Positional Encoding</strong> due to built-in local context structure introduced by convolutions.</li> <li>Fewer <strong>Parameters</strong> and lower <strong>FLOPs</strong> (Floating Point Operations per second) compared to other vision transformer architectures.</li>",Gl,W,Wl,z,QM='Time to get hands-on! Let’s explore how to code each major blocks of the CvT architecture in PyTorch shown in the official implementation <a href="#cvt-imp">[8]</a>.',zl,H,ZM="<li>Importing required libraries</li>",Hl,x,xl,p,RM="<li>Implementation of <strong>Convolutional Projection</strong></li>",Xl,X,Yl,Y,VM="The method takes several parameters related to a convolutional layer (such as input and output dimensions, kernel size, padding, stride, and method) and returns a projection block based on the specified method.",ql,q,NM="<li><p>If the method is <code>dw_bn</code> (depthwise separable with batch normalization), it creates a Sequential block consisting of a depthwise separable convolutional layer followed by batch normalization and rearranges the dimensions.</p></li> <li><p>If the method is <code>avg</code> (average pooling), it creates a Sequential block with an average pooling layer followed by rearranging the dimensions.</p></li> <li><p>If the method is <code>linear</code>, it returns None, indicating that no projection is applied.</p></li>",Fl,F,SM="The rearrangement of dimensions is performed using the <code>Rearrange</code> operation, which reshapes the input tensor. The resulting projection block is then returned.",$l,I,GM="<li>Implementation of <strong>Convolutional Token Embedding</strong></li>",Ll,$,Dl,L,WM="This code defines a ConvEmbed module that performs patch-wise embedding on an input image.",Kl,D,zM="<li><p>The <code>__init__</code> method initializes the module with parameters such as <code>patch_size</code> (size of the image patches), <code>in_chans</code> (number of input channels), <code>embed_dim</code> (dimensionality of the embedded patches), <code>stride</code> (stride for the convolution operation), <code>padding</code> (padding for the convolution operation), and <code>norm_layer</code> (a normalization layer, which is optional).</p></li> <li><p>In the constructor, a 2D convolutional layer (<code>nn.Conv2d</code>) is created with specified parameters, including the patch size, input channels, embedding dimension, stride, and padding. This convolutional layer is assigned to <code>self.proj</code>.</p></li> <li><p>If a normalization layer is provided, an instance of the normalization layer is created with embed_dim channels, and it is assigned to <code>self.norm</code>.</p></li> <li><p>The forward method takes an input tensor x and applies the convolution operation using <code>self.proj</code>. The output is reshaped using the rearrange function to flatten the spatial dimensions. If a normalization layer is present, it is applied to the flattened representation. Finally, the tensor is reshaped back to the original spatial dimensions and returned.</p></li>",Pl,K,HM="In summary, this module is designed for patch-wise embedding of images, where each patch is processed independently through a convolutional layer, and optional normalization is applied to the embedded features.",Ol,c,xM="<li>Implementation of <strong>Vision Transformer</strong> Block</li>",lM,P,MM,O,XM="This code defines a Vision Transformer module. Here’s a brief overview of the code:",eM,ll,YM="<li><p><strong>Initialization:</strong> The <code>VisionTransformer</code> class is initialized with various parameters that define the model architecture, such as patch size, embedding dimensions, number of layers, number of attention heads, dropout rates, etc.</p></li> <li><p><strong>Patch Embedding:</strong> The model includes a patch embedding layer (`patch_embed), which processes the input image by dividing it into non-overlapping patches and embedding them using Convolutions.</p></li> <li><p><strong>Transformer Blocks:</strong> The model consists of a stack of transformer blocks (<code>Block</code>). The number of blocks is determined by the depth parameter. Each block contains multi-head self-attention mechanisms and a feedforward neural network.</p></li> <li><p><strong>Classification Token:</strong> Optionally, the model can include a learnable classification token (<code>cls_token</code>) appended to the input sequence. This token is used for classification tasks.</p></li> <li><p><strong>Stochastic Depth:</strong> Stochastic depth is applied to the transformer blocks, where a random subset of blocks is skipped during training to improve regularization. This is controlled by the <code>drop_path_rate</code> parameter.</p></li> <li><p><strong>Initialization of Weights:</strong> The model weights are initialized using either truncated normal distribution (<code>trunc_norm</code>) or Xavier initialization (<code>xavier</code>).</p></li> <li><p><strong>Forward Method:</strong> The forward method processes the input through the patch embedding, rearranges the dimensions, adds the classification token if present, applies dropout, and then passes the data through the stack of transformer blocks. Finally, the output is rearranged back to the original shape, and the classification token (if present) is separated from the rest of the sequence before returning the output.</p></li>",sM,m,qM="<li>Implementation of Convolutional Vision Transformer Block (<strong>Hierarchy of Transformers</strong>)</li>",tM,Ml,nM,el,FM="This code defines a PyTorch module called <code>ConvolutionalVisionTransformer</code>.",aM,sl,$M="<li>The model consists of multiple stages, each represented by an instance of the <code>VisionTransformer</code> class.</li> <li>Each stage has different configurations such as patch size, stride, depth, number of heads, etc., specified in the spec dictionary.</li> <li>The <code>forward_features</code> method processes the input x through all the stages, and it aggregates the final representation.</li> <li>The class has a classifier head that performs a linear transformation to produce the final output.</li> <li>The <code>forward</code> method calls <code>forward_features</code> and then passes the result through the classifier head.</li> <li>The vision transformer stages are sequentially named as stage0, stage1, etc., and each stage is an instance of the <code>VisionTransformer</code> class forming a hierarchy of transformers.</li>",yM,tl,LM='Congratulations! Now you know how to implement CvT architecture in PyTorch. You can view complete code of the CvT architecture <a href="https://github.com/microsoft/CvT/blob/main/lib/models/cls_cvt.py" rel="nofollow">here</a>.',iM,nl,UM,al,DM="If you’re looking to use CvT without getting into the complex details of its PyTorch implementation, you can easily do so by leveraging the Hugging Face <code>transformers</code> library. Here’s how:",TM,yl,oM,il,KM='You can find the documentation for CvT model <a href="https://huggingface.co/docs/transformers/model_doc/cvt#overview" rel="nofollow">here</a>.',JM,Ul,wM,Tl,PM="Here is how to use CvT model to classify an image of the COCO 2017 dataset into one of the 1,000 ImageNet classes:",CM,ol,rM,Jl,jM,wl,OM='<li><a href="https://arxiv.org/abs/2010.11929" rel="nofollow">An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale</a> <a id="vision-transformer"></a></li> <li><a href="https://arxiv.org/abs/2103.15808" rel="nofollow">CvT: Introducing Convolutions to Vision Transformers</a> <a id="cvt"></a></li> <li><a href="https://arxiv.org/abs/2012.12877" rel="nofollow">Training data-efficient image transformers &amp; distillation through attention</a> <a id="deit"></a></li> <li><a href="https://arxiv.org/abs/2102.10882" rel="nofollow">Conditional Positional Encodings for Vision Transformers</a> <a id="cpvt"></a></li> <li><a href="https://arxiv.org/abs/2103.00112v3" rel="nofollow">Transformer in Transformer</a><a id="tnt"></a></li> <li><a href="https://arxiv.org/abs/2101.11986" rel="nofollow">Tokens-to-Token ViT: Training Vision Transformers from Scratch on ImageNet</a> <a id="t2t"></a></li> <li><a href="https://arxiv.org/abs/2102.12122" rel="nofollow">Pyramid Vision Transformer: A Versatile Backbone for Dense Prediction without Convolutions</a> <a id="pvt"></a></li> <li><a href="https://github.com/microsoft/CvT/tree/main" rel="nofollow">Implementation of CvT</a> <a id="cvt-imp"></a></li>',pM,Cl,IM,Il,cM;return d=new ie({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new r({props:{title:"Convolutional Vision Transformer (CvT)",local:"convolutional-vision-transformer-cvt",headingTag:"h1"}}),u=new r({props:{title:"Recap",local:"recap",headingTag:"h2"}}),b=new r({props:{title:"Overview",local:"overview",headingTag:"h2"}}),B=new r({props:{title:"Architecture",local:"architecture",headingTag:"h2"}}),Z=new r({props:{title:"Comparision of CvT Architecture with other Vision Transformers",local:"comparision-of-cvt-architecture-with-other-vision-transformers",headingTag:"h3"}}),N=new r({props:{title:"Main Highlights",local:"main-highlights",headingTag:"h3"}}),W=new r({props:{title:"PyTorch Implementation",local:"pytorch-implementation",headingTag:"h2"}}),x=new rl({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwT3JkZXJlZERpY3QlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHRvcmNoLm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBhcyUyMEYlMEFmcm9tJTIwZWlub3BzJTIwaW1wb3J0JTIwcmVhcnJhbmdlJTBBZnJvbSUyMGVpbm9wcy5sYXllcnMudG9yY2glMjBpbXBvcnQlMjBSZWFycmFuZ2U=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> OrderedDict
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">from</span> einops <span class="hljs-keyword">import</span> rearrange
<span class="hljs-keyword">from</span> einops.layers.torch <span class="hljs-keyword">import</span> Rearrange`,wrap:!1}}),X=new rl({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_build_projection</span>(<span class="hljs-params">self, dim_in, dim_out, kernel_size, padding, stride, method</span>):
    <span class="hljs-keyword">if</span> method == <span class="hljs-string">&quot;dw_bn&quot;</span>:
        proj = nn.Sequential(
            OrderedDict(
                [
                    (
                        <span class="hljs-string">&quot;conv&quot;</span>,
                        nn.Conv2d(
                            dim_in,
                            dim_in,
                            kernel_size=kernel_size,
                            padding=padding,
                            stride=stride,
                            bias=<span class="hljs-literal">False</span>,
                            groups=dim_in,
                        ),
                    ),
                    (<span class="hljs-string">&quot;bn&quot;</span>, nn.BatchNorm2d(dim_in)),
                    (<span class="hljs-string">&quot;rearrage&quot;</span>, Rearrange(<span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)),
                ]
            )
        )
    <span class="hljs-keyword">elif</span> method == <span class="hljs-string">&quot;avg&quot;</span>:
        proj = nn.Sequential(
            OrderedDict(
                [
                    (
                        <span class="hljs-string">&quot;avg&quot;</span>,
                        nn.AvgPool2d(
                            kernel_size=kernel_size,
                            padding=padding,
                            stride=stride,
                            ceil_mode=<span class="hljs-literal">True</span>,
                        ),
                    ),
                    (<span class="hljs-string">&quot;rearrage&quot;</span>, Rearrange(<span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)),
                ]
            )
        )
    <span class="hljs-keyword">elif</span> method == <span class="hljs-string">&quot;linear&quot;</span>:
        proj = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Unknown method ({})&quot;</span>.<span class="hljs-built_in">format</span>(method))

    <span class="hljs-keyword">return</span> proj`,wrap:!1}}),$=new rl({props:{code:"Y2xhc3MlMjBDb252RW1iZWQobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMjBwYXRjaF9zaXplJTNENyUyQyUyMGluX2NoYW5zJTNEMyUyQyUyMGVtYmVkX2RpbSUzRDY0JTJDJTIwc3RyaWRlJTNENCUyQyUyMHBhZGRpbmclM0QyJTJDJTIwbm9ybV9sYXllciUzRE5vbmUlMEElMjAlMjAlMjAlMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0Y2hfc2l6ZSUyMCUzRCUyMHRvXzJ0dXBsZShwYXRjaF9zaXplKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGF0Y2hfc2l6ZSUyMCUzRCUyMHBhdGNoX3NpemUlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnByb2olMjAlM0QlMjBubi5Db252MmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5fY2hhbnMlMkMlMjBlbWJlZF9kaW0lMkMlMjBrZXJuZWxfc2l6ZSUzRHBhdGNoX3NpemUlMkMlMjBzdHJpZGUlM0RzdHJpZGUlMkMlMjBwYWRkaW5nJTNEcGFkZGluZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm5vcm0lMjAlM0QlMjBub3JtX2xheWVyKGVtYmVkX2RpbSklMjBpZiUyMG5vcm1fbGF5ZXIlMjBlbHNlJTIwTm9uZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYucHJvaih4KSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEIlMkMlMjBDJTJDJTIwSCUyQyUyMFclMjAlM0QlMjB4LnNoYXBlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHJlYXJyYW5nZSh4JTJDJTIwJTIyYiUyMGMlMjBoJTIwdyUyMC0lM0UlMjBiJTIwKGglMjB3KSUyMGMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLm5vcm0lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5ub3JtKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHJlYXJyYW5nZSh4JTJDJTIwJTIyYiUyMChoJTIwdyklMjBjJTIwLSUzRSUyMGIlMjBjJTIwaCUyMHclMjIlMkMlMjBoJTNESCUyQyUyMHclM0RXKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHg=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ConvEmbed</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self, patch_size=<span class="hljs-number">7</span>, in_chans=<span class="hljs-number">3</span>, embed_dim=<span class="hljs-number">64</span>, stride=<span class="hljs-number">4</span>, padding=<span class="hljs-number">2</span>, norm_layer=<span class="hljs-literal">None</span>
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        patch_size = to_2tuple(patch_size)
        self.patch_size = patch_size

        self.proj = nn.Conv2d(
            in_chans, embed_dim, kernel_size=patch_size, stride=stride, padding=padding
        )
        self.norm = norm_layer(embed_dim) <span class="hljs-keyword">if</span> norm_layer <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.proj(x)

        B, C, H, W = x.shape
        x = rearrange(x, <span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)
        <span class="hljs-keyword">if</span> self.norm:
            x = self.norm(x)
        x = rearrange(x, <span class="hljs-string">&quot;b (h w) c -&gt; b c h w&quot;</span>, h=H, w=W)

        <span class="hljs-keyword">return</span> x`,wrap:!1}}),P=new rl({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">VisionTransformer</span>(nn.Module):
    <span class="hljs-string">&quot;&quot;&quot;Vision Transformer with support for patch or hybrid CNN input stage&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        patch_size=<span class="hljs-number">16</span>,
        patch_stride=<span class="hljs-number">16</span>,
        patch_padding=<span class="hljs-number">0</span>,
        in_chans=<span class="hljs-number">3</span>,
        embed_dim=<span class="hljs-number">768</span>,
        depth=<span class="hljs-number">12</span>,
        num_heads=<span class="hljs-number">12</span>,
        mlp_ratio=<span class="hljs-number">4.0</span>,
        qkv_bias=<span class="hljs-literal">False</span>,
        drop_rate=<span class="hljs-number">0.0</span>,
        attn_drop_rate=<span class="hljs-number">0.0</span>,
        drop_path_rate=<span class="hljs-number">0.0</span>,
        act_layer=nn.GELU,
        norm_layer=nn.LayerNorm,
        init=<span class="hljs-string">&quot;trunc_norm&quot;</span>,
        **kwargs,
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.num_features = self.embed_dim = embed_dim

        self.rearrage = <span class="hljs-literal">None</span>

        self.patch_embed = ConvEmbed(
            patch_size=patch_size,
            in_chans=in_chans,
            stride=patch_stride,
            padding=patch_padding,
            embed_dim=embed_dim,
            norm_layer=norm_layer,
        )

        with_cls_token = kwargs[<span class="hljs-string">&quot;with_cls_token&quot;</span>]
        <span class="hljs-keyword">if</span> with_cls_token:
            self.cls_token = nn.Parameter(torch.zeros(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, embed_dim))
        <span class="hljs-keyword">else</span>:
            self.cls_token = <span class="hljs-literal">None</span>

        self.pos_drop = nn.Dropout(p=drop_rate)
        dpr = [
            x.item() <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> torch.linspace(<span class="hljs-number">0</span>, drop_path_rate, depth)
        ]  <span class="hljs-comment"># stochastic depth decay rule</span>

        blocks = []
        <span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(depth):
            blocks.append(
                Block(
                    dim_in=embed_dim,
                    dim_out=embed_dim,
                    num_heads=num_heads,
                    mlp_ratio=mlp_ratio,
                    qkv_bias=qkv_bias,
                    drop=drop_rate,
                    attn_drop=attn_drop_rate,
                    drop_path=dpr[j],
                    act_layer=act_layer,
                    norm_layer=norm_layer,
                    **kwargs,
                )
            )
        self.blocks = nn.ModuleList(blocks)

        <span class="hljs-keyword">if</span> self.cls_token <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            trunc_normal_(self.cls_token, std=<span class="hljs-number">0.02</span>)

        <span class="hljs-keyword">if</span> init == <span class="hljs-string">&quot;xavier&quot;</span>:
            self.apply(self._init_weights_xavier)
        <span class="hljs-keyword">else</span>:
            self.apply(self._init_weights_trunc_normal)

        <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
            x = self.patch_embed(x)
            B, C, H, W = x.size()

            x = rearrange(x, <span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)

            cls_tokens = <span class="hljs-literal">None</span>
            <span class="hljs-keyword">if</span> self.cls_token <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                cls_tokens = self.cls_token.expand(B, -<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)
                x = torch.cat((cls_tokens, x), dim=<span class="hljs-number">1</span>)

            x = self.pos_drop(x)

            <span class="hljs-keyword">for</span> i, blk <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(self.blocks):
                x = blk(x, H, W)

            <span class="hljs-keyword">if</span> self.cls_token <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                cls_tokens, x = torch.split(x, [<span class="hljs-number">1</span>, H * W], <span class="hljs-number">1</span>)
            x = rearrange(x, <span class="hljs-string">&quot;b (h w) c -&gt; b c h w&quot;</span>, h=H, w=W)

            <span class="hljs-keyword">return</span> x, cls_tokens`,wrap:!1}}),Ml=new rl({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ConvolutionalVisionTransformer</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        in_chans=<span class="hljs-number">3</span>,
        num_classes=<span class="hljs-number">1000</span>,
        act_layer=nn.GELU,
        norm_layer=nn.LayerNorm,
        init=<span class="hljs-string">&quot;trunc_norm&quot;</span>,
        spec=<span class="hljs-literal">None</span>,
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.num_classes = num_classes

        self.num_stages = spec[<span class="hljs-string">&quot;NUM_STAGES&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.num_stages):
            kwargs = {
                <span class="hljs-string">&quot;patch_size&quot;</span>: spec[<span class="hljs-string">&quot;PATCH_SIZE&quot;</span>][i],
                <span class="hljs-string">&quot;patch_stride&quot;</span>: spec[<span class="hljs-string">&quot;PATCH_STRIDE&quot;</span>][i],
                <span class="hljs-string">&quot;patch_padding&quot;</span>: spec[<span class="hljs-string">&quot;PATCH_PADDING&quot;</span>][i],
                <span class="hljs-string">&quot;embed_dim&quot;</span>: spec[<span class="hljs-string">&quot;DIM_EMBED&quot;</span>][i],
                <span class="hljs-string">&quot;depth&quot;</span>: spec[<span class="hljs-string">&quot;DEPTH&quot;</span>][i],
                <span class="hljs-string">&quot;num_heads&quot;</span>: spec[<span class="hljs-string">&quot;NUM_HEADS&quot;</span>][i],
                <span class="hljs-string">&quot;mlp_ratio&quot;</span>: spec[<span class="hljs-string">&quot;MLP_RATIO&quot;</span>][i],
                <span class="hljs-string">&quot;qkv_bias&quot;</span>: spec[<span class="hljs-string">&quot;QKV_BIAS&quot;</span>][i],
                <span class="hljs-string">&quot;drop_rate&quot;</span>: spec[<span class="hljs-string">&quot;DROP_RATE&quot;</span>][i],
                <span class="hljs-string">&quot;attn_drop_rate&quot;</span>: spec[<span class="hljs-string">&quot;ATTN_DROP_RATE&quot;</span>][i],
                <span class="hljs-string">&quot;drop_path_rate&quot;</span>: spec[<span class="hljs-string">&quot;DROP_PATH_RATE&quot;</span>][i],
                <span class="hljs-string">&quot;with_cls_token&quot;</span>: spec[<span class="hljs-string">&quot;CLS_TOKEN&quot;</span>][i],
                <span class="hljs-string">&quot;method&quot;</span>: spec[<span class="hljs-string">&quot;QKV_PROJ_METHOD&quot;</span>][i],
                <span class="hljs-string">&quot;kernel_size&quot;</span>: spec[<span class="hljs-string">&quot;KERNEL_QKV&quot;</span>][i],
                <span class="hljs-string">&quot;padding_q&quot;</span>: spec[<span class="hljs-string">&quot;PADDING_Q&quot;</span>][i],
                <span class="hljs-string">&quot;padding_kv&quot;</span>: spec[<span class="hljs-string">&quot;PADDING_KV&quot;</span>][i],
                <span class="hljs-string">&quot;stride_kv&quot;</span>: spec[<span class="hljs-string">&quot;STRIDE_KV&quot;</span>][i],
                <span class="hljs-string">&quot;stride_q&quot;</span>: spec[<span class="hljs-string">&quot;STRIDE_Q&quot;</span>][i],
            }

            stage = VisionTransformer(
                in_chans=in_chans,
                init=init,
                act_layer=act_layer,
                norm_layer=norm_layer,
                **kwargs,
            )
            <span class="hljs-built_in">setattr</span>(self, <span class="hljs-string">f&quot;stage<span class="hljs-subst">{i}</span>&quot;</span>, stage)

            in_chans = spec[<span class="hljs-string">&quot;DIM_EMBED&quot;</span>][i]

        dim_embed = spec[<span class="hljs-string">&quot;DIM_EMBED&quot;</span>][-<span class="hljs-number">1</span>]
        self.norm = norm_layer(dim_embed)
        self.cls_token = spec[<span class="hljs-string">&quot;CLS_TOKEN&quot;</span>][-<span class="hljs-number">1</span>]

        <span class="hljs-comment"># Classifier head</span>
        self.head = (
            nn.Linear(dim_embed, num_classes) <span class="hljs-keyword">if</span> num_classes &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> nn.Identity()
        )
        trunc_normal_(self.head.weight, std=<span class="hljs-number">0.02</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward_features</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.num_stages):
            x, cls_tokens = <span class="hljs-built_in">getattr</span>(self, <span class="hljs-string">f&quot;stage<span class="hljs-subst">{i}</span>&quot;</span>)(x)

        <span class="hljs-keyword">if</span> self.cls_token:
            x = self.norm(cls_tokens)
            x = torch.squeeze(x)
        <span class="hljs-keyword">else</span>:
            x = rearrange(x, <span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)
            x = self.norm(x)
            x = torch.mean(x, dim=<span class="hljs-number">1</span>)

        <span class="hljs-keyword">return</span> x

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.forward_features(x)
        x = self.head(x)

        <span class="hljs-keyword">return</span> x`,wrap:!1}}),nl=new r({props:{title:"Try it out",local:"try-it-out",headingTag:"h2"}}),yl=new rl({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),Ul=new r({props:{title:"Usage",local:"usage",headingTag:"h3"}}),ol=new rl({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwQ3Z0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmN2dC0xMyUyMiklMEFtb2RlbCUyMCUzRCUyMEN2dEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmN2dC0xMyUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHglNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, CvtForImageClassification
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;microsoft/cvt-13&quot;</span>)
model = CvtForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/cvt-13&quot;</span>)

inputs = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)
logits = outputs.logits
<span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),Jl=new r({props:{title:"References",local:"references",headingTag:"h2"}}),Cl=new Ue({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit3/vision-transformers/cvt.mdx"}}),{c(){j=a("meta"),cl=t(),pl=a("p"),ml=t(),U(d.$$.fragment),dl=t(),U(h.$$.fragment),hl=t(),A=a("p"),A.innerHTML=dM,Al=t(),U(u.$$.fragment),ul=t(),f=a("p"),f.textContent=hM,fl=t(),U(b.$$.fragment),bl=t(),g=a("p"),g.innerHTML=AM,gl=t(),U(B.$$.fragment),Bl=t(),k=a("p"),k.innerHTML=uM,kl=t(),v=a("p"),v.textContent=fM,vl=t(),E=a("ul"),E.innerHTML=bM,El=t(),_=a("p"),_.innerHTML=gM,_l=t(),Q=a("ul"),Q.innerHTML=BM,Ql=t(),U(Z.$$.fragment),Zl=t(),R=a("p"),R.textContent=kM,Rl=t(),V=a("table"),V.innerHTML=vM,Vl=t(),U(N.$$.fragment),Nl=t(),S=a("p"),S.textContent=EM,Sl=t(),G=a("ul"),G.innerHTML=_M,Gl=t(),U(W.$$.fragment),Wl=t(),z=a("p"),z.innerHTML=QM,zl=t(),H=a("ol"),H.innerHTML=ZM,Hl=t(),U(x.$$.fragment),xl=t(),p=a("ol"),p.innerHTML=RM,Xl=t(),U(X.$$.fragment),Yl=t(),Y=a("p"),Y.textContent=VM,ql=t(),q=a("ul"),q.innerHTML=NM,Fl=t(),F=a("p"),F.innerHTML=SM,$l=t(),I=a("ol"),I.innerHTML=GM,Ll=t(),U($.$$.fragment),Dl=t(),L=a("p"),L.textContent=WM,Kl=t(),D=a("ul"),D.innerHTML=zM,Pl=t(),K=a("p"),K.textContent=HM,Ol=t(),c=a("ol"),c.innerHTML=xM,lM=t(),U(P.$$.fragment),MM=t(),O=a("p"),O.textContent=XM,eM=t(),ll=a("ul"),ll.innerHTML=YM,sM=t(),m=a("ol"),m.innerHTML=qM,tM=t(),U(Ml.$$.fragment),nM=t(),el=a("p"),el.innerHTML=FM,aM=t(),sl=a("ul"),sl.innerHTML=$M,yM=t(),tl=a("p"),tl.innerHTML=LM,iM=t(),U(nl.$$.fragment),UM=t(),al=a("p"),al.innerHTML=DM,TM=t(),U(yl.$$.fragment),oM=t(),il=a("p"),il.innerHTML=KM,JM=t(),U(Ul.$$.fragment),wM=t(),Tl=a("p"),Tl.textContent=PM,CM=t(),U(ol.$$.fragment),rM=t(),U(Jl.$$.fragment),jM=t(),wl=a("ul"),wl.innerHTML=OM,pM=t(),U(Cl.$$.fragment),IM=t(),Il=a("p"),this.h()},l(l){const M=ae("svelte-u9bgzb",document.head);j=y(M,"META",{name:!0,content:!0}),M.forEach(e),cl=n(l),pl=y(l,"P",{}),le(pl).forEach(e),ml=n(l),T(d.$$.fragment,l),dl=n(l),T(h.$$.fragment,l),hl=n(l),A=y(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-16sbh2z"&&(A.innerHTML=dM),Al=n(l),T(u.$$.fragment,l),ul=n(l),f=y(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-h8g8bs"&&(f.textContent=hM),fl=n(l),T(b.$$.fragment,l),bl=n(l),g=y(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-6zwop"&&(g.innerHTML=AM),gl=n(l),T(B.$$.fragment,l),Bl=n(l),k=y(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-8qvbjw"&&(k.innerHTML=uM),kl=n(l),v=y(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1hpmpi2"&&(v.textContent=fM),vl=n(l),E=y(l,"UL",{"data-svelte-h":!0}),i(E)!=="svelte-8uqhj0"&&(E.innerHTML=bM),El=n(l),_=y(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-19dxdy5"&&(_.innerHTML=gM),_l=n(l),Q=y(l,"UL",{"data-svelte-h":!0}),i(Q)!=="svelte-1dr5apn"&&(Q.innerHTML=BM),Ql=n(l),T(Z.$$.fragment,l),Zl=n(l),R=y(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-rzznkl"&&(R.textContent=kM),Rl=n(l),V=y(l,"TABLE",{"data-svelte-h":!0}),i(V)!=="svelte-d2nidq"&&(V.innerHTML=vM),Vl=n(l),T(N.$$.fragment,l),Nl=n(l),S=y(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1cwmxe6"&&(S.textContent=EM),Sl=n(l),G=y(l,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-18fic2x"&&(G.innerHTML=_M),Gl=n(l),T(W.$$.fragment,l),Wl=n(l),z=y(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-n5s215"&&(z.innerHTML=QM),zl=n(l),H=y(l,"OL",{"data-svelte-h":!0}),i(H)!=="svelte-1iuw5nq"&&(H.innerHTML=ZM),Hl=n(l),T(x.$$.fragment,l),xl=n(l),p=y(l,"OL",{start:!0,"data-svelte-h":!0}),i(p)!=="svelte-1nmeitm"&&(p.innerHTML=RM),Xl=n(l),T(X.$$.fragment,l),Yl=n(l),Y=y(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-16rc2tn"&&(Y.textContent=VM),ql=n(l),q=y(l,"UL",{"data-svelte-h":!0}),i(q)!=="svelte-1cz11rv"&&(q.innerHTML=NM),Fl=n(l),F=y(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-14plira"&&(F.innerHTML=SM),$l=n(l),I=y(l,"OL",{start:!0,"data-svelte-h":!0}),i(I)!=="svelte-wkbrt0"&&(I.innerHTML=GM),Ll=n(l),T($.$$.fragment,l),Dl=n(l),L=y(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1ecejkd"&&(L.textContent=WM),Kl=n(l),D=y(l,"UL",{"data-svelte-h":!0}),i(D)!=="svelte-1f6lcgb"&&(D.innerHTML=zM),Pl=n(l),K=y(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-16mpu0t"&&(K.textContent=HM),Ol=n(l),c=y(l,"OL",{start:!0,"data-svelte-h":!0}),i(c)!=="svelte-71ryog"&&(c.innerHTML=xM),lM=n(l),T(P.$$.fragment,l),MM=n(l),O=y(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-g3l3ba"&&(O.textContent=XM),eM=n(l),ll=y(l,"UL",{"data-svelte-h":!0}),i(ll)!=="svelte-h46hn5"&&(ll.innerHTML=YM),sM=n(l),m=y(l,"OL",{start:!0,"data-svelte-h":!0}),i(m)!=="svelte-6qayo5"&&(m.innerHTML=qM),tM=n(l),T(Ml.$$.fragment,l),nM=n(l),el=y(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-pi1s51"&&(el.innerHTML=FM),aM=n(l),sl=y(l,"UL",{"data-svelte-h":!0}),i(sl)!=="svelte-5gyfbr"&&(sl.innerHTML=$M),yM=n(l),tl=y(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-r9bolc"&&(tl.innerHTML=LM),iM=n(l),T(nl.$$.fragment,l),UM=n(l),al=y(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-62j7m0"&&(al.innerHTML=DM),TM=n(l),T(yl.$$.fragment,l),oM=n(l),il=y(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1ss8190"&&(il.innerHTML=KM),JM=n(l),T(Ul.$$.fragment,l),wM=n(l),Tl=y(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-5w7pre"&&(Tl.textContent=PM),CM=n(l),T(ol.$$.fragment,l),rM=n(l),T(Jl.$$.fragment,l),jM=n(l),wl=y(l,"UL",{"data-svelte-h":!0}),i(wl)!=="svelte-1m285ue"&&(wl.innerHTML=OM),pM=n(l),T(Cl.$$.fragment,l),IM=n(l),Il=y(l,"P",{}),le(Il).forEach(e),this.h()},h(){jl(j,"name","hf:doc:metadata"),jl(j,"content",oe),jl(p,"start","2"),jl(I,"start","3"),jl(c,"start","4"),jl(m,"start","5")},m(l,M){ye(document.head,j),s(l,cl,M),s(l,pl,M),s(l,ml,M),o(d,l,M),s(l,dl,M),o(h,l,M),s(l,hl,M),s(l,A,M),s(l,Al,M),o(u,l,M),s(l,ul,M),s(l,f,M),s(l,fl,M),o(b,l,M),s(l,bl,M),s(l,g,M),s(l,gl,M),o(B,l,M),s(l,Bl,M),s(l,k,M),s(l,kl,M),s(l,v,M),s(l,vl,M),s(l,E,M),s(l,El,M),s(l,_,M),s(l,_l,M),s(l,Q,M),s(l,Ql,M),o(Z,l,M),s(l,Zl,M),s(l,R,M),s(l,Rl,M),s(l,V,M),s(l,Vl,M),o(N,l,M),s(l,Nl,M),s(l,S,M),s(l,Sl,M),s(l,G,M),s(l,Gl,M),o(W,l,M),s(l,Wl,M),s(l,z,M),s(l,zl,M),s(l,H,M),s(l,Hl,M),o(x,l,M),s(l,xl,M),s(l,p,M),s(l,Xl,M),o(X,l,M),s(l,Yl,M),s(l,Y,M),s(l,ql,M),s(l,q,M),s(l,Fl,M),s(l,F,M),s(l,$l,M),s(l,I,M),s(l,Ll,M),o($,l,M),s(l,Dl,M),s(l,L,M),s(l,Kl,M),s(l,D,M),s(l,Pl,M),s(l,K,M),s(l,Ol,M),s(l,c,M),s(l,lM,M),o(P,l,M),s(l,MM,M),s(l,O,M),s(l,eM,M),s(l,ll,M),s(l,sM,M),s(l,m,M),s(l,tM,M),o(Ml,l,M),s(l,nM,M),s(l,el,M),s(l,aM,M),s(l,sl,M),s(l,yM,M),s(l,tl,M),s(l,iM,M),o(nl,l,M),s(l,UM,M),s(l,al,M),s(l,TM,M),o(yl,l,M),s(l,oM,M),s(l,il,M),s(l,JM,M),o(Ul,l,M),s(l,wM,M),s(l,Tl,M),s(l,CM,M),o(ol,l,M),s(l,rM,M),o(Jl,l,M),s(l,jM,M),s(l,wl,M),s(l,pM,M),o(Cl,l,M),s(l,IM,M),s(l,Il,M),cM=!0},p:ee,i(l){cM||(J(d.$$.fragment,l),J(h.$$.fragment,l),J(u.$$.fragment,l),J(b.$$.fragment,l),J(B.$$.fragment,l),J(Z.$$.fragment,l),J(N.$$.fragment,l),J(W.$$.fragment,l),J(x.$$.fragment,l),J(X.$$.fragment,l),J($.$$.fragment,l),J(P.$$.fragment,l),J(Ml.$$.fragment,l),J(nl.$$.fragment,l),J(yl.$$.fragment,l),J(Ul.$$.fragment,l),J(ol.$$.fragment,l),J(Jl.$$.fragment,l),J(Cl.$$.fragment,l),cM=!0)},o(l){w(d.$$.fragment,l),w(h.$$.fragment,l),w(u.$$.fragment,l),w(b.$$.fragment,l),w(B.$$.fragment,l),w(Z.$$.fragment,l),w(N.$$.fragment,l),w(W.$$.fragment,l),w(x.$$.fragment,l),w(X.$$.fragment,l),w($.$$.fragment,l),w(P.$$.fragment,l),w(Ml.$$.fragment,l),w(nl.$$.fragment,l),w(yl.$$.fragment,l),w(Ul.$$.fragment,l),w(ol.$$.fragment,l),w(Jl.$$.fragment,l),w(Cl.$$.fragment,l),cM=!1},d(l){l&&(e(cl),e(pl),e(ml),e(dl),e(hl),e(A),e(Al),e(ul),e(f),e(fl),e(bl),e(g),e(gl),e(Bl),e(k),e(kl),e(v),e(vl),e(E),e(El),e(_),e(_l),e(Q),e(Ql),e(Zl),e(R),e(Rl),e(V),e(Vl),e(Nl),e(S),e(Sl),e(G),e(Gl),e(Wl),e(z),e(zl),e(H),e(Hl),e(xl),e(p),e(Xl),e(Yl),e(Y),e(ql),e(q),e(Fl),e(F),e($l),e(I),e(Ll),e(Dl),e(L),e(Kl),e(D),e(Pl),e(K),e(Ol),e(c),e(lM),e(MM),e(O),e(eM),e(ll),e(sM),e(m),e(tM),e(nM),e(el),e(aM),e(sl),e(yM),e(tl),e(iM),e(UM),e(al),e(TM),e(oM),e(il),e(JM),e(wM),e(Tl),e(CM),e(rM),e(jM),e(wl),e(pM),e(IM),e(Il)),e(j),C(d,l),C(h,l),C(u,l),C(b,l),C(B,l),C(Z,l),C(N,l),C(W,l),C(x,l),C(X,l),C($,l),C(P,l),C(Ml,l),C(nl,l),C(yl,l),C(Ul,l),C(ol,l),C(Jl,l),C(Cl,l)}}}const oe='{"title":"Convolutional Vision Transformer (CvT)","local":"convolutional-vision-transformer-cvt","sections":[{"title":"Recap","local":"recap","sections":[],"depth":2},{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Architecture","local":"architecture","sections":[{"title":"Comparision of CvT Architecture with other Vision Transformers","local":"comparision-of-cvt-architecture-with-other-vision-transformers","sections":[],"depth":3},{"title":"Main Highlights","local":"main-highlights","sections":[],"depth":3}],"depth":2},{"title":"PyTorch Implementation","local":"pytorch-implementation","sections":[],"depth":2},{"title":"Try it out","local":"try-it-out","sections":[{"title":"Usage","local":"usage","sections":[],"depth":3}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Je(mM){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends te{constructor(j){super(),ne(this,j,Je,Te,Me,{})}}export{Ie as component};
