import{s as _t,n as Vt,o as zt}from"../chunks/scheduler.35aab934.js";import{S as Yt,i as Xt,e as d,s as n,c as i,h as Ht,a as m,d as s,b as a,f as Gt,g as o,j as h,k as Dt,l as Lt,m as l,n as r,t as M,o as p,p as c}from"../chunks/index.de17b971.js";import{C as St}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as f}from"../chunks/CodeBlock.c1f62de5.js";import{H as u,E as qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function Ft(ut){let b,fe,he,be,y,ye,j,je,T,Te,w,ft=`DETR is mainly used for object detection tasks, which is the process of detecting objects in an image. For example, the input of the model would be an image of a road, and the output of the model could be <code>[(&#39;car&#39;,X1,Y1,W1,H1),(&#39;pedestrian&#39;,X2,Y2,W2,H2)]</code>, in which X, Y, W, H represent the x, y coordinates denoting the location of the bounding box, as well as the width and height of the box.
A traditional object detection model like YOLO consists of hand-crafted features like anchor box priors, which requires initial guesses of object locations and shapes, affecting downstream training. Post-processing steps are then used to remove overlapping bounding boxes, which require careful selection of its filtering heuristics.
DEtection TRansformer, DETR for short, simplifies the detector by using an encoder-decoder transformer after the feature extraction backbone to directly predict bounding boxes in parallel, requiring minimal post-processing.`,we,J,bt=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR.png" alt="Architecture Diagram of DETR"/>
The model architecture of DETR begins with a CNN backbone, similar to other image-based networks, the output of which is processed and fed into a transformer encoder, resulting in N embeddings. The encoder embeddings are added to learned positional embeddings (called object queries) and used in a transformer decoder, generating another N embeddings. As a final step, each of the N embeddings are put through individual feed forward layers to predict the width, height, coordinates of the bounding box, as well as the object class (or whether there is an object).`,Je,U,Ue,g,ge,C,yt=`As with other transformers, the transformer encoder expects the output of the CNN backbone to be a sequence. Thus, the feature map of size <code>[dimension, height, width]</code> is downsized and then flattened to <code>[dimension, less than height x width]</code>.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR_FeatureMaps.png" alt="Feature Maps of Encoder"/> <em><strong>Left</strong>: 12 out of 256 dimensions in the feature maps are visualized. Each dimension extracts some features of the original cat image while downsizing the original image. Some dimensions have a higher focus on the patterns on the cat; some have a higher focus on the bed sheets.</em> <em><strong>Right</strong>: Keeping the original feature dimension of size 256, the width and height are further downsized and flattened into size 850.</em><br/>
Since transformers are permutation invariant, positional embeddings are added to both the encoder and decoder to remind the model where on the image the embeddings come from. In the encoder, fixed positional encodings are used, while in the decoder, learned positional encodings (object queries) are used. Fixed encodings are similar to the ones used in the original Transformer paper, in which the encodings are defined by sinusoidal functions of varying frequencies at different feature dimensions. It gives the sense of position without having any learned parameters, indexed by the position on the image. Learned encodings are also indexed by the positions, but each position has a separate encoding that is learned throughout training to denote the positions in a way that the model understands.`,Ce,I,Ie,A,jt="In YOLO, a popular object detection model, the loss function comprises the bounding box, objectness (ie. the probability of an object existing in a region of interest), and class loss. The loss is calculated over multiple bounding boxes per each grid cell, which is a fixed number. On the other hand, in DETR, the architecture is expected to generate unique bounding boxes in a permutation-invariant manner (i.e., the order of the detections does not matter in the output, and the bounding boxes must vary and cannot all be the same). Thus, matching is required to assess how good the predictions are.",Ae,$,Tt=`<strong>Bipartite Matching</strong><br/>
Bipartite matching is a way to compute one-on-one matching between the ground truth bounding boxes and the predicted boxes. It finds matches with the highest similarity between ground truth and predicted bounding boxes, as well as classes. This ensures the closest prediction would be matched with the corresponding ground truth in order to properly adjust the boxes and classes in the loss function. If matching is not done, predictions not aligned with the order of the ground truth would be marked as incorrect even if it were correct.`,$e,Z,Ze,k,wt="To see an example of how you can perform inference with DETR using Hugging Face transformers, see <code>DETR.ipynb</code>.",ke,v,ve,x,xe,E,Jt=`Two of the main problems of DETR are a long and slow process of convergence and suboptimal small object detection.
<strong>Deformable Attention</strong><br/>
The first problem is resolved by using deformable attention, which reduces the amount of sampling points to pay attention to. Traditional attention is inefficient due to global attention and heavily limit the resolution that the image can have. The model only attends to a fixed amount of sampling points around each reference point, and the reference points are learned by the model based on the input. For example, in an image of a dog, a reference point may be in the center of the dog, with sampling points near the ears, mouth, tail, etc.`,Ee,R,Ut=`<strong>Multi-scale Deformable Attention Module</strong><br/>
The second problem is resolved similarly to YOLOv3, in which multi-scale feature maps are introduced. In convolutional neural networks, earlier layers extract smaller details (ex. lines) while later layers extract larger details (ex. wheels, ears). In a similar manner, different layers of deformable attention result in different levels of resolution. By connecting the outputs of some of these layers from the encoder to the decoder, it allows for the model to detect objects of a multitude of sizes.`,Re,W,We,B,gt=`Conditional DETR also sets out to resolve the problem of slow training convergence in the original DETR, resulting in convergence that is over 6.7 times faster. The authors found that the object queries are general and are not specific to the input image. Using <strong>Conditional Cross-Attention</strong> in the decoder, the queries can better localize the areas for bounding box regression.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR_DecoderLayer.png" alt="A decoder layer for Conditional DETR"/> <em>Left: DETR Decoder Layer. Right: Conditional DETR Decoder Layer</em><br/>
The original DETR and Conditional DETR decoder layers are compared in the figure above, with the main difference being the query input of the cross-attention block. The authors make a distinction between content query c<sub>q</sub> (decoder self attention output) and spatial query p<sub>q</sub>. The original DETR simply adds them together. In Conditional DETR, they are concatenated, with c<sub>q</sub> focusing on the content of the object and p<sub>q</sub> focusing on the bounding box regions.<br/>
The spatial query p<sub>q</sub> is the result of both the decoder embeddings and object queries projecting to the same space (to become T and p<sub>s</sub> respectively) and multiplied together. The previous layers’ decoder embeddings contain information for the bounding box regions, and the object queries contains information of learned reference points for each bounding box. Thus, their projections combine into a representation that allows for cross-attention to measure their similarities with the encoder input and sinusoidal positional embedding. This is more effective than DETR which only uses object queries and fixed reference points.`,Be,Q,Qe,N,Ct="You can infer with existing DETR models on Hugging Face Hub like below:",Ne,G,Ge,D,It="Outputs are below.",De,_,_e,V,Ve,z,At="The implementation of DETR from the original paper is shown below:",ze,Y,Ye,X,Xe,H,$t=`<strong>Backbone</strong><br/>
The input image is first put through a ResNet backbone and then a convolution layer, which reduces the dimension to the <code>hidden_dim</code>.`,He,L,Le,S,Zt="They are declared in the <code>__init__</code> function.",Se,q,qe,F,kt="<strong>Positional Embeddings</strong>",Fe,K,vt="While in the paper fixed and trained embeddings are used in the encoder and decoder respectively, the authors used trained embeddings for both in the implementation for simplicity.",Ke,P,Pe,O,xt="They are declared here as <code>nn.Parameter</code>. The row and column embeddings combined denote the locations in the image.",Oe,ee,et,te,Et=`<strong>Resize</strong><br/>
Before going into the transformer, the features with size <code>(batch size, hidden_dim, H, W)</code> are reshaped to <code>(hidden_dim, batch size, H*W)</code>. This makes them a sequential input for the transformer.`,tt,se,st,le,Rt=`<strong>Transformer</strong><br/>
The <code>nn.Transformer</code> function takes in the first parameter as the input to the encoder, and the second parameter as the input of the encoder. As you can see, the encoder takes in the resized features added to the positional embeddings, while the decoder takes in <code>query_pos</code>, which is the decoder positional embedding.`,lt,ne,nt,ae,Wt=`<strong>Feed-Forward Network</strong><br/>
In the end, the outputs, which is a tensor of size <code>(query_pos_dim, batch size, hidden_dim)</code>, is fed through two linear layers.`,at,ie,it,oe,Bt="The first of which predicts the class. An additional class is added for the <code>No Object</code> class.",ot,re,rt,Me,Qt="The second linear layer predicts the bounding box with an output size 4 for the xy coordinates, height and width.",Mt,pe,pt,ce,ct,de,Nt='<li><a href="https://arxiv.org/abs/2005.12872" rel="nofollow">DETR</a></li> <li><a href="https://arxiv.org/abs/1506.02640" rel="nofollow">YOLO</a></li> <li><a href="https://arxiv.org/abs/1804.02767" rel="nofollow">YOLOv3</a></li> <li><a href="https://arxiv.org/abs/2108.06152" rel="nofollow">Conditional DETR</a></li> <li><a href="https://arxiv.org/abs/2010.04159" rel="nofollow">Deformable DETR</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-50" rel="nofollow"><code>facebook/detr-resnet-50</code></a></li>',dt,me,mt,ue,ht;return y=new St({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new u({props:{title:"DEtection TRansformer (DETR)",local:"detection-transformer-detr",headingTag:"h1"}}),T=new u({props:{title:"Overview of architecture",local:"overview-of-architecture",headingTag:"h2"}}),U=new u({props:{title:"Key Features",local:"key-features",headingTag:"h2"}}),g=new u({props:{title:"Encoder-Decoder",local:"encoder-decoder",headingTag:"h3"}}),I=new u({props:{title:"Set-based Global Loss Function",local:"set-based-global-loss-function",headingTag:"h3"}}),Z=new u({props:{title:"Using DETR to Detect Objects",local:"using-detr-to-detect-objects",headingTag:"h2"}}),v=new u({props:{title:"Evolution of DETR",local:"evolution-of-detr",headingTag:"h2"}}),x=new u({props:{title:"Deformable DETR",local:"deformable-detr",headingTag:"h3"}}),W=new u({props:{title:"Conditional DETR",local:"conditional-detr",headingTag:"h3"}}),Q=new u({props:{title:"DETR Inference",local:"detr-inference",headingTag:"h2"}}),G=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrImageProcessor, DetrForObjectDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># initialize the model</span>
processor = DetrImageProcessor.from_pretrained(
    <span class="hljs-string">&quot;facebook/detr-resnet-101&quot;</span>, revision=<span class="hljs-string">&quot;no_timm&quot;</span>
)
model = DetrForObjectDetection.from_pretrained(
    <span class="hljs-string">&quot;facebook/detr-resnet-101&quot;</span>, revision=<span class="hljs-string">&quot;no_timm&quot;</span>
)

<span class="hljs-comment"># preprocess the inputs and infer</span>
inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)

<span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-comment"># non max supression above 0.9</span>
target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
results = processor.post_process_object_detection(
    outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.9</span>
)[<span class="hljs-number">0</span>]

<span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
    )`,wrap:!1}}),_=new f({props:{code:"RGV0ZWN0ZWQlMjBjYXQlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk4JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjM0NC4wNiUyQyUyMDI0Ljg1JTJDJTIwNjQwLjM0JTJDJTIwMzczLjc0JTVEJTBBRGV0ZWN0ZWQlMjByZW1vdGUlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk3JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjMyOC4xMyUyQyUyMDc1LjkzJTJDJTIwMzcyLjgxJTJDJTIwMTg3LjY2JTVEJTBBRGV0ZWN0ZWQlMjByZW1vdGUlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk3JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjM5LjM0JTJDJTIwNzAuMTMlMkMlMjAxNzUuNTYlMkMlMjAxMTguNzglNUQlMEFEZXRlY3RlZCUyMGNhdCUyMHdpdGglMjBjb25maWRlbmNlJTIwMC45OTglMjBhdCUyMGxvY2F0aW9uJTIwJTVCMTUuMzYlMkMlMjA1MS43NSUyQyUyMDMxNi44OSUyQyUyMDQ3MS4xNiU1RCUwQURldGVjdGVkJTIwY291Y2glMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk1JTIwYXQlMjBsb2NhdGlvbiUyMCU1Qi0wLjE5JTJDJTIwMC43MSUyQyUyMDYzOS43MyUyQyUyMDQ3NC4xNyU1RA==",highlighted:`Detected <span class="hljs-built_in">cat</span> with confidence 0.998 at location [344.06, 24.85, 640.34, 373.74]
Detected remote with confidence 0.997 at location [328.13, 75.93, 372.81, 187.66]
Detected remote with confidence 0.997 at location [39.34, 70.13, 175.56, 118.78]
Detected <span class="hljs-built_in">cat</span> with confidence 0.998 at location [15.36, 51.75, 316.89, 471.16]
Detected couch with confidence 0.995 at location [-0.19, 0.71, 639.73, 474.17]`,wrap:!1}}),V=new u({props:{title:"PyTorch Implementation of DETR",local:"pytorch-implementation-of-detr",headingTag:"h2"}}),Y=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> torchvision.models <span class="hljs-keyword">import</span> resnet50


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DETR</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self, num_classes, hidden_dim, nheads, num_encoder_layers, num_decoder_layers
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.backbone = nn.Sequential(*<span class="hljs-built_in">list</span>(resnet50(pretrained=<span class="hljs-literal">True</span>).children())[:-<span class="hljs-number">2</span>])
        self.conv = nn.Conv2d(<span class="hljs-number">2048</span>, hidden_dim, <span class="hljs-number">1</span>)
        self.transformer = nn.Transformer(
            hidden_dim, nheads, num_encoder_layers, num_decoder_layers
        )
        self.linear_class = nn.Linear(hidden_dim, num_classes + <span class="hljs-number">1</span>)
        self.linear_bbox = nn.Linear(hidden_dim, <span class="hljs-number">4</span>)
        self.query_pos = nn.Parameter(torch.rand(<span class="hljs-number">100</span>, hidden_dim))
        self.row_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))
        self.col_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, inputs</span>):
        x = self.backbone(inputs)
        h = self.conv(x)
        H, W = h.shape[-<span class="hljs-number">2</span>:]
        pos = (
            torch.cat(
                [
                    self.col_embed[:W].unsqueeze(<span class="hljs-number">0</span>).repeat(H, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
                    self.row_embed[:H].unsqueeze(<span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, W, <span class="hljs-number">1</span>),
                ],
                dim=-<span class="hljs-number">1</span>,
            )
            .flatten(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
            .unsqueeze(<span class="hljs-number">1</span>)
        )
        h = self.transformer(
            pos + h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>), self.query_pos.unsqueeze(<span class="hljs-number">1</span>)
        )
        <span class="hljs-keyword">return</span> self.linear_class(h), self.linear_bbox(h).sigmoid()`,wrap:!1}}),X=new u({props:{title:"Going line by line in the forward function:",local:"going-line-by-line-in-the-forward-function",headingTag:"h3"}}),L=new f({props:{code:"eCUyMCUzRCUyMHNlbGYuYmFja2JvbmUoaW5wdXRzKSUwQWglMjAlM0QlMjBzZWxmLmNvbnYoeCk=",highlighted:`x = self.backbone(inputs)
h = self.conv(x)`,wrap:!1}}),q=new f({props:{code:"c2VsZi5iYWNrYm9uZSUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoKmxpc3QocmVzbmV0NTAocHJldHJhaW5lZCUzRFRydWUpLmNoaWxkcmVuKCkpJTVCJTNBLTIlNUQpJTBBc2VsZi5jb252JTIwJTNEJTIwbm4uQ29udjJkKDIwNDglMkMlMjBoaWRkZW5fZGltJTJDJTIwMSk=",highlighted:`self.backbone = nn.Sequential(*<span class="hljs-built_in">list</span>(resnet50(pretrained=<span class="hljs-literal">True</span>).children())[:-<span class="hljs-number">2</span>])
self.conv = nn.Conv2d(<span class="hljs-number">2048</span>, hidden_dim, <span class="hljs-number">1</span>)`,wrap:!1}}),P=new f({props:{code:"cG9zJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHRvcmNoLmNhdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbF9lbWJlZCU1QiUzQVclNUQudW5zcXVlZXplKDApLnJlcGVhdChIJTJDJTIwMSUyQyUyMDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yb3dfZW1iZWQlNUIlM0FIJTVELnVuc3F1ZWV6ZSgxKS5yZXBlYXQoMSUyQyUyMFclMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpbSUzRC0xJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMC5mbGF0dGVuKDAlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMC51bnNxdWVlemUoMSklMEEp",highlighted:`pos = (
    torch.cat(
        [
            self.col_embed[:W].unsqueeze(<span class="hljs-number">0</span>).repeat(H, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
            self.row_embed[:H].unsqueeze(<span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, W, <span class="hljs-number">1</span>),
        ],
        dim=-<span class="hljs-number">1</span>,
    )
    .flatten(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    .unsqueeze(<span class="hljs-number">1</span>)
)`,wrap:!1}}),ee=new f({props:{code:"c2VsZi5yb3dfZW1iZWQlMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZCg1MCUyQyUyMGhpZGRlbl9kaW0lMjAlMkYlMkYlMjAyKSklMEFzZWxmLmNvbF9lbWJlZCUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKDUwJTJDJTIwaGlkZGVuX2RpbSUyMCUyRiUyRiUyMDIpKQ==",highlighted:`self.row_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))
self.col_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))`,wrap:!1}}),se=new f({props:{code:"aC5mbGF0dGVuKDIpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKQ==",highlighted:'h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)',wrap:!1}}),ne=new f({props:{code:"aCUyMCUzRCUyMHNlbGYudHJhbnNmb3JtZXIocG9zJTIwJTJCJTIwaC5mbGF0dGVuKDIpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKSUyQyUyMHNlbGYucXVlcnlfcG9zLnVuc3F1ZWV6ZSgxKSk=",highlighted:'h = self.transformer(pos + h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>), self.query_pos.unsqueeze(<span class="hljs-number">1</span>))',wrap:!1}}),ie=new f({props:{code:"cmV0dXJuJTIwc2VsZi5saW5lYXJfY2xhc3MoaCklMkMlMjBzZWxmLmxpbmVhcl9iYm94KGgpLnNpZ21vaWQoKQ==",highlighted:'<span class="hljs-keyword">return</span> self.linear_class(h), self.linear_bbox(h).sigmoid()',wrap:!1}}),re=new f({props:{code:"c2VsZi5saW5lYXJfY2xhc3MlMjAlM0QlMjBubi5MaW5lYXIoaGlkZGVuX2RpbSUyQyUyMG51bV9jbGFzc2VzJTIwJTJCJTIwMSk=",highlighted:'self.linear_class = nn.Linear(hidden_dim, num_classes + <span class="hljs-number">1</span>)',wrap:!1}}),pe=new f({props:{code:"c2VsZi5saW5lYXJfYmJveCUyMCUzRCUyMG5uLkxpbmVhcihoaWRkZW5fZGltJTJDJTIwNCk=",highlighted:'self.linear_bbox = nn.Linear(hidden_dim, <span class="hljs-number">4</span>)',wrap:!1}}),ce=new u({props:{title:"References",local:"references",headingTag:"h2"}}),me=new qt({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit3/vision-transformers/detr.mdx"}}),{c(){b=d("meta"),fe=n(),he=d("p"),be=n(),i(y.$$.fragment),ye=n(),i(j.$$.fragment),je=n(),i(T.$$.fragment),Te=n(),w=d("p"),w.innerHTML=ft,we=n(),J=d("p"),J.innerHTML=bt,Je=n(),i(U.$$.fragment),Ue=n(),i(g.$$.fragment),ge=n(),C=d("p"),C.innerHTML=yt,Ce=n(),i(I.$$.fragment),Ie=n(),A=d("p"),A.textContent=jt,Ae=n(),$=d("p"),$.innerHTML=Tt,$e=n(),i(Z.$$.fragment),Ze=n(),k=d("p"),k.innerHTML=wt,ke=n(),i(v.$$.fragment),ve=n(),i(x.$$.fragment),xe=n(),E=d("p"),E.innerHTML=Jt,Ee=n(),R=d("p"),R.innerHTML=Ut,Re=n(),i(W.$$.fragment),We=n(),B=d("p"),B.innerHTML=gt,Be=n(),i(Q.$$.fragment),Qe=n(),N=d("p"),N.textContent=Ct,Ne=n(),i(G.$$.fragment),Ge=n(),D=d("p"),D.textContent=It,De=n(),i(_.$$.fragment),_e=n(),i(V.$$.fragment),Ve=n(),z=d("p"),z.textContent=At,ze=n(),i(Y.$$.fragment),Ye=n(),i(X.$$.fragment),Xe=n(),H=d("p"),H.innerHTML=$t,He=n(),i(L.$$.fragment),Le=n(),S=d("p"),S.innerHTML=Zt,Se=n(),i(q.$$.fragment),qe=n(),F=d("p"),F.innerHTML=kt,Fe=n(),K=d("p"),K.textContent=vt,Ke=n(),i(P.$$.fragment),Pe=n(),O=d("p"),O.innerHTML=xt,Oe=n(),i(ee.$$.fragment),et=n(),te=d("p"),te.innerHTML=Et,tt=n(),i(se.$$.fragment),st=n(),le=d("p"),le.innerHTML=Rt,lt=n(),i(ne.$$.fragment),nt=n(),ae=d("p"),ae.innerHTML=Wt,at=n(),i(ie.$$.fragment),it=n(),oe=d("p"),oe.innerHTML=Bt,ot=n(),i(re.$$.fragment),rt=n(),Me=d("p"),Me.textContent=Qt,Mt=n(),i(pe.$$.fragment),pt=n(),i(ce.$$.fragment),ct=n(),de=d("ul"),de.innerHTML=Nt,dt=n(),i(me.$$.fragment),mt=n(),ue=d("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);b=m(t,"META",{name:!0,content:!0}),t.forEach(s),fe=a(e),he=m(e,"P",{}),Gt(he).forEach(s),be=a(e),o(y.$$.fragment,e),ye=a(e),o(j.$$.fragment,e),je=a(e),o(T.$$.fragment,e),Te=a(e),w=m(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1uea2cx"&&(w.innerHTML=ft),we=a(e),J=m(e,"P",{"data-svelte-h":!0}),h(J)!=="svelte-1mj736s"&&(J.innerHTML=bt),Je=a(e),o(U.$$.fragment,e),Ue=a(e),o(g.$$.fragment,e),ge=a(e),C=m(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-t8og7r"&&(C.innerHTML=yt),Ce=a(e),o(I.$$.fragment,e),Ie=a(e),A=m(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-12feezj"&&(A.textContent=jt),Ae=a(e),$=m(e,"P",{"data-svelte-h":!0}),h($)!=="svelte-1obgrh7"&&($.innerHTML=Tt),$e=a(e),o(Z.$$.fragment,e),Ze=a(e),k=m(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-f2wazx"&&(k.innerHTML=wt),ke=a(e),o(v.$$.fragment,e),ve=a(e),o(x.$$.fragment,e),xe=a(e),E=m(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-w2zzks"&&(E.innerHTML=Jt),Ee=a(e),R=m(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-vzcbkx"&&(R.innerHTML=Ut),Re=a(e),o(W.$$.fragment,e),We=a(e),B=m(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-nmnqe1"&&(B.innerHTML=gt),Be=a(e),o(Q.$$.fragment,e),Qe=a(e),N=m(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-fvf0lp"&&(N.textContent=Ct),Ne=a(e),o(G.$$.fragment,e),Ge=a(e),D=m(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-r4sesn"&&(D.textContent=It),De=a(e),o(_.$$.fragment,e),_e=a(e),o(V.$$.fragment,e),Ve=a(e),z=m(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-d0cg5t"&&(z.textContent=At),ze=a(e),o(Y.$$.fragment,e),Ye=a(e),o(X.$$.fragment,e),Xe=a(e),H=m(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-13sutp8"&&(H.innerHTML=$t),He=a(e),o(L.$$.fragment,e),Le=a(e),S=m(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-f638vd"&&(S.innerHTML=Zt),Se=a(e),o(q.$$.fragment,e),qe=a(e),F=m(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1afjwf9"&&(F.innerHTML=kt),Fe=a(e),K=m(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-1e5n46h"&&(K.textContent=vt),Ke=a(e),o(P.$$.fragment,e),Pe=a(e),O=m(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-xpw6n2"&&(O.innerHTML=xt),Oe=a(e),o(ee.$$.fragment,e),et=a(e),te=m(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-1mhfud0"&&(te.innerHTML=Et),tt=a(e),o(se.$$.fragment,e),st=a(e),le=m(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-b0wrkd"&&(le.innerHTML=Rt),lt=a(e),o(ne.$$.fragment,e),nt=a(e),ae=m(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-bczn5d"&&(ae.innerHTML=Wt),at=a(e),o(ie.$$.fragment,e),it=a(e),oe=m(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-1wmk5h5"&&(oe.innerHTML=Bt),ot=a(e),o(re.$$.fragment,e),rt=a(e),Me=m(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-yoo56g"&&(Me.textContent=Qt),Mt=a(e),o(pe.$$.fragment,e),pt=a(e),o(ce.$$.fragment,e),ct=a(e),de=m(e,"UL",{"data-svelte-h":!0}),h(de)!=="svelte-1ie7nnc"&&(de.innerHTML=Nt),dt=a(e),o(me.$$.fragment,e),mt=a(e),ue=m(e,"P",{}),Gt(ue).forEach(s),this.h()},h(){Dt(b,"name","hf:doc:metadata"),Dt(b,"content",Kt)},m(e,t){Lt(document.head,b),l(e,fe,t),l(e,he,t),l(e,be,t),r(y,e,t),l(e,ye,t),r(j,e,t),l(e,je,t),r(T,e,t),l(e,Te,t),l(e,w,t),l(e,we,t),l(e,J,t),l(e,Je,t),r(U,e,t),l(e,Ue,t),r(g,e,t),l(e,ge,t),l(e,C,t),l(e,Ce,t),r(I,e,t),l(e,Ie,t),l(e,A,t),l(e,Ae,t),l(e,$,t),l(e,$e,t),r(Z,e,t),l(e,Ze,t),l(e,k,t),l(e,ke,t),r(v,e,t),l(e,ve,t),r(x,e,t),l(e,xe,t),l(e,E,t),l(e,Ee,t),l(e,R,t),l(e,Re,t),r(W,e,t),l(e,We,t),l(e,B,t),l(e,Be,t),r(Q,e,t),l(e,Qe,t),l(e,N,t),l(e,Ne,t),r(G,e,t),l(e,Ge,t),l(e,D,t),l(e,De,t),r(_,e,t),l(e,_e,t),r(V,e,t),l(e,Ve,t),l(e,z,t),l(e,ze,t),r(Y,e,t),l(e,Ye,t),r(X,e,t),l(e,Xe,t),l(e,H,t),l(e,He,t),r(L,e,t),l(e,Le,t),l(e,S,t),l(e,Se,t),r(q,e,t),l(e,qe,t),l(e,F,t),l(e,Fe,t),l(e,K,t),l(e,Ke,t),r(P,e,t),l(e,Pe,t),l(e,O,t),l(e,Oe,t),r(ee,e,t),l(e,et,t),l(e,te,t),l(e,tt,t),r(se,e,t),l(e,st,t),l(e,le,t),l(e,lt,t),r(ne,e,t),l(e,nt,t),l(e,ae,t),l(e,at,t),r(ie,e,t),l(e,it,t),l(e,oe,t),l(e,ot,t),r(re,e,t),l(e,rt,t),l(e,Me,t),l(e,Mt,t),r(pe,e,t),l(e,pt,t),r(ce,e,t),l(e,ct,t),l(e,de,t),l(e,dt,t),r(me,e,t),l(e,mt,t),l(e,ue,t),ht=!0},p:Vt,i(e){ht||(M(y.$$.fragment,e),M(j.$$.fragment,e),M(T.$$.fragment,e),M(U.$$.fragment,e),M(g.$$.fragment,e),M(I.$$.fragment,e),M(Z.$$.fragment,e),M(v.$$.fragment,e),M(x.$$.fragment,e),M(W.$$.fragment,e),M(Q.$$.fragment,e),M(G.$$.fragment,e),M(_.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(X.$$.fragment,e),M(L.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(pe.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),ht=!0)},o(e){p(y.$$.fragment,e),p(j.$$.fragment,e),p(T.$$.fragment,e),p(U.$$.fragment,e),p(g.$$.fragment,e),p(I.$$.fragment,e),p(Z.$$.fragment,e),p(v.$$.fragment,e),p(x.$$.fragment,e),p(W.$$.fragment,e),p(Q.$$.fragment,e),p(G.$$.fragment,e),p(_.$$.fragment,e),p(V.$$.fragment,e),p(Y.$$.fragment,e),p(X.$$.fragment,e),p(L.$$.fragment,e),p(q.$$.fragment,e),p(P.$$.fragment,e),p(ee.$$.fragment,e),p(se.$$.fragment,e),p(ne.$$.fragment,e),p(ie.$$.fragment,e),p(re.$$.fragment,e),p(pe.$$.fragment,e),p(ce.$$.fragment,e),p(me.$$.fragment,e),ht=!1},d(e){e&&(s(fe),s(he),s(be),s(ye),s(je),s(Te),s(w),s(we),s(J),s(Je),s(Ue),s(ge),s(C),s(Ce),s(Ie),s(A),s(Ae),s($),s($e),s(Ze),s(k),s(ke),s(ve),s(xe),s(E),s(Ee),s(R),s(Re),s(We),s(B),s(Be),s(Qe),s(N),s(Ne),s(Ge),s(D),s(De),s(_e),s(Ve),s(z),s(ze),s(Ye),s(Xe),s(H),s(He),s(Le),s(S),s(Se),s(qe),s(F),s(Fe),s(K),s(Ke),s(Pe),s(O),s(Oe),s(et),s(te),s(tt),s(st),s(le),s(lt),s(nt),s(ae),s(at),s(it),s(oe),s(ot),s(rt),s(Me),s(Mt),s(pt),s(ct),s(de),s(dt),s(mt),s(ue)),s(b),c(y,e),c(j,e),c(T,e),c(U,e),c(g,e),c(I,e),c(Z,e),c(v,e),c(x,e),c(W,e),c(Q,e),c(G,e),c(_,e),c(V,e),c(Y,e),c(X,e),c(L,e),c(q,e),c(P,e),c(ee,e),c(se,e),c(ne,e),c(ie,e),c(re,e),c(pe,e),c(ce,e),c(me,e)}}}const Kt='{"title":"DEtection TRansformer (DETR)","local":"detection-transformer-detr","sections":[{"title":"Overview of architecture","local":"overview-of-architecture","sections":[],"depth":2},{"title":"Key Features","local":"key-features","sections":[{"title":"Encoder-Decoder","local":"encoder-decoder","sections":[],"depth":3},{"title":"Set-based Global Loss Function","local":"set-based-global-loss-function","sections":[],"depth":3}],"depth":2},{"title":"Using DETR to Detect Objects","local":"using-detr-to-detect-objects","sections":[],"depth":2},{"title":"Evolution of DETR","local":"evolution-of-detr","sections":[{"title":"Deformable DETR","local":"deformable-detr","sections":[],"depth":3},{"title":"Conditional DETR","local":"conditional-detr","sections":[],"depth":3}],"depth":2},{"title":"DETR Inference","local":"detr-inference","sections":[],"depth":2},{"title":"PyTorch Implementation of DETR","local":"pytorch-implementation-of-detr","sections":[{"title":"Going line by line in the forward function:","local":"going-line-by-line-in-the-forward-function","sections":[],"depth":3}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Pt(ut){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Yt{constructor(b){super(),Xt(this,b,Pt,Ft,_t,{})}}export{ns as component};
